<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
//LOG
require_once 'log/insertLog.php';
//LIBRERIA DE EXPORTACION
require_once 'libreria/Spout/Autoloader/autoload.php';

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;
    date_default_timezone_set('America/Lima');
    //Funciones para codificar al momento de grabar en Mysql
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }
    //LIBRERIA DE EXPORTACION
    $lblfvisitainicial=$_GET['lblfvisitainicial'];
    $lblfvisitafinal=$_GET['lblfvisitafinal'];
    $lblperfil=$_GET['lblperfil'];
 
    $fechaconvertfvisitainicial=  myUrlEncode($lblfvisitainicial);
    $fechagrabarfvisitainicial=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertfvisitainicial));
    $fechaconvertfvisitafinal=  myUrlEncode($lblfvisitafinal);
    $fechagrabarfvisitafinal=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertfvisitafinal));

$fileName = 'VisitasRE.csv';

$writer = WriterEntityFactory::createCSVWriter();

$writer->openToBrowser($fileName);

$head = array('IdVenta','IdUsuario',
'IdCliente',
'Matricula',
'Comercial',
'CC',
'JefeVenta',
'CategoriaVenta',
'TipoVenta',
'Segmento',
'NProspecto',
'NContrato',
'PrecioKit',
'TotalExtra',
'IngresoKIT',
'IngresoExtras',
'IngresoTotal',
'EstadoVenta',
'ExtraAutorizado',
'MesesAutorizado',
'N590',
'FormaPago',
'PAI',
'ResumenVenta',
'FechaHoraREG',
'EstadoVisita',
'FechaVisita',
'HoraVisita',
'MesVisita',
'FVencimientoVisita',
'GestorMKT',
'OrigenVisita',
'ComentarioVisita',
'GestorOrigen',
'IdGeografico',
'NombApellido',
'Telefonouno',
'Telefonodos',
'Correo',
'Direccion',
'Distrito',
'Provincia',
'CCOriginal',
'EstadoTelecierre',
'TCGestor',
'TCMotivoNoVenta',
'TCTipoVenta',
'Checkin',
'LeadID',
'FechaHoraInst',
'TipoDocumento',
'Documento',
'Accion',
'PerfilScoring',
'IdConsultaScoring',
'DistritalScoring',
'ProvincialScoring',
'DepartamentalScoring',
'MatriculaScoring',
'Score',
'PredictorIngresos_IP',
'CantidadDocumentosMorosos',
'FechaHoraConsulta',
'Zona',
'Seccion'
);
$rowFromValues = WriterEntityFactory::createRowFromArray($head);
$writer->addRow($rowFromValues);

date_default_timezone_set('America/Lima');

$fecharegistro=date("Y-m-d H:i:s");

$result_exec = StmtInsertarLogSeguridad_General('Exportar', $fecharegistro, '', '');


$query="SELECT 
v.IdVenta,
v.IdUsuario,
v.IdCliente,
v.Matricula,
v.Comercial,
v.CC,
v.JefeVenta,
v.CategoriaVenta,
v.TipoVenta,
v.Segmento,
v.NProspecto,
v.NContrato,
v.PrecioKit,
v.TotalExtra,
v.IngresoKIT,
v.IngresoExtras,
v.IngresoTotal,
v.EstadoVenta,
v.ExtraAutorizado,
v.MesesAutorizado,
v.N590,
v.FormaPago,
v.PAI,
v.ResumenVenta,
v.FechaHoraREG,
v.EstadoVisita,
v.FechaVisita,
v.HoraVisita,
v.MesVisita,
v.FVencimientoVisita,
v.GestorMKT,
v.OrigenVisita,
v.ComentarioVisita,
v.GestorOrigen,
c.IdGeografico,
c.NombApellido,
c.Telefonouno,
c.Telefonodos,
c.Correo,
c.Direccion,
g.Distrito,
g.Provincia,
v.CCOriginal,
v.EstadoTelecierre,
v.TCGestor,
v.TCMotivoNoVenta,
v.TCTipoVenta,
v.Checkin,
v.LeadID,
concat(a.FechaInst, ' ', a.HoraInst) FechaHoraInst,
d.TipoDocumento,
d.Documento,
v.Accion,
v.PerfilScoring,
v.IdConsultaScoring,
s.Distrital as DistritalScoring,
s.Provincial as ProvincialScoring,
s.Departamental as DepartamentalScoring,
s.GestorOrigen as MatriculaScoring,
s.Score,
s.PredictorIngresos_IP,
s.CantidadDocumentosMorosos,
s.FechaHoraReg as FechaHoraConsulta,
c.objGeofinder
FROM dbVENTAS.tblventa v INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
INNER JOIN dbVENTAS.tblagenda a ON a.IdVenta=v.IdVenta 
INNER JOIN dbVENTAS.tblgeografico g ON g.IdGeografico=c.IdGeografico
LEFT JOIN dbVENTAS.tbldocumento d ON c.IdDocVisita = d.IdDoc
LEFT JOIN dbVENTAS.tbltmpscoring s ON s.IdConsultaScoring=v.IdConsultaScoring    
WHERE v.TipoVenta='RE'
and v.FechaVisita BETWEEN '".$fechagrabarfvisitainicial."' AND '".$fechagrabarfvisitafinal."'
";
/*ID(23466) desde 2019-04 hacia adelante*/
/*ID(29636) desde 2019-06 hacia adelante*/

$result = $con->query($query);
//Contador para reccorer cada fila del resultado.
$i=0;

while ($Venta = $result->fetch_assoc()){

    $arreglo[] = $Venta;
    
    $objGeofinder = json_decode($Venta['objGeofinder'], true);
    
    $zonas = $objGeofinder['zonas'];
    //ZONA
    $zona = $zonas[0]['valor'];
    //MICROZONA
    $microzona=$zonas[1]['valor'];
    
    $arreglo[$i]['zona'] = $zona;
    $arreglo[$i]['microzona'] = $microzona;
    
    unset($arreglo[$i]['objGeofinder']);
    
    $i++;

}

for($i=0; $i<count($arreglo); $i++){
    $rowData = WriterEntityFactory::createRowFromArray($arreglo[$i]);
    $writer->addRow($rowData);
}

$result->close();

$writer->close();

$con->close();

?>
