<?php
    include('is_logged.php');
    require_once '../config/db.php';
    require_once '../config/conexion.php';
    //LOG
    require_once 'log/insertLog.php';
    date_default_timezone_set('America/Lima');
    //Funciones para codificar al momento de grabar en Mysql
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }
    
    require_once 'libreria/Spout/Autoloader/autoload.php';
    
    use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
    use Box\Spout\Common\Entity\Row;
    
    $fileName = 'DireccionesGeo.csv';
    
    $writer = WriterEntityFactory::createCSVWriter();
    
    $writer->openToBrowser($fileName);
    
    $head = array(
        'IdVenta',
        'IdCliente',
        'NProspecto',
        'Telefonouno',
        'FechaHoraREG',
        'GestorOrigen',
        'Direccion',
        'Distrito',
        'Provincia',
        'DireccionAproxBO',
        'DireccionAproxCC',
        'TipoDireccionCC',
        'TipoDireccionBO',
        'GestorMKT',
        'Gestor',
        'Referencia',
        'ComentarioVisita',
        'objGeofinder',
        'objZonificacion',
        'Checkin',
        'Distancia',
        'Zona',
        'Microzona',
        'CodDelegacionAsignada',
        'DelegacionAsignada',
        'DelegadoAsignado',
        'Matricula',
        'Comercial',
        'CC',
        'JefeVenta'
    );
    
    $rowFromValues = WriterEntityFactory::createRowFromArray($head);
    $writer->addRow($rowFromValues);
    
    $query = "SELECT DISTINCT 
                    v.IdVenta,
                    c.IdCliente, 
                    v.NProspecto, 
                    c.Telefonouno, 
                    v.FechaHoraREG, 
                    v.GestorOrigen, 
                    c.Direccion, 
                    g.Distrito, 
                    g.Provincia, 
                    c.DireccionAprox 'DireccionAproxBO',
                    d.Direccion 'DireccionAproxCC', 
                    d.TipoDireccion 'TipoDireccionCC', 
                    c.TipoDireccion 'TipoDireccionBO' , 
                    v.GestorMKT, 
                    d.Gestor, 
                    c.Referencia, 
                    v.ComentarioVisita, 
                    c.objGeofinder, 
                    c.objZonificacion,
                    v.Checkin,
                    v.InfoCheckIn,
                    v.Matricula,
                    v.Comercial,
                    v.CC,
                    v.JefeVenta
                FROM tblventa v
                INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
                INNER JOIN tblgeografico g ON c.IdGeografico = g.IdGeografico
                LEFT JOIN tbltmpdirecciones d ON c.Telefonouno = d.Telefono
                WHERE v.IdVenta >= 85607 AND v.TipoVenta='RE' AND v.CCOriginal NOT IN (512, 511)
                ORDER BY v.FechaHoraREG
                ";
                
    $result = $con->query($query);
    
    
    
    while ($Venta = $result->fetch_assoc()){
        
        $InfoCheckIn = json_decode($Venta['InfoCheckIn'], true);
        
        $Distancia = $InfoCheckIn['Distancia'];
        
        $objZonificacion = json_decode($Venta['objZonificacion'], true);
        
        $Zona = $objZonificacion['Zona']; 
        $Microzona = $objZonificacion['Microzona'];
        $CodDelegacionAsignada =$objZonificacion['CodigoDelegacion'];
        $DelegacionAsignada =$objZonificacion['NombreDelegacion'];
        $DelegadoAsignado =$objZonificacion['Delegado'];
        
        $arreglo = array(
                'IdVenta' => $Venta['IdVenta'],
                'IdCliente' => $Venta['IdCliente'],
                'NProspecto' => $Venta['NProspecto'],
                'Telefonouno' => $Venta['Telefonouno'],
                'FechaHoraREG' => $Venta['FechaHoraREG'],
                'GestorOrigen' => $Venta['GestorOrigen'],
                'Direccion' => $Venta['Direccion'],
                'Distrito' => $Venta['Distrito'],
                'Provincia' => $Venta['Provincia'],
                'DireccionAproxBO' => $Venta['DireccionAproxBO'],
                'DireccionAproxCC' => $Venta['DireccionAproxCC'],
                'TipoDireccionCC' => $Venta['TipoDireccionCC'],
                'TipoDireccionBO' => $Venta['TipoDireccionBO'],
                'GestorMKT' => $Venta['GestorMKT'],
                'Gestor' => $Venta['Gestor'],
                'Referencia' => $Venta['Referencia'],
                'ComentarioVisita' => $Venta['ComentarioVisita'],
                'objGeofinder' => $Venta['objGeofinder'],
                'objZonificacion' => $Venta['objZonificacion'],
                'Checkin' => $Venta['Checkin'],
                'Distancia' => $Distancia,
                'Zona' => $Zona,
                'Microzona' => $Microzona,
                'CodDelegacionAsignada' => $CodDelegacionAsignada,
                'DelegacionAsignada' => $DelegacionAsignada,
                'DelegadoAsignado' => $DelegadoAsignado,
                'Matricula'=> $Venta['Matricula'],
                'Comercial'=> $Venta['Comercial'],
                'CC'=> $Venta['CC'],
                'JefeVenta'=> $Venta['JefeVenta']
            );    
        
      $rowData = WriterEntityFactory::createRowFromArray($arreglo);
      $writer->addRow($rowData);
    }
    
    $result->close();
    
    $writer->close();
    
    
    $con->close();
    
    

?>