<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

$ingresokit=0;
$ingresoextras=0;
$ingresototal=0;

require '../config/db.php';
require '../config/conexion.php';
include '../helper/helper_validacion.php';
//FUNCIONES LOG
include 'log/insertLog.php'; //LOG TRANSAC
include 'log/insertLogCliente.php'; //LOG CLIENTE
include 'log/insertLogVenta.php'; //LOG VENTA
include 'log/insertLogAgenda.php'; //LOG AGENDA
//AGREGADO 31.05.2021
include 'log/insertLogAgendaVenta.php';

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';

$gestor = sanitizaCampo($_POST['gestor'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$gestor = htmlspecialchars($gestor);

$estvisita = sanitizaCampo($_POST['lblestvisita'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$estvisita = htmlspecialchars($estvisita);

$estadoventa = sanitizaCampo($_POST['lblestventa'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$estadoventa = htmlspecialchars($estadoventa);

$tipoventa = sanitizaCampo($_POST['lbltiventa'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$tipoventa = htmlspecialchars($tipoventa);

$categoria = sanitizaCampo($_POST['lblcategoria'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$categoria = htmlspecialchars($categoria);

$validarfechainst="";
$fechmod=date("Y-m-d H:i:s");

$idagenda = sanitizaCampo($_POST['lblidagenda'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$idagenda = htmlspecialchars($idagenda);

    $mesesautorizados = sanitizaCampo($_POST['lblmesesautorizados'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $mesesautorizados = htmlspecialchars($mesesautorizados);

    $preciokit = sanitizaCampo($_POST['lblpreciokit'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $preciokit = htmlspecialchars($preciokit);
    
    $totalextra = sanitizaCampo($_POST['lbltotalextra'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $totalextra = htmlspecialchars($totalextra);
    

    $extraautorizado = sanitizaCampo($_POST['lblextraautorizado'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $extraautorizado = htmlspecialchars($extraautorizado);
    
    $formadepago = sanitizaCampo($_POST['lblformadepago'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $formadepago = htmlspecialchars($formadepago);

    $n590 = sanitizaCampo($_POST['lbl590'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $n590 = htmlspecialchars($n590);
    
    $PAI = sanitizaCampo($_POST['lblPAI'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $PAI = htmlspecialchars($PAI);
    
    $resumenventa = sanitizaCampo($_POST['lblresumenventa'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $resumenventa = htmlspecialchars($resumenventa);
    
    $idventa = sanitizaCampo($_POST['lblidventa'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $idventa = htmlspecialchars($idventa);
    
    $cancelado=NULL;
    $repercucion=NULL;
    $costo=NULL;
    //$ncontrato=NULL;

    $ncontrato = sanitizaCampo($_POST['lblncontrato'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $ncontrato = htmlspecialchars($ncontrato);

    //$movivonoventa=$_POST['lblmovivonoventa'];
    //$competencia=$_POST['lblcompetencia'];
    
    $movivonoventa=NULL;
    $competencia=NULL;

    //Agenda
    $finstalacion = sanitizaCampo($_POST['lblfinstalacion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $finstalacion = htmlspecialchars($finstalacion);
    
    $hinstalacion = sanitizaCampo($_POST['lblhinstalacion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $hinstalacion = htmlspecialchars($hinstalacion);
    
    $fechaconvert=  myUrlEncode($finstalacion);
    $fechagrabar=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvert));
    $horaconvert=  myUrlEncode($hinstalacion);
    $horagrabar=  date("H:i", strtotime(str_replace("+"," ",$horaconvert)));
    $horagrabarcomparar=  date("H:i:s", strtotime(str_replace("+"," ",$horaconvert)));
    
    $instaladox = sanitizaCampo($_POST['lblinstaladox'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $instaladox = htmlspecialchars($instaladox);
    
    $tecnico = sanitizaCampo($_POST['lbltecnico'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $tecnico = htmlspecialchars($tecnico);
    
    $comentarioagenda = sanitizaCampo($_POST['lblcomentarioagenda'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $comentarioagenda = htmlspecialchars($comentarioagenda);
    
    $fecharegistroagenda = date("Y-m-d H:i:s");
    $fecharegistrofacturacion = date("Y-m-d H:i:s");
    $fecharegistroventa = date("Y-m-d H:i:s");
    
    $inviable = sanitizaCampo(utf8_decode($_POST['lblinviable']), 'sanitizestring|scapestring|htmlspecialchars',$con);
    $inviable = htmlspecialchars($inviable);

    if($PAI=="PAI 30x36"){
    
    $ingresokit=round((($preciokit+1080)/1.18),2);
    $ingresoextras=round(($totalextra/1.18),2);
    $ingresototal=($ingresokit+$ingresoextras);
    
    }
    else{
    
    $ingresokit=round((($preciokit)/1.18),2);
    $ingresoextras=round(($totalextra/1.18),2);
    $ingresototal=($ingresokit+$ingresoextras);
    }

    //POST NUEVOS
    $matricula = sanitizaCampo($_POST['lblmatricula'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $matricula = htmlspecialchars($matricula);
    // $dc=$_POST['lbldc'];
    // $jefeventa=$_POST['lbljefeventa'];
    
    $hidden_HCertificacion = sanitizaCampo($_POST['hidden_HCertificacion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $hidden_HCertificacion = htmlspecialchars($hidden_HCertificacion);
    
    //INFORMACION ADICIONAL DE LA VENTA AGREGADA POR PILOTO ZEROVISION
    $lbltipokit = sanitizaCampo($_POST['lbltipokit'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $lbltipokit = htmlspecialchars($lbltipokit);
    
    $lblclosingpack = sanitizaCampo($_POST['lblclosingpack'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $lblclosingpack = htmlspecialchars($lblclosingpack);
    
    $lblprecioEspecial = sanitizaCampo($_POST['lblprecioEspecial'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $lblprecioEspecial = htmlspecialchars($lblprecioEspecial);
    
    $lblCantExtras = sanitizaCampo($_POST['lblCantExtras'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $lblCantExtras = htmlspecialchars($lblCantExtras);

    $lblresultadoScoring = sanitizaCampo($_POST['lblresultadoScoring'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $lblresultadoScoring = htmlspecialchars($lblresultadoScoring);
    
    //NUEVAS DATOS PARA LA INFORMACION DE LA VENTA PILOTO NUEVO CARRITO DE COMPRA KIT, EXTRA Y REGALO (26.10.2021)
    if(isset($_POST['lblcategoriaprecio'])){

        $lblcategoriaprecio = sanitizaCampo($_POST['lblcategoriaprecio'], 'sanitizestring|scapestring|htmlspecialchars',$con);
        $lblcategoriaprecio = htmlspecialchars($lblcategoriaprecio);
    } else {
        $lblcategoriaprecio = null;
    }
    //NUEVOS

     $hidGGCC = sanitizaCampo($_POST['hidGGCC'], 'sanitizestring|scapestring|htmlspecialchars',$con);
     $hidGGCC = htmlspecialchars($hidGGCC);
    
     $IdDocRP = sanitizaCampo($_POST['IdDocRP'], 'sanitizeint|scapestring|htmlspecialchars',$con);
     $IdDocRP = htmlspecialchars($IdDocRP);
     
     $idcliente = sanitizaCampo($_POST['lblidcliente'], 'sanitizeint|scapestring|htmlspecialchars',$con);
     $idcliente = htmlspecialchars($idcliente);
     
     //NUEVOS DATOS PARA EL DETALLE EXTRAS Y REGALOS
     if(isset($_POST['lblCantRegalos'])){
        $lblCantRegalos = sanitizaCampo($_POST['lblCantRegalos'], 'sanitizeint|scapestring|htmlspecialchars',$con);
        $lblCantRegalos = htmlspecialchars($lblCantRegalos);
     } else {
         $lblCantRegalos = null;
     }
     
     if(isset($_POST['lbltotalcuota'])){
        $lbltotalcuota = sanitizaCampo($_POST['lbltotalcuota'], 'sanitizefloat|scapestring|htmlspecialchars',$con);
        $lbltotalcuota = htmlspecialchars($lbltotalcuota);
     }else {
         $lbltotalcuota = null;
     }
     if(isset($_POST['lblDescuentoCuota'])){
        $lblDescuentoCuota = sanitizaCampo($_POST['lblDescuentoCuota'], 'sanitizestring|scapestring|htmlspecialchars',$con);
        $lblDescuentoCuota = htmlspecialchars($lblDescuentoCuota);
     } else {
         $lblDescuentoCuota = null;
     }

    if(isset($_POST['lbltipocamarakit'])){
        if($_POST['lbltipocamarakit']=='' || empty($_POST['lbltipocamarakit'])){
            $lbltipocamarakit=NULL;
        } else{
            $lbltipocamarakit = sanitizaCampo($_POST['lbltipocamarakit'], 'sanitizestring|scapestring|htmlspecialchars',$con);
            $lbltipocamarakit = htmlspecialchars($lbltipocamarakit);
        }
    } else {
        $lbltipocamarakit=NULL;
    }

    if(isset($_POST['lblRenove'])){
        if($_POST['lblRenove']=='' || empty($_POST['lblRenove'])){
            $lblRenove=NULL;
        } else{
            $lblRenove=htmlspecialchars($_POST['lblRenove']);
        }
    } else {
        $lblRenove=NULL;
    }
    
    if(isset($_POST['lblRcompetencia'])){
        if($_POST['lblRcompetencia']=='' || empty($_POST['lblRcompetencia'])){
            $lblRcompetencia=NULL;
        } else{
            $lblRcompetencia=htmlspecialchars($_POST['lblRcompetencia']);
        }
    } else {
        $lblRcompetencia=NULL;
    }
    
    if(isset($_POST['lblRvencimiento'])){
        if($_POST['lblRvencimiento']=='' || empty($_POST['lblRvencimiento'])){
            $lblRvencimiento=NULL;
        } else{
            $lblRvencimiento=htmlspecialchars($_POST['lblRvencimiento']);
        }
    } else {
        $lblRvencimiento=NULL;
    }


 //INTERACCIONES DE AUDITORIA
 
$lblIteraccionAttec = sanitizaCampo($_POST['lblIteraccionAttec'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$lblIteraccionAttec = htmlspecialchars($lblIteraccionAttec);
    
    //AGREGADO 31.05.2021 VALIDACION DE CONTRATO
    if($estadoventa=="InstaladaDEL"){
      $resultadoAgendaVenta = consultaAgendaVenta($idventa);
        if(isset($ncontrato) && $ncontrato <> $resultadoAgendaVenta['NContrato']){
           if(validarNContrato($ncontrato) > 0){
                die('2');
            }else{
                $sqlventa=$con->prepare("UPDATE dbVENTAS.tblventa v SET v.EstadoVenta=?,v.NContrato=? WHERE v.IdVenta=? "); //ACTUALIZA DATOS EN LA TABLA VENTA
                $sqlventa->bind_param('ssi',$estadoventa,$ncontrato,$idventa);
                $sqlventa->execute();
                
                $sqlclientecontrato=$con->prepare("UPDATE dbVENTAS.tblcliente c SET c.NCliente=? WHERE c.IdCliente=? "); //ACTUALIZA NCLIENTE O NCONTRATO EN TBLCLIENTE
                $sqlclientecontrato->bind_param('si',$ncontrato,$idcliente);
                $sqlclientecontrato->execute();
                
                $ultimaestado=UltimoEstadoVenta($idventa);
                if($ultimaestado=="Cancelada" || $lbrylIteraccionAttec==0){
                    if($estadoventa=="InstaladaDEL"){
                        $lblIteraccionAttec++;
                        registrarAttecReporte($idventa,$fecharegistroventa,$fechagrabar,$horagrabar,$lblIteraccionAttec);
                    }
                }                
                
            }
        }  
    }
     
    if(isset($_POST['valcodigoOperacionScoring'])){
        if($_POST['valcodigoOperacionScoring']=='' || empty($_POST['valcodigoOperacionScoring'])){
            $valcodigoOperacionScoring=NULL;  
            $IdConsultaScoring=NULL;
            $PerfilScoring=NULL;
            $Accion=NULL;
        } else {

            $valcodigoOperacionScoring = sanitizaCampo($_POST['valcodigoOperacionScoring'], 'sanitizestring|scapestring|htmlspecialchars',$con);
            $valcodigoOperacionScoring = htmlspecialchars($valcodigoOperacionScoring);
            $resultadoScoring= $con->prepare("SELECT t.IdConsultaScoring,t.PerfilScoring,t.Accion,t.TipoDocumento,t.NumeroDocumento FROM dbVENTAS.tbltmpscoring t WHERE t.NumeroOperacion=? ");
            $resultadoScoring->bind_param('s',$valcodigoOperacionScoring);
            $resultadoScoring->execute();
            $resultadoScoring->store_result();
            $resultadoScoring->bind_result(
                $IdConsultaScoringRow,
                $PerfilScoringRow,
                $AccionRow,
                $TipoDocumentoRow,
                $NumeroDocumentoRow
                );
            while ($resultadoScoring->fetch()) {
                $IdConsultaScoring=$IdConsultaScoringRow;
                $PerfilScoring=$PerfilScoringRow;
                $Accion=$AccionRow;
                $TipoDocumento=$TipoDocumentoRow;
                $NumeroDocumento=$NumeroDocumentoRow;                
                }
            //DOCUMENTO
                if ($IdDocRP == NULL){
                     $resultadoDocumento = insertarDocumento($TipoDocumento,$NumeroDocumento,$fecharegistro);
                     if ($resultadoDocumento > 0){
                     $IdDocRP=$resultadoDocumento;
                     $resultadocliente=actualizarClienteDoc($idcliente);
                     }else{
                     $IdDocRP=NULL;  
                     }
                     
                }else{
                    $resultadoDocumento = actualizarDocumento($TipoDocumento,$NumeroDocumento,$IdDocRP);
                    if ($resultadoDocumento > 0){
                    }else{
                    }
                }            
            }
    } else {
            $valcodigoOperacionScoring=NULL;   
            $IdConsultaScoring=NULL;
            $PerfilScoring=NULL;
            $Accion=NULL;            
    }
    
    //PROCSEO DE LA INFORMACION

    //PROCECSAR LA INFORMACION DEL DETALLE EXTRA Y REGALOS

    $detalleExtras = $_POST['detalleExtras'];
    
    $detalleRegalos = $_POST['detalleRegalos'];
  
    $detalleGeneral = $_POST['detalleGeneral'];
    
    $resultadoRegistroRegalos = registrarExtrasRegalos($detalleExtras, $detalleRegalos, $detalleGeneral);
    
    //INTERACCIONES DE AUDITORIA
    $lblIteraccionAttec = sanitizaCampo($_POST['lblIteraccionAttec'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $lblIteraccionAttec = htmlspecialchars($lblIteraccionAttec); 

    //ARRAY DE DATOS
    $arrayVenta = consultaVentaComercial($idventa);
    $arrayAgenda = consultaAgenda($idventa);

    //ACTUALIZA VENTA Y RETORNA EL NUMERO DE FILAS AFECTADAS
    //APLICAR SCORING
    if($tipoventa=="RE"){
        $resultadoventa = actualizarVenta($idventa);
    }else{
        $resultadoventa = actualizarVentaRP($idventa);
    }
    //ACTUALIZA AGENDA Y RETORNA EL NUMERO DE FILAS AFECTADAS

$resultadoagenda = actualizarAgenda($idventa);


if ($resultadoagenda > 0 && $resultadoventa>0) {
    //INSERTA LOG HISTORIO DE AGENDA
    $sqlagendahist=insertarAgendaHist($idagenda);
    
    //INSERTA LOG DE SEGURIDAD
    // $result_exec= mysqli_query($con,"INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES ('".$_SERVER['REMOTE_ADDR']."','".$_SESSION['usuariosesion']."','".$fecharegistroventa."','".$_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa."','Modificar','".$_SERVER['HTTP_USER_AGENT']."')");
    // $idLogSeg = $con->insert_id;
    
    $Ip = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
    $Usuario = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $Url = sanitizaCampo($_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa, 'sanitizeurl|scapestring|htmlspecialchars',$con);
    if(!empty($Url)){
    	$UrlLog = $Url.'=>IdVenta='.$idventa;
    }
    $Modificar = 'Modificar';
    $Navegador = sanitizaCampo($_SERVER['HTTP_USER_AGENT'], 'sanitizeint|scapestring|htmlspecialchars',$con);
                    
    try{
    	$result_exec= $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
    	$result_exec->bind_param('ssssss',$Ip,$Usuario,$fecharegistroventa,$UrlLog,$Modificar,$Navegador);
    	$result_exec->execute();
    	$idLogSeg = $con->insert_id;
    	$result_exec->close();
    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
        
    //INSERTA LOG TRANSACCIONAL DE TABLA VENTA
    insertLogVentaComercial($idLogSeg, $arrayVenta);
    //INSERTA LOG TRANSACCIONAL DE TABLA AGENDA
    insertLogAgenda($idLogSeg, $arrayAgenda);
    
    echo 1;
    
}
else if ($resultadoagenda == 0 && $resultadoventa>0){
    
    if($estadoventa=='PendienteData' || $estadoventa=='PendienteAgenda'){
              
        $comentarioagenda='Ingresa a Agenda';
        $fecharegistroagenda=$fechmod;

        $sqlagenda= $con->prepare("UPDATE dbVENTAS.tblagenda agen SET agen.FechaInst=NULL,agen.HoraInst=NULL,agen.InstaladoX=NULL,agen.MatriculaTec=NULL,agen.Comentario='Ingresa a Agenda',agen.Repercusion=NULL,agen.RepercusionCosto=NULL,agen.FechaHoraMODIF=?,agen.GestorAgenda=?,agen.EstadoVenta=? WHERE agen.IdVenta=? ");
        $sqlagenda->bind_param('sssi',$fechmod,$gestor,$estadoventa,$idventa);
        $sqlagenda->execute();
        
        $comentarioAgendaHistoria = 'Ingresa a Agenda';
        $sqlagendahist=$con->prepare("INSERT INTO dbVENTAS.tblagendahist(IdAgenda, IdVenta,Comentario, FechaHoraREG,GestorAgenda,EstadoVenta) VALUES (?,?,?,?,?,?)"); 
        $sqlagendahist->bind_param('iissss',$idagenda,$idventa,$comentarioAgendaHistoria,$fechmod,$gestor,$estadoventa);
        $sqlagendahist->execute();
        
        //INSERTA LOG TRANSACCIONAL DE TABLA AGENDA
        insertLogAgenda($idLogSeg, $arrayAgenda);
          
    }
    
    //INSERTA LOG DE SEGURIDAD
    // $result_exec= $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES ('".$_SERVER['REMOTE_ADDR']."','".$_SESSION['usuariosesion']."','".$fecharegistroventa."','".$_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa."','Modificar','".$_SERVER['HTTP_USER_AGENT']."')");
    // $idLogSeg = $con->insert_id;
    
    $Ip = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
    $Usuario = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $Url = sanitizaCampo($_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa, 'sanitizeurl|scapestring|htmlspecialchars',$con);
    if(!empty($Url)){
    	$UrlLog = $Url.'=>IdVenta='.$idventa;
    }
    $Modificar = 'Modificar';
    $Navegador = sanitizaCampo($_SERVER['HTTP_USER_AGENT'], 'sanitizeint|scapestring|htmlspecialchars',$con);
                    
    try{
    	$result_exec= $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
    	$result_exec->bind_param('ssssss',$Ip,$Usuario,$fecharegistroventa,$UrlLog,$Modificar,$Navegador);
    	$result_exec->execute();
    	$idLogSeg = $con->insert_id;
    	$result_exec->close();
    }  catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
        
    //INSERTA LOG TRANSACCIONAL DE TABLA VENTA
    insertLogVentaComercial($idLogSeg, $arrayVenta);
    
    echo 1;
}
else if ($resultadoagenda >0 && $resultadoventa==0){
    
        //INSERTA LOG HISTORIO DE AGENDA
    $sqlagendahist=insertarAgendaHist($idagenda);
    //INSERTA LOG DE SEGURIDAD
    // $result_exec= mysqli_query($con,"INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES ('".$_SERVER['REMOTE_ADDR']."','".$_SESSION['usuariosesion']."','".$fecharegistroventa."','".$_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa."','Modificar','".$_SERVER['HTTP_USER_AGENT']."')");
    // $idLogSeg = $con->insert_id;
    
    $Ip = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
    $Usuario = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $Url = sanitizaCampo($_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa, 'sanitizeurl|scapestring|htmlspecialchars',$con);
    if(!empty($Url)){
    	$UrlLog = $Url.'=>IdVenta='.$idventa;
    }
    $Modificar = 'Modificar';
    $Navegador = sanitizaCampo($_SERVER['HTTP_USER_AGENT'], 'sanitizeint|scapestring|htmlspecialchars',$con);
                    
    try{
    	$result_exec= $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
    	$result_exec->bind_param('ssssss',$Ip,$Usuario,$fecharegistroventa,$UrlLog,$Modificar,$Navegador);
    	$result_exec->execute();
    	$idLogSeg = $con->insert_id;
    	$result_exec->close();
    }  catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
    //INSERTA LOG TRANSACCIONAL DE TABLA AGENDA
    insertLogAgenda($idLogSeg, $arrayAgenda);
    
    echo 1;
}
else if ($resultadoagenda==0 && $resultadoventa==0){
    echo 0;
}
else {
    echo -1;
}


function actualizarVenta($idventa){
    
    global $con;
    
    global $categoria;
    global $tipoventa;
    global $preciokit;
    global $totalextra;
    global $ingresokit;
    global $ingresoextras;
    global $ingresototal;
    global $estadoventa;
    global $extraautorizado;
    global $mesesautorizados;
    global $n590;
    global $formadepago;
    global $PAI;
    global $resumenventa;
    global $estvisita;
    global $movivonoventa;
    global $competencia;
    global $hidden_HCertificacion;
    
    global $lbltipokit;
    global $lblclosingpack;
    global $lblprecioEspecial;
    global $lblCantExtras;
    global $lblresultadoScoring;
    global $IdConsultaScoring;
    global $hidGGCC;
    
    global $lblCantRegalos;
    global $lbltotalcuota;
    
    $RegalosAutorizados = 'NO';
    
    global $lblcategoriaprecio;
    global $lblDescuentoCuota;
    global $lbltipocamarakit;
    
    global $lblRenove,$lblRcompetencia,$lblRvencimiento;

    
    try{
        
        $stmt = $con->prepare("UPDATE dbVENTAS.tblventa v SET 
                v.CategoriaVenta=?,
                v.TipoVenta=?,
                v.PrecioKit=?,
                v.TotalExtra=?,
                v.IngresoKIT=?,
                v.IngresoExtras=?,
                v.IngresoTotal=?,
                v.EstadoVenta=?,
                v.ExtraAutorizado=?,
                v.MesesAutorizado=?,
                v.N590=?,
                v.FormaPago=?,
                v.PAI=?,
                v.ResumenVenta=?,
                v.EstadoVisita=?,
                v.PrecioKITOriginal=?,
                v.TotalExtraOriginal=?,
                v.ExtraAutorizadoOriginal=?,
                v.MesesAutorizadoOriginal=?,
                v.FormaPagoOriginal=?,
                v.PAIOriginal=?,
                v.ResumenVentaOriginal=?,
                v.MotivoNoVenta=?,
                v.Competencia=?,
                v.HojaCertificacion=?,
                v.TipoKIT=?,
                v.TipoKITOriginal=?,
                v.ClosingPack=?,
                v.PrecioEspecial=?,
                v.CantidadExtras=?,
                v.CantidadExtrasOriginal=?,
                v.ScoringRP=?,
                v.IdConsultaScoringRP=?,
                v.GGCC=?,
                v.CantidadRegalo=?,
                v.CantidadRegaloOriginal=?,
                v.TotalCuotaMonitoreo=?,
                v.RegalosAutorizados=?,
                v.CategoriaPrecio=?,
                v.dsctCuota=?,
                v.TipoCamaraKit=?,
                v.Renove=?,
                v.RCompetencia=?,
                v.RVencimiento=?
        WHERE v.IdVenta=?");
          $stmt->bind_param('ssdddddssssssssddssssssssssssiisisiidsssssssi', $categoria, $tipoventa, $preciokit, $totalextra, $ingresokit, $ingresoextras, $ingresototal, $estadoventa, $extraautorizado, $mesesautorizados, $n590, $formadepago, $PAI, $resumenventa, $estvisita,$preciokit,$totalextra,$extraautorizado,$mesesautorizados,$formadepago,$PAI,$resumenventa,$movivonoventa,$competencia, $hidden_HCertificacion, $lbltipokit, $lbltipokit, $lblclosingpack, $lblprecioEspecial, $lblCantExtras, $lblCantExtras, $lblresultadoScoring,$IdConsultaScoring,$hidGGCC, $lblCantRegalos, $lblCantRegalos, $lbltotalcuota, $RegalosAutorizados, $lblcategoriaprecio, $lblDescuentoCuota,$lbltipocamarakit,$lblRenove,$lblRcompetencia,$lblRvencimiento, $idventa);
        //$stmt->bind_param('ssdddddssssssssddsssssssssisssi',$categoria, $tipoventa,$preciokit,$totalextra,$ingresokit,$ingresoextras,$ingresototal,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$estvisita,$preciokit,$totalextra,$extraautorizado,$mesesautorizados,$formadepago,$PAI,$resumenventa,$movivonoventa,$competencia, $hidden_HCertificacion, $lbltipokit, $lblCantExtras, $lblclosingpack, $lblprecioEspecial, $lblresultadoScoring, $idventa);
        $stmt->execute();

        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function actualizarVentaRP($idventa){
        
        global $con;
        
        global $categoria;
        global $tipoventa;
        global $preciokit;
        global $totalextra;
        global $ingresokit;
        global $ingresoextras;
        global $ingresototal;
        global $estadoventa;
        global $extraautorizado;
        global $mesesautorizados;
        global $n590;
        global $formadepago;
        global $PAI;
        global $resumenventa;
        global $estvisita;
        global $movivonoventa;
        global $competencia;
        global $hidden_HCertificacion;
        
        global $lbltipokit;
        global $lblclosingpack;
        global $lblprecioEspecial;
        global $lblCantExtras;
        global $lblresultadoScoring;
        global $IdConsultaScoring;
        global $hidGGCC;
        global $PerfilScoring;
        global $Accion;
        
        global $lblCantRegalos;
        global $lbltotalcuota;
        
        global $lblcategoriaprecio;
        global $lblDescuentoCuota;
        global $lbltipocamarakit;
        
        global $lblRenove,$lblRcompetencia,$lblRvencimiento;
        

            
        try{
            
            $stmt = $con->prepare("UPDATE dbVENTAS.tblventa v SET 
            v.CategoriaVenta=?,
            v.TipoVenta=?,
            v.PrecioKit=?,
            v.TotalExtra=?,
            v.IngresoKIT=?,
            v.IngresoExtras=?,
            v.IngresoTotal=?,
            v.EstadoVenta=?,
            v.ExtraAutorizado=?,
            v.MesesAutorizado=?,
            v.N590=?,
            v.FormaPago=?,
            v.PAI=?,
            v.ResumenVenta=?,
            v.EstadoVisita=?,
            v.PrecioKITOriginal=?,
            v.TotalExtraOriginal=?,
            v.ExtraAutorizadoOriginal=?,
            v.MesesAutorizadoOriginal=?,
            v.FormaPagoOriginal=?,
            v.PAIOriginal=?,
            v.ResumenVentaOriginal=?,
            v.MotivoNoVenta=?,
            v.Competencia=?,
            v.HojaCertificacion=?,
            v.TipoKIT=?,
            v.TipoKITOriginal=?,
            v.ClosingPack=?,
            v.PrecioEspecial=?,
            v.CantidadExtras=?,
            v.CantidadExtrasOriginal=?,
            v.ScoringRP=?,
            v.IdConsultaScoring=?,
            v.IdConsultaScoringRP=?,
            v.GGCC=?,
            v.PerfilScoring=?,
            v.Accion=?,
            v.CantidadRegalo=?,
            v.CantidadRegaloOriginal=?,
            v.TotalCuotaMonitoreo=?,
            v.CategoriaPrecio=?,
            v.dsctCuota=?,
            v.TipoCamaraKit=?,
            v.Renove=?,
            v.RCompetencia=?,
            v.RVencimiento=?
            WHERE v.IdVenta=?");
              $stmt->bind_param('ssdddddssssssssddssssssssssssiisiissssssssssssi', $categoria, $tipoventa, $preciokit, $totalextra, $ingresokit, $ingresoextras, $ingresototal, $estadoventa, $extraautorizado, $mesesautorizados, $n590, $formadepago, $PAI, $resumenventa, $estvisita,$preciokit,$totalextra,$extraautorizado,$mesesautorizados,$formadepago,$PAI,$resumenventa,$movivonoventa,$competencia, $hidden_HCertificacion, $lbltipokit, $lbltipokit, $lblclosingpack, $lblprecioEspecial, $lblCantExtras, $lblCantExtras, $lblresultadoScoring,$IdConsultaScoring,$IdConsultaScoring,$hidGGCC, $PerfilScoring, $Accion, $lblCantRegalos, $lblCantRegalos, $lbltotalcuota, $lblcategoriaprecio, $lblDescuentoCuota,$lbltipocamarakit,$lblRenove,$lblRcompetencia,$lblRvencimiento,$idventa);
            //$stmt->bind_param('ssdddddssssssssddsssssssssisssi',$categoria, $tipoventa,$preciokit,$totalextra,$ingresokit,$ingresoextras,$ingresototal,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$estvisita,$preciokit,$totalextra,$extraautorizado,$mesesautorizados,$formadepago,$PAI,$resumenventa,$movivonoventa,$competencia, $hidden_HCertificacion, $lbltipokit, $lblCantExtras, $lblclosingpack, $lblprecioEspecial, $lblresultadoScoring, $idventa);
            $stmt->execute();
    
            $respuesta = $stmt->affected_rows;
            
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = 'error';
        }
        
        return $respuesta;
        
    }

function actualizarAgenda($idventa){
    
    global $con;
    
    
    global $fechagrabar;
    global $horagrabar;
    global $instaladox;
    global $tecnico;
    global $comentarioagenda;
    global $fecharegistroagenda;
    global $inviable;
    global $gestor;
    global $estadoventa;
    
    try{
        
        $stmt = $con->prepare("UPDATE dbVENTAS.tblagenda SET FechaInst=?, HoraInst=?, InstaladoX=?, MatriculaTec=?, Comentario=?, MotivoInviable=?, GestorAgenda=?, EstadoVenta=? WHERE IdVenta=?");
        $stmt->bind_param('ssssssssi', $fechagrabar, $horagrabar, $instaladox, $tecnico, $comentarioagenda, $inviable, $gestor, $estadoventa, $idventa);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function insertarAgendaHist($idagenda){
    global $con;
    
    
    

    global $idventa;
    global $fechagrabar;
    global $horagrabar;
    global $instaladox;
    global $tecnico;
    global $comentarioagenda;
    global $fecharegistroagenda;
  

    global $gestor;
    global $estadoventa;

    
    
    try{
        
        $stmt = $con->prepare("INSERT INTO dbVENTAS.tblagendahist(IdAgenda, IdVenta, FechaInst,HoraInst,InstaladoX, MatriculaTec, Comentario, FechaHoraREG,GestorAgenda,EstadoVenta) VALUES(?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iissssssss',$idagenda,$idventa, $fechagrabar, $horagrabar, $instaladox, $tecnico, $comentarioagenda, $fecharegistroagenda, $gestor, $estadoventa);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function stringtonull($val){
    
    if ($val == '' || empty($val)){
        $resultado = NULL;
    }
    else if(!isset($val)){
        $resultado = NULL;
    }
    else {
        $resultado = $val;
    }
    
    return $resultado;
}

function insertarDocumento($tipodoc,$documento,$fecharegistro){
    global $con;
    $tipodocnuevo="";
    if($tipodoc==1){
        $tipodocnuevo="DNI";
    }else if($tipodoc==6){
       $tipodocnuevo="RUC"; 
    }else{
       $tipodocnuevo="CE"; 
    }
        try {
    
          $stmt = $con->prepare("INSERT INTO dbVENTAS.tbldocumento(TipoDocumento, Documento, FechaHoraREG) VALUES(?, ?, ?)");
          $stmt->bind_param('sss', $tipodocnuevo,$documento,$fecharegistro);
            $stmt->execute();
            $respuesta = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
    
        return $respuesta;
    

}

function actualizarDocumento($tipodoc,$documento,$IdDocRP){
    global $con;
    $tipodocnuevo="";
    if($tipodoc==1){
        $tipodocnuevo="DNI";
    }else if($tipodoc==6){
       $tipodocnuevo="RUC"; 
    }else{
       $tipodocnuevo="CE"; 
    }
    
    try{
        $stmt = $con->prepare("UPDATE tbldocumento SET TipoDocumento=?, Documento=? WHERE IdDoc = ?");
        $stmt->bind_param('ssi', $tipodocnuevo,$documento, $IdDocRP);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();  
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
        return $respuesta;    
}

//Funcion nueva Cliente
function actualizarClienteDoc($idcliente){
    global $con;

    global $IdDocRP;

    try{
        $stmt = $con->prepare("UPDATE dbVENTAS.tblcliente SET IdDocRP=? WHERE IdCliente = ?");
        $stmt->bind_param("ii", $IdDocRP, $idcliente);
        $stmt->execute();

        $rows = $stmt->affected_rows;
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }

    return $respuesta;
}

function validarNContrato($val){
    global $con;
    
    $sql = "SELECT * FROM tblcliente WHERE NCliente =".$val;
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    
    return $row_cnt;
    
}

function registrarExtrasRegalos($detalleExtras, $detalleRegalos, $detalleGeneral){
    global $con;
    global $idventa;
    $fecharegistro = date("Y-m-d H:i:s");
    
    if(($detalleExtras==''||$detalleExtras==null)&&($detalleExtras==''||$detalleExtras==null)&&($detalleExtras==''||$detalleExtras==null)){
        return 'error';
    }
    
    $sql = $con->prepare("SELECT 1 FROM tblventacotizacion WHERE IdVenta =?");
    $sql->bind_param('i',$idventa);
    $sql->execute();
    $sql->store_result();
    
    $row_cnt = $sql->num_rows;
    /*
    while($data = $resultado->fetch_assoc()){
        $DetalleExtras__BD = $data['DetalleExtras'];
        $DetalleRegalos__BD = $data['DetalleRegalos'];
    }
    */
    if($row_cnt > 0){

        try{
            $stmt = $con->prepare("UPDATE tblventacotizacion SET DetalleExtras=?, DetalleRegalos=?, DetalleGeneral=? WHERE IdVenta = ?");
            $stmt->bind_param("sssi", $detalleExtras, $detalleRegalos, $detalleGeneral, $idventa);
            $stmt->execute();
            $respuesta = $stmt->affected_rows;
            $stmt->close();
            
        }catch (\Exception $e) {
            $respuesta = 'error';
        }
        
    } else {
    
        try{
            $stmt = $con->prepare("INSERT INTO tblventacotizacion (IdVenta, FechaHoraREG, DetalleExtras, DetalleRegalos, DetalleGeneral) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("issss", $idventa, $fecharegistro, $detalleExtras, $detalleRegalos, $detalleGeneral);
            $stmt->execute();

            $respuesta = $con->insert_id;
            
            $stmt->close();
            
        }catch (\Exception $e) {
            $respuesta = 'error';
        }
    }
    
    return $respuesta;
}

function registrarAttecReporte($idventa,$fecharegistro,$fechagrabar,$horagrabar,$lblIteraccionAttec){
    global $con;
        if ($fechagrabar == '' || empty($fechagrabar)){
            $FechaProgramacion = NULL;
        } else {
            $FechaProgramacion=$fechagrabar.' '.$horagrabar;
        }

    try {

      $stmt = $con->prepare("INSERT INTO tblattecreporte(IdVenta, FechaInstaladaDEL, FechaProgramacion, Vueltas,FechaHoraREG) VALUES (?,?,?,?,?)");
      $stmt->bind_param('issss', $idventa, $fecharegistro, $FechaProgramacion,$lblIteraccionAttec, $fecharegistro);
      $stmt->execute();

      $respuesta = array(
            'respuesta' => 'exito',
          );

      $stmt->close();
    } catch (\Exception $e) {
        $respuesta = array(
          'respuesta' => 'error',
          'mensaje' => $e->getMessage()
        );
    }

    return $respuesta;
}

function UltimoEstadoVenta($idventa){
    
    global $con;
    
    $sql = $con->prepare("SELECT EstadoVenta 
            FROM tblventa
            WHERE IdVenta =? 
            ");
    $sql->bind_param('i',$idventa);
    $sql->execute();
    $sql->store_result();
    $sql->bind_result(
        $EstadoVentaRow
        );
    
    if($sql->num_rows > 0){
        while ($sql->fetch()){
        $ultimoestado = $EstadoVentaRow;
        }
    }else{
        $ultimoestado='';
    }
    
    return $ultimoestado;
}


$con->close();

