<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';

$sql = "SELECT 
        IdVenta,
        NProspecto,
        EstadoVenta,
        Comercial,
        CC,
        JefeVenta,
        Checkin,
        InfoCheckIn
        FROM tblventa
        WHERE
        TipoVenta = 'RE'
        AND (InfoCheckIn IS NOT NULL) 
        AND Checkin = 'NO'
        ORDER BY IdVenta DESC";
        
$resultado = $con->query($sql);
$row_cnt = $resultado->num_rows;

$arreglo = array();

if($row_cnt > 0){
    while ($data = $resultado->fetch_assoc()){
        $IdVenta = $data['IdVenta'];
        $NProspecto = $data['NProspecto'];
        $EstadoVenta = $data['EstadoVenta'];
        $Comercial = $data['Comercial'];
        $CC = $data['CC'];
        $JefeVenta = $data['JefeVenta'];
        $Checkin = $data['Checkin'];
        $InfoCheckIn = json_decode($data['InfoCheckIn'], true);
        $FechaEnvio = $InfoCheckIn['FechaEnvio'];
        $Tipo = $InfoCheckIn['Tipo'];
        
        if($Tipo == 'Manual' || $Tipo == 'Inubicable' || $Tipo == 'Reubicacion'){
            $arreglo[] = array(
                'IdVenta' => $IdVenta,
                'NProspecto' => $NProspecto,
                'EstadoVenta' => $EstadoVenta,
                'Comercial' => $Comercial,
                'CC' => $CC,
                'JefeVenta' => $JefeVenta,
                'Checkin' => $Checkin,
                'FechaEnvio' => $FechaEnvio
            );
        }
    }
    
    if(sizeof($arreglo) == 0){
        $arreglo = array(
            'Resultado' => 'noData'
        );
    }
} else {
    $arreglo = array(
            'Resultado' => 'noData'
        );
}

echo json_encode($arreglo);
