<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';

$matriculauser=sanitizaCampo($_GET['matriculauser'], 'sanitizestring|scapestring|htmlspecialchars', $con);
$permisouser=sanitizaCampo($_GET['permisouser'], 'sanitizestring|scapestring|htmlspecialchars', $con);

$arreglo=NULL;


if($permisouser=="GestorRetencion"){
    $query="SELECT
    r.IdRetencion,
    r.MotivoAviso,
    DATE_FORMAT(r.FechaHoraREG, '%Y-%m-%d %r') FechaHoraREG,
    r.TipoCanal,
    r.FechaCierre,
    r.TipoCierre,
    r.MotivoCierre,
    r.EstadoFinGestion,
    r.Gestor,
    c.NombApellido Cliente,
    c.NCliente,
    g.Distrito,
    g.Provincia
    FROM dbVENTAS.tblretencion r
    INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=r.IdCliente
    INNER JOIN dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
    where r.Gestor=?
    ORDER BY  r.FechaHoraREG DESC";
    
    	try{       
            $stmt = $con->prepare($query);
            $stmt->bind_param('s', $matriculauser);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($IdRetencion, $MotivoAviso, $FechaHoraREG, $TipoCanal, $FechaCierre, $TipoCierre, $MotivoCierre, $EstadoFinGestion, $Gestor, $Cliente,$NCliente, $Distrito, $Provincia);
            
            if($stmt->num_rows > 0){
                while($stmt->fetch()){
                    $arreglo[]=array_map(null,['IdRetencion' => $IdRetencion,
'MotivoAviso' => $MotivoAviso,
'FechaHoraREG' => $FechaHoraREG,
'TipoCanal' => $TipoCanal,
'FechaCierre' => $FechaCierre,
'TipoCierre' => $TipoCierre,
'MotivoCierre' => $MotivoCierre,
'EstadoFinGestion' => $EstadoFinGestion,
'Gestor' => $Gestor,
'Cliente' => $Cliente,
'NCliente'=>$NCliente,
'Distrito' => $Distrito,
'Provincia' => $Provincia
]); //array_map("utf8_encode",$data)  este codigo nos ayuda a muestrar caracteres diferentes
                    unset($data);
                }
            }
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }
} else {
    $query="SELECT
    r.IdRetencion,
    r.MotivoAviso,
    DATE_FORMAT(r.FechaHoraREG, '%Y-%m-%d %r') FechaHoraREG,
    r.TipoCanal,
    r.FechaCierre,
    r.TipoCierre,
    r.MotivoCierre,
    r.EstadoFinGestion,
    r.Gestor,
    c.NombApellido Cliente,
    c.NCliente,
    g.Distrito,
    g.Provincia
    FROM dbVENTAS.tblretencion r
    INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=r.IdCliente
    INNER JOIN dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
    ORDER BY  r.FechaHoraREG DESC";
    
    	try{       
            $stmt = $con->prepare($query);
            //$stmt->bind_param('s', $matriculauser);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($IdRetencion, $MotivoAviso, $FechaHoraREG, $TipoCanal, $FechaCierre, $TipoCierre, $MotivoCierre, $EstadoFinGestion, $Gestor, $Cliente, $NCliente,$Distrito, $Provincia);
            
            if($stmt->num_rows > 0){
                while($stmt->fetch()){
                    $arreglo[]=array_map(null,['IdRetencion' => $IdRetencion,
'MotivoAviso' => $MotivoAviso,
'FechaHoraREG' => $FechaHoraREG,
'TipoCanal' => $TipoCanal,
'FechaCierre' => $FechaCierre,
'TipoCierre' => $TipoCierre,
'MotivoCierre' => $MotivoCierre,
'EstadoFinGestion' => $EstadoFinGestion,
'Gestor' => $Gestor,
'Cliente' => $Cliente,
'NCliente'=>$NCliente,
'Distrito' => $Distrito,
'Provincia' => $Provincia,
]); //array_map("utf8_encode",$data)  este codigo nos ayuda a muestrar caracteres diferentes
                    unset($data);
                }
            }
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }   
}

echo json_encode($arreglo);

