<?php

require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';


$idusuario = sanitizaCampo($_POST['idusuario'], 'sanitizeint|scapestring|htmlspecialchars',$con);

    try{
        $stmt = $con->prepare( "select 1 from tblventa v INNER JOIN dbUSUARIO.tblusuario u on u.IdUsuario=v.IdUsuario WHERE v.TipoVenta = 'RE' AND u.IdUsuario=? and v.FechaVisita>=CURDATE() limit 1");
        $stmt->bind_param('i', $idusuario);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($num);
        
        $numrows1=$stmt->num_rows;
        $stmt->close();

        } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
        }


    try{
        $stmt = $con->prepare( "select 1 from tblprospectorp p INNER JOIN dbUSUARIO.tblusuario u on u.IdUsuario=p.IdUsuario WHERE p.TipoVenta = 'RPTMK' AND u.IdUsuario=? and p.FechaVisitaRP>=CURDATE()");
        $stmt->bind_param('i', $idusuario);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($num);
        
        $numrows2=$stmt->num_rows;
        $stmt->close();

        } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
        }

if ($numrows1>0 || $numrows2>0) {
    echo 1;
} else {
    echo '<div class="callout  bg-gray">
        <h4><i class="fa fa-bullhorn"></i> ¡Alerta!</h4>
          <strong>El usuario no tiene VISITAS AGENDADAS</strong><br>
        <p>&nbsp;</p>
        <br>
    </div>';
}


?>
 