<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
//LOG
require_once 'log/insertLog.php';
//LIBRERIA DE EXPORTACION
require_once 'libreria/Spout/Autoloader/autoload.php';

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

$fileName = 'VentasActual.csv';

$writer = WriterEntityFactory::createCSVWriter();

$writer->openToBrowser($fileName);

$head = array('IdVenta','IdUsuario',
'IdCliente',
'Matricula',
'Comercial',
'CC',
'JefeVenta',
'CategoriaVenta',
'TipoVenta',
'Segmento',
'NProspecto',
'NContrato',
'PrecioKit',
'TotalExtra',
'IngresoKIT',
'IngresoExtras',
'IngresoTotal',
'EstadoVenta',
'ExtraAutorizado',
'MesesAutorizado',
'N590',
'FormaPago',
'PAI',
'ResumenVenta',
'FechaHoraREG',
'EstadoVisita',
'FechaVisita',
'HoraVisita',
'FVencimientoVisita',
'GestorMKT',
'OrigenVisita',
'ComentarioVisita',
'GestorOrigen',
'IdGeografico',
'NombApellido',
'Telefonouno',
'Telefonodos',
'Correo',
'Direccion',
'Distrito',
'Provincia',
'CCOriginal',
'IMP',
'ContactadoCO',
'MesVisita',
'VTAConfirmadaCO',
'FechaInst',
'HoraInst',
'InstaladoX',
'MatriculaTec',
'IdProspectoRP',
'FechaFacturacion',
'FechaRecepcionDOC',
'MotivoIncidencia',
'TipoKIT',
'CantidadExtras',
'ClosingPack',
'PrecioEspecial',
'ScoringFIELD',
'ComentarioCO',
'PerfilScoring',
'ComentarioAgenda',
'TipoCamaraKit',
'VendidaCamaraInternaExtra',
'CantidadCamaraInternaExtra',
'PrecioCamaraInternaExtra',
'VendidaCamaraExternaExtra',
'CantidadCamaraExternaExtra',
'PrecioCamaraExternaExtra',
'dsctCuota',
'CategoriaPrecio',
'CantidadRegalo',
'TotalCuotaMonitoreo',
'NombJefeVenta',
'ContratoEnviado',
'ContratoCorrecto',
'FechaContratoEnviado',
'TipoCierre',
'MotivoIncidenciaCert',
'SolucionIncidencia',
'ComentarioCert',
'TipoDocREF',
'DocREF',
'ComentarioAttec',
'Renove',
'RCompetencia',
'RVencimiento',
'TipoSegmento',
'pagoenviadoCO',
'montoCO',
'motivoincidenciaCO',
'contratocorregidoenviador2CO',
'fechadiferenciar2CO',
'fechaenviocontratocorregidofinalr2CO',
'diferenciamontor2CO',
'comentarior2CO',
'ComentarioComercial',
'RespComercial',
'nuevohorarioSugerido',
'numerollamadas'
);

// 'Territorial'

$rowFromValues = WriterEntityFactory::createRowFromArray($head);
$writer->addRow($rowFromValues);

date_default_timezone_set('America/Lima');

$fecharegistro=date("Y-m-d H:i:s");

$result_exec = StmtInsertarLogSeguridad_General('Exportar', $fecharegistro, '', '');


$query="SELECT 
v.IdVenta,
v.IdUsuario,
v.IdCliente,
v.Matricula,
v.Comercial,
v.CC,
v.JefeVenta,
v.CategoriaVenta,
v.TipoVenta,
v.Segmento,
v.NProspecto,
v.NContrato,
v.PrecioKit,
v.TotalExtra,
v.IngresoKIT,
v.IngresoExtras,
v.IngresoTotal,
v.EstadoVenta,
v.ExtraAutorizado,
v.MesesAutorizado,
v.N590,
v.FormaPago,
v.PAI,
v.ResumenVenta,
v.FechaHoraREG,
v.EstadoVisita,
v.FechaVisita,
v.HoraVisita,
v.FVencimientoVisita,
v.GestorMKT,
v.OrigenVisita,
v.ComentarioVisita,
v.GestorOrigen,
c.IdGeografico,
c.NombApellido,
c.Telefonouno,
c.Telefonodos,
c.Correo,
c.Direccion,
g.Distrito,
g.Provincia,
v.CCOriginal,
v.IMP,
v.ContactadoCO,
v.MesVisita,
v.VTAConfirmadaCO,
a.FechaInst,
a.HoraInst,
a.InstaladoX,
a.MatriculaTec,
v.IdProspectoRP,
f.FechaFacturacion,
f.FechaRecepcionDOC,
f.MotivoIncidencia,
v.TipoKIT,
v.CantidadExtras,
v.ClosingPack,
v.PrecioEspecial,
v.ScoringRP as ScoringFIELD,
v.ComentarioCO,
v.PerfilScoring,
a.Comentario as ComentarioAgenda,
CASE WHEN v.TipoCamaraKit IS NULL THEN vena.TipoCamaraKit ELSE v.TipoCamaraKit END as TipoCamaraKit,
vena.VendidaCamaraInternaExtra,
vena.CantidadCamaraInternaExtra,
vena.PrecioCamaraInternaExtra,
vena.VendidaCamaraExternaExtra,
vena.CantidadCamaraExternaExtra,
vena.PrecioCamaraExternaExtra,
v.dsctCuota,
v.CategoriaPrecio,
v.CantidadRegalo,
v.TotalCuotaMonitoreo,
CONCAT(u.Nombres,' ',u.Apellidos) as NombJefeVenta,
v.ContratoEnviado,
v.ContratoCorrecto,
v.FechaContratoEnviado,
cv.TipoCierre,
cv.MotivoIncidencia as MotivoIncidenciaCert,
cv.SolucionIncidencia,
cv.Comentario,
p.TipoDocREF,
p.DocREF,
att.Comentario as ComentarioAttec,
v.Renove,
v.RCompetencia,
v.RVencimiento,
c.TipoSegmento,
v.pagoenviadoCO,
v.montoCO,
v.motivoincidenciaCO,
v.contratocorregidoenviadoCO,
v.fechadiferenciaCO,
v.fechaenviocontratocorregidofinalCO,
v.diferenciamontoCO,
v.comentarior2CO,
cv.ComentarioComercial,
cv.RespComercial,
cv.nuevohorarioSugerido,
cv.numerollamadas
FROM dbVENTAS.tblventa v INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
INNER JOIN dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
INNER JOIN dbVENTAS.tblagenda a on a.IdVenta=v.IdVenta
INNER JOIN dbVENTAS.tblfacturacion f on f.IdVenta=v.IdVenta
LEFT JOIN dbVENTAS.tblventainformacionarlo vena on vena.IdVenta=v.IdVenta
LEFT JOIN dbUSUARIO.tblusuario u on u.Matricula=v.JefeVenta
LEFT JOIN dbVENTAS.tblcertificacionventa cv on cv.IdCertVenta=v.IdCertVenta
LEFT JOIN dbVENTAS.tblprospectorp p on p.IdProspectoRP=v.IdProspectoRP
LEFT JOIN dbVENTAS.tblattec att on att.IdVenta=v.IdVenta
WHERE v.N590='Oct-2023'";
/*N590 Actual*/

try{
$stmt = $con->prepare($query);
$stmt->execute();
$stmt->store_result();
$stmt->bind_result(
$IdVenta,
$IdUsuario,
$IdCliente,
$Matricula,
$Comercial,
$CC,
$JefeVenta,
$CategoriaVenta,
$TipoVenta,
$Segmento,
$NProspecto,
$NContrato,
$PrecioKit,
$TotalExtra,
$IngresoKIT,
$IngresoExtras,
$IngresoTotal,
$EstadoVenta,
$ExtraAutorizado,
$MesesAutorizado,
$N590,
$FormaPago,
$PAI,
$ResumenVenta,
$FechaHoraREG,
$EstadoVisita,
$FechaVisita,
$HoraVisita,
$FVencimientoVisita,
$GestorMKT,
$OrigenVisita,
$ComentarioVisita,
$GestorOrigen,
$IdGeografico,
$NombApellido,
$Telefonouno,
$Telefonodos,
$Correo,
$Direccion,
$Distrito,
$Provincia,
$CCOriginal,
$IMP,
$ContactadoCO,
$MesVisita,
$VTAConfirmadaCO,
$FechaInst,
$HoraInst,
$InstaladoX,
$MatriculaTec,
$IdProspectoRP,
$FechaFacturacion,
$FechaRecepcionDOC,
$MotivoIncidencia,
$TipoKIT,
$CantidadExtras,
$ClosingPack,
$PrecioEspecial,
$ScoringFIELD,
$ComentarioCO,
$PerfilScoring,
$ComentarioAgenda,
$TipoCamaraKit,
$VendidaCamaraInternaExtra,
$CantidadCamaraInternaExtra,
$PrecioCamaraInternaExtra,
$VendidaCamaraExternaExtra,
$CantidadCamaraExternaExtra,
$PrecioCamaraExternaExtra,
$dsctCuota,
$CategoriaPrecio,
$CantidadRegalo,
$TotalCuotaMonitoreo,
$NombJefeVenta,
$ContratoEnviado,
$ContratoCorrecto,
$FechaContratoEnviado,
$TipoCierre,
$MotivoIncidenciaCert,
$SolucionIncidencia,
$Comentario,
$TipoDocREF,
$DocREF,
$ComentarioAttec,
$Renove,
$RCompetencia,
$RVencimiento,
$TipoSegmento,
$pagoenviadoCO,
$montoCO,
$motivoincidenciaCO,
$contratocorregidoenviadoCO,
$fechadiferenciaCO,
$fechaenviocontratocorregidofinalCO,
$diferenciamontoCO,
$comentarior2CO,
$ComentarioComercial,
$RespComercial,
$nuevohorarioSugerido,
$numerollamadas
);
      
while ($stmt->fetch()){
$rowData = WriterEntityFactory::createRowFromArray([
'IdVenta' => $IdVenta,
'IdUsuario' => $IdUsuario,
'IdCliente' => $IdCliente,
'Matricula' => $Matricula,
'Comercial' => $Comercial,
'CC' => $CC,
'JefeVenta' => $JefeVenta,
'CategoriaVenta' => $CategoriaVenta,
'TipoVenta' => $TipoVenta,
'Segmento' => $Segmento,
'NProspecto' => $NProspecto,
'NContrato' => $NContrato,
'PrecioKit' => $PrecioKit,
'TotalExtra' => $TotalExtra,
'IngresoKIT' => $IngresoKIT,
'IngresoExtras' => $IngresoExtras,
'IngresoTotal' => $IngresoTotal,
'EstadoVenta' => $EstadoVenta,
'ExtraAutorizado' => $ExtraAutorizado,
'MesesAutorizado' => $MesesAutorizado,
'N590' => $N590,
'FormaPago' => $FormaPago,
'PAI' => $PAI,
'ResumenVenta' => $ResumenVenta,
'FechaHoraREG' => $FechaHoraREG,
'EstadoVisita' => $EstadoVisita,
'FechaVisita' => $FechaVisita,
'HoraVisita' => $HoraVisita,
'FVencimientoVisita' => $FVencimientoVisita,
'GestorMKT' => $GestorMKT,
'OrigenVisita' => $OrigenVisita,
'ComentarioVisita' => $ComentarioVisita,
'GestorOrigen' => $GestorOrigen,
'IdGeografico' => $IdGeografico,
'NombApellido' => $NombApellido,
'Telefonouno' => $Telefonouno,
'Telefonodos' => $Telefonodos,
'Correo' => $Correo,
'Direccion' => $Direccion,
'Distrito' => $Distrito,
'Provincia' => $Provincia,
'CCOriginal' => $CCOriginal,
'IMP' => $IMP,
'ContactadoCO' => $ContactadoCO,
'MesVisita' => $MesVisita,
'VTAConfirmadaCO' => $VTAConfirmadaCO,
'FechaInst' => $FechaInst,
'HoraInst' => $HoraInst,
'InstaladoX' => $InstaladoX,
'MatriculaTec' => $MatriculaTec,
'IdProspectoRP' => $IdProspectoRP,
'FechaFacturacion' => $FechaFacturacion,
'FechaRecepcionDOC' => $FechaRecepcionDOC,
'MotivoIncidencia' => $MotivoIncidencia,
'TipoKIT' => $TipoKIT,
'CantidadExtras' => $CantidadExtras,
'ClosingPack' => $ClosingPack,
'PrecioEspecial' => $PrecioEspecial,
'ScoringFIELD' => $ScoringFIELD,
'ComentarioCO' => $ComentarioCO,
'PerfilScoring' => $PerfilScoring,
'ComentarioAgenda' => $ComentarioAgenda,
'TipoCamaraKit' => $TipoCamaraKit,
'VendidaCamaraInternaExtra' => $VendidaCamaraInternaExtra,
'CantidadCamaraInternaExtra' => $CantidadCamaraInternaExtra,
'PrecioCamaraInternaExtra' => $PrecioCamaraInternaExtra,
'VendidaCamaraExternaExtra' => $VendidaCamaraExternaExtra,
'CantidadCamaraExternaExtra' => $CantidadCamaraExternaExtra,
'PrecioCamaraExternaExtra' => $PrecioCamaraExternaExtra,
'dsctCuota' => $dsctCuota,
'CategoriaPrecio' => $CategoriaPrecio,
'CantidadRegalo' => $CantidadRegalo,
'TotalCuotaMonitoreo' => $TotalCuotaMonitoreo,
'NombJefeVenta' => $NombJefeVenta,
'ContratoEnviado' => $ContratoEnviado,
'ContratoCorrecto' => $ContratoCorrecto,
'FechaContratoEnviado' => $FechaContratoEnviado,
'TipoCierre' => $TipoCierre,
'MotivoIncidenciaCert' => $MotivoIncidenciaCert,
'SolucionIncidencia' => $SolucionIncidencia,
'Comentario' => $Comentario,
'TipoDocREF' => $TipoDocREF,
'DocREF' => $DocREF,
'ComentarioAttec' => $ComentarioAttec,
'Renove' => $Renove,
'RCompetencia' => $RCompetencia,
'RVencimiento' => $RVencimiento,
'TipoSegmento' =>$TipoSegmento,
'pagoenviadoCO' => $pagoenviadoCO,
'montoCO' => $montoCO,
'motivoincidenciaCO' => $motivoincidenciaCO,
'contratocorregidoenviador2CO' => $contratocorregidoenviadoCO,
'fechadiferenciar2CO' => $fechadiferenciaCO,
'fechaenviocontratocorregidofinalr2CO' => $fechaenviocontratocorregidofinalCO,
'diferenciamontor2CO' => $diferenciamontoCO,
'comentarior2CO'=>$comentarior2CO,
'ComentarioComercial' =>$ComentarioComercial,
'RespComercial' =>$RespComercial,
'nuevohorarioSugerido' =>$nuevohorarioSugerido,
'numerollamadas'=>$numerollamadas
    ]);
$writer->addRow($rowData);  
}
	    
$stmt->close();
$writer->close();
$con->close();


} catch(PDOException $e) {
    echo "Error: " . $e->getMessage();
    exit();
}




?>
