<?php

require_once '../config/db.php';
require_once '../config/conexion.php';

$json = file_get_contents('php://input');
$data = json_decode($json);

if(isset($data->lblMesVisita)){
    $mesVisita = $data->lblMesVisita;
} else {
    $mesVisita= 'Jun-2021';
}

$arregloDatos = consultaOperadores($mesVisita);

$arregloDatos['Totales']['NombreCompleto']  = 'Total';

$arregloCantidadVisitasOperador = consultaVisitasGeoOperador($mesVisita);
$arregloCantidadVisitasOperadorEnLinea = consultaVisitasGeoOperadorEnLinea($mesVisita);
$arregloCantidadVisitasOperadorFueraLlamada = consultaVisitasGeoOperadorFueraLlamada($mesVisita);

agregarDatos($arregloCantidadVisitasOperador, 'Visitas');
agregarDatos($arregloCantidadVisitasOperadorEnLinea, 'EnLinea');
agregarDatos($arregloCantidadVisitasOperadorFueraLlamada, 'FueraLlamada');

echo json_encode($arregloDatos);

function agregarDatos($arreglo, $tipo){
    global $arregloDatos;
    
    //RECORRE EL ARRAY GLOBAL 
    foreach($arregloDatos as $clave => $valor){
        //RECORRER EL ARRAY QUE SE ENVIA COMO PARAMETRO PARA AGREGAR SU RESULTADO AL ARRAY GLOBAL
        foreach($arreglo as $claveTMP => $valorTMP){
            if($valor['Matricula'] == $valorTMP['Gestor']){
                //AGREGA LA CANTIDAD AL ARREGLO GLOBAL
                $arregloDatos[$clave][$tipo] = $valorTMP['Cantidad'];
                
                $total += $valorTMP['Cantidad'];
            }
            
        }
    }
    
    $arregloDatos['Totales'][$tipo] = $total;
}

function consultaOperadores($mesVisita){
    global $con;
    
    $sql = "SELECT * FROM dbUSUARIO.tblusuario WHERE IdPerfil = 55 ORDER BY Apellidos, Nombres";
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    
    if($row_cnt > 0){
        while($data = $resultado->fetch_assoc()){
            $arregloResultado[] = array(
                    'IdUsuario' => $data['IdUsuario'],
                    'Matricula' => $data['Matricula'],
                    'NombreCompleto' => $data['Apellidos'].', '.$data['Nombres'],
                    'Visitas' => 0,
                    'EnLinea' => 0,
                    'FueraLlamada' => 0
                );
        } 
    } else {
        $arregloResultado = '';
    }
    
    return $arregloResultado;
}

function consultaVisitasGeoOperador($mesVisita){
    global $con;
    
    $sql = "SELECT d.Gestor, count(*) AS 'Cantidad'
            FROM tblventa v
            INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
            INNER JOIN tblgeografico g ON c.IdGeografico = g.IdGeografico
            INNER JOIN tbltmpdirecciones d ON c.IdDireccion = d.IdDireccion
            WHERE v.mesVisita = '".$mesVisita."'
            AND c.IdDireccion NOT IN (0)
            AND v.TipoVenta = 'RE'
            AND CCOriginal NOT IN (512, 511)
            GROUP BY d.Gestor";
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    
    if($row_cnt > 0){
        while($data = $resultado->fetch_assoc()){
            $arregloResultado[] = $data;
        } 
    } else {
        $arregloResultado = '';
    }
    
    return $arregloResultado;
    
}

function consultaVisitasGeoOperadorEnLinea($mesVisita){
    global $con;
    
    $sql = "SELECT d.Gestor, count(*) AS 'Cantidad'
            FROM tblventa v
            INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
            INNER JOIN tblgeografico g ON c.IdGeografico = g.IdGeografico
            INNER JOIN tbltmpdirecciones d ON c.IdDireccion = d.IdDireccion
            WHERE v.mesVisita = '".$mesVisita."'
            AND c.IdDireccion NOT IN (0)
            AND v.TipoVenta = 'RE'
            AND Busqueda = 'En Linea'
            GROUP BY d.Gestor";
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    
    if($row_cnt > 0){
        while($data = $resultado->fetch_assoc()){
            $arregloResultado[] = $data;
        } 
    } else {
        $arregloResultado = '';
    }
    
    return $arregloResultado;    
}

function consultaVisitasGeoOperadorFueraLlamada($mesVisita){
    global $con;
    
    $sql = "SELECT d.Gestor, count(*) AS 'Cantidad'
            FROM tblventa v
            INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
            INNER JOIN tblgeografico g ON c.IdGeografico = g.IdGeografico
            INNER JOIN tbltmpdirecciones d ON c.IdDireccion = d.IdDireccion
            WHERE v.mesVisita = '".$mesVisita."'
            AND c.IdDireccion NOT IN (0)
            AND v.TipoVenta = 'RE'
			AND Busqueda = 'Fuera de la llamada'
            GROUP BY d.Gestor";
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    
    if($row_cnt > 0){
        while($data = $resultado->fetch_assoc()){
            $arregloResultado[] = $data;
        } 
    } else {
        $arregloResultado = '';
    }
    
    return $arregloResultado; 
}