<?php

require_once '../config/db.php';
require_once '../config/conexion.php';

$json = file_get_contents('php://input');
$data = json_decode($json);

$fechadiahoy= $data->mescancelaciones;

$delegaciones = array(
    array('Id' =>150, 'Titulo'=>'SURCO', 'Delegado'=>'B. MURGA'),
    array('Id' =>151, 'Titulo'=>'LIMA SUR', 'Delegado'=>'H. VIGO'),     
    array('Id' =>152, 'Titulo'=>'LIMA ESTE', 'Delegado'=>'C. CUNEO'), 
    array('Id' =>153, 'Titulo'=>'LIMA CENTRO', 'Delegado'=>'C. ALMEIDA'), 
    array('Id' =>154, 'Titulo'=>'MIRAFLORES', 'Delegado'=>'D. ADELL'), 
    array('Id' =>155, 'Titulo'=>'LIMA NORTE 1', 'Delegado'=>'F. VERA'),     
    array('Id' =>156, 'Titulo'=>'LIMA OESTE', 'Delegado'=>'J. TORREGROSA'),
    array('Id' =>157, 'Titulo'=>'LA MOLINA', 'Delegado'=>'J. UGAZ'),
    array('Id' =>158, 'Titulo'=>'LIMA NORTE 2', 'Delegado'=>'J. BARNUEVO'),
    array('Id' =>159, 'Titulo'=>'LINCE', 'Delegado'=>'J. GOICOCHEA'),
    array('Id' =>120, 'Titulo'=>'TRUJILLO', 'Delegado'=>'J. ROJAS JVD'), 
    array('Id' =>200, 'Titulo'=>'PIURA', 'Delegado'=>'J.VALENCIA JVD'), 
    array('Id' =>41, 'Titulo'=>'AREQUIPA', 'Delegado'=>'C. MOSCOSO'),       
    array('Id' =>511, 'Titulo'=>'TELECIERRE', 'Delegado'=>''), 
    array('Id' =>512, 'Titulo'=>'TELEVENTA', 'Delegado'=>''),
    array('Id' =>599, 'Titulo'=>'FORMACION', 'Delegado'=>''),
    array('Id' =>500, 'Titulo'=>'CENTRAL', 'Delegado'=>'') 
    
);

//var_dump($delegaciones);

$arregloDatos = array();

$totalCancelacionesNoVentas=0;
$totalCancelacionesClienteausente=0;
$totalCancelacionesNodeseaelservicio=0;
$totalCancelacionesLugarenobras=0;
$totalCancelacionesNodisponedetiempo=0;
$totalCancelacionesCobertura=0;
$totalCancelacionesMotivosEconomicos=0;
$totalCancelacionesMotivosPersonales=0;
$totalCancelacionesRetrasoTecnico=0;
$totalInstalacionesTEC=0;
$totalInstalacionesDEL=0;
$totalRepercusion=0;

$arregloCancelacionesNoVentas=consultaCancelacionesNoVentas();
$arregloCancelacionesClienteausente=consultaCancelacionesClienteausente();
$arregloCancelacionesNodeseaelservicio=consultaCancelacionesNodeseaelservicio();
$arregloCancelacionesLugarenobras=consultaCancelacionesLugarenobras();
$arregloCancelacionesNodisponedetiempo=consultaCancelacionesNodisponedetiempo();
$arregloCancelacionesCobertura=consultaCancelacionesCobertura();
$arregloCancelacionesMotivosEconomicos=consultaCancelacionesMotivosEconomicos();
$arregloCancelacionesMotivosPersonales=consultaCancelacionesMotivosPersonales();
$arregloCancelacionesRetrasoTecnico=consultaCancelacionesRetrasoTecnico();
$arregloInstalacionesTEC=consultaInstalacionesTEC();
$arregloInstalacionesDEL=consultaInstalacionesDEL();


for($i=0; $i<count($delegaciones); $i++){
    
$delegacion = $delegaciones[$i]['Id'];
$cantidadCancelacionesNoVentas = cantidadCanceladas($delegacion, $arregloCancelacionesNoVentas);
$cantidadCancelacionesClienteausente=cantidadCanceladas($delegacion, $arregloCancelacionesClienteausente);
$cantidadCancelacionesNodeseaelservicio=cantidadCanceladas($delegacion, $arregloCancelacionesNodeseaelservicio);
$cantidadCancelacionesLugarenobras=cantidadCanceladas($delegacion, $arregloCancelacionesLugarenobras);
$cantidadCancelacionesNodisponedetiempo=cantidadCanceladas($delegacion, $arregloCancelacionesNodisponedetiempo);
$cantidadCancelacionesCobertura=cantidadCanceladas($delegacion, $arregloCancelacionesCobertura);
$cantidadCancelacionesMotivosEconomicos=cantidadCanceladas($delegacion, $arregloCancelacionesMotivosEconomicos);
$cantidadCancelacionesMotivosPersonales=cantidadCanceladas($delegacion, $arregloCancelacionesMotivosPersonales);
$cantidadCancelacionesRetrasoTecnico=cantidadCanceladas($delegacion, $arregloCancelacionesRetrasoTecnico);
$cantidadInstalacionesTEC=cantidadCanceladas($delegacion,$arregloInstalacionesTEC);
$cantidadInstalacionesDEL=cantidadCanceladas($delegacion,$arregloInstalacionesDEL);
$cantidadTotalRepercusion=($cantidadCancelacionesNoVentas+$cantidadCancelacionesClienteausente+$cantidadCancelacionesNodeseaelservicio+$cantidadCancelacionesLugarenobras+$cantidadCancelacionesNodisponedetiempo+$cantidadCancelacionesCobertura+$cantidadCancelacionesMotivosEconomicos+$cantidadCancelacionesMotivosPersonales+$cantidadCancelacionesRetrasoTecnico);
$porcentajeCancelaciones=porcentaje($cantidadTotalRepercusion, ($cantidadInstalacionesTEC+$cantidadTotalRepercusion));
    
$totalCancelacionesNoVentas += $cantidadCancelacionesNoVentas;
$totalCancelacionesClienteausente+= $cantidadCancelacionesClienteausente;
$totalCancelacionesNodeseaelservicio+= $cantidadCancelacionesNodeseaelservicio;
$totalCancelacionesLugarenobras+= $cantidadCancelacionesLugarenobras;
$totalCancelacionesNodisponedetiempo+= $cantidadCancelacionesNodisponedetiempo;
$totalCancelacionesCobertura+= $cantidadCancelacionesCobertura;
$totalCancelacionesMotivosEconomicos+= $cantidadCancelacionesMotivosEconomicos;
$totalCancelacionesMotivosPersonales+= $cantidadCancelacionesMotivosPersonales;
$totalCancelacionesRetrasoTecnico+= $cantidadCancelacionesRetrasoTecnico;
$totalInstalacionesTEC+=$cantidadInstalacionesTEC;
$totalInstalacionesDEL+=$cantidadInstalacionesDEL;
$totalRepercusion+=$cantidadTotalRepercusion;


$arregloDatos[$i] = array(
'Delegacion' => $delegaciones[$i],
'CancelacionesNoVentas' => $cantidadCancelacionesNoVentas,
'CancelacionesClienteausente'=>$cantidadCancelacionesClienteausente,
'CancelacionesNodeseaelservicio'=>$cantidadCancelacionesNodeseaelservicio,
'CancelacionesLugarenobras'=>$cantidadCancelacionesLugarenobras,
'CancelacionesNodisponedetiempo'=>$cantidadCancelacionesNodisponedetiempo,
'CancelacionesCobertura'=>$cantidadCancelacionesCobertura,
'CancelacionesMotivosEconomicos'=>$cantidadCancelacionesMotivosEconomicos,
'CancelacionesMotivosPersonales'=>$cantidadCancelacionesMotivosPersonales,
'CancelacionesRetrasoTecnico'=>$cantidadCancelacionesRetrasoTecnico,
'InstalacionesTEC'=>$cantidadInstalacionesTEC,
'InstalacionesDEL'=>$cantidadInstalacionesDEL,
'PorcentajeCancelaciones'=>$porcentajeCancelaciones,
'TotalRepercusionxCC'=>$cantidadTotalRepercusion
        );
}

$totalporcentajeCancelaciones=porcentaje($totalRepercusion, ($totalInstalacionesTEC+$totalRepercusion));

$arregloDatos['Totales'] = array(
'totalCancelacionesNoVentas' => $totalCancelacionesNoVentas,
'totalCancelacionesClienteausente'=>$totalCancelacionesClienteausente,
'totalCancelacionesNodeseaelservicio'=>$totalCancelacionesNodeseaelservicio,
'totalCancelacionesLugarenobras'=>$totalCancelacionesLugarenobras,
'totalCancelacionesNodisponedetiempo'=>$totalCancelacionesNodisponedetiempo,
'totalCancelacionesCobertura'=>$totalCancelacionesCobertura,
'totalCancelacionesMotivosEconomicos'=>$totalCancelacionesMotivosEconomicos,
'totalCancelacionesMotivosPersonales'=>$totalCancelacionesMotivosPersonales,
'totalCancelacionesRetrasoTecnico'=>$totalCancelacionesRetrasoTecnico,
'totalInstalacionesTEC'=>$totalInstalacionesTEC,
'totalInstalacionesDEL'=>$totalInstalacionesDEL,
'totalPorcentajeCancelaciones'=>$totalporcentajeCancelaciones,
'totalRepercusion'=>$totalRepercusion
);

echo json_encode($arregloDatos);


function consultaCancelacionesNoVentas(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT h.CC, count(h.IdAgendaHist) as TotalAgendaHist  FROM tblagendahist h  where DATE_FORMAT(h.FechaHoraREG,  '%b-%Y')='".$fechadiahoy."' and h.Repercusion='Noventa' and (h.EstadoVenta='Cancelada' or h.EstadoVenta='Inviable')
    GROUP BY h.CC";
    $resultado = $con->query($sql);
    while($canceladas = $resultado->fetch_assoc()){
        $data[] = $canceladas;
    }
    
    return $data;
}

function consultaCancelacionesClienteausente(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT h.CC, count(h.IdAgendaHist) as TotalAgendaHist  FROM tblagendahist h  where DATE_FORMAT(h.FechaHoraREG,  '%b-%Y')='".$fechadiahoy."' and h.Repercusion='Clienteausente' and (h.EstadoVenta='Cancelada' or h.EstadoVenta='Inviable')
    GROUP BY h.CC";
    $resultado = $con->query($sql);
    while($canceladas = $resultado->fetch_assoc()){
        $data[] = $canceladas;
    }
    
    return $data;
}

function consultaCancelacionesNodeseaelservicio(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT h.CC, count(h.IdAgendaHist) as TotalAgendaHist  FROM tblagendahist h  where DATE_FORMAT(h.FechaHoraREG,  '%b-%Y')='".$fechadiahoy."' and h.Repercusion='Nodeseaelservicio' and (h.EstadoVenta='Cancelada' or h.EstadoVenta='Inviable')
    GROUP BY h.CC";
    $resultado = $con->query($sql);
    while($canceladas = $resultado->fetch_assoc()){
        $data[] = $canceladas;
    }
    
    return $data;
}
function consultaCancelacionesLugarenobras(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT h.CC, count(h.IdAgendaHist) as TotalAgendaHist  FROM tblagendahist h  where DATE_FORMAT(h.FechaHoraREG,  '%b-%Y')='".$fechadiahoy."' and h.Repercusion='Lugarenobras' and (h.EstadoVenta='Cancelada' or h.EstadoVenta='Inviable')
    GROUP BY h.CC";
    $resultado = $con->query($sql);
    while($canceladas = $resultado->fetch_assoc()){
        $data[] = $canceladas;
    }
    
    return $data;
}
function consultaCancelacionesNodisponedetiempo(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT h.CC, count(h.IdAgendaHist) as TotalAgendaHist  FROM tblagendahist h  where DATE_FORMAT(h.FechaHoraREG,  '%b-%Y')='".$fechadiahoy."' and h.Repercusion='Nodisponedetiempo' and (h.EstadoVenta='Cancelada' or h.EstadoVenta='Inviable')
    GROUP BY h.CC";
    $resultado = $con->query($sql);
    while($canceladas = $resultado->fetch_assoc()){
        $data[] = $canceladas;
    }
    
    return $data;
}
function consultaCancelacionesCobertura(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT h.CC, count(h.IdAgendaHist) as TotalAgendaHist  FROM tblagendahist h  where DATE_FORMAT(h.FechaHoraREG,  '%b-%Y')='".$fechadiahoy."' and h.Repercusion='Cobertura' and (h.EstadoVenta='Cancelada' or h.EstadoVenta='Inviable')
    GROUP BY h.CC";
    $resultado = $con->query($sql);
    while($canceladas = $resultado->fetch_assoc()){
        $data[] = $canceladas;
    }
    
    return $data;
}
function consultaCancelacionesMotivosEconomicos(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT h.CC, count(h.IdAgendaHist) as TotalAgendaHist  FROM tblagendahist h  where DATE_FORMAT(h.FechaHoraREG,  '%b-%Y')='".$fechadiahoy."' and h.Repercusion='MotivosEconomicos' and (h.EstadoVenta='Cancelada' or h.EstadoVenta='Inviable')
    GROUP BY h.CC";
    $resultado = $con->query($sql);
    while($canceladas = $resultado->fetch_assoc()){
        $data[] = $canceladas;
    }
    
    return $data;
}
function consultaCancelacionesMotivosPersonales(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT h.CC, count(h.IdAgendaHist) as TotalAgendaHist  FROM tblagendahist h  where DATE_FORMAT(h.FechaHoraREG,  '%b-%Y')='".$fechadiahoy."' and h.Repercusion='MotivosPersonales' and (h.EstadoVenta='Cancelada' or h.EstadoVenta='Inviable')
    GROUP BY h.CC";
    $resultado = $con->query($sql);
    while($canceladas = $resultado->fetch_assoc()){
        $data[] = $canceladas;
    }
    
    return $data;
}
function consultaCancelacionesRetrasoTecnico(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT h.CC, count(h.IdAgendaHist) as TotalAgendaHist  FROM tblagendahist h  where DATE_FORMAT(h.FechaHoraREG,  '%b-%Y')='".$fechadiahoy."' and h.Repercusion='RetrasoTecnico' and (h.EstadoVenta='Cancelada' or h.EstadoVenta='Inviable')
    GROUP BY h.CC";
    $resultado = $con->query($sql);
    while($canceladas = $resultado->fetch_assoc()){
        $data[] = $canceladas;
    }
    
    return $data;
}
function consultaInstalacionesTEC(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT v.CC,count(v.IdVenta) as TotalAgendaHist FROM tblventa v inner join tblagenda a on a.IdVenta=v.IdVenta where v.N590='".$fechadiahoy."' and a.InstaladoX='TEC' and (v.EstadoVenta='Instalada' OR v.EstadoVenta='InstaladaDEL' OR v.EstadoVenta = 'NoDoc' OR v.EstadoVenta = 'DocEnvi' OR v.EstadoVenta = 'PorFacturar' OR v.EstadoVenta = 'Incidencia' OR v.EstadoVenta = 'IncidenciaGestValija' OR v.EstadoVenta = 'IncidenciaGestCorreo' OR v.EstadoVenta = 'Facturada') 
    GROUP BY v.CC";
    $resultado = $con->query($sql);
    while($instaladas = $resultado->fetch_assoc()){
        $data[] = $instaladas;
    }
    
    return $data;
}
function consultaInstalacionesDEL(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT v.CC,count(v.IdVenta) as TotalAgendaHist FROM tblventa v inner join tblagenda a on a.IdVenta=v.IdVenta where v.N590='".$fechadiahoy."' and a.InstaladoX='DEL' and (v.EstadoVenta='Instalada' OR v.EstadoVenta='InstaladaDEL' OR v.EstadoVenta = 'NoDoc' OR v.EstadoVenta = 'DocEnvi' OR v.EstadoVenta = 'PorFacturar' OR v.EstadoVenta = 'Incidencia' OR v.EstadoVenta = 'IncidenciaGestValija' OR v.EstadoVenta = 'IncidenciaGestCorreo' OR v.EstadoVenta = 'Facturada') 
    GROUP BY v.CC";
    $resultado = $con->query($sql);
    while($instaladas = $resultado->fetch_assoc()){
        $data[] = $instaladas;
    }
    
    return $data;
}

function cantidadCanceladas($delegacion, $arregloCancelacionesTotales){
    //echo json_encode($arregloCancelacionesTotales);
    $cantCanceladas = 0;
    for($i=0; $i<count($arregloCancelacionesTotales); $i++){
        if ($delegacion == $arregloCancelacionesTotales[$i]['CC']){
            //echo $arregloCancelacionesTotales[$i]['visitas'];
            $cantCanceladas =  $arregloCancelacionesTotales[$i]['TotalAgendaHist'];
            break;
        } 
    }
    return $cantCanceladas;
}

function porcentaje($parte, $total){
    if($total > 0){
        return round(($parte/$total)*100);
    } else {
        return 0;
    }
    
}


?>