<?php
// require "bd/Conection.php";
// require $_SERVER['DOCUMENT_ROOT']."/trabajo/bd/Conection.php";

//use PHP_CodeSniffer\Standards\Squiz\Sniffs\Strings\EchoedStringsSniff;
//use PhpParser\Node\Stmt\TryCatch;

/**
 * 
 */
class ConexionTelecierre
{


	private $db;
	private $usuario;

	function __construct()
	{

		$this->db =  Database::connect();

		// $this->db = new mysqli('localhost','root','','prueba');

	}

	public function SelectIdDepartamental($idgeografico){

		$query = $this->db->prepare("SELECT p.IdDepartamental FROM dbVENTAS.tblgeografico g
INNER JOIN dbVENTAS.tbldistrital d on d.CodUbigeoReniec=g.CodUbigeoReniec
INNER JOIN dbVENTAS.tblprovincial p on p.IdProvincial=d.IdProvincial
WHERE g.IdGeografico=?");
        $query->execute(array($idgeografico));

        $respuesta = $query->rowCount();
        if($respuesta>0){
            $fila = $query->fetch(PDO::FETCH_ASSOC);
            if($fila['IdDepartamental']==7){
              $fila= array('IdDepartamental'=>'15');  
            }
        }else{
            $fila= array('IdDepartamental'=>'15');
        }
		return $fila;

	}



	/* INSERTAR DOCUMENTOS*/ 

	public function insertarDocumento($lbltipodoc,$lbldocumento,$fecharegistro){

        if(empty($lbltipodoc) && empty($lbldocumento)){
            return 0;
        }else{
            try {
        
			$query = $this->db->prepare("INSERT INTO dbVENTAS.tbldocumento(TipoDocumento, Documento, FechaHoraREG) VALUES (?,?,?)");
            $query->execute(array($lbltipodoc,$lbldocumento,$fecharegistro));

			$idDocumento = $this->db->lastInsertId(); 

			$respuesta = $idDocumento;
			
            } catch (\Exception $e) {
                $respuesta = array(
                    'respuesta' => 'error'
                );
            }
        
            return $respuesta;
        }

	}

	/* ACTUALIZAR DOCUMENTOS */ 

	public function actualizarDocumento($lblIdDocTV,$lbltipodoc,$lbldocumento){
		try {
			
			$query = $this->db->prepare("UPDATE tbldocumento SET TipoDocumento = ? , Documento = ? WHERE IdDoc = ?");
            $query->execute(array($lbltipodoc,$lbldocumento,$lblIdDocTV));
			
			$rows = $query->rowCount();

            if($rows > 0){
                $respuesta = 'exito';
            } else {
                $respuesta = 'sincambios';
            }
			
		} catch (\Exception $e) {
			$respuesta = 'error';
        }

		return $respuesta;	
	}
	public function actualizarClienteDoc($IdDocTC,$lblidcliente){
		try {
			
			$query = $this->db->prepare("UPDATE dbVENTAS.tblcliente SET IdDocTC=? WHERE IdCliente = ?");
            $query->execute(array($IdDocTC,$lblidcliente));
			
			$rows = $query->rowCount();

            if ($rows > 0) {
                $respuesta = array(
                    'respuesta' => 'exito',
                    'id_actualizado' => $lblidcliente,
                    'tipo' => 'cliente'
                );
            } else {
                $respuesta = array(
                    'respuesta' => 'nada',
                    'tipo' => 'cliente'
                );
            }			
			
		} catch (\Exception $e) {
			$respuesta = array(
                'respuesta' => 'error'
            );
        }

		return $respuesta;	
	}


	/* LISTAR SCORING */
	public function ListarScoring($valcodigoOperacionScoring)
	{
		
		$query = $this->db->prepare("SELECT t.IdConsultaScoring,t.PerfilScoring,t.Accion,t.TipoDocumento,t.NumeroDocumento FROM dbVENTAS.tbltmpscoring t WHERE t.NumeroOperacion =?");
        $query->execute(array($valcodigoOperacionScoring));		

		$retorno = [];
		$i = 0;
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[$i] = $fila;
			$i++;
		}

		return $retorno;
		
	}
	///......-------......./////

    public function actualizarTelecierre(
            $lblidagenda,$instaladoXAgenda,$tecnicoAgenda,$fechaAgenda,$horaAgenda,$comentarioAgenda,$repercucionAgenda,
            $ediventa,
            $catgventa,
            $lblestadoventa,
            $lbl590,
            $lblestadotelecierre,
            $lbltipoventatc,
            $lblmovivonoventatc,
            $lblcctc,
            $lblgestortc,
            $lblpreciokittc,
            $lbltotalextratc,
            $ingresokit,
            $ingresoextras,
            $ingresototal,
            $lblextraautorizadotc,
            $lblmesesautorizadostc,
            $lblformadepagotc,
            $lblPAItc,
            $lblresumenventatc,
            $lblcomentariotc,
            $lblcomentariocancelacion,
            $lblestadovisita,
            $lblsco,
            $lblcompetencia,
            $lblfrellamadaTC,
            $lblhrellamadaTC,
            $tipokittc,
            $cantidadextratc,
            $lblformapagocuota,
            $lblTotalCuotaMonitoreo,
            $HidDesc3meses,
            $HidpagoAdelantado,
            $lblcantidadregalotc,
            $hidden_visitadox,
            $hidden_acuerdocomercialinst,
            $ultimaestado,
            $fecharegistro,
            $gestor,
            $FechaTCFI,
            $IdConsultaScoring,
            $lblnivel1,
            $lblnivel2,
            $lbltipoaccion,
            $lblvueltas,
            $lblfechaultimagestion,
            $tcfechagestion,
            $lblIteraccionAgenda,
            $lbldistrito,
            $prospectoAbierto,
            $fechaProspectoAbierto=null,
            $IdTCTVgestion=null
            ){
                
 
  if($lbltipoaccion=='gestion'){

 
    if($lblestadoventa=='PendienteAgenda' || $lblestadoventa=='PendienteData' || $lblestadoventa=='AgendadaTEC'){
        if ($FechaTCFI == ''){
            $FechaTCFI=date("Y-m-d H:i:s");
        }else{
            $FechaTCFI=$FechaTCFI;
        }
    }
    
    if($lblestadotelecierre=="Online"){
        if($ultimaestado=="Cancelada" || $ultimaestado=="Inviable" || $ultimaestado=="Ilocalizable" || $ultimaestado=="NoAgendada" || $lblIteraccionAgenda==0){
            if($lblestadoventa=='PendienteAgenda' || $lblestadoventa=='PendienteData' || $lblestadoventa=='AgendadaTEC'){
                $lblIteraccionAgenda++;
                // registrarAgendaReporte($ediventa);
                $fechaprogramacion=$fechaAgenda.' '.$horaAgenda;
                $query = $this->db->prepare("INSERT INTO tblagendareporte(IdVenta, FechaVenta, Matricula, CC, Vueltas, IdGeografico,FechaProgramacion) VALUES (?,?,?,?,?,?,?)");
		        $query->execute(array($ediventa,$fecharegistro,$lblgestortc,$lblcctc,$lblIteraccionAgenda,$lbldistrito,$fechaprogramacion));
                
            }
        }
    }    
    


          $FechaProspectoAbierto = NULL;
    
		  if($prospectoAbierto == NULL || $prospectoAbierto == ''){
		      if($lblestadotelecierre == 'ProspectoAbierto'){
    		        $prospectoAbierto = 'SI';
    		        $FechaProspectoAbierto = date("Y-m-d H:i:s");
		      } else {
    		      if($prospectoAbierto != '' || $prospectoAbierto != NULL){
    		          $FechaProspectoAbierto = $fechaProspectoAbierto;
    		      } else {
        		      $prospectoAbierto = NULL;
        		      $FechaProspectoAbierto = NULL;
    		      }
		      }
		  } else {

		      if($prospectoAbierto != '' || $prospectoAbierto != NULL){
    		          $FechaProspectoAbierto = $fechaProspectoAbierto;
		      } else {
    		      $prospectoAbierto = NULL;
    		      $FechaProspectoAbierto = NULL;
		      }
		  }
    
    try{

		  $query = $this->db->prepare("UPDATE tblventa SET CategoriaVenta=?, EstadoVenta=?, N590=?, EstadoTelecierre=?, TCTipoVenta=?, TCMotivoNoVenta=?, CC=?, TCGestor=?, PrecioKit=?, TotalExtra=?, IngresoKIT=?, IngresoExtras=?, IngresoTotal=?, ExtraAutorizado=?, MesesAutorizado=?, FormaPago=?, PAI=?, ResumenVenta=?, TCComentario=?, EstadoVisita=?, TCScoring=?, TCCompetencia=?, TCFechaRellamada=?, TCHoraRellamada=?, TipoKIT=?,CantidadExtras=?, FormaPagoCuota=?, TotalCuotaMonitoreo=?, DescMeses=?, pagoAdelantado=?, CantidadRegalo=?, TCVisitado=?,FechaTCFI=?,IteraccionAgenda=?,IdConsultaScoringTCTV=?,Nivel_1=?,Nivel_2=?,Vueltas=?,FechaUltimaGestion=?,FechaGestionTC=?,TCAcuerdoComercial=?,ComentarioCancelacion=?, ProspectoAbierto=?, FechaProspectoAbierto=?,IdTCTVgestion=? WHERE IdVenta=?");
          $query->execute(array($catgventa, $lblestadoventa, $lbl590, $lblestadotelecierre, $lbltipoventatc, $lblmovivonoventatc, $lblcctc, $lblgestortc, $lblpreciokittc, $lbltotalextratc, $ingresokit, $ingresoextras, $ingresototal, $lblextraautorizadotc, $lblmesesautorizadostc, $lblformadepagotc, $lblPAItc, $lblresumenventatc, $lblcomentariotc, $lblestadovisita, $lblsco, $lblcompetencia, $lblfrellamadaTC, $lblhrellamadaTC, $tipokittc, $cantidadextratc, $lblformapagocuota, $lblTotalCuotaMonitoreo, $HidDesc3meses, $HidpagoAdelantado, $lblcantidadregalotc, $hidden_visitadox,$FechaTCFI,$lblIteraccionAgenda,$IdConsultaScoring,$lblnivel1,$lblnivel2,$lblvueltas,$lblfechaultimagestion,$tcfechagestion,$hidden_acuerdocomercialinst, $lblcomentariocancelacion,$prospectoAbierto,$FechaProspectoAbierto,$IdTCTVgestion,$ediventa));
          $rows = $query->rowCount();
            if($rows > 0){
                $respuesta = 'exito';

	  		    if($lblestadoventa=='AgendadaTEC'){
	  		        
    			  $queryActualizarAgenda = $this->db->prepare("UPDATE dbVENTAS.tblagenda SET FechaInst=?, HoraInst=?, InstaladoX=?, MatriculaTec=?, Comentario=?, Repercusion=? WHERE IdAgenda=?");
                  $queryActualizarAgenda->execute(array($fechaAgenda,$horaAgenda,$instaladoXAgenda,$tecnicoAgenda,$comentarioAgenda,$repercucionAgenda,$lblidagenda));
                  $filaAfectadaActualizarAgenda = $queryActualizarAgenda->rowCount();

    			  $queryInsertarVenta = $this->db->prepare("INSERT INTO dbVENTAS.tblagendahist(IdAgenda, IdVenta,Comentario, FechaHoraREG,GestorAgenda,EstadoVenta,FechaInst,HoraInst,InstaladoX,MatriculaTec) VALUES (?,?,?,?,?,?,?,?,?,?)");
                  $queryInsertarVenta->execute(array($lblidagenda,$ediventa,$comentarioAgenda,$fecharegistro,$gestor,$lblestadoventa,$fechaAgenda,$horaAgenda,$instaladoXAgenda,$tecnicoAgenda));
                  
                  
                  
		        }
                
            } else {
                $respuesta = 'sincambios';
            }
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
 
 
     
 }else if($lbltipoaccion=='informacion'){

    try{

		$query = $this->db->prepare("UPDATE tblventa SET CategoriaVenta=?, EstadoVenta=?, N590=?, TCTipoVenta=?, CC=?, TCGestor=?, PrecioKit=?, TotalExtra=?, IngresoKIT=?, IngresoExtras=?, IngresoTotal=?, ExtraAutorizado=?, MesesAutorizado=?, FormaPago=?, PAI=?, ResumenVenta=?, TCComentario=?, EstadoVisita=?, TCScoring=?, TipoKIT=?,CantidadExtras=?, FormaPagoCuota=?, TotalCuotaMonitoreo=?, DescMeses=?, pagoAdelantado=?, CantidadRegalo=?, TCVisitado=?,IdConsultaScoringTCTV=?,TCAcuerdoComercial=?,ComentarioCancelacion=? WHERE IdVenta=?");
        $query->execute(array($catgventa, $lblestadoventa, $lbl590, $lbltipoventatc, $lblcctc, $lblgestortc, $lblpreciokittc, $lbltotalextratc, $ingresokit, $ingresoextras, $ingresototal, $lblextraautorizadotc, $lblmesesautorizadostc, $lblformadepagotc, $lblPAItc, $lblresumenventatc, $lblcomentariotc, $lblestadovisita, $lblsco, $tipokittc, $cantidadextratc, $lblformapagocuota, $lblTotalCuotaMonitoreo, $HidDesc3meses, $HidpagoAdelantado, $lblcantidadregalotc, $hidden_visitadox,$IdConsultaScoring,$hidden_acuerdocomercialinst,$lblcomentariocancelacion, $ediventa));

        $rows = $query->rowCount();
        if($rows > 0){
            $respuesta = 'exito';
        } else {
            $respuesta = 'sincambios';
        }
    } catch (\Exception $e) {
        $respuesta = 'error';
    }     
     
     
 }else{
      $respuesta = 'error';
  }
 
    return $respuesta;               
        
                
        
    }

    public function insertTelecierreHistorico_v2($ediventa,$lblestadovisita,$lblestadoventa,$lblestadotelecierre,$lbltipoventatc,$lblmovivonoventatc,$lblcctc,$lblgestortc,$lblpreciokittc,$lbltotalextratc,$lblresumenventatc,$lblextraautorizadotc,$lblformadepagotc,$lblmesesautorizadostc,$lblPAItc,$lblcomentariotc,$lbl590,$gestor,$fecharegistro,$lbldc,$hidden_visitadox,$hidden_acuerdocomercialinst,$lblsco,$lblcompetencia,$lblnivel1,$lblnivel2,$lbltipoaccion,$lblvueltas,$lblfrellamadaTC,$lblhrellamadaTC,$lblcomentariocancelacion)
    {
	    try {

			$query = $this->db->prepare("INSERT INTO dbVENTAS.tbltelecierrehist(IdVenta, EstadoVisita, EstadoVenta, EstadoTelecierre, TCTipoVenta, TCMotivoNoVenta, TCCC, TCGestor, TCPrecioKIT, TCTotalExtra, TCResumenVenta, TCExtraAutorizado, TCFormaPago, TCMesesAutorizado, TCPAI, TCComentario, TC590, GestorOrigen, FechaHoraREG, CCOriginal, TCVisitado, TCScoring, TCCompetencia,Gestion,Nivel_1,Nivel_2,Vueltas,TCFechaRellamada,TCHoraRellamada,TCAcuerdoComercial,ComentarioCancelacion) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?)");
			$query->execute(array($ediventa, $lblestadovisita, $lblestadoventa, $lblestadotelecierre, $lbltipoventatc, $lblmovivonoventatc, $lblcctc, $lblgestortc, $lblpreciokittc, $lbltotalextratc, $lblresumenventatc, $lblextraautorizadotc, $lblformadepagotc, $lblmesesautorizadostc, $lblPAItc, $lblcomentariotc, $lbl590, $gestor, $fecharegistro, $lbldc, $hidden_visitadox, $lblsco, $lblcompetencia,$lbltipoaccion,$lblnivel1,$lblnivel2,$lblvueltas,$lblfrellamadaTC,$lblhrellamadaTC,$hidden_acuerdocomercialinst,$lblcomentariocancelacion));
			$lastInsertId = $this->db->lastInsertId(); 

			$respuesta = $lastInsertId;
		
		} catch (\Exception $e) {
			$respuesta = array(
                'respuesta' => 'error'
            );
        }

		return $respuesta;        
    }
    


	public function UltimoEstadoVenta($ediventa){

		$query = $this->db->prepare("SELECT EstadoVenta FROM tblventa WHERE IdVenta = ?");
		$query->execute(array($ediventa));

		$fila = $query->fetch(PDO::FETCH_ASSOC);

		return $fila['EstadoVenta'];

	}

	public function totalRegistros($ediventa){

		$query = $this->db->prepare("SELECT count(*) totalRegistros FROM tbltelecierrehist WHERE IdVenta = ?");
		$query->execute(array($ediventa));

		$fila = $query->fetch(PDO::FETCH_ASSOC);

		return $fila['totalRegistros'];

	}


	public function consultaTelecierre($ediventa){
    
        $arrayactual = null;

        $query = $this->db->prepare("SELECT 
        v.CategoriaVenta, 
        v.EstadoVenta, 
        v.N590,
        v.EstadoTelecierre,
        v.TCTipoVenta,
        v.TCMotivoNoVenta,
        v.CC,
        v.TCGestor,
        v.PrecioKit,
        v.TotalExtra,
        v.IngresoKIT,
        v.IngresoExtras,
        v.IngresoTotal,
        v.ExtraAutorizado,
        v.MesesAutorizado,
        v.FormaPago,
        v.PAI,
        v.ResumenVenta,
        v.TCComentario,
        v.EstadoVisita,
        v.TCVisitado,
        v.TCScoring,
        v.TCCompetencia
        FROM tblventa v
        WHERE v.IdVenta= ?");
        
        $query->execute(array($ediventa));
        
		$arrayactual = $query->fetch(PDO::FETCH_ASSOC);
        // while ($tv = $resultadoTeleventa->fetch_assoc()){
        //     $arrayactual = array(
        //             'CategoriaVenta' => $tv['CategoriaVenta'],
        //             'EstadoVenta' => $tv['EstadoVenta'],
        //             'N590' => $tv['N590'],
        //             'EstadoTelecierre' => $tv['EstadoTelecierre'],
        //             'TCTipoVenta' => $tv['TCTipoVenta'],
        //             'TCMotivoNoVenta' => $tv['TCMotivoNoVenta'],
        //             'CC' => $tv['CC'],
        //             'TCGestor' => $tv['TCGestor'],
        //             'PrecioKit' => $tv['PrecioKit'],
        //             'TotalExtra' => $tv['TotalExtra'],
        //             'IngresoKIT' => $tv['IngresoKIT'],
        //             'IngresoExtras' => $tv['IngresoExtras'],
        //             'IngresoTotal' => $tv['IngresoTotal'],
        //             'ExtraAutorizado' => $tv['ExtraAutorizado'],
        //             'MesesAutorizado' => $tv['MesesAutorizado'],
        //             'FormaPago' => $tv['FormaPago'],
        //             'PAI' => $tv['PAI'],
        //             'ResumenVenta' => $tv['ResumenVenta'],
        //             'TCComentario' => $tv['TCComentario'],
        //             'EstadoVisita' => $tv['EstadoVisita'],
        //             'TCScoring' => $tv['TCScoring'],
        //             'TCCompetencia' => $tv['TCCompetencia'],
        //             'NProspecto' => $tv['NProspecto'],
        //             'NProspectoCC' => $tv['NProspectoCC'],
        //             'MesTeleventa' => $tv['MesTeleventa'],
        //             'LeadID' => $tv['LeadID']
        //         );
        // }
        
        return $arrayactual;
    }
	

    public function registrarInformacionArlo($ediventa,$fecharegistro,$tipocamarakit, $VendidaCamaraExtraInterna, $CantidadCamaraExtraInterna,$PrecioCamaraExtraInterna,$VendidaCamaraExtraExterna,$CantidadCamaraExtraExterna,$PrecioCamaraExtraExterna){


        $query = $this->db->prepare("SELECT TipoCamaraKit,VendidaCamaraInternaExtra,CantidadCamaraInternaExtra,PrecioCamaraInternaExtra,VendidaCamaraExternaExtra,CantidadCamaraExternaExtra,PrecioCamaraExternaExtra FROM tblventainformacionarlo WHERE IdVenta= ?");
        $query->execute(array($ediventa));
        
        $resultado = $query->fetchAll();
        
        $row_cnt=count($resultado);
        
        
        if($row_cnt > 0){

            try{

                $query = $this->db->prepare("UPDATE tblventainformacionarlo SET TipoCamaraKit=?,VendidaCamaraInternaExtra=?,CantidadCamaraInternaExtra=?,PrecioCamaraInternaExtra=?,VendidaCamaraExternaExtra=?,CantidadCamaraExternaExtra=?,PrecioCamaraExternaExtra=? WHERE IdVenta = ?");
                $query->execute(array($tipocamarakit, $VendidaCamaraExtraInterna, $CantidadCamaraExtraInterna,$PrecioCamaraExtraInterna,$VendidaCamaraExtraExterna,$CantidadCamaraExtraExterna,$PrecioCamaraExtraExterna, $ediventa));                
                
                $respuesta = $query->rowCount();
                    
            }catch (\Exception $e) {
                $respuesta = 'error';
            }
            
        } else {
        
            try{

                $query = $this->db->prepare("INSERT INTO tblventainformacionarlo (IdVenta, FechaHoraREG, TipoCamaraKit,VendidaCamaraInternaExtra,CantidadCamaraInternaExtra,PrecioCamaraInternaExtra,VendidaCamaraExternaExtra,CantidadCamaraExternaExtra,PrecioCamaraExternaExtra) VALUES (?,?,?,?,?,?,?,?,?)");
                $query->execute(array($ediventa, $fecharegistro, $tipocamarakit, $VendidaCamaraExtraInterna, $CantidadCamaraExtraInterna,$PrecioCamaraExtraInterna,$VendidaCamaraExtraExterna,$CantidadCamaraExtraExterna,$PrecioCamaraExtraExterna));                
                 
                $respuesta = $this->db->lastInsertId();
                
            }catch (\Exception $e) {
                $respuesta = 'error';
            }
        }
    }


    public function mostarGestorCC()
    {
        $query = $this->db->prepare("SELECT u.IdUsuario,u.Matricula,u.Nombres,u.Apellidos,u.TC,u.RemarketingTC FROM dbUSUARIO.tblusuario u WHERE u.Estado='Activo' and u.CC=511");
        
        $query->execute();

		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
		}
		return $retorno;		
    }

	public function UpdateGestorRMKT($idUsuario,$checked,$tipo)
	{
	    if($tipo=='RemarketingTC'){
	    $sql="UPDATE dbUSUARIO.tblusuario SET RemarketingTC=? WHERE IdUsuario=?";     
	    }else{
	    $sql="UPDATE dbUSUARIO.tblusuario SET TC=? WHERE IdUsuario=?";    
	    }
	    
		$query = $this->db->prepare($sql);
	    $query->execute(array($checked,$idUsuario));
        $retorno = $query->rowCount();

		return $retorno;

	}
	
	
	
	/* INSERTAR TCTVgestion*/ 

	public function insertarTCTVgestion($lbltipoventatc,$vueltas,$ResultadoGestion,$ultimoGestor,$TCMotivoNoVenta=null,$TCCompetencia=null){
		try {
            if($lbltipoventatc=='Telecierre2'){
                $sql="INSERT INTO dbVENTAS.tblTCTVgestion(vueltasTelecierredos, ultimoGestorTelecierredos, ResultadoGestionTelecierredos,SubtipificacionTelecierredos,MotivoSubtipificacionTelecierredos) VALUES (?,?,?,?,?)";

            }else if($lbltipoventatc=='TCRemarketing'){
                $sql="INSERT INTO dbVENTAS.tblTCTVgestion(vueltasTCRemarketing, ultimoGestorTCRemarketing, ResultadoGestionTCRemarketing,SubtipificacionTCRemarketing,MotivoSubtipificacionTCRemarketing) VALUES (?,?,?,?,?)";

            }else{
                $sql="INSERT INTO dbVENTAS.tblTCTVgestion(vueltasTelecierre, ultimoGestorTelecierre, ResultadoGestionTelecierre,SubtipificacionTelecierre,MotivoSubtipificacionTelecierre) VALUES (?,?,?,?,?)";
                
            }
            
			$query = $this->db->prepare($sql);
			$query->execute(array($vueltas,$ultimoGestor,$ResultadoGestion,$TCMotivoNoVenta,$TCCompetencia));
			
			$idDocumento = $this->db->lastInsertId(); 

			$respuesta = $idDocumento;
		
		} catch (\Exception $e) {
			$respuesta = array(
                'respuesta' => 'error'
            );
        }

		return $respuesta;
	}

	public function updateTCTVgestion($lbltipoventatc,$vueltas,$ResultadoGestion,$ultimoGestor,$id,$TCMotivoNoVenta=null,$TCCompetencia=null){

		try {
            
            if($lbltipoventatc=='Telecierre2'){
                $sql="UPDATE dbVENTAS.tblTCTVgestion SET vueltasTelecierredos=?, ultimoGestorTelecierredos=?, ResultadoGestionTelecierredos=?,SubtipificacionTelecierredos=?,MotivoSubtipificacionTelecierredos=? where id=?";

            }else if($lbltipoventatc=='TCRemarketing'){
                $sql="UPDATE dbVENTAS.tblTCTVgestion SET vueltasTCRemarketing=?, ultimoGestorTCRemarketing=?, ResultadoGestionTCRemarketing=?,SubtipificacionTCRemarketing=?,MotivoSubtipificacionTCRemarketing=? where id=?";
                
            }else{
                $sql="UPDATE dbVENTAS.tblTCTVgestion SET vueltasTelecierre=?, ultimoGestorTelecierre=?, ResultadoGestionTelecierre=?,SubtipificacionTelecierre=?,MotivoSubtipificacionTelecierre=? where id=?";
                
            }
            
    		$query = $this->db->prepare($sql);
    	    $query->execute(array($vueltas,$ultimoGestor,$ResultadoGestion,$TCMotivoNoVenta,$TCCompetencia,$id));
            $retorno = $query->rowCount();
    
    		return $retorno;			
			
		
		} catch (\Exception $e) {
			return $respuesta = array(
                'respuesta' => 'error'
            );
        }

		return $respuesta;
	}
	

	public function mostrarTodosTCGestionados($function)
	{
        $new_total_rows = 0;
        $contador=1;
        
        $pagenum=htmlspecialchars(filter_var($function->pagenum, FILTER_SANITIZE_NUMBER_INT));
        $pagesize=htmlspecialchars(filter_var($function->pagesize, FILTER_SANITIZE_NUMBER_INT));
        
        $starts = $pagenum * $pagesize;
        

        $queryexec="SELECT 
IdVenta,
TCGestor,
NombreTC,
Telefonouno,
Gestionable,
Tipificacion,
SubTipificacion,
Competencia,
FechaHoraTransferenciaTC,
FechaPrimerGestion,
TCHoraRellamada,
FechaHoraREG,
FechaUltimaGestion,
TCFechaRellamada,
Vueltas,
EstadoVenta,
FechaVisita,
FVencimientoVisita,
Checkin,
Cliente,
Segmento,
Departamento,
Provincia,
Distrito,
NProspecto,
TipoKIT,
TCComentario,
N590,
FechaInst,
HoraInst,
NContrato,
MatriculaOriginal,
Comercial,
CCOriginal,
MotivoTransferencia,
CC,
TCTipoVenta,
FechaHoraTransferenciaTelecierredos,
vueltasTelecierredos,
FechaHoraTransferenciaTCRemarketing,
vueltasTCRemarketing
FROM tcgestionados";
        $query = $queryexec." LIMIT :starts,:pagesize";


        $where="";
        // filter data.
        if (isset($function->filterscount))
        {
        	$filterscount = htmlspecialchars($function->filterscount);
        			
        	if ($filterscount > 0)
        	{
        		$where = " WHERE (";
        		$tmpdatafield = "";
        		$tmpfilteroperator = "";
        		for ($i=0; $i < $filterscount; $i++)
        		{
        			// get the filter's value.
        			$filtervalue = htmlspecialchars($function->{"filtervalue".$i});
        			// get the filter's condition.
        			$filtercondition =htmlspecialchars($function->{"filtercondition".$i});
        			// get the filter's column.
        			$filterdatafield =htmlspecialchars($function->{"filterdatafield".$i});
        			// get the filter's operator.
        			$filteroperator =htmlspecialchars($function->{"filteroperator".$i});
        					
        			if ($tmpdatafield == "")
        			{
        				$tmpdatafield = $filterdatafield;			
        			}
        			else if ($tmpdatafield <> $filterdatafield)
        			{
        					if ($tmpfilteroperator == 2){
            					$where.= " OR ";
            				}else{ 
            				    $where.= ") AND (";
            				}
        			}
        			else if ($tmpdatafield == $filterdatafield)
        			{
        				    if ($tmpfilteroperator == 0){
            					$where.= " AND ";
            				}else{ 
            				    $where.= " OR ";
            				}	
        			}
        					
        			// build the "WHERE" clause depending on the filter's condition, value and datafield.
        			switch($filtercondition)
        			{
        				case "CONTAINS":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."%'";
        					break;
        				case "DOES_NOT_CONTAIN":
        					$where .= " " . $filterdatafield . " NOT LIKE '%" . $filtervalue ."%'";
        					break;
        				case "EQUAL":
        					$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
        					break;
        				case "NOT_EQUAL":
        					$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN":
        					$where .= " " . $filterdatafield . " > '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN":
        					$where .= " " . $filterdatafield . " < '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ."'";
        					break;
        				case "STARTS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '" . $filtervalue ."%'";
        					break;
        				case "ENDS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."'";
        					break;
        				case "NULL":
        					$where .= " " . $filterdatafield . " IS NULL";
        					break;
        				case "NOT_NULL":
        					$where .= " " . $filterdatafield . " NOT NULL";
        					break;
        				case "GREATER_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ." 00:00:00'";
        					break;
        				case "LESS_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ." 23:59:59'";
        					break;
        					
        					
        			}
        									
        			if ($i == $filterscount - 1){
        				$where.= ")";
        			}
        					
        			$tmpfilteroperator = $filteroperator;
        			$tmpdatafield = $filterdatafield;			
        		}
        		$query = $queryexec." " .$where." LIMIT :starts,:pagesize";	
        		//var_dump($query);
        
        	}
        }
        if (isset($function->sortdatafield)){
        	$sortfield = htmlspecialchars($function->sortdatafield);
        	$sortorder = htmlspecialchars($function->sortorder);
        	$filterscount = htmlspecialchars($function->filterscount);
        	if ($sortorder != '')
        		{
        		if ($filterscount == 0)
        			{
        			if ($sortorder == "desc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}

        			}
        		else
        			{
        			if ($sortorder == "desc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}
        			$query = $queryexec." " .$where.$filterquery;
        			}
        		}
        }



		$result = $this->db->prepare($query); 
        $result->bindParam(':starts', $starts, PDO::PARAM_INT);
        $result->bindParam(':pagesize',$pagesize, PDO::PARAM_INT);		
		$result->execute(); 
		

        $orders = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $orders[] = array(

'IdVenta' => $row['IdVenta'],
'TCGestor' => $row['TCGestor'],
'NombreTC' => $row['NombreTC'],
'Telefonouno' => $row['Telefonouno'],
'Gestionable' => $row['Gestionable'],
'Tipificacion' => $row['Tipificacion'],
'SubTipificacion' => $row['SubTipificacion'],
'Competencia' => $row['Competencia'],
'FechaHoraTransferenciaTC' => $row['FechaHoraTransferenciaTC'],
'FechaPrimerGestion' => $row['FechaPrimerGestion'],
'TCHoraRellamada' => $row['TCHoraRellamada'],
'FechaHoraREG' => $row['FechaHoraREG'],
'FechaUltimaGestion' => $row['FechaUltimaGestion'],
'TCFechaRellamada' => $row['TCFechaRellamada'],
'Vueltas' => $row['Vueltas'],
'EstadoVenta' => $row['EstadoVenta'],
'FechaVisita' => $row['FechaVisita'],
'FVencimientoVisita' => $row['FVencimientoVisita'],
'Checkin' => $row['Checkin'],
'Cliente' => $row['Cliente'],
'Segmento' => $row['Segmento'],
'Departamento' => $row['Departamento'],
'Provincia' => $row['Provincia'],
'Distrito' => $row['Distrito'],
'NProspecto' => $row['NProspecto'],
'TipoKIT' => $row['TipoKIT'],
'TCComentario' => $row['TCComentario'],
'N590' => $row['N590'],
'FechaInst' => $row['FechaInst'],
'HoraInst' => $row['HoraInst'],
'NContrato' => $row['NContrato'],
'MatriculaOriginal' => $row['MatriculaOriginal'],
'Comercial' => $row['Comercial'],
'CCOriginal' => $row['CCOriginal'],
'MotivoTransferencia' => $row['MotivoTransferencia'],
'CC' => $row['CC'],
'TCTipoVenta' => $row['TCTipoVenta'],
'FechaHoraTransferenciaTelecierredos'=> $row['FechaHoraTransferenciaTelecierredos'],
'vueltasTelecierredos'=> $row['vueltasTelecierredos'],
'FechaHoraTransferenciaTCRemarketing'=> $row['FechaHoraTransferenciaTCRemarketing'],
'vueltasTCRemarketing'=> $row['vueltasTCRemarketing']
                	);
$contador++;                	
            
        }
        
	    $query = "SELECT COUNT(*) AS found_rows FROM tcgestionados ".$where;
		$result =  $this->db->prepare($query);
		$result->execute();
		$rows=$result->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['found_rows'];
        if ($new_total_rows > 0) $total_rows = $new_total_rows;	        

        if ($total_rows > 0){
            $data[] = array(
            	'TotalRows' => $total_rows,
            	'Rows' => array_map(null,$orders),
            	'mensaje' => '',
            	'tipo' =>1
            );
            
        } else {
            $data[] = array(
        	'TotalRows' => 0,
        	'Rows' => null,
        	'mensaje' => '<div class="callout bg-gray">
                            <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                       <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                        <br>
            </div>',
        	'tipo' =>0
        	);
        }
        
        
        return $data;


	} 
		
   	public function selectListarVentas511($function)
	{
        $new_total_rows = 0;
        $contador=1;
        
        $pagenum=htmlspecialchars(filter_var($function->pagenum, FILTER_SANITIZE_NUMBER_INT));
        $pagesize=htmlspecialchars(filter_var($function->pagesize, FILTER_SANITIZE_NUMBER_INT));
        
        $starts = $pagenum * $pagesize;
        

        $queryexec="SELECT 
                IdVenta,
                EstadoVenta,
                TipoVenta,
                DC,
                Matricula,
                Comercial,
                Segmento,
                NProspecto,
                NContrato,
                Cliente,
                CategoriaVenta,
                PrecioKit,
                FVencimientoVisita,
                TCGestor,
                EstadoTelecierre,
                TCComentario,
                FechaVisita,
                HoraVisita,
                Checkin,
                Telefonouno,
                Telefonodos,
                InstaladoX,
                FechaInst,
                HoraInst,
                FechaHoraMODIF,
                VisitaNoVisitable,
                FechaHoraTransferenciaTC
                FROM telecierre";
        $query = $queryexec." LIMIT :starts,:pagesize";


        $where="";
        // filter data.
        if (isset($function->filterscount))
        {
        	$filterscount = htmlspecialchars($function->filterscount);
        			
        	if ($filterscount > 0)
        	{
        		$where = " WHERE (";
        		$tmpdatafield = "";
        		$tmpfilteroperator = "";
        		for ($i=0; $i < $filterscount; $i++)
        		{
        			// get the filter's value.
        			$filtervalue = htmlspecialchars($function->{"filtervalue".$i});
        			// get the filter's condition.
        			$filtercondition =htmlspecialchars($function->{"filtercondition".$i});
        			// get the filter's column.
        			$filterdatafield =htmlspecialchars($function->{"filterdatafield".$i});
        			// get the filter's operator.
        			$filteroperator =htmlspecialchars($function->{"filteroperator".$i});
        					
        			if ($tmpdatafield == "")
        			{
        				$tmpdatafield = $filterdatafield;			
        			}
        			else if ($tmpdatafield <> $filterdatafield)
        			{
        					if ($tmpfilteroperator == 2){
            					$where.= " OR ";
            				}else{ 
            				    $where.= ") AND (";
            				}
        			}
        			else if ($tmpdatafield == $filterdatafield)
        			{
        				    if ($tmpfilteroperator == 0){
            					$where.= " AND ";
            				}else{ 
            				    $where.= " OR ";
            				}	
        			}
        					
        			// build the "WHERE" clause depending on the filter's condition, value and datafield.
        			switch($filtercondition)
        			{
        				case "CONTAINS":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."%'";
        					break;
        				case "DOES_NOT_CONTAIN":
        					$where .= " " . $filterdatafield . " NOT LIKE '%" . $filtervalue ."%'";
        					break;
        				case "EQUAL":
        					$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
        					break;
        				case "NOT_EQUAL":
        					$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN":
        					$where .= " " . $filterdatafield . " > '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN":
        					$where .= " " . $filterdatafield . " < '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ."'";
        					break;
        				case "STARTS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '" . $filtervalue ."%'";
        					break;
        				case "ENDS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."'";
        					break;
        				case "NULL":
        					$where .= " " . $filterdatafield . " IS NULL";
        					break;
        				case "NOT_NULL":
        					$where .= " " . $filterdatafield . " NOT NULL";
        					break;
        				case "GREATER_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ." 00:00:00'";
        					break;
        				case "LESS_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ." 23:59:59'";
        					break;
        					
        					
        			}
        									
        			if ($i == $filterscount - 1){
        				$where.= ")";
        			}
        					
        			$tmpfilteroperator = $filteroperator;
        			$tmpdatafield = $filterdatafield;			
        		}
        		$query = $queryexec." " .$where." LIMIT :starts,:pagesize";	
        		//var_dump($query);
        
        	}
        }
        if (isset($function->sortdatafield)){
        	$sortfield = htmlspecialchars($function->sortdatafield);
        	$sortorder = htmlspecialchars($function->sortorder);
        	$filterscount = htmlspecialchars($function->filterscount);
        	if ($sortorder != '')
        		{
        		if ($filterscount == 0)
        			{
        			if ($sortorder == "desc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}

        			}
        		else
        			{
        			if ($sortorder == "desc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}
        			$query = $queryexec." " .$where.$filterquery;
        			}
        		}
        }



		$result = $this->db->prepare($query); 
        $result->bindParam(':starts', $starts, PDO::PARAM_INT);
        $result->bindParam(':pagesize',$pagesize, PDO::PARAM_INT);		
		$result->execute(); 
		

        $orders = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $orders[] = array(

                'IdVenta' => $row['IdVenta'],
                'EstadoVenta' => $row['EstadoVenta'],
                'TipoVenta' => $row['TipoVenta'],
                'DC' => $row['DC'],
                'Matricula' => $row['Matricula'],
                'Comercial' => $row['Comercial'],
                'Segmento' => $row['Segmento'],
                'NProspecto' => $row['NProspecto'],
                'NContrato' => $row['NContrato'],
                'Cliente' => $row['Cliente'],
                'CategoriaVenta' => $row['CategoriaVenta'],
                'PrecioKit' => $row['PrecioKit'],
                'FVencimientoVisita' => $row['FVencimientoVisita'],
                'TCGestor' => $row['TCGestor'],
                'EstadoTelecierre' => $row['EstadoTelecierre'],
                'TCComentario' => $row['TCComentario'],
                'FechaVisita' => $row['FechaVisita'],
                'HoraVisita' => $row['HoraVisita'],
                'Checkin' => $row['Checkin'],
                'Telefonouno' => $row['Telefonouno'],
                'Telefonodos' => $row['Telefonodos'],
                'InstaladoX' => $row['InstaladoX'],
                'FechaInst' => $row['FechaInst'],
                'HoraInst' => $row['HoraInst'],
                'FechaHoraMODIF' => $row['FechaHoraMODIF'],
                'VisitaNoVisitable' => $row['VisitaNoVisitable'],
                'FechaHoraTransferenciaTC' => $row['FechaHoraTransferenciaTC']
                	);
$contador++;                	
            
        }
        
	    $query = "SELECT COUNT(*) AS found_rows FROM telecierre ".$where;
		$result =  $this->db->prepare($query);
		$result->execute();
		$rows=$result->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['found_rows'];
        if ($new_total_rows > 0) $total_rows = $new_total_rows;	        

        if ($total_rows > 0){
            $data[] = array(
            	'TotalRows' => $total_rows,
            	'Rows' => array_map(null,$orders),
            	'mensaje' => '',
            	'tipo' =>1
            );
            
        } else {
            $data[] = array(
        	'TotalRows' => 0,
        	'Rows' => null,
        	'mensaje' => '<div class="callout bg-gray">
                            <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                       <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                        <br>
            </div>',
        	'tipo' =>0
        	);
        }
        
        
        return $data;


	}  

    function registrarExtrasRegalos($idventa,$detalleExtras){
        
        $fecharegistro = date("Y-m-d H:i:s");

		$query = $this->db->prepare("SELECT Detalle FROM tblventacotizaciontctv WHERE IdVenta=?");
		$query->execute(array($idventa));
		
		$rows = $query->rowCount();
        if($rows > 0){

            try{
                $query = $this->db->prepare("UPDATE tblventacotizaciontctv SET Detalle=? WHERE IdVenta = ?");
                $query->execute(array($detalleExtras,$idventa));
                $respuesta = $query->rowCount();
                
                
            }catch (\Exception $e) {
                $respuesta = 'error';
            }            
            
            
        } else {

            try{
                $query = $this->db->prepare("INSERT INTO tblventacotizaciontctv (IdVenta, FechaHoraREG, Detalle) VALUES (?, ?, ?)");
                $query->execute(array($idventa,$fecharegistro,$detalleExtras));
                $respuesta = $this->db->lastInsertId(); 
                
            }catch (\Exception $e) {
                $respuesta = 'error';
            }            
            
            
        }
		

		return $respuesta;

    }



}
