<?php

class ConexionTVReferidos
{


	private $db;
	private $usuario;

	function __construct()
	{

		$this->db =  Database::connect();

		// $this->db = new mysqli('localhost','root','','prueba');

	}
    /* LISTAR REFERIDOS*/
	public function mostrarTodosReferido($function)
	{
        $new_total_rows = 0;
        $pagenum=$function->pagenum;
        $pagesize=$function->pagesize;
        
        $starts = $pagenum * $pagesize;
        


        $queryexec="SELECT SQL_CALC_FOUND_ROWS
        Id,
        CodigoId,
        IdVenta,
        TipoVenta,
        Estado,
        FechaHoraREG,
        PrimerNombre,
        PrimerApellido,
        Telefono,
        Segmento,
        FechaHoraREG,
        TipoReferido,
        CC
         FROM dbREFERIDO.referidosTCTV";
        
        $query = $queryexec." LIMIT :starts,:pagesize";



        // filter data.
        if (isset($function->filterscount))
        {
        	$filterscount = $function->filterscount;
        			
        	if ($filterscount > 0)
        	{
        		$where = " WHERE (";
        		$tmpdatafield = "";
        		$tmpfilteroperator = "";
        		for ($i=0; $i < $filterscount; $i++)
        		{
        			// get the filter's value.
        			$filtervalue = $function->{"filtervalue".$i};
        			// get the filter's condition.
        			$filtercondition =$function->{"filtercondition".$i};
        			// get the filter's column.
        			$filterdatafield =$function->{"filterdatafield".$i};
        			// get the filter's operator.
        			$filteroperator =$function->{"filteroperator".$i};
        					
        			if ($tmpdatafield == "")
        			{
        				$tmpdatafield = $filterdatafield;			
        			}
        			else if ($tmpdatafield <> $filterdatafield)
        			{
        					if ($tmpfilteroperator == 2){
            					$where.= " OR ";
            				}else{ 
            				    $where.= ") AND (";
            				}
        			}
        			else if ($tmpdatafield == $filterdatafield)
        			{
        				    if ($tmpfilteroperator == 0){
            					$where.= " AND ";
            				}else{ 
            				    $where.= " OR ";
            				}	
        			}
        					
        			// build the "WHERE" clause depending on the filter's condition, value and datafield.
        			switch($filtercondition)
        			{
        				case "CONTAINS":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."%'";
        					break;
        				case "DOES_NOT_CONTAIN":
        					$where .= " " . $filterdatafield . " NOT LIKE '%" . $filtervalue ."%'";
        					break;
        				case "EQUAL":
        					$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
        					break;
        				case "NOT_EQUAL":
        					$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN":
        					$where .= " " . $filterdatafield . " > '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN":
        					$where .= " " . $filterdatafield . " < '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ."'";
        					break;
        				case "STARTS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '" . $filtervalue ."%'";
        					break;
        				case "ENDS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."'";
        					break;
        			}
        									
        			if ($i == $filterscount - 1){
        				$where.= ")";
        			}
        					
        			$tmpfilteroperator = $filteroperator;
        			$tmpdatafield = $filterdatafield;			
        		}
        		$query = $queryexec." " .$where." LIMIT :starts,:pagesize";	
        		//var_dump($query);
        
        	}
        }

		$result = $this->db->prepare($query); 
        $result->bindParam(':starts', $starts, PDO::PARAM_INT);
        $result->bindParam(':pagesize',$pagesize, PDO::PARAM_INT);		
		$result->execute(); 
		

        $orders = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $orders[] = array(
                'Id'=>$row['Id'],
                'CodigoId'=>$row['CodigoId'].'-'.($row['Estado']==''?'SinEstado':$row['Estado']),
                'IdVenta'=>$row['IdVenta'],
                'TipoVenta'=>$row['TipoVenta'],
                'Estado'=>$row['Estado'],
                'FechaHoraREG'=>$row['FechaHoraREG'],
                'PrimerNombre'=>$row['PrimerNombre'],
                'PrimerApellido'=>$row['PrimerApellido'],
                'Telefono'=>$row['Telefono'],
                'Segmento'=>$row['Segmento'],
                'FechaHoraREG'=>$row['FechaHoraREG'],
                'TipoReferido'=>$row['TipoReferido'],
                'CC'=>$row['CC']
                	);
            
        }
        
	    $query = "SELECT FOUND_ROWS() AS found_rows";
		$result =  $this->db->prepare($query);
		$result->execute();
		$rows=$result->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['found_rows'];
        if ($new_total_rows > 0) $total_rows = $new_total_rows;	        

        if ($total_rows > 0){
            $data[] = array(
            	'TotalRows' => $total_rows,
            	'Rows' => array_map(null,$orders),
            	'mensaje' => '',
            	'tipo' =>1
            );
            
        } else {
            $data[] = array(
        	'TotalRows' => 0,
        	'Rows' => null,
        	'mensaje' => '<div class="callout bg-gray">
                            <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                       <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                        <br>
            </div>',
        	'tipo' =>0
        	);
        }
        
        
        return $data;


	}


    /* BUSQUEDA REFERIDOTCTV*/
	public function getReferido($id)
	{
		
		$query = $this->db->prepare("SELECT 
                                    refd.Id,
                                    ref.IdVenta,
                                    ref.CC,
                                    ref.TipoVenta,
                                    ref.Matricula,
                                    u.IdUsuario,
                                    u.Nombres,
                                    u.Apellidos,
                                    u.Manager,
                                    refd.EstadoReferido,
                                    refd.PrimerNombre,
                                    refd.PrimerApellido,
                                    refd.Telefono,
                                    refd.Segmento,
                                    refd.TipoReferido
                                    FROM dbREFERIDO.tblreferidoTCTV ref 
                                    INNER JOIN dbREFERIDO.tblreferido_detalleTCTV refd on ref.Id=refd.Referido_ID
                                    INNER JOIN dbUSUARIO.tblusuario u on ref.Matricula=u.Matricula
                                    WHERE refd.Id=?");
        $query->execute(array($id));
		$retorno = $query->fetch(PDO::FETCH_ASSOC);
		return $retorno;

	}

	public function getUsuario($matricula)
	{
		$query = $this->db->prepare("SELECT 
		                            u.Matricula,
		                            CONCAT(u.Nombres,' ',u.Apellidos) as NombreUsuario,
		                            u.CC,
		                            u.Correo
                                    FROM dbUSUARIO.tblusuario u
                                    WHERE u.Matricula=?");
        $query->execute(array($matricula));

		$retorno = $query->fetch(PDO::FETCH_ASSOC);
		return $retorno;

	}



    /* BUSQUEDA TELEFONODUPLICIDAD*/
	public function getTelefonoReferido($buscarnumero)
	{

		$query = $this->db->prepare("SELECT v.IdVenta ID,v.IdProspectoRP,v.FechaHoraREG,v.Matricula,v.Comercial,v.CC,v.NProspecto,v.TipoVenta,c.Telefonouno,c.Telefonodos,'Visita' OrigenVista FROM tblventa v 
            INNER JOIN tblcliente c on c.IdCliente=v.IdCliente
            WHERE ((v.TipoVenta='RE' OR v.TipoVenta='RPMKT') and v.CCOriginal<>'511' and v.CCOriginal<>'512')
            and (v.EstadoVenta='PendienteData' or v.EstadoVenta='PendienteAgenda' or v.EstadoVenta='AgendadaTEC' or v.EstadoVenta='AgendadaDEL' or v.EstadoVenta='NoVendida' or v.EstadoVenta='Cancelada' or v.EstadoVenta='Inviable' or v.EstadoVenta='Ilocalizable' or v.EstadoVenta='VAsignada') 
            and DATEDIFF(curdate(), v.FechaHoraREG) <=105 and
            (c.Telefonouno=? or c.Telefonodos=?)
            UNION
            SELECT v.IdVenta ID,v.IdProspectoRP,v.FechaHoraREG,v.Matricula,v.Comercial,v.CC,v.NProspecto,v.TipoVenta,c.Telefonouno,c.Telefonodos,'Televenta' OrigenVista FROM tblventa v 
            INNER JOIN tblcliente c on c.IdCliente=v.IdCliente
            WHERE v.TipoVenta='RE' and v.TCTipoVenta='TeleVenta'
            and (v.EstadoVenta='' or v.EstadoVenta='PendienteData' or v.EstadoVenta='PendienteAgenda' or v.EstadoVenta='AgendadaTEC' or v.EstadoVenta='AgendadaDEL' or v.EstadoVenta='NoVendida' or v.EstadoVenta='Cancelada' or v.EstadoVenta='Inviable' or v.EstadoVenta='Ilocalizable' or v.EstadoVenta='VAsignada') 
            and DATEDIFF(curdate(), v.FechaHoraREG) <=105 and
            (c.Telefonouno=? or c.Telefonodos=?)
            UNION
            SELECT v.IdVenta,v.IdProspectoRP,v.FechaHoraREG,v.Matricula,v.Comercial,v.CC,v.NProspecto,v.TipoVenta,c.Telefonouno,c.Telefonodos,'Venta' FROM tblventa v 
            INNER JOIN tblcliente c on c.IdCliente=v.IdCliente
            WHERE (v.TipoVenta='RP' OR v.TipoVenta='RPPR' OR v.TipoVenta='RPPA')   
            and (v.EstadoVenta='PendienteData' or v.EstadoVenta='PendienteAgenda' or v.EstadoVenta='AgendadaTEC' or v.EstadoVenta='AgendadaDEL' or v.EstadoVenta='NoVendida' or v.EstadoVenta='Cancelada' or v.EstadoVenta='Inviable' or v.EstadoVenta='Ilocalizable' or v.EstadoVenta='VAsignada') 
            and DATEDIFF(curdate(), v.FechaHoraREG) <=105 and
            (c.Telefonouno=? or c.Telefonodos=?)
            UNION
            SELECT p.IdProspectoRP,p.IdProspectoRP,p.FechaHoraREG,p.Matricula,p.Comercial,p.CC,p.NProspecto,p.TipoVenta,c1.Telefonouno,c1.Telefonodos,'ProspectoRP' FROM tblprospectorp p 
            INNER JOIN tblcliente c1 on c1.IdCliente=p.IdCliente
            WHERE (p.TipoVenta='RP' OR p.TipoVenta='RPPR' OR p.TipoVenta='RPPA') 
            and p.EstadoProspecto='ProspectoRP' 
            and DATEDIFF(curdate(), p.FechaHoraREG) <=105 and
            (c1.Telefonouno=? or c1.Telefonodos=?)");

        $query->execute(array($buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero));

		$retorno = [];
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
		}

		return $retorno;


	}	
	
	public function updateReferidoTCTV($id,$Gestor,$fechahorahoy,$idVen)
	{
	    $query = $this->db->prepare("UPDATE dbREFERIDO.tblreferido_detalleTCTV SET EstadoReferido = 'Transferido', GestorCall = ?,updated_at=?,IdVenta=? WHERE Id = ?");
	    $query->execute(array($Gestor,$fechahorahoy,$idVen,$id));
	    
	    return $query->rowCount()>0 ? true : false;
	}

	/* INSERTAR CLIENTE*/
	public function insertCliente($distrito,$nombcliente,$telefonouno,$correo,$direccion,$segmento)
	{
		
		$query = $this->db->prepare("INSERT INTO dbVENTAS.tblcliente(IdGeografico, NombApellido, Telefonouno, Correo, Direccion,Segmento) VALUES (?,?,?,?,?,?)");
		$query->execute(array($distrito,$nombcliente,$telefonouno,$correo,$direccion,$segmento));
		$retorno = $this->db->lastInsertId(); 

		return $retorno;

	}
	
	public function updateCliente($idcliente,$distrito,$nombcliente,$telefonodos,$correo,$direccion)
	{
		
		$query = $this->db->prepare("UPDATE dbVENTAS.tblcliente SET IdGeografico=?, NombApellido=?, Telefonodos=?, Correo=?, Direccion=? WHERE IdCliente=?");
        $query->execute(array($distrito,$nombcliente,$telefonodos,$correo,$direccion,$idcliente));
        $retorno = $query->rowCount();	

		return $retorno;

	}

	public function findProspecto($prospecto)
	{
		

        $query = $this->db->prepare("SELECT IdVenta FROM dbVENTAS.tblventa WHERE NProspecto= ?");
        $query->execute(array($prospecto));
        
        $resultado = $query->fetchAll();
        
        $row_cnt=count($resultado);
        
		return $retorno;

	}
	
	public function updateVentaProspecto($idventa,$prospecto)
	{
		
		$query = $this->db->prepare("UPDATE dbVENTAS.tblventa SET NProspecto= ? WHERE IdVenta=?");
        $query->execute(array($prospecto,$idventa));
        $retorno = $query->rowCount();	

		return $retorno;

	}	

	/* INSERTAR VENTA*/
	public function insertVenta($idusuario,$idCli,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$nprospecto,$preciokit,$totalextra,$ingresokit,$ingresoextras,$ingresototal,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$fecharegistroventa,$matriculausuario,$TCTipoVenta,$estadotelecierre,$tipotvz,$asignado,$mesteleventa,$leadid,$prioridad,$HabilitadoTV,$origen)
	{
		
	
		
		$query = $this->db->prepare("INSERT INTO dbVENTAS.tblventa(IdUsuario,IdCliente,Matricula,Comercial,CC,JefeVenta,CategoriaVenta,TipoVenta,Segmento,NProspectoCC,PrecioKit,TotalExtra,IngresoKIT,IngresoExtras,IngresoTotal,EstadoVenta,ExtraAutorizado,MesesAutorizado,N590,FormaPago,PAI,ResumenVenta,FechaHoraREG,GestorOrigen,CCOriginal,PrecioKITOriginal,TotalExtraOriginal,ExtraAutorizadoOriginal,MesesAutorizadoOriginal,FormaPagoOriginal,PAIOriginal,ResumenVentaOriginal,TCTipoVenta,TCGestor,EstadoTelecierre,TipoTV,GestorMKT,MesTeleventa,LeadID,Prioridad,HabilitadoTV,OrigenVisita) VALUES ('$idusuario','$idCli','$matricula','$nombcomercial','$dc','$jefeventa','$categoria','$tipoventa','$segmento','$nprospecto','$preciokit','$totalextra','$ingresokit','$ingresoextras','$ingresototal','$estadoventa','$extraautorizado','$mesesautorizados','$n590','$formadepago','$PAI','$resumenventa','$fecharegistroventa','$matriculausuario','$dc','$preciokit','$totalextra','$extraautorizado','$mesesautorizados','$formadepago','$PAI','$resumenventa','$TCTipoVenta','$matricula','$estadotelecierre','$tipotvz','$asignado','$mesteleventa','$leadid','$prioridad', '$HabilitadoTV','$origen')");
        $query->execute(array($idusuario,$idCli,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$nprospecto,$preciokit,$totalextra,$ingresokit,$ingresoextras,$ingresototal,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$fecharegistroventa,$matriculausuario,$dc,$preciokit,$totalextra,$extraautorizado,$mesesautorizados,$formadepago,$PAI,$resumenventa,$TCTipoVenta,$matricula,$estadotelecierre,$tipotvz,$asignado,$mesteleventa,$leadid,$prioridad, $HabilitadoTV,$origen));

		$retorno = $this->db->lastInsertId(); 

		return $retorno;

	}

	/* INSERTAR AGENDA*/
	public function insertAgenda($idVen,$fecharegistroagenda,$GestionOrigen)
	{
		
		$query = $this->db->prepare("INSERT INTO dbVENTAS.tblagenda(IdVenta,FechaHoraREG,GestionOrigen) VALUES (?,?,?)");
		$query->execute(array($idVen,$fecharegistroagenda,$GestionOrigen));
		
		$retorno = $this->db->lastInsertId(); 

		return $retorno;

	}
	/* INSERTAR FACTURACION*/
	public function insertFacturacion($idVen,$fecharegistrofacturacion,$GestionOrigen)
	{
		
		$query = $this->db->prepare("INSERT INTO dbVENTAS.tblfacturacion(IdVenta, FechaHoraREG,GestionOrigen) VALUES (?,?,?)");
		$query->execute(array($idVen,$fecharegistrofacturacion,$GestionOrigen));
		
		$retorno = $this->db->lastInsertId(); 

		return $retorno;

	}
	
	public function listarGestoresMatricula($q)
	{
		
        $q = "%{$q}%";
        $query = $this->db->prepare("SELECT u.IdUsuario,u.Matricula,u.CC,CONCAT(u.Nombres,' ',u.Apellidos) NombComercial,u.Manager FROM dbUSUARIO.tblusuario u  INNER JOIN dbUSUARIO.tblarea a on a.IdArea=u.IdArea INNER JOIN dbUSUARIO.tblusuario m on m.Matricula=u.Manager WHERE u.Matricula LIKE ? AND a.LN='11' and (u.CC='512' or u.CC='511') LIMIT 0,50");
        $query->execute(array($q));
        
		$retorno = [];
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
            $retorno[] = array_map("utf8_encode",['value'=>$fila['Matricula']." - ".$fila['NombComercial'],
                                            	    'idusuario'=>$fila['IdUsuario'],
                                            	    'matricula'=>$fila['Matricula'],
        	                                        'comercial'=>$fila['NombComercial'],
        	                                        'manager'=>$fila['Manager']]);
		}

		return $retorno;

	}	
	
	


}
