<?php

class ConexionReferidoRPPR
{


	private $db;
	private $usuario;

	function __construct()
	{

		$this->db =  Database::connect();

	}

	public function registrarcolaborador(
$PrimerNombre,
$SegundoNombre=null,
$ApellidoPaterno,
$ApellidoMaterno,
$TipoDocumento,
$Documento,
$Telefono,
$Correo,
$FechaNacimiento,
$Direccion,
$Distrito,
$Provincia,
$Departamento,
$CodUbigeoReniec,
$FechaHoraREG,
$MatriculaREG,
$EstadoReferido=null,
$imagenes=null
)
	{

        $idReferido=0;
        
	    $query = $this->db->prepare("INSERT INTO dbREFERIDO.tblreferidorppr(PrimerNombre, SegundoNombre, ApellidoPaterno, ApellidoMaterno, TipoDocumento, Documento, Telefono, Correo, FechaNacimiento, Direccion, Distrito, Provincia, Departamento, CodUbigeoReniec, FechaHoraREG, MatriculaREG, EstadoReferido,Imagenes) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
		$query->execute(array($PrimerNombre,
                    $SegundoNombre,
                    $ApellidoPaterno,
                    $ApellidoMaterno,
                    $TipoDocumento,
                    $Documento,
                    $Telefono,
                    $Correo,
                    $FechaNacimiento,
                    $Direccion,
                    $Distrito,
                    $Provincia,
                    $Departamento,
                    $CodUbigeoReniec,
                    $FechaHoraREG,
                    $MatriculaREG,
                    $EstadoReferido,
                    $imagenes));
		
		$idReferido = $this->db->lastInsertId();
		
		return $idReferido;
	}
	
	public function validarcolaborador($Documento){
	    $cantidadregistro=0;
	    
	    $query = $this->db->prepare("SELECT Documento FROM dbREFERIDO.tblreferidorppr WHERE Documento=? and EstadoReferido='Validado' LIMIT 1");
		$query->execute(array($Documento));
		$cantidadregistro=$query->rowCount();
		
		return $cantidadregistro;
	    
	}
	
	public function mostrardatoscolaborador($Documento){

	    $query = $this->db->prepare("SELECT Documento,TipoDocumento FROM dbREFERIDO.tblreferidorppr WHERE Documento=? and EstadoReferido='Validado' LIMIT 1");
		$query->execute(array($Documento));

		$retorno = [];
		$i = 0;
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[$i] = $fila;
			$i++;
		}

		return $retorno;
	    
	}

	public function mostrarTodosColaboradores($function)
	{
        $new_total_rows = 0;
        $contador=1;
        $pagenum=$function->pagenum;
        $pagesize=$function->pagesize;
        
        $starts = $pagenum * $pagesize;
        


        $queryexec="SELECT 
            Id,
            PrimerNombre,
            SegundoNombre,
            ApellidoPaterno,
            ApellidoMaterno,
            TipoDocumento,
            Documento,
            Telefono,
            Correo,
            FechaNacimiento,
            Direccion,
            Distrito,
            Provincia,
            Departamento,
            CodUbigeoReniec,
            FechaHoraREG,
            MatriculaREG,
            EstadoReferido
            FROM dbREFERIDO.tblreferidorppr";
        
        $query = $queryexec." LIMIT :starts,:pagesize";


        $where="";
        // filter data.
        if (isset($function->filterscount))
        {
        	$filterscount = $function->filterscount;
        			
        	if ($filterscount > 0)
        	{
        		$where = " WHERE (";
        		$tmpdatafield = "";
        		$tmpfilteroperator = "";
        		for ($i=0; $i < $filterscount; $i++)
        		{
        			// get the filter's value.
        			$filtervalue = $function->{"filtervalue".$i};
        			// get the filter's condition.
        			$filtercondition =$function->{"filtercondition".$i};
        			// get the filter's column.
        			$filterdatafield =$function->{"filterdatafield".$i};
        			// get the filter's operator.
        			$filteroperator =$function->{"filteroperator".$i};
        					
        			if ($tmpdatafield == "")
        			{
        				$tmpdatafield = $filterdatafield;			
        			}
        			else if ($tmpdatafield <> $filterdatafield)
        			{
        					if ($tmpfilteroperator == 2){
            					$where.= " OR ";
            				}else{ 
            				    $where.= ") AND (";
            				}
        			}
        			else if ($tmpdatafield == $filterdatafield)
        			{
        				    if ($tmpfilteroperator == 0){
            					$where.= " AND ";
            				}else{ 
            				    $where.= " OR ";
            				}	
        			}
        					
        			// build the "WHERE" clause depending on the filter's condition, value and datafield.
        			switch($filtercondition)
        			{
        				case "CONTAINS":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."%'";
        					break;
        				case "DOES_NOT_CONTAIN":
        					$where .= " " . $filterdatafield . " NOT LIKE '%" . $filtervalue ."%'";
        					break;
        				case "EQUAL":
        					$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
        					break;
        				case "NOT_EQUAL":
        					$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN":
        					$where .= " " . $filterdatafield . " > '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN":
        					$where .= " " . $filterdatafield . " < '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ."'";
        					break;
        				case "STARTS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '" . $filtervalue ."%'";
        					break;
        				case "ENDS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."'";
        					break;
        				case "NULL":
        					$where .= " " . $filterdatafield . " IS NULL";
        					break;
        				case "NOT_NULL":
        					$where .= " " . $filterdatafield . " NOT NULL";
        					break;
        				case "GREATER_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ." 00:00:00'";
        					break;
        				case "LESS_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ." 23:59:59'";
        					break;
        					
        					
        			}
        									
        			if ($i == $filterscount - 1){
        				$where.= ")";
        			}
        					
        			$tmpfilteroperator = $filteroperator;
        			$tmpdatafield = $filterdatafield;			
        		}
        		$query = $queryexec." " .$where." LIMIT :starts,:pagesize";	
        		//var_dump($query);
        
        	}
        }
        if (isset($function->sortdatafield)){
        	$sortfield = $function->sortdatafield;
        	$sortorder = $function->sortorder;
        	$filterscount = $function->filterscount;
        	if ($sortorder != '')
        		{
        		if ($filterscount == 0)
        			{
        			if ($sortorder == "desc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}

        			}
        		else
        			{
        			if ($sortorder == "desc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}
        			$query = $queryexec." " .$where.$filterquery;
        			}
        		}
        }



		$result = $this->db->prepare($query); 
        $result->bindParam(':starts', $starts, PDO::PARAM_INT);
        $result->bindParam(':pagesize',$pagesize, PDO::PARAM_INT);		
		$result->execute(); 
		

        $orders = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $orders[] = array(
        'Id' => $row['Id'],
        'PrimerNombre' => $row['PrimerNombre'],
        'SegundoNombre' => $row['SegundoNombre'],
        'ApellidoPaterno' => $row['ApellidoPaterno'],
        'ApellidoMaterno' => $row['ApellidoMaterno'],
        'TipoDocumento' => $row['TipoDocumento'],
        'Documento' => $row['Documento'],
        'Telefono' => $row['Telefono'],
        'Correo' => $row['Correo'],
        'FechaNacimiento' => $row['FechaNacimiento'],
        'Direccion' => $row['Direccion'],
        'Distrito' => $row['Distrito'],
        'Provincia' => $row['Provincia'],
        'Departamento' => $row['Departamento'],
        'CodUbigeoReniec' => $row['CodUbigeoReniec'],
        'FechaHoraREG' => $row['FechaHoraREG'],
        'MatriculaREG' => $row['MatriculaREG'],
        'EstadoReferido' => $row['EstadoReferido']
                	);
    $contador++;                	
            
        }
        
	    $query = "SELECT COUNT(*) AS found_rows FROM dbREFERIDO.tblreferidorppr".$where;
		$result =  $this->db->prepare($query);
		$result->execute();
		$rows=$result->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['found_rows'];
        if ($new_total_rows > 0) $total_rows = $new_total_rows;	        

        if ($total_rows > 0){
            $data[] = array(
            	'TotalRows' => $total_rows,
            	'Rows' => array_map(null,$orders),
            	'mensaje' => '',
            	'tipo' =>1
            );
            
        } else {
            $data[] = array(
        	'TotalRows' => 0,
        	'Rows' => null,
        	'mensaje' => '<div class="callout bg-gray">
                            <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                       <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                        <br>
            </div>',
        	'tipo' =>0
        	);
        }
        
        
        return $data;


	}
	
	public function mostrardatoscolaboradorporID($id){

	    $query = $this->db->prepare("SELECT
            l.PrimerNombre,
            l.SegundoNombre,
            l.ApellidoPaterno,
            l.ApellidoMaterno,
            l.TipoDocumento,
            l.Documento,
            l.Telefono,
            l.Correo,
            l.FechaNacimiento,
            l.Direccion,
            l.Distrito,
            l.Provincia,
            l.Departamento,
            l.CodUbigeoReniec,
            l.FechaHoraREG,
            l.MatriculaREG,
            l.EstadoReferido,
            l.Imagenes,
            dep.IdDepartamental, 
            prov.IdProvincial,
            l.Observacion
            FROM dbREFERIDO.tblreferidorppr l
            LEFT JOIN dbVENTAS.tbldistrital d ON l.CodUbigeoReniec = d.CodUbigeoReniec
            LEFT JOIN dbVENTAS.tblprovincial prov ON prov.IdProvincial = d.IdProvincial
            LEFT JOIN dbVENTAS.tbldepartamental dep ON dep.IdDepartamental = prov.IdDepartamental            
            WHERE Id=?");
		$query->execute(array($id));

		$retorno = [];
		$i = 0;
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[$i] = $fila;
			$i++;
		}

		return $retorno;
	    
	}
	
	public function actualizarporEstado($idColaborador,$estado){
	    
	    $query = $this->db->prepare("UPDATE dbREFERIDO.tblreferidorppr SET EstadoReferido = ? WHERE Id = ?");
		$query->execute(array($estado,$idColaborador));
		return $query ? true: false;
	    
	}

	public function actualizarcolaborador(
                            $PrimerNombre,
                            $SegundoNombre=null,
                            $ApellidoPaterno,
                            $ApellidoMaterno,
                            $Telefono,
                            $Correo,
                            $FechaNacimiento,
                            $Direccion,
                            $Distrito,
                            $Provincia,
                            $Departamento,
                            $CodUbigeoReniec,
                            $Observacion,
                            $idColaborador
    )
	{

            $respuesta=0;

			$query = $this->db->prepare("UPDATE dbREFERIDO.tblreferidorppr SET PrimerNombre=?, SegundoNombre=?, ApellidoPaterno=?, ApellidoMaterno=?, Telefono=?, Correo=?, FechaNacimiento=?, Direccion=?, Distrito=?, Provincia=?, Departamento=?, CodUbigeoReniec=?,Observacion=? WHERE Id = ? ");
			$query->execute(array($PrimerNombre,
                            $SegundoNombre,
                            $ApellidoPaterno,
                            $ApellidoMaterno,
                            $Telefono,
                            $Correo,
                            $FechaNacimiento,
                            $Direccion,
                            $Distrito,
                            $Provincia,
                            $Departamento,
                            $CodUbigeoReniec,
                            $Observacion,
                            $idColaborador));
			
			$respuesta = $query->rowCount();        
        
		
		return $respuesta;
	}	
	
	public function actualizarcolaboradorimagenes(
                            $imagenes,
                            $idColaborador
    )
	{

            $respuesta=0;

			$query = $this->db->prepare("UPDATE dbREFERIDO.tblreferidorppr SET Imagenes=? WHERE Id = ? ");
			$query->execute(array(
                            $imagenes,
                            $idColaborador));
			
			$respuesta = $query->rowCount();        
        
		
		return $respuesta;
	}	
	
	

}
