<?php
// SESSION
require dirname(__DIR__).'/ajax/is_logged.php';

require dirname(__DIR__).'/Connection/Conection.php';
require dirname(__DIR__).'/Model/ConexionCalendario.php';



date_default_timezone_set('America/Lima');

if (isset($_POST['function']) && !empty($_POST['function'])) {

    $function = json_decode($_POST['function']);

    switch ($function->array) {
        case 'array1':
            $consulta = new Calendario;
            $consulta->CalendarioSemanal();
            break;
        case 'array2':
            $consulta = new Calendario;
            $consulta->ListaTecnicos();
            break;             
        case 'array3':
            $consulta = new Calendario;
            $consulta->ValidarDisponibilidadRango();
            break;            
        
        default:
            echo "Error no se encontro la data";
            break;
    }

}


class Calendario
{

    public function CalendarioSemanal()
    {
        $function = json_decode($_POST['function']);

        $zona=(isset($function->zona) || !empty($function->zona))?$function->zona:15;        
        
        //Obtengo un array de los tecnicos ocupados
        $conexion = new ConexionCalendario();
        $arrayTecnicosAsignadosVisitas = $conexion->rowcalendario($zona);
        
        
        $arrayTecnicosAgendados=ContadorGeneral($arrayTecnicosAsignadosVisitas);

// 		print_r($arrayTecnicosAgendados);
// 		exit();          
        
        $arrayTecnicos=$conexion->cantidadTecnicosAsigandos($zona);
        
        if(count($arrayTecnicos)>0){
            $arrayMatriculasTecnicos = array_column($arrayTecnicos, 'Matricula');
        }else{
            $arrayMatriculasTecnicos = array();
        }
        
        
        $cantidadT=count($arrayTecnicos);

        $datos=array();
        //print_r($function->start);
        //Configuraciones Locales de fecha hoy con formato dia y hora
        $hoy=date('Y-m-d 00:00:00');
        $hoyhora=date('Y-m-d H:i:s');
        //Capturo la fecha incial de la semana que envia fullcalendar
        $start=date("Y-m-d",strtotime($function->start));
        //print_r($start);
        //Obtengo los dias-fecha de la semana
        $arregloDiaSemana=date_week($start);
        $arregloDiaSemanaHoras=array();

        $arrayTecnicosIndisponibles = $conexion->TecnicosIndisponibleSemanal($zona,$arregloDiaSemana[0],$arregloDiaSemana[6]);
        
        $arrayTecnicosInd=ContadorIndisponibles($arrayTecnicosIndisponibles);
        
        
        // print_r($arrayTecnicosInd);
        // exit();



        foreach($arregloDiaSemana as $clave => $valor) 
        {
            $arregloDiaSemanaHoras[]=date("Y-m-d H:i:s",strtotime($valor.'08:00:00'));
            $arregloDiaSemanaHoras[]=date("Y-m-d H:i:s",strtotime($valor.'11:00:00'));
            $arregloDiaSemanaHoras[]=date("Y-m-d H:i:s",strtotime($valor.'14:00:00'));
            $arregloDiaSemanaHoras[]=date("Y-m-d H:i:s",strtotime($valor.'17:00:00'));

        }
        
        
        //print_r(json_encode($arregloDiaSemanaHoras));

        foreach($arregloDiaSemanaHoras as $clave => $valor) 
        {
            if(strtotime($hoy)>strtotime($valor)){

            $fechaAuxiliar  = strtotime ("3 hours" ,strtotime ($valor)) ;  
            $fechaFin   = date ('Y-m-d H:i:s' , $fechaAuxiliar);
            $datos[] = [
                            'id'              => 0,
                            // 'title'           => $row['title'],
                            'title'           => "",
                            'start'           => $valor,
                            'end'             => $fechaFin,
                            'backgroundColor' => '#a5a8a6',
                            'textColor'       => '#ffffff',
                            'borderColor'     => '#ffffff'
                        ]; 
                
            }else{

                $fechaAuxiliar  = strtotime ("3 hours" ,strtotime ($valor)) ;  
                $fechaFin   = date ('Y-m-d H:i:s' , $fechaAuxiliar);
                
                if(strtotime($hoyhora)>strtotime($fechaFin)){

                $datos[] = [
                            'id'              => 0,
                            // 'title'           => $row['title'],
                            'title'           => "",
                            'start'           => $valor,
                            'end'             => $fechaFin,
                            'backgroundColor' => '#a5a8a6',
                            'textColor'       => '#ffffff',
                            'borderColor'     => '#ffffff'
                        ];                
                    
                }else{

                    if($cantidadT>0){
                        $cantidadTAux=0;
                        //Tecnicos no Disponible por cantidad
                        if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor)), $arrayTecnicosInd)) {
                            
                            
                            $cantidadTAux=$cantidadT-$arrayTecnicosInd[date("Y-m-d H:i:s",strtotime($valor))][0];
                            if($cantidadTAux==0){
                                        $datos[] = [
                                                'id'              => 0,
                                                // 'title'           => $row['title'],
                                                'title'           => "",
                                                'start'           => $valor,
                                                'end'             => $fechaFin,
                                                'backgroundColor' => '#a5a8a6',
                                                'textColor'       => '#ffffff',
                                                'borderColor'     => '#ffffff'
                                            ]; 
                                
                            }else{
                                if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor)), $arrayTecnicosAgendados)) {
                                    
                                            $arrayTUnidos = array_diff($arrayMatriculasTecnicos,$arrayTecnicosInd[date("Y-m-d H:i:s",strtotime($valor))][1],$arrayTecnicosAgendados[date("Y-m-d H:i:s",strtotime($valor))][1]);

                                            $cantidadTunidos=count($arrayTUnidos);
                                            
                                    
                                            if($cantidadTunidos==0){
                    
                                                    $datos[] = [
                                                            'id'              => 0,
                                                            // 'title'           => $row['title'],
                                                            'title'           => "",
                                                            'start'           => $valor,
                                                            'end'             => $fechaFin,
                                                            'backgroundColor' => '#e65a5a',
                                                            'textColor'       => '#ffffff',
                                                            'borderColor'     => '#ffffff'
                                                        ];
                                                
                                            }else if($cantidadTunidos>=$cantidadTAux*0.50 && $cantidadTunidos<$cantidadT){
                    
                                                    $datos[] = [
                                                            'id'              => 1,
                                                            // 'title'           => $row['title'],
                                                            'title'           => "TV",
                                                            'start'           => $valor,
                                                            'end'             => $fechaFin,
                                                            'backgroundColor' => '#ebd34d',
                                                            'textColor'       => '#ffffff',
                                                            'borderColor'     => '#ffffff'
                                                        ];                        
                                            
                                            }else{
                    
                                                    $datos[] = [
                                                            'id'              => 1,
                                                            // 'title'           => $row['title'],
                                                            'title'           => "TV",
                                                            'start'           => $valor,
                                                            'end'             => $fechaFin,
                                                            'backgroundColor' => '#10bd2e',
                                                            'textColor'       => '#ffffff',
                                                            'borderColor'     => '#ffffff'
                                                        ];  
                                                
                                            }
                                            
                                    }else{

                                        $datos[] = [
                                                'id'              => 1,
                                                // 'title'           => $row['title'],
                                                'title'           => "TV",
                                                'start'           => $valor,
                                                'end'             => $fechaFin,
                                                'backgroundColor' => '#10bd2e',
                                                'textColor'       => '#ffffff',
                                                'borderColor'     => '#ffffff'
                                            ];
                    
                                            
                                            
                                    }                                
                            }
                            


                            
                        }else{

                                    if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor)), $arrayTecnicosAgendados)) {


                                        
                                            if($arrayTecnicosAgendados[date("Y-m-d H:i:s",strtotime($valor))][0]>=$cantidadT){
                    
                                                    $datos[] = [
                                                            'id'              => 0,
                                                            // 'title'           => $row['title'],
                                                            'title'           => "",
                                                            'start'           => $valor,
                                                            'end'             => $fechaFin,
                                                            'backgroundColor' => '#e65a5a',
                                                            'textColor'       => '#ffffff',
                                                            'borderColor'     => '#ffffff'
                                                        ];
                                                
                                            }else if($arrayTecnicosAgendados[date("Y-m-d H:i:s",strtotime($valor))][0]>=$cantidadT*0.50 && $arrayTecnicosAgendados[date("Y-m-d H:i:s",strtotime($valor))][0]<$cantidadT){
                    
                                                    $datos[] = [
                                                            'id'              => 1,
                                                            // 'title'           => $row['title'],
                                                            'title'           => "TV",
                                                            'start'           => $valor,
                                                            'end'             => $fechaFin,
                                                            'backgroundColor' => '#ebd34d',
                                                            'textColor'       => '#ffffff',
                                                            'borderColor'     => '#ffffff'
                                                        ];                        
                                            
                                            }else{
                    
                                                    $datos[] = [
                                                            'id'              => 1,
                                                            // 'title'           => $row['title'],
                                                            'title'           => "TV",
                                                            'start'           => $valor,
                                                            'end'             => $fechaFin,
                                                            'backgroundColor' => '#10bd2e',
                                                            'textColor'       => '#ffffff',
                                                            'borderColor'     => '#ffffff'
                                                        ];  
                                                
                                            }
                                            
                                    }else{

                                        $datos[] = [
                                                'id'              => 1,
                                                // 'title'           => $row['title'],
                                                'title'           => "TV",
                                                'start'           => $valor,
                                                'end'             => $fechaFin,
                                                'backgroundColor' => '#10bd2e',
                                                'textColor'       => '#ffffff',
                                                'borderColor'     => '#ffffff'
                                            ];
                    
                                            
                                            
                                    }

                            
                        }
                        
                        

                        
                    }else{
                        
                                        $datos[] = [
                                                'id'              => 0,
                                                // 'title'           => $row['title'],
                                                'title'           => "",
                                                'start'           => $valor,
                                                'end'             => $fechaFin,
                                                'backgroundColor' => '#a5a8a6',
                                                'textColor'       => '#ffffff',
                                                'borderColor'     => '#ffffff'
                                            ]; 
                        
                    }


                    
                }
               
                
            }
            
           
           
            
        }



        print_r(json_encode($datos));
        
        //print_r(json_encode($datos));

    }
    
    public function ValidarDisponibilidadRango(){
        $function = json_decode($_POST['function']);

        $zona=(isset($function->zona) || !empty($function->zona))?$function->zona:15;  
        $startDate=$function->fechaInicio;
        // $endDate=$function->endDate;
        $conexion = new ConexionCalendario();
        $arrayTecnicosAsociados = $conexion->getTecnicos($zona);

		$arrayTecnicosAgendadosporFlanja = $conexion->rowcalendarioFecha($zona,$startDate);
		
		$aTmp1 = []; $aTmp2=[];
		
		foreach($arrayTecnicosAsociados as $aV){
            $aTmp1[] = $aV['Matricula'];
        }
        
        foreach($arrayTecnicosAgendadosporFlanja as $aV){
            $aTmp2[] = $aV['Matricula'];
        }
        
        $arrayTecnicosDisponibles = array_diff($aTmp1,$aTmp2);
        
        // print_r($aTmp1); print_r($aTmp2); print_r($arrayTecnicosDisponibles);exit();
        print_r(json_encode($arrayTecnicosDisponibles));
        
        
    }
    
    public function ListaTecnicos()
    {

        $function = json_decode($_POST['function']);

        $zona=(isset($function->zona) || !empty($function->zona))?$function->zona:15;  
        $startDate=$function->startDate;
        $endDate=$function->endDate;
        $horafija=$function->horafija;
        
        

        $conexion = new ConexionCalendario();

		// $funcion = json_decode($_POST['function']);

		// $idVenta = $funcion->idVenta; 
		
		$arrayTecnicosAsociados = $conexion->getTecnicos($zona);

		$arrayTecnicosAgendadosporFlanja = $conexion->rowcalendarioFecha($zona,$startDate);
		

		
		$arrayTecnicosIndisponible=$conexion->TecnicosIndisponible($zona,$horafija);
		
		$arrayTecnicosInd=ContadorIndisponibles($arrayTecnicosIndisponible);

        $aTmp3=array();		
		if (array_key_exists(date("Y-m-d H:i:s",strtotime($horafija)), $arrayTecnicosInd)) {
		    $aTmp3=$arrayTecnicosInd[date("Y-m-d H:i:s",strtotime($horafija))][1];
		}
		
 
        foreach($arrayTecnicosAsociados as $aV){
            $aTmp1[] = $aV['Matricula'];
        }
        
        
        
        $aTmp2=array();
        if(count($arrayTecnicosAgendadosporFlanja)>0){
            
            foreach($arrayTecnicosAgendadosporFlanja as $aV){
                $aTmp2[] = $aV['Matricula'];
            }
        }
        
// print_r($aTmp3);
// exit();
            $arrayComparacion = array_diff($aTmp1,$aTmp3,$aTmp2);
            

// print_r($arrayTecnicosInd);
// print_r($aTmp1);
// print_r($aTmp3);
// print_r($aTmp2);
// print_r($arrayComparacion);
// exit();            
            
            $arrayCambiosMS=array();
            foreach ($arrayComparacion as $key => $value) {
                $arrayCambiosMS[] = array('Matricula'=>$value);
            }
            
            $datos=$arrayCambiosMS;


        

        //     $arrayComparacionT = array_diff($aTmp1,$aTmp3);
            
        //     $aTmp1=array();
        //     foreach ($arrayComparacionT as $key => $value) {
        //         $aTmp1[] = array('Matricula'=>$value);
        //     }
            
        //     $datos=$aTmp1;
        
      
        // if(count($arrayTecnicosAgendadosporFlanja)>0){
            
        //     foreach($arrayTecnicosAgendadosporFlanja as $aV){
        //         $aTmp2[] = $aV['Matricula'];
        //     }
            

        // }
		
		
		print_r(json_encode($datos));
		

    }

}


function date_week($u_date) {
    $date_obj = new DateTime($u_date); // Crear un objeto de fecha
    $num_day = $date_obj->format('N'); // 0-dom, 1-lun, ... 6-sab
    //print_r($num_day);

    $date_obj->modify("-$num_day day"); // Posicionar el objeto en domingo
    $date_obj->modify("+1 day"); // Posicionar el objeto en Lunes
    $wdays = array();
    for($i=0; $i<7; $i++) {
        $wdays[] = $date_obj->format('Y-m-d');
        $date_obj->modify('+1 day'); // Incrementar el objeto 1 dia
    }
    return $wdays;
}

function ContadorIndisponibles($arrayDatos) {

    $arrayResult=array();
    foreach($arrayDatos as $clave => $valor) 
    {
        if($valor['hora_inicio']=='00:00:00' && $valor['hora_fin']=='23:59:59'){

            if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'08:00:00')), $arrayResult)) {
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'08:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'08:00:00'))][0]+1;
                
                array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'08:00:00'))][1],$valor['Matricula']);
            }else{
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'08:00:00'))]=array(1,array($valor['Matricula']));
            }


            if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00')), $arrayResult)) {
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))][0]+1;
                array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))][1],$valor['Matricula']);
            }else{
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))]=array(1,array($valor['Matricula']));
            }
            
            if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00')), $arrayResult)) {
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))][0]+1;
                array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))][1],$valor['Matricula']);
            }else{
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))]=array(1,array($valor['Matricula']));
            }            

            if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00')), $arrayResult)) {
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))][0]+1;
                array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))][1],$valor['Matricula']);
            }else{
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))]=array(1,array($valor['Matricula']));
            }
            
    
        }else{

        $fechaInicioConcatenada = date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].' '.$valor['hora_inicio']));
        $fechaFinConcatenada   = date('Y-m-d H:i:s' , strtotime($valor['fecha_inicio'].' '.$valor['hora_fin']));
        
        if(strtotime($fechaInicioConcatenada)<strtotime($valor['fecha_inicio'].' 11:00:00')){
            if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'08:00:00')), $arrayResult)) {
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'08:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'08:00:00'))][0]+1;
                array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'08:00:00'))][1],$valor['Matricula']);
            }else{
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'08:00:00'))]=array(1,array($valor['Matricula']));
            }
            
            //VALIDAR SIGUIENTE BLOQUE DE FLANJA HORARIA [11-14]
            if(strtotime($fechaFinConcatenada)>strtotime($valor['fecha_inicio'].' 11:00:00') && strtotime($fechaFinConcatenada)<=strtotime($valor['fecha_inicio'].' 14:00:00')){
                if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00')), $arrayResult)) {
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))][0]+1;
                    array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))][1],$valor['Matricula']);
                }else{
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))]=array(1,array($valor['Matricula']));
                }
            }

            //VALIDAR SIGUIENTE BLOQUE DE FLANJA HORARIA <14-17]
            else if(strtotime($fechaFinConcatenada)>strtotime($valor['fecha_inicio'].' 14:00:00') && strtotime($fechaFinConcatenada)<=strtotime($valor['fecha_inicio'].' 17:00:00')){


                if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00')), $arrayResult)) {
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))][0]+1;
                    array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))][1],$valor['Matricula']);
                }else{
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))]=array(1,array($valor['Matricula']));
                }
                
                if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00')), $arrayResult)) {
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))][0]+1;
                    array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))][1],$valor['Matricula']);
                }else{
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))]=array(1,array($valor['Matricula']));
                }            


            }
            

            //VALIDAR SIGUIENTE BLOQUE DE FLANJA HORARIA <17-+>
            else if(strtotime($fechaFinConcatenada)>strtotime($valor['fecha_inicio'].' 17:00:00')){

                if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00')), $arrayResult)) {
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))][0]+1;
                    array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))][1],$valor['Matricula']);
                }else{
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))]=array(1,array($valor['Matricula']));
                }
                
                if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00')), $arrayResult)) {
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))][0]+1;
                    array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))][1],$valor['Matricula']);
                }else{
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))]=array(1,array($valor['Matricula']));
                }            
    
                if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00')), $arrayResult)) {
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))][0]+1;
                    array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))][1],$valor['Matricula']);
                }else{
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))]=array(1,array($valor['Matricula']));
                }



            }
            

          
            

        }else if(strtotime($fechaInicioConcatenada)>=strtotime($valor['fecha_inicio'].' 11:00:00') && strtotime($fechaInicioConcatenada)<strtotime($valor['fecha_inicio'].' 14:00:00')){
            if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00')), $arrayResult)) {
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))][0]+1;
                array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))][1],$valor['Matricula']);
            }else{
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'11:00:00'))]=array(1,array($valor['Matricula']));
            }
            
            //VALIDAR SIGUIENTE BLOQUE DE FLANJA HORARIA <14-17]
            if(strtotime($fechaFinConcatenada)>strtotime($valor['fecha_inicio'].' 14:00:00') && strtotime($fechaFinConcatenada)<=strtotime($valor['fecha_inicio'].' 17:00:00')){

                if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00')), $arrayResult)) {
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))][0]+1;
                    array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))][1],$valor['Matricula']);
                }else{
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))]=array(1,array($valor['Matricula']));
                }            


            }
            
            //VALIDAR SIGUIENTE BLOQUE DE FLANJA HORARIA <17-+>
            else if(strtotime($fechaFinConcatenada)>strtotime($valor['fecha_inicio'].' 17:00:00')){

                if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00')), $arrayResult)) {
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))][0]+1;
                    array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))][1],$valor['Matricula']);
                }else{
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))]=array(1,array($valor['Matricula']));
                }            
    
                if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00')), $arrayResult)) {
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))][0]+1;
                    array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))][1],$valor['Matricula']);
                }else{
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))]=array(1,array($valor['Matricula']));
                }



            }
            

            
            
            
        }else if(strtotime($fechaInicioConcatenada)>=strtotime($valor['fecha_inicio'].' 14:00:00') && strtotime($fechaInicioConcatenada)<strtotime($valor['fecha_inicio'].' 17:00:00')){

            if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00')), $arrayResult)) {
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))][0]+1;
                array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))][1],$valor['Matricula']);
            }else{
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'14:00:00'))]=array(1,array($valor['Matricula']));
            }


            //VALIDAR SIGUIENTE BLOQUE DE FLANJA HORARIA <17-+>
            if(strtotime($fechaFinConcatenada)>strtotime($valor['fecha_inicio'].' 17:00:00')){

                if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00')), $arrayResult)) {
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))][0]+1;
                    array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))][1],$valor['Matricula']);
                }else{
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))]=array(1,array($valor['Matricula']));
                }


            }
            
            
                
        }else if(strtotime($fechaInicioConcatenada)>=strtotime($valor['fecha_inicio'].' 17:00:00')){
            
            if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00')), $arrayResult)) {
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))][0]+1;
                array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))][1],$valor['Matricula']);
            }else{
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['fecha_inicio'].'17:00:00'))]=array(1,array($valor['Matricula']));
            }

            
        }
        
        

            
        }

    }
    
    return $arrayResult;
    
}


function ContadorGeneral($arrayDatos) {

    $arrayResult=array();    
    
    foreach($arrayDatos as $clave => $valor) 
    {
        $fechaInicioConcatenada = date("Y-m-d H:i:s",strtotime($valor['FechaInst'].' '.$valor['HoraInst']));
        $fechaAuxiliarConcatenada  = strtotime ( "3 hours" , strtotime ( $valor['FechaInst']." ".$valor['HoraInst'] ) ) ;  
        $fechaFinConcatenada   = date ('Y-m-d H:i:s' , $fechaAuxiliarConcatenada );
        
        if(strtotime($fechaInicioConcatenada)>=strtotime($valor['FechaInst'].' 08:00:00') && strtotime($fechaInicioConcatenada)<strtotime($valor['FechaInst'].' 11:00:00')){
            if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'08:00:00')), $arrayResult)) {
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'08:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'08:00:00'))][0]+1;
                array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'08:00:00'))][1],$valor['Matricula']);
            }else{
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'08:00:00'))]=array(1,array($valor['Matricula']));
                
            }
            //VALIDAR SIGUIENTE BLOQUE DE FLANJA HORARIA
            if(strtotime($fechaFinConcatenada)>strtotime($valor['FechaInst'].' 11:00:00') && strtotime($fechaFinConcatenada)<strtotime($valor['FechaInst'].' 14:00:00')){
                if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'11:00:00')), $arrayResult)) {
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'11:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'11:00:00'))][0]+1;
                    array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'11:00:00'))][1],$valor['Matricula']);
                }else{
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'11:00:00'))]=array(1,array($valor['Matricula']));
                }
            }
            

        }else if(strtotime($fechaInicioConcatenada)>=strtotime($valor['FechaInst'].' 11:00:00') && strtotime($fechaInicioConcatenada)<strtotime($valor['FechaInst'].' 14:00:00')){
            if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'11:00:00')), $arrayResult)) {
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'11:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'11:00:00'))][0]+1;
                array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'11:00:00'))][1],$valor['Matricula']);
            }else{
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'11:00:00'))]=array(1,array($valor['Matricula']));
            }
            
            //VALIDAR SIGUIENTE BLOQUE DE FLANJA HORARIA
            if(strtotime($fechaFinConcatenada)>strtotime($valor['FechaInst'].' 14:00:00') && strtotime($fechaFinConcatenada)<strtotime($valor['FechaInst'].' 17:00:00')){
                if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'14:00:00')), $arrayResult)) {
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'14:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'14:00:00'))][0]+1;
                    array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'14:00:00'))][1],$valor['Matricula']);
                }else{
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'14:00:00'))]=array(1,array($valor['Matricula']));
                }
            }
            
            
            
        }else if(strtotime($fechaInicioConcatenada)>=strtotime($valor['FechaInst'].' 14:00:00') && strtotime($fechaInicioConcatenada)<strtotime($valor['FechaInst'].' 17:00:00')){

            if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'14:00:00')), $arrayResult)) {
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'14:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'14:00:00'))][0]+1;
                array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'14:00:00'))][1],$valor['Matricula']);
            }else{
            $arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'14:00:00'))]=array(1,array($valor['Matricula']));
            }


            //VALIDAR SIGUIENTE BLOQUE DE FLANJA HORARIA
            if(strtotime($fechaFinConcatenada)>strtotime($valor['FechaInst'].' 17:00:00') && strtotime($fechaFinConcatenada)<strtotime($valor['FechaInst'].' 20:00:00')){
                if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'17:00:00')), $arrayResult)) {
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'17:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'17:00:00'))][0]+1;
                    array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'17:00:00'))][1],$valor['Matricula']);
                }else{
                    $arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'17:00:00'))]=array(1,array($valor['Matricula']));
                }
            }            
            
                
        }else if(strtotime($fechaInicioConcatenada)>=strtotime($valor['FechaInst'].' 17:00:00') && strtotime($fechaInicioConcatenada)<strtotime($valor['FechaInst'].' 20:00:00')){
            
            if (array_key_exists(date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'17:00:00')), $arrayResult)) {
                $arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'17:00:00'))][0]=$arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'17:00:00'))][0]+1;
                array_push($arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'17:00:00'))][1],$valor['Matricula']);
            }else{
            $arrayResult[date("Y-m-d H:i:s",strtotime($valor['FechaInst'].'17:00:00'))]=array(1,array($valor['Matricula']));
            }

            
        }
        
    }
    
    
    return $arrayResult;
}



//FUNCIONES UFT8 Y Fecha
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}



?>