<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
            <div class="row">
                <div class="col-xxl-3 col-sm-6">
                    <div class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <p class="fw-medium text-muted mb-0">Total de reposiciones</p>
                                    <h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target=""></span></h2>
                                    <!--<h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="547">547</span>k</h2>-->
                                    <!--<p class="mb-0 text-muted"><span class="badge bg-light text-success mb-0"> <i class="ri-arrow-up-line align-middle"></i> 17.32 % </span> vs. previous month</p>-->
                                </div>
                                <div>
                                    <div class="avatar-sm flex-shrink-0">
                                        <span class="avatar-title bg-sistema-25 rounded-circle fs-4">
                                            <i class="mdi mdi-ticket-account" style="font-size: 28px;"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div><!-- end card body -->
                    </div> <!-- end card-->
                </div>
                <!--end col-->
                <div class="col-xxl-3 col-sm-6">
                    <div class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <p class="fw-medium text-muted mb-0">Reposiciones del mes</p>
                                    <h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target=""></span></h2>
                                    <!--<h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="124">124</span>k</h2>-->
                                    <!--<p class="mb-0 text-muted"><span class="badge bg-light text-danger mb-0"> <i class="ri-arrow-down-line align-middle"></i> 0.96 % </span> vs. previous month</p>-->
                                </div>
                                <div>
                                    <div class="avatar-sm flex-shrink-0">
                                        <span class="avatar-title bg-sistema-25 rounded-circle fs-4">
                                            <i class="mdi mdi-calendar-month-outline" style="font-size: 28px;"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div><!-- end card body -->
                    </div>
                </div>
                <!--end col-->
                <div class="col-xxl-3 col-sm-6">
                    <div class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <p class="fw-medium text-muted mb-0">Reposiciones pendientes</p>
                                    <h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target=""></span></h2>
                                    <!--<h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="107">107</span>K</h2>-->
                                    <!--<p class="mb-0 text-muted"><span class="badge bg-light text-danger mb-0"> <i class="ri-arrow-down-line align-middle"></i> 3.87 % </span> vs. previous month</p>-->
                                </div>
                                <div>
                                    <div class="avatar-sm flex-shrink-0">
                                        <span class="avatar-title bg-sistema-25 rounded-circle fs-4">
                                            <i class="mdi mdi-timer-sand" style="font-size: 28px;"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div><!-- end card body -->
                    </div>
                </div>
                <!--end col-->
                <div class="col-xxl-3 col-sm-6">
                    <div class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <p class="fw-medium text-muted mb-0">Reposiciones sin iniciar</p>
                                    <h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target=""></span></h2>
                                    <!--<h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="15.95">15.95</span>%</h2>-->
                                    <!--<p class="mb-0 text-muted"><span class="badge bg-light text-success mb-0"> <i class="ri-arrow-up-line align-middle"></i> 1.09 % </span> vs. previous month</p>-->
                                </div>
                                <div>
                                    <div class="avatar-sm flex-shrink-0">
                                        <span class="avatar-title bg-sistema-25 rounded-circle fs-4">
                                            <i class="mdi mdi-clock-alert-outline" style="font-size: 28px;"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div><!-- end card body -->
                    </div>
                </div>
                <!--end col-->
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card" id="ticketsList">
                        <div class="card-header border-0">
                            <div class="d-flex align-items-center">
                                <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                                <div class="d-flex">
                                    <button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#registrarReposicion" data-form="#formRegistrarReposicion" id="btnNuevaReposicion" data-placement="top" title="Registrar Reposición" aria-label="Registrar Reposición">
                                        <i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i>Reposición
                                    </button>
                                    <button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                        <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <!--end card-body-->
                        <div class="card-body">
                            <div class="mb-4 table-responsive">
                                <table id="tblSolicitudesReposicion" class="table table-bordered dt-responsive nowrap table-striped align-middle" width="100%">
                                    
                                </table>
                            </div>
                        </div>
                        <!--end card-body-->
                    </div>
                    <!--end card-->
                </div>
                <!--end col-->
            </div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<?= $this->section('js'); ?>
<script>
	$(function () {
	    /***SERVERSIDE SOLICITUDES DE REPOSICIÓN***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblSolicitudesReposicion').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/solicitud-reposicion-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						}
					},
					"columns": [
						{"title": "Nro Solicitud", "data": "IDSolicitudReposicion", "class": "text-center", "searchable": true },
						{"title": "Fecha de Solicitud", "data": "FechaSolicitudReposicion", "class": "text-center", "searchable": true },
						{"title": "Fecha Último Cambio", "data": "FechaUltimoCambio", "class": "text-center", "searchable": true },
						{"title": "Solicitante", "data": "SolicitanteReposicion", "class": "text-center", "searchable": true },
						{"title": "Adjudicado", "data": "AdjudicadoReposicion", "class": "text-center", "searchable": true },
						{"title": "Elemento", "data": "ElementoReposicion", "class": "text-center", "searchable": true },
						{"title": "Motivo Reposición", "data": "MotivoReposicion", "class": "text-center", "searchable": true },
						{"title": "Estado", "data": "EstadoSolicitud", "class": "text-center", "searchable": true },
						{"title": "Acciones", "data": "Acciones", "class": "text-center", "searchable": true }
					],
                    "drawCallback": function(settings) {
                        // Re-inicializar tooltips después de que los datos son cargados
                        $('[data-tooltip="tooltip"]').tooltip();
                        $('[data-toggle="tooltip"]').tooltip();
                    },
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
                    columnDefs: [
                        { responsivePriority: 1, targets: 0 },
                        { responsivePriority: 1, targets: 1 },
                        { responsivePriority: 1, targets: 2 },
                        { responsivePriority: 6, targets: 3 },
                        { responsivePriority: 1, targets: 4 },
                        { responsivePriority: 1, targets: 5 },
                        { responsivePriority: 6, targets: 6 },
                        { responsivePriority: 1, targets: 7 },
                        { responsivePriority: 1, targets: 8 }
                    ],
					autoWidth: false,
					"aaSorting": [[0, 'desc']],
				});
			}
		}

		assetListVM.init();
		/****FIN SERVERSIDE SOLICITUDES DE REPOSICIÓN****/
		
		pondDenunciaSolicitudReposicion = FilePond.create(
            document.querySelector("#fileAdjuntoReposicion"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false
            }
        );
        
        $('#txtMotivoReposicion').select2({
            dropdownParent: $('#registrarReposicion .modal-body')
        });
        
        $("#txtAdjudicadoReposicion").select2({
            minimumInputLength: 2,
            placeholder: 'Seleccione Adjudicado',
            dropdownParent: $('#registrarReposicion .modal-body'),
            allowClear: true,
            language: {
                errorLoading: function() {
                    return "La carga falló";
                },
                noResults: function() {
                    return "No hay resultado";
                },
                searching: function() {
                    return "Buscando..";
                }
            },
            ajax: {
                url: baseUrl + '/listado-usuarios-select',
                dataType: 'json',
                type: "POST",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: data
                    };
                }
            }
        });
        
        $(document).on('change', '#txtAdjudicadoReposicion', function(e) {
            var idUsuario = $(this).val();
            
            if(idUsuario != '')
            {
                var parametros = {
                    "idUsuario"  : idUsuario
            	};
            	
                $.ajax({        
                    url: baseUrl + '/obtener-datos-usuario',
                    type: "POST",
                    data: parametros,
                    dataType: 'json',
                    beforeSend: function() {
                        Swal.fire({
                            html: 'Un momento por favor...',
                            heightAuto: true,
                            showConfirmButton: false
                        });
                    },
                    success: function(response) {
                        Swal.close();
                        if (response.descripcion === 0 || response.descripcion === 2) 
                        {
                            Swal.fire({
                                title: response.mensaje,
                                icon: 'warning',
                                showCancelButton: false,
                                confirmButtonColor: '#282E38',
                                confirmButtonText: 'Confirmar'
                            });
                            $('#txtAdjudicadoReposicion').val('').trigger('change');
                            $('#txtMatriculaAdjudicado').val('');
                            $('#txtNombreAdjudicado').val('');
                            $('#txtApellidoAdjudicado').val('');
                            $('#txtDocumentoAdjudicado').val('');
                            $('#txtDireccionAdjudicado').val('');
                            $('#txtAreaAdjudicado').val('');
                            $('#txtCargoAdjudicado').val('');
                        }
                        else 
                        {
                            $('#txtMatriculaAdjudicado').val(response.matricula);
                            $('#txtNombreAdjudicado').val(response.nombres);
                            $('#txtApellidoAdjudicado').val(response.apellidos);
                            $('#txtDocumentoAdjudicado').val(response.documento);
                            $('#txtDireccionAdjudicado').val(response.direccion);
                            $('#txtAreaAdjudicado').val(response.area);
                            $('#txtCargoAdjudicado').val(response.cargo);
                        }
                        
                        $('.validarNextTab').blur();
                    }, 
                    error: function(jqXHR, textStatus, errorThrown){
                        //$.unblockUI({});
                        Swal.close();
                        
                        Swal.fire({
                            title: 'Ha ocurrido un error interno',
                            text: errorThrown,
                            icon: 'error',
                            showCancelButton: false,
                            confirmButtonColor: '#E4002B',
                            confirmButtonText: 'Confirmar'
                        });
                    }
                });
                
                $('#txtItemReposicion').empty();
                $.post(baseUrl + '/listado-items-asignados', 
                {
                    idUsuario : idUsuario,
                    motivoReposicion    : $("#txtMotivoReposicion").val()
                }, 
                function(response) {
                    if (response.descripcion === 0) {
                        //alert("Ocurrió un error al obtener los datos.");
                    } else {
                        var items = $.parseJSON(response.listadoItems);
                        $("#txtItemReposicion").append('\
                            <option value="">Seleccione una opción</td>\n\
                        ');
                        for(var i = 0; i < items.length; i++){
                            $("#txtItemReposicion").append('\
                                <option value="' + items[i].id + '" >' + items[i].item +'</td>\n\
                            ');
                        }
                    }
                }, 'json');
                $('#txtItemReposicion').select2({
                    dropdownParent: $('#registrarReposicion .modal-body')
                });
            }
        });

        $(document).on('change', '#txtMotivoReposicion', function(e) {
            var motivoReposicion = $(this).val();
            var idUsuario = $("#txtAdjudicadoReposicion").val();
            
            if(idUsuario != '')
            {
                $('#txtItemReposicion').empty();
                $.post(baseUrl + '/listado-items-asignados', 
                {
                    idUsuario           : idUsuario,
                    motivoReposicion    : motivoReposicion
                }, 
                function(response) {
                    if (response.descripcion === 0) {
                        //alert("Ocurrió un error al obtener los datos.");
                    } else {
                        var items = $.parseJSON(response.listadoItems);
                        $("#txtItemReposicion").append('\
                            <option value="">Seleccione una opción</td>\n\
                        ');
                        for(var i = 0; i < items.length; i++){
                            $("#txtItemReposicion").append('\
                                <option value="' + items[i].id + '" >' + items[i].item +'</td>\n\
                            ');
                        }
                    }
                }, 'json');
                $('#txtItemReposicion').select2({
                    dropdownParent: $('#registrarReposicion .modal-body')
                });
            }
        });

    	$('#txtElementoNuevaAsignacion').select2({
            dropdownParent: $('#nuevaAsignacion .modal-body')
        });
        
	});
</script>
<?php $this->endSection(); ?>



<!-- Filtros -->
<form class="filtroInactivo" autocomplete="off" action="" method="POST" accept-charset="utf-8">
    <div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
        <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
            <h5 class="m-0 me-2 text-white">Filtros</h5>
    
            <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body p-0">
            <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
            <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
            <!--        <div class="simplebar-height-auto-observer-wrapper">-->
            <!--            <div class="simplebar-height-auto-observer">-->
                            
            <!--            </div>-->
            <!--        </div>-->
            <!--        <div class="simplebar-mask">-->
            <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
            <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
            <!--                    <div class="simplebar-content" style="padding: 0px;">-->
                <div id="ctnFiltro" class="p-3">
    				<div class="card border" style="border-top: 3px #536878 solid!important;">
    					<div class="card-header">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1">
                                    <h6 class="card-title mb-0">Columnas</h6>
                                </div>
                                <div class="flex-shrink-0">
                                    <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                        <li class="list-inline-item">
                                            <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseColumnasFiltros" role="button" aria-expanded="true" aria-controls="collapseColumnasFiltros">
                                                <i class="mdi mdi-plus align-middle plus"></i>
                                                <i class="mdi mdi-minus align-middle minus"></i>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
    					<div class="card-body collapse show" id="collapseColumnasFiltros" style="">
    						cxcvcxxvxcxcv
    					</div>
    				</div>
    				<div class="panel">
                        <div class="panel-heading">
                            <h4>Columnas</h4>
                        </div>
                        <div class="panel-content">
                            <div class="row">
                                adasasads
                            </div>
                        </div>
                    </div>
                </div>
            <!--                    </div>-->
            <!--                </div>-->
            <!--            </div>-->
            <!--        </div>-->
            <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                        
            <!--        </div>-->
            <!--    </div>-->
            <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
            <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                        
            <!--        </div>-->
            <!--    </div>-->
            <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
            <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                        
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->
        </div>
        <div class="offcanvas-footer border-top p-3 text-center">
            <div class="row">
                <div class="col-4">
                    <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
                </div>
                <div class="col-4">
                    <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
                </div>
                <div class="col-4">
                    <button type="submit" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
                </div>
            </div>
        </div>
    </div>
</form>

<!-- Modal Registrar Petición -->
<div class="modal fade zoomIn" id="registrarReposicion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleRegistrarReposicion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema d-flex justify-content-start align-items-center p-3">
				<h5 class="modal-title color-white" id="exampleRegistrarReposicion">Solicitar Reposición</h5>
                <button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close" id="close-modal"></button>
			</div>
			<form id="formRegistrarReposicion" class="formulario form-steps" autocomplete="off" action="<?= $baseUrl ?>/solicitar-reposicion-item" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
                    <div class="step-arrow-nav mb-4">
                        <ul class="nav nav-pills custom-nav nav-justified" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="tabSolicitudReposicion" data-bs-toggle="pill" data-bs-target="#tabcontentSolicitudReposicion" type="button" role="tab" aria-controls="tabcontentSolicitudReposicion" aria-selected="true" data-position="0">Información de Usuario</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="tabDetalleReposicion" data-bs-toggle="pill" data-bs-target="#tabcontenDetalleReposicion" type="button" role="tab" aria-controls="tabcontenDetalleReposicion" aria-selected="false" data-position="1">Elementos a reponer</button>
                            </li>
                        </ul>
                    </div>

                    <div class="tab-content">
                        <div class="tab-pane fade active show" id="tabcontentSolicitudReposicion" role="tabpanel" aria-labelledby="tabSolicitudReposicion">
                            <div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-8 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label" >Usuario Solicitante</label>
            								<input type="text" class="form-control" style="color: #0000FF" value="<?= $nombres.' '.$apellidos ?>" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label" >Matrícula Solicitante</label>
            								<input type="text" class="form-control" style="color: #0000FF" value="<?= $matriculaLog ?>" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
                                    <div class="col-xxl-8 col-md-12 col-12 px-3">
                                        <div>
                                            <label for="txtAdjudicadoReposicion" class="form-label">Usuario Adjudicado</label>
                                            <select class="form-select" aria-label="Adjudicado" id="txtAdjudicadoReposicion" name="txtAdjudicadoReposicion">
                                                <option selected="" value="">Seleccione una opción</option>
                                            </select>
                                        </div>
                                    </div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtMatriculaAdjudicado" class="form-label" >Matrícula Adjudicado</label>
            								<input type="text" class="form-control validarNextTab" id="txtMatriculaAdjudicado" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtNombreAdjudicado" class="form-label" >Nombre Adjudicado</label>
            								<input type="text" class="form-control validarNextTab" id="txtNombreAdjudicado" name="txtNombreAdjudicado" disabled >
            							</div>
            						</div>
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtApellidoAdjudicado" class="form-label">Apellido Adjudicado</label>
            								<input type="text" class="form-control validarNextTab" id="txtApellidoAdjudicado" name="txtApellidoAdjudicado" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtDocumentoAdjudicado" class="form-label">Documento Adjudicado</label>
            								<input type="text" class="form-control validarNextTab" id="txtDocumentoAdjudicado" name="txtDocumentoAdjudicado" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtDireccionAdjudicado" class="form-label" >Dirección Adjudicado</label>
            								<input type="text" class="form-control validarNextTab" id="txtDireccionAdjudicado" name="txtDireccionAdjudicado" disabled >
            							</div>
            						</div>
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtAreaAdjudicado" class="form-label">Área Adjudicado</label>
            								<input type="text" class="form-control validarNextTab" id="txtAreaAdjudicado" name="txtAreaAdjudicado" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtCargoAdjudicado" class="form-label">Cargo Adjudicado</label>
            								<input type="text" class="form-control validarNextTab" id="txtCargoAdjudicado" name="txtCargoAdjudicado" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-12 col-md-12 col-12 px-3">
            						    <div>
                                            <label for="txtMotivoReposicion" class="form-label">Motivo de reposición</label>
                                            <select class="form-select validarNextTab" aria-label="Motivo" id="txtMotivoReposicion" name="txtMotivoReposicion">
                                                <option selected="" value="">Seleccione una opción</option>
                                                <option value="ROB">ROBO</option>
                                                <option value="PER">PÉRDIDA</option>
                                                <option value="NOD">NO DEVOLUCIÓN</option>
                                                <option value="FAL">FALLA</option>
                                                <option value="REN">RENOVACIÓN</option>
                                                <option value="INC">KIT INCOMPLETO</option>
                                            </select>
                                        </div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-12 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtObservacion" class="form-label">Observación</label>
            								<textarea class="form-control validarNextTab" id="txtObservacion" name="txtObservacion" rows="4"></textarea>
            							</div>
            						</div>
        					    </div>
        					    <div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-3 mb-3 d-flex justify-content-between align-items-center" style="border-radius: 10px; font-size: 15px;">
            					    Denuncia policial
            					</div>
            					<div class="row col-12 m-0 p-0 d-flex justify-content-center">
            						<div class="col-10 m-0 p-0">
            					        <input type="file" id="fileAdjuntoReposicion" class="filepond" name="fileAdjuntoReposicion" data-max-file-size="100MB" data-max-files="1" />
            					    </div>
        					    </div>
        					    <?php
								if (in_array("EXCORE", $permisos)) 
								{
								?>
        					    <div class="col-12 col-md-12 px-3 justify-content-end">
        							<div class="col-xxl-12 col-md-12 col-12 border-sistema-2px p-2 d-flex justify-content-between align-items-center" style="border-radius: 15px;">
            						    <h5 class="color-sistema m-0" for="chkExcepcionCobro">¿Excepción de cobro de reposición?</h5>
            						    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center" for="chkExcepcionCobro">
            								<input class="form-check-input form-check-input-sistema" type="checkbox" role="switch" name="chkExcepcionCobro" id="chkExcepcionCobro">
            								<label class="form-check-label m-0" for="chkExcepcionCobro"></label>
            							</div>
            						</div>
            					</div>
            					<?php
								}
								?>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabDetalleReposicion" id="btnNextTab" disabled><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Ingresar elementos</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                        <div class="tab-pane fade" id="tabcontenDetalleReposicion" role="tabpanel" aria-labelledby="tabDetalleReposicion">
                            <div>
        					    <div class="row col-12 m-0 p-0 mb-0 d-flex">
        					        <div class="alert alert-warning border-0" role="alert">
                                        <li>La reposición generará automáticamente la autorización de descuento que será enviada al correo del trabajador para que pueda ser firmado y poder gestionar el envío de un nuevo dispositivo.</li>
                                        <li>En casos particulares, la autorización de descuento se enviará luego de un proceso de revisión del dispositivo devuelto, por lo que se verá reflejado si se generó el documento o está siendo validado.</li>
                                        <li>El monto a descontarse y las cuotas dependerá del motivo por el cual se solicita la reposición y/o el resultado de la revisión del dispositivo.</li>
                                    </div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-10 col-md-12 col-12 px-3">
            							<div>
                                            <label for="txtItemReposicion" class="form-label">Item</label>
                                            <select class="form-select" aria-label="Item" id="txtItemReposicion" name="txtItemReposicion">
                                                <option selected="" value="">Seleccione una opción</option>
                                            </select>
                                        </div>
            						</div>
            						<div class="col-xxl-2 col-md-12 col-12 px-3 d-flex justify-content-end align-items-center">
            						    <button type="button" class="btn bg-success px-2 py-1 ms-3" onclick="return agregarItemReposicion();" data-tooltip="tooltip" aria-label="Agregar Item a la reposición">
                                            <i class="mdi mdi-plus" style="font-size: 24px; color: #FFF"></i>
                                        </button>
            						</div>
        					    </div>
                                <div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-3 mb-3 d-flex justify-content-between align-items-center" style="border-radius: 10px; font-size: 15px;">
            					    Elementos para reponer
            					</div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex" id="ctnElementosReposicion">
            						
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-light btn-label previestab" data-previous="tabSolicitudReposicion"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar a la asignación</button>
                                <button type="submit" class="btn btn-success btn-label right ms-auto"><i class="mdi mdi-content-save label-icon align-middle fs-16 ms-2"></i>Guardar</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                    </div>
                    <!-- end tab content -->
				</div>
			</form>
		</div>
	</div>
</div>

<?php $this->endSection(); ?>