<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div class="d-flex">
                                <button type="button" class="btn bg-warning d-flex align-items-center mx-1 color-white" id="btnExportarTotalCesados">
    								<i class="mdi mdi-file-download" style="font-size: 14px;"></i> Exportar Cesados
    							</button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblReporteAsignaciones" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Matrícula</th>
										<th class="text-center align-middle">Usuario</th>
										<th class="text-center align-middle">Nombre y Apellidos</th>
										<th class="text-center align-middle">Elemento</th>
										<th class="text-center align-middle">Tipo</th>
										<th class="text-center align-middle">Marca</th>
										<th class="text-center align-middle">Modelo</th>
										<th class="text-center align-middle">Serie</th>
										<th class="text-center align-middle">Fecha Asignación</th>
										<th class="text-center align-middle">Cantidad Robos</th>
										<th class="text-center align-middle">Total</th>
										<th class="text-center align-middle">Verisure</th>
										<th class="text-center align-middle">usuario</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listaAsignaciones as $items){ ?>
									<tr>
										<td class="text-center align-middle"><span class="d-none"><?= $items['Estado_Usuario'] ?></span><?= $items['Matricula'] ?></td>
										<td class="text-center align-middle"><span class="<?= $items['Estado_Usuario'] == 'Activo' ? 'text-dark' : 'badge bg-danger color-white' ?> border-0"><?= $items['Usuario'] ?></span></td>
										<td class="text-center align-middle"><?= $items['NOMBRE'] ?></td>
										<td class="text-center align-middle"><?= $items['ELEMENTO'] ?></td>
										<td class="text-center align-middle"><?= $items['TIPO'] ?></td>
										<td class="text-center align-middle"><?= $items['MARCA'] ?></td>
										<td class="text-center align-middle"><?= $items['MODELO'] ?></td>
										<td class="text-center align-middle"><?= $items['SERIE'] ?></td>
										<td class="text-center align-middle"><?= date("d-m-Y", strtotime($items['Fecha de Asignación'])) ?></td>
										<td class="text-center align-middle"><?= $items['CANTIDADROBO'] ?></td>
										<td class="text-center align-middle"><?= $items['TOTAL'] ?></td>
										<td class="text-center align-middle"><?= $items['VERISURE'] ?></td>
										<td class="text-center align-middle"><?= $items['TRABAJADOR'] ?></td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<?php $this->endSection(); ?>