<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
                                <button class="btn bg-warning d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#exportarMoviles">
									<i class="mdi mdi-file-export me-1" style="font-size: 14px;"></i>Exportar
								</button>
								<?php
								if (in_array("ADDMOV", $permisos)) 
								{
								?>
                                <button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white datos-movil" data-bs-target="#informacionMovil" data-form="#formInformacionMovil" data-id="0" data-accion="crear" id="crear-movil">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i>Nuevo
								</button>
								<?php
								}
								?>
								<button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblMoviles" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
	$(function () {
		/***SERVERSIDE LISTADO DE MÓVILES***/
		assetListVM = {
			dt: null,
			params: {},  // Para almacenar parámetros adicionales de filtro
			init: function () {
				this.dt = $('#tblMoviles').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/moviles-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						    
						    // Agregar los parámetros adicionales de filtro a la solicitud
                            $.each(assetListVM.params, function(key, value) {
                                d[key] = value;
                            });
						}
					},
					"columns": [
						{"title": "Código", "data": "IDMovil", "class": "text-center", "searchable": true },
						{"title": "IMEI", "data": "IMEI", "class": "text-center", "searchable": true },
						{"title": "Marca", "data": "Marca", "class": "text-center", "searchable": true },
						{"title": "Modelo", "data": "Modelo", "class": "text-center", "searchable": true },
						{"title": "Fecha de Compra", "data": "FechaCompraMovil", "class": "text-center", "searchable": true, "orderable": false },
						{"title": "Estado", "data": "EstadoMovil", "class": "text-center", "searchable": true },
						{"title": "¿Equipo Stock?", "data": "EquipoStockMovil", "class": "text-center", "searchable": true },
						{"title": "Usuario Asignado", "data": "UsuarioAsignado", "class": "text-center", "searchable": false, "orderable": false },
						{"title": "Nombre Asignado", "data": "NombreAsignado", "class": "text-center", "searchable": false, "orderable": false },
						{"title": "Matrícula", "data": "MatriculaAsignado", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Acciones", "data": "acciones", "class": "text-center", "searchable": false, "orderable": false },
					],
                    "drawCallback": function(settings) {
                        // Re-inicializar tooltips después de que los datos son cargados
                        $('[data-tooltip="tooltip"]').tooltip();
                        $('[data-toggle="tooltip"]').tooltip();
                    },
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 10,
					"paging": true,
					"aaSorting": [[0, 'desc']],
				});
			},
			// Método para aplicar filtros adicionales
            applyFilters: function(filters) {
                this.params = filters;  // Actualiza los parámetros de filtro
                
                if (this.dt) {
                    this.dt.clear();  // Limpia los datos previos
                    this.dt.destroy();  // Destruye la instancia actual de DataTable
                }
            
                // Reinicia DataTable con los nuevos filtros
                this.init();
            }
		}

// 		assetListVM.init();
		/****FIN SERVERSIDE LISTADO MÓVILES****/
		
        /***********************************/
        /*  INPUTS DE FILTRO */
        /***********************************/
        
        selectMarcas("cboMarcaFiltro", "", "");
        
		$('#cboModeloFiltro').select2({
            dropdownParent: $('#ctnFiltro')
        });
        
        $(document).on('change', '#cboMarcaFiltro', function() {
            var idMarca = $(this).val();
            $("#cboModeloFiltro").empty();
            
            selectDispositivos("cboModeloFiltro", idMarca, "", "", "");
        });
        
        /*---------------------------*/
        
        selectDireccionEstructura("cboDireccionFiltro", "", "");
        
		$('#cboAreaFiltro').select2({
            dropdownParent: $('#ctnFiltro')
        });
        
		$('#cboSubareaFiltro').select2({
            dropdownParent: $('#ctnFiltro')
        });
        
        $(document).on('change', '#cboDireccionFiltro', function() {
            var idDireccion = $(this).val();
            $("#cboAreaFiltro").empty();
            $("#cboSubareaFiltro").empty();
            
            selectAreaEstructura("cboAreaFiltro", idDireccion, "", "");
        });
        
        $(document).on('change', '#cboAreaFiltro', function() {
            var idArea = $(this).val();
            $("#cboSubareaFiltro").empty();
            
            selectSubareaEstructura("cboSubareaFiltro", idArea, "", "");
        });
        
        $(document).on('click', '#btnLimpiar', function() {
            $('#cboMarcaFiltro').val('').trigger('change');
            $('#cboDireccionFiltro').val('').trigger('change');
            
            $('#rdbtnTodoAsignadosFiltro').prop("checked", true);
            $('#chkEstadoActivoFiltro').prop("checked", true);
            
            $('.filtro').trigger('submit');
        });
        
        // Disparar el submit del formulario al cargar la página
        $('.filtro').trigger('submit');
	});
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->
<form class="filtro" autocomplete="off" action="" method="POST" accept-charset="utf-8">
    <div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
        <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
            <h5 class="m-0 me-2 text-white">Filtros</h5>
    
            <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body p-0">
            <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
            <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
            <!--        <div class="simplebar-height-auto-observer-wrapper">-->
            <!--            <div class="simplebar-height-auto-observer">-->
                            
            <!--            </div>-->
            <!--        </div>-->
            <!--        <div class="simplebar-mask">-->
            <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
            <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
            <!--                    <div class="simplebar-content" style="padding: 0px;">-->
                <div id="ctnFiltro" class="p-3">
				    <div class="panel">
                        <div class="panel-heading">
                            <h4>Marca - Modelo</h4>
                        </div>
                        <div class="panel-content">
                            <div class="row">
                                <div class="col-xxl-12 col-md-12 col-12 p-2">
                					<div class="col-xxl-12 col-md-12 col-12 my-2">
                						<div>
                						    <label class="form-label fw-bold text-start">Marca</label>
                							<select class="form-select" aria-label="Marca" id="cboMarcaFiltro" name="marcaFiltro" placeholder="Marca">
                								<option selected="" value="">Seleccione una opción</option>
                								
                							</select>
                						</div>
                					</div>
                        		</div>
                                <div class="col-xxl-12 col-md-12 col-12 p-2">
                        		    <div class="col-xxl-12 col-md-12 col-12 my-2">
                						<div>
                						    <label class="form-label fw-bold text-start">Modelo</label>
                							<select class="form-select" aria-label="Modelo" id="cboModeloFiltro" name="modeloFiltro" placeholder="Modelo">
                								<option selected="" value="">Seleccione una opción</option>
                								
                							</select>
                						</div>
                					</div>
                        		</div>
                            </div>
                        </div>
                    </div>
                    <div class="panel">
                        <div class="panel-heading">
                            <h4>Estado</h4>
                        </div>
                        <div class="panel-content">
                            <div class="row">
                                <div class="col-xxl-4 col-md-12 col-12 p-1 m-0">
                                    <div class="d-flex justify-content-left">
                                        <center class="content-left" style="position: relative; height: 40px;">
                                            <input type="checkbox" id="chkEstadoActivoFiltro" name="estadosFiltro[]" class="chk-basico chk-activo chkEstadoFiltro" value="ACT" checked>
                                            <label for="chkEstadoActivoFiltro"></label>
                            			</center>
                            			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center text-start" for="chkEstadoActivoFiltro">Activo</label>
                            		</div>
                            	</div>
                                <div class="col-xxl-4 col-md-12 col-12 p-1 m-0">
                                    <div class="d-flex justify-content-left">
                                        <center class="content-left" style="position: relative; height: 40px;">
                                            <input type="checkbox" id="chkEstadoAveriadoFiltro" name="estadosFiltro[]" class="chk-basico chk-averiado chkEstadoFiltro" value="AVE">
                                            <label for="chkEstadoAveriadoFiltro"></label>
                            			</center>
                            			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center text-start" for="chkEstadoAveriadoFiltro">Averiado</label>
                            		</div>
                            	</div>
                                <div class="col-xxl-4 col-md-12 col-12 p-1 m-0">
                                    <div class="d-flex justify-content-left">
                                        <center class="content-left" style="position: relative; height: 40px;">
                                            <input type="checkbox" id="chkEstadoBajaFiltro" name="estadosFiltro[]" class="chk-basico chk-baja chkEstadoFiltro" value="BAJ">
                                            <label for="chkEstadoBajaFiltro"></label>
                            			</center>
                            			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center text-start" for="chkEstadoBajaFiltro">Baja</label>
                            		</div>
                            	</div>
                            </div>
                        </div>
                    </div>
    				<div class="panel">
                        <div class="panel-heading">
                            <h4>Subárea de usuario asignado</h4>
                        </div>
                        <div class="panel-content">
                            <div class="row">
                                <div class="col-xxl-12 col-md-12 col-12 p-2">
                					<div class="col-xxl-12 col-md-12 col-12 my-2">
                						<div>
                						    <label class="form-label fw-bold text-start">Dirección</label>
                							<select class="form-select" aria-label="Dirección" id="cboDireccionFiltro" name="direccionFiltro" placeholder="Dirección">
                								<option selected="" value="">Seleccione una opción</option>
                								
                							</select>
                						</div>
                					</div>
                        		</div>
                                <div class="col-xxl-12 col-md-12 col-12 p-2">
                        		    <div class="col-xxl-12 col-md-12 col-12 my-2">
                						<div>
                						    <label class="form-label fw-bold text-start">Área</label>
                							<select class="form-select" aria-label="Área" id="cboAreaFiltro" name="areaFiltro" placeholder="Área">
                								<option selected="" value="">Seleccione una opción</option>
                								
                							</select>
                						</div>
                					</div>
                        		</div>
                                <div class="col-xxl-12 col-md-12 col-12 p-2">
                        		    <div class="col-xxl-12 col-md-12 col-12 my-2">
                						<div>
                						    <label class="form-label fw-bold text-start">Subárea</label>
                							<select class="form-select" aria-label="Subárea" id="cboSubareaFiltro" name="subareaFiltro" placeholder="Subárea">
                								<option selected="" value="">Seleccione una opción</option>
                								
                							</select>
                						</div>
                					</div>
                        		</div>
                            </div>
                        </div>
                    </div>
    				<div class="panel">
                        <div class="panel-heading">
                            <h4>Asignados</h4>
                        </div>
                        <div class="panel-content">
                            <div class="row">
                                <div class="col-xxl-12 col-md-12 col-12 p-1 m-0">
                                    <div class="d-flex justify-content-center">
                                        <center class="content-left" style="position: relative; height: 40px;">
                                            <input type="radio" id="rdbtnTodoAsignadosFiltro" name="asignadosFiltro" class="rb-basico rb-filtro rdbtnAsignadoFiltro" value="TODO" checked>
                                            <label for="rdbtnTodoAsignadosFiltro"></label>
                            			</center>
                            			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center text-start" for="rdbtnTodoAsignadosFiltro">Todos los registros</label>
                            		</div>
                            	</div>
                                <div class="col-xxl-6 col-md-12 col-12 p-1 m-0">
                                    <div class="d-flex justify-content-left">
                                        <center class="content-left" style="position: relative; height: 40px;">
                                            <input type="radio" id="rdbtnAsignadosFiltro" name="asignadosFiltro" class="rb-basico rb-filtro rdbtnAsignadoFiltro" value="Y">
                                            <label for="rdbtnAsignadosFiltro"></label>
                            			</center>
                            			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center text-start" for="rdbtnAsignadosFiltro">Asignado</label>
                            		</div>
                            	</div>
                                <div class="col-xxl-6 col-md-12 col-12 p-1 m-0">
                                    <div class="d-flex justify-content-left">
                                        <center class="content-left" style="position: relative; height: 40px;">
                                            <input type="radio" id="rdbtnNoAsignadoFiltro" name="asignadosFiltro" class="rb-basico rb-filtro rdbtnAsignadoFiltro" value="N">
                                            <label for="rdbtnNoAsignadoFiltro"></label>
                            			</center>
                            			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center text-start" for="rdbtnNoAsignadoFiltro">No Asignado</label>
                            		</div>
                            	</div>
                            </div>
                        </div>
                    </div>
                </div>
            <!--                    </div>-->
            <!--                </div>-->
            <!--            </div>-->
            <!--        </div>-->
            <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                        
            <!--        </div>-->
            <!--    </div>-->
            <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
            <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                        
            <!--        </div>-->
            <!--    </div>-->
            <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
            <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                        
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->
        </div>
        <div class="offcanvas-footer border-top p-3 text-center">
            <div class="row">
                <div class="col-4">
                    <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
                </div>
                <div class="col-4">
                    <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
                </div>
                <div class="col-4">
                    <button type="submit" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
                </div>
            </div>
        </div>
    </div>
</form>

<!-- Modal Información Movil -->
<div class="modal fade zoomIn" id="informacionMovil" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionMovil" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleinformacionMovil">Información de móvil</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionMovil" class="formulario" autocomplete="off" action="" method="POST" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDMovil_i" name="txtIDMovil_i">
					<div class="row">
					    <div class="row col-12 m-0">
    						<div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-2 mb-3 d-flex justify-content-between align-items-center" style="border-radius: 10px;">
    						    <h5 class="color-white m-0">¿Equipo Stock?</h5>
    						    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center">
    								<input class="form-check-input form-check-input-green" type="checkbox" role="switch" name="chkEquipoStock_i" id="chkEquipoStock_i" >
    								<label class="form-check-label" for="chkEquipoStock_i"></label>
    							</div>
    						</div>
    					</div>
						<div class="col-xxl-6 col-md-12 col-12 my-2">
							<div>
								<label for="txtMarca_i" class="form-label">Marca</label>
								<select class="form-select select2-dinamico" aria-label="Marca" id="txtMarca_i" name="txtMarca_i" data-categoria="MOVIL" data-modal="#informacionMovil">
									<option selected="" value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
						<div class="col-xxl-6 col-md-12 col-12 my-2">
							<div>
								<label for="txtModeloComercial_i" class="form-label">Modelo</label>
								<select class="form-select select2-dinamico" aria-label="Tipo" id="txtModeloComercial_i" name="txtModeloComercial_i" data-modal="#informacionMovil">
									<option selected="" value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 my-2">
							<label for="txtProveedor_i" class="form-label">Proveedor</label>
							<select class="form-select" aria-label="Proveedor" id="txtProveedor_i" name="txtProveedor_i" data-modal="#informacionMovil">
								<option selected="" value="">Seleccione una opción</option>
								<option value="ENTEL">ENTEL</option>
								<option value="LOGÍSTICA">LOGÍSTICA</option>
							</select>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 my-2">
							<div>
								<label for="txtIMEI_i" class="form-label">IMEI</label>
								<input type="number" class="form-control" id="txtIMEI_i" name="txtIMEI_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 my-2">
							<div>
								<label for="txtFechaCompra_i" class="form-label">Fecha Compra</label>
								<input type="date" class="form-control" id="txtFechaCompra_i" name="txtFechaCompra_i" value="<?= date("Y-m-d") ?>">
							</div>
						</div>
						<div class="col-xxl-6 col-md-12 col-12 my-2">
							<div>
								<label for="txtPrecioCompra_i" class="form-label">Precio Compra</label>
								<input type="number" class="form-control" step="0.01" id="txtPrecioCompra_i" name="txtPrecioCompra_i">
							</div>
						</div>
						<div class="col-xxl-6 col-md-12 col-12 my-2">
							<div>
								<label for="txtPrecioLista_i" class="form-label">Precio Lista</label>
								<input type="number" class="form-control" step="0.01" id="txtPrecioLista_i" name="txtPrecioLista_i">
							</div>
						</div>
						<div class="row col-12 p-0 m-0" id="ctnEstadosMovil">
							<div class="col-xxl-6 col-md-12 col-12 my-2">
								<label for="txtEstadoMovil_i" class="form-label">Estado</label>
								<select class="form-select" aria-label="Estado" id="txtEstadoMovil_i" name="txtEstadoMovil_i" data-modal="#informacionMovil">
									<option selected="" value="">Seleccione una opción</option>
									<option value="ACT">ACTIVO</option>
								</select>
							</div>
							<div class="col-xxl-6 col-md-12 col-12 my-2">
								<label for="txtMotivoMovil_i" class="form-label">Motivo</label>
								<select class="form-select select2-dinamico" aria-label="Motivo" id="txtMotivoMovil_i" name="txtMotivoMovil_i" data-modal="#informacionMovil">
									<option selected="" value="">Seleccione una opción</option>
								</select>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" id="btnEjecutarMovil" class="btn bg-success color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Exportar Móviles -->
<div class="modal fade zoomIn" id="exportarMoviles" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleexportarMoviles" aria-hidden="true">
	<div class="modal-dialog modal-xl modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleexportarMoviles">Exportar Móviles</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
			    <div class="row col-12 m-0 p-0 justify-content-center align-items-center">
				    <div class="col-lg-4 col-12 d-flex justify-content-center align-items-center">
				        <div class="card card-light">
				            <div class="card-header">
                                <h6 class="card-title mb-0">Móviles No Asignados</h6>
                            </div>
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="flex-shrink-0">
                                        <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <p class="card-text">Para descargar los <strong>Móviles No Asignados</strong> presione el enlace de abajo.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <div class="text-center">
                                    <a href='<?= base_url().'/exportar-movil/noasignado' ?>' class="text-body" style="cursor: pointer;" target="_blank">
								        Exportar No Asignados <i class="ri-arrow-right-s-line align-middle lh-1"></i>
								    </a>
                                </div>
                            </div>
                        </div>
				    </div>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- Modal Histórico Asignaciones -->
<div class="modal fade zoomIn" id="mdlHistoricoAsignacionesMoviles" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlHistoricoAsignacionesMoviles" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlHistoricoAsignacionesMoviles">Histórico de Asignaciones de Móviles</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
			    <div class="row col-12 m-0 p-0 justify-content-center align-items-center" id="ctnHistoricoAsignacionesModel">
				    
				</div>
			</div>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>