<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
                                <a href="<?= $baseUrl ?>/listar-planes/TOTAL" class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white">
									<i class="mdi mdi-satellite-uplink me-1" style="font-size: 14px;"></i>Planes
								</a>
								<?php
								if (in_array("ADDOPE", $permisos)) 
								{
								?>
                                <button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#registrarOperador" id="btnRegistrarOperador">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i>Nuevo
								</button>
								<?php
								}
								?>
								<button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblOperadores" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
	$(function () {
		/***SERVERSIDE LISTADO DE OPERADORES***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblOperadores').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/operadores-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    //arrayrutavista.length-1 para obtener la ruta del controller
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						}
					},
					"columns": [
						{"title": "Código", "data": "IDOperador", "class": "text-center", "searchable": true },
						{"title": "Operador", "data": "Operador", "class": "text-center", "searchable": true },
						{"title": "Observación", "data": "Observacion", "class": "text-center", "searchable": true },
						{"title": "Estado", "data": "EstadoOperador", "class": "text-center", "searchable": true },
						{"title": "Acciones", "data": "acciones", "class": "text-center", "searchable": false, "orderable": false },
					],
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 10,
					"paging": true,
					"aaSorting": [[0, 'desc']],
				});
			}
		}

		assetListVM.init();
		/****FIN SERVERSIDE LISTADO OPERADORES****/
	});
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->
<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Filtros</h5>

        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
        <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
        <!--        <div class="simplebar-height-auto-observer-wrapper">-->
        <!--            <div class="simplebar-height-auto-observer">-->
                        
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-mask">-->
        <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
        <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
        <!--                    <div class="simplebar-content" style="padding: 0px;">-->
            <div id="ctnFiltro" class="p-3">
				<div class="card border" style="border-top: 3px #536878 solid!important;">
					<div class="card-header">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-0">Columnas</h6>
                            </div>
                            <div class="flex-shrink-0">
                                <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                    <li class="list-inline-item">
                                        <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseColumnasFiltros" role="button" aria-expanded="true" aria-controls="collapseColumnasFiltros">
                                            <i class="mdi mdi-plus align-middle plus"></i>
                                            <i class="mdi mdi-minus align-middle minus"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
					<div class="card-body collapse show" id="collapseColumnasFiltros" style="">
						cxcvcxxvxcxcv
					</div>
				</div>
				<div class="panel">
                    <div class="panel-heading">
                        <h4>Columnas</h4>
                    </div>
                    <div class="panel-content">
                        <div class="row">
                            adasasads
                        </div>
                    </div>
                </div>
            </div>
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
        <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
        <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Registro Operador -->
<div class="modal fade zoomIn" id="registrarOperador" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleregistrarOperador" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleregistrarOperador">Registrar Operador</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formRegistrarOperador" class="formulario form-steps" autocomplete="off" action="<?= $baseUrl ?>/registrar-operador" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
                    <div class="step-arrow-nav mb-3">
                        <ul class="nav nav-pills custom-nav nav-border-top nav-justified" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="tabInformacionOperador" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionOperador" type="button" role="tab" aria-controls="tabcontentInformacionOperador" aria-selected="true" data-position="0">Información del Operador</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="tabInformacionPlanOperador" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionPlanOperador" type="button" role="tab" aria-controls="tabcontentInformacionPlanOperador" aria-selected="false" data-position="1">Información de Planes</button>
                            </li>
                        </ul>
                    </div>

                    <div class="tab-content">
                        <div class="tab-pane fade active show" id="tabcontentInformacionOperador" role="tabpanel" aria-labelledby="tabInformacionOperador">
                            <div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
                                    <div class="col-xxl-12 col-md-12 col-12 px-3 mb-3">
            							<div>
            								<label for="txtOperador_ro" class="form-label" >Operador</label>
            								<input type="text" class="form-control" id="txtOperador_ro" name="txtOperador_ro">
            							</div>
            						</div>
            						<div class="col-xxl-12 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtObservacion_ro" class="form-label">Observación</label>
            								<textarea class="form-control" id="txtObservacion_ro" name="txtObservacion_ro" rows="4"></textarea>
            							</div>
            						</div>
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabInformacionPlanOperador">
                                    <i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Registrar Planes
                                </button>
                            </div>
                        </div>
                         <!--end tab pane -->
                        <div class="tab-pane fade" id="tabcontentInformacionPlanOperador" role="tabpanel" aria-labelledby="tabInformacionPlanOperador">
                            <div>
                                <h3 class="mb-3">Agregar Planes</h3>
                                <div class="card-text mb-3">
									<div class="form-group row">
										<div class="col-6">
											<label for="txtPlanVerisure_ro">Plan Verisure</label>
											<input type="text" class="form-control" id="txtPlanVerisure_ro" placeholder="Plan Verisure">
										</div>
										<div class="col-6">
											<label for="txtPlanOperador_ro">Plan Operador</label>
											<input type="text" class="form-control" id="txtPlanOperador_ro" placeholder="Plan Operador">
										</div>
									</div>
								</div>
								<div class="card-text mb-4">
									<div class="form-group row">
										<div class="col-lg-4">
										    <label for="txtPrecioPlan_ro">Precio Plan</label>
                                            <div class="input-group">
                                                <span class="input-group-text">S/.</span>
                                                <input type="number" step="0.01" class="form-control" id="txtPrecioPlan_ro" placeholder="Precio Plan">
                                            </div>
                                        </div>
										<div class="col-lg-4">
										    <label for="txtPorcentajeDescuento_ro">Porcentaje Descuento</label>
                                            <div class="input-group">
                                                <span class="input-group-text">%</span>
                                                <input type="number" step="0.01" min="0" max="100" class="form-control" id="txtPorcentajeDescuento_ro" placeholder="Porcentaje Descuento">
                                            </div>
                                        </div>
										<div class="col-lg-4">
										    <label for="txtPrecioFinal_ro">Precio Final</label>
                                            <div class="input-group">
                                                <span class="input-group-text">S/.</span>
                                                <input type="number" step="0.01" class="form-control" id="txtPrecioFinal_ro" placeholder="Precio Final">
                                            </div>
                                        </div>
									</div>
								</div>
                                <div class="card-text mb-3">
									<div class="form-group row">
										<div class="col-12">
											<label for="txtObservacionPlan_ro">Observación</label>
											<textarea class="form-control" id="txtObservacionPlan_ro" rows="3"></textarea>
										</div>
									</div>
								</div>
								<div class="card-text mb-3">
									<div class="form-group row">
										<div class="col-8">
										    <label for="txtCapacidadDescarga_ro">Capacidad de Descarga</label>
                                            <div class="input-group">
                                                <span class="input-group-text">GB</span>
                                                <input type="number" step="0.01" class="form-control" id="txtCapacidadDescarga_ro" placeholder="Capacidad de descarga">
                                            </div>
										</div>
										<div class="col-4 d-flex justify-content-end align-items-end">
										    <button type="button" class="btn bg-info px-2 py-1 ms-3 color-white d-flex justify-content-end align-items-center" onclick="return agregarPlan('ctnPlanOperadorRegistro');" data-tooltip="tooltip" aria-label="Agregar Plan">
                                                <i class="mdi mdi-plus" style="font-size: 24px; color: #FFF"></i> Agregar Plan
                                            </button>
										</div>
									</div>
								</div>
								<hr class="my-4">
								<h3 class="mb-3">Planes</h3>
								<div class="row col-12 m-0 p-0 d-flex" id="ctnPlanOperadorRegistro">
								    
        				        </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-light btn-label previestab" data-previous="tabInformacionOperador"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar a información del hardware</button>
                                <button type="submit" class="btn btn-success btn-label right ms-auto"><i class="mdi mdi-content-save label-icon align-middle fs-16 ms-2"></i>Guardar</button>
                            </div>
                        </div>
                         <!--end tab pane -->
                    </div>
                     <!--end tab content -->
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Información Operador -->
<div class="modal fade zoomIn" id="informacionOperador" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionOperador" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleinformacionOperador">Información de operador</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionOperador" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDOperador_i" name="txtIDOperador_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 my-2">
							<label for="txtOperador_i" class="form-label">Operador</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Operador" id="txtOperador_i" name="txtOperador_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 my-2">
							<div>
								<label for="txtObservacion_i" class="form-label">Observación</label>
								<textarea class="form-control" id="txtObservacion_i" name="txtObservacion_i" rows="4"></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" id="btnEjecutarOperador" class="btn bg-success color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>