<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
                                <?php
                                if(in_array("TOTDES", $permisos))
                                {
                                ?>
                                <button class="btn bg-warning d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#exportarReporteDescuentos">
									<i class="mdi mdi-file-export me-1" style="font-size: 14px;"></i>Exportar
								</button>
								<?php
                                }
                                
                                if(in_array("INFDES", $permisos))
                                {
                                ?>
                                <button class="btn bg-morado d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#gestionInformacionDescuento" id="btnGestionDescuentoMensual">
									<i class="mdi mdi-swap-vertical-bold me-1" style="font-size: 14px;"></i>Información
								</button>
								<?php
                                }
								?>
                                <button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblDescuentosMensual" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<?= $this->section('js'); ?>
<script>
	$(document).ready(function() {
	    /***SERVERSIDE LISTADO DE DESCUENTOS MENSUAL***/
		assetListVM = {
			dt: null,
			params: {},  // Para almacenar parámetros adicionales de filtro
			init: function () {
				this.dt = $('#tblDescuentosMensual').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/descuentos-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						    
						    // Agregar los parámetros adicionales de filtro a la solicitud
                            $.each(assetListVM.params, function(key, value) {
                                d[key] = value;
                            });
						}
					},
					"columns": [
						{"title": "Documento", "data": "BotonesDocumento", "class": "text-center", "searchable": true },
						{"title": "Matrícula", "data": "MatriculaAdjudicado", "class": "text-center", "searchable": true },
						{"title": "Usuario", "data": "Usuario", "class": "text-center", "searchable": true },
						{"title": "Periodo", "data": "PeriodoDescuento", "class": "text-center", "searchable": true },
						{"title": "Elemento", "data": "ElementoDescuento", "class": "text-center", "searchable": true },
						{"title": "Monto Descuento Total", "data": "MontoDescuentoTotal", "class": "text-center", "searchable": true },
						{"title": "Cuotas", "data": "TotalCuotas", "class": "text-center", "searchable": true },
						{"title": "¿Cobrado?", "data": "DescuentoCobrado", "class": "text-center", "searchable": true },
						{"title": "Monto Cobrado", "data": "MontoCobrado", "class": "text-center", "searchable": true },
						{"title": "Fecha Cobro", "data": "FechaCobrado", "class": "text-center", "searchable": true },
						{"title": "Observación Cobro", "data": "ObservacionCobrado", "class": "text-center", "searchable": true }
					],
                    "drawCallback": function(settings) {
                        // Re-inicializar tooltips después de que los datos son cargados
                        $('[data-tooltip="tooltip"]').tooltip();
                        $('[data-toggle="tooltip"]').tooltip();
                    },
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
                    "pageLength": 10,
                    "paging": true,
                    columnDefs: [
                        { responsivePriority: 1, targets: 0 },
                        { responsivePriority: 1, targets: 1 },
                        { responsivePriority: 1, targets: 2 },
                        { responsivePriority: 6, targets: 3 },
                        { responsivePriority: 6, targets: 4 },
                        { responsivePriority: 10, targets: 5 },
                        { responsivePriority: 10, targets: 6 },
                        { responsivePriority: 6, targets: 7 },
                        { responsivePriority: 1, targets: 8 },
                        { responsivePriority: 1, targets: 9 }
                    ],
					"aaSorting": [[0, 'desc']],
				});
			},
			// Método para aplicar filtros adicionales
            applyFilters: function(filters) {
                this.params = filters;  // Actualiza los parámetros de filtro
                
                if (this.dt) {
                    this.dt.clear();  // Limpia los datos previos
                    this.dt.destroy();  // Destruye la instancia actual de DataTable
                }
            
                // Reinicia DataTable con los nuevos filtros
                this.init();
            }
		}

// 		assetListVM.init();
		/****FIN SERVERSIDE LISTADO ASIGNACIONES****/
		
		$('#MesDescuento').select2({
            dropdownParent: $('#ctnFiltro')
        });
        
		$('#AnioDescuento').select2({
            dropdownParent: $('#ctnFiltro')
        });
        
        // Disparar el submit del formulario al cargar la página
        $('.filtro').trigger('submit');
	});
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->
<form class="filtro" autocomplete="off" action="" method="POST" accept-charset="utf-8">
    <div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
        <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
            <h5 class="m-0 me-2 text-white">Filtros</h5>
    
            <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body p-0">
            <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
            <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
            <!--        <div class="simplebar-height-auto-observer-wrapper">-->
            <!--            <div class="simplebar-height-auto-observer">-->
                            
            <!--            </div>-->
            <!--        </div>-->
            <!--        <div class="simplebar-mask">-->
            <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
            <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
            <!--                    <div class="simplebar-content" style="padding: 0px;">-->
                <div id="ctnFiltro" class="p-3">
    				<div class="panel">
                        <div class="panel-heading">
                            <h4>Búsqueda</h4>
                        </div>
                        <div class="panel-content">
                            <div class="row">
                                <div class="col-xxl-12 col-md-6 col-12 mb-3">
                					<label for="MesDescuento" class="form-label">Mes</label>
                					<select class="form-select" aria-label="Mes" id="MesDescuento" name="MesDescuento">
                						<option value="01" <?= date("m") == '01' ? 'selected' : '' ?> >ENERO</option>
                						<option value="02" <?= date("m") == '02' ? 'selected' : '' ?> >FEBRERO</option>
                						<option value="03" <?= date("m") == '03' ? 'selected' : '' ?> >MARZO</option>
                						<option value="04" <?= date("m") == '04' ? 'selected' : '' ?> >ABRIL</option>
                						<option value="05" <?= date("m") == '05' ? 'selected' : '' ?> >MAYO</option>
                						<option value="06" <?= date("m") == '06' ? 'selected' : '' ?> >JUNIO</option>
                						<option value="07" <?= date("m") == '07' ? 'selected' : '' ?> >JULIO</option>
                						<option value="08" <?= date("m") == '08' ? 'selected' : '' ?> >AGOSTO</option>
                						<option value="09" <?= date("m") == '09' ? 'selected' : '' ?> >SETIEMBRE</option>
                						<option value="10" <?= date("m") == '10' ? 'selected' : '' ?> >OCTUBRE</option>
                						<option value="11" <?= date("m") == '11' ? 'selected' : '' ?> >NOVIEMBRE</option>
                						<option value="12" <?= date("m") == '12' ? 'selected' : '' ?> >DICIEMBRE</option>
                					</select>
                				</div>
                				<div class="col-xxl-12 col-md-6 col-12 mb-3">
                					<label for="AnioDescuento" class="form-label">Año</label>
                					<select class="form-select" aria-label="Año" id="AnioDescuento" name="AnioDescuento">
                					    <?php
                					    $anioInicial = "2024";
                					    $anioActual = date("Y");
                					    for($i = $anioInicial; $i <= ($anioActual + 2); $i++)
                					    {
                					    ?>
                					    <option value="<?= $i ?>" <?= $i == $anioActual ? 'selected' : '' ?> ><?= $i ?></option>
                					    <?php
                					    }
                					    ?>
                					</select>
                				</div>
                            </div>
                        </div>
                    </div>
                </div>
            <!--                    </div>-->
            <!--                </div>-->
            <!--            </div>-->
            <!--        </div>-->
            <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                        
            <!--        </div>-->
            <!--    </div>-->
            <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
            <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                        
            <!--        </div>-->
            <!--    </div>-->
            <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
            <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                        
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->
        </div>
        <div class="offcanvas-footer border-top p-3 text-center">
            <div class="row">
                <div class="col-4">
                    <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
                </div>
                <div class="col-4">
                    <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
                </div>
                <div class="col-4">
                    <button type="submit" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
                </div>
            </div>
        </div>
    </div>
</form>

<?php
if(in_array("INFDES", $permisos))
{
?>
<!-- Modal Gestión información -->
<div class="modal fade zoomIn" id="gestionInformacionDescuento" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplegestionInformacionDescuento" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplegestionInformacionDescuento">Gestión de Información de descuento</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<div class="card-group">
                    <div class="card text-white bg-success">
                        <div class="card-header text-center d-flex justify-content-center align-items-center" style="background-color: transparent;">
                            <span class="mdi mdi-file-export-outline" style="font-size: 18px;"></span> Exportar
                        </div>
                        <div class="card-body text-black text-center" style="background-color: #FFF;">
                          <p class="card-text">Si desea descargar el CSV de la información del periodo filtrado, presione el botón inferior.<br><span class="mdi mdi-hand-pointing-down" style="font-size: 25px;"></span></p>
                        </div>
                        <div class="card-footer d-flex justify-content-center align-items-center" style="background-color: transparent;">
                            <label class="btn btn-warning m-0" onclick="return descargarDescuentosMensualPendiente();">Descargar</label>
                        </div>
                    </div>
                    <div class="card text-white bg-info">
                        <div class="card-header text-center d-flex justify-content-center align-items-center" style="background-color: transparent;">
                            <span class="mdi mdi-file-import-outline" style="font-size: 18px;"></span> Importar
                        </div>
                        <div class="card-body text-black text-center" style="background-color: #FFF;">
                          <p class="card-text">Si desea importar el CSV con la información del cobro realizado, presione el botón inferior.<br><span class="mdi mdi-hand-pointing-down" style="font-size: 25px;"></span></p>
                        </div>
                        <div class="card-footer d-flex justify-content-center align-items-center" style="background-color: transparent;">
                            <div class='m-0'>
                                <span class='btnFile_01'>
                                    <input type='file' class='btnFile' id='btnFile_01' name='txtImportarDescuentoCobrado' accept=".csv">
                                </span>
                                <label class='btn btn-warning m-0' for='btnFile_01'>Adjuntar</label>
                            </div>
                        </div>
                    </div>
                </div>
			</div>
		</div>
	</div>
</div>
<?php
}
?>

<!-- Modal Exportar Descuentos -->
<div class="modal fade zoomIn" id="exportarReporteDescuentos" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleexportarReporteDescuentos" aria-hidden="true">
	<div class="modal-dialog modal-xl modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleexportarReporteDescuentos">Exportar Reporte de Descuentos</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
			    <div class="row col-12 m-0 p-0 justify-content-center align-items-center">
				    <div class="col-lg-4 col-12 d-flex justify-content-center align-items-center">
				        <div class="card card-light">
				            <div class="card-header">
                                <h6 class="card-title mb-0">Información Total</h6>
                            </div>
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="flex-shrink-0">
                                        <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <p class="card-text">Para descargar la <strong>Información Total de Descuentos</strong> presione el enlace de abajo.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <div class="text-center">
                                    <a href='<?= base_url().'/exportar-descuento-global' ?>' class="text-body" style="cursor: pointer;" target="_blank">
								        Exportar Descuentos Totales <i class="ri-arrow-right-s-line align-middle lh-1"></i>
								    </a>
                                </div>
                            </div>
                        </div>
				    </div>
				</div>
			</div>
		</div>
	</div>
</div>


<?php $this->endSection(); ?>