<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
                                <?php
								if (in_array("CSVASI", $permisos)) 
								{
								?>
								<button class="btn bg-info d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#importarCSVAsignacion" data-toggle="tooltip" data-placement="top" title="Importar CSV Asignación" aria-label="Importar CSV Asignación">
									<i class="mdi mdi-file-upload me-1" style="font-size: 14px;"></i>Importar
								</button>
								<?php
								}
								
								if (in_array("ASIDIS", $permisos)) 
								{
								?>
								<button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white" data-bs-target="#nuevaAsignacion" data-form="#formNuevaAsignacion" id="btnNuevaAsignacion" data-toggle="tooltip" data-placement="top" title="Registrar Nueva Asignación" aria-label="Registrar Nueva Asignación">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i> Asignar
								</button>
								<?php
								}
								?>
								<button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblAsignaciones" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<?= $this->section('js'); ?>
<script>
	$(function () {
	    /***SERVERSIDE ASIGNACIONES***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblAsignaciones').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/asignaciones-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						}
					},
					"columns": [
						{"title": "Código", "data": "IDAsignacion", "class": "text-center", "searchable": true },
						{"title": "Matrícula", "data": "MatriculaAsignado", "class": "text-center", "searchable": true },
						{"title": "Asignado", "data": "NombreAsignado", "class": "text-center", "searchable": true },
						{"title": "Fecha Asignado", "data": "FechaAsignado", "class": "text-center", "searchable": true },
						{"title": "Tipo Asignado", "data": "TipoAsignado", "class": "text-center", "searchable": true },
						{"title": "Observación", "data": "Observacion", "class": "text-center", "searchable": true },
						{"title": "Remitente", "data": "NombreRemitente", "class": "text-center", "searchable": true },
						{"title": "Dispositivos Asignados", "data": "TIPOS_ELEMENTO", "class": "text-center", "searchable": true },
						{"title": "¿Firmado?", "data": "Firma", "class": "text-center", "searchable": true },
						{"title": "Acciones", "data": "Acciones", "class": "text-center", "searchable": true }
					],
                    "drawCallback": function(settings) {
                        // Re-inicializar tooltips después de que los datos son cargados
                        $('[data-tooltip="tooltip"]').tooltip();
                        $('[data-toggle="tooltip"]').tooltip();
                    },
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
                    columnDefs: [
                        { responsivePriority: 1, targets: 0 },
                        { responsivePriority: 1, targets: 1 },
                        { responsivePriority: 1, targets: 2 },
                        { responsivePriority: 6, targets: 3 },
                        { responsivePriority: 6, targets: 4 },
                        { responsivePriority: 10, targets: 5 },
                        { responsivePriority: 10, targets: 6 },
                        { responsivePriority: 6, targets: 7 },
                        { responsivePriority: 1, targets: 8 },
                        { responsivePriority: 1, targets: 9 }
                    ],
					autoWidth: false,
					"aaSorting": [[0, 'desc']],
				});
			}
		}

		assetListVM.init();
		/****FIN SERVERSIDE LISTADO ASIGNACIONES****/
		
        pondCSVAsignacion = FilePond.create(
            document.querySelector("#fileCSVAsignacion"), {
                labelIdle: 'Arrastra y suelta el CSV de asignación o <span class="filepond--label-action">explora</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['text/csv'],
                onaddfile: (file) => {
                    // Validación manual por extensión
                    const allowedExtensions = /(\.xml)$/i;
                    if (!allowedExtensions.exec(file.name)) {
                        Swal.fire({
                            text: "El formato del archivo debe ser CSV.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondCSVAsignacion.removeFile(file.id);
                        return false; // Detener el envío del archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );
        
    	$('#txtTipoAsignado').select2({
            dropdownParent: $('#nuevaAsignacion .modal-body')
        });
        
        $("#txtUsuarioAsignacion").select2({
            minimumInputLength: 2,
            placeholder: 'Seleccione Usuario',
            dropdownParent: $('#nuevaAsignacion .modal-body'),
            allowClear: true,
            language: {
                errorLoading: function() {
                    return "La carga falló";
                },
                noResults: function() {
                    return "No hay resultado";
                },
                searching: function() {
                    return "Buscando..";
                }
            },
            ajax: {
                url: baseUrl + '/listado-usuarios-select',
                dataType: 'json',
                type: "POST",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: data
                    };
                }
            }
        });
        
    	$('#txtElementoNuevaAsignacion').select2({
            dropdownParent: $('#nuevaAsignacion .modal-body')
        });
        
    	$("#txtItem").select2({
            minimumInputLength: 2,
            placeholder: 'Seleccione Item',
            dropdownParent: $('#nuevaAsignacion .modal-body'),
            allowClear: true,
            language: {
                errorLoading: function() {
                    return "La carga falló";
                },
                noResults: function() {
                    return "No hay resultado";
                },
                searching: function() {
                    return "Buscando..";
                }
            },
            ajax: {
                url: baseUrl + '/obtener-elementos-asignacion',
                dataType: 'json',
                type: "POST",
                quietMillis: 50,
                data: function (term) {
                    var el = $("#txtElementoNuevaAsignacion").val();
                    term['elemento'] = el;
                    // var usuario = $("#txtAsignado").val();
                    var usuario = $("#txtUsuarioAsignacion").val();
                    
                    if((el=='HARDWARE' || el=='KITDEMO') && usuario == '')
                    {
                        Swal.fire({
                            html: 'Debe seleccionar el usuario asignado para filtrar el ELEMENTO seleccionado',
                            heightAuto: true,
                            showConfirmButton: false
                        });
                    }
                    else
                    {
                        term['usuario'] = usuario;
                        return {
                            term: term
                        };
                    }
                },
                processResults: function (data) {
                    return {
                        results: data
                    };
                }
            }
        });
        
	});
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->
<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Filtros</h5>

        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
        <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
        <!--        <div class="simplebar-height-auto-observer-wrapper">-->
        <!--            <div class="simplebar-height-auto-observer">-->
                        
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-mask">-->
        <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
        <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
        <!--                    <div class="simplebar-content" style="padding: 0px;">-->
            <div id="ctnFiltro" class="p-3">
				<div class="card border" style="border-top: 3px #536878 solid!important;">
					<div class="card-header">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-0">Columnas</h6>
                            </div>
                            <div class="flex-shrink-0">
                                <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                    <li class="list-inline-item">
                                        <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseColumnasFiltros" role="button" aria-expanded="true" aria-controls="collapseColumnasFiltros">
                                            <i class="mdi mdi-plus align-middle plus"></i>
                                            <i class="mdi mdi-minus align-middle minus"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
					<div class="card-body collapse show" id="collapseColumnasFiltros" style="">
						cxcvcxxvxcxcv
					</div>
				</div>
				<div class="panel">
                    <div class="panel-heading">
                        <h4>Columnas</h4>
                    </div>
                    <div class="panel-content">
                        <div class="row">
                            adasasads
                        </div>
                    </div>
                </div>
            </div>
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
        <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
        <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Nueva Asignación -->
<div class="modal fade zoomIn" id="nuevaAsignacion" data-bs-backdrop="static" role="dialog" aria-labelledby="examplenuevaAsignacion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplenuevaAsignacion">Nueva Asignación</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formNuevaAsignacion" class="formulario form-steps" autocomplete="off" action="<?= $baseUrl ?>/guardar-asignacion" method="POST" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
                    <div class="step-arrow-nav mb-4">
                        <ul class="nav nav-pills custom-nav nav-border-top nav-justified" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="tabInformacionAsignacion" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionAsignacion" type="button" role="tab" aria-controls="tabcontentInformacionAsignacion" aria-selected="true" data-position="0">Asignación</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="tabInformacionElementos" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionElementos" type="button" role="tab" aria-controls="tabcontentInformacionElementos" aria-selected="false" data-position="1">Elementos de la asignación</button>
                            </li>
                        </ul>
                    </div>

                    <div class="tab-content">
                        <div class="tab-pane fade active show" id="tabcontentInformacionAsignacion" role="tabpanel" aria-labelledby="tabInformacionAsignacion">
                            <div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-8 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label" >Usuario Remitente</label>
            								<input type="text" class="form-control" value="<?= $nombres.' '.$apellidos ?>" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label" >Matrícula Remitente</label>
            								<input type="text" class="form-control" value="<?= $matriculaLog ?>" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-6 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtFechaAsignado" class="form-label">Fecha de asignación</label>
            								<input type="date" class="form-control validarNextTab" id="txtFechaAsignado" name="txtFechaAsignado" value="<?= date("Y-m-d") ?>">
            							</div>
            						</div>
            						<div class="col-xxl-6 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtTipoAsignado" class="form-label">Tipo de asignación</label>
            								<select class="form-select validarNextTab" aria-label="Tipo de asignación" id="txtTipoAsignado" name="txtTipoAsignado" data-modal="#nuevaAsignacion">
            									<option selected="" value="">Seleccione una opción</option>
                								<option value="ASIGNADO">ASIGNADO</option>
                								<option value="TEMPORAL">TEMPORAL</option>
                								<option value="RESPONSABLE">RESPONSABLE</option>
            								</select>
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-12 col-md-12 col-12 mb-3">
            							<div>
            								<label for="txtObservacionAsignacion" class="form-label">Observación</label>
            								<textarea class="form-control" id="txtObservacionAsignacion" name="txtObservacionAsignacion" rows="4"></textarea>
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-12 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtUsuarioAsignacion" class="form-label">Seleccione asignado</label>
            								<select class="form-select validarNextTab" aria-label="Usuario Asignado" id="txtUsuarioAsignacion" name="txtUsuarioAsignacion" data-modal="#nuevaAsignacion">
            									<option selected="" value="">Seleccione una opción</option>
            								</select>
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtNombreAsignado" class="form-label" >Nombre Usuario</label>
            								<input type="text" class="form-control validarNextTab" id="txtNombreAsignado" name="txtNombreAsignado" disabled >
            							</div>
            						</div>
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtApellidoAsignado" class="form-label">Apellido Usuario</label>
            								<input type="text" class="form-control validarNextTab" id="txtApellidoAsignado" name="txtApellidoAsignado" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtDocumentoAsignado" class="form-label">Documento Usuario</label>
            								<input type="text" class="form-control validarNextTab" id="txtDocumentoAsignado" name="txtDocumentoAsignado" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtDireccionAsignado" class="form-label" >Dirección Usuario</label>
            								<input type="text" class="form-control validarNextTab" id="txtDireccionAsignado" name="txtDireccionAsignado" disabled >
            							</div>
            						</div>
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtAreaAsignado" class="form-label">Área Usuario</label>
            								<input type="text" class="form-control validarNextTab" id="txtAreaAsignado" name="txtAreaAsignado" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtCargoAsignado" class="form-label">Cargo Usuario</label>
            								<input type="text" class="form-control validarNextTab" id="txtCargoAsignado" name="txtCargoAsignado" disabled >
            							</div>
            						</div>
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabInformacionElementos" id="btnNextTab" disabled><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Ingresar elementos</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                        <div class="tab-pane fade" id="tabcontentInformacionElementos" role="tabpanel" aria-labelledby="tabInformacionElementos">
                            <div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-5 col-md-12 col-12 px-3">
            							<div>
                                            <label for="txtElementoNuevaAsignacion" class="form-label">Elemento</label>
                                            <select class="form-select" aria-label="Elemento" id="txtElementoNuevaAsignacion" name="txtElementoNuevaAsignacion" data-modal="#nuevaAsignacion">
                                                <option selected="" value="">Seleccione una opción</option>
                                                <?php
                                                if(in_array($idPerfil, array(1,2)))
                                                {
                                                ?>
                                                <option value="LINEA">LINEA</option>
                                                <option value="MOVIL">MÓVIL</option>
                                                <option value="TARJETA">TARJETA DE ACCESO</option>
                                                <option value="HARDWARE">HARDWARE</option>
                                                <option value="ACCESORIOIT">ACCESORIOS IT</option>
                                                <option value="KITDEMO">KIT DEMO</option>
                                                <?php
                                                }
                                                
                                                if(in_array($idPerfil, array(1,5)))
                                                {
                                                ?>
                                                <option value="KITTRABAJO">KIT DE TRABAJO</option>
                                                <option value="ELEMENTOTRABAJO">ELEMENTO DE TRABAJO</option>
                                                <?php
                                                }
                                                ?>
                                            </select>
                                        </div>
            						</div>
        					        <div class="col-xxl-5 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtItem" class="form-label">Item</label>
                                            <select class="form-select" aria-label="Item" id="txtItem" name="txtItem" data-modal="#nuevaAsignacion">
                                                <option selected="" value="">Seleccione una opción</option>
                                            </select>
            							</div>
            						</div>
            						<div class="col-xxl-2 col-md-12 col-12 px-3 d-flex justify-content-end align-items-center">
            						    <button type="button" class="btn bg-success px-2 py-1 ms-3" onclick="return agregarItemAsignacion();" data-tooltip="tooltip" aria-label="Agregar Item a la asignación">
                                            <i class="mdi mdi-plus" style="font-size: 24px; color: #FFF"></i>
                                        </button>
            						</div>
        					    </div>
                                <div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-3 mb-3 d-flex justify-content-between align-items-center" style="border-radius: 10px; font-size: 15px;">
            					    Elementos para asignar
            					</div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex" id="ctnElementosAsignacion">
            						
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-light btn-label previestab" data-previous="tabInformacionAsignacion"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar a la asignación</button>
                                <button type="submit" class="btn btn-success btn-label right ms-auto"><i class="mdi mdi-content-save label-icon align-middle fs-16 ms-2"></i>Guardar</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                    </div>
                    <!-- end tab content -->
				</div>
			</form>
		</div>
	</div>
</div>

<div class="modal fade zoomIn" id="importarCSVAsignacion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleimportarCSVAsignacion" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h4 class="modal-title color-white" id="exampleimportarCSVAsignacion">Subir CSV de Asignación</h4>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formularioImportarCSVAsignacion" id="formImportarCSVAsignacion" autocomplete="off" action="<?= $baseUrl ?>/subir-csv-asignacion" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<ol>
						    <li>Información de columna [TIPO]: [LINEA, MOVIL, ACCESORIOIT, HARDWARE, TARJETA, KITDEMO, MALETÍN DE HERRAMIENTA, VESTIMENTA].</li>
						    <li>Información de columna [REFERENCIA]:</li>
						    <ul>
						        <li>LINEA                   : Número telefónico</li>
						        <li>MOVIL                   : IMEI</li>
						        <li>ACCESORIOIT             : Nombre elemento</li>
						        <li>HARDWARE                : Número de Serie</li>
						        <li>TARJETA                 : Número de Serie</li>
						        <li>KITDEMO                 : Código de Kit Demo</li>
						        <li>MALETÍN DE HERRAMIENTA  : SKU</li>
						        <li>VESTIMENTA              : SKU</li>
						    </ul>
						    <li>Información de columna [USUARIO]: Considerar el usuario asignado al trabajador.</li>
						    <li>Información de columna [TIPO ASIGNADO]: [ASIGNADO, TEMPORAL, RESPONSABLE].</li>
						    <li>Información de columna [OBSERVACION ASIGNADO]: Observación general de la asignación.</li>
						    <li>Información de columna [OBSERVACION ELEMENTO]: Observación particular del elemento que se va a asignar.</li>
						    <li>Información de columna [CANTIDAD ELEMENTO]: Solo aplicable a "Maletín de Herramienta" y "Vestimenta". Se debe colocar un número entero a entregar.</li>
						    <li>Información de columna [SITUACIÓN ELEMENTO]: Solo aplicable a "ACCESORIOIT". Se debe colocar ['NUEVO', 'REUTILIZADO'] para registrar el movimiento de kardex.</li>
						</ol>
					</div>
    				<hr>
    				<h4 class="mb-3">Plantillas:</h4>
					<div class="row col-12 m-0 p-0">
					    <div class="col-lg-12 col-12 d-flex justify-content-center align-items-center">
					        <div class="card card-light">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0">
                                            <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="card-text">Si desea descargar la <strong class="fw-medium">Plantilla de Asignación</strong> presione el enlace de abajo.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="text-center">
                                        <a class="text-body" href='<?= base_url().'/'.$basePublic.'/docs/Plantillas/plantilla csv asignaciones.csv' ?>' download='Plantilla CSV Asignaciones'>Descargar Plantilla <i class="ri-arrow-right-s-line align-middle lh-1"></i></a>
                                        <!--<a href="javascript:void(0);" class="text-body">Descargar Plantilla</a>-->
                                    </div>
                                </div>
                            </div>
					    </div>
					</div>
    				<hr>
    				<h4 class="mb-3">Importar archivo:</h4>
					<div class="col-12 mb-0 d-flex justify-content-center">
					    <div class="col-7 m-0 p-0">
					        <input type="file" id="fileCSVAsignacion" class="filepond" name="fileCSVAsignacion" data-max-file-size="100MB" data-max-files="1" />
					    </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger d-flex justify-content-center" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn btn-success d-flex justify-content-center"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<?php $this->endSection(); ?>