<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div class="d-flex">
								<?php
								if (in_array("ADDMOD", $permisos)) 
								{
								?>
                                <button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white datos-modulo" data-bs-target="#informacionModulo" data-form="#formInformacionModulo" data-id="0" data-accion="crear" id="crear-modulo">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i>Nuevo 
								</button>
								<?php
								}
								?>
								<button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="example" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Cabecera</th>
										<th class="text-center align-middle">Orden</th>
										<th class="text-center align-middle">Módulo</th>
										<th class="text-center align-middle">Ícono</th>
										<th class="text-center align-middle">Raíz</th>
										<th class="text-center align-middle">Observación</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listaModulos as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDModulo'] ?></td>
										<td class="text-center align-middle"><?= $items['Cabecera'] ?></td>
										<td class="text-center align-middle"><?= $items['Orden'] ?></td>
										<td class="text-center align-middle"><?= $items['Modulo'] ?></td>
										<td class="text-center align-middle">
											<span class="<?= $items['Icono'] != '' ? $items['Icono'] : 'mdi mdi-home' ?>"></span>
										</td>
										<td class="text-center align-middle"><?= $items['Ruta'] ?></td>
										<td class="text-center align-middle"><?= $items['Observacion'] ?></td>
										<td class="text-center align-middle">
											<?php
											if (in_array("ESTMOD", $permisos)) 
											{
											?>
											<button class="badge <?= $items['Estado'] == 'A' ? 'bg-success' : 'bg-warning' ?> border-0 cambiar-estado-modulo" data-estado="<?= $items['Estado'] ?>" data-id="<?= $items['IDModulo'] ?>">
												<?= $items['Estado'] == 'A' ? 'ACTIVO' : 'INACTIVO' ?>
											</button>
											<?php
											}
											else 
											{
											?>
											<span class="badge <?= $items['Estado'] == 'A' ? 'bg-success' : 'bg-warning' ?> border-0">
												<?= $items['Estado'] == 'A' ? 'ACTIVO' : 'INACTIVO' ?>
											</span>
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
										    <button class="badge bg-info border-0 p-2 mx-1 datos-modulo" data-bs-target="#informacionModulo" data-form="#formInformacionModulo" data-id="<?= $items['IDModulo'] ?>" data-accion="ver" id="ver-modulo" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" title="Ver Modulo" aria-label="Ver Modulo">
                                				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                			</button>
                                			<?php
											if (in_array("UPDMOD", $permisos)) 
											{
											?>
											<button class="badge bg-warning border-0 p-2 mx-1 datos-modulo" data-bs-target="#informacionModulo" data-form="#formInformacionModulo" data-id="<?= $items['IDModulo'] ?>" data-accion="editar" id="editar-modulo" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" title="Editar Modulo" aria-label="Editar Modulo">
											    <i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
											</button>
											<?php
											}
											?>	
											<a href="<?= $baseUrl ?>/listar-rutas-modulo/<?= $items['IDModulo'] ?>" class="badge bg-sistema border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" title="Ver rutas del módulo" aria-label="Ver rutas del módulo">
                                				<i class="mdi mdi-link align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                			</a>
											
											<a href="<?= $baseUrl ?>/listar-acciones-modulo/<?= $items['IDModulo'] ?>" class="badge bg-sistema border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" title="Ver permisos del módulo" aria-label="Ver permisos del módulo">
                                				<i class="mdi mdi-gesture-tap-button align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                			</a>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<!-- Filtros -->
<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Filtros</h5>

        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
        <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
        <!--        <div class="simplebar-height-auto-observer-wrapper">-->
        <!--            <div class="simplebar-height-auto-observer">-->
                        
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-mask">-->
        <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
        <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
        <!--                    <div class="simplebar-content" style="padding: 0px;">-->
            <div id="ctnFiltro" class="p-3">
				<div class="card border" style="border-top: 3px #536878 solid!important;">
					<div class="card-header">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-0">Columnas</h6>
                            </div>
                            <div class="flex-shrink-0">
                                <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                    <li class="list-inline-item">
                                        <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseColumnasFiltros" role="button" aria-expanded="true" aria-controls="collapseColumnasFiltros">
                                            <i class="mdi mdi-plus align-middle plus"></i>
                                            <i class="mdi mdi-minus align-middle minus"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
					<div class="card-body collapse show" id="collapseColumnasFiltros" style="">
						cxcvcxxvxcxcv
					</div>
				</div>
				<div class="panel">
                    <div class="panel-heading">
                        <h4>Columnas</h4>
                    </div>
                    <div class="panel-content">
                        <div class="row">
                            adasasads
                        </div>
                    </div>
                </div>
            </div>
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
        <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
        <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Información Módulo -->
<div class="modal fade zoomIn" id="informacionModulo" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionModulo" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleinformacionModulo">Información de módulo</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionModulo" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtCabecera_i" class="form-label">Cabecera</label>
								<select class="form-select" aria-label="Cabecera" id="txtCabecera_i" name="txtCabecera_i">
									<option selected="" value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtModulo_i" class="form-label">Módulo</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Módulo" id="txtModulo_i" name="txtModulo_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtOrden_i" class="form-label">Orden</label>
							<div class="input-group">
								<input type="number" class="form-control" min="1" aria-label="Orden" id="txtOrden_i" name="txtOrden_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtIcono_i" class="form-label">Clase ícono</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Ícono" id="txtIcono_i" name="txtIcono_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtObservacionModulo_i" class="form-label">Observación</label>
								<textarea class="form-control" id="txtObservacionModulo_i" name="txtObservacionModulo_i" rows="3"></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" id="btnEjecutarModulo" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-import mx-1" style="font-size: 14px;"></i>Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>