<?php
namespace App\Models\URES;
use CodeIgniter\Model;

class KitsTrabajoModel extends Model
{
    protected $table      = 'kit_trabajo';
    protected $primaryKey = 'IDKitTrabajo';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['CategoriaKitTrabajo', 'Detalle', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listarKitsTrabajo($array)
    {
        $this->select('kit_trabajo.IDKitTrabajo,
            kit_trabajo.CategoriaKitTrabajo,
            kit_trabajo.Detalle,
            kit_trabajo.Estado');
             
        if(!empty($array))
        {
            if(isset($array['estado']) && $array['estado'] != '' && $array['estado'] != '')
            {
                $this->where('kit_trabajo.Estado', $array['estado']);
            }
            
            if(isset($array['like']) && $array['like'] != '' && $array['like'] != null)
            {
                //VISUALIZO TODAS LAS PETICIONES DE MI GRUPO DE TRABAJO QUE NO ESTÉN APROBADOS CANCELADOS O AA
                $this->groupStart(); // Inicia un grupo de condiciones
                $this->orLike("kit_trabajo.CategoriaKitTrabajo", $array['like']);
                $this->groupEnd(); // Finaliza el grupo de condiciones
                
            }
        }
        
        
        
        $datos = $this->findAll();
        return $datos;
    }

    // public function listarKitDemoXCodigoKitXNoAsignado($codigoKitDemo)
    // {
    //     $this->select('kit_demo.IDItemKitDemo,
    //         kit_demo.CodigoKitDemo,
    //         kit_demo.IDElementoDemo,
    //         elementos_demo.SKU,
    //         elementos_demo.Nombre,
    //         elementos_demo.PrecioReposicion,
    //         elementos_demo.MonedaReposicion,
    //         kit_demo.Serie,
    //         kit_demo.Detalle,
    //         kit_demo.FechaCompra,
    //         kit_demo.Estado');
    //     $this->join('elementos_demo', 'kit_demo.IDElementoDemo = elementos_demo.IDElementoDemo', 'left');
    //     $this->where('kit_demo.CodigoKitDemo', $codigoKitDemo);
    //     $this->where('kit_demo.Estado', "ACT");
    //     $this->where('kit_demo.IDItemKitdemo NOT IN (SELECT
    //                 kit_demo.IDItemKitDemo
    //             FROM 
    //                 asignaciones_detalle
    //             INNER JOIN 
    //             	kit_demo ON asignaciones_detalle.IDElemento = kit_demo.IDItemKitDemo AND asignaciones_detalle.TipoElemento = "KITDEMO"
    //             LEFT JOIN 
    //                 devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
    //             WHERE 
    //                 devoluciones_detalle.IDDevolucion IS NULL)');
        
    //     $datos = $this->findAll();
    //     return $datos;
    // }
    
    // public function obtenerKitDemoAsignadoUsuario($idUsuario)
    // {
    //     $consulta = "SELECT DISTINCT
    //         kit_demo.CodigoKitDemo
    //     FROM 
    //         asignaciones_detalle
    //     INNER JOIN 
    //     	asignaciones ON asignaciones_detalle.IDAsignacion = asignaciones.IDAsignacion
    //     INNER JOIN 
    //     	kit_demo ON asignaciones_detalle.IDElemento = kit_demo.IDItemKitDemo AND asignaciones_detalle.TipoElemento = 'KITDEMO'
    //     LEFT JOIN 
    //         devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
    //     WHERE 
    //         devoluciones_detalle.IDDevolucion IS NULL AND asignaciones.UsuarioAsignado = '".$idUsuario."'";

    //     $obtieneConsulta = $this->db->query($consulta);
    //     return $obtieneConsulta->getResultArray();
    // }

    // public function listarKitDemoDisponibles($variable)
    // {
    //     $consulta = "SELECT DISTINCT
    //         kit_demo.CodigoKitDemo
    //     FROM 
    //         kit_demo
    //     WHERE   
    //         (kit_demo.CodigoKitDemo LIKE '%".$variable."%') AND
    //         kit_demo.Estado IN ('ACT') AND 
    //         kit_demo.CodigoKitDemo NOT IN (SELECT DISTINCT
    //                 kit_demo.CodigoKitDemo
    //             FROM 
    //                 asignaciones_detalle
    //             INNER JOIN 
    //             	kit_demo ON asignaciones_detalle.IDElemento = kit_demo.IDItemKitDemo AND asignaciones_detalle.TipoElemento = 'KITDEMO'
    //             LEFT JOIN 
    //                 devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
    //             WHERE 
    //                 devoluciones_detalle.IDDevolucion IS NULL)";

    //     $obtieneConsulta = $this->db->query($consulta);
    //     return $obtieneConsulta->getResultArray();
    // }
    
    // public function obtenerItemKitDemo($idItemKitDemo)
    // {
    //     $this->select('kit_demo.IDItemKitDemo,
    //         kit_demo.CodigoKitDemo,
    //         kit_demo.IDElementoDemo,
    //         elementos_demo.SKU,
    //         elementos_demo.Nombre,
    //         elementos_demo.PrecioReposicion,
    //         kit_demo.Serie,
    //         kit_demo.Detalle,
    //         kit_demo.FechaCompra,
    //         kit_demo.Estado');
    //     $this->join('elementos_demo', 'kit_demo.IDElementoDemo = elementos_demo.IDElementoDemo', 'left');
    //     $this->where('kit_demo.IDItemKitDemo', $idItemKitDemo);

    //     $datos = $this->first();
    //     return $datos;
    // }

}