<?php
namespace App\Models\IT;
use CodeIgniter\Model;

class TarjetasAccesoUbicacionesModel extends Model
{
    protected $table      = 'tarjetas_acceso_ubicaciones';
    protected $primaryKey = 'IDTarjetaAcceso';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDTarjetaAcceso', 'IDUbicacionAcceso', 'UsuarioRegistra', 'FechaRegistra'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listarUbicacionesTarjetaAcceso($idTarjetaAcceso)
    {
        $this->select('tarjetas_acceso_ubicaciones.IDTarjetaAcceso,
            dbMASTERUSUARIO.direccion_ubicacion_acceso.IDUbicacionAcceso,
            dbMASTERUSUARIO.direccion_ubicacion_acceso.Ubicacion,
            dbMASTERUSUARIO.direccion_ubicacion_acceso.IDDireccion,
            IF(tarjetas_acceso_ubicaciones.IDTarjetaAcceso IS NULL, 0, 1) AS "ACTIVO"');
        $this->join('dbMASTERUSUARIO.direccion_ubicacion_acceso', 'tarjetas_acceso_ubicaciones.IDUbicacionAcceso = dbMASTERUSUARIO.direccion_ubicacion_acceso.IDUbicacionAcceso AND tarjetas_acceso_ubicaciones.IDTarjetaAcceso = "'.$idTarjetaAcceso.'"', 'right');
      
        $datos = $this->findAll();
        return $datos;
    }
}