<?php
namespace App\Models\IT;
use CodeIgniter\Model;

class TarjetasAccesoModel extends Model
{
    protected $table      = 'tarjetas_acceso';
    protected $primaryKey = 'IDTarjetaAcceso';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Serie', 'PrecioCompra', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'Situacion', 'Transito', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listaGeneralViewTarjetasAcceso($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        $builder = $this->db->table('vista_listar_tarjetas_acceso');
        
        $fields = array(
            0 => 'IDTarjetaAcceso', 
            1 => 'Serie', 
            2 => 'PrecioCompra', 
            3 => 'Observacion', 
            4 => 'Estado', 
            5 => 'UsuarioAsignado', 
            6 => 'NombreAsignado', 
            7 => 'MatriculaAsignado');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS total");
        $sql = $builder->getCompiledSelect();
        $totalRecords = $this->db->query($sql)->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $builder = $this->db->table('vista_listar_tarjetas_acceso');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            if(in_array($get['search']['value'], array("No Asignado", "no asignado", "No asignado", "NO ASIGNADO")))
            {
                $builder->where("IDAsignado IS NULL");
            }
            else
            {
                $builder->groupStart(); // Inicia un grupo de condiciones
            
                foreach ($get['columns'] as $k => $column) 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $builder->orLike($fields[$k], $get['search']['value']);
                    }
                }
                
                $builder->orLike("NombreAsignado", $get['search']['value']);
                
                $builder->groupEnd(); // Finaliza el grupo de condiciones
                
            }
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS filtered");
        $sql = $builder->getCompiledSelect();
        $filteredRecords = $this->db->query($sql)->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $builder = $this->db->table('vista_listar_tarjetas_acceso');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            if(in_array($get['search']['value'], array("No Asignado", "no asignado", "No asignado")))
            {
                $builder->where("IDAsignado IS NULL");
            }
            else
            {
                $builder->groupStart(); // Inicia un grupo de condiciones
            
                foreach ($get['columns'] as $k => $column) 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $builder->orLike($fields[$k], $get['search']['value']);
                    }
                }
                
                $builder->orLike("NombreAsignado", $get['search']['value']);
                
                $builder->groupEnd(); // Finaliza el grupo de condiciones
                
            }
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $builder->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        $builder->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        
        $sql = $builder->getCompiledSelect();
        // echo $sql; exit;
        $result = $this->db->query($sql)->getResultArray();
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }


    // public function listarTarjetasAcceso()
    // {
    //     $this->select('
    //         tarjetas_acceso.IDTarjetaAcceso,
    //         tarjetas_acceso.Serie,
    //         tarjetas_acceso.PrecioCompra,
    //         tarjetas_acceso.Observacion,
    //         tarjetas_acceso.Estado,
    //         asignacion.UsuarioAsignado');
    //     $this->join('(SELECT asignaciones_detalle.IDElemento, asignaciones.UsuarioAsignado FROM asignaciones INNER JOIN asignaciones_detalle ON asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion LEFT JOIN devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion WHERE devoluciones_detalle.IDDevolucion IS NULL AND asignaciones_detalle.TipoElemento="TARJETA") AS asignacion', 'tarjetas_acceso.IDTarjetaAcceso = asignacion.IDElemento', 'left');

    //     $datos = $this->findAll();
    //     return $datos;
    // }
    
    public function listarTarjetasAccesoDisponibles($variable)
    {
        $consulta = "SELECT 
            tarjetas_acceso.IDTarjetaAcceso, 
            tarjetas_acceso.Serie, 
            tarjetas_acceso.PrecioCompra,
            tarjetas_acceso.Observacion
        FROM
            tarjetas_acceso 
        WHERE 
            (tarjetas_acceso.Serie LIKE '%".$variable."%' OR tarjetas_acceso.Observacion LIKE '%".$variable."%') AND
            tarjetas_acceso.Estado IN ('ACT') AND 
            tarjetas_acceso.IDTarjetaAcceso NOT IN (SELECT 
                    asignaciones_detalle.IDElemento 
                FROM 
                    asignaciones_detalle 
                LEFT JOIN 
                    devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
                WHERE 
                    devoluciones_detalle.IDDevolucion IS NULL AND 
                    asignaciones_detalle.TipoElemento = 'TARJETA') AND 
            tarjetas_acceso.IDTarjetaAcceso NOT IN (SELECT 
                    asignaciones_detalle.IDElemento 
                FROM 
                    asignaciones_detalle 
                LEFT JOIN 
                    devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
                WHERE 
                    devoluciones_detalle.Estado = 'REGIS' AND 
                    asignaciones_detalle.TipoElemento = 'TARJETA')";
        
        $obtieneConsulta = $this->db->query($consulta);
        return $obtieneConsulta->getResultArray();
    }
}