<?php
namespace App\Models\IT;
use CodeIgniter\Model;

class MovilesModel extends Model
{
    protected $table      = 'moviles';
    protected $primaryKey = 'IDMovil';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDModelo', 'Proveedor', 'IMEI', 'FechaCompra', 'PrecioCompra', 'PrecioLista', 'EquipoStock', 'FechaEstado', 'UsuarioEstado', 'Estado', 'Situacion', 'Transito','MotivoCambio', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function obtenerMovil($idMovil)
    {
        $this->select('
            moviles.IDMovil ,
            moviles.IDModelo,
            marcas_dispositivos.Modelo,
            marcas_dispositivos.IDMarca,
            marcas_dispositivos.Descontinuado,
            marcas.Marca,
            moviles.Proveedor,
            moviles.IMEI,
            moviles.FechaCompra,
            moviles.PrecioCompra,
            moviles.PrecioLista,
            moviles.EquipoStock');
        $this->join('marcas_dispositivos', 'moviles.IDModelo = marcas_dispositivos.IDDispositivo', 'left');
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');
        $this->where('moviles.IDMovil', $idMovil);
        
        $datos = $this->first();
        return $datos;
    }
    
    public function listadoMoviles($array)
    {
        $builder = $this->db->table('vista_listar_moviles');
        
        if(!empty($array))
        {
            if(isset($array['estado']) && $array['estado'] != '' && $array['estado'] != null)
            {
                $builder->where('Estado', $array['estado']);
            }
            
            if(isset($array['libre']) && $array['libre'] == 'Y')
            {
                $builder->where('IDAsignado IS NULL');
            }
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
    
    public function listaGeneralViewMoviles($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        $builder = $this->db->table('vista_listar_moviles');
        
        $fields = array(
            0 => 'IDMovil', 
            1 => 'IMEI', 
            2 => 'Marca', 
            3 => 'Modelo', 
            4 => 'FechaCompra', 
            5 => 'Estado', 
            6 => 'EquipoStock', 
            7 => 'UsuarioAsignado', 
            8 => 'MatriculaAsignado');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS total");
        $sql = $builder->getCompiledSelect();
        $totalRecords = $this->db->query($sql)->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $builder = $this->db->table('vista_listar_moviles');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if (valor_valido($get['marcaFiltro'] ?? null)) {
            $builder->where('IDMarca', $get['marcaFiltro']);
        }
        
        if (valor_valido($get['modeloFiltro'] ?? null)) {
            $builder->where('IDModelo', $get['modeloFiltro']);
        }
        
        if (valor_valido($get['estadosFiltro'] ?? null)) {
            $builder->whereIn('Estado', $get['estadosFiltro']);
        }
        
        if (valor_valido($get['subareaFiltro'] ?? null)) {
            $builder->where('IDSubareaUsuarioAsignado', $get['subareaFiltro']);
        }
        
        if (valor_valido($get['areaFiltro'] ?? null) && !valor_valido($get['subareaFiltro'] ?? null)) {
            $builder->where('IDAreaUsuarioAsignado', $get['areaFiltro']);
        }
        
        if (valor_valido($get['direccionFiltro'] ?? null) && !valor_valido($get['areaFiltro'] ?? null) && !valor_valido($get['subareaFiltro'] ?? null)) {
            $builder->where('IDDireccionUsuarioAsignado', $get['direccionFiltro']);
        }
        
        if (valor_valido($get['asignadosFiltro'] ?? null) && $get['asignadosFiltro'] == "N") {
            $builder->where("IDAsignacion IS NULL", null, false);
        }
        else if (valor_valido($get['asignadosFiltro'] ?? null) && $get['asignadosFiltro'] == "Y") {
            $builder->where("IDAsignacion IS NOT NULL", null, false);
        }
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
        
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $builder->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $builder->orLike("NombreAsignado", $get['search']['value']);
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS filtered");
        $sql = $builder->getCompiledSelect();
        $filteredRecords = $this->db->query($sql)->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $builder = $this->db->table('vista_listar_moviles');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if (valor_valido($get['marcaFiltro'] ?? null)) {
            $builder->where('IDMarca', $get['marcaFiltro']);
        }
        
        if (valor_valido($get['modeloFiltro'] ?? null)) {
            $builder->where('IDModelo', $get['modeloFiltro']);
        }
        
        if (valor_valido($get['estadosFiltro'] ?? null)) {
            $builder->whereIn('Estado', $get['estadosFiltro']);
        }
        
        if (valor_valido($get['subareaFiltro'] ?? null)) {
            $builder->where('IDSubareaUsuarioAsignado', $get['subareaFiltro']);
        }
        
        if (valor_valido($get['areaFiltro'] ?? null) && !valor_valido($get['subareaFiltro'] ?? null)) {
            $builder->where('IDAreaUsuarioAsignado', $get['areaFiltro']);
        }
        
        if (valor_valido($get['direccionFiltro'] ?? null) && !valor_valido($get['areaFiltro'] ?? null) && !valor_valido($get['subareaFiltro'] ?? null)) {
            $builder->where('IDDireccionUsuarioAsignado', $get['direccionFiltro']);
        }
        
        if (valor_valido($get['asignadosFiltro'] ?? null) && $get['asignadosFiltro'] == "N") {
            $builder->where("IDDevolucion IS NOT NULL", null, false);
        }
        else if (valor_valido($get['asignadosFiltro'] ?? null) && $get['asignadosFiltro'] == "Y") {
            $builder->where("IDDevolucion IS NULL", null, false);
        }
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
        
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $builder->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $builder->orLike("NombreAsignado", $get['search']['value']);
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $builder->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        $builder->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        
        $sql = $builder->getCompiledSelect();
        // echo $sql; exit;
        $result = $this->db->query($sql)->getResultArray();
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }
    
    public function listarMovilesDisponibles($variable)
    {
        $consulta = "SELECT 
            moviles.IDMovil,
            moviles.IMEI, 
            marcas_dispositivos.Modelo,
            marcas.Marca 
        FROM 
            moviles 
        INNER JOIN 
            marcas_dispositivos ON moviles.IDModelo = marcas_dispositivos.IDDispositivo 
        INNER JOIN
        	marcas ON marcas_dispositivos.IDMarca = marcas.IDMarca
        WHERE   
            (moviles.IMEI LIKE '%".$variable."%' OR marcas_dispositivos.Modelo LIKE '%".$variable."%' OR marcas.Marca LIKE '%".$variable."%') AND
            moviles.Estado IN ('ACT') AND 
            moviles.IDMovil NOT IN (SELECT 
                    asignaciones_detalle.IDElemento 
                FROM 
                    asignaciones_detalle 
                LEFT JOIN 
                    devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
                WHERE 
                    devoluciones_detalle.IDDevolucion IS NULL AND 
                    asignaciones_detalle.TipoElemento = 'MOVIL') AND
            moviles.IDMovil NOT IN (SELECT 
                    asignaciones_detalle.IDElemento 
                FROM 
                    asignaciones_detalle 
                LEFT JOIN 
                    devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
                WHERE 
                    devoluciones_detalle.Estado = 'REGIS' AND 
                    asignaciones_detalle.TipoElemento = 'MOVIL')";

        $obtieneConsulta = $this->db->query($consulta);
        return $obtieneConsulta->getResultArray();
    }
}