<?php
namespace App\Models\IT;
use CodeIgniter\Model;

class AccesoriosITModel extends Model
{
    protected $table      = 'accesorios_it';
    protected $primaryKey = 'IDAccesorio';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Accesorio', 'IDModelo', 'CodigoNavision', 'GeneraCobro', 'ReposicionNuevo', 'ReposicionReutilizado', 'CantidadTotal', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listaGeneralAccesoriosIT($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        
        $fields = array(
            0 => 'accesorios_it.IDAccesorio', 
            1 => 'accesorios_it.Accesorio', 
            2 => 'accesorios_it.CodigoNavision',
            3 => 'marcas.Marca',
            4 => 'marcas_dispositivos.Modelo',
            5 => 'accesorios_it.CantidadTotal',
            6 => 'accesorios_it.GeneraCobro');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS total");
        $totalQuery = $this->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('
            accesorios_it.IDAccesorio,
            accesorios_it.Accesorio,
            accesorios_it.CodigoNavision,
            marcas.Marca,
            marcas_dispositivos.Modelo,
            accesorios_it.CantidadTotal,
            accesorios_it.GeneraCobro');
            
        $this->join('marcas_dispositivos', 'accesorios_it.IDModelo = marcas_dispositivos.IDDispositivo', 'left');
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS filtered");
        $filteredQuery = $this->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $this->select('
            accesorios_it.IDAccesorio,
            accesorios_it.Accesorio,
            accesorios_it.CodigoNavision,
            marcas.Marca,
            marcas_dispositivos.Modelo,
            accesorios_it.CantidadTotal,
            accesorios_it.GeneraCobro');
            
        $this->join('marcas_dispositivos', 'accesorios_it.IDModelo = marcas_dispositivos.IDDispositivo', 'left');
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->get();
        // return $this->getLastQuery();
        
        // $result = $this->get()->getResultArray();
        // return $result;
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo $this->getLastQuery();
        // exit;
        
        // return $result;
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }

    public function listarAccesorios($estado)
    {
        $this->select('accesorios_it.IDAccesorio,
            accesorios_it.Accesorio,
            accesorios_it.IDModelo,
            accesorios_it.GeneraCobro,
            accesorios_it.ReposicionNuevo,
            accesorios_it.ReposicionReutilizado,
            accesorios_it.CodigoNavision,
            accesorios_it.CantidadTotal,
            marcas_dispositivos.Modelo,
            marcas.Marca,
            subtipo.nombre_subtipo,
            tipo.nombre_tipo,
            categoria.nombre_categoria,
            accesorios_it.Estado');
        $this->join('marcas_dispositivos', 'accesorios_it.IDModelo = marcas_dispositivos.IDDispositivo', 'left');
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');
        // $this->join('subtipo', 'accesorios_it.IDSubtipo = subtipo.id_subtipo', 'left');
        $this->join('subtipo', 'marcas_dispositivos.Subtipo = subtipo.id_subtipo', 'left');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
        
        if($estado != '')
        {
            $this->where('accesorios_it.Estado', $estado);
        }
        
        $datos = $this->findAll();
        return $datos;
    }

    public function obtenerAccesorio($idAccesorio)
    {
        $this->select('accesorios_it.IDAccesorio,
            accesorios_it.Accesorio,
            accesorios_it.IDModelo,
            accesorios_it.CodigoNavision,
            accesorios_it.GeneraCobro,
            accesorios_it.CantidadTotal,
            accesorios_it.Observacion,
            accesorios_it.ReposicionNuevo,
            accesorios_it.ReposicionReutilizado,
            marcas_dispositivos.Modelo,
            marcas_dispositivos.IDMarca,
            marcas.Marca,
            accesorios_it.CodigoNavision,
            marcas_dispositivos.Subtipo,
            subtipo.nombre_subtipo,
            subtipo.id_tipo,
            tipo.nombre_tipo,
            tipo.id_categoria,
            categoria.nombre_categoria,
            accesorios_it.Estado');
        $this->join('marcas_dispositivos', 'accesorios_it.IDModelo = marcas_dispositivos.IDDispositivo', 'left');
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');
        // $this->join('subtipo', 'accesorios_it.IDSubtipo = subtipo.id_subtipo', 'left');
        $this->join('subtipo', 'marcas_dispositivos.Subtipo = subtipo.id_subtipo', 'left');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
        
        $this->where('accesorios_it.IDAccesorio', $idAccesorio);
        
        $datos = $this->first();
        return $datos;
    }
    
}