<?php
namespace App\Models\IT;
use CodeIgniter\Model;

class AccesoriosITKardexModel extends Model
{
    protected $table      = 'accesorios_it_kardex';
    protected $primaryKey = 'IDAccesorio';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDAccesorio', 'CantidadPrevio', 'Concepto', 'Movimiento', 'Cantidad', 'IDUsuario', 'IDDelegacion', 'IDSubarea', 'IDArea', 'IDDireccion', 'IDCargo', 'IDAsignacion', 'Observacion', 'UsuarioRegistra', 'FechaRegistra', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listadoMovimientosAccesorioIT($array)
    {
        $this->select('accesorios_it_kardex.IDAccesorio,
            accesorios_it_kardex.CantidadPrevio,
            accesorios_it_kardex.Concepto,
            accesorios_it_kardex.Movimiento,
            accesorios_it_kardex.Cantidad,
            accesorios_it_kardex.IDUsuario,
            accesorios_it_kardex.IDAsignacion,
            accesorios_it_kardex.Observacion,
            accesorios_it_kardex.FechaRegistra');
            
        if(!empty($array))
        {
            if(isset($array['IDAccesorio']) && $array['IDAccesorio'] != '')
            {
                $this->where("accesorios_it_kardex.IDAccesorio", $array['IDAccesorio']);
            }
            
            if(isset($array['FechaInicio']) && $array['FechaInicio'] != '')
            {
                $this->where("accesorios_it_kardex.FechaRegistra >=", $array['FechaInicio']);
            }
            
            if(isset($array['FechaFinal']) && $array['FechaFinal'] != '')
            {
                $this->where("accesorios_it_kardex.FechaRegistra <=", $array['FechaFinal']);
            }
        }
        
        $this->orderBy("accesorios_it_kardex.FechaRegistra", "DESC");
        
        $datos = $this->findAll();
        return $datos;
    }
    
    public function cantidadTraspasoAccesorioIT($array)
    {
        $this->select('accesorios_it.Accesorio,
            accesorios_it_kardex.IDDelegacion,
            SUM(accesorios_it_kardex.Cantidad) AS "Total"');
        
        $this->join('accesorios_it', 'accesorios_it_kardex.IDAccesorio = accesorios_it.IDAccesorio', 'left');
        $this->where("accesorios_it_kardex.Movimiento", "SAL");
        
        if(!empty($array))
        {
            if(isset($array['FechaInicio']) && $array['FechaInicio'] != '')
            {
                $this->where("accesorios_it_kardex.FechaRegistra >=", $array['FechaInicio']);
            }
            
            if(isset($array['FechaFinal']) && $array['FechaFinal'] != '')
            {
                $this->where("accesorios_it_kardex.FechaRegistra <=", $array['FechaFinal']);
            }
        }
        
        $this->groupBy(['accesorios_it.Accesorio', 'accesorios_it_kardex.IDDelegacion']);
        
        $datos = $this->findAll();
        return $datos;
    }
}