<?php
namespace App\Models\Configuracion;
use CodeIgniter\Model;

class MarcasDispositivosModel extends Model
{
    protected $table      = 'marcas_dispositivos';
    protected $primaryKey = 'IDDispositivo';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDMarca', 'Modelo', 'Subtipo', 'Descontinuado','FechaEstado', 'UsuarioEstado', 'Estado', 'MotivoCambio', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listaGeneralDispositivos($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        
        $fields = array(
            0 => 'marcas_dispositivos.IDDispositivo', 
            1 => 'marcas.Marca', 
            2 => 'marcas_dispositivos.Modelo',
            4 => 'subtipo.nombre_subtipo',
            5 => 'tipo.nombre_tipo',
            6 => 'categoria.nombre_categoria',
            7 => 'marcas_dispositivos.Estado');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS total");
        $totalQuery = $this->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('
            marcas_dispositivos.IDDispositivo,
            marcas_dispositivos.Modelo,
            marcas_dispositivos.Estado,
            marcas_dispositivos.Subtipo,
            marcas_dispositivos.Descontinuado,
            marcas_dispositivos.IDMarca,
            marcas.Marca,
            subtipo.nombre_subtipo,
            subtipo.id_tipo,
            tipo.nombre_tipo,
            tipo.id_categoria,
            categoria.nombre_categoria');
            
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');
        $this->join('subtipo', 'marcas_dispositivos.Subtipo = subtipo.id_subtipo', 'left');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            if(mb_strtolower($get['search']['value']) == "descontinuado")
            {
                $this->where("marcas_dispositivos.Descontinuado", "Y");
            }
            else
            {
                $this->groupStart(); // Inicia un grupo de condiciones
                
                foreach ($get['columns'] as $k => $column) 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $this->orLike($fields[$k], $get['search']['value']);
                    }
                }
                
                $this->groupEnd(); // Finaliza el grupo de condiciones
            }
        }
        
        if(isset($adicionales['IDMarca']) && $adicionales['IDMarca'] != "TOTAL")
        {
            $this->where("marcas_dispositivos.IDMarca", $adicionales['IDMarca']);
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS filtered");
        $filteredQuery = $this->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $this->select('
            marcas_dispositivos.IDDispositivo,
            marcas_dispositivos.Modelo,
            marcas_dispositivos.Estado,
            marcas_dispositivos.Subtipo,
            marcas_dispositivos.Descontinuado,
            marcas_dispositivos.IDMarca,
            marcas.Marca,
            subtipo.nombre_subtipo,
            subtipo.id_tipo,
            tipo.nombre_tipo,
            tipo.id_categoria,
            categoria.nombre_categoria');
            
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');
        $this->join('subtipo', 'marcas_dispositivos.Subtipo = subtipo.id_subtipo', 'left');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            if(mb_strtolower($get['search']['value']) == "descontinuado")
            {
                $this->where("marcas_dispositivos.Descontinuado", "Y");
            }
            else
            {
                $this->groupStart(); // Inicia un grupo de condiciones
                
                foreach ($get['columns'] as $k => $column) 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $this->orLike($fields[$k], $get['search']['value']);
                    }
                }
                
                $this->groupEnd(); // Finaliza el grupo de condiciones
            }
        }
        
        if(isset($adicionales['IDMarca']) && $adicionales['IDMarca'] != "TOTAL")
        {
            $this->where("marcas_dispositivos.IDMarca", $adicionales['IDMarca']);
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->get();
        // return $this->getLastQuery();
        
        // $result = $this->get()->getResultArray();
        // return $result;
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo $this->getLastQuery();
        // exit;
        
        // return $result;
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }

    public function obtenerDispositivo($idDispositivo)
    {
        $this->select('
            marcas_dispositivos.IDDispositivo,
            marcas_dispositivos.Modelo,
            marcas_dispositivos.Estado,
            marcas_dispositivos.Subtipo,
            marcas_dispositivos.Descontinuado,
            marcas_dispositivos.IDMarca,
            subtipo.nombre_subtipo,
            subtipo.id_tipo,
            tipo.nombre_tipo,
            tipo.id_categoria,
            categoria.nombre_categoria');
        $this->join('subtipo', 'marcas_dispositivos.Subtipo = subtipo.id_subtipo', 'left');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
        $this->where('marcas_dispositivos.IDDispositivo', $idDispositivo);

        $datos = $this->first();
        return $datos;
    }

    // public function listadoDispositivosXMarca($idMarca)
    // {
    //     $this->select('
    //         marcas_dispositivos.IDDispositivo,
    //         marcas_dispositivos.Modelo,
    //         marcas_dispositivos.Estado,
    //         marcas_dispositivos.Descontinuado,
    //         subtipo.nombre_subtipo,
    //         tipo.nombre_tipo,
    //         categoria.nombre_categoria');
    //     $this->join('subtipo', 'marcas_dispositivos.Subtipo = subtipo.id_subtipo', 'left');
    //     $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
    //     $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
    //     $this->where('marcas_dispositivos.IDMarca', $idMarca);

    //     $datos = $this->findAll();
    //     return $datos;
    // }

    public function listadoDispositivos($array)
    {
        $this->select('
            marcas_dispositivos.IDDispositivo,
            marcas_dispositivos.Modelo,
            marcas_dispositivos.Estado,
            marcas_dispositivos.Descontinuado,
            subtipo.nombre_subtipo,
            subtipo.id_tipo,
            tipo.nombre_tipo,
            tipo.id_categoria,
            categoria.nombre_categoria');
        $this->join('subtipo', 'marcas_dispositivos.Subtipo = subtipo.id_subtipo', 'left');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');

        if(isset($array['idMarca']) && $array['idMarca'] != '')
        {
            $this->where('marcas_dispositivos.IDMarca', $array['idMarca']);
        }
        
        if(isset($array['estado']) && $array['estado'] != '')
        {
            $this->where('marcas_dispositivos.Estado', $array['estado']);
        }

        if(isset($array['clave']) && $array['clave'] != '')
        {
            $this->where('categoria.clave', $array['clave']);
        }
        
        if(isset($array['modelo']) && $array['modelo'] != '')
        {
            $this->where('marcas_dispositivos.Modelo', $array['modelo']);
        }
        
        if(isset($array['marca']) && $array['marca'] != '')
        {
            $this->where('marcas.Marca', $array['marca']);
        }
        $datos = $this->findAll();
        return $datos;
    }

}