<?php
namespace App\Models\Configuracion;
use CodeIgniter\Model;

class ElementosTrabajoModel extends Model
{
    protected $table      = 'elementos_trabajo';
    protected $primaryKey = 'IDElementoTrabajo';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['SKU', 'Nombre', 'CantidadStock', 'Clasificacion', 'Observacion', 'MonedaReposicion', 'PrecioReposicion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listaGeneralElementosTrabajo($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        
        $fields = array(
            0 => 'IDElementoTrabajo', 
            1 => 'SKU', 
            2 => 'Nombre', 
            3 => 'CantidadStock', 
            4 => 'Clasificacion', 
            5 => 'Observacion', 
            6 => 'MonedaReposicion', 
            7 => 'PrecioReposicion', 
            8 => 'Estado');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS total");
        $totalQuery = $this->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('
            IDElementoTrabajo,
            SKU,
            Nombre,
            CantidadStock,
            Clasificacion,
            Observacion,
            MonedaReposicion,
            PrecioReposicion,
            Estado');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS filtered");
        $filteredQuery = $this->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $this->select('
            IDElementoTrabajo,
            SKU,
            Nombre,
            CantidadStock,
            Clasificacion,
            Observacion,
            MonedaReposicion,
            PrecioReposicion,
            Estado');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->get();
        // return $this->getLastQuery();
        
        // $result = $this->get()->getResultArray();
        // return $result;
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo $this->getLastQuery();
        // exit;
        
        // return $result;
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw' => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal' => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered' => $filteredRecords, // Total de registros después de aplicar filtros
            'data' => $result // Los datos actuales para mostrar
        ];
    }

    public function listarElementosTrabajo($array)
    {
        $this->select('
            elementos_trabajo.IDElementoTrabajo,
            elementos_trabajo.SKU,
            elementos_trabajo.Nombre,
            elementos_trabajo.CantidadStock,
            elementos_trabajo.Clasificacion,
            elementos_trabajo.Observacion,
            elementos_trabajo.MonedaReposicion,
            elementos_trabajo.PrecioReposicion');
            
        if(!empty($array))
        {
            if(isset($array['like']) && $array['like'] != '' && $array['like'] != null)
            {
                //VISUALIZO TODAS LAS PETICIONES DE MI GRUPO DE TRABAJO QUE NO ESTÉN APROBADOS CANCELADOS O AA
                $this->groupStart(); // Inicia un grupo de condiciones
                $this->orLike("elementos_trabajo.SKU", $array['like']);
                $this->orLike('elementos_trabajo.Nombre', $array['like']);
                $this->orLike('elementos_trabajo.Clasificacion', $array['like']);
                $this->groupEnd(); // Finaliza el grupo de condiciones
                
            }
        }
        
        // if($array['IDUsuario'] == 3660)
        // {
        // $this->get();
        // return $this->getLastQuery();
        // }
        // else
        // {
        $datos = $this->findAll();
        return $datos;
        // }
    }
    
}