<?php
namespace App\Models\Cargos;
use CodeIgniter\Model;

class ReposicionesModel extends Model
{
    protected $table      = 'reposiciones';
    protected $primaryKey = 'IDReposicion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['UsuarioAdjudicado', 'CargoAdjudicado', 'DireccionAdjudicado', 'AreaAdjudicado', 'SubareaAdjudicado', 'DelegacionAdjudicado', 'TokenLinkFirma', 'LiberadoFirma', 'FechaRegistroFirma', 'ConceptoRegistroFirma', 'Motivo', 'Observacion', 'Cuotas', 'UsuarioCrea', 'CargoCrea', 'DireccionCrea', 'AreaCrea', 'SubareaCrea', 'DelegacionCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function obtenerInformacionActaReposicion($array)
    {
        $builder = $this->db->table('vista_listar_reposiciones');
        
        if(!empty($array))
        {
            if(isset($array['IDReposicion']) && !empty($array['IDReposicion']))
            {
                $builder->where('IDReposicion', $array['IDReposicion']);
            }
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getRowArray();
        
        return $datos;
    }
    
    public function listarReposicionesServerside($get, $adicionales)
    {
        /*
        * ----------------------------
        * SETEAMOS VISTA A UTILIZAR
        * ----------------------------
        */
    
        $builder = $this->db->table('vista_listar_reposiciones');
        
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        // $this->globales = new Globales();
        
        $fields = array(
            0 => 'IDReposicion', 
            1 => 'MatriculaAdjudicado', 
            2 => 'NombreAdjudicado', 
            3 => 'FechaCrea', 
            4 => 'TotalDescuentoTrabajador', 
            5 => 'Observacion', 
            6 => 'Cuotas', 
            7 => 'TotalElementos',
            8 => 'FechaRegistroFirma');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS total");
        $totalQuery = $builder->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $builder->select('IDReposicion,
            MatriculaAdjudicado,
            NombreAdjudicado,
            TokenLinkFirma,
            FechaCrea,
            TotalDescuentoTrabajador,
            Observacion,
            Cuotas,
            TotalElementos,
            FechaRegistroFirma');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if(isset($adicionales) && !empty($adicionales))
        {
            if(in_array($adicionales['IDPerfil'], array(3)))
            {
                if(isset($adicionales['Delegaciones']) && !empty($adicionales['Delegaciones']))
                {
                    $builder->whereIn('IDDelegacionUsuarioAdjudicado', $adicionales['Delegaciones']);
                }
                else if(isset($adicionales['CCAsignado']) && !empty($adicionales['CCAsignado']))
                {
                    $builder->whereIn('CCAdjudicado', $adicionales['CCAsignado']);
                }
                else
                {
                    $builder->where('1 = 0'); // Si quieres asegurarte que no devuelva nada
                }
            }
        }
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $builder->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS filtered");
        $filteredQuery = $builder->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $builder->select('IDReposicion,
            MatriculaAdjudicado,
            NombreAdjudicado,
            TokenLinkFirma,
            FechaCrea,
            TotalDescuentoTrabajador,
            Observacion,
            Cuotas,
            TotalElementos,
            FechaRegistroFirma');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if(isset($adicionales) && !empty($adicionales))
        {
            if(in_array($adicionales['IDPerfil'], array(3)))
            {
                if(isset($adicionales['Delegaciones']) && !empty($adicionales['Delegaciones']))
                {
                    $builder->whereIn('IDDelegacionUsuarioAdjudicado', $adicionales['Delegaciones']);
                }
                else if(isset($adicionales['CCAsignado']) && !empty($adicionales['CCAsignado']))
                {
                    $builder->whereIn('CCAdjudicado', $adicionales['CCAsignado']);
                }
                else
                {
                    $builder->where('1 = 0'); // Si quieres asegurarte que no devuelva nada
                }
            }
        }
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $builder->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $builder->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        $builder->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $builder->get()->getResultArray();
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }
    
    public function listarReposiciones($cc)
    {
        $builder = $this->db->table('vista_listar_reposiciones');
        if(!empty($cc))
        {
            $builder->whereIn('CCAdjudicado', $cc);
        }
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
}