<?php
namespace App\Models\Cargos;
use CodeIgniter\Model;

class ReposicionesDetalleModel extends Model
{
    protected $table      = 'reposiciones_detalle';
    protected $primaryKey = 'IDDetalleReposicion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDReposicion', 'IDDetalleAsignacion', 'TotalDescuento', 'TotalVerisure', 'TotalTrabajador', 'Observacion', 'TotalCuotas', 'MesFacturacion', 'AnioFacturacion', 'Bolsa', 'Cobrado', 'UsuarioCobro', 'FechaCobro', 'MontoCobro', 'ObservacionCobro', 'UsuarioExcepcion', 'FechaExcepcion', 'MontoExcepcion', 'ObservacionExcepcion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listarDescuentosReposicionesServerside($get, $adicionales)
    {
        /*
        * ----------------------------
        * SETEAMOS VISTA A UTILIZAR
        * ----------------------------
        */
    
        $builder = $this->db->table('vista_listar_descuentos_reposiciones');
        
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        // $this->globales = new Globales();
        
        $fields = array(
            1 => 'MatriculaAdjudicado', 
            5 => 'TotalTrabajador', 
            6 => 'TotalCuotas', 
            7 => 'Cobrado',
            8 => 'MontoCobro', 
            9 => 'FechaCobro',
            10 => 'ObservacionCobro');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS total");
        $totalQuery = $builder->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $builder->select('IDReposicion,
            TotalTrabajador,
            TotalCuotas,
            Observacion,
            Cobrado,
            FechaCobro,
            MontoCobro,
            ObservacionCobro,
            MesFacturacion,
            AnioFacturacion,
            IDUsuarioAdjudicado,
            NombresAdjudicado,
            ApellidosAdjudicado,
            MatriculaAdjudicado,
            TokenReposicion,
            TipoElemento,
            IDElemento,
            IDAsignacion,
            TokenAsignacion,
            TipoEquipo,
            Marca,
            Modelo,
            Serie');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if(isset($get['MesDescuento']) && !empty($get['MesDescuento']))
        {
            $builder->where('MesFacturacion', $get['MesDescuento']);
        }
        
        if(isset($get['AnioDescuento']) && !empty($get['AnioDescuento']))
        {
            $builder->where('AnioFacturacion', $get['AnioDescuento']);
        }
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                // Si la columna es la 2 o la 4 (que son CONCAT)
                if ($k == 2) 
                {
                    $builder->orLike("CONCAT(NombresAdjudicado, ' ', ApellidosAdjudicado)", $get['search']['value']);
                } 
                else if ($k == 4) 
                {
                    $builder->orLike("CONCAT(TipoEquipo, ' ', Marca, ' ', Modelo)", $get['search']['value']);
                } 
                else 
                {
                    if(array_key_exists($k, $fields))
                    {
                        // Para los otros campos, aplica la búsqueda normal
                        $builder->orLike($fields[$k], $get['search']['value']);
                    }
                    
                }
            }
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS filtered");
        $filteredQuery = $builder->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $builder->select('IDReposicion,
            TotalTrabajador,
            TotalCuotas,
            Observacion,
            Cobrado,
            FechaCobro,
            MontoCobro,
            ObservacionCobro,
            MesFacturacion,
            AnioFacturacion,
            IDUsuarioAdjudicado,
            NombresAdjudicado,
            ApellidosAdjudicado,
            MatriculaAdjudicado,
            TokenReposicion,
            TipoElemento,
            IDElemento,
            IDAsignacion,
            TokenAsignacion,
            TipoEquipo,
            Marca,
            Modelo,
            Serie');
           
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if(isset($get['MesDescuento']) && !empty($get['MesDescuento']))
        {
            $builder->where('MesFacturacion', $get['MesDescuento']);
        }
        
        if(isset($get['AnioDescuento']) && !empty($get['AnioDescuento']))
        {
            $builder->where('AnioFacturacion', $get['AnioDescuento']);
        }
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                // Si la columna es la 2 o la 4 (que son CONCAT)
                if ($k == 2) 
                {
                    $builder->orLike("CONCAT(NombresAdjudicado, ' ', ApellidosAdjudicado)", $get['search']['value']);
                } 
                else if ($k == 4) 
                {
                    $builder->orLike("CONCAT(TipoEquipo, ' ', Marca, ' ', Modelo)", $get['search']['value']);
                } 
                else 
                {
                    if(array_key_exists($k, $fields))
                    {
                        // Para los otros campos, aplica la búsqueda normal
                        $builder->orLike($fields[$k], $get['search']['value']);
                    }
                    
                }
            }
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) 
        {
            // Si la columna es la 2 o la 4 (que son CONCAT), ordena por la expresión CONCAT
            if ($order['column'] == 2) 
            {
                $builder->orderBy("CONCAT(NombresAdjudicado, ' ', ApellidosAdjudicado)", $order['dir']);
            } 
            else if ($order['column'] == 4) 
            {
                $builder->orderBy("CONCAT(TipoEquipo, ' ', Marca, ' ', Modelo)", $order['dir']);
            } 
            else 
            {
                if(array_key_exists($order['column'], $fields))
                {
                    $field = $fields[$order['column']];
                    
                    // Para las otras columnas, aplica el orden normal
                    $builder->orderBy($field, $order['dir']);
                }
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        $builder->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $builder->get()->getResultArray();
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }
    
    public function obtenerInformacionDescuentoReposicion($array)
    {
        $builder = $this->db->table('vista_listar_descuentos_reposiciones');
        
        if(!empty($array))
        {
            if(isset($array['MesFacturacion']) && !empty($array['MesFacturacion']))
            {
                $builder->where('MesFacturacion', $array['MesFacturacion']);
            }
            
            if(isset($array['AnioFacturacion']) && !empty($array['AnioFacturacion']))
            {
                $builder->where('AnioFacturacion', $array['AnioFacturacion']);
            }
            
            if(isset($array['Cobrado']) && !empty($array['Cobrado']))
            {
                $builder->where('Cobrado', $array['Cobrado']);
            }
        }
        
        $sql = $builder->getCompiledSelect();
        
        if(isset($array["return"]) && $array['return'] == 'row')
        {
            $datos = $this->db->query($sql)->getRowArray();
        }
        else
        {
            $datos = $this->db->query($sql)->getResultArray();
        }
        
        return $datos;
    }
    
    public function listadoDetalleActaReposicion($array)
    {
        $builder = $this->db->table('vista_detalle_acta_reposicion');
        
        if(!empty($array))
        {
            if(isset($array["IDReposicion"]) && $array['IDReposicion'] != "" && $array['IDReposicion'] != NULL)
            {
                $builder->where('IDReposicion', $array['IDReposicion']);
            }
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
    
    // public function listarDetalleReposicion($idReposicion)
    // {
    //     $this->select('reposiciones_detalle.IDDetalleReposicion,
    //         reposiciones_detalle.IDReposicion,
    //         reposiciones_detalle.TotalDescuento,
    //         reposiciones_detalle.TotalVerisure,
    //         reposiciones_detalle.TotalTrabajador,
    //         reposiciones_detalle.Observacion,
    //         asignaciones_detalle.IDDetalleAsignacion,
    //         asignaciones_detalle.TipoElemento,
    //         asignaciones_detalle.IDElemento');
    //     $this->join('asignaciones_detalle', 'reposiciones_detalle.IDDetalleAsignacion = asignaciones_detalle.IDDetalleAsignacion','left');
    //     $this->where('reposiciones_detalle.IDReposicion', $idReposicion);
        
    //     $datos = $this->findAll();
    //     return $datos;
    // }

}