<?php

namespace App\Libraries;
use \App\Libraries\Error;
use \App\Libraries\Alertas;

class Veriactivos 
{
    function perfilesAutorizadosArea()
    {
        return array(
            "URES" => array(1, 5),
            "IT" => array(1, 2)
        );
    }
    
    function motivosDevolucion()
    {
        return array(
            "DEV" => "DEVOLUCIÓN OK",
            "FVU" => "BAJA POR FIN DE VIDA ÚTIL",
            "INO" => "INOPERATIVO",
            "ROB" => "ROBO",
            "PER" => "PÉRDIDA",
            "NOD" => "NO DEVOLUCIÓN",
            "FAL" => "FALLA",
            "REN" => "RENOVACIÓN",
            "UNI" => "USUARIO NO INGRESÓ",
            "INC" => "KIT INCOMPLETO"
        );
    }
    
    function listadoTiposInforme()
    {
        return array(
            "DEVACT" => array(
                "ASUNTO_SINGULAR" => "Informe de remisión y evaluación de activo.",
                "TEXTO_SINGULAR" => "Este informe se emite con el fin de brindar información del activo al momento de la recepción en la oficina de IT.",
                "ASUNTO_PLURAL" => "Informe de remisión y evaluación de activos.",
                "TEXTO_PLURAL" => "Este informe se emite con el fin de brindar información de los activos al momento de la recepción en la oficina de IT."
            )
        );
    }
    
    function estadosSolicitud() {
        return array(
            'CREA' => array(
                "PASADO"    => "CREADO",
                "FUTURO"    => "CREAR",
                "FONDO"     => "bg-crea",
                "COLOR"     => "color-crea",
                "ICONO"     => "mdi mdi-creation"
            ),
            'RECI' => array(
                "PASADO"    => "RECIBIDO",
                "FUTURO"    => "RECIBIR",
                "FONDO"     => "bg-asig",
                "COLOR"     => "color-asig",
                "ICONO"     => "mdi mdi-book-arrow-left"
            ),
            'INIC' => array(
                "PASADO"    => "INICIADO",
                "FUTURO"    => "INICIAR",
                "FONDO"     => "bg-inic",
                "COLOR"     => "color-inic",
                "ICONO"     => "mdi mdi-play-circle"
            ),
            'COMP' => array(
                "PASADO"    => "COMPLETADO",
                "FUTURO"    => "COMPLETAR",
                "FONDO"     => "bg-comp",
                "COLOR"     => "color-comp",
                "ICONO"     => "mdi mdi-stop-circle"
            ),
            // 'ASIG' => array(
            //     "PASADO"    => "ASIGNADO",
            //     "FUTURO"    => "ASIGNAR",
            //     "FONDO"     => "bg-asig",
            //     "COLOR"     => "color-asig",
            //     "ICONO"     => "mdi mdi-account-search"
            // ),
            // 'ESPE' => array(
            //     "PASADO"    => "EN ESPERA",
            //     "FUTURO"    => "EN ESPERA",
            //     "FONDO"     => "bg-espe",
            //     "COLOR"     => "color-espe",
            //     "ICONO"     => "mdi mdi-pause-circle"
            // ),
            // 'DERI' => array(
            //     "PASADO"    => "DERIVADO",
            //     "FUTURO"    => "DERIVAR",
            //     "FONDO"     => "bg-deri",
            //     "COLOR"     => "color-deri",
            //     "ICONO"     => "mdi mdi-share-circle"
            // ),
            // 'APRO' => array(
            //     "PASADO"    => "APROBADO",
            //     "FUTURO"    => "APROBAR",
            //     "FONDO"     => "bg-apro",
            //     "COLOR"     => "color-apro",
            //     "ICONO"     => "mdi mdi-check-circle"
            // ),
            // 'REEV' => array(
            //     "PASADO"    => "REEVALUADO",
            //     "FUTURO"    => "REEVALUAR",
            //     "FONDO"     => "bg-reev",
            //     "COLOR"     => "color-reev",
            //     "ICONO"     => "mdi mdi-replay"
            // ),
            // 'AA' => array(
            //     "PASADO"    => "APROBADO AUTOMÁTICO",
            //     "FUTURO"    => "APROBAR AUTOMÁTICAMENTE",
            //     "FONDO"     => "bg-aa",
            //     "COLOR"     => "color-aa",
            //     "ICONO"     => "mdi mdi-check-circle"
            // ),
            // 'CANC' => array(
            //     "PASADO"    => "CANCELADO",
            //     "FUTURO"    => "CANCELAR",
            //     "FONDO"     => "bg-canc",
            //     "COLOR"     => "color-canc",
            //     "ICONO"     => "mdi mdi-cancel"
            // ),
            // 'COME' => array(
            //     "PASADO"    => "COMENTARIO",
            //     "FUTURO"    => "COMENTAR",
            //     "FONDO"     => "bg-come",
            //     "COLOR"     => "color-come",
            //     "ICONO"     => "mdi mdi-comment"
            // )
        );
    }    

    function permanenciaContrato() 
    {
        return array(
            'SP' => "SIN PERMANENCIA",
            '12' => "12 MESES",
            '15' => "15 MESES",
            '18' => "18 MESES"
        );
    }
    
    public function obtenerDescripcionTiempoTranscurridoContrato($array)
    {
        $html = '';
        
        if($array['Permanencia'] == 'Y')
		{
			$mesesPermanencia = $array['PeriodoPermanencia'];
			if(is_numeric($mesesPermanencia))
			{
				$inicioContrato = new \DateTime($array['InicioContrato']);

				$finContrato = new \DateTime($array['InicioContrato']);
				$finContrato->add(new \DateInterval('P'.$mesesPermanencia.'M'));

				$fechaActual = new \DateTime();
				$fechaActual->setTime(0,0,0);
				
				if($fechaActual <= $finContrato && $fechaActual >= $inicioContrato)
				{
					$interval=$fechaActual->diff($inicioContrato);
					# obtenemos la diferencia en meses
					$intervalMeses=$interval->format("%m");
					# obtenemos la diferencia en años y la multiplicamos por 12 para tener los meses
					$intervalAnos = $interval->format("%y")*12;

					$transcurrido = $intervalAnos + $intervalMeses;
					$restante = $mesesPermanencia - $transcurrido;
					$html .= $transcurrido.' M | '.$restante.' M | '.$array['PeriodoPermanencia'];
				}
				else
				{
					$html .= '<span class="badge bg-warning border-0">SIN PERMANENCIA</span>';
				}

			}
			else
			{
			    $html .= '<span class="badge bg-warning border-0">SIN PERMANENCIA</span>';
			}
		}
		else
		{
    		$html .= '<span class="badge bg-warning border-0">SIN PERMANENCIA</span>';
		}
		
		return $html;
    }
    
    public function rangoDescuentosMoviles($montoEvaluar)
    {
        if($montoEvaluar <= 250)
        {
            $cuota = 1;
        }
        else if($montoEvaluar > 250 && $montoEvaluar <= 600)
        {
            $cuota = 2;
        }
        else if($montoEvaluar > 600 && $montoEvaluar <= 990)
        {
            $cuota = 3;
        }
        else if($montoEvaluar > 990 && $montoEvaluar <= 2200)
        {
            $cuota = 5;
        }
        else if($montoEvaluar > 2200 && $montoEvaluar <= 4050)
        {
            $cuota = 6;
        }
        else
        {
            $cuota = 8;
        }
        return $cuota;
    }

    public function calculoPenalidadMovil($array)
    {
        //Si contrato no tiene permanencia, solo se le cobra el equipo (Precio Lista)
        if((isset($array['Permanencia']) && $array['Permanencia']=='N') || !isset($array['Permanencia']))
        {
            return $array['PrecioCompra'];
        }
        else
        {
            //Si el contrato tiene permanencia, se va a evaluar que tipo de contrato es por el valor de cuota de equipo
            if($array['MontoCuota'] !== '0,00' && $array['MontoCuota'] !== '0.00')
            {
                //Declaramos fecha actual para calculo de ultima facturación
                $hoy = date("Y-m-d");

                //Obtenemos la fecha de facturación dada por el operador, la cantidad de cuotas del equipo y el monto de la cuota.
                $facturacion = ($array['DiaFacturacion'] < 10 && strlen($array['DiaFacturacion']) == 1 ? '0'.$array['DiaFacturacion'] : $array['DiaFacturacion']);
                $cuotas = $array['PeriodoPermanencia'];
                $montoCuotas = $array['MontoCuota'];
                //Asignamos la primera fecha de facturación evaluando la fecha de compra. 
                //Si la fecha de compra fue antes de la fecha de facturación, aplica ese mes como inicio
                //Si la fecha de compra fue despues de la fecha de facturación, aplica para el siguiente mes como inicio 
                $inicioTime = strtotime($array['InicioContrato']) ;
                $diaInicioContrato = date("d", $inicioTime);
                //$inicio = date("Y-m-d", $inicioTime);
                //$inicioFact = date('Y-m-'.$facturacion, $inicioTime);

                if($diaInicioContrato < $facturacion)
                {
                    $primeraFacturacion = date("Y-m-".$facturacion, $inicioTime);
                }
                else
                {
                    $primeraFacturacion = date("Y-m-".$facturacion, strtotime('+1 month', $inicioTime));
                }
                
                //Si la primera facturación es posterior a la fecha actual
                if(strtotime($primeraFacturacion) > strtotime($hoy))
                {
                    $mesesFacturacion = 0;
                }
                else
                {
                    //Asignamos la última fecha de facturación evaluando la fecha actual
                    //Si el día actual es menor al día de facturación, la última facturación es el mes pasado.
                    //Si el día actual es mayor o igual al día de facturación, la última facturación es el mes actual.
    
                    $diaFinActual = date("d");
                    $ultimo = date("Y-m-".$facturacion);
                    $ultimoTime = strtotime($ultimo);
    
                    if($diaFinActual < $facturacion)
                    {
                        $ultimaFacturacion = date("Y-m-".$facturacion, strtotime('-1 month', $ultimoTime));
                    }
                    else
                    {
                        $ultimaFacturacion = $ultimo;
                    }
    
                    //Se vuelven DateTime la primera facturación y la última facturación para calcular la cantidad de meses transcurridos
                    $dtI=new \DateTime($primeraFacturacion);
                    $dtU=new \DateTime($ultimaFacturacion);
    
                    $interval=$dtU->diff($dtI);
                    # obtenemos la diferencia en meses
                    $intervalMeses=$interval->format("%m");
                    # obtenemos la diferencia en años y la multiplicamos por 12 para tener los meses
                    $intervalAnos = $interval->format("%y")*12;
    
                    //A la cantidad de meses calculados, le sumamos 1 ya se que evalua puntos de corte y no periodos.
                    $mesesFacturacion = $intervalMeses + $intervalAnos + 1;
                }
                
                //Calculamos el monto total de penalidad restando el (total de cuotas - meses facturación)*monto cuota
                //Sumandole el precio de lista del equipo.
                return number_format(round((($cuotas - $mesesFacturacion)*$montoCuotas)+$array['PrecioCompra'], 2), 2, '.', '');
                // return $primeraFacturacion;
            }
            else
            {
                $precioLista = $array['PrecioLista'];
                $precioVenta = $array['PrecioCompra'];
                $totalDias = $array['PeriodoPermanencia']*30;

                $inicio = date("Y-m-d", strtotime($array['InicioContrato']));
                $actual = date("Y-m-d");
                $dtI=new \DateTime($inicio);
                $dtA=new \DateTime($actual);

                $interval=$dtA->diff($dtI);
                $diasActivo = $interval->days;

                $montoPenalidad = (($precioLista - $precioVenta)/$totalDias)*($totalDias - $diasActivo);
                $redondeado = number_format(round($montoPenalidad, 2), 2, '.', '');
                return $redondeado+$precioLista;
            }
        }
        
    }
    
    public function calculoPorcentajeResponsabilidadMovil($cantidadRobo, $montoTotal, $situacion)
    {
        $montos = array();
        if($situacion != 'ROB')
        {
            $montos['TRABAJADOR'] = $montoTotal;
            $montos['VERISURE'] = 0;
        }
        else
        {
            if($cantidadRobo === 0)
            {
                $montoTrabajador = number_format(round($montoTotal*0.20, 2), 2, '.', '');
                $montos['TRABAJADOR'] = $montoTrabajador;
                $montos['VERISURE'] = $montoTotal - $montoTrabajador;
            }
            else if($cantidadRobo === 1)
            {
                $montoTrabajador = number_format(round($montoTotal*0.40, 2), 2, '.', '');
                $montos['TRABAJADOR'] = $montoTrabajador;
                $montos['VERISURE'] = $montoTotal - $montoTrabajador;
            }
            else
            {
                $montos['TRABAJADOR'] = $montoTotal;
                $montos['VERISURE'] = 0;
            }
        }
        return $montos;
    }
    
    public function rangoDescuentosHardware($montoEvaluar)
    {
        if($montoEvaluar <= 250)
        {
            $cuota = 1;
        }
        else if($montoEvaluar > 250 && $montoEvaluar <= 600)
        {
            $cuota = 2;
        }
        else if($montoEvaluar > 600 && $montoEvaluar <= 990)
        {
            $cuota = 3;
        }
        else if($montoEvaluar > 990 && $montoEvaluar <= 2200)
        {
            $cuota = 5;
        }
        else if($montoEvaluar > 2200 && $montoEvaluar <= 4050)
        {
            $cuota = 6;
        }
        else
        {
            $cuota = 8;
        }
        return $cuota;
    }

    public function calculoPorcentajeResponsabilidadHardware($cantidadRobo, $montoTotal, $situacion)
    {
        $montos = array();
        if($situacion != 'ROB')
        {
            $montos['TRABAJADOR'] = $montoTotal;
            $montos['VERISURE'] = 0;
        }
        else
        {
            if($cantidadRobo === 0)
            {
                $montoTrabajador = number_format(round($montoTotal*0.50, 2), 2, '.', '');
                $montos['TRABAJADOR'] = $montoTrabajador;
                $montos['VERISURE'] = $montoTotal - $montoTrabajador;
            }
            else
            {
                $montos['TRABAJADOR'] = $montoTotal;
                $montos['VERISURE'] = 0;
            }
        }
        return $montos;
    }

    public function rangoDescuentosKitDemo($montoEvaluar)
    {
        if($montoEvaluar <= 250)
        {
            $cuota = 1;
        }
        else if($montoEvaluar > 250 && $montoEvaluar <= 600)
        {
            $cuota = 2;
        }
        else if($montoEvaluar > 600 && $montoEvaluar <= 990)
        {
            $cuota = 3;
        }
        else if($montoEvaluar > 990 && $montoEvaluar <= 2200)
        {
            $cuota = 5;
        }
        else if($montoEvaluar > 2200 && $montoEvaluar <= 4050)
        {
            $cuota = 6;
        }
        else
        {
            $cuota = 8;
        }
        return $cuota;
    }

    public function calculoPorcentajeResponsabilidadKitDemo($cantidadRobo, $montoTotal, $situacion)
    {
        $montos = array();
        if($situacion != 'ROB')
        {
            $montos['TRABAJADOR'] = $montoTotal;
            $montos['VERISURE'] = 0;
        }
        else
        {
            if($cantidadRobo == 0)
            {
                $montoTrabajador = 0;
                $montos['TRABAJADOR'] = 0;
                $montos['VERISURE'] = $montoTotal;
            }
            else if($cantidadRobo == 1)
            {
                $montoTrabajador = number_format(round($montoTotal*0.50, 2), 2, '.', '');
                $montos['TRABAJADOR'] = $montoTrabajador;
                $montos['VERISURE'] = $montoTotal - $montoTrabajador;
            }
            else
            {
                $montos['TRABAJADOR'] = $montoTotal;
                $montos['VERISURE'] = 0;
            }
        }
        return $montos;
    }

    public function validarUpgradePlan($planOrigen, $planCambio)
    {
        $mensaje = '';
        $operadorOrigen = $planOrigen['IDOperador'];
        $operadorCambio = $planCambio['IDOperador'];
        
        if($operadorOrigen != $operadorCambio)
        {
            $mensaje = "Si va a cambiar de operador, debe generar un nuevo contrato.";
        }
        else
        {
            $precioOrigen = $planOrigen['PrecioPlan'];
            $precioCambio = $planCambio['PrecioPlan'];
            
            if($precioCambio < $precioOrigen)
            {
                $mensaje = "No se puede cambiar a un plan de menor valor que el contratado.<br>Deberá generar un nuevo contrato.<br>Costo mínimo del plan: S/ ".$precioOrigen;
            }
        }
        
        return $mensaje;
    }
    
    public function calculoReposicionHardware($informacionHardware, $arrayDivisas)
    {
        $monedaCompra = isset($informacionHardware['MonedaCompra']) ? $informacionHardware['MonedaCompra'] : (isset($informacionHardware['MonedaElemento']) ? $informacionHardware['MonedaElemento'] : "PEN");
        $precioCompra = isset($informacionHardware['PrecioCompra']) ? $informacionHardware['PrecioCompra'] : (isset($informacionHardware['PrecioCompraElemento']) ? $informacionHardware['PrecioCompraElemento'] : "1");
        $fechaCompra = isset($informacionHardware['FechaCompra']) ? $informacionHardware['FechaCompra'] : (isset($informacionHardware['FechaCompraElemento']) && $informacionHardware['FechaCompraElemento'] != "SIN INFORMACIÓN" && $informacionHardware['FechaCompraElemento'] != "0000-00-00" ? $informacionHardware['FechaCompraElemento'] : date("Y-m-d") );
        
        if($monedaCompra != "PEN")
        {
            // Crear un array asociativo para acceder fácilmente a cada MONEDA por su nomenclatura
            $simbolosMonedas = [];
            $cambioMonedas = [];
            
            foreach ($arrayDivisas as $moneda) {
                $simbolosMonedas[$moneda['CodigoInternacional']] = $moneda['Simbolo'] ;
                $cambioMonedas[$moneda['CodigoInternacional']] = $moneda['ValorCambio'] ;
            }
            
            $montoReposicion = number_format(round($precioCompra * $cambioMonedas[$monedaCompra], 2), 2, '.', '');
        }
        else
        {
            $montoReposicion = $precioCompra;
        }
        
        $depreciacionAnual = 0.25;
        
        $diaActual      = date("Y-m-d");
        
        $fechaCompraObj = new \DateTime($fechaCompra);
        $diaActualObj   = new \DateTime($diaActual);
        
        // Calcular la diferencia
        $diferencia = $fechaCompraObj->diff($diaActualObj);
        
        // Obtener solo la diferencia en años completos
        $aniosDepreciacion = $diferencia->y;
        
        //Si está dentro del primer año de compra, el costo de reposición es el precio de compra
        if($aniosDepreciacion > 0)
        {
            for($i = 0; $i < $aniosDepreciacion ; $i++)
            {
                $montoReposicion = $montoReposicion - ($montoReposicion * $depreciacionAnual);
            }
        }
        
        return number_format(round($montoReposicion, 2), 2, '.', '');
        
    }
    
    public function calculoPorcentajeResponsabilidadEquiposInformaticos($cantidadRobo, $montoTotal, $situacion, $cargo)
    {
        $montos = array();
        
        if($situacion != 'ROB')
        {
            $montos['TRABAJADOR'] = $montoTotal;
            $montos['VERISURE'] = 0;
        }
        else
        {
            if (stripos($cargo, "practicante") !== false) 
            {
                if($cantidadRobo === 0)
                {
                    $montos['TRABAJADOR'] = 0;
                    $montos['VERISURE'] = $montoTotal;
                }
                else if($cantidadRobo === 1)
                {
                    $montoTrabajador = number_format(round($montoTotal*0.20, 2), 2, '.', '');
                    $montos['TRABAJADOR'] = $montoTrabajador;
                    $montos['VERISURE'] = $montoTotal - $montoTrabajador;
                }
                else if($cantidadRobo === 2)
                {
                    $montoTrabajador = number_format(round($montoTotal*0.40, 2), 2, '.', '');
                    $montos['TRABAJADOR'] = $montoTrabajador;
                    $montos['VERISURE'] = $montoTotal - $montoTrabajador;
                }
                else
                {
                    $montos['TRABAJADOR'] = $montoTotal;
                    $montos['VERISURE'] = 0;
                }
            } 
            else 
            {
                if($cantidadRobo === 0)
                {
                    $montoTrabajador = number_format(round($montoTotal*0.20, 2), 2, '.', '');
                    $montos['TRABAJADOR'] = $montoTrabajador;
                    $montos['VERISURE'] = $montoTotal - $montoTrabajador;
                }
                else if($cantidadRobo === 1)
                {
                    $montoTrabajador = number_format(round($montoTotal*0.40, 2), 2, '.', '');
                    $montos['TRABAJADOR'] = $montoTrabajador;
                    $montos['VERISURE'] = $montoTotal - $montoTrabajador;
                }
                else
                {
                    $montos['TRABAJADOR'] = $montoTotal;
                    $montos['VERISURE'] = 0;
                }
            }
        }
        
        return $montos;
        
    }

    public function cuotasDescuentoEquiposInformaticos($montoEvaluar)
    {
        if($montoEvaluar <= 250)
        {
            $cuota = 1;
        }
        else if($montoEvaluar > 250 && $montoEvaluar <= 600)
        {
            $cuota = 2;
        }
        else if($montoEvaluar > 600 && $montoEvaluar <= 990)
        {
            $cuota = 3;
        }
        else if($montoEvaluar > 990 && $montoEvaluar <= 2200)
        {
            $cuota = 5;
        }
        else if($montoEvaluar > 2200 && $montoEvaluar <= 4050)
        {
            $cuota = 6;
        }
        else
        {
            $cuota = 8;
        }
        return $cuota;
    }

}
