<?php

namespace App\Libraries;
use \App\Libraries\Error;
use \App\Libraries\Alertas;

class Globales 
{
    function estadosLinea() 
    {
        return array(
            'ACT' => "ACTIVO",
            'SUS' => "SUSPENDIDA",
            'BAJ' => "BAJA"
        );
    }    

    function motivoEstadoLinea($estadoLinea) 
    {
        switch ($estadoLinea) {
            case 'ACT':
                return array(
                    "NUE" => "NUEVO",
                    "REP" => "REPOSICIÓN",
                    "ASI" => "ASIGNADO",
                    "TRA" => "TRASPASO",
                    "DEV" => "DEVOLUCIÓN OK"
                );
                break;
            case 'SUS':
                return array(
                    "ROB" => "ROBO",
                    "PER" => "PÉRDIDA",
                    "BAC" => "BACKUP",
                    "FVU" => "FIN DE VIDA ÚTIL",
                    "SUS" => "SUSPENDIDA"
                );
                break;
            case 'BAJ':
                return array(
                    "DEP" => "DEPURACIÓN",
                    "TRA" => "TRASPASO",
                    "FVU" => "FIN DE VIDA ÚTIL"
                );
                break;
            default:
                return array();
                break;
        }
    }    

    function estadosMovil() {
        return array(
            'ACT' => "ACTIVO",
            'AVE' => "AVERIADO",
            'REP' => "REPARACIÓN",
            'BAJ' => "BAJA"
        );
    }    

    function motivoEstadoMovil($estadoMovil) {

        switch ($estadoMovil) {
            case 'ACT':
                return array(
                    "NUE" => "NUEVO",
                    "OPE" => "OPERATIVO",
                    "ASI" => "ASIGNADO",
                    "STO" => "STOCK",
                    "REP" => "REPARADO",
                    "DEV" => "DEVOLUCIÓN OK"
                );
                break;
            case 'AVE':
                return array(
                    "FF" => "FALLA DE FÁBRICA",
                    "FT" => "FALLA TÉCNICA",
                    "FAL" => "FALLA"
                );
                break;
            case 'REP':
                return array(
                    "GAR" => "GARANTÍA (OPERADOR)",
                    "EXT" => "CENTRO EXTERNO"
                );
                break;
            case 'BAJ':
                return array(
                    "INO" => "INOPERATIVO",
                    "ROB" => "ROBO",
                    "PER" => "PÉRDIDA",
                    "NOD" => "NO DEVOLUCIÓN",
                    "FVU" => "FIN DE VIDA ÚTIL"
                );
                break;
            default:
                return array(
                    "NUE" => "NUEVO",
                    "OPE" => "OPERATIVO",
                    "ASI" => "ASIGNADO",
                    "STO" => "STOCK",
                    "DEV" => "DEVOLUCIÓN OK",
                    "FVU" => "BAJA POR FIN DE VIDA ÚTIL",
                    "FF" => "FALLA DE FÁBRICA",
                    "FT" => "FALLA TÉCNICA",
                    "GAR" => "GARANTÍA (OPERADOR)",
                    "EXT" => "CENTRO EXTERNO",
                    "INO" => "INOPERATIVO",
                    "ROB" => "ROBO",
                    "PER" => "PÉRDIDA",
                    "NOD" => "NO DEVOLUCIÓN",
                    "FAL" => "FALLA"
                );
                break;
        }
    }    

    function estadosDispositivos() {
        return array(
            'ACT' => "ACTIVO",
            'AVE' => "AVERIADO",
            'REP' => "REPARACIÓN",
            'BAJ' => "BAJA"
        );
    }    

    function motivoEstadoDispositivos($estadoDispositivo) {

        switch ($estadoDispositivo) {
            case 'ACT':
                return array(
                    "NUE" => "NUEVO",
                    "OPE" => "OPERATIVO",
                    "ASI" => "ASIGNADO",
                    "STO" => "STOCK",
                    "DEV" => "DEVOLUCIÓN OK",
                    "UNI" => "USUARIO NO INGRESÓ",
                    ""  => "NO DEFINIDO"
                );
                break;
            case 'AVE':
                return array(
                    "FF" => "FALLA DE FÁBRICA",
                    "FT" => "FALLA TÉCNICA",
                    "FAL" => "FALLA",
                    ""  => "NO DEFINIDO"
                );
                break;
            case 'REP':
                return array(
                    "GAR" => "GARANTÍA (OPERADOR)",
                    "EXT" => "CENTRO EXTERNO",
                    ""  => "NO DEFINIDO"
                );
                break;
            case 'BAJ':
                return array(
                    "INO" => "INOPERATIVO",
                    "ROB" => "ROBO",
                    "PER" => "PÉRDIDA",
                    "NOD" => "NO DEVOLUCIÓN",
                    "FVU" => "FIN DE VIDA ÚTIL",
                    ""  => "NO DEFINIDO"
                );
                break;
            default:
                return array(
                    "NUE" => "NUEVO",
                    "OPE" => "OPERATIVO",
                    "ASI" => "ASIGNADO",
                    "STO" => "STOCK",
                    "DEV" => "DEVOLUCIÓN OK",
                    "FVU" => "BAJA POR FIN DE VIDA ÚTIL",
                    "FF" => "FALLA DE FÁBRICA",
                    "FT" => "FALLA TÉCNICA",
                    "GAR" => "GARANTÍA (OPERADOR)",
                    "EXT" => "CENTRO EXTERNO",
                    "INO" => "INOPERATIVO",
                    "ROB" => "ROBO",
                    "PER" => "PÉRDIDA",
                    "NOD" => "NO DEVOLUCIÓN",
                    "FAL" => "FALLA",
                    "UNI" => "USUARIO NO INGRESÓ",
                    ""  => "NO DEFINIDO"
                );
                break;
        }
    }    

    public function urlExternos()
    {
        return array(
            'verPDFActaAsignacion',
            'acta-asignacion',
            'subir-firma-acta-asignacion',
            'verPDFActaDevolucion',
            'acta-devolucion',
            'subir-firma-acta-devolucion',
            'verPDFActaReposicion',
            'acta-reposicion',
            'subir-firma-acta-reposicion'
        );
    }
    
    public function urlLibres()
    {
        $libres = array(
            'descargatxt',
            'test-controller',
            'cambiar-password',
            'cantidad-notificaciones-header', 
            'registrar-vista-notificacion', 
            'cargar-notificaciones-header',
            'listado-direccion',
            'listado-region-pais', 
            'listado-region-departamentos', 
            'listado-region-provincias', 
            'listado-region-distritos', 
            'listado-monedas', 
            'listado-tipos-documento',
            'listado-tipos-documento-sunat',
            'listado-direccion-busqueda',
            'listado-direccion-estructura',
            'listado-area-estructura',
            'listado-subarea-estructura',
            'listado-delegacion-estructura',
            'listado-cc-delegacion-estructura',
            'listado-estructura-delegacion',
            'listado-usuarios',
            'obtener-datos-usuario',
            'exportar-estructura-departamental',
            'historico-asignaciones-moviles',
            'marcas-serverside',
            'dispositivos-serverside',
            'operadores-serverside',
            'planes-serverside',
            'categorias-serverside',
            'tipos-categoria-serverside',
            'subtipos-categoria-serverside',
            'elementos-demo-serverside',
            'elementos-trabajo-serverside',
            'moviles-serverside',
            'lineas-serverside',
            'historico-asignaciones-lineas',
            'contratos-linea-serverside',
            'hardware-serverside',
            'historico-asignaciones-hardware',
            'tarjetas-acceso-serverside',
            'historico-asignaciones-tarjeta-acceso',
            'accesorios-it-serverside',
            'listado-accesorios-it',
            'asignaciones-serverside',
            'devoluciones-serverside',
            'elementos-devolucion',
            'obtener-elemento-a-devolver',
            'reposiciones-serverside',
            'descuentos-serverside',
            'legales-serverside',
            'solicitud-reposicion-serverside',
            'kit-demo-serverside',
            'reporte-asignaciones-serverside',
            'recargar-detalle-elementos-devolucion',
            'validacion-activos-devolucion',
            'registro-validacion-activos-devolucion',
            'informes-devolucion-serverside',
            'verPDFInformeDevolucion',
            'grafica-asignacion-pendiente-firma-creacion',
            'recargar-detalle-asignacion-pendiente-firma-creacion',
            'grafica-detalle-asignacion-pendiente-firma-creacion',
            'grafica-asignacion-pendiente-firma-activo',
            'recargar-detalle-asignacion-pendiente-firma-activo',
            'grafica-detalle-asignacion-pendiente-firma-activo',
            'grafica-pendientes-validar',
            'recargar-detalle-pendientes-validacion',
            'mostrar-elementos-excepcion-reposicion',
            'registro-excepcion-reposicion'
            );
            
        return array_merge($libres, $this->urlExternos());
    }
    
    function iconosExtension() {
        return array(
            'xlsx' => "mdi mdi-file-excel",
            'xls' => "mdi mdi-file-excel",
            'csv' => "mdi mdi-file-delimited",
            'jpeg' => "mdi mdi-file-image-outline",
            'jpg' => "mdi mdi-file-image-outline",
            'png' => "mdi mdi-file-image-outline",
            'pdf' => "mdi mdi-file-pdf-box",
            'docx' => "mdi mdi-file-word-outline",
            'doc' => "mdi mdi-file-word-outline"
        );
    }    
    
    function extensionesImagen()
    {
        return array(
            'jpg', 
            'jpeg',
            'png',
            'bmp',
            'webp'
        );
    }
}
