<?php

namespace App\Libraries;

class Alertas {
    
    public function alertaError($mensajeAlerta) {
        $texto = '';
        $texto .= "<script>";
        $texto .= "toastr['error']('$mensajeAlerta');";
        $texto .= "toastr.options = {";
        $texto .= "'closeButton': false,";
        $texto .= "'debug': false,";
        $texto .= "'newestOnTop': false,";
        $texto .= "'progressBar': true,";
        $texto .= "'positionClass': 'toast-bottom-right',";
        $texto .= "'preventDuplicates': false,";
        $texto .= "'onclick': null,";
        $texto .= "'showDuration': '500',";
        $texto .= "'hideDuration': '1000',";
        $texto .= "'timeOut': '10000',";
        $texto .= "'extendedTimeOut': '1000',";
        $texto .= "'showEasing': 'swing',";
        $texto .= "'hideEasing': 'linear',";
        $texto .= "'showMethod': 'fadeIn',";
        $texto .= "'hideMethod': 'fadeOut'";
        $texto .= "}</script>";
        return $texto;
    }

    public function alertaExito($mensajeAlerta) {
        $texto = '';
        $texto .= "<script>";
        $texto .= "toastr['success']('$mensajeAlerta');";
        $texto .= "toastr.options = {";
        $texto .= "'closeButton': false,";
        $texto .= "'debug': false,";
        $texto .= "'newestOnTop': false,";
        $texto .= "'progressBar': true,";
        $texto .= "'onclick': null,";
        $texto .= "'positionClass': 'toast-bottom-right',";
        $texto .= "'preventDuplicates': false,";
        $texto .= "'onclick': null,";
        $texto .= "'showDuration': '500',";
        $texto .= "'hideDuration': '1000',";
        $texto .= "'timeOut': '10000',";
        $texto .= "'extendedTimeOut': '1000',";
        $texto .= "'showEasing': 'swing',";
        $texto .= "'hideEasing': 'linear',";
        $texto .= "'showMethod': 'fadeIn',";
        $texto .= "'hideMethod': 'fadeOut'";
        $texto .= "}</script>";
        return $texto;
    }

    public function alertaPeligro($mensajeAlerta) {
        $texto = '';
        $texto .= "<script>";
        $texto .= "toastr['warning']('$mensajeAlerta');";
        $texto .= "toastr.options = {";
        $texto .= "'closeButton': false,";
        $texto .= "'debug': false,";
        $texto .= "'newestOnTop': false,";
        $texto .= "'progressBar': true,";
        $texto .= "'onclick': null,";
        $texto .= "'positionClass': 'toast-bottom-right',";
        $texto .= "'preventDuplicates': false,";
        $texto .= "'onclick': null,";
        $texto .= "'showDuration': '500',";
        $texto .= "'hideDuration': '1000',";
        $texto .= "'timeOut': '10000',";
        $texto .= "'extendedTimeOut': '1000',";
        $texto .= "'showEasing': 'swing',";
        $texto .= "'hideEasing': 'linear',";
        $texto .= "'showMethod': 'fadeIn',";
        $texto .= "'hideMethod': 'fadeOut'";
        $texto .= "}</script>";
        return $texto;
    }

    public function reDireccion($vinculoUrl, $tiempo = ''){
        $texto = '<script>';
        if($tiempo != ''){
            $obtienePeriodo = $tiempo * 1000;
            $texto .= 'setTimeout( function(){ location.href="'.$vinculoUrl.'"; }, '.$obtienePeriodo.' );';
        } else{
            $texto .= 'location.href="'.$vinculoUrl.'"';
        }
        $texto .= '</script>';
        return $texto;
    }

    public function reDireccionBlank($vinculoUrl, $tiempo = ''){
        $texto = '<script>';
        if($tiempo != ''){
            $obtienePeriodo = $tiempo * 1000;
            $texto .= 'setTimeout( function(){ location.href="'.$vinculoUrl.'"; }, '.$obtienePeriodo.' );';
        } else{
            $texto .= 'window.open("'.$vinculoUrl.'","_blank");';
        }
        $texto .= '</script>';
        return $texto;
    }    
    
    public function refrescar($tiempo = ''){
        $texto = '<script>';
        if($tiempo != ''){
            $obtienePeriodo = $tiempo * 1000;
            $texto .= 'setTimeout( function(){ parent.location.reload(); }, '.$obtienePeriodo.' );';
        } else{
            $texto .= 'parent.location.reload()';
        }
        $texto .= '</script>';
        return $texto;
    }
    
    public function tiempoPeriodo($tiempo){
        $obtienePeriodo = $tiempo * 1000;
        $texto = '<script>';
        $texto .= 'setTimeout( function(){ }, '.$obtienePeriodo.' );';
        $texto .= '</script>';
        return $texto;
        
    }
    
    public function alerta($mensajeAlerta){
        $texto = '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';
        $texto .= '<script>';
        $texto .= 'alert("'.$mensajeAlerta.'")';
        $texto .= '</script>';
        return $texto;
    }
    
    public function confirmar($mensajeAlerta, $opcion = array('yes' => '', 'no' => ''), $procesar = FALSE){
        $texto = '<meta charset="utf-8" />';
        $texto .= '<script>';
        $texto .= 'var choice = confirm("'.$mensajeAlerta.'"); ';
        $texto .= 'if(choice){ ';
        if($procesar === TRUE){
            $texto .= 'location.href="'.$opcion['yes'].'"; '; 
        }
        $texto .= '} else{ ';
        $texto .= 'location.href="'.$opcion['no'].'"; ';
        $texto .= '} ';
        $texto .= '</script>';
        return $texto;
    }

    public function descargaArchivoTXT($nombreArchivo) {
        $texto = '';
        $texto .= "<script>";
        //$texto .= "window.location.href = '".base_url()."/descargatxt/".$nombreArchivo."';";
        $texto .= "window.open('".base_url()."/descargatxt/".$nombreArchivo."','_blank')";
        $texto .= "</script>";
        return $texto;
    }

}
