<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

class Ures extends BaseController
{
	public function __construct(){
	    $this->usuarios = new \App\Models\UsuarioModel();
	    
        // $this->asignaciones = new \App\Models\AsignacionesModel();
        // $this->detalleasignaciones = new \App\Models\AsignacionesDetalleModel();
        
        $this->legales = new \App\Models\LegalesModel();
        
        /* CONFIGURACIÓN */
        $this->elementosDemo    = new \App\Models\Configuracion\ElementosDemoModel();
        $this->elementosTrabajo = new \App\Models\Configuracion\ElementosTrabajoModel();
        
        /* URES */
        $this->kitsDemo             = new \App\Models\URES\KitsDemoModel();
        $this->kitsTrabajo          = new \App\Models\URES\KitsTrabajoModel();
        $this->kitsTrabajoElementos = new \App\Models\URES\KitsTrabajoElementosModel();
        
        /* URES */
        $this->correoStatusAsignacion   = new \App\Models\Cargos\CorreoStatusAsignacionModel();
	}

	/**************************************************************************/
	
    /******************************** KIT DEMO ********************************/
    
	public function listarKitsDemo()
	{
    	if(isset($this->items['id']))
    	{
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Kits Demo | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Listado Kits Demo',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Listado Kits Demo",
				'subtitulo'                 => 'Kits Demo'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('ures/listar_kits_demo',$data);			
		} 
		else 
		{
			return view('errors/500');
		}	
	}

	public function kitDemoServerside()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR MÓVILES */
            $dataServerside = $this->kitsDemo->listaGeneralViewKitDemo($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
                if($value['Estado']=='ACT')
                {
                    $bg = "bg-success";
                }
                else if($value['Estado']=='BAJ')
                {
                    $bg = "bg-danger";
                }
                else
                {
                    $bg = "bg-warning";
                }
                
                $dataServerside["data"][$key]['EstadoElementoKitDemo'] = "<span class='badge ".$bg." border-0'>".($value['Estado'] == 'ACT' ? "ACTIVO" : ($value['Estado'] == 'BAJ' ? 'BAJA' : 'AVERIADO'))."</span>";
                
                if($value['IDAsignado'] != '' && $value['IDAsignado'] != null )
                {
                    $dataServerside["data"][$key]['NombreAsignado'] = ucwords(mb_strtolower($value['NombresAsignado'].' '.$value['ApellidosAsignado']));
                    $dataServerside["data"][$key]['UsuarioAsignado'] = '<span class="badge '.($value['EstadoAsignado'] == 'Activo' ? 'bg-light text-dark' : 'bg-danger color-white').' border-0">'.$value['UsuarioAsignado'].'</span>';
                
                    $fechaAsignado = ( ($value['FechaAsignado'] != '' && $value['FechaAsignado'] != null && $value['FechaAsignado'] != '0000-00-00' && $value['FechaAsignado'] != '1969-01-01') ? date("Y-m-d", strtotime($value['FechaAsignado'])) : date("Y-m-d", strtotime($value['FechaCreaAsignado'])));
                
                    $dataServerside["data"][$key]['FechaAsignado'] = $fechaAsignado;
                }
                else
                {
                    $dataServerside["data"][$key]['MatriculaAsignado'] = "No Asignado";
                    $dataServerside["data"][$key]['NombreAsignado'] = "No Asignado";
                    $dataServerside["data"][$key]['MatriculaAsignado'] = "No Asignado";
                    $dataServerside["data"][$key]['FechaAsignado'] = "No Asignado";
                    $dataServerside["data"][$key]['UsuarioAsignado'] = "No Asignado";
                }
                
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-item-demo" data-bs-target="#informacionItemDemo" data-form="#formInformacionItemDemo" data-id="'.$value['IDItemKitDemo'].'" data-accion="ver" id="ver-item-demo" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" title="Ver Item Kit Demo" aria-label="Ver Item Kit Demo">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDELK", $this->items['permisos']) || in_array("UPMOFU", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-item-demo" data-bs-target="#informacionItemDemo" data-form="#formInformacionItemDemo" data-id="'.$value['IDItemKitDemo'].'" data-accion="editar" id="editar-item-demo" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" title="Editar Item Kit Demo" aria-label="Editar Item Kit Demo">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
	}
	
	public function obtenerNuevoItemKitDemo()
	{
	    $idElementoDemo = $this->request->getPost('idElementoDemo');
	    
	    $listaElementosDemo = $this->elementosDemo->where("IDElementoDemo", $idElementoDemo)->findAll();
	    
	    $html = '';
	    
	    if(empty($listaElementosDemo))
	    {
	        $aleatorio = $this->complementos->generar_string_aleatorio(5);
    	        
	        $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="elementoskitdemo'.$aleatorio.'" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-10 col-10 ">
        	        <div class="alert alert-warning alert-border-left alert-dismissible fade show mb-xl-0" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN INFORMACIÓN</strong> - No hay elementos autorizados para un demo.
                    </div>
                </div>
        		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
        			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico(\'elementoskitdemo'.$aleatorio.'\');" data-tooltip="tooltip" aria-label="Eliminar Elemento">
                        <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
                    </button>
        		</div>
        	</div>';
	    }
	    else
	    {
    	    foreach($listaElementosDemo as $item)
    	    {
    	        $aleatorio = $this->complementos->generar_string_aleatorio(5);
    	        
    	        $html.='<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="elementoskitdemo'.$aleatorio.'" style="border-radius: 10px;">
    	            <input type="hidden" name="idelemento['.$aleatorio.']" value="'.$item['IDElementoDemo'].'">
            		<div class="col-xxl-8 col-md-12 col-12 mb-2">
            			<div>
            				<label class="form-label">Elemento:</label>
            				<input type="text" class="form-control" value="'.$item['Nombre'].'" disabled>
            			</div>
            		</div>
            		<div class="col-xxl-4 col-md-12 col-12 mb-2">
            			<div>
            				<label class="form-label">SKU:</label>
            				<input type="text" class="form-control" value="'.$item['SKU'].'" disabled>
            			</div>
            		</div>
            		
            		<div class="col-xxl-6 col-md-12 col-12 mb-2">
            			<div>
            				<label class="form-label">Serie:</label>
            				<input type="text" class="form-control" id="serieelemento'.$aleatorio.'" name="serieelemento['.$aleatorio.']" value="">
            			</div>
            		</div>
            		
            		<div class="col-xxl-6 col-md-12 col-12 mb-2">
            			<div>
            				<label class="form-label">Fecha Compra:</label>
            				<input type="date" class="form-control" id="fechacompraelemento'.$aleatorio.'" name="fechacompraelemento['.$aleatorio.']" value="'.date("Y-m-d").'">
            			</div>
            		</div>
            		
            		<div class="col-xxl-10 col-md-10 col-10 ">
            		    <div class="form-floating">
                            <textarea class="form-control" id="detalleelemento'.$aleatorio.'" name="detalleelemento['.$aleatorio.']" rows="3"></textarea>
                            <label for="detalleelemento'.$aleatorio.'">Detalle</label>
                        </div>
            		</div>
            		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
            			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico(\'elementoskitdemo'.$aleatorio.'\');" data-tooltip="tooltip" aria-label="Eliminar Elemento">
                            <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
                        </button>
            		</div>
            	</div>';
    	    }
	    }
	    
	    echo $html;
	}
		
    public function subirCSVKitsDemo()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("itemsFile");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'itemsFile' => [
                'mime_in[itemsFile,text/csv,text/plain]',
                'ext_in[itemsFile,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 11);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $codigoKit      = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $SKU            = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $serie          = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $detalle        = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $fechaCompra    = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $matricula      = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");

                //Validamos existencia de SKU:
                
                if($SKU == '' || $SKU == null)
                {
                    $filasError[$fila]['SKU'] = "EL CAMPO SKU ES NECESARIO";
                    $ejecutarInsert = false;
                }
                else
                {
                    $datosElemento = $this->elementosDemo->where("SKU",trim($SKU))->first();
                    if(empty($datosElemento))
                    {
                        $filasError[$fila]['SKU'] = "EL SKU INGRESADO NO EXISTE";
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos Existencia de Serie de elemento de Kit:
                
                if($serie != '' && $serie != null)
                {
                    $datoskit = $this->kitsDemo->where("Serie",trim($serie))->first();
                    if(!empty($datoskit))
                    {
                        $filasError[$fila]['SERIE'] = "LA SERIE YA SE ENCUENTRA REGISTRADA.";
                        $ejecutarInsert = false;
                    }
                }
                
                // //Validamos usuario correcto:
                if($matricula != '' && $matricula != null)
                {
                    $datosUsuario = $this->usuarios->buscarUsuarioXmatricula($matricula);
                    
                    if(empty($datosUsuario))
                    {
                        $filasError[$fila]['USUARIO'] = "MATRÍCULA NO VÁLIDA-".$matricula;
                        $ejecutarInsert = false;
                    }
                    else
                    {
                        if($datosUsuario['Cargo'] == '' || $datosUsuario['Cargo'] == null)
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE CARGO/PUESTO ACTUALIZADO: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['IDArea'] == '' || $datosUsuario['IDArea'] == null)
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE ÁREA DEPARTAMENTAL ACTUALIZADA: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['IDDireccion'] == '' || $datosUsuario['IDDireccion'] == null )
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE DIRECCIÓN DEPARTAMENTAL ACTUALIZADA: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['IDDelegacion'] == '' || $datosUsuario['IDDelegacion'] == null )
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE LA DELEGACIÓN ACTUALIZADA: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['Estado'] == 'Cesado' )
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO SE ENCUENTRA CESADO: ".$usuario;
                            $ejecutarInsert = false;
                        }
                    }
                }
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = $this->items['basePublic'].'/';
            $nombre = 'error.txt';
            $file = $this->items['basePublic'].'/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayAsig = array();
        $arrayDetalleAsig = array();
        
        $filainsert = 0;
        
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $filainsert++;
            if($filainsert > 1)
            {
                //Asignamos valores de CSV a variables locales
                $codigoKit      = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $SKU            = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $serie          = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $detalle        = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $fechaCompra    = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $matricula      = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                $tipoasignado   = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                $obsasignado    = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                $fechaasignado  = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
                $obselemento    = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
                $montoreposicion= trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
                
                if($fechaCompra != '' && $fechaCompra != null)
                {
                    $detectaFormatoFC = strpos($fechaCompra, "/");
                    
                    if($detectaFormatoFC === false)
                    {
                        $fechaCompra = date("Y-m-d", strtotime($fechaCompra));
                    }
                    else
                    {
                        // $fechaCompra = date_create_from_format('j/m/Y', $fechaCompra);
                        // $fechaCompra = date_format($fechaCompra, 'Y-m-d');
                        $fechaCompra_e = $this->complementos->myUrlEncode($fechaCompra);
                        $fechaCompra = date('Y-m-d', strtotime(str_replace('/', '-', $fechaCompra_e)));
                    }
                    
                }
                else
                {
                    $fechaCompra = NULL;
                }
                
                if($fechaasignado != '' && $fechaasignado != null)
                {
                    $detectaFormatoFA = strpos($fechaCompra, "/");
                    
                    if($detectaFormatoFA === false)
                    {
                        $fechaasignado = date("Y-m-d", strtotime($fechaasignado));
                    }
                    else
                    {
                        // $fechaasignado = date_create_from_format('m/j/Y', $fechaasignado);
                        // $fechaasignado = date_format($fechaasignado, 'Y-m-j');
                        $fechaasignado_e = $this->complementos->myUrlEncode($fechaasignado);
                        $fechaasignado = date('Y-m-d', strtotime(str_replace('/', '-', $fechaasignado_e)));
                    }
                    
                }
                else
                {
                    $fechaasignado = date("Y-m-d", strtotime($fechaActual));
                }
                
                //Obtenemos información relevante
                
                $datosElemento = $this->elementosDemo->where("SKU",trim($SKU))->first();
                
                //Armar array de Linea e insertar datos:
                $data = array (
                    'CodigoKitDemo'     => $codigoKit,
                    'IDElementoDemo'    => $datosElemento['IDElementoDemo'],
                    'Serie'             => $serie,
                    'Detalle'           => $detalle,
                    'FechaCompra'       => $fechaCompra,
                    'UsuarioCrea'       => $this->items['id'],
                    'FechaCrea'         => $fechaActual,  
                    'Localhost'         => $this->request->getIPAddress(),    
                    'UsuarioEstado'     => $this->items['id'],
                    'FechaEstado'       => $fechaActual,
                    'MotivoEstado'      => "Registro de Kit Demo masivo.",
                    'Estado'            => 'ACT'
                );

                $lastId = $this->kitsDemo->insert($data, TRUE);

        		if($lastId !== FALSE){
        			if($matricula != '' && $matricula != null)
        			{
                        if(!array_key_exists($matricula, $arrayAsig)) 
                        {
                            $arrayAsig[$matricula] = array(
                                "TIPO"          => $tipoasignado,
                                "OBSERVACION"   => $obsasignado,
                                "FECHA"         => $fechaasignado);
                        }
                        
                        $arrayDetalleAsig[$matricula][] = array(
                            "TIPOELEMENTO"  => "KITDEMO",
                            "ELEMENTO"      => $lastId,
                            "OBSERVACION"   => $obselemento,
                            "MONEDA"        => "PEN",
                            "REPOSICION"    => ($montoreposicion != '' && $montoreposicion != NULL ? $montoreposicion : $datosElemento['PrecioReposicion']));
                
        			}
        		}
                
            }
        }

        fclose($handleInsert);
    
        $arrayInsertAsign=array();
        
        $textoLegal = '';
        
        $infolegales = $this->legales->buscarLegalXactaXelementos("ASIGNACIÓN", array("KITDEMO"));
        
        if(!empty($infolegales))
        {
            foreach($infolegales as $key=>$value)
            {
                $textoLegal.=$value['Titulo'];
                $textoLegal.="\n";
                $textoLegal.=$value['Texto'];
                $textoLegal.="\n";
            }
        }
        
        foreach($arrayAsig as $usuario => $valor)
        {
            $datosAsignado = $this->usuarios->buscarUsuarioXmatricula($usuario);
            $tokenAsignacion = $this->complementos->generar_string_aleatorio(15);
    
            $dataAsignacion = array (
                'UsuarioAsignado'       => $datosAsignado['IdUsuario'], 
                'CargoAsignado'         => $datosAsignado['Cargo'], 
                'DireccionAsignado'     => $datosAsignado['IDDireccion'], 
                'AreaAsignado'          => $datosAsignado['IDArea'], 
                'SubareaAsignado'       => $datosAsignado['IDSubarea'], 
                'DelegacionAsignado'    => $datosAsignado['IDDelegacion'], 
                'FechaAsignado'         => $valor['FECHA'], 
                'TipoAsignado'          => $valor['TIPO'], 
                'Observacion'           => $valor['OBSERVACION'], 
                'UsuarioRemitente'      => $this->items['id'], 
                'CargoRemitente'        => $this->items['cargo'], 
                'DireccionRemitente'    => $this->items['dpto'], 
                'AreaRemitente'         => $this->items['idArea'], 
                'SubareaRemitente'      => $this->items['idSubarea'], 
                'DelegacionRemitente'   => $this->items['idDelegacionLog'], 
                'Legales'               => $textoLegal,
                'TokenLinkFirma'        => $tokenAsignacion,
                'LiberadoFirma'         => 'Y',
                'UsuarioCrea'           => $this->items['id'],
                'FechaCrea'             => $fechaActual,    
                'Localhost'             => $this->request->getIPAddress()
            );
    // var_dump($dataAsignacion);exit;
            $lastIdAsignacion = $this->asignaciones->insert($dataAsignacion, TRUE);
            
            if($lastIdAsignacion !== FALSE){
                $arrayInsertAsign[] = $lastIdAsignacion;
                
                $dataDetalle = array();
                
                foreach($arrayDetalleAsig[$usuario] as $detalle)
                {
                    $totalReposicion = 0;
        
                    $dataDetalle[] = array (
                        'IDAsignacion'      => $lastIdAsignacion, 
                        'TipoElemento'      => $detalle['TIPOELEMENTO'],  
                        'IDElemento'        => $detalle['ELEMENTO'], 
                        'Observacion'       => $detalle['OBSERVACION'], 
                        'MonedaReposicion'  => $detalle['MONEDA'], 
                        'MontoReposicion'   => $detalle['REPOSICION'], 
                        'UsuarioCrea'       => $this->items['id'],
                        'FechaCrea'         => $fechaActual,    
                        'Localhost'         => $this->request->getIPAddress()
                    );
                }
                $lastId = $this->detalleasignaciones->insertBatch($dataDetalle);
                
        		if($lastId === FALSE)
                {
                    $this->detalleasignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                    $this->asignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                    $message = sprintf($this->mensajeError->msg201, "<li>Se insertaron el total de ".($filainsert-1)." fila(s).2</li><br><li>Hubo un problema al realizar las asignaciones. Inténtelo luego.</li>");
                    echo $this->alertas->alertaPeligro($message);
                    EXIT;
                }
                
                /*
                * ----------------------------
                * PREPARACIÓN DE CUERPO DE CORREO
                * ----------------------------
                */
    
                $arrayCuerpo = array(
                    "TITULO" => "ACTA DE ASIGNACIÓN",
                    "ACTA" => "ACTA DE ASIGNACIÓN",
                    "USUARIO" => ucwords(mb_strtolower($datosAsignado['Nombres'].' '.$datosAsignado['Apellidos'])),
                    "URL_ACTA" => base_url()."/acta-asignacion/".$lastIdAsignacion."/".$tokenAsignacion
                );
    
                $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
                
                /*
                * ----------------------------
                * PREPARACIÓN DE PARAMETROS PARA EL CORREO
                * ----------------------------
                */
    
                $asunto='ACTA DE ASIGNACIÓN: '.$lastIdAsignacion.' - '.$datosAsignado['Nombres'].' '.$datosAsignado['Apellidos'];
                //$correoDestino = array($asignado['Correo']);
                $configCorreo = array(
                    "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                    "CORREO_ORIGEN" => $this->items['correoElectronico'],
                    "CORREOS_DESTINOS" => array($datosAsignado['Correo']),
                    "CORREOS_COPIA" => array($this->items['correoElectronico']),
                    "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
                    // "CORREOS_DESTINOS" => array("josejesus.cuadros@verisure.pe"),
                    // "CORREOS_COPIA" => array(),
                    // "CORREOS_OCULTO" => array(),
                    "ASUNTO" => $asunto,
                    "MENSAJE" => $cuerpo
                );
    
                $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
    
                $dataCorreo = array(
                    "IDAsignacion"  => $lastIdAsignacion,
                    "Response"      => $estadoCorreo['RESPUESTA'],
                    "Error"         => $estadoCorreo['ERROR'],
                    'UsuarioCrea'   => $this->items['id'],
                    'FechaCrea'     => $fechaActual,    
                    'Localhost'     => $this->request->getIPAddress()
                );
    
                $this->correoStatusAsignacion->insert($dataCorreo, TRUE);
                
            }
            else
            {
                $this->detalleasignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                $this->asignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                $message = sprintf($this->mensajeError->msg201, "<li>Se insertaron el total de ".($filainsert-1)." fila(s).1</li><br><li>Hubo un problema al realizar las asignaciones. Inténtelo luego.</li>");
                echo $this->alertas->alertaPeligro($message);
                EXIT;
            }
                
        }
        
        $message = sprintf($this->mensajeError->msg201, "Se insertaron el total de ".($filainsert-1)." fila(s).");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
        
    }
    
	public function insertarKitDemo()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $codigokit              = $this->request->getPost('txtCodigoKitDemo');
        $idElemento             = $this->request->getPost('idelemento');
        $serieElemento          = $this->request->getPost('serieelemento');
        $fechaCompraElemento    = $this->request->getPost('fechacompraelemento');
        $detalleElemento        = $this->request->getPost('detalleelemento');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($codigokit, 'required|trim|minlength[1]|maxlength[30]', 'Código Kit');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        foreach($idElemento as $key=>$elemento)
        {
            $where = array(
                "CodigoKitDemo"     => $codigokit,
                "IDElementoDemo"    => $elemento,
                "Serie"             => $serieElemento[$key]
            );
            
            $itemKit = $this->kitsDemo->where($where)->first();
            if(!empty($itemKit))
            {
                $msgExistencia .= "<li>La SERIE ".$serieElemento[$key]." ya fue registrado para este kit.</li>";
            }
        }
		
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $dataKit = array();

        foreach($idElemento as $key=>$elemento)
        {
            $dataKit[] = array (
                'CodigoKitDemo' => $codigokit,
                'IDElementoDemo'=> $elemento,
                'Serie'         => $serieElemento[$key],
                'Detalle'       => $detalleElemento[$key],
                'FechaCompra'   => $fechaCompraElemento[$key],
                'UsuarioCrea'   => $this->items['id'],
                'FechaCrea'     => $fechaActual,    
                'Localhost'     => $this->request->getIPAddress(),
                'UsuarioEstado' => $this->items['id'],
                'FechaEstado'   => $fechaActual,    
                'MotivoEstado'  => "Creación de Kit Demo.",    
                'Estado'        => 'ACT'
            );
        }
        
        $lastId = $this->kitsDemo->insertBatch($dataKit);
        
		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $codigokit);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosItemKitDemo()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idItemKitDemo = $this->request->getPost('idItemKitDemo');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idItemKitDemo, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosItemKitDemo = $this->kitsDemo->obtenerItemKitDemo($idItemKitDemo);

		if(!empty($datosItemKitDemo)){
			$resultado = array(
				'iditemkitdemo' => (string) $idItemKitDemo,
				'codigo'        => (string) $datosItemKitDemo['CodigoKitDemo'],
				'sku'           => (string) $datosItemKitDemo['SKU'],
				'elemento'      => (string) $datosItemKitDemo['Nombre'],
				'serie'         => (string) $datosItemKitDemo['Serie'],
				'fechacompra'   => (string) $datosItemKitDemo['FechaCompra'],
				'detalle'       => (string) $datosItemKitDemo['Detalle']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarItemKitDemo($idItemKitDemo)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        $codigokit              = $this->request->getPost('txtCodigoKitDemo_i');
        $serieElemento          = $this->request->getPost('txtSerieItemDemo_i');
        $fechaCompraElemento    = $this->request->getPost('txtFechaCompraItemDemo_i');
        $detalleElemento        = $this->request->getPost('txtDetalleItemDemo_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($codigokit, 'required|trim|minlength[1]|maxlength[30]', 'Código Kit');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'CodigoKitDemo'     => $codigokit,
            'Serie'             => $serieElemento,
            'Detalle'           => $detalleElemento,
            'FechaCompra'       => $fechaCompraElemento,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->kitsDemo->update([$idItemKitDemo], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $codigokit);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
	/**************************************************************************/
	
    /****************************** KIT TRABAJO *******************************/
    
	public function listarKitsTrabajo()
	{
	    if(isset($this->items['id']))
	    {
			/* ACCIONES */
			$listaKitsTrabajo = $this->kitsTrabajo->listarKitsTrabajo(array());
			
            $data = array (
				'session'                       => 'on',
				'titulo'                        => 'Kits de Trabajo | Verisure',
				'breadcrumb'                    => $this->items['modulo'],
				// 'breadcrumb_alias'      => 'Comprobantes de Orden de Compra',
				'elementoSeleccionadoModulo'    => 'Kits de Trabajo',
				'subtitulo'                     => "Kits de Trabajo",
				'listaKitsTrabajo'              => $listaKitsTrabajo
			);
			
			$data = array_merge($data, $this->items);
			return view('ures/listar_kits_trabajo',$data);			
		} 
		else 
		{
			return view('errors/500');
		}	
	}
	
	public function obtenerNuevoItemKitTrabajo()
	{
	    $idElementoTrabajo = $this->request->getPost('idElementoTrabajo');
	    
	    $listaElementosTrabajo = $this->elementosTrabajo->where("IDElementoTrabajo", $idElementoTrabajo)->findAll();
	    
	    $html = '';
	    
	    if(empty($listaElementosTrabajo))
	    {
	        $aleatorio = $this->complementos->generar_string_aleatorio(5);
    	        
	        $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="elementoskittrabajo'.$aleatorio.'" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-10 col-10 ">
        	        <div class="alert alert-warning alert-border-left alert-dismissible fade show mb-xl-0" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN INFORMACIÓN</strong> - No hay elementos autorizados para la categoría.
                    </div>
                </div>
        		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
        			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico(\'elementoskittrabajo'.$aleatorio.'\');" data-tooltip="tooltip" aria-label="Eliminar Elemento">
                        <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
                    </button>
        		</div>
        	</div>';
	    }
	    else
	    {
    	    foreach($listaElementosTrabajo as $item)
    	    {
    	        $aleatorio = $this->complementos->generar_string_aleatorio(5);
    	        
    	        $html.='<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="elementoskittrabajo'.$aleatorio.'" style="border-radius: 10px;">
    	            <input type="hidden" name="idelemento['.$aleatorio.']" value="'.$item['IDElementoTrabajo'].'">
    	            <input type="hidden" name="skuelemento['.$aleatorio.']" value="'.$item['SKU'].'">
            		<div class="col-xxl-6 col-md-12 col-12 mb-2">
            			<div>
            				<label class="form-label">Elemento:</label>
            				<input type="text" class="form-control" value="'.$item['Nombre'].'" disabled>
            			</div>
            		</div>
            		<div class="col-xxl-4 col-md-12 col-12 mb-2">
            			<div>
            				<label class="form-label">SKU:</label>
            				<input type="text" class="form-control" value="'.$item['SKU'].'" disabled>
            			</div>
            		</div>
            		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
            			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico(\'elementoskittrabajo'.$aleatorio.'\');" data-tooltip="tooltip" aria-label="Eliminar Elemento">
                            <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
                        </button>
            		</div>
            	</div>';
    	    }
	    }
	    
	    echo $html;
	}
	
	public function insertarKitTrabajo()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $categoria              = $this->request->getPost('txtCategoriaKitTrabajo');
        $idElemento             = $this->request->getPost('idelemento');
        $skuElemento            = $this->request->getPost('skuelemento');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($categoria, 'required|trim|minlength[1]|maxlength[20]', 'Código Kit');
        
        if(empty($idElemento))
        {
            $error .= "<li>Debe seleccionar mínimo un elemento para registrar la categoría del Kit.</li>";
        }
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $where = array(
            "CategoriaKitTrabajo"   => $categoria
        );
            
        $itemKit = $this->kitsTrabajo->where($where)->first();
        
        if(!empty($itemKit))
        {
            $msgExistencia .= "<li>La categoría ya fue registrada como un kit de trabajo.</li>";
        }
        
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
    
        
        // 
        // foreach($idElemento as $key=>$elemento)
        // {
        //     $where = array(
        //         "CategoriaKitTrabajo"   => $categoria,
        //         "IDElementoTrabajo"     => $elemento
        //     );
            
        //     $itemKit = $this->kitsTrabajo->where($where)->first();
            
        // }
		
        /*
        * ----------------------------
        * INSERTAR INFORMACIÓN DE KIT DE TRABAJO
        * ----------------------------
        */
        
        $dataKit = array (
            'CategoriaKitTrabajo'   => $categoria,
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress(),
            'UsuarioEstado'         => $this->items['id'],
            'FechaEstado'           => $fechaActual,    
            'MotivoEstado'          => "Creación de Kit trabajo.",    
            'Estado'                => 'ACT'
        );

        $lastId = $this->kitsTrabajo->insert($dataKit, TRUE);
        
        if($lastId === FALSE){
			$message = sprintf($this->mensajeError->msg502, $codigokit);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
		
        /*
        * ----------------------------
        * INSERTAR INFORMACIÓN DE ELEMENTOS DE KIT DE TRABAJO
        * ----------------------------
        */

        $dataKitElementos = array();

        foreach($idElemento as $key=>$elemento)
        {
            $dataKitElementos[] = array (
                'IDKitTrabajo'          => $lastId,
                'IDElementoTrabajo'     => $elemento,
                'UsuarioRegistra'       => $this->items['id'],
                'FechaRegistra'         => $fechaActual,    
                'Localhost'             => $this->request->getIPAddress()
            );
        }
        
        $lastIdElementos = $this->kitsTrabajoElementos->insertBatch($dataKitElementos);
        
		if($lastIdElementos !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $categoria);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function kitTrabajoElementos($idKitTrabajo)
	{
	    if(isset($this->items['id'])){

			/* ACCIONES */
			$kitTrabajo = $this->kitsTrabajo->where("IDKitTrabajo", $idKitTrabajo)->first();
			
			$listaElementosKitTrabajo = $this->kitsTrabajoElementos->listarElementosKitTrabajo($idKitTrabajo);
            $data = array (
				'session'                       => 'on',
				'titulo'                        => 'Elementos de Kit de Trabajo | Verisure',
				'breadcrumb'                    => $this->items['modulo'],
				// 'breadcrumb_alias'      => 'Comprobantes de Orden de Compra',
				'elementoSeleccionadoModulo'    => 'Kit de Trabajo: '.$kitTrabajo['CategoriaKitTrabajo'],
				'subtitulo'                     => "Elementos de Trabajo",
                'previo'                        => 'listar-kits-trabajo',
                'kitTrabajo'                    => $kitTrabajo,
				'listaElementosKitTrabajo'      => $listaElementosKitTrabajo
			);
			
			$data = array_merge($data, $this->items);
			return view('ures/listar_kits_trabajo_elementos',$data);			
		} else {
			return view('errors/500');
		}	
	}
	
	public function asociarElementoKitTrabajo()
	{
	    $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $idElementoTrabajo  = $this->request->getPost('idElementoTrabajo');
        $idKitTrabajo       = $this->request->getPost('idKitTrabajo');
        // var_dump($idKitTrabajo); exit;
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idElementoTrabajo, 'required|trim|number', 'ID Elemento');
        $error .= $this->complementos->validaCampo($idKitTrabajo, 'required|trim|number', 'ID Kit de Trabajo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereEKT = array(
            'IDKitTrabajo'         => $idKitTrabajo,
            'IDElementoTrabajo'    => $idElementoTrabajo
        );
        
		$combinacionExistente = $this->kitsTrabajoElementos->where($whereEKT)->findAll();
		
        if(count($combinacionExistente)>0)
        {
            $msgExistencia .= "<li>El elemento ya fue agregado al kit de trabajo. [CAMPO] <small>ELEMENTO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDKitTrabajo'      => $idKitTrabajo, 
            'IDElementoTrabajo' => $idElementoTrabajo,
            'UsuarioRegistra'   => $this->items['id'],
            'FechaRegistra'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
// var_dump($data); exit;
        $lastId = $this->kitsTrabajoElementos->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idElementoTrabajo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
    public function eliminarElementoKitTrabajo()
    {
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idElementoTrabajo  = $this->request->getPost('idElementoTrabajo');
        $idKitTrabajo       = $this->request->getPost('idKitTrabajo');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idElementoTrabajo, 'required|trim|number', 'ID Elemento');
        $error .= $this->complementos->validaCampo($idKitTrabajo, 'required|trim|number', 'ID Kit de Trabajo');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $whereDelete = array (
            'IDKitTrabajo'         => $idKitTrabajo, 
            'IDElementoTrabajo'    => $idElementoTrabajo
        );

        $lastId = $this->kitsTrabajoElementos->where($whereDelete)->delete();

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg504, $idElementoTrabajo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
	
	
	
	
	
	
	
    public function modificarEstadoElementoDemo()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idElementoDemo = $this->request->getPost('idElementoDemo');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idElementoDemo, 'required|trim|numeric', 'ID Elemento Demo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->elementosDemo->update([$idElementoDemo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idElementoDemo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
}