<?php

namespace App\Controllers;

class Solicitudes extends BaseController
{
	public function __construct()
	{
	    
        $this->auditoria    = new \App\Models\AuditoriaModel();
        
        $this->usuarios     = new \App\Models\UsuarioModel();
        
        $this->divisas              = new \App\Models\DivisasModel();
        
		/* CONFIGURACIÓN */
		$this->elementosTrabajo             = new \App\Models\Configuracion\ElementosTrabajoModel();
		
        /* IT */
        $this->moviles                      = new \App\Models\IT\MovilesModel();
        $this->contratos                    = new \App\Models\IT\LineasContratoModel();
        $this->hardware                     = new \App\Models\IT\HardwareModel();
        $this->tarjetasAcceso               = new \App\Models\IT\TarjetasAccesoModel();
        
		/* URES */
		$this->kitsDemo                     = new \App\Models\URES\KitsDemoModel();
		$this->kitsTrabajo                  = new \App\Models\URES\KitsTrabajoModel();
		$this->kitsTrabajoElementos         = new \App\Models\URES\KitsTrabajoElementosModel();
		
        /* CARGOS */
        $this->asignacionesDetalle          = new \App\Models\Cargos\AsignacionesDetalleModel();
        
        $this->solicitudReposicion          = new \App\Models\Solicitudes\SolicitudReposicionModel();
        
        $this->reposiciones                 = new \App\Models\Cargos\ReposicionesModel();
        $this->reposicionesDetalle          = new \App\Models\Cargos\ReposicionesDetalleModel();
        $this->reposicionesAdjuntos         = new \App\Models\Cargos\ReposicionesAdjuntosModel();
        $this->reposicionesCronogramaPago   = new \App\Models\Cargos\ReposicionesCronogramaPagoModel();
        
        $this->devoluciones                 = new \App\Models\Cargos\DevolucionesModel();
        $this->devolucionesDetalle          = new \App\Models\Cargos\DevolucionesDetalleModel();
        $this->devolucionesAdjuntos         = new \App\Models\Cargos\DevolucionesAdjuntosModel();
        
        $this->correoStatusAsignacion       = new \App\Models\Cargos\CorreoStatusAsignacionModel();
        $this->correoStatusDevolucion       = new \App\Models\Cargos\CorreoStatusDevolucionModel();
        $this->correoStatusReposicion       = new \App\Models\Cargos\CorreoStatusReposicionModel();
	}
	
	/**************************************************************************/
	
    /************************ SOLICITUD DE REPOSICIONES ***********************/
    
	public function listarSolicitudesReposicion()
	{
	    if(isset($this->items['id']))
	    {
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Solicitudes de Reposición | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Solicitudes de Reposición',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Solicitudes de Reposición",
				'subtitulo'                 => 'Listado de Solicitudes'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('solicitudes/solicitudes_reposicion',$data);	
		} 
		else 
		{
			return view('errors/500');
		}
	}
	
	public function solicitudReposicionServerside()
	{
    	if (isset($this->items['id'])) 
    	{
            $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
    	    $dataServerside =  $this->solicitudReposicion->listarSolicitudesReposicionServerside($this->request->getPost(), $adicionales);
    	    
    	    foreach($dataServerside["data"] as $key=>$value)
            {
                //CONFIGURACIÓN DE LA INFORMACIÓN "FECHA SOLICITUD"
                
                $fechaSolicitud = date("d-m-Y", strtotime($value['FechaCrea']));
                $dataServerside["data"][$key]['FechaSolicitudReposicion'] = $fechaSolicitud;
                
                //CONFIGURACIÓN DE LA INFORMACIÓN "FECHA SOLICITUD"
                
                $fechaUltimoCambio = $value['FechaModifica'] == '' || $value['FechaModifica'] == null ? date("d-m-Y", strtotime($value['FechaCrea'])) : date("d-m-Y", strtotime($value['FechaModifica']));
                $dataServerside["data"][$key]['FechaUltimoCambio'] = $fechaUltimoCambio;
                
                $dataServerside["data"][$key]['SolicitanteReposicion'] = ucwords(mb_strtolower($value['NombresSolicitante'].' '.$value['ApellidosSolicitante']));
                $dataServerside["data"][$key]['AdjudicadoReposicion'] = $value['MatriculaAdjudicado'].' | '.ucwords(mb_strtolower($value['NombresAdjudicado'].' '.$value['ApellidosAdjudicado']));
                $dataServerside["data"][$key]['ElementoReposicion'] = $value['TipoEquipo'].' | '.$value['Marca'].' - '.$value['Modelo'].' - '.$value['Serie'];
                $dataServerside["data"][$key]['MotivoReposicion'] = '<span class="badge bg-sistema border-0">'.$this->globales->motivoEstadoDispositivos('')[$value['MotivoReposicion']].'</span>';
                $dataServerside["data"][$key]['EstadoSolicitud'] = '<span class="badge '.$this->veriactivos->estadosSolicitud()[$value['Estado']]['FONDO'].' border-0">'.$this->veriactivos->estadosSolicitud()[$value['Estado']]['PASADO'].'</span>';
                
                //CONFIGURACIÓN DE LAS ACCIONES DEL ELEMENTO
                $acciones = "";
                $acciones .= "<div class='dropdown d-inline-block'>";
                
                $acciones .= "<a href='".$this->items['baseUrl']."/solicitud-reposicion-informacion/".$value['IDSolicitudReposicion']."' target='_blank' class='badge bg-sistema border-0 p-2 mx-1' data-tooltip='tooltip' data-toggle='tooltip' data-placement='top' title='Ver Solicitud de Reposición #".$value['IDSolicitudReposicion']."' aria-label='Ver Solicitud de Reposición #".$value['IDSolicitudReposicion']."'>
                    <i class='mdi mdi-eye align-bottom' style='font-size: 20px; color: #FFF;'></i>
                </a>";
    			
    			$acciones .= "</div>";
                
                $dataServerside["data"][$key]['Acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	} 
    	else 
    	{
            $resultado = array(
				'descripcion' => 0,
			);
			echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
	}
	
	public function listadoItemsAsignados() 
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/
		
		$msjError = TRUE;
		$idUsuario          = $this->request->getPost('idUsuario');
		$motivoReposicion   = $this->request->getPost('motivoReposicion');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idUsuario, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
        $whereDetalle = array(
            'IDDevolucion'      => '',
            'UsuarioAsignado'   => $idUsuario,
            'TipoCategoria'     => ($motivoReposicion == "INC" ? "KITS" : "" )
        );
		
		$listadoItems = $this->asignacionesDetalle->listarDetalleElementosAsignados($whereDetalle);
		
        $items = array();

        if (!empty($listadoItems)) 
        {
            foreach($listadoItems as $value)
            {
                $items[] = array(
					'id'    => (string) $value['IDDetalleAsignacion'],
         	        'item'  => (string) $value['TipoEquipo'].' | '.$value['Marca'].' '.$value['Modelo'].' '.$value['Serie'],
                );
            }
            
            $resultado = array(
				'listadoItems' => json_encode($items)
			);
        } 
        else
        {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

    public function obtenerElementoReponer()
    {
        $idItem = $this->request->getPost('idItem');
        $idUsuario = $this->request->getPost('idUsuario');
        $situacion = $this->request->getPost('situacion');
        
        $dataReposicion = array();
        
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
        $whereDetalle = array(
            'IDDetalleAsignacion'   => $idItem,
            'return'                => "row"
        );
		
        $detalle = $this->asignacionesDetalle->listarDetalleElementosAsignados($whereDetalle);
        
        // $dataReposicion = array();
        
        $dataReposicion[] = $this->informacionReposicionElemento($detalle, $idUsuario, $situacion, "");
        // var_dump($dataReposicion); exit;
        /*
        * ----------------------------
        * ARMAR VISUAL POR ELEMENTO
        * ----------------------------
        */
        
	    $html = '';
	    
	    if(empty($dataReposicion))
	    {
            $aleatorio = $this->complementos->generar_string_aleatorio(5);
    	        
	        $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="itemasignar'.$aleatorio.'" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-10 col-10 ">
        	        <div class="alert alert-warning alert-border-left alert-dismissible fade show mb-xl-0" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN INFORMACIÓN</strong> - No se encontró información sobre el item seleccionado.
                    </div>
                </div>
        		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
        			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico(\'itemasignar'.$aleatorio.'\');" data-tooltip="tooltip" aria-label="Eliminar Item a Asignar">
                        <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
                    </button>
        		</div>
        	</div>';
	    }
	    else
	    {
    	    foreach($dataReposicion as $item)
    	    {
                $aleatorio = $this->complementos->generar_string_aleatorio(5);
                
                $valorValidacion = in_array($item['ELEMENTO'], array("MOVIL", "HARDWARE", "TARJETA")) ? "REGIS" : "NREQV";
    	        
                $html.='<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="itemreponer'.$aleatorio.'" style="border-radius: 10px;">
    	            <input type="hidden" name="itemReposicion['.$aleatorio.']" value="'.$item['IDITEM'].'">
    	            <input type="hidden" name="elemento['.$aleatorio.']" value="'.$item['ELEMENTO'].'">
    	            <input type="hidden" name="idelemento['.$aleatorio.']" value="'.$item['IDELEMENTO'].'">
    	            <input type="hidden" name="validacionDevolucion['.$aleatorio.']" value="'.$valorValidacion.'">
    	            <input type="hidden" name="etiquetaitem['.$aleatorio.']" value="'.$item['ITEM'].'">
            		<div class="col-xxl-7 col-md-12 col-12 mb-3">
            			<div>
            				<label class="form-label">Elemento:</label>
            				<input type="text" class="form-control" value="'.$item['ITEM'].'" disabled>
            			</div>
            		</div>
            		<div class="col-xxl-5 col-md-12 col-12 mb-3">
            		    <label class="form-label">Valor Reposición</label>
            			<div class="input-group">
                            <span class="input-group-text">'.$item['SIMBOLO'].'</span>
                            <input type="number" class="form-control" step="0.01" min="0" value="'.$item['TOTALCAMBIO'].'" disabled>
                            <input type="hidden" class="form-control" value="'.$item['VERISURE'].'" >
                            <input type="hidden" class="form-control" value="'.$item['TRABAJADOR'].'" >
                            <input type="hidden" class="form-control" value="'.$item['ROBO'].'" >
                        </div>
            		</div>
            		<div class="col-xxl-10 col-md-10 col-10 ">
            		    <div class="form-floating">
                            <textarea class="form-control" id="detalle'.$aleatorio.'" name="obselemento['.$aleatorio.']" rows="3"></textarea>
                            <label for="detalle'.$aleatorio.'">Detalle</label>
                        </div>
            		</div>
            		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
            			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico(\'itemreponer'.$aleatorio.'\');" data-tooltip="tooltip" aria-label="Eliminar Item a Reponer">
                            <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
                        </button>
            		</div>
            	</div>';
    	    }
	    }
	    
	    echo $html;
    }

	public function solicitarReposicionItem()
	{
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        // var_dump($this->request->getPost());exit;
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $adjudicado = $this->request->getPost('txtAdjudicadoReposicion');
        $motivo = $this->request->getPost('txtMotivoReposicion');
        // $cuotas = $this->request->getPost('txtCuotasReposicion');
        $observacion = $this->request->getPost('txtObservacion');
        
        $excepcion = $this->request->getPost('chkExcepcionCobro');
        
        $itemDetalle = $this->request->getPost('itemReposicion');
        $etiquetaitem = $this->request->getPost('etiquetaitem');
        $elemento = $this->request->getPost('elemento');
        $idelemento = $this->request->getPost('idelemento');
        $validacion = $this->request->getPost('validacionDevolucion');
        // $totalDescuento = $this->request->getPost('totalDescuento');
        // $totalVerisure = $this->request->getPost('totalVerisure');
        // $totalTrabajador = $this->request->getPost('totalTrabajador');
        $obsDetalle = $this->request->getPost('obselemento');
        // $tipoElemento = $this->request->getPost('tipoElementoReposicion');

        $adjunto = $this->request->getFile("fileAdjuntoReposicion");
        
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($adjudicado, 'required|trim', 'Usuario adjudicado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim|minlength[3]|maxlength[3]', 'Motivo');
        // $error .= $this->complementos->validaCampo($cuotas, 'required|trim|minlength[1]|maxlength[1]', 'Cuotas');
        
        if(empty($itemDetalle))
        {
            $error .= "<li>Debe registrar un item en la reposición.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        if($motivo == 'ROB' || $motivo == 'PER')
        {
            /*
            * ----------------------------
            * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
            * ----------------------------
            */
            
            if (! $adjunto->isValid()) {
                $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
                echo $this->alertas->alertaError($message);
                exit;
            }
            
            /*
            * ----------------------------
            * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
            * ----------------------------
            */
            
            $validationRule = [
                'fileAdjuntoReposicion' => [
                    'mime_in[fileAdjuntoReposicion,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                    'ext_in[fileAdjuntoReposicion,pdf,jpeg,jpg]'
                ],
            ];

            if (! $this->validate($validationRule)) {
                $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        foreach($itemDetalle as $key=>$detalle)
        {
            $itemRepuesto = $this->reposicionesDetalle->where("IDDetalleAsignacion", $detalle)->findAll();

            if(!empty($itemRepuesto))
            {
                $msgExistencia .= "<li>El ".$etiquetaitem[$detalle]." ya fue repuesto.</li>";
            }
        }
		
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * --------------------------------------------------------------------
        * ---------------- GESTIÓN DE SOLICITUD DE REPOSICIÓN ----------------
        * --------------------------------------------------------------------
        */
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS SOLICITUD
        * ----------------------------
        */

        $dataSolicitud = array();
        
        foreach($itemDetalle as $key => $detalle)
        {
            $elementosURES = array("KITDEMO", "ELEMENTOTRABAJO");
            $elementosIT = array("LINEA", "MOVIL", "TARJETA", "HARDWARE", "ACCESORIOIT");
            
            $area = in_array($elemento[$key], $elementosURES) ? "URES" : "IT";
            
            $dataSolicitud[] = array (
                'IDDetalleAsignacion'       => $detalle,
                'Observacion'               => $obsDetalle[$key], 
                'Excepcion'                 => ($excepcion == '' || $excepcion == null ? "N" : "Y"),
                'AreaEncargada'             => $area, 
                'MotivoReposicion'          => $motivo,
                'IDUsuarioAdjudicado'       => $adjudicado, 
                'UsuarioCrea'               => $this->items['id'],
                'FechaCrea'                 => $fechaActual,    
                'Localhost'                 => $this->request->getIPAddress(),
                'Estado'                    => "CREA",
                'UsuarioEstado'             => $this->items['id'],
                'FechaEstado'               => $fechaActual,
                'IDDireccionEstado'         => $this->items['dpto'], 
                'IDAreaEstado'              => $this->items['idArea'], 
                'IDSubareaEstado'           => $this->items['idSubarea'], 
                'IDDelegacionEstado'        => $this->items['idDelegacionLog'],
                'IDPerfilEstado'            => $this->items['idPerfil'],
                'IDCargoEstado'             => $this->items['idCargoLog'],
                'MotivoEstado'              => $observacion
            );
        }
        
        $lastIdSolicitud = $this->solicitudReposicion->insertBatch($dataSolicitud);
        // $lastIdSolicitud = "2222222222222";
        if($lastIdSolicitud === FALSE)
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la solicitud. Inténtelo luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * --------------------------------------------------------------------
        * ------------------- GESTIÓN DE ACTA DE DEVOLUCIÓN ------------------
        * --------------------------------------------------------------------
        */
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS DEVOLUCIÓN
        * ----------------------------
        */
        
        $datosUsuario = $this->usuarios->buscarUsuario($adjudicado);
        $tokenDevolucion = $this->complementos->generar_string_aleatorio(15);

        $dataDevolucion = array (
            'UsuarioDevolucion'         => $adjudicado, 
            'CargoDevolucion'           => $datosUsuario['Cargo'], 
            'DireccionDevolucion'       => $datosUsuario['IDDireccion'], 
            'AreaDevolucion'            => $datosUsuario['IDArea'], 
            'SubareaDevolucion'         => $datosUsuario['IDSubarea'], 
            'DelegacionDevolucion'      => $datosUsuario['IDDelegacion'], 
            'Motivo'                    => "REPOSICION", 
            'Observacion'               => "Devolución generada desde reposición.", 
            'TokenLinkFirma'            => $tokenDevolucion,
            'UsuarioCrea'               => $this->items['id'],
            'CargoCrea'                 => $this->items['cargo'], 
            'DireccionCrea'             => $this->items['dpto'],
            'AreaCrea'                  => $this->items['idArea'], 
            'SubareaCrea'               => $this->items['idSubarea'],
            'DelegacionCrea'            => $this->items['idDelegacionLog'],
            'FechaCrea'                 => $fechaActualAdd,
            'Localhost'                 => $this->request->getIPAddress()
        );

        $lastIdDevolucion = $this->devoluciones->insert($dataDevolucion, TRUE);
        
        if($lastIdDevolucion !== FALSE){
            $idDevolucion = $lastIdDevolucion;
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la reposición. Inténtelo luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $dataDetalleDevolucion = array();
        $eliminarNoCobro = array();

        foreach($itemDetalle as $key => $detalle)
        {
            $dataDetalleDevolucion[] = array (
                'IDDevolucion'          => $idDevolucion, 
                'IDDetalleAsignacion'   => $detalle,  
                'MotivoDevolucion'      => $motivo,
                'Estado'                => $validacion[$key],
                'Observacion'           => $obsDetalle[$key],
                'UsuarioCrea'           => $this->items['id'],
                'FechaCrea'             => $fechaActualAdd,    
                'Localhost'             => $this->request->getIPAddress()
            );
            
            $whereDetalleAsignacion = array(
                'IDDetalleAsignacion'   => $detalle,
                'return'                => "row"
            );
    		
    		$detalleAsignacion = $this->asignacionesDetalle->listarDetalleElementosAsignados($whereDetalleAsignacion);
    		
    		if($detalleAsignacion['GeneraCobroReposicion'] == "N")
    		{
    		    $eliminarNoCobro[] = $detalle;
    		}
        }
        $lastIdDetalleDevolucion = $this->devolucionesDetalle->insertBatch($dataDetalleDevolucion);
        
		if($lastIdDetalleDevolucion === FALSE){
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la reposición. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		} 

        /*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO DE DEVOLUCIÓN
        * ----------------------------
        */

        $arrayCuerpo = array(
            "TITULO" => "ACTA DE DEVOLUCIÓN",
            "ACTA" => "ACTA DE DEVOLUCIÓN",
            "USUARIO" => ucwords(mb_strtolower($datosUsuario['Nombres'].' '.$datosUsuario['Apellidos'])),
            "URL_ACTA" => base_url()."/acta-devolucion/".$idDevolucion."/".$tokenDevolucion
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
        
        /*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
        */

        $asunto='ACTA DE DEVOLUCIÓN: '.$idDevolucion.' - '.$datosUsuario['Nombres'].' '.$datosUsuario['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
            "CORREO_ORIGEN" => $this->items['correoElectronico'],
            "CORREOS_DESTINOS" => array($datosUsuario['Correo']),
            "CORREOS_COPIA" => array("soporteit@verisure.pe", $this->items['correoElectronico']),
            "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
            // "CORREOS_DESTINOS" => array("josejesus.cuadros@verisure.pe"),
            // "CORREOS_COPIA" => array(),
            // "CORREOS_OCULTO" => array(),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDDevolucion"  => $idDevolucion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusDevolucion->insert($dataCorreo, TRUE);
        
        /*
        * --------------------------------------------------------------------
        * ------------------- GESTIÓN DE ACTA DE REPOSICIÓN ------------------
        * --------------------------------------------------------------------
        */
        
        // if($motivo == 'FAL')
        // {
        //     foreach ($elemento as $key => $value) {      // Recorrer los elementos del array
        //         if ($value == "KITDEMO" || $value == "MOVIL") {                 // Si la clave es un entero:
        //             unset($itemDetalle[$key]);              // Destruir la variable (elemento del array)
        //         }
        //     }
        // }
        
        // if(!empty($itemDetalle))
        if($excepcion == '' || $excepcion == null)
        {
            if($motivo != 'FAL' && $motivo != 'REN')
            {
                $itemDetalle = array_filter($itemDetalle, function($valor) use ($eliminarNoCobro) 
                {
                    return !in_array($valor, $eliminarNoCobro);
                });
                
                if(count($itemDetalle)>0)
                {
                    /*
                    * ----------------------------
                    * INSERCIÓN DE DATOS REPOSICIÓN
                    * ----------------------------
                    */
                    
                    $datosAdjudicado = $this->usuarios->buscarUsuario($adjudicado);
                    $tokenReposicion = $this->complementos->generar_string_aleatorio(15);
            
                    $dataReposicion = array (
                        'UsuarioAdjudicado'         => $adjudicado, 
                        'CargoAdjudicado'           => $datosAdjudicado['Cargo'], 
                        'DireccionAdjudicado'       => $datosAdjudicado['IDDireccion'], 
                        'AreaAdjudicado'            => $datosAdjudicado['IDArea'], 
                        'SubareaAdjudicado'         => $datosAdjudicado['IDSubarea'], 
                        'DelegacionAdjudicado'      => $datosAdjudicado['IDDelegacion'], 
                        'TokenLinkFirma'            => $tokenReposicion, 
                        'LiberadoFirma'             => "Y",
                        'Motivo'                    => $motivo,
                        'Observacion'               => $observacion,
                        'Cuotas'                    => "Y",
                        'UsuarioCrea'               => $this->items['id'],
                        'CargoCrea'                 => $this->items['cargo'],
                        'DireccionCrea'             => $this->items['dpto'],
                        'AreaCrea'                  => $this->items['idArea'],
                        'SubareaCrea'               => $this->items['idSubarea'],
                        'DelegacionCrea'            => $this->items['idDelegacionLog'],
                        'FechaCrea'                 => $fechaActual,    
                        'Localhost'                 => $this->request->getIPAddress()
                    );
            
                    $lastIdReposicion = $this->reposiciones->insert($dataReposicion, TRUE);
                    // $lastIdReposicion = "111111111111111";
                    if($lastIdReposicion !== FALSE){
                        $idReposicion = $lastIdReposicion;
                    }
                    else
                    {
                        $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar el acta de la reposición. Inténtelo luego.</li>");
                        echo $this->alertas->alertaError($message);
                        EXIT;
                    }
            
                    $dataDetalle = array();
                    $totalSumaTrabajador = 0;
                    
                    $diaPlanilla = $this->globales->diaCortePlanilla();
            
                    $fechaPlanillaActual = date("Y-m-".$diaPlanilla);
                    $fechaEvaluarActual = date("Y-m-d");
                    
                    $timePlanilla = strtotime($fechaPlanillaActual);
                    $timeActual = strtotime($fechaEvaluarActual);
            
                    $mesActual = date("m");
                    $anioActual = date("Y");
                    
                    foreach($itemDetalle as $key => $detalle)
                    {
                        //SETEAMOS EL MES Y ANIO DE INICIO DE CUOTAS DE CADA ELEMENTO
                        $mesInicioCuotas=0;
                        $anioInicioCuotas=0;
            
                        if($timePlanilla >= $timeActual)
                        {
                            $mesInicioCuotas = date("m");
                            $anioInicioCuotas = date("Y");
                        }
                        else
                        {
                            if($mesActual == 12)
                            {
                                $mesInicioCuotas = 1;
                                $anioInicioCuotas = $anioActual +1 ;
                            }
                            else
                            {
                                $mesInicioCuotas = $mesActual + 1;
                                $anioInicioCuotas = $anioActual;
                            }
                        }
                        
                        $whereDetalle = array(
                            'IDDetalleAsignacion'   => $detalle,
                            'return'                => "row"
                        );
                        
                        $detalleAsignacion = $this->asignacionesDetalle->listarDetalleElementosAsignados($whereDetalle);
                        $dataReposicion = $this->informacionReposicionElemento($detalleAsignacion, $adjudicado, $motivo, "");
                        
                        $totalDescuento     = !empty($dataReposicion) ? $dataReposicion['TOTALCAMBIO'] : 0 ;
                        $totalVerisure      = !empty($dataReposicion) ? $dataReposicion['VERISURE'] : 0 ;
                        $totalTrabajador    = !empty($dataReposicion) ? $dataReposicion['TRABAJADOR'] : 0 ;
                        
                        $cuotasTrabajador   = !empty($dataReposicion) ? $dataReposicion['TOTALCUOTAS'] : 1 ;
                        $bolsa              = !empty($dataReposicion) ? $dataReposicion['BOLSA'] : 'IT' ;
    
                        $dataDetalle = array (
                            'IDReposicion'          => $idReposicion, 
                            'IDDetalleAsignacion'   => $detalle,
                            'TotalDescuento'        => $totalDescuento, 
                            'TotalVerisure'         => $totalVerisure, 
                            'TotalTrabajador'       => $totalTrabajador, 
                            'Observacion'           => $obsDetalle[$key], 
                            'TotalCuotas'           => $cuotasTrabajador,
                            'MesFacturacion'        => $mesInicioCuotas,
                            'AnioFacturacion'       => $anioInicioCuotas,
                            'Bolsa'                 => $bolsa,
                            'Cobrado'               => 'N',
                            'UsuarioCrea'           => $this->items['id'],
                            'FechaCrea'             => $fechaActual,    
                            'Localhost'             => $this->request->getIPAddress()
                        );
            
                        $lastIdDetalleReposicion = $this->reposicionesDetalle->insert($dataDetalle, TRUE);
                        
                        if($lastIdDetalleReposicion === FALSE){
                            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la reposición de un item. Inténtelo luego.[ARD]");
                            echo $this->alertas->alertaError($message);
                            exit;
                        } 
                        
                        /*
                        * ----------------------------
                        * INSERCIÓN DE DATOS REPOSICIÓN - CRONOGRAMA DE PAGOS
                        * ----------------------------
                        */
                        
                        $dataCronogramaPago = array();
                        
                        $descuentoMensual = number_format(round($totalTrabajador / $cuotasTrabajador, 2), 2, '.', '');
                
                        for($i=1; $i<=$cuotasTrabajador;$i++)
                        {
                            if($i == ($cuotasTrabajador))
                            {
                                $montoCuota = ($totalTrabajador - (($cuotasTrabajador - 1)*$descuentoMensual));
                            }
                            else
                            {
                                $montoCuota = $descuentoMensual;
                            }
                
                            $dataCronogramaPago[] = array (
                                'IDDetalleReposicion'   => $lastIdDetalleReposicion, 
                                'NroCuota'              => $i, 
                                'MesCuota'              => $mesInicioCuotas, 
                                'AnioCuota'             => $anioInicioCuotas, 
                                'MontoCuota'            => $montoCuota, 
                                'Observacion'           => 'Cuota generada automáticamente', 
                                'UsuarioCrea'           => $this->items['id'],
                                'FechaCrea'             => $fechaActual,
                                'Estado'                => 'A',
                                'UsuarioEstado'         => $this->items['id'],
                                'FechaEstado'           => $fechaActual,
                                'Localhost'             => $this->request->getIPAddress()
                            );
                
                            $mesInicioCuotas++;
                
                            if($mesInicioCuotas > 12)
                            {
                                $mesInicioCuotas = 1;
                                $anioInicioCuotas = $anioInicioCuotas + 1;
                            }
                        }
                
                        $lastIdCronograma = $this->reposicionesCronogramaPago->insertBatch($dataCronogramaPago);
                        
                		if($lastIdCronograma === FALSE){
                            $this->reposicionesDetalle->where('IDDetalleReposicion', $lastIdDetalleReposicion)->delete();
                            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar un detalle de la reposición. Inténtelo luego.[INSERT]");
                			echo $this->alertas->alertaError($message);
                			exit;
                		} 
                
                        /*
                        * ----------------------------
                        * ACTUALIZAR ESTADO DEL ITEM DE LA SOLICITUD DE REPOSICIÓN
                        * ----------------------------
                        */
                        
                        $updSolicitud = array(
                            "GeneraReposicion"      => "Y",
                            "DescargoEvaluacion"    => "Acta de reposición generada por politíca asociada.",
                            "Estado"                => 'COMP',
                            "UsuarioEstado"         => $this->items['id'],
                            "FechaEstado"           => $fechaActualAdd,
                            'IDDireccionEstado'     => $this->items['dpto'], 
                            'IDAreaEstado'          => $this->items['idArea'], 
                            'IDSubareaEstado'       => $this->items['idSubarea'], 
                            'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
                            'IDPerfilEstado'        => $this->items['idPerfil'],
                            'IDCargoEstado'         => $this->items['idCargoLog'],
                            "MotivoEstado"          => "Acta de reposición generada."
                        );
                        
                        $lastIdUpdate = $this->solicitudReposicion->where("IDDetalleAsignacion", $detalle)->set($updSolicitud)->update();
                        
                    }
                    
                    /*
                    * ----------------------------
                    * GUARDAR ARCHIVO ADJUNTO
                    * ----------------------------
                    */
                    
                    if($motivo == 'ROB' || $motivo == 'PER')
                    {
                        if($adjunto->guessExtension() != null)
                        {
                            $extensionDoc = $adjunto->guessExtension();
                        }
                        else
                        {
                            $nombre_original = $adjunto->getBasename();
                            $fileNameCmps = explode(".", $nombre_original);
                            $extensionDoc = strtolower(end($fileNameCmps));
                        }
                        
                        /*
                        * ----------------------------
                        * INSERCIÓN DE DATOS ADJUNTOS
                        * ----------------------------
                        */
            
                        $dataAdjuntoReposicion = array (
                            'IDReposicion'      => $idReposicion, 
                            'Nombre'            => "Denuncia Reposición", 
                            'Extension'         => $extensionDoc,
                            'Observacion'       => "Reporte de denuncia de equipos.",
                            'ReemplazoFirma'    => "N",  
                            'UsuarioCrea'       => $this->items['id'],
                            'FechaCrea'         => $fechaActual,    
                            'Localhost'         => $this->request->getIPAddress()
                        );
            
                        $lastIdAdjuntosReposiciones = $this->reposicionesAdjuntos->insert($dataAdjuntoReposicion, TRUE);
            
                        if($lastIdAdjuntosReposiciones === FALSE){
                            // $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
                            // $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                            // $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                            /*$this->devolucionesDetalle->where('IDDevolucion', $idDevolucion)->delete();
                            $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();*/
                            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
                            echo $this->alertas->alertaError($message);
                            exit;
                        }
            
                        /*
                        * ----------------------------
                        * GUARDAR ARCHIVO ADJUNTO REPOSICIÓN
                        * ----------------------------
                        */
                        $ruta = $this->items['baseDinamic']."/docs/ActaReposicion/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
                        $nombreArchivo = $idReposicion."-".$lastIdAdjuntosReposiciones;
            
                        if(!file_exists($ruta))
                        {
                            @mkdir($ruta, 0777, true);
                        }
            
                        # si exsite la carpeta o se ha creado
                        if (file_exists($ruta) || @mkdir($ruta)) 
                        {
                            $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
                            
                            $estadoMove = $adjunto->move($ruta, $nuevonombre);
                            
                            if (!$estadoMove) {
                                // $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
                                // $this->reposicionesAdjuntos->where('IDAdjuntoReposicion', $lastIdAdjuntosReposiciones)->delete();
                                // $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                                // $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                                echo $this->alertas->alertaError($message);
                                exit;
                            }
                        }
                        else
                        {
                            // $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
                            // $this->reposicionesAdjuntos->where('IDAdjuntoReposicion', $lastIdAdjuntosReposiciones)->delete();
                            // $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                            // $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
                            echo $this->alertas->alertaError($message);
                            exit;
                        }
                        
                    }
                    
                    /*
                    * ----------------------------
                    * PREPARACIÓN DE CUERPO DE CORREO DE REPOSICIÓN
                    * ----------------------------
                    */
            
                    $arrayCuerpo = array(
                        "TITULO" => "ACTA DE REPOSICIÓN",
                        "ACTA" => "ACTA DE REPOSICIÓN",
                        "USUARIO" => ucwords(mb_strtolower($datosAdjudicado['Nombres'].' '.$datosAdjudicado['Apellidos'])),
                        "URL_ACTA" => base_url()."/acta-reposicion/".$idReposicion."/".$tokenReposicion
                    );
            
                    $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
                    
                    /*
                    * ----------------------------
                    * PREPARACIÓN DE PARAMETROS PARA EL CORREO
                    * ----------------------------
                    */
            
                    $asunto='ACTA DE REPOSICIÓN: '.$idReposicion.' - '.$datosAdjudicado['Nombres'].' '.$datosAdjudicado['Apellidos'];
                    //$correoDestino = array($asignado['Correo']);
                    $configCorreo = array(
                        "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                        "CORREO_ORIGEN" => $this->items['correoElectronico'],
                        "CORREOS_DESTINOS" => array($datosAdjudicado['Correo']),
                        "CORREOS_COPIA" => array("soporteit@verisure.pe", $this->items['correoElectronico']),
                        "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
                        // "CORREOS_DESTINOS" => array("josejesus.cuadros@verisure.pe"),
                        // "CORREOS_COPIA" => array(),
                        // "CORREOS_OCULTO" => array(),
                        "ASUNTO" => $asunto,
                        "MENSAJE" => $cuerpo
                    );
            
                    $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
            
                    $dataCorreo = array(
                        "IDReposicion"  => $idReposicion,
                        "Response"      => $estadoCorreo['RESPUESTA'],
                        "Error"         => $estadoCorreo['ERROR'],
                        'UsuarioCrea'   => $this->items['id'],
                        'FechaCrea'     => $fechaActual,    
                        'Localhost'     => $this->request->getIPAddress()
                    );
            
                    $this->correoStatusReposicion->insert($dataCorreo, TRUE);
                }
            }
        }
        
        $message = sprintf($this->mensajeError->msg201, "La reposición fue solicitada exitosamente.");
        echo $this->alertas->alertaExito($message);
        // echo $this->alertas->refrescar(1);
        // echo $this->alertas->reDireccion(base_url()."/solicitud-reposicion-items/".$lastIdSolicitud, 1);
        
	}
	
	public function informacionSolicitudReposicion($idSolicitudReposicion)
	{
	    if(isset($this->items['id']))
	    {
	        $arraySolicitud = array(
	            'IDSolicitudReposicion' => $idSolicitudReposicion,
	            'return' => 'row'
	        );
	        
		    $solicitud  = $this->solicitudReposicion->obtenerInformacionSolicitudReposicion($arraySolicitud);
            $timeline   = $this->solicitudReposicion->timelineSolicitudReposicion($arraySolicitud);
            
			$motivosDevolucion = $this->globales->motivoEstadoDispositivos('');
			$estadosSolicitud = $this->veriactivos->estadosSolicitud();
			
            $autorizado = in_array($this->items['idPerfil'], $this->veriactivos->perfilesAutorizadosArea()[$solicitud['AreaEncargada']]);
            
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Información de Solicitud | '.$idSolicitudReposicion,
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Información de Solicitud | '.$idSolicitudReposicion,
                'previo'                => 'solicitudes-reposicion',
				'solicitud'             => $solicitud,
				'motivosDevolucion'     => $motivosDevolucion,
				'estadosSolicitud'      => $estadosSolicitud,
				'autorizado'            => $autorizado,
				'timeline'              => $timeline
			);
			$data = array_merge($data, $this->items);

			return view('solicitudes/solicitudes_reposicion_informacion',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
	}
	
	public function modificarEstadoSolicitudReposicion($idSolicitudReposicion)
	{
	    $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $estado         = $this->request->getPost('txtEstadoSolicitudReposicion_i');
        $motivo         = $this->request->getPost('txtDescargoEvaluacion_i');
        $cobro          = $this->request->getPost('chkGeneraReposicion_i');
        //SI GENERA COBRO, SE USARÁN PARAMETROS ADICIONALES
        $motivoReposicion   = $this->request->getPost('txtMotivoReposicionReal');
        $tipoDescuento      = $this->request->getPost('rdbtnTipoDescuentoReposicion');
        $montoParcial       = $this->request->getPost('txtMontoParcialReposicion');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idSolicitudReposicion, 'required|trim|numeric', 'ID Solicitud Reposición');
        // $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[4]|maxlength[4]', 'Estado');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        $dataSolicitud = array (
            'UsuarioModifica'       => $this->items['id'],
            'Estado'                => $estado, 
            'UsuarioEstado'         => $this->items['id'],
            'IDDireccionEstado'     => $this->items['dpto'], 
            'IDSubareaEstado'       => $this->items['idSubarea'], 
            'IDAreaEstado'          => $this->items['idArea'], 
            'IDPerfilEstado'        => $this->items['idPerfil'],
            'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
            'IDCargoEstado'         => $this->items['idCargoLog'],
            'Localhost'             => $this->request->getIPAddress()
        );
        
        $infoSolicitud = $this->solicitudReposicion->obtenerSolicitudReposicion($idSolicitudReposicion);
        
        if($estado == 'RECI')
        {
            if($infoSolicitud['Estado'] != 'CREA')
            {
                $message = sprintf($this->mensajeError->msg201, "No se puede gestionar el cambio de estado. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
            else
            {
                $dataSolicitud['FechaModifica']  = $fechaActual;
                $dataSolicitud['FechaEstado']    = $fechaActual;
                $dataSolicitud['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Se recibió el elemento.";
                
                // $nuevaNotificacion['usuariodestino'] = $infoSolicitud['UsuarioCrea'];
                // $nuevaNotificacion['gtdestino'] = null;
                // $nuevaNotificacion['perfildestino'] = null;
                // $nuevaNotificacion['mensaje'] = "Se ha <span class='color-asig'>ASIGNADO</span> la petición #".$idPeticion.".";
            }
        }
        else if($estado == 'INIC')
        {
            if($infoSolicitud['Estado'] == 'COMP')
            {
                $message = sprintf($this->mensajeError->msg201, "No se puede gestionar el cambio de estado. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
            else if($infoSolicitud['Estado'] == 'CREA')
            {
                $dataSolicitudPrev = array (
                    'UsuarioModifica'       => $this->items['id'],
                    'FechaModifica'         => $fechaActual,
                    'Estado'                => 'RECI', 
                    'FechaEstado'           => $fechaActual,
                    'UsuarioEstado'         => $this->items['id'],
                    'IDSubareaEstado'       => $this->items['idSubarea'], 
                    'IDAreaEstado'          => $this->items['idArea'], 
                    'IDDireccionEstado'     => $this->items['dpto'], 
                    'IDPerfilEstado'        => $this->items['idPerfil'],
                    'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
                    'IDCargoEstado'         => $this->items['idCargoLog'],
                    'MotivoEstado'          => "Se recibió el elemento.",
                    'Localhost'             => $this->request->getIPAddress()
                );
                $lastIdPrev = $this->solicitudReposicion->update([$idSolicitudReposicion], $dataSolicitudPrev);
                
                if($lastIdPrev !== FALSE){
        			$dataSolicitud['FechaModifica']  = $fechaActualAdd;
                    $dataSolicitud['FechaEstado']    = $fechaActualAdd;
                    $dataSolicitud['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Evaluación de elemento iniciado.";
                    
                    // $nuevaNotificacion['usuariodestino'] = $infoSolicitud['UsuarioCrea'];
                    // $nuevaNotificacion['gtdestino'] = null;
                    // $nuevaNotificacion['perfildestino'] = null;
                    // $nuevaNotificacion['mensaje'] = "Se ha <span class='color-asig'>INICIADO LA GESTIÓN</span> de la petición #".$idPeticion.".";
        		}
        		else
        		{
        		    $message = sprintf($this->mensajeError->msg201, "No se puede gestionar la recepción del elemento. Inténtelo luego.[".$estado."]");
                    echo $this->alertas->alertaError($message);
        			exit;
        		}
            }
            else
            {
                $dataSolicitud['FechaModifica']  = $fechaActual;
                $dataSolicitud['FechaEstado']    = $fechaActual;
                $dataSolicitud['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Evaluación de elemento iniciado.";
                
                // $nuevaNotificacion['usuariodestino'] = $infoSolicitud['UsuarioCrea'];
                // $nuevaNotificacion['gtdestino'] = null;
                // $nuevaNotificacion['perfildestino'] = null;
                // $nuevaNotificacion['mensaje'] = "Se ha <span class='color-asig'>INICIADO LA GESTIÓN</span> de la petición #".$idPeticion.".";
            }
            
        }
        else if($estado == 'COMP')
        {
            if($infoSolicitud['Estado'] == 'INIC')
            {
                $dataSolicitud['FechaModifica']         = $fechaActual;
                $dataSolicitud['FechaEstado']           = $fechaActual;
                $dataSolicitud['MotivoEstado']          = $motivo != '' && $motivo != null ? $motivo : "Evaluación concluida.";
                $dataSolicitud['GeneraReposicion']      = $cobro != '' ? "Y" : "N";
                $dataSolicitud['DescargoEvaluacion']    = $motivo;
                
                if($cobro != '')
                {
                    $diaPlanilla = $this->globales->diaCortePlanilla();
            
                    $fechaPlanillaActual = date("Y-m-".$diaPlanilla);
                    $fechaEvaluarActual = date("Y-m-d");
                    
                    $timePlanilla = strtotime($fechaPlanillaActual);
                    $timeActual = strtotime($fechaEvaluarActual);
            
                    $mesInicioCuotas=0;
                    $anioInicioCuotas=0;
            
                    $mesActual = date("m");
                    $anioActual = date("Y");
            
                    if($timePlanilla >= $timeActual)
                    {
                        $mesInicioCuotas = date("m");
                        $anioInicioCuotas = date("Y");
                    }
                    else
                    {
                        if($mesActual == 12)
                        {
                            $mesInicioCuotas = 1;
                            $anioInicioCuotas = $anioActual +1 ;
                        }
                        else
                        {
                            $mesInicioCuotas = $mesActual + 1;
                            $anioInicioCuotas = $anioActual;
                        }
                    }
                        
                    /*
                    * ----------------------------
                    * INSERCIÓN DE DATOS REPOSICIÓN
                    * ----------------------------
                    */
                    
                    $datosAdjudicado = $this->usuarios->buscarUsuario($infoSolicitud['IDUsuarioAdjudicado']);
                    $tokenReposicion = $this->complementos->generar_string_aleatorio(15);
            
                    $dataReposicion = array (
                        'UsuarioAdjudicado'         => $infoSolicitud['IDUsuarioAdjudicado'], 
                        'CargoAdjudicado'           => $datosAdjudicado['Cargo'], 
                        'DireccionAdjudicado'       => $datosAdjudicado['IDDireccion'], 
                        'AreaAdjudicado'            => $datosAdjudicado['IDArea'], 
                        'SubareaAdjudicado'         => $datosAdjudicado['IDSubarea'], 
                        'DelegacionAdjudicado'      => $datosAdjudicado['IDDelegacion'], 
                        'TokenLinkFirma'            => $tokenReposicion, 
                        'LiberadoFirma'             => "Y",
                        'Motivo'                    => $motivoReposicion != '' && $motivoReposicion != null ? $motivoReposicion : $infoSolicitud['MotivoReposicion'],
                        'Observacion'               => $motivo,
                        'Cuotas'                    => "Y",
                        'UsuarioCrea'               => $this->items['id'],
                        'CargoCrea'                 => $this->items['cargo'],
                        'DireccionCrea'             => $this->items['dpto'],
                        'AreaCrea'                  => $this->items['idArea'],
                        'SubareaCrea'               => $this->items['idSubarea'],
                        'DelegacionCrea'            => $this->items['idDelegacionLog'],
                        'FechaCrea'                 => $fechaActual,    
                        'Localhost'                 => $this->request->getIPAddress()
                    );
                    
                    $lastIdReposicion = $this->reposiciones->insert($dataReposicion, TRUE);
                    
                    if($lastIdReposicion !== FALSE){
                        $idReposicion = $lastIdReposicion;
                    }
                    else
                    {
                        $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar el acta de la reposición. Inténtelo luego.</li>");
                        echo $this->alertas->alertaError($message);
                        EXIT;
                    }
            
                    $dataDetalle = array();
                    $totalSumaTrabajador = 0;
                    
                    $whereDetalle = array(
                        'IDDetalleAsignacion'   => $detalle,
                        'return'                => "row"
                    );
                    
                    $detalleAsignacion = $this->asignacionesDetalle->listarDetalleElementosAsignados($whereDetalle);
                    $dataReposicion = $this->informacionReposicionElemento($detalleAsignacion, $infoSolicitud['IDUsuarioAdjudicado'], ($motivoReposicion != '' && $motivoReposicion != null ? $motivoReposicion : $infoSolicitud['MotivoReposicion']), "");
                    
                    if($tipoDescuento == "TOTAL")
                    {
                        $totalDescuento     = !empty($dataReposicion) ? $dataReposicion['TOTALCAMBIO'] : 0 ;
                        $totalVerisure      = !empty($dataReposicion) ? $dataReposicion['VERISURE'] : 0 ;
                        $totalTrabajador    = !empty($dataReposicion) ? $dataReposicion['TRABAJADOR'] : 0 ;
                        
                        $cuotasTrabajador   = !empty($dataReposicion) ? $dataReposicion['TOTALCUOTAS'] : 1 ;
                        $bolsa              = !empty($dataReposicion) ? $dataReposicion['BOLSA'] : 'IT' ;
                    }
                    else
                    {
                        $totalDescuento = $montoParcial;
                        $totalVerisure = 0;
                        $totalTrabajador = $montoParcial;
                        
                        if($infoSolicitud['TipoElemento']=='ELEMENTOTRABAJO' || $infoSolicitud['TipoElemento']=='KITDEMO') 
                        {
                            $cuotasTrabajador = $this->veriactivos->rangoDescuentosKitDemo($totalTrabajador);
                            $bolsa = "URES";
                        }
                        else
                        {
                            $bolsa = "IT";
                        
                            if($infoSolicitud['TipoElemento']=='MOVIL') 
                            {
                                $cuotasTrabajador = $this->veriactivos->rangoDescuentosMoviles($totalTrabajador);
                            }
                            else if($infoSolicitud['TipoElemento']=='HARDWARE') 
                            {
                                $cuotasTrabajador = $this->veriactivos->rangoDescuentosHardware($totalTrabajador);
                            }
                        }
                    }
                    
                    $dataDetalle = array (
                        'IDReposicion'          => $idReposicion, 
                        'IDDetalleAsignacion'   => $infoSolicitud['IDDetalleAsignacion'], 
                        'TotalDescuento'        => $totalDescuento, 
                        'TotalVerisure'         => $totalVerisure, 
                        'TotalTrabajador'       => $totalTrabajador, 
                        'Observacion'           => $motivo, 
                        'TotalCuotas'           => $cuotasTrabajador,
                        'MesFacturacion'        => $mesInicioCuotas,
                        'AnioFacturacion'       => $anioInicioCuotas,
                        'Bolsa'                 => $bolsa,
                        'Cobrado'               => 'N',
                        'UsuarioCrea'           => $this->items['id'],
                        'FechaCrea'             => $fechaActual,    
                        'Localhost'             => $this->request->getIPAddress()
                    );
                    
                    $lastIdDetalleReposicion = $this->reposicionesDetalle->insert($dataDetalle, TRUE);
                    
                    if($lastIdDetalleReposicion === FALSE){
                        $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la reposición de un item. Inténtelo luego.[ARD]");
                        echo $this->alertas->alertaError($message);
                        exit;
                    } 
            
                    /*
                    * ----------------------------
                    * INSERCIÓN DE DATOS REPOSICIÓN - CRONOGRAMA DE PAGOS
                    * ----------------------------
                    */
                    
                    $dataCronogramaPago = array();
                    
                    $descuentoMensual = number_format(round($totalTrabajador / $cuotasTrabajador, 2), 2, '.', '');
            
                    for($i=1; $i<=$cuotasTrabajador;$i++)
                    {
                        if($i == ($cuotasTrabajador))
                        {
                            $montoCuota = ($totalTrabajador - (($cuotasTrabajador - 1)*$descuentoMensual));
                        }
                        else
                        {
                            $montoCuota = $descuentoMensual;
                        }
            
                        $dataCronogramaPago[] = array (
                            'IDDetalleReposicion'   => $lastIdDetalleReposicion, 
                            'NroCuota'              => $i, 
                            'MesCuota'              => $mesInicioCuotas, 
                            'AnioCuota'             => $anioInicioCuotas, 
                            'MontoCuota'            => $montoCuota, 
                            'Observacion'           => 'Cuota generada automáticamente', 
                            'UsuarioCrea'           => $this->items['id'],
                            'FechaCrea'             => $fechaActual,
                            'Estado'                => 'A',
                            'UsuarioEstado'         => $this->items['id'],
                            'FechaEstado'           => $fechaActual,
                            'Localhost'             => $this->request->getIPAddress()
                        );
            
                        $mesInicioCuotas++;
            
                        if($mesInicioCuotas > 12)
                        {
                            $mesInicioCuotas = 1;
                            $anioInicioCuotas = $anioInicioCuotas + 1;
                        }
                    }
                    
                    $lastIdCronograma = $this->reposicionesCronogramaPago->insertBatch($dataCronogramaPago);
                    
            		if($lastIdCronograma === FALSE){
                        $this->reposicionesDetalle->where('IDDetalleReposicion', $lastIdDetalleReposicion)->delete();
                        $message = sprintf($this->mensajeError->msg201, "No se pudo registrar un detalle de la reposición. Inténtelo luego.[INSERT]");
            			echo $this->alertas->alertaError($message);
            			exit;
            		} 
            
                    /*
                    * ----------------------------
                    * PREPARACIÓN DE CUERPO DE CORREO DE REPOSICIÓN
                    * ----------------------------
                    */
            
                    $arrayCuerpo = array(
                        "TITULO" => "ACTA DE REPOSICIÓN",
                        "ACTA" => "ACTA DE REPOSICIÓN",
                        "USUARIO" => ucwords(mb_strtolower($datosAdjudicado['Nombres'].' '.$datosAdjudicado['Apellidos'])),
                        "URL_ACTA" => base_url()."/acta-reposicion/".$idReposicion."/".$tokenReposicion
                    );
            
                    $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
                    
                    /*
                    * ----------------------------
                    * PREPARACIÓN DE PARAMETROS PARA EL CORREO
                    * ----------------------------
                    */
            
                    $asunto='ACTA DE REPOSICIÓN: '.$idReposicion.' - '.$datosAdjudicado['Nombres'].' '.$datosAdjudicado['Apellidos'];
                    //$correoDestino = array($asignado['Correo']);
                    $configCorreo = array(
                        "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                        "CORREO_ORIGEN" => $this->items['correoElectronico'],
                        "CORREOS_DESTINOS" => array($datosAdjudicado['Correo']),
                        "CORREOS_COPIA" => array("soporteit@verisure.pe", $this->items['correoElectronico']),
                        "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
                        // "CORREOS_DESTINOS" => array("josejesus.cuadros@verisure.pe"),
                        // "CORREOS_COPIA" => array(),
                        // "CORREOS_OCULTO" => array(),
                        "ASUNTO" => $asunto,
                        "MENSAJE" => $cuerpo
                    );
            
                    $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
            
                    $dataCorreo = array(
                        "IDReposicion"  => $idReposicion,
                        "Response"      => $estadoCorreo['RESPUESTA'],
                        "Error"         => $estadoCorreo['ERROR'],
                        'UsuarioCrea'   => $this->items['id'],
                        'FechaCrea'     => $fechaActual,    
                        'Localhost'     => $this->request->getIPAddress()
                    );
            
                    $this->correoStatusReposicion->insert($dataCorreo, TRUE);
                }
                
                // $nuevaNotificacion['usuariodestino'] = $infoSolicitud['UsuarioCrea'];
                // $nuevaNotificacion['gtdestino'] = null;
                // $nuevaNotificacion['perfildestino'] = null;
                // $nuevaNotificacion['mensaje'] = "Se encuentra <span class='color-espe'>EN ESPERA LA GESTIÓN</span> de la petición #".$idPeticion.".";
            }
            else
            {
                $message = sprintf($this->mensajeError->msg201, "No cuenta con estado previo autorizado para concluir la evaluación. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
        }
        
        $lastId = $this->solicitudReposicion->update([$idSolicitudReposicion], $dataSolicitud);

		if($lastId !== FALSE){
		    
		    /*
            * ----------------------------
            * INSERCIÓN DE NOTIFICACIÓN
            * ----------------------------
            */
            
            // if($estado != 'INIC')
            // {
            //     $this->insertarNotificacion($nuevaNotificacion);
            // }
		    
		    
			$message = sprintf($this->mensajeError->msg503, $idPeticion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
}