<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

class Reportes extends BaseController
{
	public function __construct(){
	    $this->usuarios = new \App\Models\UsuarioModel();
	    
        $this->legales = new \App\Models\LegalesModel();
        
        $this->divisas              = new \App\Models\DivisasModel();
        
        /* IT */
        $this->moviles                      = new \App\Models\IT\MovilesModel();
        $this->lineas                       = new \App\Models\IT\LineasModel();
        $this->contratos                    = new \App\Models\IT\LineasContratoModel();
        $this->hardware                     = new \App\Models\IT\HardwareModel();
        $this->tarjetasAcceso               = new \App\Models\IT\TarjetasAccesoModel();
        $this->accesorios                   = new \App\Models\IT\AccesoriosITModel();
	    
        /* CARGOS */
        $this->asignaciones         = new \App\Models\Cargos\AsignacionesModel();
        $this->asignacionesDetalle  = new \App\Models\Cargos\AsignacionesDetalleModel();
        
        $this->correoStatusAsignacion   = new \App\Models\Cargos\CorreoStatusAsignacionModel();
        
        /* CONFIGURACIÓN */
        $this->elementosDemo    = new \App\Models\Configuracion\ElementosDemoModel();
        $this->elementosTrabajo = new \App\Models\Configuracion\ElementosTrabajoModel();
        
        /* URES */
        $this->kitsDemo             = new \App\Models\URES\KitsDemoModel();
        $this->kitsTrabajo          = new \App\Models\URES\KitsTrabajoModel();
        
	}
	
	public function pruebasquery($valor1, $valor2)
	{
	    //Valido existencia de kit demo
	    $whereKitDemo = array(
	        'CodigoKitDemo' => $valor2
	    );
	    
	    $existenciaKitDemo = $this->kitsDemo->where($whereKitDemo)->countAllResults();
	    
	    if($existenciaKitDemo > 0)
	    {
	       // echo "<br>Si existe<br>";
	    }
	    else
	    {
	        echo "<br>NO existe<br>";
	       exit;
	    }
	    
	    //Valido asociación de kit demo con el usuario
	    //**USUARIO***/
		$whereUsuario = array (
			'Usuario' => $valor1,
// 			'Estado'  => "Activo"
		);
		
        $datosUsuario = $this->usuarios->where($whereUsuario)->first();

        if(!empty($datosUsuario))
        {
            $demoAsignado = $this->kitsDemo->obtenerKitDemoAsignadoUsuario($datosUsuario['IdUsuario']);
            
            if(empty($demoAsignado))
            {
                //Valido si kit está libre para asignar
                $disponible = $this->kitsDemo->listarKitDemoDisponibles($valor2);
                
                if(empty($disponible))
                {
                    echo "<br> El kit no se encuentra disponible";
                }
                else
                {
                    echo "<br> continua nueva asignación";
                }
            }
            else
            {
                if(in_array($valor2, array_column($demoAsignado, 'CodigoKitDemo')))
                {
                    echo "<br> El kit está asociado al usuario";
                }
                else
                {
                    echo "<br> El kit no está asociado al usuario";
                    exit;
                }
            }
            // var_dump($demoAsignado);
        }
        else
        {
            echo "No existe usuario";
        }
	}

	/**************************************************************************/
	
    /******************************** REPORTES ********************************/
    
	public function listarReporteActivosAsignados()
	{
	    if(isset($this->items['id']))
        {
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Reporte de Asignaciones | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Reporte de Asignaciones'
			);
			$data = array_merge($data, $this->items);
			return view('reportes/listar_reporte_asignaciones',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
	}
	
	public function reporteAsignacionesServerside()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR MÓVILES */
            $dataServerside = $this->asignaciones->listarReporteTotalAsignacionesServersideIT($this->request->getPost(), $adicionales);
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
	}
	
	public function exportarAsignadosCesados()
	{
	    $where = array(
            'Estado'   => "Cesado"
        );
        
        $listadoActivos = $this->asignaciones->listarReporteTotalAsignaciones($where);
        
        $filename = "Asignados-Cesados.csv";
        $writer = WriterEntityFactory::createCSVWriter();
        $writer->setFieldDelimiter(';');
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("Matrícula"),
            WriterEntityFactory::createCell("Usuario"),
            WriterEntityFactory::createCell("Nombre y Apellido"),
            WriterEntityFactory::createCell("Estado Usuario"),
            WriterEntityFactory::createCell("Subárea"),
            WriterEntityFactory::createCell("Área"),
            WriterEntityFactory::createCell("Dirección"),
            WriterEntityFactory::createCell("CC"),
            WriterEntityFactory::createCell("LN"),
            WriterEntityFactory::createCell("Elemento"),
            WriterEntityFactory::createCell("Tipo"),
            WriterEntityFactory::createCell("Marca"),
            WriterEntityFactory::createCell("Modelo"),
            WriterEntityFactory::createCell("Serie"),
            WriterEntityFactory::createCell("Tipo Asignación"),
            WriterEntityFactory::createCell("Código Asignación"),
            WriterEntityFactory::createCell("Fecha Asignación"),
            WriterEntityFactory::createCell("Fecha Cese")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listadoActivos as $key=>$item)
        {
            $fechaAsignacion = $item['Fecha de Asignación'] != '' && $item['Fecha de Asignación'] != null ? date("Y-m-d", strtotime($item['Fecha de Asignación'])) : "";
            $fechaCese = $item['Fecha Cese'] != '' && $item['Fecha Cese'] != null ? date("Y-m-d", strtotime($item['Fecha Cese'])) : "";
			$cells = [
                WriterEntityFactory::createCell($item['Matricula']),
                WriterEntityFactory::createCell($item['Usuario']),
                WriterEntityFactory::createCell($item['NOMBRE']),
                WriterEntityFactory::createCell($item['Estado_Usuario']),
                WriterEntityFactory::createCell($item['Subarea']),
                WriterEntityFactory::createCell($item['Area']),
                WriterEntityFactory::createCell($item['Direccion']),
                WriterEntityFactory::createCell($item['CC']),
                WriterEntityFactory::createCell($item['LN']),
                WriterEntityFactory::createCell($item['ELEMENTO']),
                WriterEntityFactory::createCell($item['TIPO']),
                WriterEntityFactory::createCell($item['MARCA']),
                WriterEntityFactory::createCell($item['MODELO']),
                WriterEntityFactory::createCell($item['SERIE']),
                WriterEntityFactory::createCell($item['Tipo de Asignación']),
                WriterEntityFactory::createCell($item['IDAsignacion']),
                WriterEntityFactory::createCell($fechaAsignacion),
                WriterEntityFactory::createCell($fechaCese),
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
        
	}
	
	public function informacionActivosUsuarios()
	{
    	if(isset($this->items['id']))
    	{
            $data = array (
				'session'                       => 'on',
				'titulo'                        => 'Activos de Usuario | Verisure',
				'breadcrumb'                    => $this->items['modulo'],
				'elementoSeleccionadoModulo'    => 'Listado de Activos del Usuario',
				'subtitulo'                     => "Listado",
				// 'previo'                        => "listar-ordenes-compra",
				'ordenCompra'                   => array(),
				'comprobantes'                  => array(),
				'pdfValidacion'                 => 0,
				'xmlValidacion'                 => 0
			);
			
			$data = array_merge($data, $this->items);
			return view('reportes/informacion_activos_usuario',$data);
		} else {
			return view('errors/500');
		}	
	}
	
	public function recargarReporteActivosTotal()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $adicionales = array();
    	    
            $simbolosMonedas    = array();
            $cambioMonedas      = array();
			
            $dataServerside = $this->asignaciones->listarReporteTotalAsignacionesServersideIT($this->request->getPost(), $adicionales);
            
            $listadoMonedas = $this->divisas->findAll();
            // Crear un array asociativo para acceder fácilmente a cada MONEDA por su nomenclatura
            $simbolosMonedas = [];
            $cambioMonedas = [];
            foreach ($listadoMonedas as $moneda) {
                $simbolosMonedas[$moneda['CodigoInternacional']] = $moneda['Simbolo'] ;
                $cambioMonedas[$moneda['CodigoInternacional']] = $moneda['ValorCambio'] ;
            }
            
            foreach($dataServerside["data"] as $key=>$item)
            {
                $costoReposicion = "S/ 0";
                
                if($item['ELEMENTO']=="LINEA")
                {
                    $costoReposicion = "S/ 1";
                }
                else if($item['ELEMENTO']=="MOVIL")
                {
                    $informacionMovil = $this->moviles->obtenerMovil($item['ID ELEMENTO']);
                    $contrato = $this->contratos->obtenerContratosXEquipo($item['ID ELEMENTO']);
                    
                    if($informacionMovil['EquipoStock'] == 'Y' || empty($contrato))
                    {
                        $fechaReferencia = $item['Fecha de Asignación'];
                        $contrato['Permanencia'] = 'Y';
                        $contrato['PrecioCompra'] = $informacionMovil['PrecioCompra'];
                        $contrato['MontoCuota'] = number_format(round($informacionMovil['PrecioCompra']/18, 8), 8, '.', '');
                        $contrato['DiaFacturacion'] = date("j", strtotime($fechaReferencia."- 1 days"));
                        $contrato['PeriodoPermanencia'] = '18';
                        $contrato['InicioContrato'] = date("Y-m-d", strtotime($fechaReferencia));
                    }
                    
                    if($informacionMovil['Descontinuado'] == 'Y')
                    {
                        $montoTotal = $informacionMovil['PrecioLista'];
                    }
                    else
                    {
                        $montoTotal = $this->veriactivos->calculoPenalidadMovil($contrato);
                    }
                    
                    $costoReposicion = "S/ ".$montoTotal;
                }
                else if($item['ELEMENTO']=="HARDWARE")
                {
                    $informacionHardware = $this->hardware->obtenerHardware($item['ID ELEMENTO']);
                    $montoReposicion = $informacionHardware['PrecioCompra'];
                    $valorCambio = $cambioMonedas[$informacionHardware['MonedaCompra']];
                    
                    //SI LA MONEDA ES OTRA QUE NO SEA PEN, DEBE REALIZARSE LA CONVERSIÓN Y AL RESULTADO SETEARLO COMO $montoTotal
                    
                    if($informacionHardware['MonedaCompra'] != 'PEN')
                    {
                        $montoTotal = number_format(round($montoReposicion * $valorCambio, 2), 2, '.', '');
                    }
                    else
                    {
                        $montoTotal = $montoReposicion;
                    }
                    
                    $costoReposicion = "S/ ".$montoTotal;
                }
                else if($item['ELEMENTO']=="TARJETA")
                {
                    $informacionTarjeta = $this->tarjetasAcceso->where("IDTarjetaAcceso", $item['ID ELEMENTO'])->first();
        
                    $costoReposicion = "S/ ".$informacionTarjeta['PrecioCompra'];
                }
                else if($item['ELEMENTO']=="KITDEMO")
                {
                    $informacionKit = $this->kitsDemo->obtenerItemKitDemo($item['ID ELEMENTO']);
                    $montoReposicion = $informacionKit['PrecioReposicion'];
                    $valorCambio = $cambioMonedas[$informacionKit['MonedaReposicion']];
                    
                    //SI LA MONEDA ES OTRA QUE NO SEA PEN, DEBE REALIZARSE LA CONVERSIÓN Y AL RESULTADO SETEARLO COMO $montoTotal
                    
                    if($informacionKit['MonedaReposicion'] != 'PEN' && $informacionKit['MonedaReposicion'] != '' && $informacionKit['MonedaReposicion'] != null)
                    {
                        $montoTotal = number_format(round($montoReposicion * $valorCambio, 2), 2, '.', '');
                    }
                    else
                    {
                        $montoTotal = $montoReposicion;
                    }
                    
                    $costoReposicion = "S/ ".$montoTotal;
                }
                else if($item['ELEMENTO']=="ACCESORIOIT")
                {
                    $informacionAccesorio = $this->accesorios->where("IDAccesorio", $item['ID ELEMENTO'])->first();
                    $montoReposicion = $item['Monto_Asignacion'];
                    $valorCambio = $item['Moneda_Asignacion'] != '' && $item['Moneda_Asignacion'] != null ? $cambioMonedas[$item['Moneda_Asignacion']] : $cambioMonedas["PEN"];
                    
                    //SI EL ACCESORIO GENERA COBRO, SE CALCULA EL MONTO TOTAL, SINO VALOR 0
                    if($informacionAccesorio['GeneraCobro'] == "Y")
                    {
                        //SI LA MONEDA ES OTRA QUE NO SEA PEN, DEBE REALIZARSE LA CONVERSIÓN Y AL RESULTADO SETEARLO COMO $montoTotal
                        
                        if($item['Moneda_Asignacion'] != 'PEN' && $item['Moneda_Asignacion'] != '' && $item['Moneda_Asignacion'] != null)
                        {
                            $montoTotal = number_format(round($montoReposicion * $valorCambio, 2), 2, '.', '');
                        }
                        else
                        {
                            $montoTotal = $montoReposicion;
                        }
                    }
                    else
                    {
                        $montoTotal = 0;
                    }
                    
                    $costoReposicion = "S/ ".$montoTotal;
                }
                
                $dataServerside["data"][$key]['CostoReposicion'] = $costoReposicion;
                
                $documento = "<a href='".base_url()."/detalle-acta-asignacion/".$item['IDAsignacion']."/".$item['TokenAsignacion']."' class='text-muted bg-sistema px-2 py-2' target='_blank'><i class='mdi mdi-open-in-new color-white' style='font-size: 15px;'></i></a>";
                $dataServerside["data"][$key]['Documento'] = $documento;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
        } 
    	else 
    	{
            $resultado = array(
				'descripcion' => 0,
			);
			echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
	}

	/**************************************************************************/
	
    /******************************* SIMULADOR ********************************/
    
    // public function simuladorReposicion()
//     {
//         if(isset($this->items['id']))
//         {
//             $simbolosMonedas    = array();
//             $cambioMonedas      = array();
			
// 			/* ACCIONES */
// 			$listaAsignaciones = $this->asignaciones->listarReporteTotalAsignacionesServersideIT($this->request->getPost(), $adicionales);
			
//             $listadoMonedas = $this->divisas->findAll();
//             // Crear un array asociativo para acceder fácilmente a cada MONEDA por su nomenclatura
//             $simbolosMonedas = [];
//             $cambioMonedas = [];
//             foreach ($listadoMonedas as $moneda) {
//                 $simbolosMonedas[$moneda['CodigoInternacional']] = $moneda['Simbolo'] ;
//                 $cambioMonedas[$moneda['CodigoInternacional']] = $moneda['ValorCambio'] ;
//             }
            
// 			foreach($listaAsignaciones as $key => $value)
// 			{
// 			    if($value["TIPO"]=="MOVIL")
//                 {
//                     $movil = $this->moviles->obtenerMovil($value["ID ELEMENTO"]);
//                     $contrato = $this->contratos->obtenerContratosXEquipo($value["ID ELEMENTO"]);
                    
//                     if($movil['EquipoStock'] == 'Y' || empty($contrato))
//                     {
//                         $fechaReferencia = $value['Fecha de Asignación'] != '' && $value['Fecha de Asignación'] != null && $value['Fecha de Asignación'] != "0000-00-00" ? $value['Fecha de Asignación'] : $value['FechaCreaAsignado'];
//                         // $fechaReferencia = "2024-02-16";
//                         $contrato['Permanencia'] = 'Y';
//                         $contrato['PrecioCompra'] = $movil['PrecioCompra'];
//                         $contrato['MontoCuota'] = number_format(round($movil['PrecioCompra']/18, 8), 8, '.', '');
//                         $contrato['DiaFacturacion'] = date("d", strtotime($fechaReferencia."- 1 days"));
//                         $contrato['PeriodoPermanencia'] = '18';
//                         $contrato['InicioContrato'] = date("Y-m-d", strtotime($fechaReferencia));
//                     }
                    
//                     if($movil['Descontinuado'] == 'Y')
//                     {
//                         $montoTotal = $movil['PrecioLista'];
//                     }
//                     else
//                     {
//                         $montoTotal = $this->veriactivos->calculoPenalidadMovil($contrato);
//                     }
                    
//                     $registrosRobo = $this->asignacionesDetalle->obtenerDispositivosRobadosUsuario($value['IdUsuario'],"MOVIL", "");
//                     $cantidadRobo = empty($registrosRobo) ? 0 : count($registrosRobo);
//                     $porcentajes = $this->veriactivos->calculoPorcentajeResponsabilidadMovil($cantidadRobo, $montoTotal, "ROB");
                    
//                     $totalDescuento = $montoTotal;
//                     $totalVerisure = $porcentajes['VERISURE'];
//                     $totalTrabajador = $porcentajes['TRABAJADOR'];
                
//                     // $cuotasTrabajador = $this->complementos->rangoDescuentosMoviles($totalTrabajador) ;
//                     // $bolsa = "IT";
//                 }
//                 else if($value["TIPO"]=="HARDWARE")
//                 {
//                     $informacionHardware = $this->hardware->obtenerHardware($value["ID ELEMENTO"]);
//                     $montoRepo = $informacionHardware['PrecioCompra'];
//                     $valorCambio = $cambioMonedas[$informacionHardware['MonedaCompra']];
                    
//                     //SI LA MONEDA ES OTRA QUE NO SEA PEN, DEBE REALIZARSE LA CONVERSIÓN Y AL RESULTADO SETEARLO COMO $montoTotal
                    
//                     if($informacionHardware['MonedaCompra'] != 'PEN')
//                     {
//                         $montoTotal = number_format(round($montoRepo * $valorCambio, 2), 2, '.', '');
//                     }
//                     else
//                     {
//                         $montoTotal = $montoRepo;
//                     }
                    
//                     $registrosRobo = $this->asignacionesDetalle->obtenerDispositivosRobadosUsuario($value['IdUsuario'],"HARDWARE", "");
//                     $cantidadRobo = empty($registrosRobo) ? "0" : count($registrosRobo);
//                     $porcentajes = $this->veriactivos->calculoPorcentajeResponsabilidadMovil($cantidadRobo, $montoTotal, "ROB");
                    
//                     $totalDescuento = $montoTotal;
//                     $totalVerisure = $porcentajes['VERISURE'];
//                     $totalTrabajador = $porcentajes['TRABAJADOR'];
                    
//                     // $cuotasTrabajador = $this->complementos->rangoDescuentosHardware($totalTrabajador) ;
//                     // $bolsa = "IT";
//                 }
//                 else
//                 {
//                     $totalDescuento = "NO APLICA";
//                     $totalVerisure = "NO APLICA";
//                     $totalTrabajador = "NO APLICA";
                    
//                 }
                
//                 $listaAsignaciones[$key]['CANTIDADROBO'] = $cantidadRobo;
//                 $listaAsignaciones[$key]['TOTAL'] = $totalDescuento;
//                 $listaAsignaciones[$key]['VERISURE'] = $totalVerisure;
//                 $listaAsignaciones[$key]['TRABAJADOR'] = $totalTrabajador;
// 			}

// 			$data = array (
// 				'session'               => 'on',
// 				'titulo'                => 'Simulador de Reposiciones | Verisure',
// 				'breadcrumb'            => $this->items['modulo'],
// 				'breadcrumb_alias'      => 'Simulador de Reposiciones',
// 				'listaAsignaciones'     => $listaAsignaciones
// 			);
// 			$data = array_merge($data, $this->items);
// 			return view('reportes/simulador_reposicion',$data);			
// 		} else {
// 			return view('errors/500');
// 		}
//     }
    
	/**************************************************************************/
	
}