<?php

namespace App\Controllers;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

class IT extends BaseController
{
	public function __construct(){
	    
		$this->usuarios = new \App\Models\UsuarioModel();
		
 		$this->regionPais           = new \App\Models\RegionPaisModel();
        $this->regionDepartamento   = new \App\Models\RegionDepartamentoModel();
        $this->regionProvincia      = new \App\Models\RegionProvinciaModel();
        $this->regionDistrito       = new \App\Models\RegionDistritoModel();
        
        $this->estructuraSubareas       = new \App\Models\EstructuraSubareaModel();
        $this->estructuraDelegaciones   = new \App\Models\EstructuraDelegacionModel();
        
        $this->divisas              = new \App\Models\DivisasModel();
        
        $this->legales              = new \App\Models\LegalesModel();
        
        $this->auditoria            = new \App\Models\AuditoriaModel();
        
        /* CONFIGURACIÓN */
        $this->planes       = new \App\Models\Configuracion\OperadoresPlanesModel();
        $this->dispositivos = new \App\Models\Configuracion\MarcasDispositivosModel();
        
        /* IT */
        $this->moviles                      = new \App\Models\IT\MovilesModel();
        $this->lineas                       = new \App\Models\IT\LineasModel();
        $this->contratos                    = new \App\Models\IT\LineasContratoModel();
        $this->hardware                     = new \App\Models\IT\HardwareModel();
        $this->tarjetasAcceso               = new \App\Models\IT\TarjetasAccesoModel();
        $this->tarjetasAccesoUbicaciones    = new \App\Models\IT\TarjetasAccesoUbicacionesModel();
        $this->tarjetasAccesoDirecciones    = new \App\Models\IT\TarjetasAccesoDireccionesModel();
        $this->accesorios                   = new \App\Models\IT\AccesoriosITModel();
        $this->accesoriosKardex             = new \App\Models\IT\AccesoriosITKardexModel();
        $this->accesoriosKardexDescargas    = new \App\Models\IT\AccesoriosITKardexDescargasModel();
        
        /* CARGOS */
        $this->asignaciones         = new \App\Models\Cargos\AsignacionesModel();
        $this->asignacionesDetalle  = new \App\Models\Cargos\AsignacionesDetalleModel();
	}

    /******************************** MÓVILES *********************************/
    
	public function listarMoviles()
	{
		if(isset($this->items['id']))
		{
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Móviles | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Móviles',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Listado de Móviles",
				'subtitulo'                 => 'Móviles'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('it/listar_moviles',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
	}
	
	public function movilesServerside()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR MÓVILES */
            $dataServerside = $this->moviles->listaGeneralViewMoviles($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
                if($value['Estado']=='ACT')
                {
                    $bg = "bg-success";
                }
                else if($value['Estado']=='AVE')
                {
                    $bg = "bg-warning";
                }
                else if($value['Estado']=='REP')
                {
                    $bg = "bg-primary";
                }
                else if($value['Estado']=='BAJ')
                {
                    $bg = "bg-danger";
                }
                
                if($value['IDAsignado'] != '' && $value['IDAsignado'] != null && $value['EstadoDevolucion'] != 'VALID')
                {
                    $bgAsignado = ($value['EstadoDevolucion'] == 'REGIS' ? 'bg-warning text-dark' : ($value['EstadoAsignado'] == 'Activo' ? 'bg-light text-dark' : 'bg-danger color-white'));
                    
                    $dataServerside["data"][$key]['MatriculaAsignado'] = $value['MatriculaAsignado'];
                    $dataServerside["data"][$key]['UsuarioAsignado'] = '<span class="badge '.$bgAsignado.' border-0">'.$value['UsuarioAsignado'].'</span>';
                    $dataServerside["data"][$key]['NombreAsignado'] = '<span class="badge '.$bgAsignado.' border-0">'.$value['NombreAsignado'].'</span>';
                }
                else
                {
                    $dataServerside["data"][$key]['MatriculaAsignado'] = "No Asignado";
                    $dataServerside["data"][$key]['UsuarioAsignado'] = "No Asignado";
                    $dataServerside["data"][$key]['NombreAsignado'] = "No Asignado";
                }
                
                $dataServerside["data"][$key]['EstadoMovil'] = "<span class='badge ".$bg." border-0'>".$this->globales->estadosMovil()[$value['Estado']]." | ".$this->globales->motivoEstadoMovil($value['Estado'])[$value['Situacion']]."</span>";
                $dataServerside["data"][$key]['FechaCompraMovil'] = date("d-m-Y", strtotime($value['FechaCompra']));
                $dataServerside["data"][$key]['EquipoStockMovil'] = '<span class="badge '.($value['EquipoStock'] == 'Y' ? 'bg-warning color-white' : 'bg-light text-dark').' border-0">'.($value['EquipoStock'] == 'Y' ? 'SI' : 'NO').'</span>';
                
                
                
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-movil" data-bs-target="#informacionMovil" data-form="#formInformacionMovil" data-id="'.$value['IDMovil'].'" data-accion="ver" id="ver-movil" data-tooltip="tooltip" title="Ver Móvil">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPMOBA", $this->items['permisos']) || in_array("UPMOFU", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-movil" data-bs-target="#informacionMovil" data-form="#formInformacionMovil" data-id="'.$value['IDMovil'].'" data-accion="'.(in_array("UPMOFU", $this->items['permisos']) ? "editar-full" : "editar-basic").'" id="editar-movil" data-tooltip="tooltip" title="Editar Móvil">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $acciones .= '<button class="badge bg-rosa border-0 p-2 mx-1 historico-asignaciones-moviles" data-bs-target="#mdlHistoricoAsignacionesMoviles" data-id="'.$value['IDMovil'].'" data-tooltip="tooltip" title="Ver Histórico de Asignaciones">
    				<i class="mdi mdi-timeline-clock align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
	}
	
    public function insertarMovil()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $modelo         = $this->request->getPost('txtModeloComercial_i');
        $proveedor      = $this->request->getPost('txtProveedor_i');
        $stock          = $this->request->getPost('chkEquipoStock_i');
        $imei           = $this->request->getPost('txtIMEI_i');
        $fechaCompra    = $this->request->getPost('txtFechaCompra_i');
        $precioCompra   = $this->request->getPost('txtPrecioCompra_i');
        $precioLista    = $this->request->getPost('txtPrecioLista_i');
        $estado         = $this->request->getPost('txtEstadoMovil_i');
        $situacion      = $this->request->getPost('txtMotivoMovil_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($modelo, 'required|trim', 'Modelo');
        $error .= $this->complementos->validaCampo($proveedor, 'required|trim|minlength[1]|maxlength[50]', 'Proveedor');
        $error .= $this->complementos->validaCampo($imei, 'required|trim|numeric|minlength[15]|maxlength[15]', 'IMEI');
        $error .= $this->complementos->validaCampo($fechaCompra, 'required|dateDos', 'Fecha Compra');
        $error .= $this->complementos->validaCampo($precioCompra, 'required|decimal|trim|minnumber[0]', 'Precio Compra');
        $error .= $this->complementos->validaCampo($precioLista, 'required|decimal|trim|minnumber[0]', 'Precio Lista');
        $error .= $this->complementos->validaCampo($estado, 'required', 'Estado');
        $error .= $this->complementos->validaCampo($situacion, 'required', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

		$imeiExistente = $this->moviles->where('IMEI', $imei)->findAll();

        if(count($imeiExistente)>0)
        {
            $message = sprintf($this->mensajeError->msg201, "<li>El IMEI ya fue registrado. [CAMPO] <small>IMEI</small></li>");
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * ARMADO DE REGISTRO PARA INSERCIÓN
        * ----------------------------
        */

        $data = array (
            'IDModelo'          => $modelo, 
            'Proveedor'         => ucfirst($proveedor), 
            'EquipoStock'       => $stock == '' ? 'N' : 'Y',
            'IMEI'              => $imei, 
            'FechaCompra'       => date("Y-m-d", strtotime($fechaCompra)), 
            'PrecioCompra'      => $precioCompra, 
            'PrecioLista'       => $precioLista, 
            'FechaEstado'       => $fechaActual,
            'UsuarioEstado'     => $this->items['id'],
            'Estado'            => $estado,  
            'Situacion'         => $situacion,
            'MotivoCambio'      => "Registro de equipo móvil.",  
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->moviles->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $imei.' '.$modelo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }  
	
	public function obtenerDatosMovil() 
	{
        if (isset($this->items['id'])) 
    	{
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idMovil = $this->request->getPost('idMovil');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idMovil, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosMovil = $this->moviles->obtenerMovil($idMovil);
    
    		if(!empty($datosMovil))
    		{
    			$resultado = array(
    				'idmovil'       => (string) $idMovil,
    				'marca'         => (string) $datosMovil['IDMarca'],
    				'modelo'        => (string) $datosMovil['IDModelo'],
    				'proveedor'     => (string) $datosMovil['Proveedor'],
    				'imei'          => (string) $datosMovil['IMEI'],
    				'fecha_compra'  => (string) $datosMovil['FechaCompra'],
    				'precio_compra' => (string) $datosMovil['PrecioCompra'],
    				'precio_lista'  => (string) $datosMovil['PrecioLista'],
    				'stock'         => (string) $datosMovil['EquipoStock']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
    	} 
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }	
	}
	
    public function modificarMovil($idMovil)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $marca          = $this->request->getPost('txtMarca_i');
        $modelo         = $this->request->getPost('txtModeloComercial_i');
        $proveedor      = $this->request->getPost('txtProveedor_i');
        $imei           = $this->request->getPost('txtIMEI_i');
        $fechaCompra    = $this->request->getPost('txtFechaCompra_i');
        $precioCompra   = $this->request->getPost('txtPrecioCompra_i');
        $precioLista    = $this->request->getPost('txtPrecioLista_i');
        $stock          = $this->request->getPost('chkEquipoStock_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($marca, 'trim', 'Marca');
        $error .= $this->complementos->validaCampo($modelo, 'trim', 'Modelo');
        $error .= $this->complementos->validaCampo($proveedor, 'required|trim', 'Proveedor');
        $error .= $this->complementos->validaCampo($precioCompra, 'required|decimal|trim|minnumber[0]', 'Precio Compra');
        $error .= $this->complementos->validaCampo($precioLista, 'required|decimal|trim|minnumber[0]', 'Precio Lista');

        if($imei != NULL)
        {
            $error .= $this->complementos->validaCampo($imei, 'required|trim|numeric|minlength[15]|maxlength[15]', 'IMEI');
        }

        if($fechaCompra != NULL)
        {
            $error .= $this->complementos->validaCampo($fechaCompra, 'required|trim|dateDos', 'Fecha de Compra');
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        $data = array (
            'IDModelo'          => $modelo, 
            'Proveedor'         => ucfirst($proveedor),
            'PrecioCompra'      => $precioCompra, 
            'PrecioLista'       => $precioLista, 
            'EquipoStock'       => $stock == '' ? 'N' : 'Y',
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        if($imei != NULL)
        {
            $data["IMEI"] = $imei;
        }

        if($fechaCompra != NULL)
        {
            $data["FechaCompra"] = $fechaCompra;
        }

        $lastId = $this->moviles->update([$idMovil], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idMovil );
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function obtenerEstadosMovil()
	{
        if (isset($this->items['id'])) 
    	{
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            $listadoEstados = $this->globales->estadosMovil();
            
            $estados=array();
    
    		if (!empty($listadoEstados)) 
    		{
                foreach ($listadoEstados as $key=>$value) 
                {
                    $estados[] = array(
    					'id' => (string) $key,
             	        'estado' => (string) $value,
                    );
                }
    
                $resultado = array(
    				'listadoEstados' => json_encode($estados)
    			);
            }
            else
            {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
    	} 
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}

    public function obtenerMotivoEstadoMovil()
    {
        if (isset($this->items['id'])) 
    	{
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            
    		$estado = $this->request->getPost('estado');
            $listadoMotivos = $this->globales->motivoEstadoMovil($estado);
    
            $motivos=array();
    
    		if (!empty($listadoMotivos)) {
                foreach ($listadoMotivos as $key=>$value) {
                    $motivos[] = array(
    					'id' => (string) $key,
             	        'text' => (string) $value
                    );
                }
    
                $resultado = array(
    				'listadoMotivos' => json_encode($motivos)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
    	} 
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
    public function exportarMovil($accion)
    {
        if (isset($this->items['id'])) 
    	{
            switch ($accion) {
                case 'noasignado':
                    $this->exportarMovilesNoAsignados();
                    break;
                default:
                    echo "No se encontró";
            }
    	}
    	else 
    	{
            echo "No hay sesión iniciada.";
        }
    }
    
    public function exportarMovilesNoAsignados()
    {
        $filtros = array('estado' => 'ACT', 'libre' => 'Y');
        $listadoMoviles = $this->moviles->listadoMoviles($filtros);
        
        $filename = "Móviles No Asignados.csv";
        $writer = WriterEntityFactory::createCSVWriter();
        $writer->setFieldDelimiter(';');
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("IMEI"),
            WriterEntityFactory::createCell("Marca"),
            WriterEntityFactory::createCell("Modelo")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listadoMoviles as $key=>$item)
        {
			$cells = [
                WriterEntityFactory::createCell($item['IMEI']),
                WriterEntityFactory::createCell($item['Marca']),
                WriterEntityFactory::createCell($item['Modelo'])
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
    }
    
    public function historicoAsignacionesMoviles()
    {
        $html = '';
        
        if (isset($this->items['id'])) 
    	{
            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idMovil    = $this->request->getPost('idMovil');
    		
    		/*
            * -------------
            * OBTENER INFORMACIÓN DE TABLA
            * -------------
            */
            
            $filtros = array(
                "TipoElemento"  => "MOVIL",
                "IDElemento"    => $idMovil
            );
            
    		$datosMovil = $this->moviles->obtenerMovil($idMovil);
            $historico = $this->asignacionesDetalle->listadoHistoricoAsignacioneElemento($filtros);
            
            $html .= '<h3 class="mb-3">Móvil</h3>
            <div class="card-text mb-3">
				<div class="form-group row">
					<div class="col-6">
						<label>Código</label>
						<input type="text" class="form-control" value="'.$idMovil.'" disabled>
					</div>
					<div class="col-6">
						<label>IMEI</label>
						<input type="text" class="form-control" value="'.$datosMovil['IMEI'].'" disabled>
					</div>
				</div>
			</div>
			<div class="card-text mb-3">
				<div class="form-group row">
					<div class="col-6">
						<label>Marca</label>
						<input type="text" class="form-control" value="'.$datosMovil['Marca'].'" disabled>
					</div>
					<div class="col-6">
						<label>Modelo</label>
						<input type="text" class="form-control" value="'.$datosMovil['Modelo'].'" disabled>
					</div>
				</div>
			</div>
			<hr>
			<h3 class="mb-3">Histórico de Asignaciones</h3>';
			
    		$html .= $this->estructuraHTMLHistoricoAsignacionElemento($historico);
    	} 
    	else 
    	{
            $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-10 col-10 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SESIÓN CERRADA</strong> - Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
        }
        
        echo $html;
    }

	/**************************************************************************/
	
    /********************************* LÍNEAS *********************************/
    
    public function listarLineas()
    {
		if(isset($this->items['id']))
		{
		    $data = array (
				'session'                   => 'on',
				'titulo'                    => 'Líneas | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Líneas',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Listado de Líneas",
				'subtitulo'                 => 'Líneas'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('it/listar_lineas',$data);
		} 
		else 
		{
			return view('errors/500');
		}
	}
	
	public function lineasServerside()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR LÍNEAS */
            $dataServerside = $this->lineas->listaGeneralViewLineas($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
                if($value['Estado_Linea']=='ACT')
                {
                    $bg = "bg-success";
                }
                else if($value['Estado_Linea']=='SUS')
                {
                    $bg = "bg-warning";
                }
                else if($value['Estado_Linea']=='BAJ')
                {
                    $bg = "bg-danger";
                }
                
                $dataServerside["data"][$key]['EstadoLinea'] = '<span class="badge '.$bg.' border-0">'.$this->globales->estadosLinea()[$value['Estado_Linea']].' | '.$this->globales->motivoEstadoLinea($value['Estado_Linea'])[$value['Situacion_Linea']].'</span>';
                
                if(empty($value['Operador']))
                {
                    $dataServerside["data"][$key]['Operador'] = '<span class="badge bg-info border-0">SIN OPERADOR</span>';
                }
                
                if(empty($value['Plan']))
                {
                    $dataServerside["data"][$key]['Operador'] = '<span class="badge bg-info border-0">SIN PLAN</span>';
                }
                
                if($value['Estado_Contrato'] != '')
                {
                    $dataServerside["data"][$key]['EstadoContrato'] = '<span class="badge '.($value['Estado_Contrato'] == "VIGENTE" ? "bg-secondary" : "bg-primary").' border-0">'.$value['Estado_Contrato'].'</span>';
                }
                else
                {
                    $dataServerside["data"][$key]['EstadoContrato'] = '<span class="badge bg-info border-0">SIN CONTRATO</span>';
                }
                
                if($value['IDAsignado'] != '' && $value['IDAsignado'] != null && $value['EstadoDevolucion'] != 'VALID')
                {
                    $bgAsignado = ($value['EstadoDevolucion'] == 'REGIS' ? 'bg-warning text-dark' : ($value['EstadoAsignado'] == 'Activo' ? 'bg-light text-dark' : 'bg-danger color-white'));
                    
                    $dataServerside["data"][$key]['MatriculaAsignado'] = $value['MatriculaAsignado'];
                    $dataServerside["data"][$key]['UsuarioAsignado'] = '<span class="badge '.$bgAsignado.' border-0">'.$value['UsuarioAsignado'].'</span>';
                    $dataServerside["data"][$key]['NombreAsignado'] = '<span class="badge '.$bgAsignado.' border-0">'.ucwords(mb_strtolower($value['NombreAsignado'])).'</span>';
                }
                else
                {
                    $dataServerside["data"][$key]['MatriculaAsignado'] = "No Asignado";
                    $dataServerside["data"][$key]['UsuarioAsignado'] = "No Asignado";
                    $dataServerside["data"][$key]['NombreAsignado'] = "No Asignado";
                }
                
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-linea" data-bs-target="#informacionLinea" data-form="#formInformacionLinea" data-id="'.$value['IDLinea'].'" data-accion="ver" id="ver-linea" data-tooltip="tooltip" title="Ver Línea">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDLIN", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-linea" data-bs-target="#informacionLinea" data-form="#formInformacionLinea" data-id="'.$value['IDLinea'].'" data-accion="editar" id="editar-linea" data-tooltip="tooltip" title="Editar Línea">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $acciones .= '<a href="'.$this->items['baseUrl'].'/contrato-linea/'.$value['IDLinea'].'" class="badge bg-sistema border-0 p-2 mx-1" data-tooltip="tooltip" title="Ver Contratos Asociados">
    				<i class="mdi mdi-file-document-edit-outline align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</a>';
    			
                $acciones .= '<button class="badge bg-rosa border-0 p-2 mx-1 historico-asignaciones-lineas" data-bs-target="#mdlHistoricoAsignacionesLineas" data-id="'.$value['IDLinea'].'" data-tooltip="tooltip" title="Ver Histórico de Asignaciones">
    				<i class="mdi mdi-timeline-clock align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
	}
	
	public function insertarLinea()
	{
	    $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError           = TRUE;
        
        //PARÁMETROS LÍNEA
        $numero             = $this->request->getPost('txtNumeroLinea_rl');
        $iccid              = $this->request->getPost('txtICCID_rl');
        $estadoLinea        = $this->request->getPost('txtEstadoLinea');
        $situacionLinea     = $this->request->getPost('txtMotivoLinea');
        
        //PARÁMETROS CONTRATO
        $idplan             = $this->request->getPost('txtPlan');
        $inicioContrato     = $this->request->getPost('txtInicioContrato');
        $diaFacturacion     = $this->request->getPost('txtDiaFacturacion');
        $periodo            = $this->request->getPost('txtPeriodoPermanencia');
        $cuotaEquipo        = $this->request->getPost('txtValorCuota');
        $estadoContrato     = $this->request->getPost('txtEstado_contrato');
        
        //PARÁMETROS MÓVIL
        $incluyeMovil       = $this->request->getPost('chkContratoMovil'); // on o vacio
        
        $modelo             = $this->request->getPost('txtModeloMovil_rl');
        $proveedor          = $this->request->getPost('txtProveedor_i');
        $imei               = $this->request->getPost('txtIMEI_i');
        $fechaCompra        = $this->request->getPost('txtFechaCompra_i');
        $precioCompra       = $this->request->getPost('txtPrecioCompra_i');
        $precioLista        = $this->request->getPost('txtPrecioLista_i');
        $equipoStock        = $this->request->getPost('chkEquipoStock_i');
        $estadoEquipo       = $this->request->getPost('txtEstadoMovil_rl');
        $situacionEquipo    = $this->request->getPost('txtMotivoMovil_rl');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        //VALIDACIONES LÍNEA
        $error .= $this->complementos->validaCampo($numero, 'required|trim|numeric|minlength[9]|maxlength[9]', 'Número');
        $error .= $this->complementos->validaCampo($iccid, 'trim|numeric|minlength[15]|maxlength[30]', 'ICCID');
        $error .= $this->complementos->validaCampo($estadoLinea, 'required', 'Estado');
        $error .= $this->complementos->validaCampo($situacionLinea, 'required', 'Situación');
        
        //VALIDACIONES CONTRATO
        $error .= $this->complementos->validaCampo($idplan, 'required|trim|numeric', 'IDPlan');
        $error .= $this->complementos->validaCampo($inicioContrato, 'required|dateDos', 'Inicio de contrato');
        $error .= $this->complementos->validaCampo($diaFacturacion, 'required|number|minnumber[1]|maxnumber[31]', 'Dia facturación');
        $error .= $this->complementos->validaCampo($periodo, 'required|trim', 'Permanencia');
        $error .= $this->complementos->validaCampo($cuotaEquipo, 'required|decimal|trim|minnumber[0]', 'Valor de Cuota');
        $error .= $this->complementos->validaCampo($estadoContrato, 'required', 'Estado Contrato');
        
        //VALIDACIONES MÓVIL
        if($incluyeMovil != '')
        {
            $error .= $this->complementos->validaCampo($modelo, 'required|trim|minlength[1]|maxlength[50]', 'Modelo');
            $error .= $this->complementos->validaCampo($proveedor, 'required|trim|minlength[1]|maxlength[50]', 'Proveedor');
            $error .= $this->complementos->validaCampo($imei, 'required|trim|numeric|minlength[15]|maxlength[15]', 'IMEI');
            $error .= $this->complementos->validaCampo($fechaCompra, 'required|dateDos', 'Fecha Compra');
            $error .= $this->complementos->validaCampo($precioCompra, 'required|decimal|trim|minnumber[0]', 'Precio Compra');
            $error .= $this->complementos->validaCampo($precioLista, 'required|decimal|trim|minnumber[0]', 'Precio Lista');
            $error .= $this->complementos->validaCampo($estadoEquipo, 'required', 'Estado Equipo');
            $error .= $this->complementos->validaCampo($situacionEquipo, 'required', 'Motivo Equipo');
        }
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA DE LÍNEA
        * ----------------------------
        */
        $msgExistencia = '';
        
		$iccidExistente = $this->lineas->where('ICCID', $iccid)->findAll();
		$numeroExistente = $this->lineas->where('Numero', $numero)->findAll();

        if($iccid != '' && count($iccidExistente)>0)
        {
            $msgExistencia .= "<li>El ICCID ya fue registrado. [CAMPO] <small>ICCID</small></li>";
        }

        if(count($numeroExistente)>0)
        {
            $msgExistencia .= "<li>El Número ya fue registrado. [CAMPO] <small>Número</small></li>";
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA DE MÓVIL
        * ----------------------------
        */
        
		$imeiExistente = $this->moviles->where('IMEI', $imei)->findAll();

        if(count($imeiExistente)>0)
        {
            $msgExistencia .= "<li>El IMEI ya fue registrado. [CAMPO] <small>IMEI</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE MÓVIL
        * ----------------------------
        */

        if($incluyeMovil != '')
        {
            $dataEquipo = array (
                'IDModelo'          => $modelo, 
                'Proveedor'         => ucfirst($proveedor), 
                'IMEI'              => $imei, 
                'FechaCompra'       => date("Y-m-d", strtotime($fechaCompra)), 
                'PrecioCompra'      => $precioCompra, 
                'PrecioLista'       => $precioLista, 
                'EquipoStock'       => $equipoStock != '' ? "Y" : "N",
                'FechaEstado'       => $fechaActual,
                'UsuarioEstado'     => $this->items['id'],
                'Estado'            => $estadoEquipo,  
                'Situacion'         => $situacionEquipo,
                'MotivoCambio'      => "Registro de equipo móvil.",  
                'UsuarioCrea'       => $this->items['id'],
                'FechaCrea'         => $fechaActual,    
                'Localhost'         => $this->request->getIPAddress()
            );

            $lastIdEquipo = $this->moviles->insert($dataEquipo, TRUE);
            
            if($lastIdEquipo !== FALSE){
                $idMovil = $lastIdEquipo;
            }
            else
            {
                $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al guardar el equipo. Inténtelo luego.</li>");
                echo $this->alertas->alertaError($message);
                EXIT;
            }
        }
        else
        {
            $idMovil = NULL;
        }
	    
        /*
        * ----------------------------
        * INSERCIÓN DE LÍNEA
        * ----------------------------
        */

        $data = array (
            'Numero'            => $numero, 
            'ICCID'             => $iccid, 
            'FechaEstado'       => $fechaActual,
            'UsuarioEstado'     => $this->items['id'],
            'Estado'            => $estadoLinea,  
            'Situacion'         => $situacionLinea,
            'MotivoCambio'      => "Registro de línea.",  
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastIdLinea = $this->lineas->insert($data, TRUE);

		if($lastIdLinea !== FALSE)
		{
		    $idLinea = $lastIdLinea;
		}
		else   
		{
		    if($idMovil != NULL)
		    {
		        $this->moviles->where('IDMovil', $idMovil)->delete();
		    }
		    
		    $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al guardar la línea. Inténtelo luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
		}
		
        /*
        * ----------------------------
        * INSERCIÓN DE CONTRATO
        * ----------------------------
        */
        
        $dataContrato = array (
            'IDLinea'           => $idLinea, 
            'IDPlan'            => $idplan,  
            'InicioContrato'    => date("Y-m-d", strtotime($inicioContrato)), 
            'DiaFacturacion'    => $diaFacturacion, 
            'Permanencia'       => ($periodo == 'SP' ? 'N' : 'Y'), 
            'PeriodoPermanencia'=> $periodo, 
            'EquipoAsociado'    => $idMovil,
            'MontoCuota'        => $cuotaEquipo,
            'FechaEstado'       => $fechaActual,
            'UsuarioEstado'     => $this->items['id'],
            'Estado'            => $estadoContrato,
            'MotivoCambio'      => "Registro de contrato.",  
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->contratos->insert($dataContrato, TRUE);
        
		if($lastId !== FALSE)
		{
			$message = sprintf($this->mensajeError->msg201, "Se registró con éxito la línea.");
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosLinea()
	{
	    if (isset($this->items['id'])) 
    	{
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idLinea = $this->request->getPost('idLinea');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idLinea, 'trim', 'ID');
    
    		if ($error != '') 
    		{
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosLinea = $this->lineas->where("IDLinea",$idLinea)->first();
    
    		if(!empty($datosLinea))
    		{
    			$resultado = array(
    				'idlinea'   => (string) $idLinea,
    				'numero'    => (string) $datosLinea['Numero'],
    				'iccid'     => (string) $datosLinea['ICCID']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
	public function modificarLinea($idLinea)
	{
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $numero = $this->request->getPost('txtNumero');
        $iccid  = $this->request->getPost('txtICCID');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($numero, 'required|trim|numeric|minlength[9]|maxlength[9]', 'Número');
        $error .= $this->complementos->validaCampo($iccid, 'trim|numeric|minlength[15]|maxlength[30]', 'ICCID');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */
        
        $msgExistencia = '';
        
		$iccidExistente = $this->lineas->where('ICCID', $iccid)->whereNotIn("IDLinea", array($idLinea))->findAll();
		$numeroExistente = $this->lineas->where('Numero', $numero)->whereNotIn("IDLinea", array($idLinea))->findAll();

        if($iccid != '' && count($iccidExistente)>0)
        {
            $msgExistencia .= "<li>El ICCID ya fue registrado. [CAMPO] <small>ICCID</small></li>";
        }

        if(count($numeroExistente)>0)
        {
            $msgExistencia .= "<li>El Número ya fue registrado. [CAMPO] <small>Número</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        $data = array (
            'Numero'            => $numero, 
            'ICCID'             => $iccid, 
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->lineas->update([$idLinea], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idLinea);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
	
	public function obtenerEstadosLinea()
	{
	    if (isset($this->items['id'])) 
    	{
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            $listadoEstados = $this->globales->estadosLinea();
            
            $estados=array();
    
    		if (!empty($listadoEstados)) 
    		{
                foreach ($listadoEstados as $key=>$value) 
                {
                    $estados[] = array(
    					'id'    => (string) $key,
             	        'text'  => (string) $value,
                    );
                }
    
                $resultado = array(
    				'listadoEstados' => json_encode($estados)
    			);
            } 
            else 
            {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado);
    	}
        else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
	public function obtenerMotivoEstadoLinea()
	{
	    if (isset($this->items['id'])) 
    	{
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            
    		$estado = $this->request->getPost('estado');
            $listadoMotivos = $this->globales->motivoEstadoLinea($estado);
    
            $motivos=array();
    
    		if (!empty($listadoMotivos)) 
    		{
                foreach ($listadoMotivos as $key=>$value) 
                {
                    $motivos[] = array(
    					'id' => (string) $key,
             	        'motivo' => (string) $value
                    );
                }
    
                $resultado = array(
    				'listadoMotivos' => json_encode($motivos)
    			);
            } 
            else 
            {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
	public function exportarLinea($accion)
    {
        if (isset($this->items['id'])) 
    	{
            switch ($accion) {
                case 'noasignado':
                    $this->exportarLineasNoAsignados();
                    break;
                default:
                    echo "No se encontró";
            }
    	}
    	else 
    	{
            echo "No hay sesión iniciada.";
        }
    }
    
    public function exportarLineasNoAsignados()
    {
        $filtros = array('estado' => 'ACT', 'libre' => 'Y');
        $listadoLineas = $this->lineas->listadoLineas($filtros);
        
        $filename = "Líneas No Asignadas.csv";
        $writer = WriterEntityFactory::createCSVWriter();
        $writer->setFieldDelimiter(';');
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("Línea"),
            WriterEntityFactory::createCell("ICCID"),
            WriterEntityFactory::createCell("Operador"),
            WriterEntityFactory::createCell("Plan")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listadoLineas as $key=>$item)
        {
			$cells = [
                WriterEntityFactory::createCell($item['Numero']),
                WriterEntityFactory::createCell($item['ICCID']),
                WriterEntityFactory::createCell($item['Operador']),
                WriterEntityFactory::createCell($item['Plan'])
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
    }
	
    public function importarCSVLinea()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("itemsFile");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) 
        {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'itemsFile' => [
                'mime_in[itemsFile,text/csv,text/plain]',
                'ext_in[itemsFile,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 22);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        $lineasCSV = array();
        $iccidCSV = array();
        $imeiCSV = array();
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $linea              = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $iccid              = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $plan               = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $inicioContrato     = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $diaFacturacion     = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $permanencia        = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                $modelo             = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
                $imei               = trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
                $fechaCompra        = trim($data[11]," \t\n\r\0\x0B\xc2\xa0");
                $precioCompra       = trim($data[12]," \t\n\r\0\x0B\xc2\xa0");
                $precioLista        = trim($data[13]," \t\n\r\0\x0B\xc2\xa0");
                $usuario            = trim($data[14]," \t\n\r\0\x0B\xc2\xa0");
                $fechaAsignacion    = trim($data[17]," \t\n\r\0\x0B\xc2\xa0");
                
                //Validamos Línea
                if($linea == null || $linea == '')
                {
                    $filasError[$fila]['LINEA'] = "LA LÍNEA ES OBLIGATORIA.";
                    $ejecutarInsert = false;
                }
                else
                {
                    if(!is_numeric($linea))
                    {
                        $filasError[$fila]['LINEA'] = "LA LÍNEA NO ES UN NÚMERO.";
                        $ejecutarInsert = false;
                    }
                    
                    if(in_array($linea, $lineasCSV))
                    {
                        $filasError[$fila]['LINEA'] = "LA LÍNEA SE ENCUENTRA REPETIDA EN EL CSV.";
                        $ejecutarInsert = false;
                    }
                    
                    //Validamos existencia de Linea:
                    $datosLinea = $this->lineas->where("Numero",trim($linea))->first();
                    if(!empty($datosLinea))
                    {
                        $filasError[$fila]['LINEA'] = "LA LÍNEA YA FUE REGISTRADA.";
                        $ejecutarInsert = false;
                    }
                    
                    $lineasCSV[] = $linea;
                }

                //Validamos ICCID
                if($iccid == null || $iccid == '')
                {
                    $filasError[$fila]['ICCID'] = "EL ICCID ES OBLIGATORIO.";
                    $ejecutarInsert = false;
                }
                else
                {
                    if(!is_numeric($iccid))
                    {
                        $filasError[$fila]['ICCID'] = "EL ICCID NO ES UN NÚMERO.";
                        $ejecutarInsert = false;
                    }
                    
                    if(in_array($iccid, $iccidCSV))
                    {
                        $filasError[$fila]['ICCID'] = "EL ICCID SE ENCUENTRA REPETIDO EN EL CSV.";
                        $ejecutarInsert = false;
                    }
                    
                    //Validamos existencia de ICCID:
                    $datosiccid = $this->lineas->where("ICCID",trim($iccid))->first();
                    if(!empty($datosiccid))
                    {
                        $filasError[$fila]['ICCID'] = "EL ICCID YA FUE REGISTRADO.";
                        $ejecutarInsert = false;
                    }
                    
                    $iccidCSV[] = $iccid;
                }
                
                //Validamos Plan
                if($plan == null || $plan == '')
                {
                    $filasError[$fila]['PLAN'] = "EL PLAN ES OBLIGATORIO.";
                    $ejecutarInsert = false;
                }
                else
                {
                    //Validamos existencia de Plan:
                    $datosPlan = $this->planes->where("Plan", trim($plan))->first();
                    if(empty($datosPlan))
                    {
                        $filasError[$fila]['PLAN'] = "EL PLAN NO EXISTE.";
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos Fecha Inicio Contrato
                if($inicioContrato == '' || $inicioContrato == null)
                {
                    $filasError[$fila]['INICIO CONTRATO'] = "EL INICIO DE CONTRATO ES OBLIGATORIO.";
                    $ejecutarInsert = false;
                }
                
                //Validamos Permanencia
                if($permanencia == '' || $permanencia == null)
                {
                    $filasError[$fila]['PERMANENCIA'] = "LA PERMANENCIA ES OBLIGATORIA.";
                    $ejecutarInsert = false;
                }
                
                //Validamos Modelo
                if($modelo != '' && $modelo != null)
                {
                    //Validamos existencia de Modelo:
                    $datosDispositivos = $this->dispositivos->where("Modelo", trim($modelo))->first();
                    if(empty($datosDispositivos))
                    {
                        $filasError[$fila]['MODELO'] = "MODELO NO EXISTE";
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos IMEI
                if($imei != null && $imei != '')
                {
                    if(!is_numeric($imei))
                    {
                        $filasError[$fila]['IMEI'] = "EL IMEI DEBE SER UN NÚMERO.";
                        $ejecutarInsert = false;
                    }
                    
                    //Validamos existencia de IMEI:
                    $datosImei = $this->moviles->where('IMEI', trim($imei))->first();
                    
                    if(!empty($datosImei))
                    {
                        $filasError[$fila]['IMEI'] = "IMEI EXISTENTE";
                        $ejecutarInsert = false;
                    }
                    
                    if(in_array($imei, $imeiCSV))
                    {
                        $filasError[$fila]['IMEI'] = "EL IMEI SE ENCUENTRA REPETIDO EN EL CSV.";
                        $ejecutarInsert = false;
                    }
                    
                    $imeiCSV[] = $imei;
                }
                
                //Validamos Fecha de compra
                if($modelo != '' && $modelo != null)
                {
                    if($fechaCompra == '' || $fechaCompra == null)
                    {
                        $filasError[$fila]['FECHA COMPRA'] = "LA FECHA DE COMPRA ES OBLIGATORIA.";
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos Precio de compra
                if($modelo != '' && $modelo != null)
                {
                    if($precioCompra == '' || $precioCompra == null)
                    {
                        $filasError[$fila]['PRECIO COMPRA'] = "EL PRECIO DE COMPRA ES OBLIGATORIA.";
                        $ejecutarInsert = false;
                    }
                }

                //Validamos Precio de lista
                if($modelo != '' && $modelo != null)
                {
                    if($precioLista == '' || $precioLista == null)
                    {
                        $filasError[$fila]['PRECIO LISTA'] = "EL PRECIO DE LISTA ES OBLIGATORIA.";
                        $ejecutarInsert = false;
                    }
                }

                //Validamos usuario correcto:
                if($usuario != '' && $usuario != null)
                {
                    $datosUsuario = $this->usuarios->buscarUsuarioXusuario($usuario);

                    if(empty($datosUsuario))
                    {
                        $filasError[$fila]['USUARIO'] = "USUARIO NO VÁLIDO: ".$usuario;
                        $ejecutarInsert = false;
                    }
                    else
                    {
                        if($datosUsuario['Cargo'] == '' || $datosUsuario['Cargo'] == null)
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE EL CARGO/PUESTO ACTUALIZADO: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['IDArea'] == '' || $datosUsuario['IDArea'] == null)
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE EL ÁREA DEPARTAMENTAL ACTUALIZADA: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['IDDireccion'] == '' || $datosUsuario['IDDireccion'] == null )
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE LA DIRECCIÓN DEPARTAMENTAL ACTUALIZADA: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['IDDelegacion'] == '' || $datosUsuario['IDDelegacion'] == null )
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE LA DELEGACIÓN ACTUALIZADA: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['Estado'] == 'Cesado' )
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO SE ENCUENTRA CESADO: ".$usuario;
                            $ejecutarInsert = false;
                        }
                    }
                }
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = $this->items['basePublic'].'/';
            $nombre = 'error.txt';
            $file = $this->items['basePublic'].'/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayLineaInsert = array();
        $arrayContratoInsert = array();
        $arrayEquipoInsert = array();
        $arrayAsignacionInsert = array();
        $arrayAsignacionDetalleInsert = array();
        $filainsert = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $filainsert++;
            if($filainsert > 1)
            {
                $a = trim($data[3]);
                //Asignamos valores de CSV a variables locales
                $linea                  = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $iccid                  = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $plan                   = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $inicioContrato         = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $diaFacturacion         = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $periodo                = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                $cuotaEquipo            = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                $equipoStock            = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                $modelo                 = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
                $proveedor              = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
                $imei                   = trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
                $fechaCompra            = trim($data[11]," \t\n\r\0\x0B\xc2\xa0");
                $precioCompra           = trim($data[12]," \t\n\r\0\x0B\xc2\xa0");
                $precioLista            = trim($data[13]," \t\n\r\0\x0B\xc2\xa0");
                $asignado               = trim($data[14]," \t\n\r\0\x0B\xc2\xa0");
                $tipoasignado           = trim($data[15]," \t\n\r\0\x0B\xc2\xa0");
                $observacionasignado    = trim($data[16]," \t\n\r\0\x0B\xc2\xa0");
                $fechaasignado          = trim($data[17]," \t\n\r\0\x0B\xc2\xa0");
                $obslinea               = trim($data[18]," \t\n\r\0\x0B\xc2\xa0");
                $obsmovil               = trim($data[19]," \t\n\r\0\x0B\xc2\xa0");
                $repolinea              = trim($data[20]," \t\n\r\0\x0B\xc2\xa0");
                $repomovil              = trim($data[21]," \t\n\r\0\x0B\xc2\xa0");

                //Armar array de Linea e insertar datos:
                $dataLinea = array (
                    'Numero'            => $linea, 
                    'ICCID'             => $iccid, 
                    'FechaEstado'       => $fechaActual,
                    'UsuarioEstado'     => $this->items['id'],
                    'Estado'            => 'ACT',  
                    'Situacion'         => 'NUE',
                    'MotivoCambio'      => "Registro de línea.",  
                    'UsuarioCrea'       => $this->items['id'],
                    'FechaCrea'         => $fechaActual,    
                    'Localhost'         => $this->request->getIPAddress()
                );

                $lastIdLinea = $this->lineas->insert($dataLinea, TRUE);
                
                if($lastIdLinea === FALSE){
                    //Eliminar registros previos
                    if(!empty($arrayLineaInsert))
                    {
                        $this->lineas->whereIn('IDLinea', $arrayLineaInsert)->delete();
                    }
                    
                    if(!empty($arrayEquipoInsert))
                    {
                        $this->moviles->whereIn('IDMovil', $arrayEquipoInsert)->delete();
                    }
                    
                    if(!empty($arrayContratoInsert))
                    {
                        $this->contratos->whereIn('IDContrato', $arrayContratoInsert)->delete();
                    }
                    
                    if(!empty($arrayAsignacionInsert))
                    {
                        $this->asignaciones->whereIn('IDAsignacion', $arrayAsignacionInsert)->delete();
                        $this->detalleasignaciones->whereIn('IDAsignacion', $arrayAsignacionInsert)->delete();
                    }
                    
                    $message = sprintf($this->mensajeError->msg201, "No se pudo insertar los registros solicitados. Inténtelo luego<LINEA>.".$filainsert);
                    echo $this->alertas->alertaError($message);
                    echo $this->alertas->refrescar(1);
                    exit;
                }

                $arrayLineaInsert[] = $lastIdLinea;

                //Armar array de Movil e insertar datos:

                if($imei != '' && $imei != null)
                {
                    $detectaFormatoFC = strpos($fechaCompra, "/");
                        
                    if($detectaFormatoFC === false)
                    {
                        $fechaCompra = date("Y-m-d", strtotime($fechaCompra));
                    }
                    else
                    {
                        $fechaCompra_e = $this->complementos->myUrlEncode($fechaCompra);
                        $fechaCompra = date('Y-m-d', strtotime(str_replace('/', '-', $fechaCompra_e)));
                    }
                    
                    $datosDispositivos = $this->dispositivos->where("Modelo", trim($modelo))->first();

                    $dataMovil = array (
                        'IDModelo'          => $datosDispositivos['IDDispositivo'], 
                        'Proveedor'         => ucfirst($proveedor), 
                        'IMEI'              => $imei, 
                        'FechaCompra'       => $fechaCompra, 
                        'PrecioCompra'      => $precioCompra, 
                        'PrecioLista'       => $precioLista, 
                        'EquipoStock'       => $equipoStock == 'Y' ? "Y" : "N",
                        'FechaEstado'       => $fechaActual,
                        'UsuarioEstado'     => $this->items['id'],
                        'Estado'            => "ACT",  
                        'Situacion'         => "NUE",
                        'MotivoCambio'      => "Registro de equipo móvil.",  
                        'UsuarioCrea'       => $this->items['id'],
                        'FechaCrea'         => $fechaActual,    
                        'Localhost'         => $this->request->getIPAddress()
                    );

                    $lastIdMovil = $this->moviles->insert($dataMovil, TRUE);

                    if($lastIdMovil === FALSE){
                        //Eliminar registros previos
                        if(!empty($arrayLineaInsert))
                        {
                            $this->lineas->whereIn('IDLinea', $arrayLineaInsert)->delete();
                        }
                        
                        if(!empty($arrayEquipoInsert))
                        {
                            $this->moviles->whereIn('IDMovil', $arrayEquipoInsert)->delete();
                        }
                        
                        if(!empty($arrayContratoInsert))
                        {
                            $this->contratos->whereIn('IDContrato', $arrayContratoInsert)->delete();
                        }
                        
                        if(!empty($arrayAsignacionInsert))
                        {
                            $this->asignaciones->whereIn('IDAsignacion', $arrayAsignacionInsert)->delete();
                            $this->detalleasignaciones->whereIn('IDAsignacion', $arrayAsignacionInsert)->delete();
                        }
                        
                        $message = sprintf($this->mensajeError->msg201, "No se pudo insertar los registros solicitados. Inténtelo luego.<MOVIL>".$filainsert);
                        echo $this->alertas->alertaError($message);
                        echo $this->alertas->refrescar(1);
                        exit;
                    }
                    $arrayEquipoInsert[] = $lastIdMovil;
                }
                else
                {
                    $lastIdMovil = null;
                }
                    
                if($plan != '' && $plan != null)
                {
                    $detectaFormatoIC = strpos($inicioContrato, "/");
                        
                    if($detectaFormatoIC === false)
                    {
                        $inicioContrato = date("Y-m-d", strtotime($inicioContrato));
                    }
                    else
                    {
                        $inicioContrato_e = $this->complementos->myUrlEncode($inicioContrato);
                        $inicioContrato = date('Y-m-d', strtotime(str_replace('/', '-', $inicioContrato_e)));
                    }
                    
                    //Armar array de Contrato e insertar datos:
                    $datosPlan = $this->planes->where("Plan", trim($plan))->first();
                    $dataContrato = array (
                        'IDLinea'           => $lastIdLinea, 
                        'IDPlan'            => $datosPlan['IDPlan'],  
                        'InicioContrato'    => $inicioContrato, 
                        'DiaFacturacion'    => $diaFacturacion, 
                        'Permanencia'       => ($periodo == 'SP' ? 'N' : 'Y'), 
                        'PeriodoPermanencia'=> $periodo, 
                        'EquipoAsociado'    => $lastIdMovil,
                        'MontoCuota'        => $cuotaEquipo,
                        'FechaEstado'       => $fechaActual,
                        'UsuarioEstado'     => $this->items['id'],
                        'Estado'            => 'VIGENTE',
                        'MotivoCambio'      => "Registro de contrato.",  
                        'UsuarioCrea'       => $this->items['id'],
                        'FechaCrea'         => $fechaActual,    
                        'Localhost'         => $this->request->getIPAddress()
                    );
            
                    $lastIdContrato = $this->contratos->insert($dataContrato, TRUE);
                    
                    if($lastIdContrato === FALSE){
                        //Eliminar registros previos
                        if(!empty($arrayLineaInsert))
                        {
                            $this->lineas->whereIn('IDLinea', $arrayLineaInsert)->delete();
                        }
                        
                        if(!empty($arrayEquipoInsert))
                        {
                            $this->moviles->whereIn('IDMovil', $arrayEquipoInsert)->delete();
                        }
                        
                        if(!empty($arrayContratoInsert))
                        {
                            $this->contratos->whereIn('IDContrato', $arrayContratoInsert)->delete();
                        }
                        
                        if(!empty($arrayAsignacionInsert))
                        {
                            $this->asignaciones->whereIn('IDAsignacion', $arrayAsignacionInsert)->delete();
                            $this->detalleasignaciones->whereIn('IDAsignacion', $arrayAsignacionInsert)->delete();
                        }
                        
                        $message = sprintf($this->mensajeError->msg201, "No se pudo insertar los registros solicitados. Inténtelo luego.<CONTRATO>".$filainsert);
                        echo $this->alertas->alertaError($message);
                        echo $this->alertas->refrescar(1);
                        exit;
                    }
                    $arrayContratoInsert[] = $lastIdContrato;
                }
                    
                //Validamos usuario correcto:
                if($asignado != '' && $asignado != null)
                {
                    $detectaFormatoFA = strpos($fechaasignado, "/");
                        
                    if($detectaFormatoFA === false)
                    {
                        $fechaasignado = date("Y-m-d", strtotime($fechaasignado));
                    }
                    else
                    {
                        $fechaasignado_e = $this->complementos->myUrlEncode($fechaasignado);
                        $fechaasignado = date('Y-m-d', strtotime(str_replace('/', '-', $fechaasignado_e)));
                    }
                    
                    //Armar array de Asignaciones e insertar datos:
                    $datosUsuario = $this->usuarios->buscarUsuarioXusuario($asignado);
                    
                    $textoLegal = '';
                    
                    $infolegales = $this->legales->buscarLegalXactaXelementos("ASIGNACIÓN", array("LINEA", "MOVIL"));
                    
                    if(!empty($infolegales))
                    {
                        foreach($infolegales as $key=>$value)
                        {
                            $textoLegal.=$value['Titulo'];
                            $textoLegal.="\n";
                            $textoLegal.=$value['Texto'];
                            $textoLegal.="\n";
                        }
                    }
                    
                    $dataAsignacion = array (
                        'UsuarioAsignado'       => $datosUsuario['IdUsuario'], 
                        'CargoAsignado'         => $datosUsuario['Cargo'], 
                        'DireccionAsignado'     => $datosUsuario['IDDireccion'], 
                        'AreaAsignado'          => $datosUsuario['IDArea'], 
                        'SubareaAsignado'       => $datosUsuario['IDSubarea'], 
                        'DelegacionAsignado'    => $datosUsuario['IDDelegacion'], 
                        'FechaAsignado'         => $fechaasignado, 
                        'TipoAsignado'          => $tipoasignado, 
                        'Observacion'           => $observacionasignado, 
                        'UsuarioRemitente'      => $this->items['id'], 
                        'CargoRemitente'        => $this->items['cargo'], 
                        'DireccionRemitente'    => $this->items['dpto'], 
                        'AreaRemitente'         => $this->items['idArea'], 
                        'SubareaRemitente'      => $this->items['idSubarea'], 
                        'DelegacionRemitente'   => $this->items['idDelegacionLog'], 
                        'Legales'               => $textoLegal,
                        'TokenLinkFirma'        => $this->complementos->generar_string_aleatorio(15),
                        'LiberadoFirma'         => 'Y',
                        'UsuarioCrea'           => $this->items['id'],
                        'FechaCrea'             => $fechaActualAdd,    
                        'Localhost'             => $this->request->getIPAddress()
                    );

                    $lastIdAsignacion = $this->asignaciones->insert($dataAsignacion, TRUE);
                    
                    if($lastIdAsignacion === FALSE){
                        //Eliminar registros previos
                        if(!empty($arrayLineaInsert))
                        {
                            $this->lineas->whereIn('IDLinea', $arrayLineaInsert)->delete();
                        }
                        
                        if(!empty($arrayEquipoInsert))
                        {
                            $this->moviles->whereIn('IDMovil', $arrayEquipoInsert)->delete();
                        }
                        
                        if(!empty($arrayContratoInsert))
                        {
                            $this->contratos->whereIn('IDContrato', $arrayContratoInsert)->delete();
                        }
                        
                        if(!empty($arrayAsignacionInsert))
                        {
                            $this->asignaciones->whereIn('IDAsignacion', $arrayAsignacionInsert)->delete();
                            $this->detalleasignaciones->whereIn('IDAsignacion', $arrayAsignacionInsert)->delete();
                        }
                        
                        $message = sprintf($this->mensajeError->msg201, "No se pudo insertar los registros solicitados. Inténtelo luego.<ASIGNACION>".$filainsert);
                        echo $this->alertas->alertaError($message);
                        echo $this->alertas->refrescar(1);
                        exit;
                    }
                    $arrayAsignacionInsert[] = $lastIdAsignacion;

                    $dataDetalleAsignacion = array();

                    $dataDetalleAsignacion[] = array (
                        'IDAsignacion'      => $lastIdAsignacion, 
                        'TipoElemento'      => "LINEA",  
                        'IDElemento'        => $lastIdLinea, 
                        'Observacion'       => $obslinea, 
                        'MonedaReposicion'  => "PEN", 
                        'MontoReposicion'   => $repolinea, 
                        'UsuarioCrea'       => $this->items['id'],
                        'FechaCrea'         => $fechaActualAdd,    
                        'Localhost'         => $this->request->getIPAddress()
                    );
                    
                    if($lastIdMovil!='' && $lastIdMovil != null)
                    {
                        $dataDetalleAsignacion[] = array (
                            'IDAsignacion'      => $lastIdAsignacion, 
                            'TipoElemento'      => "MOVIL",  
                            'IDElemento'        => $lastIdMovil, 
                            'Observacion'       => $obsmovil, 
                            'MonedaReposicion'  => "PEN", 
                            'MontoReposicion'   => $repomovil, 
                            'UsuarioCrea'       => $this->items['id'],
                            'FechaCrea'         => $fechaActualAdd,    
                            'Localhost'         => $this->request->getIPAddress()
                        );
                    }
                    
                    $lastIdDetalleAsignacion = $this->detalleasignaciones->insertBatch($dataDetalleAsignacion);
                        
                    if($lastIdDetalleAsignacion === FALSE){
                        //Eliminar registros previos
                        if(!empty($arrayLineaInsert))
                        {
                            $this->lineas->whereIn('IDLinea', $arrayLineaInsert)->delete();
                        }
                        
                        if(!empty($arrayEquipoInsert))
                        {
                            $this->moviles->whereIn('IDMovil', $arrayEquipoInsert)->delete();
                        }
                        
                        if(!empty($arrayContratoInsert))
                        {
                            $this->contratos->whereIn('IDContrato', $arrayContratoInsert)->delete();
                        }
                        
                        if(!empty($arrayAsignacionInsert))
                        {
                            $this->asignaciones->whereIn('IDAsignacion', $arrayAsignacionInsert)->delete();
                            $this->detalleasignaciones->whereIn('IDAsignacion', $arrayAsignacionInsert)->delete();
                        }
                        
                        $message = sprintf($this->mensajeError->msg201, "No se pudo insertar los registros solicitados. Inténtelo luego.<DETALLE>".$filainsert);
                        echo $this->alertas->alertaError($message);
                        echo $this->alertas->refrescar(1);
                        exit;
                    }
                    $arrayAsignacionDetalleInsert[] = $lastIdDetalleAsignacion;
                }
                
            }
        }

        fclose($handleInsert);

        $message = sprintf($this->mensajeError->msg201, "Se insertaron el total de ".$filainsert." filas.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);

    }
	
    public function historicoAsignacionesLineas()
    {
        $html = '';
        
        if (isset($this->items['id'])) 
    	{
            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idLinea    = $this->request->getPost('idLinea');
    		
    		/*
            * -------------
            * OBTENER INFORMACIÓN DE TABLA
            * -------------
            */
            
            $filtros = array(
                "TipoElemento"  => "LINEA",
                "IDElemento"    => $idLinea
            );
    		
    		$datosLinea = $this->lineas->where("IDLinea",$idLinea)->first();
            $historico = $this->asignacionesDetalle->listadoHistoricoAsignacioneElemento($filtros);
            
            $html .= '<h3 class="mb-3">Línea</h3>
            <div class="card-text mb-3">
				<div class="form-group row">
					<div class="col-4">
						<label>Código</label>
						<input type="text" class="form-control" value="'.$idLinea.'" disabled>
					</div>
					<div class="col-4">
						<label>Número celular</label>
						<input type="text" class="form-control" value="'.$datosLinea['Numero'].'" disabled>
					</div>
					<div class="col-4">
						<label>ICCID</label>
						<input type="text" class="form-control" value="'.$datosLinea['ICCID'].'" disabled>
					</div>
				</div>
			</div>
			<hr>
			<h3 class="mb-3">Histórico de Asignaciones</h3>';
			
    		$html .= $this->estructuraHTMLHistoricoAsignacionElemento($historico);
    	} 
    	else 
    	{
            $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-10 col-10 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SESIÓN CERRADA</strong> - Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
        }
        
        echo $html;
    }

	/**************************************************************************/
	
    /**************************** LÍNEA - CONTRATO ****************************/
    
    public function listarContratosLinea($idLinea)
    {
		if(isset($this->items['id']))
		{
			if($idLinea != "TOTAL")
			{
			    $linea = $this->lineas->where('IDLinea', $idLinea)->first();
			}
			else
			{
			    $linea = array();
			}
			
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Contratos de línea | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Contratos de línea',
                'previo'                    => 'listar-lineas',
				'elementoSeleccionadoModulo'=> "Contratos",
				'subtitulo'                 => 'Listado de Contratos',
                'idLinea'                   => $idLinea,
                'linea'                     => $linea
			);
			
			$data = array_merge($data, $this->items);
			
			return view('it/listar_contratos_linea',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
	}
	
	public function contratosLineaServerside()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id'],
                "IDLinea"   => $this->request->getPost('idLinea')
            );
            
            /* LISTAR CONTRATOS */
            $dataServerside = $this->contratos->listaGeneralContratos($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			$dataServerside["data"][$key]['FechaInicioContrato']    = date("d-m-Y", strtotime($value['InicioContrato']));
    			$dataServerside["data"][$key]['TiempoPermanencia']      = $this->veriactivos->permanenciaContrato()[$value['PeriodoPermanencia']];
    			$dataServerside["data"][$key]['TiempoTranscurrido']     = $this->veriactivos->obtenerDescripcionTiempoTranscurridoContrato($value);
    			$dataServerside["data"][$key]['Penalidad']              = 'S/ '.$this->veriactivos->calculoPenalidadMovil($value);
    			
    			if($value['EquipoAsociado'] != '' && $value['EquipoAsociado'] != NULL)
    			{
    			    $dataServerside["data"][$key]['EquipoComprado'] = '<span class="badge bg-danger border-0">
						<a class="datos-movil px-2 py-2" style="color: #FFF;" data-bs-toggle="modal" data-bs-target="#informacionMovil" data-form="#formInformacionMovil" data-id="'.$value['EquipoAsociado'].'" data-accion="ver" id="ver-movil">'.$value['IMEI'].'</a>
					</span>';
    			}
    			else
    			{
    			    if(in_array("ASMOCO", $this->items['permisos']))
    			    {
    			        $dataServerside["data"][$key]['EquipoComprado'] = '--';
    			    }
    			    else
    			    {
    			        $dataServerside["data"][$key]['EquipoComprado'] = '--';
    			    }
    			}
    			
    			if($value['Estado'] != '' && $value['Estado'] != NULL)
    			{
    			    $dataServerside["data"][$key]['EstadoContrato'] = '<span class="badge '.($value['Estado'] == "VIGENTE" ? "bg-secondary" : "bg-primary").' border-0">'.$value['Estado'].'</span>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoContrato'] = '<span class="badge bg-info border-0">SIN CONTRATO</span>';
    			}
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-contrato" data-bs-target="#informacionContrato" data-form="#formInformacionContrato" data-id="'.$value['IDContrato'].'" data-linea="'.$value['IDLinea'].'" data-accion="ver" id="ver-contrato" data-tooltip="tooltip" title="Ver Contrato">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDCON", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-contrato" data-bs-target="#informacionContrato" data-form="#formInformacionContrato" data-id="'.$value['IDContrato'].'" data-linea="'.$value['IDLinea'].'" data-accion="editar" id="editar-contrato" data-tooltip="tooltip" title="Editar Contrato">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
	}
    
	public function validarContratoLineaActual()
	{
	    if (isset($this->items['id'])) 
        {
    	    $idLinea = $this->request->getPost('idLinea');
    	    
    	    $contrato = $this->contratos->where("IDLinea", $idLinea)->orderBy('FechaCrea', 'DESC')->first();
    	    
    	    if($contrato['Permanencia']=='Y')
    	    {
    	        $resultado = array(
    				'mensaje'   => (string) "El contrato vigente cuenta con permanencia, por lo que deberá pagar una penalidad, ¿Deseas continuar?",
    				'form'      => (string) "PEN"
    			);
    	    }
    	    else
    	    {
    	        $resultado = array(
    				'mensaje'   => (string) "¿Deseas crear un nuevo contrato para esta línea?",
    				'form'      => (string) "REG"
    			);
    	    }
    	    
    		echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
		else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
	public function insertarContratoLinea()
	{
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $montoDeducible = $this->request->getPost('txtMontoDeducible');
        $idLinea        = $this->request->getPost('txtIdLinea');
        $idplan         = $this->request->getPost('txtPlan_rcl');
        $inicioContrato = $this->request->getPost('txtInicioContrato_rcl');
        $diaFacturacion = $this->request->getPost('txtDiaFacturacion_rcl');
        $periodo        = $this->request->getPost('txtPeriodoPermanencia_rcl');
        $cuotaEquipo    = $this->request->getPost('txtValorCuota_rcl');
        $estadoContrato = $this->request->getPost('txtEstado_contrato_rcl');
        
        $incluyeMovil   = $this->request->getPost('chkContratoMovil_rcl'); // on o vacio

        $modelo             = $this->request->getPost('txtModeloMovil_rcl');
        $proveedor          = $this->request->getPost('txtProveedor_rcl');
        $imei               = $this->request->getPost('txtIMEI_rcl');
        $fechaCompra        = $this->request->getPost('txtFechaCompra_rcl');
        $precioCompra       = $this->request->getPost('txtPrecioCompra_rcl');
        $precioLista        = $this->request->getPost('txtPrecioLista_rcl');
        $equipoStock        = $this->request->getPost('chkEquipoStock_rcl');
        $estadoEquipo       = $this->request->getPost('txtEstadoMovil_rcl');
        $situacionEquipo    = $this->request->getPost('txtMotivoMovil_rcl');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idplan, 'required|trim|numeric', 'IDPlan');
        $error .= $this->complementos->validaCampo($inicioContrato, 'required|dateDos', 'Inicio de contrato');
        $error .= $this->complementos->validaCampo($diaFacturacion, 'required|number|minnumber[1]|maxnumber[31]', 'Dia facturación');
        $error .= $this->complementos->validaCampo($periodo, 'required|trim', 'Permanencia');
        $error .= $this->complementos->validaCampo($cuotaEquipo, 'required|decimal|trim|minnumber[0]', 'Valor de Cuota');
        $error .= $this->complementos->validaCampo($estadoContrato, 'required', 'Estado Contrato');

        if(isset($montoDeducible))
        {
            $error .= $this->complementos->validaCampo($montoDeducible, 'required|decimal|trim|minnumber[0]', 'Monto Penalidad');
        }
        
        if($incluyeMovil != '')
        {
            $error .= $this->complementos->validaCampo($modelo, 'required|trim|minlength[1]|maxlength[50]', 'Modelo');
            $error .= $this->complementos->validaCampo($proveedor, 'required|trim|minlength[1]|maxlength[50]', 'Proveedor');
            $error .= $this->complementos->validaCampo($imei, 'required|trim|numeric|minlength[15]|maxlength[15]', 'IMEI');
            $error .= $this->complementos->validaCampo($fechaCompra, 'required|dateDos', 'Fecha Compra');
            $error .= $this->complementos->validaCampo($precioCompra, 'required|decimal|trim|minnumber[0]', 'Precio Compra');
            $error .= $this->complementos->validaCampo($precioLista, 'required|decimal|trim|minnumber[0]', 'Precio Lista');
            $error .= $this->complementos->validaCampo($estadoEquipo, 'required', 'Estado Equipo');
            $error .= $this->complementos->validaCampo($situacionEquipo, 'required', 'Motivo Equipo');
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */
        
        $msgExistencia = '';
        
		$imeiExistente = $this->moviles->where('IMEI', $imei)->findAll();

        if(count($imeiExistente)>0)
        {
            $msgExistencia .= "<li>El IMEI ya fue registrado. [CAMPO] <small>IMEI</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */
        
        if($incluyeMovil != '')
        {
            $dataEquipo = array (
                'IDModelo'          => $modelo, 
                'Proveedor'         => ucfirst($proveedor), 
                'IMEI'              => $imei, 
                'FechaCompra'       => date("Y-m-d", strtotime($fechaCompra)), 
                'PrecioCompra'      => $precioCompra, 
                'PrecioLista'       => $precioLista, 
                'EquipoStock'       => $equipoStock != '' ? "Y" : "N",
                'FechaEstado'       => $fechaActual,
                'UsuarioEstado'     => $this->items['id'],
                'Estado'            => $estadoEquipo,  
                'Situacion'         => $situacionEquipo,
                'MotivoCambio'      => "Registro de equipo móvil.",  
                'UsuarioCrea'       => $this->items['id'],
                'FechaCrea'         => $fechaActual,    
                'Localhost'         => $this->request->getIPAddress()
            );

            $lastIdEquipo = $this->moviles->insert($dataEquipo, TRUE);
            
            if($lastIdEquipo !== FALSE){
                $idMovil = $lastIdEquipo;
            }
            else
            {
                $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al guardar el equipo. Inténtelo luego.</li>");
                echo $this->alertas->alertaError($message);
                EXIT;
            }
        }
        else
        {
            $idMovil = null;
        }

        //Actualizamos Contrato previo
        
        $contratoActual = $this->contratos->where("IDLinea", $idLinea)->orderBy('FechaCrea', 'DESC')->first();
        
        $dataContratoActual = array (
            'Permanencia'       => 'N',
            'FechaEstado'       => $fechaActual,
            'FinalContrato'     => date("Y-m-d", strtotime($fechaActual)),
            'UsuarioEstado'     => $this->items['id'],
            'Estado'            => "CADUCADO",
            'MotivoCambio'      => "CONTRATO CADUCADO POR NUEVO CONTRATO.",
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        
        if(isset($montoDeducible))
        {
            $dataContratoActual['MontoDeducible'] = $montoDeducible;
            $dataContratoActual['FechaPagoDeducible'] = $fechaActual;
        }
        
        $lastId = $this->contratos->update([$contratoActual['IDContrato']], $dataContratoActual);

		if($lastId === FALSE){
			$message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al actualizar el contrato actual. Inténtelo luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
		}
        
        $dataContrato = array (
            'IDLinea'           => $idLinea, 
            'IDPlan'            => $idplan,  
            'InicioContrato'    => date("Y-m-d", strtotime($inicioContrato)), 
            'DiaFacturacion'    => $diaFacturacion, 
            'Permanencia'       => ($periodo == 'SP' ? 'N' : 'Y'), 
            'PeriodoPermanencia'=> $periodo, 
            'EquipoAsociado'    => $idMovil,
            'MontoCuota'        => $cuotaEquipo,
            'FechaEstado'       => $fechaActual,
            'UsuarioEstado'     => $this->items['id'],
            'Estado'            => $estadoContrato,
            'MotivoCambio'      => "Registro de contrato.",  
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->contratos->insert($dataContrato, TRUE);
        
		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idLinea);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }  
    
    public function obtenerDatosContratoLinea() 
    {
        if (isset($this->items['id'])) 
        {
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idContrato = $this->request->getPost('idContrato');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idContrato, 'trim', 'ID');
    
    		if ($error != '') 
    		{
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosContrato = $this->contratos->obtenerContrato($idContrato);
            
    		if(!empty($datosContrato))
    		{
    			$resultado = array(
    				'idcontrato'        => (string) $idContrato,
    				'idplan'            => (string) $datosContrato['IDPlan'],
    				'idoperador'        => (string) $datosContrato['IDOperador'],
    				'iniciocontrato'    => (string) $datosContrato['InicioContrato'],
    				'periodo'           => (string) $datosContrato['PeriodoPermanencia'],
    				'diafacturacion'    => (string) $datosContrato['DiaFacturacion'],
    				'montocuota'        => (string) $datosContrato['MontoCuota']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
        else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
	public function modificarContrato($idContrato)
	{
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idplan         = $this->request->getPost('txtPlan_i');
        // $inicioContrato = $this->request->getPost('txtInicioContrato_i');
        $periodo        = $this->request->getPost('txtPeriodoPermanencia_i');
        $diaFacturacion = $this->request->getPost('txtDiaFacturacion_i');
        $cuotaEquipo    = $this->request->getPost('txtValorCuota_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idplan, 'required|trim|numeric', 'IDPlan');
        // $error .= $this->complementos->validaCampo($inicioContrato, 'required|dateDos', 'Inicio de contrato');
        $error .= $this->complementos->validaCampo($diaFacturacion, 'required|number|minnumber[1]|maxnumber[31]', 'Dia facturación');
        $error .= $this->complementos->validaCampo($periodo, 'required|trim', 'Permanencia');
        $error .= $this->complementos->validaCampo($cuotaEquipo, 'required|decimal|trim|minnumber[0]', 'Valor de Cuota');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE PLAN A ACTUALIZAR
        * ----------------------------
        */
        
        $planOrigen = $this->auditoria->obtenerPrimerPlanContrato($idContrato);
        
        if(empty($planOrigen))
        {
            $planOrigen = $this->contratos->obtenerContrato($idContrato);
        }
        
        $planSeleccionado = $this->planes->where("IDPlan", $idplan)->first();
        
        $mensajeValidacion = $this->veriactivos->validarUpgradePlan($planOrigen, $planSeleccionado);
        
        if($mensajeValidacion != '')
        {
            $message = sprintf($this->mensajeError->msg201, $mensajeValidacion);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * ACTUALIZACIÓN DE DATOS
        * ----------------------------
        */
        
        $data = array (
            'IDPlan'            => $idplan, 
            // 'InicioContrato'    => date("Y-m-d", strtotime($inicioContrato)), 
            'DiaFacturacion'    => $diaFacturacion,  
            'Permanencia'       => ($periodo == 'SP' ? 'N' : 'Y'), 
            'PeriodoPermanencia'=> $periodo,  
            'MontoCuota'        => $cuotaEquipo,  
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        
        $lastId = $this->contratos->update([$idContrato], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idContrato);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	/**************************************************************************/
	
    /******************************** HARDWARE ********************************/
    
    public function listarHardware()
    {
		if(isset($this->items['id']))
		{
		    $data = array (
				'session'                   => 'on',
				'titulo'                    => 'Hardware | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Hardware',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Listado de Hardware",
				'subtitulo'                 => 'Hardware'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('it/listar_hardware',$data);
		} 
		else 
		{
			return view('errors/500');
		}
	}
	
	public function hardwareServerside()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* OBTENER MONEDAS ACTUALES */
            
            $listadoMonedas = $this->divisas->findAll();
            // Crear un array asociativo para acceder fácilmente a cada MONEDA por su nomenclatura
            $monedasMapeadas = [];
            foreach ($listadoMonedas as $moneda) {
                $monedasMapeadas[$moneda['CodigoInternacional']] = $moneda['Simbolo'] ;
            }
            
            /* LISTAR HARDWARE */
            $dataServerside = $this->hardware->listaGeneralViewHardware($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
                if($value['FinalGarantia'] == '' || $value['FinalGarantia'] == null || $value['FinalGarantia'] == '0000-00-00')
                {
                    $dataServerside["data"][$key]['FechaFinalGarantia'] = '<span class="badge bg-info border-0">Sin Información</span>';
                }
                else
                {
                    $fechaFinalGarantia = \DateTime::createFromFormat('Y-m-d', $value['FinalGarantia']);
                    $fechaHoy = new \DateTime(); // Fecha actual
                    
                    if ($fechaHoy < $fechaFinalGarantia) 
                    {
                        // Obtener la diferencia en meses
                        $diferencia = $fechaHoy->diff($fechaFinalGarantia);
                        $mesesDeDiferencia = $diferencia->m + ($diferencia->y * 12); // Convertir años a meses
                    
                        // Validar si la diferencia es menor a 1 mes o menor a 6 meses
                        if ($mesesDeDiferencia < 1) 
                        {
                            $dataServerside["data"][$key]['FechaFinalGarantia'] = '<span class="badge bg-black color-white border-0">'.date("d-m-Y", strtotime($value['FinalGarantia'])).'</span>';
                        } 
                        elseif ($mesesDeDiferencia < 6) 
                        {
                            $dataServerside["data"][$key]['FechaFinalGarantia'] = '<span class="badge bg-orange border-0">'.date("d-m-Y", strtotime($value['FinalGarantia'])).'</span>';
                        } 
                        else 
                        {
                            $dataServerside["data"][$key]['FechaFinalGarantia'] = date("d-m-Y", strtotime($value['FinalGarantia']));
                        }
                    } 
                    else 
                    {
                        $dataServerside["data"][$key]['FechaFinalGarantia'] = date("d-m-Y", strtotime($value['FinalGarantia']));
                    }
                }
                
                $dataServerside["data"][$key]['PrecioHardware']     = $monedasMapeadas[$value['MonedaCompra']].' '.$value['PrecioCompra'];
                $dataServerside["data"][$key]['SubareaReserva']     = '<span class="badge '.($value['Subarea']  == NULL || $value['Subarea']  == '' || $value['Subarea']  == 'null' ? "bg-light text-dark" : "bg-warning text-dark").' border-0">'.($value['Subarea']  == NULL || $value['Subarea']  == '' || $value['Subarea']  == 'null' ? "Libre" : $value['Subarea']).'</span>';
                
                if($value['HabilitadoNavision'] == "Y")
                {
                    if($value['EstadoNavision'] == "MOV")
                    {
                        $dataServerside["data"][$key]['Navision'] = '<span class="badge bg-success border-0">'.date("d-m-Y", strtotime($value['FechaEstadoNavision'])).'<br>'.date("H:i:s", strtotime($value['FechaEstadoNavision'])).'</span>';
                    }
                    else
                    {
                        $dataServerside["data"][$key]['Navision'] = '<span class="badge bg-danger border-0">NO</span>';
                    }
                }
                else
                {
                    $dataServerside["data"][$key]['Navision'] = '';
                }
                
                if($value['IDAsignado'] != '' && $value['IDAsignado'] != null )
                {
                    $dataServerside["data"][$key]['MatriculaAsignado'] = $value['MatriculaAsignado'];
                    $dataServerside["data"][$key]['Asignado'] = '<span class="badge '.($value['EstadoAsignado'] == 'Activo' ? 'bg-light text-dark' : 'bg-danger color-white').' border-0">'.$value['UsuarioAsignado'].'</span>';
                }
                else
                {
                    $dataServerside["data"][$key]['MatriculaAsignado'] = "No Asignado";
                    $dataServerside["data"][$key]['Asignado'] = "No Asignado";
                }
                
                $dataServerside["data"][$key]['NombreAsignado'] = ucwords(mb_strtolower($value['NombreAsignado']));
                
                
                
                
                if($value['Estado']=='ACT')
                {
                    $bg = "bg-success";
                }
                else if($value['Estado']=='BAJ')
                {
                    $bg = "bg-danger";
                }
                else
                {
                    $bg = "bg-warning";
                }
                
                $dataServerside["data"][$key]['EstadoHardware'] = '<span class="badge '.$bg.' border-0">'.$this->globales->estadosDispositivos()[$value['Estado']].' | '.$this->globales->motivoEstadoDispositivos($value['Estado'])[$value['Situacion']].'</span>';
                
                
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-hardware" data-bs-target="#informacionHardware" data-form="#formInformacionHardware" data-id="'.$value['IDHardware'].'" data-accion="ver" id="ver-hardware" data-tooltip="tooltip" title="Ver Hardware">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDHAR", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-hardware" data-bs-target="#informacionHardware" data-form="#formInformacionHardware" data-id="'.$value['IDHardware'].'" data-accion="editar" id="editar-hardware" data-tooltip="tooltip" title="Editar Hardware">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $acciones .= '<button class="badge bg-rosa border-0 p-2 mx-1 historico-asignaciones-hardware" data-bs-target="#mdlHistoricoAsignacionesHardware" data-id="'.$value['IDHardware'].'" data-tooltip="tooltip" title="Ver Histórico de Asignaciones">
    				<i class="mdi mdi-timeline-clock align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
	}
	
    public function insertarHardware()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $modelo         = $this->request->getPost('txtModeloComercial_i');
        $hostname       = $this->request->getPost('txtHostnameHardware_i');
        $serie          = $this->request->getPost('txtSerieHardware_i');
        $tag            = $this->request->getPost('txtTAGHardware_i');
        $procesador     = $this->request->getPost('txtProcesadorHardware_i');
        $generacion     = $this->request->getPost('txtGenProcesadorHardware_i');
        $ram            = $this->request->getPost('txtRamHardware_i');
        $tiporam        = $this->request->getPost('txtTipoRAMHardware_i');
        $hdd            = $this->request->getPost('txtHDDHardware_i');
        $ssd            = $this->request->getPost('txtSSDHardware_i');
        $pulgadas       = $this->request->getPost('txtPulgadasHardware_i');
        $iniciogarantia = $this->request->getPost('txtInicioGarantia_i');
        $fingarantia    = $this->request->getPost('txtFinalGarantia_i');
        $finvidautil    = $this->request->getPost('txtFinalVidaUtil_i');
        $detalle        = $this->request->getPost('txtDetalleHardware_i');
        $albaran        = $this->request->getPost('txtAlbaranHardware_i');
        $subarea        = $this->request->getPost('txtSubareaReserva_i');
        $factura        = $this->request->getPost('txtFacturaHardware_i');
        $ordencompra    = $this->request->getPost('txtOCHardware_i');
        $fechacompra    = $this->request->getPost('txtFechaCompra_i');
        $preciocompra   = $this->request->getPost('txtPrecioCompra_i');
        $monedacompra   = $this->request->getPost('txtMonedaCompraHardware_i');
        $ubicacion      = $this->request->getPost('txtUbicacionHardware_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $categoria = $this->dispositivos->obtenerDispositivo($modelo);

        $error = '';
        $error .= $this->complementos->validaCampo($modelo, 'required|trim|numeric', 'Modelo');
        $error .= $this->complementos->validaCampo($serie, 'required|trim|minlength[1]|maxlength[50]', 'Serie');
        $error .= $this->complementos->validaCampo($iniciogarantia, 'dateDos', 'Inicio Garantía');
        $error .= $this->complementos->validaCampo($fingarantia, 'dateDos', 'Fin Garantía');
        $error .= $this->complementos->validaCampo($finvidautil, 'dateDos', 'Fin Vida Útil');
        $error .= $this->complementos->validaCampo($fechacompra, 'required|dateDos', 'Fecha Compra');
        $error .= $this->complementos->validaCampo($preciocompra, 'required|decimal|trim|minnumber[0]', 'Precio Compra');
        $error .= $this->complementos->validaCampo($monedacompra, 'required|trim', 'Moneda Compra');
        $error .= $this->complementos->validaCampo($albaran, 'trim|minlength[1]|maxlength[50]', 'Albarán');
        $error .= $this->complementos->validaCampo($factura, 'trim|minlength[1]|maxlength[50]', 'Factura');
        $error .= $this->complementos->validaCampo($ordencompra, 'trim|minlength[1]|maxlength[50]', 'Orden de Compra');
        $error .= $this->complementos->validaCampo($subarea, 'trim|numeric', 'Reservado para');
        $error .= $this->complementos->validaCampo($ubicacion, 'trim|numeric', 'Almacén Ubicado');
        
        if($categoria['id_categoria'] == "1")
        {
            $error .= $this->complementos->validaCampo($hostname, 'required|trim|minlength[1]|maxlength[50]', 'Hostname');
            $error .= $this->complementos->validaCampo($tag, 'trim|minlength[1]|maxlength[20]', 'TAG');
            $error .= $this->complementos->validaCampo($procesador, 'required|trim|minlength[1]|maxlength[20]', 'Procesador');
            $error .= $this->complementos->validaCampo($generacion, 'required|trim|numeric', 'Generación Procesador');
            $error .= $this->complementos->validaCampo($ram, 'required|trim|numeric', 'RAM');
            $error .= $this->complementos->validaCampo($tiporam, 'required|trim|minlength[1]|maxlength[5]', 'Tipo RAM');
            $error .= $this->complementos->validaCampo($hdd, 'trim|numeric', 'HDD');
            $error .= $this->complementos->validaCampo($ssd, 'trim|numeric', 'SSD');
        }
        else if($categoria['id_categoria'] == "2")
        {
            // $error .= $this->complementos->validaCampo($hostname, 'required|trim|minlength[1]|maxlength[50]', 'Hostname');
            $error .= $this->complementos->validaCampo($pulgadas, 'required|trim|decimal|trim|minnumber[0]', 'Pulgadas');
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */
        $msgExistencia = '';
        
        $whereExistente = array("IDModelo" => $modelo, "Serie" => $serie);
		$hardwareExistente = $this->hardware->where($whereExistente)->findAll();
		
        if($hardwareExistente != '' && count($hardwareExistente)>0)
        {
            $msgExistencia .= "<li>La combinación de modelo y serie ya fue registrada. [CAMPO] <small>MODELO - SERIE</small></li>";
        }
        
        if($hostname != '')
        {
            $hostnameExistente = $this->hardware->where("Hostname", $hostname)->findAll();
            if($hostnameExistente != '' && count($hostnameExistente)>0)
            {
                $msgExistencia .= "<li>El Hostname ya fue registrado. [CAMPO] <small>HOSTNAME</small></li>";
            }
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDModelo'              => $modelo, 
            'Hostname'              => $hostname,
            'Serie'                 => $serie, 
            'TAG'                   => $tag, 
            'Procesador'            => $procesador, 
            'GeneracionProcesador'  => $generacion, 
            'RAM'                   => $ram, 
            'TipoRam'               => $tiporam, 
            'HDD'                   => $hdd, 
            'SSD'                   => $ssd, 
            'Pulgadas'              => $pulgadas, 
            'InicioGarantia'        => $iniciogarantia, 
            'FinalGarantia'         => $fingarantia, 
            'FinalVidaUtil'         => $finvidautil, 
            'Detalle'               => $detalle, 
            'Albaran'               => $albaran, 
            'IDSubarea'             => $subarea,
            'Factura'               => $factura, 
            'OrdenCompra'           => $ordencompra, 
            'FechaCompra'           => $fechacompra, 
            'PrecioCompra'          => $preciocompra, 
            'MonedaCompra'          => $monedacompra,
            'IDDireccion'           => $ubicacion,
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,  
            'Localhost'             => $this->request->getIPAddress(),    
            'Estado'                => "ACT",  
            'UsuarioEstado'         => $this->items['id'],
            'FechaEstado'           => $fechaActual,
            'MotivoEstado'          => "Registro de Hardware."
        );

        $lastId = $this->hardware->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $serie);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }  

	public function obtenerDatosHardware()
	{
	    if (isset($this->items['id'])) 
        {
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idHardware = $this->request->getPost('idHardware');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idHardware, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosHardware = $this->hardware->obtenerHardware($idHardware);
    
    		if(!empty($datosHardware)){
    			$resultado = array(
    				'idhardware'        => (string) $idHardware,
    				'idmodelo'          => (string) $datosHardware['IDModelo'],
    				'idmarca'           => (string) $datosHardware['IDMarca'],
    				'categoria'         => (string) $datosHardware['nombre_categoria'],
    				'tipo'              => (string) $datosHardware['nombre_tipo'],
    				'subtipo'           => (string) $datosHardware['nombre_subtipo'],
    				'hostnamehardware'  => (string) $datosHardware['Hostname'],
    				'serie'             => (string) $datosHardware['Serie'],
    				'tag'               => (string) $datosHardware['TAG'],
    				'procesador'        => (string) $datosHardware['Procesador'] == null ? '' : $datosHardware['Procesador'],
    				'generacion'        => (string) $datosHardware['GeneracionProcesador'] == null ? '' : $datosHardware['GeneracionProcesador'],
    				'ram'               => (string) $datosHardware['RAM'] == null ? '' : $datosHardware['RAM'],
    				'tiporam'           => (string) $datosHardware['TipoRam'] == null ? '' : $datosHardware['TipoRam'],
    				'hdd'               => (string) $datosHardware['HDD'] == null || $datosHardware['HDD'] == 0 ? '' : $datosHardware['HDD'],
    				'ssd'               => (string) $datosHardware['SSD'] == null || $datosHardware['SSD'] == 0 ? '' : $datosHardware['SSD'],
    				'pulgadas'          => (string) $datosHardware['Pulgadas'] == null ? '' : $datosHardware['Pulgadas'],
    				'iniciogarantia'    => (string) $datosHardware['InicioGarantia'],
    				'finalgarantia'     => (string) $datosHardware['FinalGarantia'],
    				'finalvidautil'     => (string) $datosHardware['FinalVidaUtil'],
    				'detalle'           => (string) $datosHardware['Detalle'],
    				'albaran'           => (string) $datosHardware['Albaran'],
    				'iddireccion'       => (string) $datosHardware['IDDireccion'],
    				'idarea'            => (string) $datosHardware['IDArea'],
    				'idsubarea'         => (string) $datosHardware['IDSubarea'],
    				'factura'           => (string) $datosHardware['Factura'],
    				'ordencompra'       => (string) $datosHardware['OrdenCompra'],
    				'fechacompra'       => (string) $datosHardware['FechaCompra'],
    				'preciocompra'      => (string) $datosHardware['PrecioCompra'],
    				'monedacompra'      => (string) $datosHardware['MonedaCompra'],
    				'idubicacion'       => (string) $datosHardware['IDUbicacion_SUNAT']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado, JSON_NUMERIC_CHECK);
	    }
        else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}

    public function modificarHardware($idHardware)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $modelo         = $this->request->getPost('txtModeloComercial_i');
        $hostname       = $this->request->getPost('txtHostnameHardware_i');
        $serie          = $this->request->getPost('txtSerieHardware_i');
        $tag            = $this->request->getPost('txtTAGHardware_i');
        $procesador     = $this->request->getPost('txtProcesadorHardware_i');
        $generacion     = $this->request->getPost('txtGenProcesadorHardware_i');
        $ram            = $this->request->getPost('txtRamHardware_i');
        $tiporam        = $this->request->getPost('txtTipoRAMHardware_i');
        $hdd            = $this->request->getPost('txtHDDHardware_i');
        $ssd            = $this->request->getPost('txtSSDHardware_i');
        $pulgadas       = $this->request->getPost('txtPulgadasHardware_i');
        $iniciogarantia = $this->request->getPost('txtInicioGarantia_i');
        $fingarantia    = $this->request->getPost('txtFinalGarantia_i');
        $finvidautil    = $this->request->getPost('txtFinalVidaUtil_i');
        $detalle        = $this->request->getPost('txtDetalleHardware_i');
        $albaran        = $this->request->getPost('txtAlbaranHardware_i');
        $subarea        = $this->request->getPost('txtSubareaReserva_i');
        $factura        = $this->request->getPost('txtFacturaHardware_i');
        $ordencompra    = $this->request->getPost('txtOCHardware_i');
        $fechacompra    = $this->request->getPost('txtFechaCompra_i');
        $preciocompra   = $this->request->getPost('txtPrecioCompra_i');
        $monedacompra   = $this->request->getPost('txtMonedaCompraHardware_i');
        $ubicacion      = $this->request->getPost('txtUbicacionHardware_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $categoria = $this->dispositivos->obtenerDispositivo($modelo);

        $error = '';
        $error .= $this->complementos->validaCampo($modelo, 'required|trim|numeric', 'Modelo');
        $error .= $this->complementos->validaCampo($serie, 'required|trim|minlength[1]|maxlength[50]', 'Serie');
        $error .= $this->complementos->validaCampo($iniciogarantia, 'dateDos', 'Inicio Garantía');
        $error .= $this->complementos->validaCampo($fingarantia, 'dateDos', 'Fin Garantía');
        $error .= $this->complementos->validaCampo($finvidautil, 'dateDos', 'Fin Vida Útil');
        $error .= $this->complementos->validaCampo($fechacompra, 'required|dateDos', 'Fecha Compra');
        $error .= $this->complementos->validaCampo($preciocompra, 'required|decimal|trim|minnumber[0]', 'Precio Compra');
        $error .= $this->complementos->validaCampo($monedacompra, 'required|trim', 'Moneda Compra');
        $error .= $this->complementos->validaCampo($albaran, 'trim|minlength[1]|maxlength[50]', 'Albarán');
        $error .= $this->complementos->validaCampo($factura, 'trim|minlength[1]|maxlength[50]', 'Factura');
        $error .= $this->complementos->validaCampo($ordencompra, 'trim|minlength[1]|maxlength[50]', 'Orden de Compra');
        $error .= $this->complementos->validaCampo($subarea, 'trim|numeric', 'Reservado para');
        $error .= $this->complementos->validaCampo($ubicacion, 'trim|numeric', 'Almacén Ubicado');
        
        if($categoria['id_categoria'] == "1")
        {
            $error .= $this->complementos->validaCampo($hostname, 'required|trim|minlength[1]|maxlength[50]', 'Hostname');
            $error .= $this->complementos->validaCampo($tag, 'trim|minlength[1]|maxlength[20]', 'TAG');
            $error .= $this->complementos->validaCampo($procesador, 'required|trim|minlength[1]|maxlength[20]', 'Procesador');
            $error .= $this->complementos->validaCampo($generacion, 'required|trim|numeric', 'Generación Procesador');
            $error .= $this->complementos->validaCampo($ram, 'required|trim|numeric', 'RAM');
            $error .= $this->complementos->validaCampo($tiporam, 'required|trim|minlength[1]|maxlength[5]', 'Tipo RAM');
            $error .= $this->complementos->validaCampo($hdd, 'trim|numeric', 'HDD');
            $error .= $this->complementos->validaCampo($ssd, 'trim|numeric', 'SSD');
        }
        else if($categoria['id_categoria'] == "2")
        {
            // $error .= $this->complementos->validaCampo($hostname, 'required|trim|minlength[1]|maxlength[50]', 'Hostname');
            $error .= $this->complementos->validaCampo($pulgadas, 'required|trim|decimal|trim|minnumber[0]', 'Pulgadas');
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $data = array (
            'IDModelo'              => $modelo, 
            'Hostname'              => $hostname,
            'Serie'                 => $serie, 
            'TAG'                   => $tag, 
            'Procesador'            => $procesador, 
            'GeneracionProcesador'  => $generacion, 
            'RAM'                   => $ram, 
            'TipoRam'               => $tiporam, 
            'HDD'                   => $hdd, 
            'SSD'                   => $ssd, 
            'Pulgadas'              => $pulgadas, 
            'InicioGarantia'        => $iniciogarantia, 
            'FinalGarantia'         => $fingarantia, 
            'FinalVidaUtil'         => $finvidautil, 
            'Detalle'               => $detalle, 
            'Albaran'               => $albaran, 
            'IDSubarea'             => $subarea,
            'Factura'               => $factura, 
            'OrdenCompra'           => $ordencompra, 
            'FechaCompra'           => $fechacompra, 
            'PrecioCompra'          => $preciocompra, 
            'MonedaCompra'          => $monedacompra,
            'IDDireccion'           => $ubicacion,
            'UsuarioModifica'       => $this->items['id'],
            'FechaModifica'         => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress()
        );

        $lastId = $this->hardware->update([$idHardware], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idHardware);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function historicoAsignacionesHardware()
    {
        $html = '';
        
        if (isset($this->items['id'])) 
    	{
            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idHardware    = $this->request->getPost('idHardware');
    		
    		/*
            * -------------
            * OBTENER INFORMACIÓN DE TABLA
            * -------------
            */
            
            $filtros = array(
                "TipoElemento"  => "HARDWARE",
                "IDElemento"    => $idHardware
            );
    		
    		$datosHardware = $this->hardware->obtenerHardware($idHardware);
            $historico = $this->asignacionesDetalle->listadoHistoricoAsignacioneElemento($filtros);
            
            $html .= '<h3 class="mb-3">Hardware</h3>
            <div class="card-text mb-3">
				<div class="form-group row">
					<div class="col-6">
						<label>Código</label>
						<input type="text" class="form-control" value="'.$idHardware.'" disabled>
					</div>
					<div class="col-6">
						<label>Hostname</label>
						<input type="text" class="form-control" value="'.$datosHardware['Hostname'].'" disabled>
					</div>
				</div>
			</div>
			<div class="card-text mb-3">
				<div class="form-group row">
					<div class="col-4">
						<label>Marca</label>
						<input type="text" class="form-control" value="'.$datosHardware['Marca'].'" disabled>
					</div>
					<div class="col-4">
						<label>Modelo</label>
						<input type="text" class="form-control" value="'.$datosHardware['Modelo'].'" disabled>
					</div>
					<div class="col-4">
						<label>Serie</label>
						<input type="text" class="form-control" value="'.$datosHardware['Serie'].'" disabled>
					</div>
				</div>
			</div>
			<hr>
			<h3 class="mb-3">Histórico de Asignaciones</h3>';
			
    		$html .= $this->estructuraHTMLHistoricoAsignacionElemento($historico);
    	} 
    	else 
    	{
            $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-10 col-10 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SESIÓN CERRADA</strong> - Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
        }
        
        echo $html;
    }
    
    public function pendientesMoverNavisionHardware()
    {
        if (isset($this->items['id'])) 
    	{
                
            // $whereTraspaso = array(
            //     'FechaInicio'   => $fechaInicio,
            //     'FechaFinal'    => $fechaFin
            // );
            
            $listado = $this->hardware->listadoPendientesMoverNavision();
            
            $filename = "Pendientes_Navision.csv";
            $writer = WriterEntityFactory::createCSVWriter();
            $writer->setFieldDelimiter(';');
            $writer->openToBrowser($filename);
            
            $cells = [
                WriterEntityFactory::createCell("ID Hardware"),
                WriterEntityFactory::createCell("Movido Navision"),
                WriterEntityFactory::createCell("Modelo"),
                WriterEntityFactory::createCell("Marca"),
                WriterEntityFactory::createCell("Habilitado Navision"),
                WriterEntityFactory::createCell("Subtipo"),
                WriterEntityFactory::createCell("Tipo"),
                WriterEntityFactory::createCell("Categoría"),
                WriterEntityFactory::createCell("Serie"),
                WriterEntityFactory::createCell("Estado Hardware"),
                WriterEntityFactory::createCell("Matricula Asignado"),
                WriterEntityFactory::createCell("Nombre Asignado"),
                WriterEntityFactory::createCell("Estado Asignado"),
                WriterEntityFactory::createCell("Fecha Cese Asignado"),
                WriterEntityFactory::createCell("CC Asignado"),
                WriterEntityFactory::createCell("LN Asignado"),
                WriterEntityFactory::createCell("Fecha de Asignación")
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);
            
            foreach($listado as $key=>$item)
            {
                $delegacion = $this->estructuraDelegaciones->where("IDDelegacion", $item['DelegacionAsignado'])->first();
                $asignado = $this->usuarios->where("IdUsuario ", $item['UsuarioAsignado'])->first();
                
                $movido = (string) $item['EstadoNavision'] == "MOV" ? "SI" : "NO";
                $habilitado = (string) $item['HabilitadoNavision'] == "Y" ? "HABILITADO" : "NO HABILITADO";
                $estado = (string) ($item['Estado'] == "ACT" ? "ACTIVO" : ($item['Estado'] == "BAJ" ? "BAJA" : ($item['Estado'] == "AVE" ? "AVERIADO" : "SIN INFORMACIÓN")));
                
                $nombreUsuario = (string) ucwords(mb_strtolower($asignado['Nombres'].' '.$asignado['Apellidos']));
                
                $fechaAsignacion = (string) ($item['FechaAsignado'] != '' && $item['FechaAsignado'] != null && $item['FechaAsignado'] != "0000-00-00" ? date("d-m-Y", strtotime($item['FechaAsignado'])) : date("d-m-Y", strtotime($item['FechaCrea'])));
                
                $cc = (string) !empty($delegacion) ? $delegacion['CC'] : "Sin información-".$item['IDDelegacion'];
                $ln = (string) !empty($delegacion) ? $delegacion['LN'] : "Sin información-".$item['IDDelegacion'];
                
    			$cells = [
                    WriterEntityFactory::createCell($item['IDHardware']),
                    WriterEntityFactory::createCell($movido),
                    WriterEntityFactory::createCell($item['Modelo']),
                    WriterEntityFactory::createCell($item['Marca']),
                    WriterEntityFactory::createCell($habilitado),
                    WriterEntityFactory::createCell($item['nombre_subtipo']),
                    WriterEntityFactory::createCell($item['nombre_tipo']),
                    WriterEntityFactory::createCell($item['nombre_categoria']),
                    WriterEntityFactory::createCell($item['Serie']),
                    WriterEntityFactory::createCell($estado),
                    WriterEntityFactory::createCell($asignado['Matricula']),
                    WriterEntityFactory::createCell($nombreUsuario),
                    WriterEntityFactory::createCell($asignado['Estado']),
                    WriterEntityFactory::createCell($asignado['FechaCese']),
                    WriterEntityFactory::createCell($cc),
                    WriterEntityFactory::createCell($ln),
                    WriterEntityFactory::createCell($fechaAsignacion)
                ];
                
                /** add a row at a time */
                $singleRow = WriterEntityFactory::createRow($cells);
                $writer->addRow($singleRow);
    
            }
            
            $writer->close();
            
    	}
    	else 
    	{
            echo "No hay sesión iniciada.";
        }
    }
    
    public function importarMovimientoNavisionHardware()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("itemsFile");
        
        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'itemsFile' => [
                'mime_in[itemsFile,text/csv,text/plain]',
                'ext_in[itemsFile,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 17);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $idHardware = $data[0];
                $movido     = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                
                //Validamos ICCID
                if(!is_numeric($idHardware) && $idHardware != null && $idHardware != '')
                {
                    $filasError[$fila]['ICCID'] = "EL ID HARDWARE NO ES VÁLIDO.";
                    $ejecutarInsert = false;
                }
                
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = $this->items['basePublic'].'/';
            $nombre = 'error.txt';
            $file = $this->items['basePublic'].'/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayUpdateNavision = array();
        
        $filainsert = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $filainsert++;
            if($filainsert > 1)
            {
                $a = trim($data[3]);
                //Asignamos valores de CSV a variables locales
                $idHardware = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $movido     = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");

                //Armar array de Linea e insertar datos:
                $arrayUpdateNavision[] = array (
                    'IDHardware'           => $idHardware, 
                    'EstadoNavision'        => (in_array($movido, array("Y", "YES", "SI", "1")) ? "MOV" : "NOM"), 
                    'FechaEstadoNavision'   => $fechaActual,
                    'UsuarioEstadoNavision' => $this->items['id'],
                    'UsuarioModifica'       => $this->items['id'],
                    'FechaModifica'         => $fechaActual,
                    'Localhost'             => $this->request->getIPAddress()
                );

            }
        }

        fclose($handleInsert);
        
        $statusUpdate = $this->hardware->updateBatch($arrayUpdateNavision, 'IDHardware');
        
        if($statusUpdate !== FALSE)
        {
            $message = sprintf($this->mensajeError->msg201, "Se actualizaron los registros solicitados.");
            echo $this->alertas->alertaExito($message);
            echo $this->alertas->refrescar(1);
            exit;
        }
    }
    
    public function subirCSVHardware()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("itemsFile");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'itemsFile' => [
                'mime_in[itemsFile,text/csv,text/plain]',
                'ext_in[itemsFile,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 31);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;
            
            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $hostname       = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $marca          = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $modelo         = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $serie          = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $tag            = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $procesador     = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                $generacion     = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                $ram            = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                $tiporam        = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
                $hdd            = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
                $ssd            = trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
                $pulgadas       = trim($data[11]," \t\n\r\0\x0B\xc2\xa0");
                $iniciogarantia = trim($data[12]," \t\n\r\0\x0B\xc2\xa0");
                $finalgarantia  = trim($data[13]," \t\n\r\0\x0B\xc2\xa0");
                $finalvidautil  = trim($data[14]," \t\n\r\0\x0B\xc2\xa0");
                $detalle        = trim($data[15]," \t\n\r\0\x0B\xc2\xa0");
                $albaran        = trim($data[16]," \t\n\r\0\x0B\xc2\xa0");
                $direccion      = trim($data[17]," \t\n\r\0\x0B\xc2\xa0");
                $area           = trim($data[18]," \t\n\r\0\x0B\xc2\xa0");
                $subarea        = trim($data[19]," \t\n\r\0\x0B\xc2\xa0");
                $nrofactura     = trim($data[20]," \t\n\r\0\x0B\xc2\xa0");
                $nrooc          = trim($data[21]," \t\n\r\0\x0B\xc2\xa0");
                $fechacompra    = trim($data[22]," \t\n\r\0\x0B\xc2\xa0");
                $preciocompra   = trim($data[23]," \t\n\r\0\x0B\xc2\xa0");
                $monedacompra   = trim($data[24]," \t\n\r\0\x0B\xc2\xa0");
                $usuario        = trim($data[25]," \t\n\r\0\x0B\xc2\xa0");
                $tipoasignado   = trim($data[26]," \t\n\r\0\x0B\xc2\xa0");
                $obsasignado    = trim($data[27]," \t\n\r\0\x0B\xc2\xa0");
                $fechaasignado  = trim($data[28]," \t\n\r\0\x0B\xc2\xa0");
                $obselemento    = trim($data[29]," \t\n\r\0\x0B\xc2\xa0");
                $montoreposicion= trim($data[30]," \t\n\r\0\x0B\xc2\xa0");
                
                // $filasError[$fila]['FECHAS'] = $iniciogarantia.'-'.strtotime($iniciogarantia).'-'.$finalgarantia.'-'.$finalvidautil;

                //Validamos existencia de Modelo:
                $whereDispositivos = array("modelo" => $modelo, "marca" => $marca);
                //$datosDispositivos = $this->dispositivos->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left')->where($whereDispositivos)->first();

                $datosDispositivos = $this->dispositivos->listadoDispositivosXFiltros($whereDispositivos);
                if(empty($datosDispositivos))
                {
                    $filasError[$fila]['MODELO-MARCA'] = "EL MODELO NO SE ENCUENTRA EN LA MARCA INGRESADA";
                    $ejecutarInsert = false;
                }
                else
                {
                    if(count($datosDispositivos) > 1)
                    {
                        $filasError[$fila]['MODELO-MARCA'] = "SE ENCONTRÓ MODELO DUPLICADO EN LA MARCA. REVISAR BASE DE DATOS";
                        $ejecutarInsert = false;
                    }
                    else
                    {
                        //Validamos existencia de SERIE
                        $whereSerie = array("IDModelo" => $datosDispositivos[0]['IDDispositivo'], "Serie" => $serie);
                        $datosSerie = $this->hardware->where($whereSerie)->findAll();
                        if($serie != '' && !empty($datosSerie))
                        {
                            $filasError[$fila]['SERIE'] = "SERIE EXISTENTE";
                            $ejecutarInsert = false;
                        }

                        if($datosDispositivos[0]['id_categoria'] == "1")
                        {
                            //Validamos existencia de Hostname:
                            $datosHostname = $this->hardware->where("Hostname",trim($hostname))->first();
                            if($hostname != '' && !empty($datosHostname))
                            {
                                $filasError[$fila]['HOSTNAME'] = "HOSTNAME EXISTENTE";
                                $ejecutarInsert = false;
                            }

                            // //Validamos existencia de TAG:
                            $datostag = $this->hardware->where("TAG", trim($tag))->first();
                            if($tag != '' && !empty($datostag))
                            {
                                $filasError[$fila]['TAG'] = "TAG EXISTENTE";
                                $ejecutarInsert = false;
                            }
                            
                            //Validamos procesadores autorizados
                            if($procesador != "I5" && $procesador != "I7")
                            {
                                $filasError[$fila]['PROCESADOR'] = "ÚNICOS PROCESADORES AUTORIZADOS: 'I5' - 'I7'";
                                $ejecutarInsert = false;
                            }

                            //Validamos generaciones autorizados
                            if(!is_numeric($generacion))
                            {
                                $filasError[$fila]['GENERACION'] = "SOLO DEBE COLOCAR EL NÚMERO DE LA GENERACIÓN: 4, 5, 6, ETC.";
                                $ejecutarInsert = false;
                            }

                            //Validamos RAM
                            if(!is_numeric($ram))
                            {
                                $filasError[$fila]['RAM'] = "SOLO DEBE COLOCAR EL NÚMERO DE LA CAPACIDAD DE LA RAM";
                                $ejecutarInsert = false;
                            }
                            else if(!in_array($ram, array(8, 16, 32)))
                            {
                                $filasError[$fila]['RAM'] = "SOLO ESTÁN AUTORIZADAS LAS SIGUENTES CAPACIDADES: 8, 16, 32.";
                                $ejecutarInsert = false;
                            }

                            //Validamos HDD
                            if($hdd != '')
                            {
                                if(!is_numeric($hdd))
                                {
                                    $filasError[$fila]['HDD'] = "SOLO DEBE COLOCAR EL NÚMERO DE LA CAPACIDAD DEL HDD";
                                    $ejecutarInsert = false;
                                }
                            }

                            //Validamos SSD
                            if($ssd != '')
                            {
                                if(!is_numeric($ssd))
                                {
                                    $filasError[$fila]['SSD'] = "SOLO DEBE COLOCAR EL NÚMERO DE LA CAPACIDAD DEL SSD";
                                    $ejecutarInsert = false;
                                }
                            }
                        }

                        if($datosDispositivos[0]['id_categoria'] == "2" || $datosDispositivos[0]['id_tipo'] == "1")
                        {
                            //Validamos PULGADAS
                            if(!is_numeric($pulgadas))
                            {
                                $filasError[$fila]['PULGADAS'] = "SOLO DEBE COLOCAR EL NÚMERO DE LA PULGADA DEL ELEMENTO.";
                                $ejecutarInsert = false;
                            }
                            else if(!in_array($pulgadas, array(12, 13, 14, 18.5, 19.5, 19.9, 20.3, 20, 22, 24, 27)))
                            {
                                $filasError[$fila]['PULGADAS'] = "SOLO ESTÁN AUTORIZADAS LOS SIGUIENTES TAMAÑOS: 12, 13, 14, 18.5, 19.5, 19.9, 20.3, 20, 22, 24, 27.";
                                $ejecutarInsert = false;
                            }
                        }
                    }
                }
                
                if($monedacompra != '')
                {
                    if(!in_array($monedacompra, array("PEN", "EUR", "USD")))
                    {
                        $filasError[$fila]['MONEDA'] = "DEBE INGRESAR UNA MONEDA AUTORIZADA (PEN, EUR, USD)";
                        $ejecutarInsert = false;
                    }
                }
                else
                {
                    $filasError[$fila]['MONEDA'] = "DEBE INGRESAR LA MONEDA DE COMPRA";
                    $ejecutarInsert = false;
                }

                // //Validamos usuario correcto:
                if($usuario != '' && $usuario != null)
                {
                    $datosUsuario = $this->usuarios->buscarUsuarioXusuario($usuario);
                    
                    if(empty($datosUsuario))
                    {
                        $filasError[$fila]['USUARIO'] = "USUARIO NO VÁLIDO-".$usuario;
                        $ejecutarInsert = false;
                    }
                    else
                    {
                        if($datosUsuario['Cargo'] == '' || $datosUsuario['Cargo'] == null)
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE CARGO/PUESTO ACTUALIZADO: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['IDArea'] == '' || $datosUsuario['IDArea'] == null)
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE ÁREA DEPARTAMENTAL ACTUALIZADA: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['IDDireccion'] == '' || $datosUsuario['IDDireccion'] == null )
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE DIRECCIÓN DEPARTAMENTAL ACTUALIZADA: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['IDDelegacion'] == '' || $datosUsuario['IDDelegacion'] == null )
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE LA DELEGACIÓN ACTUALIZADA: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['Estado'] == 'Cesado' )
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO SE ENCUENTRA CESADO: ".$usuario;
                            $ejecutarInsert = false;
                        }
                    }
                }
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = $this->items['basePublic'].'/';
            $nombre = 'error.txt';
            $file = $this->items['basePublic'].'/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        //$arrayInsert = array();
        $arrayAsig = array();
        $arrayDetalleAsig = array();

        
        $filainsert = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $filainsert++;
            if($filainsert > 1)
            {
                $a = trim($data[3]);
                //Asignamos valores de CSV a variables locales
                $hostname       = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $marca          = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $modelo         = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $serie          = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $tag            = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $procesador     = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                $generacion     = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                $ram            = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                $tiporam        = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
                $hdd            = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
                $ssd            = trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
                $pulgadas       = trim($data[11]," \t\n\r\0\x0B\xc2\xa0");
                $iniciogarantia = trim($data[12]," \t\n\r\0\x0B\xc2\xa0");
                $finalgarantia  = trim($data[13]," \t\n\r\0\x0B\xc2\xa0");
                $finalvidautil  = trim($data[14]," \t\n\r\0\x0B\xc2\xa0");
                $detalle        = trim($data[15]," \t\n\r\0\x0B\xc2\xa0");
                $albaran        = trim($data[16]," \t\n\r\0\x0B\xc2\xa0");
                $direccion      = trim($data[17]," \t\n\r\0\x0B\xc2\xa0");
                $area           = trim($data[18]," \t\n\r\0\x0B\xc2\xa0");
                $subarea        = trim($data[19]," \t\n\r\0\x0B\xc2\xa0");
                $nrofactura     = trim($data[20]," \t\n\r\0\x0B\xc2\xa0");
                $nrooc          = trim($data[21]," \t\n\r\0\x0B\xc2\xa0");
                $fechacompra    = trim($data[22]," \t\n\r\0\x0B\xc2\xa0");
                $preciocompra   = trim($data[23]," \t\n\r\0\x0B\xc2\xa0");
                $monedacompra   = trim($data[24]," \t\n\r\0\x0B\xc2\xa0");
                $usuario        = trim($data[25]," \t\n\r\0\x0B\xc2\xa0");
                $tipoasignado   = trim($data[26]," \t\n\r\0\x0B\xc2\xa0");
                $obsasignado    = trim($data[27]," \t\n\r\0\x0B\xc2\xa0");
                $fechaasignado  = trim($data[28]," \t\n\r\0\x0B\xc2\xa0");
                $obselemento    = trim($data[29]," \t\n\r\0\x0B\xc2\xa0");
                $montoreposicion= trim($data[30]," \t\n\r\0\x0B\xc2\xa0");
                
                $detectaFormatoIG = strpos($iniciogarantia, "/");
                    
                if($detectaFormatoIG === false)
                {
                    $iniciogarantia = date("Y-m-d", strtotime($iniciogarantia));
                }
                else
                {
                    $iniciogarantia_e = $this->complementos->myUrlEncode($iniciogarantia);
                    $iniciogarantia = date('Y-m-d', strtotime(str_replace('/', '-', $iniciogarantia_e)));
                }
                
                $detectaFormatoFG = strpos($finalgarantia, "/");
                    
                if($detectaFormatoFG === false)
                {
                    $finalgarantia = date("Y-m-d", strtotime($finalgarantia));
                }
                else
                {
                    $finalgarantia_e = $this->complementos->myUrlEncode($finalgarantia);
                    $finalgarantia = date('Y-m-d', strtotime(str_replace('/', '-', $finalgarantia_e)));
                }
                
                $detectaFormatoFVU = strpos($finalvidautil, "/");
                    
                if($detectaFormatoFVU === false)
                {
                    $finalvidautil = date("Y-m-d", strtotime($finalvidautil));
                }
                else
                {
                    $finalvidautil_e = $this->complementos->myUrlEncode($finalvidautil);
                    $finalvidautil = date('Y-m-d', strtotime(str_replace('/', '-', $finalvidautil_e)));
                }
                
                $detectaFormatoFC = strpos($fechacompra, "/");
                    
                if($detectaFormatoFC === false)
                {
                    $fechacompra = date("Y-m-d", strtotime($fechacompra));
                }
                else
                {
                    $fechacompra_e = $this->complementos->myUrlEncode($fechacompra);
                    $fechacompra = date('Y-m-d', strtotime(str_replace('/', '-', $fechacompra_e)));
                }
                
                if($fechaasignado != '' && $fechaasignado != null)
                {
                    $detectaFormatoFA = strpos($fechaasignado, "/");
                        
                    if($detectaFormatoFA === false)
                    {
                        $fechaasignado = date("Y-m-d", strtotime($fechaasignado));
                    }
                    else
                    {
                        $fechaasignado_e = $this->complementos->myUrlEncode($fechaasignado);
                        $fechaasignado = date('Y-m-d', strtotime(str_replace('/', '-', $fechaasignado_e)));
                    }
                }
                else
                {
                    $fechaasignado = date("Y-m-d", strtotime($fechaActual));
                }
                
                if($preciocompra == '' || $preciocompra == null)
                {
                    $preciocompra = 0;
                }

                //Obtenemos información relevante
                
                $datosSubarea = $this->estructuraSubareas->obtenerSubareaXNombres($subarea, $area, $direccion);

                $whereDispositivos = array("modelo" => $modelo, "marca" => $marca);
                $datosDispositivos = $this->dispositivos->listadoDispositivosXFiltros($whereDispositivos);
                //Armar array de Linea e insertar datos:
                $data = array (
                    'IDModelo'              => $datosDispositivos[0]['IDDispositivo'],
                    'Serie'                 => $serie,
                    'InicioGarantia'        => $iniciogarantia,
                    'FinalGarantia'         => $finalgarantia,
                    'FinalVidaUtil'         => $finalvidautil,
                    'Detalle'               => $detalle,
                    'IDSubarea'             => $datosSubarea['IDSubarea'],
                    'Albaran'               => $albaran,
                    'Factura'               => $nrofactura,
                    'OrdenCompra'           => $nrooc,
                    'FechaCompra'           => $fechacompra,
                    'PrecioCompra'          => $preciocompra, 
                    'MonedaCompra'          => $monedacompra, 
                    'UsuarioCrea'           => $this->items['id'],
                    'FechaCrea'             => $fechaActual,  
                    'Localhost'             => $this->request->getIPAddress(),    
                    'UsuarioEstado'         => $this->items['id'],
                    'FechaEstado'           => $fechaActual,
                    'MotivoEstado'          => "Registro de hardware masivo.",
                    'Estado'                => 'ACT'
                );

                if($datosDispositivos[0]['id_categoria'] == "1")
                {
                    $data['Hostname']               = $hostname;
                    $data['TAG']                    = $tag;
                    $data['Procesador']             = $procesador;
                    $data['GeneracionProcesador']   = $generacion;
                    $data['RAM']                    = $ram;
                    $data['TipoRam']                = $tiporam;
                    $data['HDD']                    = $hdd;
                    $data['SSD']                    = $ssd;
                }

                if($datosDispositivos[0]['id_categoria'] == "2" || $datosDispositivos[0]['id_tipo'] == "1")
                {
                    $data['Pulgadas'] = $pulgadas;
                }

                $lastId = $this->hardware->insert($data, TRUE);

        		if($lastId !== FALSE){
        			if($usuario != '' && $usuario != null)
        			{
                        if(!array_key_exists($usuario, $arrayAsig)) 
                        {
                            $arrayAsig[$usuario] = array(
                                "TIPO"          => $tipoasignado,
                                "OBSERVACION"   => $obsasignado,
                                "FECHA"         => $fechaasignado);
                        }
                        
                        $arrayDetalleAsig[$usuario][] = array(
                            "TIPOELEMENTO"  => "HARDWARE",
                            "ELEMENTO"      => $lastId,
                            "OBSERVACION"   => $obselemento,
                            "MONEDA"        => $monedacompra,
                            "REPOSICION"    => ($montoreposicion != '' && $montoreposicion != NULL ? $montoreposicion : $preciocompra));
                
        			}
        		}
                
                $filainsert++;
                
            }
        }

        fclose($handleInsert);

        $arrayInsertAsign=array();
        
        foreach($arrayAsig as $usuario => $valor)
        {
            $datosAsignado = $this->usuarios->buscarUsuarioXusuario($usuario);
            $tokenAsignacion = $this->complementos->generar_string_aleatorio(15);
    
            $dataAsignacion = array (
                'UsuarioAsignado'       => $datosAsignado['IdUsuario'], 
                'CargoAsignado'         => $datosAsignado['Cargo'], 
                'AreaAsignado'          => $datosAsignado['IDArea'], 
                'DepartamentoAsignado'  => $datosAsignado['IDDireccion'], 
                'DelegacionAsignado'    => $datosAsignado['IDDelegacion'], 
                'FechaAsignado'         => $valor['FECHA'], 
                'TipoAsignado'          => $valor['TIPO'], 
                'Observacion'           => $valor['OBSERVACION'], 
                'UsuarioRemitente'      => $this->items['id'], 
                'CargoRemitente'        => $this->items['cargo'], 
                'AreaRemitente'         => $this->items['idArea'], 
                'DepartamentoRemitente' => $this->items['dpto'], 
                'TokenLinkFirma'        => $tokenAsignacion,
                'LiberadoFirma'         => 'Y',
                'UsuarioCrea'           => $this->items['id'],
                'FechaCrea'             => $fechaActual,    
                'Localhost'             => $this->request->getIPAddress()
            );
    
            $lastIdAsignacion = $this->asignaciones->insert($dataAsignacion, TRUE);
            
            if($lastIdAsignacion !== FALSE){
                $arrayInsertAsign[] = $lastIdAsignacion;
                
                $dataDetalle = array();
                
                foreach($arrayDetalleAsig[$usuario] as $detalle)
                {
                    $totalReposicion = 0;
        
                    $dataDetalle[] = array (
                        'IDAsignacion'      => $lastIdAsignacion, 
                        'TipoElemento'      => $detalle['TIPOELEMENTO'],  
                        'IDElemento'        => $detalle['ELEMENTO'], 
                        'Observacion'       => $detalle['OBSERVACION'], 
                        'MonedaReposicion'  => $detalle['MONEDA'], 
                        'MontoReposicion'   => $detalle['REPOSICION'], 
                        'UsuarioCrea'       => $this->items['id'],
                        'FechaCrea'         => $fechaActual,    
                        'Localhost'         => $this->request->getIPAddress()
                    );
                }
                $lastId = $this->detalleasignaciones->insertBatch($dataDetalle);
                
        		if($lastId === FALSE)
                {
                    $this->detalleasignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                    $this->asignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                    $message = sprintf($this->mensajeError->msg201, "<li>Se insertaron el total de ".($filainsert-1)." fila(s).</li><br><li>Hubo un problema al realizar las asignaciones. Inténtelo luego.</li>");
                    echo $this->alertas->alertaPeligro($message);
                    EXIT;
                }
            }
            else
            {
                $this->detalleasignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                $this->asignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                $message = sprintf($this->mensajeError->msg201, "<li>Se insertaron el total de ".($filainsert-1)." fila(s).</li><br><li>Hubo un problema al realizar las asignaciones. Inténtelo luego.</li>");
                echo $this->alertas->alertaPeligro($message);
                EXIT;
            }
                
        }
        
        $message = sprintf($this->mensajeError->msg201, "Se insertaron el total de ".($filainsert-1)." fila(s).");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }
	
	/**************************************************************************/
	
    /*************************** TARJETAS DE ACCESO ***************************/
    
    public function listarTarjetasAcceso()
    {
		if(isset($this->items['id']))
		{
		    $data = array (
				'session'                   => 'on',
				'titulo'                    => 'Tarjetas de Acceso | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Tarjetas de Acceso',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Listado de Tarjetas de Acceso",
				'subtitulo'                 => 'Tarjetas de Acceso'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('it/listar_tarjetas_acceso',$data);
		} 
		else 
		{
			return view('errors/500');
		}
	}
	
	public function tarjetasAccesoServerside()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR TARJETAS DE ACCESO */
            $dataServerside = $this->tarjetasAcceso->listaGeneralViewTarjetasAcceso($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
                $dataServerside["data"][$key]['PrecioTarjetaAcceso'] = 'S/ '.$value['PrecioCompra'];
                
                if($value['IDAsignado'] != '' && $value['IDAsignado'] != null )
                {
                    $dataServerside["data"][$key]['MatriculaAsignado'] = $value['MatriculaAsignado'];
                    $dataServerside["data"][$key]['Asignado'] = '<span class="badge '.($value['EstadoAsignado'] == 'Activo' ? 'bg-light text-dark' : 'bg-danger color-white').' border-0">'.$value['UsuarioAsignado'].'</span>';
                }
                else
                {
                    $dataServerside["data"][$key]['MatriculaAsignado'] = "No Asignado";
                    $dataServerside["data"][$key]['Asignado'] = "No Asignado";
                }
                
                $dataServerside["data"][$key]['NombreAsignado'] = ucwords(mb_strtolower($value['NombreAsignado']));
                
                
                
                
                if($value['Estado']=='ACT')
                {
                    $bg = "bg-success";
                }
                else if($value['Estado']=='BAJ')
                {
                    $bg = "bg-danger";
                }
                else
                {
                    $bg = "bg-warning";
                }
                
                $dataServerside["data"][$key]['EstadoTarjetaAcceso'] = '<span class="badge '.$bg.' border-0">'.$this->globales->estadosDispositivos()[$value['Estado']].' | '.$this->globales->motivoEstadoDispositivos($value['Estado'])[$value['Situacion']].'</span>';
                
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-tarjeta-acceso" data-bs-target="#informacionTarjetaAcceso" data-form="#formInformacionTarjetaAcceso" data-id="'.$value['IDTarjetaAcceso'].'" data-accion="ver" id="ver-tarjeta-acceso" data-tooltip="tooltip" title="Ver Tarjeta de Acceso">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDTAC", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-tarjeta-acceso" data-bs-target="#informacionTarjetaAcceso" data-form="#formInformacionTarjetaAcceso" data-id="'.$value['IDTarjetaAcceso'].'" data-accion="editar" id="editar-tarjeta-acceso" data-tooltip="tooltip" title="Editar Tarjeta de Acceso">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $acciones .= '<button class="badge bg-rosa border-0 p-2 mx-1 historico-asignaciones-tarjeta-acceso" data-bs-target="#mdlHistoricoAsignacionesTarjetaAcceso" data-id="'.$value['IDTarjetaAcceso'].'" data-tooltip="tooltip" title="Ver Histórico de Asignaciones">
    				<i class="mdi mdi-timeline-clock align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			$acciones .= '<div class="dropdown d-inline-block m-0 p-0">
    			    <button class="badge btn-soft-secondary m-0 p-0 p-2 mx-1 dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
						<i class="mdi mdi-dots-vertical align-bottom" style="font-size: 20px; color: #FFF;"></i>
					</button>
					<ul class="dropdown-menu dropdown-menu-end">';
					
						if (in_array("ADDITA", $this->items['permisos'])) 
						{
						   
						$acciones .= '<li>
							<a class="dropdown-item edit-item-btn" style="cursor: pointer;" data-bs-target="#editarDireccionesTarjetaAcceso" data-id="'.$value['IDTarjetaAcceso'].'" id="editar-direcciones-tarjeta-acceso">
								<i class="mdi mdi-sign-direction align-bottom me-2 text-muted"></i> Direcciones
							</a>
						</li>';
						
						}
						
						if (in_array("ADUBTA", $this->items['permisos'])) 
						{
						    
						$acciones .= '<li>
							<a href="'.$this->items['baseUrl'].'/listar-ubicaciones-tarjeta-acceso/'.$value['IDTarjetaAcceso'].'" class="dropdown-item">
								<i class="mdi mdi-access-point align-bottom me-2 text-muted"></i> Ubicaciones
							</a>
						</li>';
						
						}
						
					$acciones .= '</ul>
				</div>';
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
	}
	
    public function insertarTarjetaAcceso()
    {

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $serie          = $this->request->getPost('txtSerieTarjetaAcceso_i');
        $preciocompra   = $this->request->getPost('txtPrecioCompra_i');
        $observacion    = $this->request->getPost('txtObservacionTarjetaAcceso_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($serie, 'required|trim|numeric', 'Serie');
        $error .= $this->complementos->validaCampo($preciocompra, 'required|decimal|trim|minnumber[0]', 'Precio Compra');

        if ($error != '') 
        {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */
        $msgExistencia = '';
        
		$serieExistente = $this->tarjetasAcceso->where('Serie', $serie)->findAll();

        if($serieExistente != '' && count($serieExistente)>0)
        {
            $msgExistencia .= "<li>La serie ya fue registrada. [CAMPO] <small>SERIE</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $data = array (
            'Serie'             => $serie, 
            'PrecioCompra'      => ($preciocompra != '' && $preciocompra != null ? $preciocompra : 10),
            'Observacion'       => $observacion, 
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,  
            'Localhost'         => $this->request->getIPAddress(),    
            'Estado'            => "ACT",  
            'Situacion'         => "NUE",  
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => "Registro de tarjeta de acceso."
        );

        $lastId = $this->tarjetasAcceso->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $serie);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }  

	public function obtenerDatosTarjetaAcceso() 
	{
	    if (isset($this->items['id'])) 
	    {
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idTarjetaAcceso = $this->request->getPost('idTarjetaAcceso');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idTarjetaAcceso, 'trim', 'ID');
    
    		if ($error != '') 
    		{
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosTarjetaAcceso = $this->tarjetasAcceso->where("IDTarjetaAcceso",$idTarjetaAcceso)->first();
    
    		if(!empty($datosTarjetaAcceso))
    		{
    			$resultado = array(
    				'idtarjetaacceso'   => (string) $idTarjetaAcceso,
    				'serie'             => (string) $datosTarjetaAcceso['Serie'],
    				'precio'            => (string) $datosTarjetaAcceso['PrecioCompra'],
    				'observacion'       => (string) $datosTarjetaAcceso['Observacion']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado, JSON_NUMERIC_CHECK);
	    }
	    else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}

    public function modificarTarjetaAcceso($idTarjetaAcceso)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $serie          = $this->request->getPost('txtSerieTarjetaAcceso_i');
        $preciocompra   = $this->request->getPost('txtPrecioCompra_i');
        $observacion    = $this->request->getPost('txtObservacionTarjetaAcceso_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($serie, 'required|trim|numeric', 'Serie');
        $error .= $this->complementos->validaCampo($preciocompra, 'required|decimal|trim|minnumber[0]', 'Precio Compra');

        if ($error != '') 
        {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $data = array (
            'Serie'             => $serie, 
            'PrecioCompra'      => $preciocompra,
            'Observacion'       => $observacion, 
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->tarjetasAcceso->update([$idTarjetaAcceso], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idTarjetaAcceso);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function historicoAsignacionesTarjetaAcceso()
    {
        $html = '';
        
        if (isset($this->items['id'])) 
    	{
            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idTarjetaAcceso = $this->request->getPost('idTarjetaAcceso');
    		
    		/*
            * -------------
            * OBTENER INFORMACIÓN DE TABLA
            * -------------
            */
            
            $filtros = array(
                "TipoElemento"  => "TARJETA",
                "IDElemento"    => $idTarjetaAcceso
            );
    		
    		$datosTarjeta = $this->tarjetasAcceso->where("IDTarjetaAcceso",$idTarjetaAcceso)->first();
            $historico = $this->asignacionesDetalle->listadoHistoricoAsignacioneElemento($filtros);
            
            $html .= '<h3 class="mb-3">Tarjeta de Acceso</h3>
            <div class="card-text mb-3">
				<div class="form-group row">
					<div class="col-6">
						<label>Código</label>
						<input type="text" class="form-control" value="'.$idTarjetaAcceso.'" disabled>
					</div>
					<div class="col-6">
						<label>Serie</label>
						<input type="text" class="form-control" value="'.$datosTarjeta['Serie'].'" disabled>
					</div>
				</div>
			</div>
			<div class="card-text mb-3">
				<div class="form-group row">
					<div class="col-12">
						<label>Observación</label>
						<textarea class="form-control" rows="4" disabled>'.$datosTarjeta['Observacion'].'</textarea>
					</div>
				</div>
			</div>
			<hr>
			<h3 class="mb-3">Histórico de Asignaciones</h3>';
			
    		$html .= $this->estructuraHTMLHistoricoAsignacionElemento($historico);
    	} 
    	else 
    	{
            $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-10 col-10 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SESIÓN CERRADA</strong> - Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
        }
        
        echo $html;
    }
    
    public function subirCSVTarjetaAcceso()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("itemsFile");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'itemsFile' => [
                'mime_in[itemsFile,text/csv,text/plain]',
                'ext_in[itemsFile,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 17);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $serie          = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $precio         = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $observacion    = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $principal4     = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $cra4           = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $cpd4           = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                $principal5     = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                $comedor5       = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                $cpd5           = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
                $jppeatonal     = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
                $jpvehicular    = trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
                $usuario        = trim($data[11]," \t\n\r\0\x0B\xc2\xa0");
                $tipoasignado   = trim($data[12]," \t\n\r\0\x0B\xc2\xa0");
                $obsasignado    = trim($data[13]," \t\n\r\0\x0B\xc2\xa0");
                $fechaasignado  = trim($data[14]," \t\n\r\0\x0B\xc2\xa0");
                $obselemento    = trim($data[15]," \t\n\r\0\x0B\xc2\xa0");
                $montoreposicion= trim($data[16]," \t\n\r\0\x0B\xc2\xa0");
                
                //Validamos existencia de Serie:
                
                $datosTarjeta = $this->tarjetasAcceso->where("Serie", $serie)->first();
                if(!empty($datosTarjeta))
                {
                    $filasError[$fila]['SERIE'] = "LA SERIE YA FUE REGISTRADA";
                    $ejecutarInsert = false;
                }
                
                //Validamos existencia de Hostname:
                
                if($precio == '')
                {
                    $filasError[$fila]['PRECIO'] = "DEBE INGRESAR EL PRECIO";
                    $ejecutarInsert = false;
                }

                // //Validamos usuario correcto:
                if($usuario != '' && $usuario != null)
                {
                    $datosUsuario = $this->usuarios->buscarUsuarioXusuario($usuario);
                    
                    if(empty($datosUsuario))
                    {
                        $filasError[$fila]['USUARIO'] = "USUARIO NO VÁLIDO-".$usuario;
                        $ejecutarInsert = false;
                    }
                    else
                    {
                        if($datosUsuario['Cargo'] == '' || $datosUsuario['Cargo'] == null)
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE CARGO/PUESTO ACTUALIZADO: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['IDArea'] == '' || $datosUsuario['IDArea'] == null)
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE ÁREA DEPARTAMENTAL ACTUALIZADA: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['IDDireccion'] == '' || $datosUsuario['IDDireccion'] == null )
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE DIRECCIÓN DEPARTAMENTAL ACTUALIZADA: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['IDDelegacion'] == '' || $datosUsuario['IDDelegacion'] == null )
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE LA DELEGACIÓN ACTUALIZADA: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['Estado'] == 'Cesado' )
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO SE ENCUENTRA CESADO: ".$usuario;
                            $ejecutarInsert = false;
                        }
                    }
                }
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = $this->items['basePublic'].'/';
            $nombre = 'error.txt';
            $file = $this->items['basePublic'].'/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        //$arrayInsert = array();
        $arrayAsig = array();
        $arrayDetalleAsig = array();

        
        $filainsert = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $filainsert++;
            if($filainsert > 1)
            {
                $a = trim($data[3]);
                //Asignamos valores de CSV a variables locales
                $serie          = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $precio         = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $observacion    = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $principal4     = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $cra4           = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $cpd4           = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                $principal5     = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                $comedor5       = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                $cpd5           = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
                $jppeatonal     = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
                $jpvehicular    = trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
                $usuario        = trim($data[11]," \t\n\r\0\x0B\xc2\xa0");
                $tipoasignado   = trim($data[12]," \t\n\r\0\x0B\xc2\xa0");
                $obsasignado    = trim($data[13]," \t\n\r\0\x0B\xc2\xa0");
                $fechaasignado  = trim($data[14]," \t\n\r\0\x0B\xc2\xa0");
                $obselemento    = trim($data[15]," \t\n\r\0\x0B\xc2\xa0");
                $montoreposicion= trim($data[16]," \t\n\r\0\x0B\xc2\xa0");

                //Armar array de Tarjetas e insertar datos:
                $data = array (
                    'Serie'                 => $serie,
                    'PrecioCompra'          => $precio, 
                    'Observacion'           => $observacion, 
                    'UsuarioCrea'           => $this->items['id'],
                    'FechaCrea'             => $fechaActual,  
                    'Localhost'             => $this->request->getIPAddress(),    
                    'UsuarioEstado'         => $this->items['id'],
                    'FechaEstado'           => $fechaActual,
                    'MotivoEstado'          => "Registro de Tarjeta de Acceso masivo.",
                    'Estado'                => 'ACT'
                );
                
                $lastId = $this->tarjetasAcceso->insert($data, TRUE);

        		if($lastId !== FALSE)
        		{
        		    $dataUbicacion = array();
        		    $dataDireccion = array();
        		    
        		    if($principal4 != '')
        		    {
        		        $dataUbicacion[] = array(
        		            'IDTarjetaAcceso'   => $lastId,
        		            'IDUbicacionAcceso' => 1,
        		            'UsuarioRegistra'   => $this->items['id'],
        		            'FechaRegistra'     => $fechaActual
        		        );
        		    }
        		    
        		    if($cra4 != '')
        		    {
        		        $dataUbicacion[] = array(
        		            'IDTarjetaAcceso'   => $lastId,
        		            'IDUbicacionAcceso' => 2,
        		            'UsuarioRegistra'   => $this->items['id'],
        		            'FechaRegistra'     => $fechaActual
        		        );
        		    }
        		    
        		    if($cpd4 != '')
        		    {
        		        $dataUbicacion[] = array(
        		            'IDTarjetaAcceso'   => $lastId,
        		            'IDUbicacionAcceso' => 3,
        		            'UsuarioRegistra'   => $this->items['id'],
        		            'FechaRegistra'     => $fechaActual
        		        );
        		    }
        		    
        		    if($principal5 != '')
        		    {
        		        $dataUbicacion[] = array(
        		            'IDTarjetaAcceso'   => $lastId,
        		            'IDUbicacionAcceso' => 4,
        		            'UsuarioRegistra'   => $this->items['id'],
        		            'FechaRegistra'     => $fechaActual
        		        );
        		    }
        		    
        		    if($comedor5 != '')
        		    {
        		        $dataUbicacion[] = array(
        		            'IDTarjetaAcceso'   => $lastId,
        		            'IDUbicacionAcceso' => 5,
        		            'UsuarioRegistra'   => $this->items['id'],
        		            'FechaRegistra'     => $fechaActual
        		        );
        		    }
        		    
        		    if($cpd5 != '')
        		    {
        		        $dataUbicacion[] = array(
        		            'IDTarjetaAcceso'   => $lastId,
        		            'IDUbicacionAcceso' => 6,
        		            'UsuarioRegistra'   => $this->items['id'],
        		            'FechaRegistra'     => $fechaActual
        		        );
        		    }
        		    
        		    if($jppeatonal != '')
        		    {
        		        $dataUbicacion[] = array(
        		            'IDTarjetaAcceso'   => $lastId,
        		            'IDUbicacionAcceso' => 7,
        		            'UsuarioRegistra'   => $this->items['id'],
        		            'FechaRegistra'     => $fechaActual
        		        );
        		    }
        		    
        		    if($jpvehicular != '')
        		    {
        		        $dataUbicacion[] = array(
        		            'IDTarjetaAcceso'   => $lastId,
        		            'IDUbicacionAcceso' => 8,
        		            'UsuarioRegistra'   => $this->items['id'],
        		            'FechaRegistra'     => $fechaActual
        		        );
        		    }
        		    
        		    if($principal4 != '' || $cra4 != '' || $cpd4 != '')
        		    {
        		        $dataDireccion[] = array(
        		            'IDTarjetaAcceso'   => $lastId,
        		            'IDDireccion'       => 10,
        		            'UsuarioRegistra'   => $this->items['id'],
        		            'FechaRegistra'     => $fechaActual
        		        );
        		    }
        		    
        		    if($principal5 != '' || $comedor5 != '' || $cpd5 != '')
        		    {
        		        $dataDireccion[] = array(
        		            'IDTarjetaAcceso'   => $lastId,
        		            'IDDireccion'       => 3,
        		            'UsuarioRegistra'   => $this->items['id'],
        		            'FechaRegistra'     => $fechaActual
        		        );
        		    }
        		    
        		    if($jppeatonal != '' || $jpvehicular != '')
        		    {
        		        $dataDireccion[] = array(
        		            'IDTarjetaAcceso'   => $lastId,
        		            'IDDireccion'       => 11,
        		            'UsuarioRegistra'   => $this->items['id'],
        		            'FechaRegistra'     => $fechaActual
        		        );
        		    }
        		    
        		    $this->tarjetasAccesoUbicaciones->insertBatch($dataUbicacion, TRUE);
        		    $this->tarjetasAccesoDirecciones->insertBatch($dataDireccion, TRUE);
        		    
        			if($usuario != '' && $usuario != null)
        			{
                        if(!array_key_exists($usuario, $arrayAsig)) 
                        {
                            $arrayAsig[$usuario] = array(
                                "TIPO"          => $tipoasignado,
                                "OBSERVACION"   => $obsasignado,
                                "FECHA"         => date("Y-m-d", strtotime($fechaasignado)));
                        }
                        
                        $arrayDetalleAsig[$usuario][] = array(
                            "TIPOELEMENTO"  => "TARJETA",
                            "ELEMENTO"      => $lastId,
                            "OBSERVACION"   => $obselemento,
                            "REPOSICION"    => ($montoreposicion != '' && $montoreposicion != NULL ? $montoreposicion : $precio));
                
        			}
        		}
                
                $filainsert++;
                
            }
        }

        fclose($handleInsert);
        
        $textoLegal = '';
        
        $infolegales = $this->legales->buscarLegalXactaXelementos("ASIGNACIÓN", array("TARJETA"));
        
        if(!empty($infolegales))
        {
            foreach($infolegales as $key=>$value)
            {
                $textoLegal.=$value['Titulo'];
                $textoLegal.="\n";
                $textoLegal.=$value['Texto'];
                $textoLegal.="\n";
            }
        }
        
        $arrayInsertAsign=array();
        
        foreach($arrayAsig as $user => $valor)
        {
            $datosAsignado = $this->usuarios->buscarUsuarioXusuario($user);
            $tokenAsignacion = $this->complementos->generar_string_aleatorio(15);
    
            $dataAsignacion = array(
                'UsuarioAsignado'       => $datosAsignado['IdUsuario'], 
                'CargoAsignado'         => $datosAsignado['Cargo'], 
                'DireccionAsignado'     => $datosAsignado['IDDireccion'], 
                'AreaAsignado'          => $datosAsignado['IDArea'], 
                'SubareaAsignado'       => $datosAsignado['IDSubarea'], 
                'DelegacionAsignado'    => $datosAsignado['IDDelegacion'],
                'FechaAsignado'         => $valor['FECHA'], 
                'TipoAsignado'          => $valor['TIPO'], 
                'Observacion'           => $valor['OBSERVACION'], 
                'UsuarioRemitente'      => $this->items['id'], 
                'CargoRemitente'        => $this->items['cargo'],  
                'DireccionRemitente'    => $this->items['dpto'], 
                'AreaRemitente'         => $this->items['idArea'], 
                'SubareaRemitente'      => $this->items['idSubarea'], 
                'DelegacionRemitente'   => $this->items['idDelegacionLog'],
                'Legales'               => $textoLegal,
                'TokenLinkFirma'        => $tokenAsignacion,
                'LiberadoFirma'         => 'Y',
                'UsuarioCrea'           => $this->items['id'],
                'FechaCrea'             => $fechaActual,    
                'Localhost'             => $this->request->getIPAddress()
            );
            
            $lastIdAsignacion = $this->asignaciones->insert($dataAsignacion, TRUE);
            
            if($lastIdAsignacion !== FALSE){
                $arrayInsertAsign[] = $lastIdAsignacion;
                
                $dataDetalle = array();
                
                foreach($arrayDetalleAsig[$usuario] as $detalle)
                {
                    $totalReposicion = 0;
        
                    $dataDetalle[] = array (
                        'IDAsignacion'      => $lastIdAsignacion, 
                        'TipoElemento'      => $detalle['TIPOELEMENTO'],  
                        'IDElemento'        => $detalle['ELEMENTO'], 
                        'Observacion'       => $detalle['OBSERVACION'], 
                        'MonedaReposicion'  => "PEN", 
                        'MontoReposicion'   => $detalle['REPOSICION'], 
                        'UsuarioCrea'       => $this->items['id'],
                        'FechaCrea'         => $fechaActual,    
                        'Localhost'         => $this->request->getIPAddress()
                    );
                }
                $lastIdDetAsigTarAcc = $this->detalleasignaciones->insertBatch($dataDetalle);
                
        		if($lastIdDetAsigTarAcc === FALSE)
                {
                    $this->detalleasignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                    $this->asignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                    $message = sprintf($this->mensajeError->msg201, "<li>Se insertaron el total de ".($filainsert-1)." fila(s).</li><br><li>Hubo un problema al realizar las asignaciones. Inténtelo luego1.</li>");
                    echo $this->alertas->alertaPeligro($message);
                    EXIT;
                }
            }
            else
            {
                $this->detalleasignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                $this->asignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                $message = sprintf($this->mensajeError->msg201, "<li>Se insertaron el total de ".($filainsert-1)." fila(s).</li><br><li>Hubo un problema al realizar las asignaciones. Inténtelo luego2.</li>");
                echo $this->alertas->alertaPeligro($message);
                EXIT;
            }
                
        }
        
        $message = sprintf($this->mensajeError->msg201, "Se insertaron el total de ".($filainsert-1)." fila(s).");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }
	
	/**************************************************************************/
	
    /******************** TARJETAS DE ACCESO - DIRECCIONES ********************/
    
    public function listadoDireccionesTarjetaAcceso()
    {
        if (isset($this->items['id']))
        {
            /*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            
    		$idTarjetaAcceso = $this->request->getPost('idTarjetaAcceso');
    		
    		$listadoDirecciones = $this->tarjetasAccesoDirecciones->listarDireccionesTarjetaAcceso($idTarjetaAcceso);
            
            $direcciones=array();
    
    		if (!empty($listadoDirecciones)) 
    		{
                foreach ($listadoDirecciones as $items) 
                {
                    $direcciones[] = array(
    					'iddireccion'   => (string) $items['id_direccion'],
             	        'direccion'     => (string) $items['Direccion'],
             	        'activo'        => (string) $items['ACTIVO']
                    );
                }
    
                $resultado = array(
    				'listadoDirecciones' => json_encode($direcciones)
    			);
            } 
            else 
            {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
        else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
    }
    
    public function guardarDireccionesTarjetaAcceso($idTarjetaAcceso)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $direcciones    = $this->request->getPost('direcciones');
        $nombre         = $this->request->getPost('nombre');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        $listadoDireccionesPrev = $this->tarjetasAccesoDirecciones->where("IDTarjetaAcceso", $idTarjetaAcceso)->findAll();

        if(count($listadoDireccionesPrev) > 0)
        {
            $this->tarjetasAccesoDirecciones->delete($idTarjetaAcceso);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataDirecciones = array();
        $direccionesAutorizadas = array();

        foreach($direcciones as $key => $value)
        {
            $dataDirecciones[] = array (
                'IDTarjetaAcceso'   => $idTarjetaAcceso, 
                'IDDireccion'       => $key,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
        }
        
        $lastId = $this->tarjetasAccesoDirecciones->insertBatch($dataDirecciones, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idTarjetaAcceso);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	/**************************************************************************/
	
    /******************** TARJETAS DE ACCESO - UBICACIONES ********************/
    
    public function listarUbicacionesTarjetaAcceso($idTarjetaAcceso)
    {
        if(isset($this->items['id']))
        {
			/* BUSCAR PERMISOS*/
            
			$listaUbicaciones   = $this->tarjetasAccesoUbicaciones->listarUbicacionesTarjetaAcceso($idTarjetaAcceso);
            $TarjetaAcceso      = $this->tarjetasAcceso->where("IDTarjetaAcceso", $idTarjetaAcceso)->first();
			$listaDirecciones   = $this->tarjetasAccesoDirecciones->listarDireccionesTarjetaAcceso($idTarjetaAcceso);

			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Ubicaciones de Tarjeta de Acceso | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Ubicaciones de Tarjeta de Acceso',
                'previo'                    => 'listar-tarjetas-acceso',
				'elementoSeleccionadoModulo'=> "Ubicaciones de Tarjetas de Acceso",
				'subtitulo'                 => 'Ubicaciones',
				'listaUbicaciones'          => $listaUbicaciones,
                'listaDirecciones'          => $listaDirecciones,
                'tarjetaSeleccionada'       => $TarjetaAcceso,
                'idTarjetaAcceso'           => $idTarjetaAcceso
			);
			
			$data = array_merge($data, $this->items);
			
			return view('it/listar_ubicaciones_tarjeta_acceso',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function guardarUbicacionesTarjetaAcceso($idTarjetaAcceso)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $ubicaciones = $this->request->getPost('ubicaciones') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';

        if(isset($ubicaciones) && empty($ubicaciones))
        {
            $error .= "<li>No hay permisos seleccionados.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        $listadoUbicacionesPrev = $this->tarjetasAccesoUbicaciones->where("IDTarjetaAcceso", $idTarjetaAcceso)->findAll();

        if(count($listadoUbicacionesPrev) > 0)
        {
            $this->tarjetasAccesoUbicaciones->delete($idTarjetaAcceso);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataUbicaciones = array();

        foreach($ubicaciones as $key => $value)
        {
            $dataUbicaciones[] = array (
                'IDTarjetaAcceso'   => $idTarjetaAcceso, 
                'IDUbicacionAcceso' => $key,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
        }
        
        $lastId = $this->tarjetasAccesoUbicaciones->insertBatch($dataUbicaciones, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idTarjetaAcceso);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	/**************************************************************************/
	
    /****************************** ACCESORIOS IT *****************************/
	
    public function listarAccesoriosIT()
    {
        if(isset($this->items['id']))
        {
		    $data = array (
				'session'                   => 'on',
				'titulo'                    => 'Accesorios IT | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Accesorios IT',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Listado de Accesorios IT",
				'subtitulo'                 => 'Accesorios IT'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('it/listar_accesorios_it',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function accesoriosITServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR ACCESORIOS IT */
            $dataServerside = $this->accesorios->listaGeneralAccesoriosIT($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
                $dataServerside["data"][$key]['GeneraCobroAccesorio'] = '<span class="badge '.($value['GeneraCobro'] == 'Y' ? 'bg-warning color-white' : 'bg-light text-dark').' border-0">'.($value['GeneraCobro'] == 'Y' ? 'SI' : 'NO').'</span>';
                
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-accesorio-it" data-bs-target="#informacionAccesorio" data-form="#formInformacionAccesorioIT" data-id="'.$value['IDAccesorio'].'" data-accion="ver" id="ver-accesorio-it" data-tooltip="tooltip" title="Ver Accesorio IT">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDAIT", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-accesorio-it" data-bs-target="#informacionAccesorio" data-form="#formInformacionAccesorioIT" data-id="'.$value['IDAccesorio'].'" data-accion="editar" id="editar-accesorio-it" data-tooltip="tooltip" title="Editar Accesorio IT">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $acciones .= '<button class="badge bg-morado border-0 p-2 mx-1 listar-movimientos-kardex-accesorios-it" data-bs-target="#movimientosKardexAccesoriosIT" data-accesorio="'.$value['IDAccesorio'].'" data-tooltip="tooltip" title="Ver Movimientos de Entrada y Salida del Accesorio">
    				<i class="mdi mdi-clipboard-list align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }

	public function insertarAccesorioIT()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $accesorio          = $this->request->getPost('txtAccesorioIT');
        $modelo             = $this->request->getPost('txtModeloComercial_i');
        $navision           = $this->request->getPost('txtCodNavisionAccesorioIT');
        $cantidadInicial    = $this->request->getPost('txtInicialAccesorioIT');
        $generaCobro        = $this->request->getPost('chkGeneraCobroAccesorioIT_i');
        $precioNuevo        = $this->request->getPost('txtPrecioNuevoAccesorioIT');
        $precioReutilizado  = $this->request->getPost('txtPrecioReutilizadoAccesorioIT');
        $observacion        = $this->request->getPost('txtObservacionAccesorio_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($accesorio, 'required|trim|minlength[1]|maxlength[150]', 'Accesorio');
        $error .= $this->complementos->validaCampo($modelo, 'required|trim|numeric', 'Modelo');
        $error .= $this->complementos->validaCampo($navision, 'required|trim|minlength[1]|maxlength[10]', 'Código Navision');
        $error .= $this->complementos->validaCampo($cantidadInicial, 'required|trim|numeric', 'Cantidad');
        $error .= $this->complementos->validaCampo($precioNuevo, 'required|trim|decimal', 'Precio Nuevo');
        $error .= $this->complementos->validaCampo($precioReutilizado, 'required|trim|decimal', 'Precio Reutilizado');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        //Considerar la CantidadTotal en 0 y no con la variable $cantidadInicial ya que ese valor luego se suma en un trigger luego de insertar el kardex
        $dataAccesorio = array (
            'Accesorio'             => $accesorio,
            'IDModelo'              => $modelo,
            'CodigoNavision'        => $navision,
            'CantidadTotal'         => 0,
            'GeneraCobro'           => (isset($generaCobro) && !empty($generaCobro) && $generaCobro != '' && $generaCobro != NULL ? "Y" : "N"),
            'ReposicionNuevo'       => $precioNuevo,
            'ReposicionReutilizado' => $precioReutilizado,
            'Observacion'           => $observacion,
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress(),
            'UsuarioEstado'         => $this->items['id'],
            'FechaEstado'           => $fechaActual,    
            'MotivoEstado'          => "Creación de accesorio IT.",    
            'Estado'                => 'A'
        );
        
        $lastId = $this->accesorios->insert($dataAccesorio, TRUE);
        
		if($lastId !== FALSE){
		    
            $dataKardex = array (
                'IDAccesorio'       => $lastId,
                'CantidadPrevio'    => 0,
                'Concepto'          => "Registro Inicial",
                'Movimiento'        => "ENT",
                'Cantidad'          => $cantidadInicial,
                'IDUsuario'         => $this->items['id'],
                'IDDelegacion'      => $this->items['idDelegacionLog'],
                'IDSubarea'         => $this->items['idSubarea'],
                'IDArea'            => $this->items['idArea'],
                'IDDireccion'       => $this->items['dpto'],
                'IDCargo'           => $this->items['idCargoLog'],
                // 'RegistroInicial'   => "Y",
                'Observacion'       => "Registro inicial de elemento.",    
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual,
                'Localhost'         => $this->request->getIPAddress()
            );
            
            $lastId = $this->accesoriosKardex->insert($dataKardex, TRUE);
            
			$message = sprintf($this->mensajeError->msg502, $accesorio);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosAccesorioIT()
	{
	    if (isset($this->items['id'])) 
	    {
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idAccesorio = $this->request->getPost('idAccesorio');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idAccesorio, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosAccesorio = $this->accesorios->obtenerAccesorio($idAccesorio);
    
    		if(!empty($datosAccesorio))
    		{
    			$resultado = array(
    				'idaccesorio'   => (string) $idAccesorio,
    				'accesorio'     => (string) $datosAccesorio['Accesorio'],
    				'navision'      => (string) $datosAccesorio['CodigoNavision'],
    				'observacion'   => (string) $datosAccesorio['Observacion'],
    				'generacobro'   => (string) $datosAccesorio['GeneraCobro'],
    				'nuevo'         => (string) $datosAccesorio['ReposicionNuevo'],
    				'reutilizado'   => (string) $datosAccesorio['ReposicionReutilizado'],
    				'cantidad'      => (string) $datosAccesorio['CantidadTotal'],
    				'idmarca'       => (string) $datosAccesorio['IDMarca'],
    				'idmodelo'      => (string) $datosAccesorio['IDModelo']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);		
	    }
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
	public function modificarAccesorioIT($idAccesorio)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $accesorio      = $this->request->getPost('txtAccesorioIT');
        $modelo         = $this->request->getPost('txtModeloComercial_i');
        $generaCobro    = $this->request->getPost('chkGeneraCobroAccesorioIT_i');
        $precioNuevo        = $this->request->getPost('txtPrecioNuevoAccesorioIT');
        $precioReutilizado  = $this->request->getPost('txtPrecioReutilizadoAccesorioIT');
        $navision       = $this->request->getPost('txtCodNavisionAccesorioIT');
        $observacion    = $this->request->getPost('txtObservacionAccesorio_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($accesorio, 'required|trim|minlength[1]|maxlength[150]', 'Accesorio');
        $error .= $this->complementos->validaCampo($modelo, 'required|trim|numeric', 'Modelo');
        $error .= $this->complementos->validaCampo($navision, 'required|trim|minlength[1]|maxlength[10]', 'Código Navision');
        $error .= $this->complementos->validaCampo($precioNuevo, 'required|trim|decimal', 'Precio Nuevo');
        $error .= $this->complementos->validaCampo($precioReutilizado, 'required|trim|decimal', 'Precio Reutilizado');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'Accesorio'             => $accesorio,
            'IDModelo'              => $modelo,
            'CodigoNavision'        => $navision,
            'GeneraCobro'           => (isset($generaCobro) && !empty($generaCobro) && $generaCobro != '' && $generaCobro != NULL ? "Y" : "N"),
            'ReposicionNuevo'       => $precioNuevo,
            'ReposicionReutilizado' => $precioReutilizado,
            'Observacion'           => $observacion,
            'UsuarioModifica'       => $this->items['id'],
            'FechaModifica'         => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress()
        );

        $lastId = $this->accesorios->update([$idAccesorio], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $idAccesorio);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function listadoAccesoriosIT()
    {
        if(isset($this->items['id']))
        {
            $listado = $this->accesorios->listarAccesorios("A");
            
            $accesorios=array();
    
    		if (!empty($listado)) {
                foreach ($listado as $items) {
                    $accesorios[] = array(
    					'id' => (string) $items['IDAccesorio'],
                        'text' => (string) $items['Accesorio'].' | '.$items['Marca'].' '.$items['Modelo']
                    );
                }
    
                $resultado = array(
    				'listadoAccesoriosIT' => json_encode($accesorios)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
        } 
        else 
        {
    		$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);	
    }
	
	/**************************************************************************/
	
    /************************* ACCESORIOS IT - KARDEX *************************/
    
	public function guardarKardexAccesorioIT()
	{
	    $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        
        $tipoRegistro   = $this->request->getPost('tiporegistroKardex');
        $imputado       = $this->request->getPost('imputadoKardex');
        $accesorio      = $this->request->getPost('idaccesorioitKardex');
        $cantidad       = $this->request->getPost('cantidadKardex');
        $concepto       = $this->request->getPost('conceptoKardex');
        $observacion    = $this->request->getPost('observacionKardex');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        
        if(count(array_filter($tipoRegistro)) !== count($tipoRegistro))
        {
            $error .= "<li>Todos los registros deben tener un TIPO seleccionado.</li>";
        }
        
        if(empty($accesorio))
        {
            $error .= "<li>Debe agregar un Accesorio IT para registrar el movimiento.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
    
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
       */
        
        $dataKardex = array();

        foreach($tipoRegistro as $key=>$detalle)
        {
            $fechaActual = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
            
            if($detalle=="SAL")
            {
                $usuario = $this->usuarios->buscarUsuario($imputado[$key]);
                
                $dataKardex[] = array (
                    'IDAccesorio'       => $accesorio[$key], 
                    'Concepto'          => $concepto[$key],
                    'Movimiento'        => $detalle,
                    'Cantidad'          => $cantidad[$key],
                    'IDUsuario'         => $imputado[$key],
                    'IDDelegacion'      => $usuario['IDDelegacion'],
                    'IDSubarea'         => $usuario['IDSubarea'],
                    'IDArea'            => $usuario['IDArea'],
                    'IDDireccion'       => $usuario['IDDireccion'],
                    'IDCargo'           => $usuario['IDCargo'],
                    'Observacion'       => $observacion[$key], 
                    'UsuarioRegistra'   => $this->items['id'],
                    'FechaRegistra'     => $fechaActual,    
                    'Localhost'         => $this->request->getIPAddress()
                );
            }
            else
            {
                $dataKardex[] = array (
                    'IDAccesorio'       => $accesorio[$key], 
                    'Concepto'          => $concepto[$key],
                    'Movimiento'        => $detalle,
                    'Cantidad'          => $cantidad[$key],
                    'IDUsuario'         => $this->items['id'],
                    'IDDelegacion'      => $this->items['idDelegacionLog'],
                    'IDSubarea'         => $this->items['idSubarea'],
                    'IDArea'            => $this->items['idArea'],
                    'IDDireccion'       => $this->items['dpto'],
                    'IDCargo'           => $this->items['idCargoLog'],
                    'Observacion'       => $observacion[$key], 
                    'UsuarioRegistra'   => $this->items['id'],
                    'FechaRegistra'     => $fechaActual,    
                    'Localhost'         => $this->request->getIPAddress()
                );
            }
        }
        
        $lastId = $this->accesoriosKardex->insertBatch($dataKardex);
        
		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg201, "Se registraron los movimientos correctamente.");
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		} 
	}
	
	public function mostrarMovimientosKardexAccesorioIT()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $accesorio      = $this->request->getPost('idAccesorioIT');
        $fechaInicio    = $this->request->getPost('fechaInicio');
        $fechaFin       = $this->request->getPost('fechaFin');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($accesorio, 'required|trim|numeric', 'Accesorio');
        $error .= $this->complementos->validaCampo($fechaInicio, 'required|trim|dateDos', 'Fecha de Inicio');
        $error .= $this->complementos->validaCampo($fechaFin, 'required|trim|dateDos', 'Fecha Fin');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            $movimientos = '<div class="card col-xxl-7 col-md-12 col-12 m-0 border-sistema-2px">
                <div class="alert alert-warning" role="alert">'.$error.'</div>
            </div>';
            echo $movimientos;
            EXIT;
        }
        
        /*
        * ----------------------------
        * BÚSQUEDA DE INFORMACIÓN
        * ----------------------------
        */
        
        $whereMovimientos = array(
            'IDAccesorio'   => $accesorio,
            'FechaInicio'   => $fechaInicio,
            'FechaFinal'    => $fechaFin
        );
        
        $accesorioIT = $this->accesorios->where("IDAccesorio", $accesorio)->first();
        $listadoMovimientos = $this->accesoriosKardex->listadoMovimientosAccesorioIT($whereMovimientos);
        
        /*
        * ----------------------------
        * ARMADO ESTRUCTURA HTML
        * ----------------------------
        */
        
        $movimientos = '<div class="card col-xxl-7 col-md-12 col-12 m-0 border-sistema-2px">
            <div class="card-header d-flex justify-content-between align-items-center border-bottom-sistema-2px">
                <h5 class="card-title mb-0">'.$accesorioIT['Accesorio'].'</h5>
                <h5 class="card-title mb-0">Actual: '.$accesorioIT['CantidadTotal'].'</h5>
            </div>
            <div class="card-body">';
            if(!empty($listadoMovimientos))
            {
                foreach($listadoMovimientos as $item)
                {
                    $classMov = ($item['Movimiento'] == "SAL" ? "text-danger" : "text-success");
                    $simbolMov = ($item['Movimiento'] == "SAL" ? "-" : "+");
                    $iconMov = ($item['Movimiento'] == "SAL" ? "mdi mdi-minus-circle" : "mdi mdi-plus-circle");
                    $imputado = $this->usuarios->where("IdUsuario ", $item['IDUsuario'])->first();
                    
                    $movimientos .= '<div class="d-flex mb-3">
                        <div class="flex-shrink-0 d-flex justify-content-start align-items-center">
                            <i class="'.$iconMov.' '.$classMov.'" style="font-size: 35px;"></i>
                        </div>
                        <div class="flex-grow-1 ms-3 d-flex justify-content-start align-items-center">
                            <div>
                                <h6 class="m-0">'.ucwords(mb_strtolower($item['Concepto'])).'</h6>
                                <p class="text-muted mb-0">'.date("d-m-Y", strtotime($item['FechaRegistra'])).'</p>
                                <p class="text-muted mb-0" style="font-size: 10px;">'.$imputado['Matricula'].' | '.ucwords(mb_strtolower($imputado['Nombres'].' '.$imputado['Apellidos'])).'</p>
                            </div>
                        </div>
                        <div class="d-flex justify-content-start align-items-center">
                            <div>
                                <h6 class="'.$classMov.' mb-0">'.$simbolMov.' '.$item['Cantidad'].'</h6>
                                <p class="text-muted mb-0" style="font-size: 10px;">Previo: '.$item['CantidadPrevio'].'</p>
                            </div>
                        </div>
                    </div>';
                }
            }
            else
            {
                $movimientos .= '<div class="alert alert-info" role="alert">
                    <strong>NO </strong> hay movimientos en el periodo buscado.
                </div>';
            }
            $movimientos .= '</div>
        </div>';
        
        echo $movimientos;
	}
	
	public function listarRegistrosDescargasKardexAccesoriosIT()
	{
	    if(isset($this->items['id']))
        {
			/* ACCIONES */
			$listaDescargas = $this->accesoriosKardexDescargas->findAll();
			
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Registro de descargas | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Registro de Descargas',
                'previo'                    => 'listar-accesorios-it',
				'elementoSeleccionadoModulo'=> "Registro de descargas",
				'subtitulo'                 => 'Descargas de Registros',
				'listaDescargas'            => $listaDescargas
			);
			
			$data = array_merge($data, $this->items);
			
			return view('it/registros_descargas_kardex',$data);			
			
		} 
		else 
		{
			return view('errors/500');
		}
	}
	
	public function exportarKardexAccesorioIT()
	{
	    $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $reportes   = $this->request->getPost('reporte_rka');
        $fechaInicio= $this->request->getPost('dtInicio_rka');
        $fechaFin   = $this->request->getPost('dtFinal_rka');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($fechaInicio, 'required|trim|dateDos', 'Fecha de Inicio');
        $error .= $this->complementos->validaCampo($fechaFin, 'required|trim|dateDos', 'Fecha Fin');
        
        if(empty($reportes))
        {
            $error .= "<li>Debe seleccionar un reporte a exportar.</li>";
        }
        
        // Comparar las fechas
        if (strtotime($fechaInicio) > strtotime($fechaFin)) 
        {
            $error .= "<li>La fecha de inicio debe ser menor que la fecha final.</li>";
        }
            
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            $movimientos = '<div class="card col-xxl-12 col-md-12 col-12 m-0">
                <div class="alert alert-warning" role="alert">'.$error.'</div>
            </div>';
            echo $movimientos;
            EXIT;
        }
        
        /*
        * ----------------------------
        * EJECUCIÓN DE DESCARGA INDEPENDIENTE
        * ----------------------------
        */
        $mensajeGenerado = "";
        $scriptGenerado = "";
        
        foreach($reportes as $items)
        {
            $registroDescarga = $this->accesoriosKardexDescargas->where("TipoExportable", $items)->orderBy("FechaFinalExportable", "DESC")->first();
            
            if(!empty($registroDescarga))
            {
                $finalPrevio = date("Y-m-d", strtotime($registroDescarga['FechaFinalExportable']));
                
                if(strtotime($finalPrevio) < strtotime($fechaInicio) && strtotime($finalPrevio) < strtotime($fechaFin))
                {
                    $fechaInicio = date("Y-m-d", strtotime($finalPrevio. ' +1 day'));
                    $scriptGenerado .= "window.open('".base_url()."/exportar-traspaso-accesorios-it/".$fechaInicio."/".$fechaFin."/".$items."/NUEVO','_blank');";
                }
                else if(strtotime($finalPrevio) >= strtotime($fechaInicio) && strtotime($finalPrevio) < strtotime($fechaFin) )
                {
                    $fechaInicio = date("Y-m-d", strtotime($finalPrevio. ' +1 day'));
                    $scriptGenerado .= "window.open('".base_url()."/exportar-traspaso-accesorios-it/".$fechaInicio."/".$fechaFin."/".$items."/NUEVO','_blank');";
                }
                else
                {
                    $mensajeGenerado.="<li>No se puede evaluar periodo seleccionado: ".$items."-".$finalPrevio.".</li>";
                }
            }
            else
            {
                $scriptGenerado .= "window.open('".base_url()."/exportar-traspaso-accesorios-it/".$fechaInicio."/".$fechaFin."/".$items."/NUEVO','_blank');";
            }
        }
        
        $refresh = $this->alertas->refrescar(1);
        
        if($mensajeGenerado != "")
        {
            $mensajeGenerado = '<div class="card col-xxl-12 col-md-12 col-12 m-0">
                <div class="alert alert-warning" role="alert">'.$mensajeGenerado.'</div>
            </div>';
        }
        
        if($scriptGenerado != "")
        {
            $scriptGenerado = "<script>".$scriptGenerado."</script>";
        }
        
        
        echo $mensajeGenerado.$scriptGenerado.($mensajeGenerado == "" ? $refresh : "");
	}
	
	public function exportarTraspasosKardexAccesorioIT($fechaInicio, $fechaFin, $reporte, $tipoReporte)
	{
        $whereTraspaso = array(
            'FechaInicio'   => $fechaInicio,
            'FechaFinal'    => $fechaFin
        );
        
        $listadoTraspaso = $this->accesoriosKardex->cantidadTraspasoAccesorioIT($whereTraspaso);
        
        $filename = "Kardex Accesorios IT ".$fechaInicio." = ".$fechaFin.".csv";
        $writer = WriterEntityFactory::createCSVWriter();
        $writer->setFieldDelimiter(';');
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("Cod. Departamento"),
            WriterEntityFactory::createCell("Cod. Programa"),
            WriterEntityFactory::createCell("Cod. Almacén Destino"),
            WriterEntityFactory::createCell("Cod. Subalmacen Destino"),
            WriterEntityFactory::createCell("Cod. Producto"),
            WriterEntityFactory::createCell("Cantidad")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listadoTraspaso as $key=>$item)
        {
            $delegacion = $this->estructuraDelegaciones->where("IDDelegacion", $item['IDDelegacion'])->first();
            
            $cc = (string) !empty($delegacion) ? $delegacion['CC'] : "Sin información-".$item['IDDelegacion'];
            $ln = (string) !empty($delegacion) ? $delegacion['LN'] : "Sin información-".$item['IDDelegacion'];
            
			$cells = [
                WriterEntityFactory::createCell("930"),
                WriterEntityFactory::createCell("0"),
                WriterEntityFactory::createCell($cc),
                WriterEntityFactory::createCell($ln),
                WriterEntityFactory::createCell($item['Accesorio']),
                WriterEntityFactory::createCell($item['Total'])
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
        
        if($tipoReporte == "NUEVO")
        {
            $array = array(
                "Tipo"      => $reporte,
                "Inicio"    => $fechaInicio,
                "Final"     => $fechaFin
            );
            
            $this->registroGestionExportablesKardexAccesoriosIT($array);
        }
	}
	
	public function importarValidacionKardexAccesorioIT()
	{
	    $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $idRegistro     = $this->request->getPost('txtIDRegistroKardexAccesoriosIT');
        $nombreAdjunto  = $this->request->getPost('txtNombreAdjunto_rkait');
        
        $adjunto = $this->request->getFile("itemsFile");
// var_dump($adjunto);exit;

            // $fileName = $adjunto->getClientName();
            // $fileExtension = $adjunto->getClientExtension();
            // $mimeType = $adjunto->getMimeType();
            // echo "1: ".$fileName." 2: ".$fileExtension." 3: ".$mimeType;exit;
		/*
		* ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
         if (! $adjunto->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }

		/* ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        // $validationRule = [
        //     'itemsFile' => [
        //         'mime_in[itemsFile,application/vnd.ms-outlook,application/octet-stream,application/x-msg]',
        //         'ext_in[itemsFile,msg]'
        //     ],
        // ];
        
        // $validationRules = [
        //     'itemsFile' => [
        //         'rules'  => 'uploaded[itemsFile]|mime_in[itemsFile,application/vnd.ms-outlook,application/octet-stream,application/x-msg]|ext_in[itemsFile,msg]',
        //         'errors' => [
        //             'uploaded' => 'No se ha subido ningún archivo.',
        //             'mime_in'  => 'El archivo debe ser un archivo de tipo .msg.',
        //             'ext_in'   => 'El archivo debe tener la extensión .msg.',
        //         ],
        //     ],
        // ];
        
        $validationRules = [
            'itemsFile' => [
                'rules'  => 'uploaded[itemsFile]|mime_in[itemsFile,application/vnd.ms-outlook,application/octet-stream]',
                'errors' => [
                    'uploaded' => 'No se ha subido ningún archivo.',
                    'mime_in'  => 'El archivo debe ser un archivo .msg válido.',
                    // 'ext_in'   => 'El archivo debe tener la extensión .msg.',
                ],
            ],
        ];

        if (! $this->validate($validationRules)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        // if($adjunto->getClientExtension() != null)
        // {
        //     $extensionDoc = $adjunto->getClientExtension();
        // }
        // else if($adjunto->guessExtension() != null)
        // {
        //     $extensionDoc = $adjunto->guessExtension();
        // }
        // else
        // {
        //     $nombre_original = $adjunto->getBasename();
        //     $fileNameCmps = explode(".", $nombre_original);
        //     $extensionDoc = strtolower(end($fileNameCmps));
        // }
        
            if($adjunto->getClientExtension() != null)
            {
                $extensionDoc = strtolower($adjunto->getClientExtension());
            }
            else if($adjunto->guessExtension() != null)
            {
                $extensionDoc = strtolower($adjunto->guessExtension());
            }
            else
            {
                $extensionDoc = strtolower(pathinfo($adjunto->getClientName(), PATHINFO_EXTENSION));
            }

                    
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($idRegistro, 'required|trim|numeric', 'ID Registro');
        $error .= $this->complementos->validaCampo($nombreAdjunto, 'required|trim|alphaspecial', 'Nombre adjunto');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * GUARDAR ARCHIVO ADJUNTO
        * ----------------------------
        */
        
        $registroDescarga = $this->accesoriosKardexDescargas->where("IDRegistro", $idRegistro)->first();
        
        $ruta = $this->items['baseDinamic']."/docs/Kardex/AccesoriosIT/Validacion/".date("Y", strtotime($registroDescarga["FechaCrea"]))."/".date("m", strtotime($registroDescarga["FechaCrea"]))."/";
        
        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombre = $idRegistro.'.'.$extensionDoc;
            
            $estadoMove = $adjunto->move($ruta, $nuevonombre);
            
            if (!$estadoMove) {
                $message = sprintf($this->mensajeError->msg201, "<li>No se pudo guardar el archivo. Inténtelo luego.</li>");
                echo $this->alertas->alertaError($message);
                EXIT;
            }
            else
            {
                /*
                * ----------------------------
                * ACTUALIZACIÓN DE DATOS
                * ----------------------------
                */
                
                $dataDescarga = array (
                    'NombreAdjuntoValidacion'       => $nombreAdjunto,
                    'ExtensionAdjuntoValidacion'    => $extensionDoc,
                    'FechaAdjuntoValidacion'        => $fechaActual,
                    'UsuarioModifica'               => $this->items['id'],
                    'FechaModifica'                 => $fechaActual,
                    'Localhost'                     => $this->request->getIPAddress()
                );
                
        	    $lastId = $this->accesoriosKardexDescargas->update([$idRegistro], $dataDescarga);
        	    
        		if($lastId !== FALSE){
        			$message = sprintf($this->mensajeError->msg503, $nombreAdjunto);
        			echo $this->alertas->alertaExito($message);
        			echo $this->alertas->refrescar(1);
        		}
        		else
        		{
        		    $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al adjuntar la validación. Contáctese con Soporte IT.</li>");
                    echo $this->alertas->alertaError($message);
                    EXIT;
        		}
            }
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>No se encuentra la ruta para guardar el archivo. Contáctese con Soporte IT.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
	}
	
	public function registroGestionExportablesKardexAccesoriosIT($array)
	{
	    $fechaActual = date("Y-m-d H:i:s");
        
        $dataDescarga = array (
            'TipoExportable'        => $array['Tipo'],
            'FechaInicioExportable' => $array['Inicio'],
            'FechaFinalExportable'  => $array['Final'],
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,
            'Localhost'             => $this->request->getIPAddress()
        );
        
	    $this->accesoriosKardexDescargas->insert($dataDescarga, TRUE);
	}
	
	/**************************************************************************/
	
    /************************** PROVEEDORES ***********************************/
    
	/**************************************************************************/
	
    /********************* MODALIDAD DE PAGO - PROVEEDOR **********************/
    
	/**************************************************************************/
	
}