<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

class Configuracion extends BaseController
{
	public function __construct(){
	    
		$this->usuarios = new \App\Models\UsuarioModel();
		
 		$this->regionPais           = new \App\Models\RegionPaisModel();
        $this->regionDepartamento   = new \App\Models\RegionDepartamentoModel();
        $this->regionProvincia      = new \App\Models\RegionProvinciaModel();
        $this->regionDistrito       = new \App\Models\RegionDistritoModel();
        
        $this->estructuraSubareas   = new \App\Models\EstructuraSubareaModel();
        
        $this->marcas       = new \App\Models\Configuracion\MarcasModel();
        $this->dispositivos = new \App\Models\Configuracion\MarcasDispositivosModel();
        
        $this->operadores   = new \App\Models\Configuracion\OperadoresModel();
        $this->planes       = new \App\Models\Configuracion\OperadoresPlanesModel();
        
        $this->categorias   = new \App\Models\Configuracion\CategoriaModel();
        $this->tipos        = new \App\Models\Configuracion\TipoModel();
        $this->subtipos     = new \App\Models\Configuracion\SubTipoModel();
        
        $this->elementosDemo    = new \App\Models\Configuracion\ElementosDemoModel();
        $this->elementosTrabajo = new \App\Models\Configuracion\ElementosTrabajoModel();
	}

    /********************************* MARCAS *********************************/
    
	public function listarMarcas()
	{
		if(isset($this->items['id']))
		{
			/* ACCIONES */
			
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Marcas | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Marcas',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Listado de Marcas",
				'subtitulo'                 => 'Marcas'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('configuracion/listar_marcas',$data);
			
		} else {
			return view('errors/500');
		}
	}
	
	public function marcasServerside()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR MARCAS */
            $dataServerside = $this->marcas->listaGeneralMarcas($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESTMAR", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoMarca'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-marca" data-estado="'.$value['Estado'].'" data-id="'.$value['IDMarca'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoMarca'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-marca" data-bs-target="#informacionMarca" data-form="#formInformacionMarca" data-id="'.$value['IDMarca'].'" data-accion="ver" id="ver-marca" data-tooltip="tooltip" title="Ver Marca">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDMAR", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-marca" data-bs-target="#informacionMarca" data-form="#formInformacionMarca" data-id="'.$value['IDMarca'].'" data-accion="editar" id="editar-marca" data-tooltip="tooltip" title="Editar Marca">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $acciones .= '<a href="'.$this->items['baseUrl'].'/listar-dispositivos/'.$value['IDMarca'].'" class="badge bg-sistema border-0 p-2 mx-1" data-tooltip="tooltip" title="Ver modelos de dispositivos asociados">
    				<i class="mdi mdi-devices align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</a>';
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
	}
	
    public function insertarMarca()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $marca          = ucfirst(mb_strtolower($this->request->getPost('txtMarca_rm')));

        $modelo         = $this->request->getPost('modelo');
        // $categoria      = $this->request->getPost('categoria');
        // $tipo           = $this->request->getPost('tipo');
        $subtipo        = $this->request->getPost('subtipo');
        $descontinuado  = $this->request->getPost('descontinuado');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($marca, 'required|trim|alphaspecial|minlength[1]|maxlength[50]', 'Marca');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$marcaExistente = $this->marcas->where('Marca', $marca)->findAll();

        if(count($marcaExistente)>0)
        {
            $msgExistencia .= "<li>La marca ya fue registrado. [CAMPO] <small>MARCA</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * ARMADO DE REGISTRO DE MARCA
        * ----------------------------
        */

        $data = array (
            'Marca'         => $marca, 
            'FechaEstado'   => $fechaActual,
            'UsuarioEstado' => $this->items['id'],
            'Estado'        => 'A',
            'MotivoCambio'  => "Registro de marca.",  
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $lastId = $this->marcas->insert($data, TRUE);

		if($lastId !== FALSE)
		{
            /*
            * ----------------------------
            * ARMADO DE REGISTRO DE MODELO
            * ----------------------------
            */

		    if(!empty($modelo))
		    {
		        $dataDispositivo = array();
		        
		        foreach($modelo as $key => $value)
		        {
                    $dataDispositivo[] = array (
                        'IDMarca'       => $lastId, 
                        'Modelo'        => $value, 
                        'Subtipo'       => $subtipo[$key], 
                        'Descontinuado' => $descontinuado[$key],
                        'FechaEstado'   => $fechaActual,
                        'UsuarioEstado' => $this->items['id'],
                        'Estado'        => 'A',
                        'MotivoCambio'  => "Registro de dispositivo.",  
                        'UsuarioCrea'   => $this->items['id'],
                        'FechaCrea'     => $fechaActual,    
                        'Localhost'     => $this->request->getIPAddress()
                    );
		        }
		        
		        $lastIdDispositivos = $this->dispositivos->insertBatch($dataDispositivo);
		        
        		if($lastIdDispositivos === FALSE)
        		{
        		    $this->marcas->whereIn('IDMarca', $lastId)->delete();
        		    
        		    $message = sprintf($this->mensajeError->msg201, "No se pudo insertar la marca. Inténtelo luego.");
        			echo $this->alertas->alertaError($message);
        		}
		    }
		    
			$message = sprintf($this->mensajeError->msg502, $marca);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }  
    
	public function obtenerDatosMarca() 
	{
        if (isset($this->items['id'])) 
    	{
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idMarca = $this->request->getPost('idMarca');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idMarca, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosMarca = $this->marcas->where('IDMarca', $idMarca)->first();
    
    		if(!empty($datosMarca))
    		{
    			$resultado = array(
    				'idmarca' => (string) $idMarca,
    				'marca' => (string) $datosMarca['Marca']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }	
	}

    public function modificarMarca($idMarca)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $marca = ucfirst(mb_strtolower($this->request->getPost('txtMarca_i')));

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($marca, 'required|trim|alpha|minlength[1]|maxlength[50]', 'Marca');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'Marca'             => $marca,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        
        $lastId = $this->marcas->update([$idMarca], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idMarca);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function modificarEstadoMarca()
	{
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idMarca = $this->request->getPost('idMarca');
        $motivo = $this->request->getPost('motivo');
        $estado = $this->request->getPost('estado');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idMarca, 'required|trim|numeric', 'ID Marca');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');

        if ($error != '') 
        {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'FechaEstado'       => $fechaActual,
            'UsuarioEstado'     => $this->items['id'],
            'Estado'            => $estado,
            'MotivoCambio'      => $motivo,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        
        $lastId = $this->marcas->update([$idMarca], $data);

		if($lastId !== FALSE)
		{
			$message = sprintf($this->mensajeError->msg503, $idMarca);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function listadoMarcas()
	{
        if (isset($this->items['id'])) 
    	{
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            $listadoMarcas = $this->marcas->where("Estado", "A")->findAll();
            
            $marcas=array();
    
    		if (!empty($listadoMarcas)) {
                foreach ($listadoMarcas as $items) {
                    $marcas[] = array(
    					'id' => (string) $items['IDMarca'],
             	        'text' => (string) $items['Marca'],
                    );
                }
    
                $resultado = array(
    				'listadoMarcas' => json_encode($marcas)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
    	} 
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }	
	}

	/**************************************************************************/
	
    /****************************** DISPOSITIVOS ******************************/
    
	public function listarDispositivos($idMarca)
	{
		if(isset($this->items['id']))
		{
			/* ACCIONES */
			
			if($idMarca != "TOTAL")
			{
			    $marca = $this->marcas->where("IDMarca", $idMarca)->first();
			}
			else
			{
			    $marca = array();
			}
			
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Dispositivos | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Dispositivos',
                'previo'                    => 'listar-marcas',
				'elementoSeleccionadoModulo'=> "Dispositivos",
				'subtitulo'                 => 'Listado de Dispositivos',
                'idMarca'                   => $idMarca,
                'marca'                     => $marca
			);
			
			$data = array_merge($data, $this->items);
			
			return view('configuracion/listar_dispositivos',$data);			
		} 
		else 
		{
			return view('errors/500');
			
		}
	}
	
	public function dispositivosServerside()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id'],
                "IDMarca"   => $this->request->getPost('idMarca')
            );
            
            /* LISTAR DISPOSITIVOS */
            $dataServerside = $this->dispositivos->listaGeneralDispositivos($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESTDIS", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoDispositivo'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-dispositivo" data-estado="'.$value['Estado'].'" data-id="'.$value['IDDispositivo'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoDispositivo'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
    			$dataServerside["data"][$key]['ModeloDescontinuado'] = '<span class="badge '.($value['Descontinuado'] == 'Y' ? 'bg-warning color-white' : 'bg-light text-dark').' border-0">'.($value['Descontinuado'] == 'Y' ? 'SI' : 'NO').'</span>';
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-dispositivo" data-bs-target="#informacionDispositivo" data-form="#formInformacionDispositivo" data-id="'.$value['IDDispositivo'].'" data-marca="'.$value['IDMarca'].'" data-accion="ver" id="ver-dispositivo" data-tooltip="tooltip" title="Ver Dispositivo">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDDIS", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-dispositivo" data-bs-target="#informacionDispositivo" data-form="#formInformacionDispositivo" data-id="'.$value['IDDispositivo'].'" data-marca="'.$value['IDMarca'].'" data-accion="editar" id="editar-dispositivo" data-tooltip="tooltip" title="Editar Dispositivo">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
	}
	
    public function insertarDispositivo()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idMarca        = $this->request->getPost('txtIDMarca_i');
        $modelo         = $this->request->getPost('txtModelo_i');
        $subtipo        = $this->request->getPost('txtSubtipo_i');
        $descontinuado  = $this->request->getPost('chkModeloDescontinuado_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idMarca, 'required|trim|numeric', 'ID Marca');
        $error .= $this->complementos->validaCampo($modelo, 'required|trim|minlength[1]|maxlength[30]', 'Modelo');
        $error .= $this->complementos->validaCampo($subtipo, 'required|trim|numeric', 'Subtipo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        $whereModeloExistencia = array('Modelo' => $modelo, 'IDMarca' =>$idMarca, 'Subtipo' => $subtipo);
		$modeloExistente = $this->dispositivos->where($whereModeloExistencia)->findAll();
        
        if(count($modeloExistente)>0)
        {
            $msgExistencia .= "<li>El modelo ya fue registrado en la marca. [CAMPO] <small>MODELO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        $data = array (
            'IDMarca'       => $idMarca, 
            'Modelo'        => $modelo, 
            'Subtipo'       => $subtipo, 
            'Descontinuado' => ($descontinuado == '' ? "N" : "Y"),
            'FechaEstado'   => $fechaActual,
            'UsuarioEstado' => $this->items['id'],
            'Estado'        => 'A',
            'MotivoCambio'  => "Registro de dispositivo.",  
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $lastId = $this->dispositivos->insert($data, TRUE);

		if($lastId !== FALSE)
		{
			$message = sprintf($this->mensajeError->msg502, $modelo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }  

	public function obtenerDatosDispositivos() 
	{
        if (isset($this->items['id'])) 
    	{
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idDispositivo = $this->request->getPost('idDispositivo');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idDispositivo, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosDispositivos = $this->dispositivos->obtenerDispositivo($idDispositivo);
    
    		if(!empty($datosDispositivos))
    		{
    			$resultado = array(
    				'iddispositivo' => (string) $idDispositivo,
    				'modelo'        => (string) $datosDispositivos['Modelo'],
    				'idcategoria'   => (string) $datosDispositivos['id_categoria'],
    				'categoria'     => (string) $datosDispositivos['nombre_categoria'],
    				'idtipo'        => (string) $datosDispositivos['id_tipo'],
    				'tipo'          => (string) $datosDispositivos['nombre_tipo'],
    				'idsubtipo'     => (string) $datosDispositivos['Subtipo'],
    				'subtipo'       => (string) $datosDispositivos['nombre_subtipo'],
    				'idmarca'       => (string) $datosDispositivos['IDMarca'],
    				'descontinuado' => (string) $datosDispositivos['Descontinuado']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}

    public function modificarDispositivo($idDispositivo)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $modelo         = $this->request->getPost('txtModelo_i');
        $subtipo        = $this->request->getPost('txtSubtipo_i');
        $descontinuado  = $this->request->getPost('chkModeloDescontinuado_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($modelo, 'required|trim|minlength[1]|maxlength[30]', 'Modelo');
        $error .= $this->complementos->validaCampo($subtipo, 'required|trim|numeric', 'Subtipo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'Modelo'            => $modelo,
            'Subtipo'           => $subtipo,
            'Descontinuado'     => ($descontinuado == '' ? "N" : "Y"),
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        
        $lastId = $this->dispositivos->update([$idDispositivo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $modelo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarEstadoDispositivo()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idDispositivo = $this->request->getPost('idDispositivo');
        $motivo = $this->request->getPost('motivo');
        $estado = $this->request->getPost('estado');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idDispositivo, 'required|trim|numeric', 'ID Dispositivo');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');

        if ($error != '') 
        {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'FechaEstado'       => $fechaActual,
            'UsuarioEstado'     => $this->items['id'],
            'Estado'            => $estado,
            'MotivoCambio'      => $motivo,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        $lastId = $this->dispositivos->update([$idDispositivo], $data);

		if($lastId !== FALSE)
		{
			$message = sprintf($this->mensajeError->msg503, $idDispositivo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
	
	public function listadoDispositivos()
	{
        if (isset($this->items['id'])) 
    	{
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            
    		$idMarca = $this->request->getPost('idMarca');
            $categoria = $this->request->getPost('categoria');
    
            if($idMarca == 'TOTAL')
            {
                $whereDispositivos = array(
                    "estado" => "A",
                    'clave' => $categoria);
            }
            else
            {
                $whereDispositivos = array(
                    'idMarca' => $idMarca, 
                    "estado" => "A",
                    'clave' => $categoria);
                
            }
            
            $listadoDispositivos = $this->dispositivos->listadoDispositivos($whereDispositivos);
            
            $dispositivos=array();
    
    		if (!empty($listadoDispositivos)) {
                foreach ($listadoDispositivos as $items) {
                    $dispositivos[] = array(
    					'id' => (string) $items['IDDispositivo'],
             	        'text' => (string) $items['Modelo'],
                    );
                }
    
                $resultado = array(
    				'listadoDispositivos' => json_encode($dispositivos)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
    	} 
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }	
	}

	/**************************************************************************/
	
    /******************************* OPERADORES *******************************/
    
	public function listarOperadores()
	{
		if(isset($this->items['id']))
		{
			/* ACCIONES */
			
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Operadores | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Operadores',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Listado de Operadores",
				'subtitulo'                 => 'Operadores'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('configuracion/listar_operadores',$data);
		} 
		else
		{
			return view('errors/500');
		}
	}
	
	public function operadoresServerside()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR OPERADORES */
            $dataServerside = $this->operadores->listaGeneralOperadores($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESTOPE", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoOperador'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-operador" data-estado="'.$value['Estado'].'" data-id="'.$value['IDOperador'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoOperador'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-operador" data-bs-target="#informacionOperador" data-form="#formInformacionOperador" data-id="'.$value['IDOperador'].'" data-accion="ver" id="ver-operador" data-tooltip="tooltip" title="Ver Operador">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDOPE", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-operador" data-bs-target="#informacionOperador" data-form="#formInformacionOperador" data-id="'.$value['IDOperador'].'" data-accion="editar" id="editar-operador" data-tooltip="tooltip" title="Editar Operador">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $acciones .= '<a href="'.$this->items['baseUrl'].'/listar-planes/'.$value['IDOperador'].'" class="badge bg-sistema border-0 p-2 mx-1" data-tooltip="tooltip" title="Ver planes de Operadores">
    				<i class="mdi mdi-satellite-uplink align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</a>';
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
	}
	
    public function insertarOperador()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $operador       = $this->request->getPost('txtOperador_ro');
        $observacion    = $this->request->getPost('txtObservacion_ro');

        $planverisure           = $this->request->getPost('planverisure');
        $planoperador           = $this->request->getPost('planoperador');
        $precioplan             = $this->request->getPost('precioplan');
        $porcentajedescuento    = $this->request->getPost('porcentajedescuento');
        $preciofinal            = $this->request->getPost('preciofinal');
        $observacionplan        = $this->request->getPost('observacion');
        $capacidaddescarga      = $this->request->getPost('capacidaddescarga');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($operador, 'required|trim', 'Operador');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$operadorExistente = $this->operadores->where('Operador', $operador)->findAll();
        
        if(count($operadorExistente)>0)
        {
            $msgExistencia .= "<li>El operador ya fue registrado. [CAMPO] <small>OPERADOR</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * ARMADO DE REGISTRO DE OPERADOR
        * ----------------------------
        */

        $data = array (
            'Operador'      => $operador, 
            'Observacion'   => $observacion, 
            'FechaEstado'   => $fechaActual,
            'UsuarioEstado' => $this->items['id'],
            'Estado'        => 'A',
            'MotivoCambio'  => "Registro de operador.",  
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $lastId = $this->operadores->insert($data, TRUE);

		if($lastId !== FALSE)
		{
		    
            /*
            * ----------------------------
            * ARMADO DE REGISTRO DE PLAN
            * ----------------------------
            */

		    if(!empty($planverisure))
		    {
		        $dataPlan = array();
		        
		        foreach($planverisure as $key => $value)
		        {
                    $dataPlan[] = array (
                        'IDOperador'            => $lastId, 
                        'Plan'                  => $value, 
                        'PlanOperador'          => $planoperador[$key], 
                        'PrecioPlan'            => $precioplan[$key],
                        'PorcentajeDescuento'   => $porcentajedescuento[$key], 
                        'PrecioFinal'           => $preciofinal[$key],
                        'GBPlan'                => $capacidaddescarga[$key],
                        'Observacion'           => $observacionplan[$key],
                        'FechaEstado'           => $fechaActual,
                        'UsuarioEstado'         => $this->items['id'],
                        'Estado'                => 'A',
                        'MotivoCambio'          => "Registro de plan.",
                        'UsuarioCrea'           => $this->items['id'],
                        'FechaCrea'             => $fechaActual,    
                        'Localhost'             => $this->request->getIPAddress()
                    );
		        }
		        
		        $lastIdPlanes = $this->planes->insertBatch($dataPlan);
		        
        		if($lastIdPlanes === FALSE)
        		{
        		    $this->operadores->whereIn('IDOperador', $lastId)->delete();
        		    
        		    $message = sprintf($this->mensajeError->msg201, "No se pudo insertar el operador. Inténtelo luego.");
        			echo $this->alertas->alertaError($message);
        		}
		    }
		    
			$message = sprintf($this->mensajeError->msg502, $operador);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }  

	public function obtenerDatosOperador() 
	{
	    if (isset($this->items['id'])) 
    	{
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idOperador = $this->request->getPost('idOperador');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idOperador, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosOperador = $this->operadores->where('IDOperador', $idOperador)->first();
    
    		if(!empty($datosOperador))
    		{
    			$resultado = array(
    				'idoperador'    => (string) $idOperador,
    				'operador'      => (string) $datosOperador['Operador'],
    				'observacion'   => (string) $datosOperador['Observacion']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}

    public function modificarOperador($idOperador)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $operador = $this->request->getPost('txtOperador_i');
        $observacion = $this->request->getPost('txtObservacion_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($operador, 'required|trim', 'Operador');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'Operador'          => $operador,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        
        $lastId = $this->operadores->update([$idOperador], $data);

		if($lastId !== FALSE)
		{
			$message = sprintf($this->mensajeError->msg503, $idOperador);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function modificarEstadoOperador()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idOperador = $this->request->getPost('idOperador');
        $motivo     = $this->request->getPost('motivo');
        $estado     = $this->request->getPost('estado');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idOperador, 'required|trim|numeric', 'ID Operador');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'FechaEstado'       => $fechaActual,
            'UsuarioEstado'     => $this->items['id'],
            'Estado'            => $estado,
            'MotivoCambio'      => $motivo,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        
        $lastId = $this->operadores->update([$idOperador], $data);

		if($lastId !== FALSE)
		{
			$message = sprintf($this->mensajeError->msg503, $idOperador);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function listadoOperadores()
	{
	    if (isset($this->items['id'])) 
    	{
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            
            $listadoOperadores = $this->operadores->where("Estado", "A")->findAll();
            
            $operadores=array();
    
    		if (!empty($listadoOperadores)) 
    		{
                foreach ($listadoOperadores as $items) 
                {
                    $operadores[] = array(
    					'id' => (string) $items['IDOperador'],
             	        'text' => (string) $items['Operador'],
                    );
                }
    
                $resultado = array(
    				'listadoOperadores' => json_encode($operadores)
    			);
            } 
            else 
            {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
             
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}

	/**************************************************************************/
	
    /********************************* PLANES *********************************/
    
	public function listarPlanes($idOperador)
	{
		if(isset($this->items['id']))
		{
			/* ACCIONES */
			if($idOperador != "TOTAL")
			{
			    $operador = $this->operadores->where("IDOperador", $idOperador)->first();
			}
			else
			{
			    $operador = array();
			}
			
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Planes | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Planes',
                'previo'                    => 'listar-operadores',
				'elementoSeleccionadoModulo'=> "Planes",
				'subtitulo'                 => 'Listado de Planes',
                'idOperador'                => $idOperador,
                'operador'                  => $operador
			);
			
			$data = array_merge($data, $this->items);
			
			return view('configuracion/listar_planes',$data);
			
		} else {
			return view('errors/500');
		}
	}
    
	public function planesServerside()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id'],
                "IDOperador"   => $this->request->getPost('idOperador')
            );
            
            /* LISTAR PLANES */
            $dataServerside = $this->planes->listaGeneralPlanes($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESTPLA", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoPlan'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-plan" data-estado="'.$value['Estado'].'" data-id="'.$value['IDPlan'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoPlan'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
    			$dataServerside["data"][$key]['PrecioPlan'] = "S/. ".$value['PrecioPlan'];
    			$dataServerside["data"][$key]['PorcentajeDescuento'] = $value['PorcentajeDescuento']." %";
    			$dataServerside["data"][$key]['PrecioFinal'] = "S/. ".$value['PrecioFinal'];
    			$dataServerside["data"][$key]['CapacidadDescarga'] = $value['GBPlan']." GB";
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-plan" data-bs-target="#informacionPlan" data-form="#formInformacionPlan" data-id="'.$value['IDPlan'].'" data-operador="'.$value['IDOperador'].'" data-accion="ver" id="ver-operador" data-tooltip="tooltip" title="Ver Operador">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDPLA", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-plan" data-bs-target="#informacionPlan" data-form="#formInformacionPlan" data-id="'.$value['IDPlan'].'" data-operador="'.$value['IDOperador'].'" data-accion="editar" id="editar-operador" data-tooltip="tooltip" title="Editar Operador">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
	}
	
    public function insertarPlan()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idOperador     = $this->request->getPost('txtIDOperador_i');
        $plan           = $this->request->getPost('txtPlan_i');
        $planOperador   = $this->request->getPost('txtPlanOperador_i');
        $precioplan     = $this->request->getPost('txtPrecioPlan_i');
        $descuento      = $this->request->getPost('txtPorcentDescuento_i');
        $preciofinal    = $this->request->getPost('txtPrecioFinal_i');
        $capacidad      = $this->request->getPost('txtCapacidadDescarga_i');
        $observacion    = $this->request->getPost('txtObservacion_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idOperador, 'required|trim|numeric', 'ID Operador');
        $error .= $this->complementos->validaCampo($plan, 'required|trim|minlength[1]|maxlength[50]', 'Plan');
        $error .= $this->complementos->validaCampo($planOperador, 'required|trim|minlength[1]|maxlength[150]', 'Plan Operador');
        $error .= $this->complementos->validaCampo($precioplan, 'required|trim|decimal', 'Precio Plan');
        $error .= $this->complementos->validaCampo($descuento, 'required|trim|decimal', 'Descuento');
        $error .= $this->complementos->validaCampo($preciofinal, 'required|trim|decimal', 'Precio Final');
        $error .= $this->complementos->validaCampo($capacidad, 'required|trim', 'Capacidad');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        $wherePlanExistencia = array('Plan' => $plan, 'IDOperador' =>$idOperador);
		$planExistente = $this->planes->where($wherePlanExistencia)->findAll();
        
        if(count($planExistente)>0)
        {
            $msgExistencia .= "<li>El plan ya fue registrado en el operador. [CAMPO] <small>PLAN</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        $data = array (
            'IDOperador'            => $idOperador, 
            'Plan'                  => $plan, 
            'PlanOperador'          => $planOperador, 
            'PrecioPlan'            => $precioplan, 
            'PorcentajeDescuento'   => $descuento, 
            'PrecioFinal'           => $preciofinal, 
            'GBPlan'                => $capacidad, 
            'Observacion'           => $observacion, 
            'FechaEstado'           => $fechaActual,
            'UsuarioEstado'         => $this->items['id'],
            'Estado'                => 'A',
            'MotivoCambio'          => "Registro de plan.",  
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress()
        );

        $lastId = $this->planes->insert($data, TRUE);

		if($lastId !== FALSE)
		{
			$message = sprintf($this->mensajeError->msg502, $plan);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }  

	public function obtenerDatosPlan() 
	{
	    if (isset($this->items['id'])) 
    	{
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idPlan = $this->request->getPost('idPlan');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idPlan, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosPlan = $this->planes->where("IDPlan", $idPlan)->first();
    
    		if(!empty($datosPlan))
    		{
    			$resultado = array(
    				'idplan'        => (string) $idPlan,
    				'idoperador'    => (string) $datosPlan['IDOperador'],
    				'plan'          => (string) $datosPlan['Plan'],
    				'planoperador'  => (string) $datosPlan['PlanOperador'],
    				'precioplan'    => (string) $datosPlan['PrecioPlan'],
    				'descuento'     => (string) $datosPlan['PorcentajeDescuento'],
    				'preciofinal'   => (string) $datosPlan['PrecioFinal'],
    				'capacidad'     => (string) $datosPlan['GBPlan'],
    				'observacion'   => (string) $datosPlan['Observacion']
    			);
    		} else {
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}

    public function modificarPlan($idPlan)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $plan           = $this->request->getPost('txtPlan_i');
        $planOperador   = $this->request->getPost('txtPlanOperador_i');
        $precioplan     = $this->request->getPost('txtPrecioPlan_i');
        $descuento      = $this->request->getPost('txtPorcentDescuento_i');
        $preciofinal    = $this->request->getPost('txtPrecioFinal_i');
        $capacidad      = $this->request->getPost('txtCapacidadDescarga_i');
        $observacion    = $this->request->getPost('txtObservacion_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($plan, 'required|trim|minlength[1]|maxlength[50]', 'Plan');
        $error .= $this->complementos->validaCampo($planOperador, 'required|trim|minlength[1]|maxlength[150]', 'Plan Operador');
        $error .= $this->complementos->validaCampo($precioplan, 'required|trim|decimal', 'Precio Plan');
        $error .= $this->complementos->validaCampo($descuento, 'required|trim|decimal', 'Descuento');
        $error .= $this->complementos->validaCampo($preciofinal, 'required|trim|decimal', 'Precio Final');
        $error .= $this->complementos->validaCampo($capacidad, 'required|trim', 'Capacidad');
        $error .= $this->complementos->validaCampo($observacion, 'required|trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'Plan'                  => $plan,
            'PlanOperador'          => $planOperador,
            'PrecioPlan'            => $precioplan,
            'PorcentajeDescuento'   => $descuento,
            'PrecioFinal'           => $preciofinal,
            'GBPlan'                => $capacidad,
            'Observacion'           => $observacion,
            'UsuarioModifica'       => $this->items['id'],
            'FechaModifica'         => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress()
        );
        
        $lastId = $this->planes->update([$idPlan], $data);

		if($lastId !== FALSE)
		{
			$message = sprintf($this->mensajeError->msg503, $plan);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function modificarEstadoPlan()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idPlan = $this->request->getPost('idPlan');
        $motivo = $this->request->getPost('motivo');
        $estado = $this->request->getPost('estado');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idPlan, 'required|trim|numeric', 'ID Plan');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');

        if ($error != '') 
        {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'FechaEstado'       => $fechaActual,
            'UsuarioEstado'     => $this->items['id'],
            'Estado'            => $estado,
            'MotivoCambio'      => $motivo,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,
            'Localhost'         => $this->request->getIPAddress()
        );
        
        $lastId = $this->planes->update([$idPlan], $data);

		if($lastId !== FALSE)
		{
			$message = sprintf($this->mensajeError->msg503, $idPlan);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function listadoPlanes()
	{
	    if (isset($this->items['id'])) 
    	{
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
    		$idOperador = $this->request->getPost('idOperador');
    
            if($idOperador == 'TOTAL')
            {
                $listadoPlanes = $this->planes->where("Estado", "A")->findAll();
            }
            else
            {
                $wherePlanes = array('IDOperador' => $idOperador, "Estado" => "A");
                $listadoPlanes = $this->planes->where($wherePlanes)->findAll();
            }
            
            $planes=array();
    
    		if (!empty($listadoPlanes)) 
    		{
                foreach ($listadoPlanes as $items) 
                {
                    $planes[] = array(
    					'id' => (string) $items['IDPlan'],
             	        'text' => (string) $items['Plan'],
                    );
                }
    
                $resultado = array(
    				'listadoPlanes' => json_encode($planes)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}

	/**************************************************************************/
	
    /******************************* CATEGORÍAS *******************************/
    
    public function listarCategorias()
    {
        if(isset($this->items['id']))
        {
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Categorías | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Categorías',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Listado de Categorías",
				'subtitulo'                 => 'Categorías'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('configuracion/listar_categorias',$data);
		} 
		else 
		{
			return view('errors/500');	
		}
    }
    
    public function categoriasServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR CATEGORÍAS */
            $dataServerside = $this->categorias->listaGeneralCategorias($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESTCAT", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoCategoria'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-categoria" data-estado="'.$value['Estado'].'" data-id="'.$value['id_categoria'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoCategoria'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-categoria" data-bs-target="#informacionCategoria" data-form="#formInformacionCategoria" data-id="'.$value['id_categoria'].'" data-accion="ver" id="ver-categoria" data-tooltip="tooltip" title="Ver Categoría">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDCAT", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-categoria" data-bs-target="#informacionCategoria" data-form="#formInformacionCategoria" data-id="'.$value['id_categoria'].'" data-accion="editar" id="editar-categoria" data-tooltip="tooltip" title="Editar Categoría">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $acciones .= '<a href="'.$this->items['baseUrl'].'/listar-tipos-categoria/'.$value['id_categoria'].'" class="badge bg-sistema border-0 p-2 mx-1" data-tooltip="tooltip" title="Ver planes de Operadores">
    				<i class="mdi mdi-file-tree-outline align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</a>';
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }
    
    public function registrarCategoria()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $categoria      = ucfirst(mb_strtolower($this->request->getPost('txtNombreCategoria_i')));
        $clave          = $this->request->getPost('txtClaveCategoria_i');
        $observacion    = $this->request->getPost('txtObservacionCategoria_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($categoria, 'required|trim|alphaspecial|minlength[1]|maxlength[50]', 'Categoría');
        $error .= $this->complementos->validaCampo($clave, 'required|trim|alpha|minlength[1]|maxlength[10]', 'Palabra Clave');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$categoriaExistente = $this->categorias->where('nombre_categoria', $categoria)->findAll();
        
        if(count($categoriaExistente)>0)
        {
            $msgExistencia .= "<li>La categoría ya fue registrada. [CAMPO] <small>CATEGORÍA</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'nombre_categoria'  => $categoria,
            'clave'             => $clave,
            'observacion'       => $observacion,
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => 'A',
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => 'Categoría creada.'
        );

        $lastId = $this->categorias->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $categoria);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function obtenerDatosCategoria() 
	{
	    if (isset($this->items['id'])) 
    	{
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idCategoria = $this->request->getPost('idCategoria');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idCategoria, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosCategoria = $this->categorias->where('id_categoria', $idCategoria)->first();
    
    		if(!empty($datosCategoria))
    		{
    			$resultado = array(
    				'idcategoria'   => (string) $idCategoria,
    				'categoria'     => (string) $datosCategoria['nombre_categoria'],
    				'clave'         => (string) $datosCategoria['clave'],
    				'observacion'   => (string) $datosCategoria['observacion']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }	
	}
	
    public function modificarCategoria($idCategoria)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $categoria      = ucfirst(mb_strtolower($this->request->getPost('txtNombreCategoria_i')));
        $clave          = $this->request->getPost('txtClaveCategoria_i');
        $observacion    = $this->request->getPost('txtObservacionCategoria_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($categoria, 'required|trim|alphaspecial|minlength[1]|maxlength[50]', 'Categoría');
        $error .= $this->complementos->validaCampo($clave, 'required|trim|alpha|minlength[1]|maxlength[10]', 'Palabra Clave');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $data = array (
            'nombre_categoria'  => $categoria,
            'clave'             => $clave,
            'observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->categorias->update([$idCategoria], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idCategoria);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarEstadoCategoria()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idCategoria = $this->request->getPost('idCategoria');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idCategoria, 'required|trim|numeric', 'ID Categoría');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => $estado,
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => $motivo
        );
        
        $lastId = $this->categorias->update([$idCategoria], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idCategoria);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function obtenerCategorias()
	{
        if (isset($this->items['id'])) 
    	{
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            
            $listadoCategorias = $this->categorias->findAll();
            
            $categorias=array();
    
    		if (!empty($listadoCategorias))
    		{
                foreach ($listadoCategorias as $items) 
                {
                    $categorias[] = array(
    					'id'    => (string) $items['id_categoria'],
             	        'text'  => (string) $items['nombre_categoria'],
                    );
                }
    
                $resultado = array(
    				'listadoCategorias' => json_encode($categorias)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
	/**************************************************************************/
	
    /*************************** CATEGORÍAS - TIPOS ***************************/
    
    public function listarTiposCategoria($idCategoria)
    {
        if(isset($this->items['id']))
        {
			/* ACCIONES */
			if($idCategoria != "TOTAL")
			{
			    $categoria = $this->categorias->where('id_categoria', $idCategoria)->first();
			}
			else
			{
			    $categoria = array();
			}
			
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Tipos | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Tipos',
                'previo'                    => 'listar-categorias',
				'elementoSeleccionadoModulo'=> "Tipos",
				'subtitulo'                 => 'Listado de Tipos',
                'idCategoria'               => $idCategoria,
                'categoria'                 => $categoria
			);
			
			$data = array_merge($data, $this->items);
			
			return view('configuracion/listar_tipos_categoria',$data);
			
		} 
		else
		{
			return view('errors/500');
		}
    }
    
    public function tiposCategoriaServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"      => $this->items['idPerfil'],
                "IDUsuario"     => $this->items['id'],
                "IDCategoria"   => $this->request->getPost('idCategoria')
            );
            
            /* LISTAR TIPOS */
            $dataServerside = $this->tipos->listaGeneralTiposCategoria($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESTTIP", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoTipoCategoria'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-tipo-categoria" data-estado="'.$value['Estado'].'" data-id="'.$value['id_tipo'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoTipoCategoria'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-tipo-categoria" data-bs-target="#informacionTipoCategoria" data-form="#formInformacionTipoCategoria" data-id="'.$value['id_tipo'].'" data-categoria="'.$value['id_categoria'].'" data-accion="ver" id="ver-categoria" data-tooltip="tooltip" title="Ver Categoria">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDTIP", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-tipo-categoria" data-bs-target="#informacionTipoCategoria" data-form="#formInformacionTipoCategoria" data-id="'.$value['id_tipo'].'" data-categoria="'.$value['id_categoria'].'" data-accion="editar" id="editar-categoria" data-tooltip="tooltip" title="Editar Categoria">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $acciones .= '<a href="'.$this->items['baseUrl'].'/listar-subtipos-tipo/'.$value['id_tipo'].'" class="badge bg-sistema border-0 p-2 mx-1" data-tooltip="tooltip" title="Ver subtipos de tipo de categoría">
    				<i class="mdi mdi-file-tree align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</a>';
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }
    
    public function registrarTipoCategoria()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $categoria      = ucfirst(mb_strtolower($this->request->getPost('txtIDCategoria_i')));
        $tipo           = ucfirst(mb_strtolower($this->request->getPost('txtNombreTipoCategoria_i')));
        $observacion    = $this->request->getPost('txtObservacionTipoCategoria_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($categoria, 'required|trim|number', 'Categoría');
        $error .= $this->complementos->validaCampo($tipo, 'required|trim|alphaspecial|minlength[1]|maxlength[50]', 'Tipo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereTipo = array(
            'id_categoria'  => $categoria,
            'nombre_tipo'   => $tipo
        );
        
		$tipoExistente = $this->tipos->where($whereTipo)->findAll();
        
        if(count($tipoExistente)>0)
        {
            $msgExistencia .= "<li>El tipo ya fue registrado. [CAMPO] <small>TIPO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'id_categoria'      => $categoria,
            'nombre_tipo'       => $tipo,
            'observacion'       => $observacion,
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => 'A',
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => 'Tipo de categoría creada.'
        );

        $lastId = $this->tipos->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $tipo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function obtenerDatosTipoCategoria()
	{
	    if (isset($this->items['id'])) 
	    {
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idTipo = $this->request->getPost('idTipo');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idTipo, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosTipo = $this->tipos->where('id_tipo', $idTipo)->first();
    
    		if(!empty($datosTipo))
    		{
    			$resultado = array(
    				'idtipo'        => (string) $idTipo,
    				'tipo'          => (string) $datosTipo['nombre_tipo'],
    				'observacion'   => (string) $datosTipo['observacion']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
	    }
	    else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
    public function modificarTipoCategoria($idTipo)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $tipo           = $this->request->getPost('txtNombreTipoCategoria_i');
        $observacion    = $this->request->getPost('txtObservacionTipoCategoria_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($tipo, 'required|trim|alphaspecial|minlength[1]|maxlength[50]', 'Tipo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $data = array (
            'nombre_tipo'       => $tipo,
            'observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->tipos->update([$idTipo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idTipo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarEstadoTipoCategoria()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idTipo = $this->request->getPost('idTipo');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idTipo, 'required|trim|numeric', 'ID Tipo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => $estado,
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => $motivo
        );
        
        $lastId = $this->tipos->update([$idTipo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idTipo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function obtenerTipos()
	{
	    if (isset($this->items['id'])) 
    	{
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            
    		$idCategoria = $this->request->getPost('idCategoria');
    
            if($idCategoria == 'TOTAL')
            {
                $listadoTipos = $this->tipos->findAll();
            }
            else
            {
                $whereTipos = array('id_categoria' => $idCategoria);
                $listadoTipos = $this->tipos->where($whereTipos)->findAll();
            }
            
            $tipos = array();
    
    		if (!empty($listadoTipos))
    		{
                foreach ($listadoTipos as $items)
                {
                    $tipos[] = array(
    					'id' => (string) $items['id_tipo'],
             	        'text' => (string) $items['nombre_tipo'],
                    );
                }
    
                $resultado = array(
    				'listadoTipos' => json_encode($tipos)
    			);
            } 
            else 
            {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}

	/**************************************************************************/
	
    /********************* CATEGORÍAS - TIPOS - SUBTIPOS **********************/
    
    public function listarSubtiposTipoCategoria($idTipo)
    {
        if(isset($this->items['id']))
        {
            /* ACCIONES */
			if($idTipo != "TOTAL")
			{
			    $tipo = $this->tipos->obtenerTipo($idTipo);
			}
			else
			{
			    $tipo = array();
			}
			
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Subtipos | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Subtipos',
                'previo'                    => 'listar-tipos-categoria/'.$idTipo,
				'elementoSeleccionadoModulo'=> "Subtipos",
				'subtitulo'                 => 'Listado de Subtipos',
                'idTipo'                    => $idTipo,
                'tipo'                      => $tipo
			);
			
			$data = array_merge($data, $this->items);
			
			return view('configuracion/listar_subtipos_tipo_categoria',$data);
					
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function subtiposCategoriaServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id'],
                "IDTipo"    => $this->request->getPost('idTipoCategoria')
            );
            
            /* LISTAR TIPOS */
            $dataServerside = $this->subtipos->listaGeneralSubtiposCategoria($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESTSTI", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoSubtipo'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-subtipo-tipo-categoria" data-estado="'.$value['Estado'].'" data-id="'.$value['id_subtipo'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoSubtipo'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
                if($value['HabilitadoNavision'] == "Y")
                {
                    $dataServerside["data"][$key]['Navision'] = '<span class="badge bg-success border-0">SI</span>';
                }
                else
                {
                    $dataServerside["data"][$key]['Navision'] = '<span class="badge bg-danger border-0">NO</span>';
                }
                
                
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-subtipo-tipo-categoria" data-bs-target="#informacionSubtipoCategoria" data-form="#informacionSubtipoCategoria" data-id="'.$value['id_subtipo'].'" data-tipo="'.$value['id_tipo'].'" data-categoria="'.$value['id_categoria'].'" data-accion="ver" id="ver-subtipo-tipo-categoria" data-tooltip="tooltip" title="Ver Categoria">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDSTI", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-subtipo-tipo-categoria" data-bs-target="#informacionSubtipoCategoria" data-form="#informacionSubtipoCategoria" data-id="'.$value['id_subtipo'].'" data-tipo="'.$value['id_tipo'].'" data-categoria="'.$value['id_categoria'].'" data-accion="editar" id="editar-subtipo-tipo-categoria" data-tooltip="tooltip" title="Editar Categoria">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }
    
    public function registrarSubtipoTipoCategoria()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $tipo           = ucfirst(mb_strtolower($this->request->getPost('txtIDTipoCategoria_i')));
        $subtipo        = ucfirst(mb_strtolower($this->request->getPost('txtNombreSubtipoCategoria_i')));
        $navision       = $this->request->getPost('chkSubtipoHabilitadoNavision_i');
        $observacion    = $this->request->getPost('txtObservacionSubtipoCategoria_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($tipo, 'required|trim|number', 'Tipo');
        $error .= $this->complementos->validaCampo($subtipo, 'required|trim|alphaspecial|minlength[1]|maxlength[50]', 'Subtipo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereSubtipo = array(
            'id_tipo'           => $tipo,
            'nombre_subtipo'    => $subtipo
        );
        
		$subtipoExistente = $this->subtipos->where($whereSubtipo)->findAll();
        
        if(count($subtipoExistente)>0)
        {
            $msgExistencia .= "<li>El subtipo ya fue registrado. [CAMPO] <small>SUBTIPO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'id_tipo'           => $tipo,
            'nombre_subtipo'    => $subtipo,
            'HabilitadoNavision'=> (empty($navision) || $navision == '' || $navision == NULL ? "N" : "Y"),
            'observacion'       => $observacion,
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => 'A',
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => 'Subtipo de categoría creada.'
        );

        $lastId = $this->subtipos->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $subtipo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function obtenerDatosSubtipoTipoCategoria()
	{
	    if (isset($this->items['id'])) 
	    {
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idSubtipo = $this->request->getPost('idSubtipo');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idSubtipo, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosSubtipo = $this->subtipos->where('id_subtipo', $idSubtipo)->first();
    
    		if(!empty($datosSubtipo)){
    			$resultado = array(
    				'idsubtipo'     => (string) $idSubtipo,
    				'subtipo'       => (string) $datosSubtipo['nombre_subtipo'],
    				'navision'      => (string) $datosSubtipo['HabilitadoNavision'],
    				'observacion'   => (string) $datosSubtipo['observacion']
    			);
    		} else {
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
	    }
	    else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
    public function modificarSubtipoTipoCategoria($idSubtipo)
    {

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $subtipo        = ucfirst(mb_strtolower($this->request->getPost('txtNombreSubtipoCategoria_i')));
        $observacion    = $this->request->getPost('txtObservacionSubtipoCategoria_i');
        $navision       = $this->request->getPost('chkSubtipoHabilitadoNavision_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($subtipo, 'required|trim|alphaspecial|minlength[1]|maxlength[50]', 'Subtipo');
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $data = array (
            'nombre_subtipo'    => $subtipo,
            'observacion'       => $observacion,
            'HabilitadoNavision'=> (empty($navision) || $navision == '' || $navision == NULL ? "N" : "Y"),
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->subtipos->update([$idSubtipo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idSubtipo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarEstadoSubtipoTipoCategoria()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idSubtipo  = $this->request->getPost('idSubtipo');
        $estado     = $this->request->getPost('estado');
        $motivo     = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idSubtipo, 'required|trim|numeric', 'ID Subtipo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => $estado,
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => $motivo
        );
        
        $lastId = $this->subtipos->update([$idSubtipo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idSubtipo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function obtenerSubtipos()
	{
	    if (isset($this->items['id'])) 
    	{
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            
    		$idTipo = $this->request->getPost('idTipo');
    
            if($idTipo == 'TOTAL')
            {
                $listadoSubtipos = $this->subtipos->findAll();
            }
            else
            {
                $whereSubTipos = array('id_tipo' => $idTipo);
                $listadoSubtipos = $this->subtipos->where($whereSubTipos)->findAll();
            }
            
            $subtipos=array();
    
    		if (!empty($listadoSubtipos)) 
    		{
                foreach ($listadoSubtipos as $items) 
                {
                    $subtipos[] = array(
    					'id'    => (string) $items['id_subtipo'],
             	        'text'  => (string) $items['nombre_subtipo'],
                    );
                }
    
                $resultado = array(
    				'listadoSubtipos' => json_encode($subtipos)
    			);
            } 
            else 
            {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}

	/**************************************************************************/
	
    /***************************** ELEMENTOS DEMO *****************************/
    
    public function listarElementosDemo()
	{
    	if(isset($this->items['id']))
    	{
    	    
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Elementos Demo | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Elementos Demo',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Elementos Demo",
				'subtitulo'                 => 'Elementos Demo'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('configuracion/listar_elementos_demo',$data);			
		} 
		else 
		{
			return view('errors/500');
		}	
	}
    
	public function elementosDemoServerside()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR ELEMENTOS DEMO */
            $dataServerside = $this->elementosDemo->listaGeneralElementosDemo($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESTELD", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoElementoDemo'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-elemento-demo" data-estado="'.$value['Estado'].'" data-id="'.$value['IDElementoDemo'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoElementoDemo'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
    			$dataServerside["data"][$key]['CostoReposicion'] = 'S/ '.$value['PrecioReposicion'];
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-elemento-demo" data-bs-target="#informacionElementoDemo" data-form="#formInformacionElementoDemo" data-id="'.$value['IDElementoDemo'].'" data-accion="ver" id="ver-elemento-demo" data-tooltip="tooltip" title="Ver Elemento Demo">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDELD", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-elemento-demo" data-bs-target="#informacionElementoDemo" data-form="#formInformacionElementoDemo" data-id="'.$value['IDElementoDemo'].'" data-accion="editar" id="editar-elemento-demo" data-tooltip="tooltip" title="Editar Elemento Demo">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
	}
	
	public function insertarElementoDemo()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $nombreElemento     = ucwords(mb_strtolower($this->request->getPost('txtNombreElementoDemo_i')));
        $skuElemento        = $this->request->getPost('txtSKUElementoDemo_i');
        $observacion        = $this->request->getPost('txtObservacionElementoDemo_i');
        $precioReposicion   = $this->request->getPost('txtPrecioReposicionElementoDemo_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($nombreElemento, 'required|trim|minlength[1]|maxlength[150]', 'Descripción');
        $error .= $this->complementos->validaCampo($skuElemento, 'required|trim|minlength[1]|maxlength[30]', 'SKU');
        $error .= $this->complementos->validaCampo($precioReposicion, 'required|trim|minlength[1]|maxlength[30]', 'Precio Reposición');

        if ($error != '') 
        {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereExistencia = array(
            "SKU"   => $skuElemento
        );
        
		$elementoExistente = $this->elementosDemo->where($whereExistencia)->findAll();
        
        if(count($elementoExistente)>0)
        {
            $msgExistencia .= "<li>El SKU ya fue registrado. [CAMPO] <small>SKU</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'SKU'           => $skuElemento,
            'Nombre'        => $nombreElemento,
            'Observacion'   => $observacion,
            'PrecioReposicion'  => $precioReposicion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Creación de elemento.",    
            'Estado'        => 'A'
        );

        $lastId = $this->elementosDemo->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $nombreElemento);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosElementoDemo()
	{
	    if (isset($this->items['id'])) 
    	{
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idElementoDemo = $this->request->getPost('idElementoDemo');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idElementoDemo, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosElementoDemo = $this->elementosDemo->where('IDElementoDemo', $idElementoDemo)->first();
    
    		if(!empty($datosElementoDemo))
    		{
    			$resultado = array(
    				'idelementodemo'    => (string) $idElementoDemo,
    				'sku'               => (string) $datosElementoDemo['SKU'],
    				'detalle'           => (string) $datosElementoDemo['Nombre'],
    				'observacion'       => (string) $datosElementoDemo['Observacion'],
    				'precio'            => (string) $datosElementoDemo['PrecioReposicion']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
	public function modificarElementoDemo($idElementoDemo)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $nombreElemento = ucwords(mb_strtolower($this->request->getPost('txtNombreElementoDemo_i')));
        $skuElemento    = $this->request->getPost('txtSKUElementoDemo_i');
        $observacion    = $this->request->getPost('txtObservacionElementoDemo_i');
        $precioReposicion    = $this->request->getPost('txtPrecioReposicionElementoDemo_i');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($nombreElemento, 'required|trim|minlength[1]|maxlength[150]', 'Descripción');
        $error .= $this->complementos->validaCampo($skuElemento, 'required|trim|minlength[1]|maxlength[30]', 'SKU');
        $error .= $this->complementos->validaCampo($precioReposicion, 'required|trim|minlength[1]|maxlength[30]', 'Precio Reposición');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'SKU'               => $skuElemento,
            'Nombre'            => $nombreElemento,
            'Observacion'       => $observacion,
            'PrecioReposicion'  => $precioReposicion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->elementosDemo->update([$idElementoDemo], $data);

        if($lastId !== FALSE)
        {
            $message = sprintf($this->mensajeError->msg503, $nombreElemento);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }
	}
	
    public function modificarEstadoElementoDemo()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idElementoDemo = $this->request->getPost('idElementoDemo');
        $estado         = $this->request->getPost('estado');
        $motivo         = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idElementoDemo, 'required|trim|numeric', 'ID Elemento Demo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->elementosDemo->update([$idElementoDemo], $data);

		if($lastId !== FALSE)
		{
			$message = sprintf($this->mensajeError->msg503, $idElementoDemo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listadoElementosDemo()
    {
        if(isset($this->items['id']))
        {
            $listado = $this->elementosDemo->where("Estado", "A")->findAll();
            
            $elementos=array();
    
    		if (!empty($listado)) 
    		{
                foreach ($listado as $items) 
                {
                    $elementos[] = array(
    					'id' => (string) $items['IDElementoDemo'],
                        'text' => (string) $items['SKU'].' | '.$items['Nombre']
                    );
                }
    
                $resultado = array(
    				'listadoElementosDemo' => json_encode($elementos)
    			);
            } 
            else 
            {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);	
        } 
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			
			echo json_encode($resultado);
        }
    }
    
	/**************************************************************************/
	
    /*************************** ELEMENTOS TRABAJO ****************************/
	
	public function listarElementosTrabajo()
	{
    	if(isset($this->items['id']))
    	{
            $data = array (
				'session'                   => 'on',
				'titulo'                    => 'Elementos de Trabajo | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Elementos de Trabajo',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Elementos de Trabajo",
				'subtitulo'                 => 'Elementos de Trabajo'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('configuracion/listar_elementos_trabajo',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
	}
	
	public function elementosTrabajoServerside()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR ELEMENTOS DEMO */
            $dataServerside = $this->elementosTrabajo->listaGeneralElementosTrabajo($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESTETR", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoElementoTrabajo'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-elemento-trabajo" data-estado="'.$value['Estado'].'" data-id="'.$value['IDElementoTrabajo'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoElementoTrabajo'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-elemento-trabajo" data-bs-target="#informacionElementoTrabajo" data-form="#formInformacionElementosTrabajo" data-id="'.$value['IDElementoTrabajo'].'" data-accion="ver" id="ver-elemento-trabajo" data-tooltip="tooltip" title="Ver Elemento Trabajo">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDETR", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-elemento-trabajo" data-bs-target="#informacionElementoTrabajo" data-form="#formInformacionElementosTrabajo" data-id="'.$value['IDElementoTrabajo'].'" data-accion="editar" id="editar-elemento-trabajo" data-tooltip="tooltip" title="Editar Elemento Trabajo">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
	}
	
	public function insertarElementoTrabajo()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $nombreElemento     = ucwords(mb_strtolower($this->request->getPost('txtNombreElementoTrabajo_i')));
        $skuElemento        = $this->request->getPost('txtSKUElementoTrabajo_i');
        $monedaElemento     = $this->request->getPost('cboMonedaElementoTrabajo_i');
        $precioReposicion   = $this->request->getPost('txtPrecioElementoTrabajo_i');
        $clasificacion      = $this->request->getPost('cboClasificacionElementoTrabajo_i');
        $observacion        = $this->request->getPost('txtObservacionElementoTrabajo_i');
        $cantidad           = $this->request->getPost('txtCantidadElementoTrabajo_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($nombreElemento, 'required|trim|minlength[1]|maxlength[150]', 'Elemento');
        $error .= $this->complementos->validaCampo($skuElemento, 'required|trim|minlength[1]|maxlength[30]', 'SKU');
        $error .= $this->complementos->validaCampo($monedaElemento, 'required|trim|minlength[1]|maxlength[5]', 'Moneda');
        $error .= $this->complementos->validaCampo($clasificacion, 'required|trim|minlength[1]|maxlength[11]', 'Clasificación');
        $error .= $this->complementos->validaCampo($precioReposicion, 'required|trim|decimal', 'Precio Reposición');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');
        $error .= $this->complementos->validaCampo($cantidad, 'required|trim|numeric', 'Cantidad');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereExistencia = array(
            "SKU"   => $skuElemento
        );
        
		$elementoExistente = $this->elementosTrabajo->where($whereExistencia)->findAll();
        
        if(count($elementoExistente)>0)
        {
            $msgExistencia .= "<li>El SKU ya fue registrado. [CAMPO] <small>SKU</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $data = array (
            'SKU'               => $skuElemento,
            'Nombre'            => $nombreElemento,
            'CantidadStock'     => $cantidad,
            'Clasificacion'     => $clasificacion,
            'Observacion'       => $observacion,
            'MonedaReposicion'  => $monedaElemento,
            'PrecioReposicion'  => $precioReposicion,
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => "Creación de elemento.",    
            'Estado'            => 'A'
        );

        $lastId = $this->elementosTrabajo->insert($data, TRUE);

		if($lastId !== FALSE)
		{
			$message = sprintf($this->mensajeError->msg502, $nombreElemento);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosElementoTrabajo()
	{
	    if (isset($this->items['id']))
	    {
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idElementoTrabajo = $this->request->getPost('idElementoTrabajo');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idElementoTrabajo, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosElementoTrabajo = $this->elementosTrabajo->where('IDElementoTrabajo', $idElementoTrabajo)->first();
    
    		if(!empty($datosElementoTrabajo))
    		{
    			$resultado = array(
    				'idelemento'    => (string) $idElementoTrabajo,
    				'sku'           => (string) $datosElementoTrabajo['SKU'],
    				'nombre'        => (string) $datosElementoTrabajo['Nombre'],
    				'observacion'   => (string) $datosElementoTrabajo['Observacion'],
    				'clasificacion' => (string) $datosElementoTrabajo['Clasificacion'],
    				'moneda'        => (string) $datosElementoTrabajo['MonedaReposicion'],
    				'precio'        => (string) $datosElementoTrabajo['PrecioReposicion'],
    				'cantidad'      => (string) $datosElementoTrabajo['CantidadStock']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
	    }
	    else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
	public function modificarElementoTrabajo($idElementoTrabajo)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $nombreElemento     = ucwords(mb_strtolower($this->request->getPost('txtNombreElementoTrabajo_i')));
        $skuElemento        = $this->request->getPost('txtSKUElementoTrabajo_i');
        $monedaElemento     = $this->request->getPost('cboMonedaElementoTrabajo_i');
        $clasificacion      = $this->request->getPost('cboClasificacionElementoTrabajo_i');
        $precioReposicion   = $this->request->getPost('txtPrecioElementoTrabajo_i');
        $observacion        = $this->request->getPost('txtObservacionElementoTrabajo_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($nombreElemento, 'required|trim|minlength[1]|maxlength[150]', 'Elemento');
        $error .= $this->complementos->validaCampo($skuElemento, 'required|trim|minlength[1]|maxlength[30]', 'SKU');
        $error .= $this->complementos->validaCampo($monedaElemento, 'required|trim|minlength[1]|maxlength[5]', 'Moneda');
        $error .= $this->complementos->validaCampo($clasificacion, 'required|trim|minlength[1]|maxlength[11]', 'Clasificación');
        $error .= $this->complementos->validaCampo($precioReposicion, 'required|trim|decimal', 'Precio Reposición');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'SKU'               => $skuElemento,
            'Nombre'            => $nombreElemento,
            'Clasificacion'     => $clasificacion,
            'Observacion'       => $observacion,
            'MonedaReposicion'  => $monedaElemento,
            'PrecioReposicion'  => $precioReposicion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->elementosTrabajo->update([$idElementoTrabajo], $data);

        if($lastId !== FALSE)
        {
            $message = sprintf($this->mensajeError->msg503, $nombreElemento);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }
    }
	
	public function modificarEstadoElementoTrabajo()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idElementoTrabajo  = $this->request->getPost('idElementoTrabajo');
        $estado             = $this->request->getPost('estado');
        $motivo             = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idElementoTrabajo, 'required|trim|numeric', 'ID Elemento Trabajo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') 
        {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->elementosTrabajo->update([$idElementoTrabajo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idElementoTrabajo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listadoElementosTrabajo()
    {
        if(isset($this->items['id']))
        {
            $listado = $this->elementosTrabajo->where("Estado", "A")->findAll();
            
            $elementos=array();
    
    		if (!empty($listado)) 
    		{
                foreach ($listado as $items) 
                {
                    $elementos[] = array(
    					'id' => (string) $items['IDElementoTrabajo'],
                        'text' => (string) $items['Clasificacion'].' | '.$items['Nombre'].' '.$items['SKU']
                    );
                }
    
                $resultado = array(
    				'listadoElementosTrabajo' => json_encode($elementos)
    			);
            } 
            else 
            {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    		
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);	
        } 
        else 
        {
    		$resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
		}

    }
    
	/**************************************************************************/
	
    /******************* CUENTAS CONTABLES - SUBCATEGORÍAS ********************/
    
	/**************************************************************************/
	
    /************************** PROVEEDORES ***********************************/
    
	/**************************************************************************/
	
    /********************* MODALIDAD DE PAGO - PROVEEDOR **********************/
    
	/**************************************************************************/
	
}