<?php

namespace App\Controllers;

require_once APPPATH.'Libraries/spout-3.3.0/src/Spout/Autoloader/autoload.php';

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

use \App\Libraries\Veriactivos;
use \App\Libraries\Complementos;
use \App\Libraries\Globales;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;
use \App\Libraries\PlantillasCorreo;
use \App\Libraries\PlantillasPDF;

use App\Models\UsuarioModel;
use App\Models\UsuarioPerfilModel;
use App\Models\UsuarioRutasModel;
use App\Models\UsuarioSistemasModel;
use App\Models\ModulosRutasModel;
use App\Models\ModulosCabeceraModel;
use App\Models\UsuarioLogModel;
use App\Models\UsuarioGruposTrabajoModel;
use App\Models\NotificacionesModel;

/**
 * Class BaseController
 *
 * BaseController provides a convenient place for loading components
 * and performing functions that are needed by all your controllers.
 * Extend this class in any new controllers:
 *     class Home extends BaseController
 *
 * For security be sure to declare any new methods as protected or private.
 */
abstract class BaseController extends Controller
{
    /**
     * Instance of the main Request object.
     *
     * @var CLIRequest|IncomingRequest
     */
    protected $request;

    /**
     * An array of helpers to be loaded automatically upon
     * class instantiation. These helpers will be available
     * to all other controllers that extend BaseController.
     *
     * @var list<string>
     */
    protected $helpers = ['form', 'url'];

    /**
     * Be sure to declare properties for any property fetch you initialized.
     * The creation of dynamic property is deprecated in PHP 8.2.
     */
    protected $session;
    // protected $encripto;

    /**
     * @return void
     */
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        $fechaActual = date("Y-m-d H:i:s");
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
        
        $this->veriactivos = new Veriactivos();
        $this->complementos = new Complementos();
        $this->globales = new Globales();
        $this->scripts = new Scripts();
        $this->error = new Error();
        $this->alertas = new Alertas();	
        $this->pdf = new Pdf();
        $this->plantillasPDF = new PlantillasPDF();
        $this->plantillasCorreo = new PlantillasCorreo();
        $this->mensajeError = $this->error->msg();
        $this->session = \Config\Services::session();
        $this->encripto = service('encrypter');
		$this->items['baseUrl'] = base_url();
		$this->items['basePublic'] = 'public';
		$this->items['baseDinamic'] = 'public';
		$this->items['aleatorio'] = $this->complementos->generar_string_aleatorio(5);
		
        //Obtener url actual
        $uri = new \CodeIgniter\HTTP\URI($this->request->getUri());
        
        $ruta = $uri->getSegment(3);
		$this->items['raiz'] = $uri->getSegment(1);
		
        $rutasExcluidas = array('salir', 'entrar');
        $rutasExternas = $this->globales->urlExternos();
        
        //Si la ruta no est芍 incluida en las excluidas, ingresa a la validaci車n
        if(!in_array($ruta,$rutasExcluidas))
        {
            //Si la ruta no est芍 incluida en las externas, ingresa a la validaci車n
            if(!in_array($ruta,$rutasExternas))
            {
                if(isset($this->session->get('sesionUsuario')['accesoTmpId']))
                {
                    $this->usuarios = new UsuarioModel();
                    $this->usuarioPerfil = new UsuarioPerfilModel();
                    $this->usuarioRutas = new UsuarioRutasModel();
                    $this->usuarioSistemas = new UsuarioSistemasModel();
                    $this->modulosRutas = new ModulosRutasModel();
                    $this->modulosCabecera = new ModulosCabeceraModel();
    		        $this->log = new UsuarioLogModel();
    		        $this->notificaciones = new NotificacionesModel();
    
                    // if($this->session->get('sesionUsuario')['accesoTmpId'] != '4373')
                    // {
                        // $aud = array(
                        //     'IDUsuario'     => $this->session->get('sesionUsuario')['accesoTmpId'],
                        //     'FechaIngreso'  => $fechaActual,
                        //     'Plataforma'    => $uri->getSegment(1),
                        //     'URL'           => $uri->getSegment(3),
                        //     'JSON'          => null,
                        //     'Localhost'     => $this->request->getIPAddress()
                        // );
                        
                        // $this->log->insert($aud);
                    // }
                    
                    /*
                    * ----------------------
                    * VALIDA PERMISOS DE ACCESO AL SISTEMA
                    * ----------------------
                    */
                    
                    // $autorizacionSistema = $this->usuarioSistemas->join('sistemas', 'usuario_sistemas.IDSistema = sistemas.IDSistema AND usuario_sistemas.IdUsuario = "'.$this->session->get('sesionUsuario')['accesoTmpId'].'"  AND sistemas.Raiz = "compras"')->findAll();
                    
                    // if(!empty($autorizacionSistema))
                    // {
                        /*
                        * ----------------------
                        * VALIDA PERMISOS DE URL
                        * ----------------------
                        */
        
                        $array = array("ruta" => $ruta, "idusuario" => $this->session->get('sesionUsuario')['accesoTmpId']);
                        
                        $vista = $this->usuarioPerfil->obtenerRutaUsuario($array);
                        
                        $rutasGlobales = $this->globales->urlLibres();
    
                        if((count($vista)>0 && $vista['AUTORIZADO']=='1') || in_array($ruta,$rutasGlobales))
                        {
                        
                            /*
                            * ----------------------
                            * OBTENER NOTIFICACIONES NO VISTAS
                            * ----------------------
                            */
                            
                            $arrayNoVistos = array(
                                "idusuario" => $this->session->get('sesionUsuario')['accesoTmpId'],
                                "idperfil" => $this->session->get('sesionUsuario')['accesoTmpIDPerfil']
                            );
                            
                		    $arrayNoVistos = $this->notificaciones->cantidadNotificacionesSinVer($arrayNoVistos);
                		  //  $arrayNoVistos = array();
                            /*
                            * ----------------------
                            * ARMAR VARIABLES GLOBALES
                            * ----------------------
                            */
            
                            $this->items['id'] = $this->session->get('sesionUsuario')['accesoTmpId'];
                            $this->items['usuario'] = $this->session->get('sesionUsuario')['accesoTmpUsuario'];
                            $this->items['matriculaLog'] = $this->session->get('sesionUsuario')['accesoTmpMatricula'];
                            $this->items['idPerfil'] = $this->session->get('sesionUsuario')['accesoTmpIDPerfil'];
                            $this->items['perfil'] = $this->session->get('sesionUsuario')['accesoTmpPerfil'];
                            $this->items['dpto'] = $this->session->get('sesionUsuario')['accesoTmpIdDpto'];
                            $this->items['idArea'] = $this->session->get('sesionUsuario')['accesoTmpIdArea'];
                            $this->items['idSubarea'] = $this->session->get('sesionUsuario')['accesoTmpIdSubarea'];
                            $this->items['idDelegacionLog'] = $this->session->get('sesionUsuario')['accesoTmpIdDelegacion'];
                            $this->items['idCargoLog'] = $this->session->get('sesionUsuario')['accesoTmpIdCargo'];
                            
                            $this->items['notificacionesNoVistasInicio'] = isset($arrayNoVistos['TOTALNOVISTO']) ? $arrayNoVistos['TOTALNOVISTO'] : 0;
                            
                            $this->items['nombres'] = $this->session->get('sesionUsuario')['accesoTmpNombres'];
                            $this->items['apellidos'] = $this->session->get('sesionUsuario')['accesoTmpApellidos'];
                            $this->items['tipoDocumento'] = $this->session->get('sesionUsuario')['accesoTmpTipoDocumento'];
                            $this->items['numeroDocumento'] = $this->session->get('sesionUsuario')['accesoTmpNumeroDocumento'];
                            $this->items['correoElectronico'] = $this->session->get('sesionUsuario')['accesoTmpCorreoElectronico'];
                            $this->items['cargo'] = $this->session->get('sesionUsuario')['accesoTmpCargo'];
                            $this->items['navbar'] = $this->usuarioRutas->navBarUsuario($this->session->get('sesionUsuario')['accesoTmpId']);
                            $this->items['cabecera'] = $this->modulosCabecera->where("Estado","A")->orderBy('Orden', 'ASC')->findAll();
                            $this->items['linkbaseperfil'] = $vista['URLBase'];
                            
                            //Validar url externas
                            if(in_array($ruta, $rutasGlobales))
                            {
                                $rutaVista = $this->request->getPost('url_vista');
                                $this->items['permisos'] = array_column($this->modulosRutas->listadoPermisosUsuarioRuta($this->session->get('sesionUsuario')['accesoTmpId'], $rutaVista), 'Codigo');
                                $this->items['modulo'] = "Libre";
                            }
                            else
                            {
                                $this->items['permisos'] = array_column($this->modulosRutas->listadoPermisosUsuarioRuta($this->session->get('sesionUsuario')['accesoTmpId'], $ruta), 'Codigo');
                                $this->items['modulo'] = $this->modulosRutas->obtenerModulo(array("ruta"=>$ruta))['Modulo'];
                            }
                            
                            $this->items['sistemas'] = $this->usuarioSistemas->join('sistemas', 'usuario_sistemas.IDSistema = sistemas.IDSistema AND usuario_sistemas.IdUsuario = "'.$this->session->get('sesionUsuario')['accesoTmpId'].'"')->findAll();
    
                        }
                        else
                        {
                            echo $this->alertas->reDireccion($this->items['baseUrl'] . '/' .$vista['URLBase'], 1);
                            EXIT;
                        }
                    // }
                    // else
                    // {
                    //     if ($this->session->has('sesionUsuario')) {
                    //         $this->session->destroy('sesionUsuario');
                    //         $this->session->remove('sesionUsuario');
                    //     }
                        
                    //     echo $this->alertas->reDireccion($this->items['baseUrl'] . '/', 1);
                    // }
                } 
                else 
                {
                    // echo "sin sesion";exit;
                    $data = array (
                        'titulo' => 'Veriactivos | Verisure',
                    );
                    $data = array_merge($data, $this->items);
                    echo view('dashboard/iniciar-sesion',$data);exit;
                }
            }
        }
        // Preload any models, libraries, etc, here.

        // E.g.: $this->session = \Config\Services::session();
    }
    
    
    /**
    * FUNCIONES PARA COMPARTIR CON OTROS CONTROLLER
    */
    
    public function estructuraHTMLHistoricoAsignacionElemento($array)
    {
        $html = '';
        
        if(empty($array))
		{
		    $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-10 col-10 ">
        	        <div class="alert alert-info alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO ASIGNADO</strong> - El elemento aún no ha sido asignado.
                    </div>
                </div>
        	</div>';
		}
		else
		{
		    $html .= '<div class="">';
	    
		    foreach($array as $key => $value)
            {
                $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
    	            <div class="col-lg-8 col-12 d-flex justify-content-center align-items-center">
				        <div class="col-12 card card-light">
				            <div class="card-header">
                                <h3 class="card-title mb-0 text-center">'.(ucwords(mb_strtolower($value['NombreUsuarioAsignado']))).'</h3>
                            </div>
                            <div class="card-body row m-0 p-0">
                                <div class="col-12 d-flex m-0 p-0">
                                    <div class="col-6">
                                        <h4 class="m-0 my-2 color-orange text-center">Asignación:</h4>
                                        <div class="col-12 d-flex justify-content-center align-items-center">
                                            <div class="m-0 p-0">
                                                <a href="'.$this->items['baseUrl'].'/detalle-acta-asignacion/'.$value['IDAsignacion'].'/'.$value['TokenAsignacion'].'" target="_blank" class="col-12 d-flex justify-content-center align-items-center" style="cursor: pointer;">
                                                    <span class="mdi mdi-file-document-outline color-sistema" style="font-size: 90px;"></span>
                                                </a>
                                                <label class="col-12 m-0 my-2 fw-bold text-center color-sistema">'.date("d-m-Y", strtotime($value['FechaAsignacion'])).'</label>
                                                <label class="col-12 m-0 my-2 text-center color-sistema">'.(ucwords(mb_strtolower($value['NombreRemitenteAsignacion']))).'</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <h4 class="m-0 my-2 color-orange text-center">Devolución:</h4>
                                        <div class="col-12 d-flex justify-content-center align-items-center">
                                            <div class="m-0 p-0 position-relative">';
                                            if($value['IDDevolucion'] == NULL)
                                            {
                                                $html .= '<div class="alert alert-success alert-border-left alert-dismissible fade show mb-xl-0 text-center mt-3" role="alert">
                                                    <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>ASIGNADO</strong><br>Aún no se procesa la devolución.
                                                </div>';
                                            }
                                            else
                                            {
                                                $iconoValidado = $value['EstadoDetalleDevolucion'] == "REGIS" ? "mdi mdi-exclamation-thick" : ($value['EstadoDetalleDevolucion'] == "VALID" ? "mdi mdi-lightbulb" : "mdi mdi-lightbulb-off" );
                                                $bgValidado = $value['EstadoDetalleDevolucion'] == "REGIS" ? "bg-warning" : ($value['EstadoDetalleDevolucion'] == "VALID" ? "bg-success" : "bg-dark" );
                                                $mensajeValidado = $value['EstadoDetalleDevolucion'] == "REGIS" ? "Pendiente a Validar" : ($value['EstadoDetalleDevolucion'] == "VALID" ? "Validado" : "No Requiere Validación" );
                                                
                                                $html .= '<!-- Validación de recepción de activo -->
                                                <div class="'.$bgValidado.' check-badge" data-tooltip="tooltip" aria-label="'.$mensajeValidado.'">
                                                    <span class="'.$iconoValidado.' text-white" data-tooltip="tooltip" aria-label="'.$mensajeValidado.'"></span>
                                                </div>
                                                <a href="'.$this->items['baseUrl'].'/detalle-acta-devolucion/'.$value['IDDevolucion'].'/'.$value['TokenDevolucion'].'" target="_blank" class="col-12 d-flex justify-content-center align-items-center" style="cursor: pointer;">
                                                    <span class="mdi mdi-file-document-outline color-sistema" style="font-size: 90px;"></span>
                                                </a>
                                                <label class="col-12 m-0 my-2 fw-bold text-center color-sistema">'.date("d-m-Y", strtotime($value['FechaDevolucion'])).'</label>
                                                <label class="col-12 m-0 my-2 text-center color-sistema">'.(ucwords(mb_strtolower($value['NombreRemitenteDevolucion']))).'</label>';
                                            }
                                            
                                            $html .= '</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
				    </div>
            	</div>';
            }
            
            $html .= '</div>';
		    
		}
		
		return $html;
    }
    
    public function informacionReposicionElemento($detalle, $idUsuario, $situacion, $motivoDevolucion = "")
    {
        $dataReposicion = array();
        
        /* OBTENER MONEDAS ACTUALES */
        
        $listadoMonedas = $this->divisas->findAll();
        // Crear un array asociativo para acceder fácilmente a cada MONEDA por su nomenclatura
        $simbolosMonedas = [];
        $cambioMonedas = [];
        foreach ($listadoMonedas as $moneda) {
            $simbolosMonedas[$moneda['CodigoInternacional']] = $moneda['Simbolo'] ;
            $cambioMonedas[$moneda['CodigoInternacional']] = $moneda['ValorCambio'] ;
        }
        
        
        if($detalle['TipoElemento']=="LINEA")
        {
            $dataReposicion = array(
                "IDELEMENTO"    => $detalle['IDElemento'],
                "ELEMENTO"      => $detalle['TipoElemento'],
                "IDITEM"        => $detalle['IDDetalleAsignacion'],
                "ITEM"          => $detalle['TipoEquipo']." | ".$detalle['Marca'].' '.$detalle['Modelo'].' '.$detalle['Serie'],
                "TOTAL"         => 1,
                "MONEDA"        => "PEN",
                "SIMBOLO"       => "S/",
                "VALORCAMBIO"   => "1",
                "TOTALCAMBIO"   => "1",
                "VERISURE"      => "0",
                "TRABAJADOR"    => "1",
                "ROBO"          => "1",
                "TOTALCUOTAS"   => "1",
                "BOLSA"         => "IT"
            );
        }
        else if($detalle['TipoElemento']=="MOVIL")
        {
            $informacionMovil   = $this->moviles->obtenerMovil($detalle['IDElemento']);
            $contrato           = $this->contratos->obtenerContratosXEquipo($detalle['IDElemento']);
            
            if($informacionMovil['EquipoStock'] == 'Y' || empty($contrato))
            {
                $fechaReferencia                = $detalle['FechaAsignado'] != '' && $detalle['FechaAsignado'] != null && $detalle['FechaAsignado'] != "0000-00-00" ? $detalle['FechaAsignado'] : $detalle['FechaCrea'];
                // $fechaReferencia = "2024-02-16";
                $contrato['Permanencia']        = 'Y';
                $contrato['PrecioCompra']       = $informacionMovil['PrecioCompra'];
                $contrato['MontoCuota']         = number_format(round($informacionMovil['PrecioCompra']/18, 8), 8, '.', '');
                $contrato['DiaFacturacion']     = date("j", strtotime($fechaReferencia."- 1 days"));
                $contrato['PeriodoPermanencia'] = '18';
                $contrato['InicioContrato']     = date("Y-m-d", strtotime($fechaReferencia));
            }
            
            if($informacionMovil['Descontinuado'] == 'Y')
            {
                $montoTotal = $informacionMovil['PrecioLista'];
            }
            else
            {
                $montoTotal = $this->veriactivos->calculoPenalidadMovil($contrato);
            }
            
            $registrosRobo  = $this->asignacionesDetalle->obtenerDispositivosRobadosUsuario($idUsuario,"MOVIL", "", "");
            $cantidadRobo   = empty($registrosRobo) ? 0 : count($registrosRobo)-1;
            $porcentajes    = $this->veriactivos->calculoPorcentajeResponsabilidadMovil($cantidadRobo, $montoTotal, $situacion);

            $dataReposicion = array(
                "IDELEMENTO"    => $detalle['IDElemento'],
                "ELEMENTO"      => $detalle['TipoElemento'],
                "IDITEM"        => $detalle['IDDetalleAsignacion'],
                "ITEM"          => $detalle['TipoEquipo']." | ".$detalle['Marca'].' '.$detalle['Modelo'].' '.$detalle['Serie'],
                "TOTAL"         => $montoTotal,
                "MONEDA"        => "PEN",
                "SIMBOLO"       => "S/",
                "VALORCAMBIO"   => "1",
                "TOTALCAMBIO"   => $montoTotal,
                "VERISURE"      => $porcentajes['VERISURE'],
                "TRABAJADOR"    => $porcentajes['TRABAJADOR'],
                "ROBO"          => $cantidadRobo,
                "TOTALCUOTAS"   => ($motivoDevolucion == 'CESE' ? 1 : $this->veriactivos->rangoDescuentosMoviles($porcentajes['TRABAJADOR'])),
                "BOLSA"         => "IT"
            );
            
        }
        else if($detalle['TipoElemento']=="HARDWARE")
        {
            $informacionUsuario     = $this->usuarios->obtenerUsuario($idUsuario);
            $informacionHardware    = $this->hardware->obtenerHardware($detalle['IDElemento']);
            
            $montoReposicion    = $informacionHardware['PrecioCompra'];
            $valorCambio        = $cambioMonedas[$informacionHardware['MonedaCompra']];
            
            $montoTotal     = $this->veriactivos->calculoReposicionHardware($informacionHardware, $listadoMonedas);
            
            $registrosRobo  = $this->asignacionesDetalle->obtenerDispositivosRobadosUsuario($idUsuario,"HARDWARE", "", $detalle['TipoCategoria']);
            $cantidadRobo   = empty($registrosRobo) ? 0 : count($registrosRobo)-1;
            $porcentajes    = $this->veriactivos->calculoPorcentajeResponsabilidadEquiposInformaticos($cantidadRobo, $montoTotal, $situacion, $informacionUsuario['Cargo']);
            
            $dataReposicion = array(
                "IDELEMENTO"    => $detalle['IDElemento'],
                "ELEMENTO"      => $detalle['TipoElemento'],
                "IDITEM"        => $detalle['IDDetalleAsignacion'],
                "ITEM"          => $detalle['TipoEquipo']." | ".$detalle['Marca'].' '.$detalle['Modelo'].' '.$detalle['Serie'],
                "TOTAL"         => $montoReposicion,
                "MONEDA"        => $informacionHardware['MonedaCompra'],
                "SIMBOLO"       => $simbolosMonedas[$informacionHardware['MonedaCompra']],
                "VALORCAMBIO"   => $valorCambio,
                "TOTALCAMBIO"   => $montoTotal,
                "VERISURE"      => $porcentajes['VERISURE'],
                "TRABAJADOR"    => $porcentajes['TRABAJADOR'],
                "ROBO"          => $cantidadRobo,
                "TOTALCUOTAS"   => ($motivoDevolucion == 'CESE' ? 1 : $this->veriactivos->cuotasDescuentoEquiposInformaticos($porcentajes['TRABAJADOR'])),
                "BOLSA"         => "IT"
            );
        }
        else if($detalle['TipoElemento']=="TARJETA")
        {
            $informacionTarjeta = $this->tarjetasAcceso->where("IDTarjetaAcceso", $detalle['IDElemento'])->first();

            $dataReposicion = array(
                "IDELEMENTO"    => $detalle['IDElemento'],
                "ELEMENTO"      => $detalle['TipoElemento'],
                "IDITEM"        => $detalle['IDDetalleAsignacion'],
                "ITEM"          => $detalle['TipoEquipo']." | ".$detalle['Marca'].' '.$detalle['Modelo'].' '.$detalle['Serie'],
                "TOTAL"         => $informacionTarjeta['PrecioCompra'],
                "MONEDA"        => "PEN",
                "SIMBOLO"       => "S/",
                "VALORCAMBIO"   => "1",
                "TOTALCAMBIO"   => $informacionTarjeta['PrecioCompra'],
                "VERISURE"      => "0",
                "TRABAJADOR"    => $informacionTarjeta['PrecioCompra'],
                "ROBO"          => "1",
                "TOTALCUOTAS"   => "1",
                "BOLSA"         => "IT"
            );
        }
        else if($detalle['TipoElemento']=='ACCESORIOIT')
        {
            $totalDescuento = $detalle['MontoReposicion'];
            $totalVerisure = 0;
            $totalTrabajador = $detalle['MontoReposicion'];
            
            $dataReposicion = array(
                "IDELEMENTO"    => $detalle['IDElemento'],
                "ELEMENTO"      => $detalle['TipoElemento'],
                "IDITEM"        => $detalle['IDDetalleAsignacion'],
                "ITEM"          => $detalle['TipoEquipo']." | ".$detalle['Marca'].' '.$detalle['Modelo'].' '.$detalle['Serie'],
                "TOTAL"         => $detalle['MontoReposicion'],
                "MONEDA"        => "PEN",
                "SIMBOLO"       => "S/",
                "VALORCAMBIO"   => "1",
                "TOTALCAMBIO"   => $detalle['MontoReposicion'],
                "VERISURE"      => "0",
                "TRABAJADOR"    => $detalle['MontoReposicion'],
                "ROBO"          => "1",
                "TOTALCUOTAS"   => "1",
                "BOLSA"         => "IT"
            );
        }
        else if($detalle['TipoElemento']=="KITDEMO")
        {
            $informacionKit = $this->kitsDemo->obtenerItemKitDemo($detalle['IDElemento']);
            $montoReposicion = $informacionKit['PrecioReposicion'];
            $valorCambio = empty($informacionKit['MonedaReposicion']) ? 1 : $cambioMonedas[$informacionKit['MonedaReposicion']];
            
            //SI LA MONEDA ES OTRA QUE NO SEA PEN, DEBE REALIZARSE LA CONVERSIÓN Y AL RESULTADO SETEARLO COMO $montoTotal
            
            if($informacionKit['MonedaReposicion'] != 'PEN' && $informacionKit['MonedaReposicion'] != '' && $informacionKit['MonedaReposicion'] != null)
            {
                $montoTotal = number_format(round($montoReposicion * $valorCambio, 2), 2, '.', '');
            }
            else
            {
                $montoTotal = $montoReposicion;
            }
            
            $registrosRobo  = $this->asignacionesDetalle->obtenerDispositivosRobadosUsuario($idUsuario,"KITDEMO",$detalle['IDElemento'], '');
            $cantidadRobo   = empty($registrosRobo) ? 0 : count($registrosRobo)-1;
            $porcentajes    = $this->veriactivos->calculoPorcentajeResponsabilidadKitDemo($cantidadRobo, $montoTotal, $situacion);
            
            $dataReposicion = array(
                "IDELEMENTO"    => $detalle['IDElemento'],
                "ELEMENTO"      => $detalle['TipoElemento'],
                "IDITEM"        => $detalle['IDDetalleAsignacion'],
                "ITEM"          => $detalle['TipoEquipo']." | ".$detalle['Marca'].' '.$detalle['Modelo'].' '.$detalle['Serie'],
                "TOTAL"         => $montoReposicion,
                "MONEDA"        => $informacionKit['MonedaReposicion'] != '' && $informacionKit['MonedaReposicion'] != null ? $informacionKit['MonedaReposicion'] : "PEN",
                "SIMBOLO"       => $informacionKit['MonedaReposicion'] != '' && $informacionKit['MonedaReposicion'] != null ? $simbolosMonedas[$informacionKit['MonedaReposicion']] : "S/",
                "VALORCAMBIO"   => $valorCambio,
                "TOTALCAMBIO"   => $montoTotal,
                "VERISURE"      => $porcentajes['VERISURE'],
                "TRABAJADOR"    => $porcentajes['TRABAJADOR'],
                "ROBO"          => $cantidadRobo,
                "TOTALCUOTAS"   => ($motivo == 'CESE' ? 1 : $this->veriactivos->rangoDescuentosKitDemo($porcentajes['TRABAJADOR'])),
                "BOLSA"         => "URES"
            );
        }
        else if($detalle['TipoElemento']=="ELEMENTOTRABAJO")
        {
            $informacionElemento = $this->elementosTrabajo->where("IDElementoTrabajo", $detalle['IDElemento'])->first();
            $montoReposicion = $informacionElemento['PrecioReposicion'];
            $valorCambio = $cambioMonedas[$informacionElemento['MonedaReposicion']];
            
            //SI LA MONEDA ES OTRA QUE NO SEA PEN, DEBE REALIZARSE LA CONVERSIÓN Y AL RESULTADO SETEARLO COMO $montoTotal
            
            if($informacionElemento['MonedaReposicion'] != 'PEN')
            {
                $montoTotal = number_format(round($montoReposicion * $valorCambio, 2), 2, '.', '');
            }
            else
            {
                $montoTotal = $montoReposicion;
            }
            
            $dataReposicion = array(
                "IDELEMENTO"    => $detalle['IDElemento'],
                "ELEMENTO"      => $detalle['TipoElemento'],
                "IDITEM"        => $detalle['IDDetalleAsignacion'],
                "ITEM"          => $detalle['TipoEquipo']." | ".$detalle['Marca'].' '.$detalle['Modelo'].' '.$detalle['Serie'],
                "TOTAL"         => $montoReposicion,
                "MONEDA"        => $informacionElemento['MonedaReposicion'],
                "SIMBOLO"       => $simbolosMonedas[$informacionElemento['MonedaReposicion']],
                "VALORCAMBIO"   => $valorCambio,
                "TOTALCAMBIO"   => $montoTotal,
                "VERISURE"      => 0,
                "TRABAJADOR"    => $montoTotal,
                "ROBO"          => 0,
                "TOTALCUOTAS"   => ($motivo == 'CESE' ? 1 : $this->veriactivos->rangoDescuentosKitDemo($porcentajes['TRABAJADOR'])),
                "BOLSA"         => "URES"
            );
        }
        
        return $dataReposicion;
    }
}
