<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable">
	<head>
		<meta charset="utf-8">
		<title><?= $titulo ?></title>
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta content="Sistema Proveedor | Verisure" name="description">
		<meta content="Verisure Perú" name="author">
		<!-- App favicon -->
		<link rel="shortcut icon" href="<?= $baseUrl ?>/public/images/favicon.ico">
		
		<!--datatable css-->
		<link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css">
		<!--datatable responsive css-->
		<link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css">
		<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
		<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">

		<!-- Layout config Js -->
		<script src="<?= $baseUrl ?>/public/js/layout.js"></script>
		<!-- Bootstrap Css -->
		<link href="<?= $baseUrl ?>/public/css/bootstrap.min.css" rel="stylesheet" type="text/css">
		<link href="<?= $baseUrl ?>/public/libs/bootstrap-switch/css/bootstrap3/bootstrap-switch.min.css" rel="stylesheet" type="text/css">
		<!-- Icons Css -->
		<link href="<?= $baseUrl ?>/public/css/icons.min.css" rel="stylesheet" type="text/css">
		<!-- App Css-->
		<link href="<?= $baseUrl ?>/public/css/app.min.css" rel="stylesheet" type="text/css">
		<!-- custom Css-->
		<link href="<?= $baseUrl ?>/public/css/custom.min.css" rel="stylesheet" type="text/css">
		<!-- Toastr -->
		<link rel="stylesheet" href="<?= $baseUrl ?>/public/js/pages/plugins/toastr/toastr.min.css">
		<!-- SweetAlert -->
		<link rel="stylesheet" href="<?= $baseUrl ?>/public/js/pages/plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css">
	    <!-- Filepond -->
	    <link rel="stylesheet" href="<?= $baseUrl ?>/public/libs/filepond/filepond.min.css" type="text/css">
	    <link rel="stylesheet" href="<?= $baseUrl ?>/public/libs/filepond-plugin-image-preview/filepond-plugin-image-preview.min.css">
		<!-- Styles propios -->
		<link rel="stylesheet" href="<?= $baseUrl ?>/public/css/styles.css?<?= $aleatorio ?>">
	</head>
	<body>
		<!-- auth-page wrapper -->
		<div class="auth-page-wrapper auth-bg-cover py-5 d-flex justify-content-center align-items-center min-vh-100">
			<div class="bg-overlay"></div>
			<!-- auth-page content -->
			<div class="auth-page-content overflow-hidden pt-lg-5">
				<div class="container">
					<div class="row">
                        <div class="col-lg-12">
                            <div class="card overflow-hidden m-0">
                                <div class="row justify-content-center g-0">
                                    <div class="col-lg-6">
                                        <div class="p-lg-5 p-4 h-100 auth-one-bg" style="">
                                            <div class="bg-overlay"></div>
                                            <div class="position-relative h-100 d-flex flex-column">
                                                <div class="mb-4">
                                                    <a href="index.html" class="d-block">
                                                        <img src="<?= base_url() ?>/public/images/logob.png" alt="" height="38">
                                                    </a>
                                                </div>
                                                <div class="mt-auto">
                                                    <!--<div class="mb-3">-->
                                                    <!--    <i class="ri-double-quotes-l display-4 text-success"></i>-->
                                                    <!--</div>-->
    
                                                    <div id="qoutescarouselIndicators" class="carousel slide" data-bs-ride="carousel">
                                                        <div class="carousel-indicators">
                                                            <button type="button" data-bs-target="#qoutescarouselIndicators" data-bs-slide-to="0" class="active" aria-label="Slide 1" aria-current="true"></button>
                                                            <button type="button" data-bs-target="#qoutescarouselIndicators" data-bs-slide-to="1" aria-label="Slide 2" class=""></button>
                                                            <button type="button" data-bs-target="#qoutescarouselIndicators" data-bs-slide-to="2" aria-label="Slide 3" class=""></button>
                                                        </div>
                                                        <div class="carousel-inner text-center text-white-50 pb-5">
                                                            <div class="carousel-item active">
                                                                <p class="fs-15 fst-italic">"Somos personas que protegen personas"</p>
                                                            </div>
                                                            <div class="carousel-item">
                                                                <p class="fs-15 fst-italic">"Compromiso con la seguridad, prevención y protección"</p>
                                                            </div>
                                                            <div class="carousel-item">
                                                                <p class="fs-15 fst-italic">"En Perú estamos orgullosos de brindar la mejor protección a familias y negocios"</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- end carousel -->
    
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-lg-6">
                                        <div class="p-lg-5 p-4">
                                            <div>
                                                <h1 class="text-center color-red-verisure my-3">Bienvenido al portal de proveedores de Verisure Perú</h1>
                                                <!--<h1 class="text-center color-red-verisure my-3">¡Bienvenido Proveedor!</h1>-->
                                                <h3 class="text-center my-3">Iniciar Sesión</h3>
                                            </div>
    
                                            <div class="m-0">
                                                <form class="formulario" action="<?= $baseUrl ?>/entrar" method="POST">
													<span class="respuesta"></span>
                                                    <div class="my-3">
                                                        <label for="txtCorreoElectronico" class="form-label">Correo electrónico</label>
                                                        <input type="text" class="form-control" name="txtCorreoElectronico" id="txtCorreoElectronico" placeholder="Ingrese Correo Electrónico">
                                                    </div>
    
                                                    <div class="my-3">
                                                        <label class="form-label" for="password-input">Contraseña</label>
                                                        <div class="position-relative auth-pass-inputgroup mb-3">
                                                            <input type="password" class="form-control pe-5 password-input" placeholder="Ingrese Contraseña" name="txtPassword" id="txtPassword">
                                                            <button class="btn position-absolute end-0 top-0 text-decoration-none text-muted password-addon" type="button" id="password-addon" style="-webkit-box-shadow: none; box-shadow: none;">
                                                                <i class="ri-eye-fill align-middle"></i>
                                                            </button>
                                                        </div>
                                                    </div>
                                                    <div class="my-4 d-flex justify-content-center">
                                                        <button class="btn bg-red-verisure-75 color-white w-100" type="submit">Iniciar Sesión</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
    
                    </div>
					<!-- end row -->
				</div>
				<!-- end container -->
			</div>
			<!-- end auth page content -->
			<!-- footer -->
			<footer class="footer">
				<div class="container">
					<div class="row">
						<div class="col-lg-12">
							<div class="text-center">
								<p class="mb-0">
									&copy;
									<script>document.write(new Date().getFullYear())</script> Verisure Peru. Desarrollado por Verisure Peru
								</p>
							</div>
						</div>
					</div>
				</div>
			</footer>
			<!-- end Footer -->
		</div>
		<!-- end auth-page-wrapper -->

     	<script> window.baseUrl = "<?= base_url(); ?>"</script>
		<!-- jQuery -->
		<script src="<?= $baseUrl ?>/public/js/pages/plugins/jquery/jquery.min.js"></script>
		<!-- JAVASCRIPT -->
		<script src="<?= $baseUrl ?>/public/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
		
		<script src="<?= $baseUrl ?>/public/libs/node-waves/waves.min.js"></script>
		<script src="<?= $baseUrl ?>/public/libs/feather-icons/feather.min.js"></script>
		<script src="<?= $baseUrl ?>/public/js/pages/plugins/lord-icon-2.1.0.js"></script>
		<script src="<?= $baseUrl ?>/public/js/plugins.js"></script>
		<script src="<?= $baseUrl ?>/public/libs/bootstrap-switch/js/bootstrap-switch.min.js"></script>
		<!-- Filepong -->
		<script src="<?= $baseUrl ?>/public/libs/filepond/filepond.min.js?<?= $aleatorio ?>"></script>
		<script src="<?= $baseUrl ?>/public/libs/filepond/filepond.jquery.js?<?= $aleatorio ?>"></script>
		<script src="<?= $baseUrl ?>/public/libs/filepond-plugin-file-validate-type/filepond-plugin-file-validate-type.min.js?<?= $aleatorio ?>"></script>
		<!--datatable js-->
		<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
		<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
		<script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
		<script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
		<script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
		<script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
		<!--select2 cdn-->
		<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
		<script src="<?= $baseUrl ?>/public/js/pages/select2.init.js"></script>
		<!-- password-addon init -->
		<script src="<?= $baseUrl ?>/public/js/pages/password-addon.init.js"></script>
		<!-- Toastr -->
		<script src="<?= $baseUrl ?>/public/js/pages/plugins/toastr/toastr.min.js"></script>
		<!-- SweetAlert -->
		<script src="<?= $baseUrl ?>/public/js/pages/plugins/sweetalert2/sweetalert2.min.js"></script>
		<!-- Estructura -->
		<script src="<?= $baseUrl ?>/public/js/estructura.js"></script>
		<!-- Proceso -->
		<script src="<?= $baseUrl ?>/public/js/proceso.js"></script>
	</body>
</html>