<?php namespace App\Models;

use CodeIgniter\Model;

class UsuarioModel extends Model {
/*    protected $table = 'usuario';
    protected $primaryKey = 'id_usuario';
    protected $allowedFields = ['id_usuario','usuario','contrasena','perfil_id','nombres','apellidos','tipo_documento','numero_documento','correo_electronico','token','fecha_caducidad_token','fecha_solicitud_recuperacion','fecha_cambio_contrasena','fecha_registro','fecha_actualizacion','eliminacion_logica'];
*/
    protected $DBGroup          = 'baseCompras';
    protected $table            = 'externos_acceso';
    protected $primaryKey       = 'IDExterno';
    protected $allowedFields    = ['Nombres', 'Apellidos', 'NroDocumento', 'NroContacto', 'CorreoElectronico', 'Password', 'Cargo', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    public function validarIngresoUsuario($usuario)
    {
        $this->select('externos_acceso.IDExterno,
            externos_acceso.Nombres,
            externos_acceso.Apellidos,
            externos_acceso.NroDocumento,
            externos_acceso.NroContacto,
            externos_acceso.CorreoElectronico,
            externos_acceso.Password,
            externos_acceso.Cargo,
            externos_acceso.Estado');
        $this->where('externos_acceso.CorreoElectronico', $usuario);
        $datos = $this->first();
        // return $this->getLastQuery();
        return $datos;
    }

    public function validarSistemaUsuario($IDExterno, $raiz)
    {
        $this->select('externos_acceso.IDExterno,
            usuario_sistemas.IDSistema,
            sistemas.Sistema,
            sistemas.Estado');
        $this->join('usuario_sistemas', 'externos_acceso.IDExterno = usuario_sistemas.IDExterno');
        $this->join('sistemas', 'usuario_sistemas.IDSistema = sistemas.IDSistema');
        $this->where('usuario_sistemas.IDExterno', $IDExterno);
        $this->where('sistemas.Raiz', $raiz);
        $datos = $this->first();
        return $datos;
    }

    public function listaGeneralUsuario($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        // $this->globales = new Globales();
        
        $fields = array(
            0 => 'externos_acceso.IDExterno', 
            2 => 'externos_acceso.NroDocumento', 
            3 => 'externos_acceso.NroContacto', 
            4 => 'externos_acceso.Cargo', 
            6 => 'externos_acceso.CorreoElectronico', 
            7 => 'externos_acceso.Estado');
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('externos_acceso.IDExterno AS id_usuario,
            externos_acceso.Nombres,
            externos_acceso.Apellidos,
            CONCAT(externos_acceso.Nombres, " ", externos_acceso.Apellidos) AS nombre_usuario,
            externos_acceso.NroDocumento AS nro_documento,
            externos_acceso.NroContacto AS nro_contacto,
            externos_acceso.Cargo AS cargo,
            externos_acceso.CorreoElectronico AS correo_electronico,
            "" AS "perfil_usuario",
            "" AS "acciones_usuario",
            externos_acceso.Estado');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }

            $this->orLike('CONCAT(externos_acceso.Nombres, " ", externos_acceso.Apellidos)', $get['search']['value']);
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo (string) $this->getLastQuery();
        // exit;
        
        return $result;
    }

    public function buscarUsuario($IDExterno)
    {
        $this->select('externos_acceso.IDExterno,
            externos_acceso.Matricula,
            externos_acceso.Usuario,
            externos_acceso.Nombres,
            externos_acceso.Apellidos,
            externos_acceso.TipoDocumento,
            externos_acceso.NumeroDoc,
            externos_acceso.Correo,
            externos_acceso.Estado,
            externos_acceso.IDDelegacion,
            externos_acceso.IDSubarea,
            estructura_area.IDArea,
            estructura_area.Area,
            estructura_direccion.IDDireccion,
            estructura_direccion.Direccion,
            estructura_delegacion.CC,
            cargos.Cargo');
        $this->join('estructura_delegacion', 'externos_acceso.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'externos_acceso.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'externos_acceso.IDCargo = cargos.IDCargo', 'left');
        $this->where('externos_acceso.IDExterno', $IDExterno);
        $datos = $this->first();
        return $datos;
    }

    public function buscarUsuarioXusuario($usuario)
    {
        $this->select('externos_acceso.IDExterno,
            externos_acceso.Matricula,
            externos_acceso.Usuario,
            externos_acceso.Nombres,
            externos_acceso.Apellidos,
            externos_acceso.TipoDocumento,
            externos_acceso.NumeroDoc,
            externos_acceso.Correo,
            externos_acceso.Estado,
            externos_acceso.IDSubarea,
            externos_acceso.IDDelegacion,
            estructura_area.IDArea,
            estructura_area.Area,
            estructura_direccion.IDDireccion,
            estructura_direccion.Direccion,
            estructura_delegacion.CC,
            cargos.Cargo');
        $this->join('estructura_delegacion', 'externos_acceso.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'externos_acceso.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'externos_acceso.IDCargo = cargos.IDCargo', 'left');
        $this->where('externos_acceso.Usuario', $usuario);
        $datos = $this->first();
        return $datos;
    }

    public function listadoUsuariosSelect($variable, $cc = '', $estado = '')
    {
        $this->select('
        externos_acceso.IDExterno,
        externos_acceso.Matricula,
        externos_acceso.Nombres,
        externos_acceso.Apellidos,
        externos_acceso.NumeroDoc,
        estructura_delegacion.CC');
        $this->join('estructura_delegacion', 'externos_acceso.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'externos_acceso.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'externos_acceso.IDCargo = cargos.IDCargo', 'left');
        $this->where("(externos_acceso.Matricula LIKE '%".$variable."%' OR 
            externos_acceso.Nombres LIKE '%".$variable."%' OR
            externos_acceso.Apellidos LIKE '%".$variable."%' OR 
            externos_acceso.Usuario LIKE '%".$variable."%' OR 
            CONCAT(externos_acceso.Nombres, ' ',externos_acceso.Apellidos) LIKE '%".$variable."%' OR 
            externos_acceso.NumeroDoc LIKE '%".$variable."%')");

        if($cc != '')
        {
            $this->where('estructura_delegacion.CC', $cc);
        }
        
        if($estado != '')
        {
            $this->where('externos_acceso.Estado', $estado);
        }
        
        $datos = $this->findAll();
        return $datos;
    }

    public function listaGeneralUsuarios($array) 
    {
        $this->select('
        externos_acceso.IDExterno,
        externos_acceso.Matricula,
        externos_acceso.Nombres,
        externos_acceso.Apellidos,
        externos_acceso.NumeroDoc,
        estructura_delegacion.CC,
        externos_acceso.Estado');
        $this->join('estructura_delegacion', 'externos_acceso.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'externos_acceso.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'externos_acceso.IDCargo = cargos.IDCargo', 'left');

        if(isset($array['estado']) && $array['estado'] != '')
        {
            $this->where("externos_acceso.Estado", $array['estado']);
        }
        
        $datos = $this->findAll();
        return $datos;
    }
    
    public function obtenerSubareaXNombres($subarea, $area, $direccion)
    {
        $this->select('estructura_subarea.IDSubarea,
            estructura_subarea.Subarea,
            estructura_subarea.IDArea,
            estructura_area.Area,
            estructura_area.IDDireccion,
            estructura_direccion.Direccion');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->where('estructura_subarea.Subarea', $subarea);
        $this->where('estructura_area.Area', $area);
        $this->where('estructura_direccion.Direccion', $direccion);

        $datos = $this->first();
        return $datos;
    }
    
}
