<?php
namespace App\Models;
use CodeIgniter\Model;

class RegionDistritoModel extends Model
{
    protected $DBGroup      = 'baseT';
    protected $table        = 'region_distrito';
    protected $primaryKey   = 'IDDistrito';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Distrito', 'IDProvincia', 'CodigoINEI', 'CodUbigeoReniec', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function obtenerRegionxIDDistrito($idDistrito)
    {
        $this->select('region_distrito.IDDistrito,
            region_distrito.Distrito,
            region_distrito.IDProvincia,
            region_provincia.Provincia,
            region_provincia.IDDepartamento,
            region_departamento.Departamento,
            region_departamento.IDPais,
            region_pais.Pais,
            region_pais.CodigoInternacional');
        
        $this->join('region_provincia', 'region_distrito.IDProvincia = region_provincia.IDProvincia', 'left');
        $this->join('region_departamento', 'region_provincia.IDDepartamento = region_departamento.IDDepartamento', 'left');
        $this->join('region_pais', 'region_departamento.IDPais = region_pais.IDPais', 'left');
        
        $this->where('region_distrito.IDDistrito', $idDistrito);
        
        $datos = $this->first();
        return $datos;
    }
    
}