<?php
namespace App\Models;
use CodeIgniter\Model;

class OrdenCompraModel extends Model
{
    protected $DBGroup    = 'baseCompras';
    protected $table      = 'ordencompra';
    protected $primaryKey = 'IDOrdenCompra';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Concepto', 'IDProveedor', 'FormaPago', 'Observacion', 'Subtotal', 'IGV', 'Total', 'FechaPedido', 'CondicionesIGV', 'ModalidadPago', 'Banco', 'CuentaBancaria', 'CuentaInterbancaria', 'TipoMoneda', 'MontoCambio', 'Budget', 'UsuarioSolicitante', 'IDDelegacion', 'IDSubarea', 'CC', 'LN', 'UsuarioComprador', 'CompraCentralizada', 'EnvioFactura', 'IDSubcategoria', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function obtenerOrdenCompra($idOrdenCompra)
    {
        $this->select('ordencompra.IDOrdenCompra,
            ordencompra.Concepto,
            ordencompra.IDProveedor,
            proveedor.Nombre AS "Proveedor",
            proveedor.RUC,
            proveedor.Contacto,
            proveedor.CuentaDetraccion,
            proveedor.IDDistrito,
            proveedor.Direccion,
            proveedor.Email,
            proveedor.Telefono01,
            proveedor.Telefono02,
            ordencompra.Subtotal,
            ordencompra.IGV,
            ordencompra.Total,
            ordencompra.UsuarioComprador,
            ordencompra.Observacion,
            ordencompra.FechaPedido,
            ordencompra.Budget,
            ordencompra.CondicionesIGV,
            ordencompra.ModalidadPago,
            ordencompra.Banco,
            ordencompra.CuentaBancaria,
            ordencompra.CuentaInterbancaria,
            ordencompra.CompraCentralizada,
            ordencompra.TipoMoneda,
            ordencompra.MontoCambio,
            ordencompra.FormaPago,
            ordencompra.EnvioFactura,
            ordencompra.UsuarioSolicitante,
            ordencompra.IDDelegacion,
            ordencompra.IDSubarea,
            ordencompra.IDSubcategoria,
            cuentacontable_subcategorias.IDCategoriaCC,
            ordencompra.CC,
            ordencompra.LN,
            ordencompra.Estado,
            ordencompra.UsuarioCrea,
            ordencompra_responsables.UsuarioFirma1,
            ordencompra_responsables.UsuarioFirma2,
            ordencompra_responsables.UsuarioFirma3,
            comprobantes_pago.NroFactura,
            comprobantes_pago.FechaEmisionFactura,
            ordencompra.FechaCrea,
            formaspago.FormaPago as "descripcionFormaPago",
            formaspago.DiasPago,
            modalidadpago.ModalidadPago as "descripcionModalidadPago",
            bancos.Nombre as "descripcionBanco"');
        
        $this->join('comprobantes_pago', 'ordencompra.IDOrdenCompra = comprobantes_pago.IDOrigen AND comprobantes_pago.Origen = "OC" AND comprobantes_pago.TipoComprobante = "1"', 'left');
        $this->join('proveedor', 'ordencompra.IDProveedor = proveedor.IDProveedor', 'left');
        $this->join('cuentacontable_subcategorias', 'ordencompra.IDSubcategoria = cuentacontable_subcategorias.IDSubcategoriaCC', 'left');
        $this->join('cuentacontable_categorias', 'cuentacontable_subcategorias.IDCategoriaCC = cuentacontable_categorias.IDCategoriaCC', 'left');
        $this->join('ordencompra_responsables', 'ordencompra.IDOrdenCompra = ordencompra_responsables.IDOrdenCompra', 'left');
        $this->join('formaspago', 'ordencompra.FormaPago = formaspago.Codigo', 'left');
        $this->join('modalidadpago', 'ordencompra.ModalidadPago = modalidadpago.Codigo', 'left');
        $this->join('bancos', 'ordencompra.Banco = bancos.CodigoInterno', 'left');
        $this->where('ordencompra.IDOrdenCompra', $idOrdenCompra);
        
        $datos = $this->first();
        return $datos;
    }
    
    public function listaGeneralOrdenCompra($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        // $this->globales = new Globales();
        
        $fields = array(
            0 => 'ordencompra.IDOrdenCompra', 
            1 => 'ordencompra.FechaCrea', 
            2 => 'ordencompra.Concepto', 
            3 => 'proveedor.Nombre', 
            4 => 'ordencompra.Total');
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('ordencompra.IDOrdenCompra AS oc,
            ordencompra.FechaCrea AS emision,
            ordencompra.UsuarioCrea,
            ordencompra.IDProveedor,
            ordencompra.Concepto AS concepto,
            proveedor.Nombre AS proveedor,
            ordencompra.TipoMoneda,
            ordencompra.MontoCambio,
            ordencompra.Total AS total,
            ordencompra.Estado,
            COUNT(comprobantes_pago.IDComprobante) AS TotalComprobantes');
            
        $this->join('proveedor', 'ordencompra.IDProveedor = proveedor.IDProveedor', 'left');
        $this->join('comprobantes_pago', 'ordencompra.IDOrdenCompra = comprobantes_pago.IDOrigen AND comprobantes_pago.Origen = "OC"', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }

        if(!empty($adicionales))
        {
            if(!empty($adicionales['Proveedores']) && $adicionales['Proveedores'] != null)
            {
                $this->groupStart(); // Inicia un grupo de condiciones
                $this->whereIn("ordencompra.IDProveedor", $adicionales['Proveedores']);
                $this->groupEnd(); // Finaliza el grupo de condiciones
            }
        }
        
        $this->where("ordencompra.Estado", "Aprobado");
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * AGRUPAR DATOS
        * ----------------------------
        */
        
        $this->groupBy('ordencompra.IDOrdenCompra');
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo $this->getLastQuery();
        // exit;
        
        return $result;
    }

    public function obtenerCantidadOrdenCompra($array)
    {
        $this->select('ordencompra.IDOrdenCompra');
        $this->join('ordencompra_responsables', 'ordencompra.IDOrdenCompra = ordencompra_responsables.IDOrdenCompra', 'left');
        
        if(!empty($array))
        {
            if(isset($array['idperfil']) && !in_array($array['idperfil'], array(1,2)))
            {
                //OBTENER EL PERFIL QUE EVALUE LOS RESULTADOS POR RESPONSABLE
                if($array['idperfil'] == 4 && isset($array['responsable']) && $array['responsable'] != '')
                {
                    $this->orWhere("ordencompra_responsables.UsuarioFirma1", $array['responsable']);
                    $this->orWhere("ordencompra_responsables.UsuarioFirma2", $array['responsable']);
                    $this->orWhere("ordencompra_responsables.UsuarioFirma3", $array['responsable']);
                }
                else if(isset($array['solicitante']) && $array['solicitante'] != '')
                {
                    $this->where("ordencompra.UsuarioCrea", $array['solicitante']);
                }
            }
            
            if(isset($array['estado']) && $array['estado'] != '')
            {
                $this->where("ordencompra.Estado", $array['estado']);
            }
        }
        
        $datos = $this->findAll();
        return $datos;
        // $this->get();
        // return $this->getLastQuery();
    }
    
    public function datosExportarOrdenCompra($array)
    {
        $this->select('ordencompra.IDOrdenCompra,
            ordencompra.Estado,
            ordencompra.FechaCrea,
            ordencompra.FechaPedido,
            ordencompra.Concepto,
            ordencompra.Observacion,
            ordencompra.UsuarioSolicitante,
            ordencompra.IDProveedor,
            proveedor.Nombre AS "Proveedor",
            proveedor.RUC,
            proveedor.Contacto,
            proveedor.Direccion,
            proveedor.IDDistrito,
            proveedor.Telefono01,
            proveedor.Telefono02,
            proveedor.Email,
            ordencompra.FormaPago,
            ordencompra.ModalidadPago,
            ordencompra.Banco,
            ordencompra.CuentaBancaria,
            ordencompra.TipoMoneda,
            ordencompra.CuentaInterbancaria,
            ordencompra.CC,
            ordencompra.LN,
            ordencompra.IDSubarea,
            ordencompra.Subtotal,
            ordencompra.IGV,
            ordencompra.Total,
            ordencompra.MontoCambio,
            ordencompra_detalle.IDDetalleOC,
            ordencompra_detalle.Descripcion,
            ordencompra_detalle.Cantidad,
            ordencompra_detalle.PrecioUnitario,
            ordencompra.IDSubcategoria,
            cuentacontable_subcategorias.Subcategoria,
            cuentacontable_subcategorias.IDCategoriaCC,
            cuentacontable_categorias.Categoria,
            ordencompra.UsuarioComprador,
            ordencompra.MotivoEstado,
            ordencompra_responsables.UsuarioFirma1,
            ordencompra_responsables.UsuarioFirma2,
            ordencompra_responsables.UsuarioFirma3');
            // formaspago.FormaPago as "descripcionFormaPago",
            // modalidadpago.ModalidadPago as "descripcionModalidadPago",
            // bancos.Nombre as "descripcionBanco"');
        
        $this->join('proveedor', 'ordencompra.IDProveedor = proveedor.IDProveedor', 'left');
        $this->join('ordencompra_detalle', 'ordencompra.IDOrdenCompra = ordencompra_detalle.IDOrdenCompra', 'left');
        $this->join('ordencompra_responsables', 'ordencompra.IDOrdenCompra = ordencompra_responsables.IDOrdenCompra', 'left');
        $this->join('cuentacontable_subcategorias', 'ordencompra.IDSubcategoria = cuentacontable_subcategorias.IDSubcategoriaCC', 'left');
        $this->join('cuentacontable_categorias', 'cuentacontable_subcategorias.IDCategoriaCC = cuentacontable_categorias.IDCategoriaCC', 'left');
        
        // $this->join('formaspago', 'ordencompra.FormaPago = formaspago.Codigo', 'left');
        // $this->join('modalidadpago', 'ordencompra.ModalidadPago = modalidadpago.Codigo', 'left');
        // $this->join('bancos', 'ordencompra.Banco = bancos.CodigoInterno', 'left');
        
        if(!empty($array) && $array != '')
        {
            if(isset($array["fechaInicio"]) && $array["fechaInicio"] != '')
            {
                $this->where('ordencompra.FechaPedido >=', $array["fechaInicio"]);
            }
            
            if(isset($array["fechaFin"]) && $array["fechaFin"] != '')
            {
                $this->where('ordencompra.FechaPedido <=', $array["fechaFin"]);
            }
            
            if(isset($array["idordencompra"]) && $array["idordencompra"] != '')
            {
                $this->where('ordencompra.IDOrdenCompra', $array["idordencompra"]);
            }
        }
        
        $this->orderBy("ordencompra.IDOrdenCompra", "DESC");
        
        $this->get();
        return $this->getLastQuery();
        
        // $datos = $this->findAll();
        // return $datos;
    }
    
}