<?php
namespace App\Models;
use CodeIgniter\Model;

class CuentaContableSubcategoriaModel extends Model
{
    protected $table      = 'cuentacontable_subcategorias';
    protected $primaryKey = 'IDSubcategoriaCC';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDCategoriaCC', 'Subcategoria', 'Observacion','UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listadoSubcategorias($array)
    {
        $this->select('
            cuentacontable_subcategorias.IDSubcategoriaCC,
            cuentacontable_subcategorias.Subcategoria,
            cuentacontable_subcategorias.Observacion,
            cuentacontable_subcategorias.Estado,
            cuentacontable_subcategorias.IDCategoriaCC,
            cuentacontable_categorias.Categoria,
            cuentacontable_categorias.IDCuentaContable,
            cuentacontable.CodigoCuentaContable,
            cuentacontable.CuentaContable');
        $this->join('cuentacontable_categorias', 'cuentacontable_subcategorias.IDCategoriaCC = cuentacontable_categorias.IDCategoriaCC', 'left');
        $this->join('cuentacontable', 'cuentacontable_categorias.IDCuentaContable = cuentacontable.IDCuentaContable', 'left');
        
        if(isset($array['Estado']) && $array['Estado'] != '')
        {
            $this->where('cuentacontable_subcategorias.Estado', $array['Estado']);
        }
        
        if(isset($array['IDCategoriaCC']) && $array['IDCategoriaCC'] != '')
        {
            $this->where('cuentacontable_subcategorias.IDCategoriaCC', $array['IDCategoriaCC']);
        }
        
        $datos = $this->findAll();
        return $datos;
    }
    
    public function listadoSubcategoriasCategoriaCC($idCategoria = '')
    {
        $this->select('
            cuentacontable_subcategorias.IDSubcategoriaCC,
            cuentacontable_subcategorias.Subcategoria,
            cuentacontable_subcategorias.Observacion,
            cuentacontable_subcategorias.Estado,
            cuentacontable_subcategorias.IDCategoriaCC,
            cuentacontable_categorias.Categoria');
        $this->join('cuentacontable_categorias', 'cuentacontable_subcategorias.IDCategoriaCC = cuentacontable_categorias.IDCategoriaCC', 'left');
        
        if($idCategoria != '')
        {
            $this->where('cuentacontable_subcategorias.IDCategoriaCC', $idCategoria);
        }
        
        $datos = $this->findAll();
        return $datos;
    }
    
    public function obtenerSubcategoriaXDefinicion($subcategoria, $categoria)
    {
        $this->select('cuentacontable_subcategorias.IDSubcategoriaCC,
            cuentacontable_subcategorias.Subcategoria,
            cuentacontable_subcategorias.IDCategoriaCC,
            cuentacontable_categorias.Categoria');
        $this->join('cuentacontable_categorias', 'cuentacontable_subcategorias.IDCategoriaCC = cuentacontable_categorias.IDCategoriaCC', 'left');
        
        $this->where('cuentacontable_subcategorias.Subcategoria', $subcategoria);
        $this->where('cuentacontable_categorias.Categoria', $categoria);
        
        $datos = $this->first();
        return $datos;
    }
    
}