<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

class Usuarios extends BaseController
{
	public function __construct(){
		$this->modulo = new \App\Models\ModuloModel();
		$this->usuarioModelo = new \App\Models\UsuarioModel();
        $this->usuarioPerfil = new \App\Models\UsuarioPerfilModel();
        $this->usuarioPermisos = new \App\Models\UsuarioPermisosModel();
        $this->usuarioRutas = new \App\Models\UsuarioRutasModel();
	}

    public function listarUsuarioDataTable()
    {
        $adicionales = array(
            "IDPerfil"  => $this->items['idPerfilSession'],
            "IDUsuario" => $this->items['idUsuarioSession']
        );
        
        /* LISTAR USUARIOS */
        $dataServerside = $this->usuarioModelo->listaGeneralUsuario($this->request->getGet(), $adicionales);
        $recordsTotal = !empty($dataServerside) ? count($dataServerside) : 0;
        $recordsFiltered = $this->usuarioModelo->countAll();
        
        foreach($dataServerside as $key=>$value)
        {
            $perfil = $this->usuarioPerfil->obtenerPerfilUsuario($value['id_usuario']);
            
            $dataServerside[$key]['perfil_usuario'] = !empty($perfil) ? ucwords(mb_strtolower($perfil['Perfil'])) : "";
        }
        
        $datos = [
                // 'draw' => $this->request->getGet('draw'),
            'data'              => $dataServerside,
            'recordsTotal'      => $recordsTotal,
            'recordsFiltered'   => (int) $recordsFiltered
        ];

        echo json_encode($datos, JSON_NUMERIC_CHECK);
        /* LISTAR ORDEN DE COMPRA */
        // $listaUsuarios = $this->usuarioModelo->listaGeneralUsuario($orderBy,$where,$length,$start);
        // echo json_encode($listaUsuarios, JSON_NUMERIC_CHECK);
    }

	public function listar(){
		if($this->session->get('sesionUsuario')['accesoTmpId'] && in_array(1, $this->items['permisos']) && in_array(2, $this->items['permisos'])){

			/* BUSCAR USUARIOS */
			$whereUsuarios = array(
				'usuarios.eliminacion_logica' => 1
			);
			$listaUsuarios = $this->usuarioModelo
				->where($whereUsuarios)
				->orderBy('fecha_registro','DESC')
				->findAll();

            /* LISTAR MANAGERS */
			$whereManagers = array(
				'usuarios.eliminacion_logica' => 1
			);
			$listaManagers = $this->usuarioModelo
                ->join('usuarios as u', 'u.id_usuario = usuarios.matricula_responsable')
				->where($whereManagers)
				->orderBy('usuarios.apellido_paterno','ASC')
				->findAll();
                
            /* LISTAR ÁREAS */
			$whereAreas = array(
				'areas.eliminacion_logica' => 1
			);
			$listaAreas = $this->areasModelo
                ->where($whereAreas)
                ->join('departamentos', 'departamentos.id_departamento = areas.departamento_id')
                ->orderBy('departamentos.nombre_departamento','ASC')
				->findAll();

            /* LISTAR ROLES */
			$whereRoles = array(
				'roles.eliminacion_logica' => 1
			);
			$listaRoles = $this->rolesModelo
				->where($whereRoles)
				->orderBy('fecha_registro','DESC')
				->findAll();            

			$data = array (
				'session'           => 'on',
				'titulo'            => 'Usuarios | Don Bosco',
				'breadcrumb'        => $this->items['modulo'],
				'listaUsuarios'     => $listaUsuarios,
                'listaAreas'        => $listaAreas,
                'listaRoles'        => $listaRoles,
                'listaManagers'     => $listaManagers
			);
			$data = array_merge($data, $this->items);
			return view('usuarios/listar',$data);			
		} else {			
			return view('errors/500');	
		}
	}

    public function obtenerDatosUsuario($idUsuario){

        /* DATOS DEL USUARIO */
        $whereUsuario = array (
            'usuarios.id_usuario' => $idUsuario,
            'usuarios.eliminacion_logica' => 1
        );
        $datosUsuario = $this->usuarioModelo        
				->where($whereUsuario)
				->findAll();

        if(!empty($datosUsuario)){
            foreach ($datosUsuario as $items) {
                $resultado[] = array(
					'id_usuario' => (string) $items['id_usuario'],
         	        'nombres' => (string) $items['nombres'],
         	        'apellido_paterno' => (string) $items['apellido_paterno'],
         	        'apellido_materno' => (string) $items['apellido_materno'],
         	        'matricula' => (string) $items['matricula'],
         	        'correo_electronico' => (string) $items['correo_electronico'],
         	        'cargo' => (string) $items['cargo'],
         	        'area_id' => (string) $items['area_id'],
         	        'manager_id' => (string) $items['matricula_responsable'],
         	        'rol_id' => (string) $items['rol_id'],
                );
            }
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

        echo json_encode($resultado, JSON_NUMERIC_CHECK);	
    }

    public function modificarUsuario($idUsuario)
    {
        
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $perfil = $this->request->getPost('txtPerfilUsuario');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($perfil, 'required|trim', 'Perfil');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * ACTUALIZACIÓN DE DATOS
        * ----------------------------
        */

        $data = array (
            'IdUsuario'         => $idUsuario,
            'IDPerfil'          => $perfil,
            'UsuarioRegistra'   => $this->items['idUsuarioSession'],
            'FechaRegistra'     => $fechaActual
        );
        
        $lastId = $this->usuarioPerfil->save($data);
        
		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function listarPermisosUsuario($idUsuario)
    {
		if(isset($this->items['idUsuarioSession'])){
			/* BUSCAR PERMISOS*/
            
			$listaPermisos = $this->usuarioPermisos->listarPermisosUsuario($idUsuario);
            $usuario = $this->usuarioModelo->where("IDExterno",$idUsuario)->first();
			$listaModulos = $this->modulo->findAll();

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Permisos | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Permisos de Usuario',
                'previo'                => 'listar-usuarios',
				'listaPermisos'         => $listaPermisos,
                'listaModulos'          => $listaModulos,
                'usuarioSeleccionado'   => $usuario,
                'idUsuario'             => $idUsuario
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_permisos_usuario',$data);			
		} else {
			return view('errors/500');
		}
	}

	public function listarRutasUsuario($idUsuario)
    {
		if(isset($this->items['idUsuarioSession'])){
			/* BUSCAR PERMISOS*/
            
			$listaRutas = $this->usuarioRutas->listarRutasUsuario($idUsuario);
            $usuario = $this->usuarioModelo->where("IDExterno",$idUsuario)->first();
			$listaModulos = $this->modulo->findAll();

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Rutas | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Rutas de Usuario',
                'previo'                => 'listar-usuarios',
				'listaRutas'            => $listaRutas,
                'listaModulos'          => $listaModulos,
                'usuarioSeleccionado'   => $usuario,
                'idUsuario'             => $idUsuario
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_rutas_usuario',$data);			
		} else {
			return view('errors/500');
		}
	}
    
    public function guardarPermisosUsuario($idUsuario)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $permisos = $this->request->getPost('permisos') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';

        if(isset($permisos) && empty($permisos))
        {
            $error .= "<li>No hay permisos seleccionados.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        $listadoPermisosPrev = $this->usuarioPermisos->where("IdUsuario", $idUsuario)->findAll();

        if(count($listadoPermisosPrev) > 0)
        {
            $this->usuarioPermisos->delete($idUsuario);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataPermisos = array();

        foreach($permisos as $key => $value)
        {
            $dataPermisos[] = array (
                'IdUsuario'         => $idUsuario, 
                'IDAccionModulo'    => $key,
                'UsuarioRegistra'   => $this->items['idUsuarioSession'],
                'FechaRegistra'     => $fechaActual
            );
        }
        $lastId = $this->usuarioPermisos->insertBatch($dataPermisos, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function guardarRutasUsuario($idUsuario)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $rutas = $this->request->getPost('rutas') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';

        if(isset($rutas) && empty($rutas))
        {
            $error .= "<li>No hay rutas seleccionados.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        $listadoRutasPrev = $this->usuarioRutas->where("IdUsuario", $idUsuario)->findAll();

        if(count($listadoRutasPrev) > 0)
        {
            $this->usuarioRutas->delete($idUsuario);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataRutas = array();

        foreach($rutas as $key => $value)
        {
            $dataRutas[] = array (
                'IdUsuario'         => $idUsuario, 
                'IDRuta'            => $key,
                'UsuarioRegistra'   => $this->items['idUsuarioSession'],
                'FechaRegistra'     => $fechaActual
            );
        }
        $lastId = $this->usuarioRutas->insertBatch($dataRutas, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function obtenerUsuarios()
    {
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        $listadoUsuarios = $this->usuarioModelo->findAll();
        
        $usuarios=array();

		if (!empty($listadoUsuarios)) {
            foreach ($listadoUsuarios as $items) {
                $usuarios[] = array(
					'id' => (string) $items['IdDpto'],
         	        'usuario' => (string) $items['Nombres'].' '.$items['Apellidos'],
                );
            }

            $resultado = array(
				'listadoUsuarios' => json_encode($usuarios)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

    public function listadoUsuariosSelect()
    {
        $elemento = $this->request->getPost('term');
        
        $listado = $this->usuarioModelo->listadoUsuariosSelect($elemento['term'], '', 'Activo');
        
        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IdUsuario'],
                'text' => (string) $items['Matricula']." | ".$items['Nombres']." ".$items['Apellidos']
            );
        }

        echo json_encode($elementos);
    }

    // public function listadoUsuariosComprador()
    // {
    //     //Seteamos el perfil a buscar
    //     $idPerfil = 2;
    
    //     // $listadoUsuarios = $this->usuarioPerfil->listadoUsuariosPerfil($idPerfil);
        
    //     $listadoUsuarios = $this->usuarioPerfil->where("IDPerfil", $idPerfil)->findAll();
        
    //     foreach($listadoUsuarios as $key=>$value)
    //     {
    //         $usuario = $this->usuarioModelo->where("IdUsuario", $value['IdUsuario'])->first();
            
    //         $listadoUsuarios[$key]['Matricula'] = !empty($usuario) ? ucwords(mb_strtolower($usuario['Matricula'])) : "Sin información";
    //         $listadoUsuarios[$key]['Nombres'] = !empty($usuario) ? ucwords(mb_strtolower($usuario['Nombres'])) : "Sin información";
    //         $listadoUsuarios[$key]['Apellidos'] = !empty($usuario) ? ucwords(mb_strtolower($usuario['Apellidos'])) : "Sin información";
    //         $listadoUsuarios[$key]['NumeroDoc'] = !empty($usuario) ? ucwords(mb_strtolower($usuario['NumeroDoc'])) : "Sin información";
    //         $listadoUsuarios[$key]['Usuario'] = !empty($usuario) ? ucwords(mb_strtolower($usuario['Usuario'])) : "Sin información";
    //     }
        
    //     $usuarios=array();

	// 	if (!empty($listadoUsuarios)) {
    //         foreach ($listadoUsuarios as $items) {
    //             $usuarios[] = array(
	// 				'id' => (string) $items['IdUsuario'],
    //      	        'text' => (string) $items['Matricula'].' | '.$items['Nombres'].' '.$items['Apellidos'],
    //             );
    //         }
            
    //         //AGREGAMOS EL USUARIO LOGUEADO
    //             $usuarios[] = array(
	// 				'id' => (string) $this->items['idUsuarioSession'],
    //      	        'text' => (string) $this->items['matriculaLog'].' | '.$this->items['nombres'].' '.$this->items['apellidos'],
    //             );
    //         $resultado = array(
	// 			'listadoUsuarios' => json_encode($usuarios)
	// 		);
    //     } else {
	// 		$resultado = array(
	// 			'descripcion' => 0,
	// 		);
	// 	}

    //     /*
    //      * ----------------------------
    //      * DATOS DE AJAX PRE PROCESADOS
    //      * ----------------------------
    //      */
    //     echo json_encode($resultado);
    // }

}