<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable">
	<head>
		<meta charset="utf-8">
		<title><?= $titulo ?></title>
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta content="Sistema Vericompras | Perú" name="description">
		<meta content="Verisure Perú" name="author">
		<!-- App favicon -->
		<link rel="shortcut icon" href="<?= $baseUrl ?>/public/images/favicon.ico">

		<!--datatable css-->
		<link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css">
		<!--datatable responsive css-->
		<link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css">
		<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
		<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">
		
		<!-- Layout config Js -->
		<script src="<?= $baseUrl ?>/public/js/layout.js"></script>
		<!-- Bootstrap Css -->
		<link href="<?= $baseUrl ?>/public/css/bootstrap.min.css" rel="stylesheet" type="text/css">
		
		<link href="<?= $baseUrl ?>/public/libs/bootstrap-switch/css/bootstrap3/bootstrap-switch.min.css" rel="stylesheet" type="text/css">
		<!-- Icons Css -->
		<link href="<?= $baseUrl ?>/public/css/icons.min.css" rel="stylesheet" type="text/css">
		<!-- App Css-->
		<link href="<?= $baseUrl ?>/public/css/app.min.css?<?= $aleatorio ?>" rel="stylesheet" type="text/css">
		<!-- custom Css-->
		<link href="<?= $baseUrl ?>/public/css/custom.min.css" rel="stylesheet" type="text/css">
		<!-- AUTOCOMPLETE-->
		<link rel="stylesheet" href="//code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
		<!-- Toastr -->
		<link rel="stylesheet" href="<?= $baseUrl ?>/public/js/pages/plugins/toastr/toastr.min.css">
		<!-- SweetAlert -->
		<link rel="stylesheet" href="<?= $baseUrl ?>/public/js/pages/plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css">
		<!-- pie-charts.css -->
        <link rel="stylesheet" href="<?= $baseUrl ?>/public/libs/pie-charts/pie-charts.css">
	    <!-- SmartWizard -->
	    <link rel="stylesheet" href="<?= $baseUrl ?>/public/css/smartwizard.css">
	    <!-- Filepond -->
	    <link rel="stylesheet" href="<?= $baseUrl ?>/public/libs/filepond/filepond.min.css" type="text/css">
	    <link rel="stylesheet" href="<?= $baseUrl ?>/public/libs/filepond-plugin-image-preview/filepond-plugin-image-preview.min.css">
		<!-- Styles propios -->
		<link rel="stylesheet" href="<?= $baseUrl ?>/public/css/styles.css?<?= $aleatorio ?>">
	</head>
	<body>
		<!-- Begin page -->
		<div id="layout-wrapper">
			<header id="page-topbar">
				<div class="layout-width">
					<div class="navbar-header">
						<div class="d-flex">
							<!-- LOGO -->
							<div class="navbar-brand-box horizontal-logo">
								<a href="<?= $baseUrl ?>/<?= $linkbaseperfil ?>" class="logo logo-dark">
								<span class="logo-sm">
								<img src="<?= $baseUrl ?>/public/images/logob-sm.png" alt="" height="40">
								</span>
								<span class="logo-lg">
								<img src="<?= $baseUrl ?>/public/images/logob.png" alt="">
								</span>
								</a>
								<a href="<?= $baseUrl ?>/<?= $linkbaseperfil ?>" class="logo logo-donbosco">
								<span class="logo-sm">
								<img src="<?= $baseUrl ?>/public/images/logob-sm.png" alt="" height="40">
								</span>
								<span class="logo-lg">
								<img src="<?= $baseUrl ?>/public/images/logob.png" alt="" height="40">
								</span>
								</a>
							</div>
							<button type="button" class="btn btn-sm px-3 fs-16 header-item vertical-menu-btn topnav-hamburger shadow-none" id="topnav-hamburger-icon">
							<span class="hamburger-icon">
							<span></span>
							<span></span>
							<span></span>
							</span>
							</button>
						</div>
						<div class="d-flex align-items-center">
							<div class="dropdown d-md-none topbar-head-dropdown header-item">
								<button type="button" class="btn btn-icon btn-topbar btn-ghost-secondary rounded-circle shadow-none" id="page-header-search-dropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								<i class="bx bx-search fs-22"></i>
								</button>
								<div class="dropdown-menu dropdown-menu-lg dropdown-menu-end p-0" aria-labelledby="page-header-search-dropdown">
									<form class="p-3">
										<div class="form-group m-0">
											<div class="input-group">
												<input type="text" class="form-control" placeholder="Search ..." aria-label="Recipient's username">
												<button class="btn btn-primary" type="submit"><i class="mdi mdi-magnify"></i></button>
											</div>
										</div>
									</form>
								</div>
							</div>
							<div class="ms-1 header-item d-none d-sm-flex">
							    <div class="btn-group">
                                    <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                        Sistemas Verisure
                                    </button>
                                    <div class="dropdown-menu" data-popper-placement="bottom-start" style="position: absolute; inset: 0px auto auto 0px; margin: 0px; transform: translate(0px, 40px);">
                                        <!-- item-->
                                        <?php
                                        foreach($sistemas as $items)
                                        {
                                        ?>
                                        <!--<a class="dropdown-item" href="<?= 'https://www.verismart.com.pe/'.$items['Raiz'] ?>"><?= $items['Sistema'] ?></a>-->
                                        <a class="dropdown-item" href="<?= $items['Dominio'].'/'.$items['Raiz'] ?>"><?= $items['Sistema'] ?></a>
                                        <?php
                                        }
                                        ?>
                                    </div>
                                </div>
							</div>
							<div class="ms-1 header-item d-none d-sm-flex">
								<button type="button" class="btn btn-icon btn-topbar btn-ghost-secondary rounded-circle shadow-none" data-toggle="fullscreen">
								<i class='bx bx-fullscreen fs-22'></i>
								</button>
							</div>
							<div class="ms-1 header-item d-none d-sm-flex">
								<button type="button" class="btn btn-icon btn-topbar btn-ghost-secondary rounded-circle light-dark-mode shadow-none">
								<i class='bx bx-moon fs-22'></i>
								</button>
							</div>
							<!-- INICIO NOTIFICACIONES -->
							<div class="dropdown topbar-head-dropdown ms-1 header-item" id="notificationDropdown">
                                <button type="button" class="btn btn-icon btn-topbar btn-ghost-secondary rounded-circle" id="btnNotificacionesHeader" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-haspopup="true" aria-expanded="false">
                                    <i class="bx bx-bell fs-22"></i>
                                    <span class="position-absolute topbar-badge fs-10 translate-middle badge rounded-pill bg-danger" id="ctnCantidadNotificacionesHeader"><?= $notificacionesNoVistasInicio ?><span class="visually-hidden">unread messages</span></span>
                                </button>
                                <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end p-0" aria-labelledby="btnNotificacionesHeader">
            
                                    <div class="dropdown-head bg-sistema rounded-top">
                                        <div class="p-3">
                                            <div class="row align-items-center">
                                                <div class="col">
                                                    <h6 class="m-0 fs-16 fw-semibold text-white"> Notificaciones </h6>
                                                </div>
                                                <!--<div class="col-auto dropdown-tabs">-->
                                                <!--    <span class="badge bg-light-subtle text-body fs-13"> 4 New</span>-->
                                                <!--</div>-->
                                            </div>
                                        </div>
            
                                        <div class="px-2 pt-2">
                                            <ul class="nav nav-tabs dropdown-tabs nav-tabs-custom" data-dropdown-tabs="true" id="notificationItemsTab" role="tablist">
                                                <li class="nav-item waves-effect waves-light" role="presentation">
                                                    <a class="nav-link active" data-bs-toggle="tab" href="#all-noti-tab" role="tab" aria-selected="true">
                                                        Todas las notificaciones
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
            
                                    </div>
            
                                    <div class="tab-content position-relative" id="notificationItemsTabContent">
                                        <div class="tab-pane fade show active py-2 ps-2" id="all-noti-tab" role="tabpanel">
                                            <div data-simplebar style="max-height: 300px;" class="pe-2" id="ctnNotificacionesHeader">
                                                <div class="text-reset notification-item d-block dropdown-item position-relative">
                                                    <div class="d-flex">
                                                        <div class="avatar-xs me-3 flex-shrink-0">
                                                            <span class="avatar-title bg-info-subtle text-info rounded-circle fs-16">
                                                                <i class="bx bx-badge-check"></i>
                                                            </span>
                                                        </div>
                                                        <div class="flex-grow-1">
                                                            <a href="<?= $baseUrl ?>/detalle-peticion/6" target="_blank" class="stretched-link">
                                                                <h6 class="mt-0 mb-2 lh-base">Your <b>Elite</b> author Graphic
                                                                    Optimization <span class="text-secondary">reward</span> is
                                                                    ready!
                                                                </h6>
                                                            </a>
                                                            <p class="mb-0 fs-11 fw-medium text-uppercase text-muted">
                                                                <span><i class="mdi mdi-clock-outline"></i> Just 30 sec ago</span>
                                                            </p>
                                                        </div>
                                                        <!--<div class="px-2 fs-15">-->
                                                        <!--    <div class="form-check notification-check">-->
                                                        <!--        <input class="form-check-input" type="checkbox" value="" id="all-notification-check01">-->
                                                        <!--        <label class="form-check-label" for="all-notification-check01"></label>-->
                                                        <!--    </div>-->
                                                        <!--</div>-->
                                                    </div>
                                                </div>
                                                
                                                <div class="my-3 text-center view-all" style="display: block;">
                                                    <button type="button" class="btn btn-soft-success waves-effect waves-light">View
                                                        All Notifications <i class="ri-arrow-right-line align-middle"></i></button>
                                                </div>
                                            </div>
                                        </div>
            
                                    </div>
                                </div>
                            </div>
							<!-- FIN NOTIFICACIONES -->
							<div class="dropdown ms-sm-3 header-item topbar-user">
								<button type="button" class="btn shadow-none" id="page-header-user-dropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								<span class="d-flex align-items-center">
								<img class="rounded-circle header-profile-user" src="<?= $baseUrl ?>/public/images/users/user-dummy-img.jpg" alt="Header Avatar">
								<span class="text-start ms-xl-2">
								<span class="d-none d-xl-inline-block ms-1 fw-medium user-name-text"><?= $nombres.' '.$apellidos ?></span>
								<span class="d-none d-xl-block ms-1 fs-12 text-muted user-name-sub-text"><?= $perfil ?></span>
								</span>
								</span>
								</button>
								<div class="dropdown-menu dropdown-menu-end">
									<!-- item-->
									<h6 class="dropdown-header">¡Hola <?= $nombres ?>!</h6>
									<a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#cambiarContrasena">
										<i class="mdi mdi-lock text-muted fs-16 align-middle me-1"></i> <span class="align-middle">Cambiar contraseña</span>
									</a>
									<a class="dropdown-item" href="<?= $baseUrl ?>/salir">
										<i class="mdi mdi-logout text-muted fs-16 align-middle me-1"></i> <span class="align-middle" data-key="t-logout">Cerrar sesión</span>
									</a>
								</div>
							</div>
						</div>
					</div>
				</div>
			</header>
			<!-- ========== App Menu ========== -->
			<div class="app-menu navbar-menu">
				<!-- LOGO -->
				<div class="navbar-brand-box">
					<!-- Dark Logo-->
					<a href="<?= $baseUrl ?>/<?= $linkbaseperfil ?>" class="logo logo-dark">
					<span class="logo-sm">
					<img src="<?= $baseUrl ?>/public/images/logob-sm.png" alt="" height="35">
					</span>
					<span class="logo-lg">
					<img src="<?= $baseUrl ?>/public/images/logob.png" alt="" height="40">
					</span>
					</a>
					<!-- Light Logo-->
					<a href="<?= $baseUrl ?>/<?= $linkbaseperfil ?>" class="logo logo-donbosco">
					<span class="logo-sm">
					<img src="<?= $baseUrl ?>/public/images/logob-sm.png" alt="" height="35">
					</span>
					<span class="logo-lg">
					<img src="<?= $baseUrl ?>/public/images/logob.png" alt="" height="40">
					</span>
					</a>
					<button type="button" class="btn btn-sm p-0 fs-20 header-item float-end btn-vertical-sm-hover" id="vertical-hover">
					<i class="ri-record-circle-line"></i>
					</button>
				</div>
				<div id="scrollbar">
					<div class="container-fluid">
						<div id="two-column-menu">
						</div>
						<ul class="navbar-nav" id="navbar-nav">
							<?php
							foreach($cabecera as $items)
							{
							    if(in_array($items['IDCabecera'], array_column($navbar, 'IDCabecera')))
							    {
    							?>
    							<li class="menu-title"><span data-key="t-menu"><?= $items['Cabecera'] ?></span></li>
    							<?php
    								foreach($navbar as $nav)
    								{
    									if($items['IDCabecera'] == $nav['IDCabecera'])
    									{
    									?>
    									<li class="nav-item">
    										<a class="nav-link menu-link <?php if($breadcrumb == $nav['Modulo']){ echo "active"; } ?>" href="<?= $baseUrl ?>/<?= $nav['Ruta'] ?>">
    										<i class="<?= $nav['Icono'] ?>"></i> <span data-key="t-widgets"><?= $nav['Modulo'] ?></span>
    										</a>
    									</li>
    									<?php
    									}
    								}
							    }
							}
							?>
							<!-- end Dashboard Menu -->
						</ul>
					</div>
					<!-- Sidebar -->
				</div>
				<div class="sidebar-background"></div>
			</div>
			<!-- Left Sidebar End -->
			<!-- Vertical Overlay-->
			<div class="vertical-overlay"></div>

        <?= $this->renderSection('content'); ?>
            <span class="respuesta_cambio_password"></span>
		</div>
		<!-- END layout-wrapper -->

		<!-- Modal Cambiar de ContraseÃ±a -->
		<div class="modal fade zoomIn" id="cambiarContrasena" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleCambiarContrasena" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content" style="border: none;">
                    <div class="modal-header p-3 bg-red-verisure" style="">
                        <h4 class="modal-title color-white" id="exampleCambiarContrasena">Cambio de Contraseña</h4>
                        <button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form class="formularioCambiarPassword" id="formCambiarPassword" autocomplete="off" action="<?= $baseUrl ?>/cambiar-password" method="POST">
                        <div class="modal-body px-5 pb-2">
                            <div class="w-100 d-flex justify-content-center align-items-center p-3">
                                <img src="<?= $baseUrl ?>/public/images/cambioContrasena2.png" style="width: 300px;" class="center-block">
                            </div>
                            <h3>Introduzca una nueva contraseña para <span style="color:red"><?= ucwords(mb_strtolower($nombres.' '.$apellidos)) ?>.</span></h3>
                            <h5>Su contraseña debe tener al menos:</h5>
                            <h5><span style="color:red"><i class="mdi mdi-radiobox-marked"></i></span> Entre 10 a más caracteres</h5>
                            <h5><span style="color:red"><i class="mdi mdi-radiobox-marked"></i></span> 1 letra(s) en minúscula y al menos 1 letra(s) en MAYÚSCULA</h5>
                            <h5><span style="color:red"><i class="mdi mdi-radiobox-marked"></i></span> 1 dígito(s) y un carácter especial (por ejemplo: - , *, $, %...)</h5>
                            <!--<h5><span style="color:red"><i class="mdi mdi-radiobox-marked"></i></span> No puede coincidir con ninguna de las 3 últimas utilizadas</h5>-->
                            <!--<h5><span style="color:red"><i class="mdi mdi-radiobox-marked"></i></span> No puede contener su nombre o apellido</h5>-->
                            <div class="row ">
    							<div class="col-xxl-12 col-md-12 col-12">
    								<div>
    									<label for="txtPasswordActual" class="form-control px-0 m-0 border-0" style="width: 100%; font-size: 16px"><span class="color-red me-2">*</span>Contraseña Actual</label>
                                        <div class="position-relative auth-pass-inputgroup mb-3">
    										<input type="password" class="form-control pe-5 password-input" placeholder="Ingresa tu Contraseña Actual" id="txtPasswordActual" name="txtPasswordActual">
    										<button type="button" class="btn btn-link position-absolute end-0 top-0 text-decoration-none text-muted password-addon" type="button" style="border: none; box-shadow: none;"><i class="ri-eye-fill align-middle"></i></button>
    									</div>
    								</div>
    							</div>
    							<div class="col-xxl-12 col-md-12 col-12">
    								<div>
    									<label for="txtNuevoPassword" class="form-control px-0 m-0 border-0" style="width: 100%; font-size: 16px"><span class="color-red mx-2">*</span>Nueva Contraseña</label>
                                        <div class="position-relative auth-pass-inputgroup mb-3">
    										<input type="password" class="form-control pe-5 password-input" placeholder="Nueva Contraseña" id="txtNuevoPassword" name="txtNuevoPassword">
    										<button type="button" class="btn btn-link position-absolute end-0 top-0 text-decoration-none text-muted password-addon" type="button" style="border: none; box-shadow: none;"><i class="ri-eye-fill align-middle"></i></button>
    									</div>
    								</div>
    							</div>
    							<div class="col-xxl-12 col-md-12 col-12">
    								<div>
    									<label for="txtConfirmarNuevoPassword" class="form-control px-0 border-0" style="width: 100%; font-size: 16px"><span class="color-red mx-2">*</span>Confirmar Nueva Contraseña</label>
    									<div class="position-relative auth-pass-inputgroup mb-3">
    										<input type="password" class="form-control pe-5 password-input" placeholder="Confirmar Contraseña" id="txtConfirmarNuevoPassword" name="txtConfirmarNuevoPassword">
    										<button type="button" class="btn btn-link position-absolute end-0 top-0 text-decoration-none text-muted password-addon" type="button" style="border: none; box-shadow: none;"><i class="ri-eye-fill align-middle"></i></button>
    									</div>
    								</div>
    							</div>
    						</div>
                        </div>
                        <hr class="m-0 p-0">
        				<div class="modal-footer py-3">
        					<button type="button" class="btn btn-danger d-flex justify-content-center" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
        					<button type="submit" class="btn btn-success d-flex justify-content-center"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Guardar</button>
        				</div>
                    </form>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
		<!--start back-to-top-->
		<button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
		<i class="ri-arrow-up-line"></i>
		</button>
		<!--end back-to-top-->
		<!--preloader-->
		<div id="preloader">
			<div id="status">
				<div class="spinner-border text-primary avatar-sm" role="status">
					<span class="visually-hidden">Loading...</span>
				</div>
			</div>
		</div>
      	<script> window.baseUrl = "<?= base_url(); ?>"</script>
		<!-- jQuery -->
		<script src="<?= $baseUrl ?>/public/js/pages/plugins/jquery/jquery.min.js"></script>
		<!-- JAVASCRIPT -->
		<script src="<?= $baseUrl ?>/public/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
		<!--<script src="<?= $baseUrl ?>/public/libs/simplebar/simplebar.min.js?<?= $aleatorio ?>"></script>-->
		<script src="https://cdn.jsdelivr.net/npm/simplebar@latest/dist/simplebar.min.js"></script>
		<script src="<?= $baseUrl ?>/public/libs/node-waves/waves.min.js"></script>
		<script src="<?= $baseUrl ?>/public/libs/feather-icons/feather.min.js"></script>
		<script src="<?= $baseUrl ?>/public/js/pages/plugins/lord-icon-2.1.0.js"></script>
		<script src="<?= $baseUrl ?>/public/js/plugins.js"></script>
		<script src="<?= $baseUrl ?>/public/libs/bootstrap-switch/js/bootstrap-switch.min.js"></script>
		
       <!-- Autocomplite -->
       <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
       
		<!--datatable js-->
		<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
		<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
		<script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
		<script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
		<script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
		<script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
		
		<script src="<?= $baseUrl ?>/public/js/pages/datatables.init.js"></script>      
		<!-- PASSWORD ADDON -->
		<script src="<?= $baseUrl ?>/public/js/pages/password-addon.init.js"></script>
		<!-- apexcharts -->
		<script src="<?= $baseUrl ?>/public/libs/apexcharts/apexcharts.min.js"></script>
		<!-- piecharts init -->
		<script src="<?= $baseUrl ?>/public/libs/pie-charts/pie-charts.js"></script>
		<!--select2 cdn-->
		<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
		<script src="<?= $baseUrl ?>/public/js/pages/select2.init.js"></script>
		<!-- echarts js -->
		<script src="<?= $baseUrl ?>/public/libs/echarts/echarts.min.js"></script>
		<!-- Toastr -->
		<script src="<?= $baseUrl ?>/public/js/pages/plugins/toastr/toastr.min.js"></script>
		<!-- SweetAlert -->
		<script src="<?= $baseUrl ?>/public/js/pages/plugins/sweetalert2/sweetalert2.min.js?<?= $aleatorio ?>"></script>
		<!-- Moment -->
		<script src="<?= $baseUrl ?>/public/libs/moment/moment.js?<?= $aleatorio ?>"></script>
		<!-- Forms Wizad -->
		<script src="<?= $baseUrl ?>/public/js/pages/form-wizard.init.js"></script>
		<!-- Filepong -->
		<script src="<?= $baseUrl ?>/public/libs/filepond/filepond.min.js"></script>
		<script src="<?= $baseUrl ?>/public/libs/filepond/filepond.jquery.js"></script>
		<script src="<?= $baseUrl ?>/public/libs/filepond-plugin-file-validate-type/filepond-plugin-file-validate-type.min.js?<?= $aleatorio ?>"></script>
		<script src="<?= $baseUrl ?>/public/libs/filepond-plugin-image-preview/filepond-plugin-image-preview.min.js"></script>
		<!--<script src="<?= $baseUrl ?>/public/libs/filepond-plugin-file-validate-size/filepond-plugin-file-validate-size.min.js"></script>-->
		<script src="<?= $baseUrl ?>/public/libs/filepond-plugin-image-exif-orientation/filepond-plugin-image-exif-orientation.min.js"></script>
		<!--<script src="<?= $baseUrl ?>/public/libs/filepond-plugin-file-encode/filepond-plugin-file-encode.min.js"></script>-->
		<!--<script src="<?= $baseUrl ?>/public/js/pages/form-file-upload.init.js"></script>-->
		<!-- App js -->
		<script src="<?= $baseUrl ?>/public/js/app.js?<?= $aleatorio ?>"></script>
		<!-- SmartWizard -->
		<script src="https://cdn.jsdelivr.net/npm/smartwizard@6/dist/js/jquery.smartWizard.min.js" type="text/javascript"></script>
		<!-- Estructura -->
		<script src="<?= $baseUrl ?>/public/js/estructura.js?<?= $aleatorio ?>"></script>
		<!-- Proceso -->
		<script src="<?= $baseUrl ?>/public/js/proceso.js?<?= $aleatorio ?>"></script>
		<!-- Notificaciones -->
		<script src="<?= $baseUrl ?>/public/js/notificaciones.js?<?= $aleatorio ?>"></script>
		<!-- echarts init -->
		<!--<script src="assets/js/pages/echarts.init.js"></script>-->
		<script>
		
            $(document).on('click', '#btnCambiarPassword', function(e) 
            {
                let modal = $(this).data("bs-target");
                
                $("#txtPasswordActual").val("");
                $("#txtNuevoPassword").val("");
                $("#txtConfirmarNuevoPassword").val("");
                
                $(modal).modal("show");
            });

		    
		</script>
		<?= $this->renderSection('js'); ?>
	</body>
</html>