<?php
namespace App\Models;
use CodeIgniter\Model;
use \App\Libraries\Globales;

class NotificacionesModel extends Model
{
    protected $table      = 'notificaciones';
    protected $primaryKey = 'IDNotificacion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['TablaReferencia', 'IDReferencia', 'Mensaje', 'URL', 'IDUsuarioDestino', 'IDPerfilDestino', 'UsuarioRegistra', 'FechaRegistra', 'Estado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listarNotificaciones($array)
    {
        if(!isset($array['idperfil']))
        {
            $array['idperfil'] = '';
        }
        
        $this->select('
        notificaciones.IDNotificacion,
        notificaciones.TablaReferencia,
        notificaciones.IDReferencia,
        notificaciones.Mensaje,
        notificaciones.URL,
        notificaciones.IDUsuarioDestino,
        notificaciones.IDPerfilDestino,
        notificaciones.FechaRegistra,
        notificaciones.Estado,
        notificaciones_visualizado.UsuarioVisualizado,
        notificaciones_visualizado.FechaVisualizado');
        $this->join('notificaciones_visualizado', 'notificaciones.IDNotificacion = notificaciones_visualizado.IDNotificacion AND notificaciones_visualizado.UsuarioVisualizado = "'.$array['idusuario'].'"', 'left');
        $this->where('notificaciones.Estado', "A");
        
        $this->where('(notificaciones.IDUsuarioDestino = "'.$array['idusuario'].'" OR 
                   	notificaciones.IDPerfilDestino = "'.$array['idperfil'].'")');
                	
        if(isset($array['solonovisto']) && $array['solonovisto'] == 'Y')
        {
            $this->where('notificaciones_visualizado.IDNotificacion IS NULL');
        }
        
        if(isset($array['idreferencia']) && isset($array['tablareferencia']))
        {
            $this->where('notificaciones.TablaReferencia', $array['tablareferencia']);
            $this->where('notificaciones.IDReferencia', $array['idreferencia']);
        }
        $this->orderBy('notificaciones.FechaRegistra', 'DESC');
        $datos = $this->findAll();
        return $datos;
    }
    
    public function cantidadNotificacionesSinVer($array)
    {
        if(!isset($array['idperfil']))
        {
            $array['idperfil'] = '';
        }
        
        $this->select('COUNT(*) AS TOTALNOVISTO');
        $this->join('notificaciones_visualizado', 'notificaciones.IDNotificacion = notificaciones_visualizado.IDNotificacion AND notificaciones_visualizado.UsuarioVisualizado = "'.$array['idusuario'].'"', 'left');
        $this->where('notificaciones.Estado', "A");
        $this->where('notificaciones_visualizado.IDNotificacion IS NULL');
        $this->where('(notificaciones.IDUsuarioDestino = "'.$array['idusuario'].'" OR 
                   	notificaciones.IDPerfilDestino = "'.$array['idperfil'].'")');
        
        $this->orderBy('notificaciones.FechaRegistra', 'DESC');
        $datos = $this->first();
        // echo $this->getLastQuery();
        // exit;
        return $datos;
    }
}