<?php
namespace App\Models;
use CodeIgniter\Model;

class EstructuraDireccionResponsableModel extends Model
{
    protected $DBGroup      = 'baseT';
    protected $table        = 'estructura_direccion_responsable';
    protected $primaryKey   = 'IDDireccion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDDireccion', 'IDResponsable', 'Principal', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listadoResponsablesDireccion($idDireccion)
    {
        $this->select('
            estructura_direccion_responsable.IDDireccion,
            estructura_direccion_responsable.IDResponsable,
            estructura_direccion_responsable.Principal,
            CONCAT(tblusuario.Nombres, " ", tblusuario.Apellidos) AS "NombreResponsable",
            tblusuario.Matricula AS "MatriculaResponsable",
            tblusuario.Usuario AS "UsuarioResponsable",
            tblusuario.Correo AS "CorreoResponsable",
            cargos.Cargo AS "CargoResponsable"');
        $this->join('tblusuario', 'estructura_direccion_responsable.IDResponsable = tblusuario.IdUsuario', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->where('estructura_direccion_responsable.IDDireccion', $idDireccion);
        $datos = $this->findAll();
        return $datos;
    }
    
}