<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card mt-n4 mx-n4">
                        <div class="bg-<?= $claseEstilo ?>-50">
                            <div class="card-body pb-0 px-4">
                                <div class="row mb-3">
                                    <div class="col-md">
                                        <div class="row align-items-center g-3">
                                            <div class="col-md-auto">
                                                <div class="avatar-md">
                                                    <div class="avatar-title bg-white rounded-circle">
                                                        <img src="<?= $baseUrl ?>/<?= $basePublic ?>/images/favicon.ico" alt="" class="avatar-xs">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md">
                                                <div>
                                                    <h4 class="fw-bold">#<?= $oferta['IDOfertas'] ?> - <?= ucwords(mb_strtolower($oferta['TipoRequerimiento']))." | ".ucwords(mb_strtolower($oferta['Requerimiento']))." | ".ucwords(mb_strtolower($oferta['MotivoRequerimiento'])) ?></h4>
                                                    <div class="hstack gap-3 flex-wrap">
                                                        <div><i class="mdi mdi-account align-bottom me-1"></i><?= ucwords(mb_strtolower($oferta['NombresCreador'].' '.$oferta['ApellidosCreador'])) ?></div>
                                                        <div class="vr"></div>
                                                        <div>Fecha de Creación: <span class="fw-medium"><?= date("d-m-Y H:i:s", strtotime($oferta['FechaCrea'])) ?></span></div>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php
                                            

                                            $mostrarBoton = ($oferta['Matriz'] == 'Fuera' && $oferta['EstadoAprobacion']== 'PEND') ? '' : 'd-none';
                                            ?>
                                            <div class="col-md-auto mt-md-0 mt-4 d-flex justify-content-end align-items-center">
                                                <div class="hstack gap-1 flex-wrap">
                                                <?php
                                                    if (in_array("CANOFE",$permisos)){
                                                    $mostrarBoton = ($oferta['Matriz'] == 'Fuera' && $oferta['EstadoAprobacion']== 'PEND') ? '' : 'd-none';
                                                ?>
                                                    <button type="button" class="btn bg-warning px-2 py-1 <?= $mostrarBoton ?>" data-oferta="<?= $oferta['IDOfertas'] ?>" data-estado="CANC" data-tipo="cancelado" id="btnCancelarOferta" data-tooltip="tooltip" title="Solicitar cancelación de Oferta">
                                                        <i class="mdi mdi-cancel align-bottom" style="font-size: 24px; color: #FFF;"></i>
                                                    </button>
                                                <?php } ?>
                                                    <a href="<?= $baseUrl.'/'.$previo ?>" class="btn btn-danger px-2 py-1" data-tooltip="tooltip" title="Volver">
                                                        <i class="mdi mdi-arrow-left-circle" style="font-size: 24px; color: #FFF"></i>
                                                    </a>
                                                </div>
                                            </div>
                                            <input type="hidden" id="valorDescuentoEditar" val="<?= $oferta['ValorDescuento']?>">
                    						<input type="hidden" id="maxDescuentoEditar">
                    						<input type="hidden" id="tipoDeOfertaEditar">
 
                                        </div>
                                    </div>
                                </div>

                                <ul class="nav nav-tabs-custom border-bottom-0" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link fw-semibold active" data-bs-toggle="tab" href="#oferta-general" role="tab" aria-selected="true" data-condonacion="<?= $oferta['IDOfertas'] ?>" onclick="recargarGeneralOferta(this);">
                                            General
                                        </a>
                                    </li>
                                    <!--<li class="nav-item" role="presentation">-->
                                    <!--    <a class="nav-link fw-semibold" data-bs-toggle="tab" href="#condonacion-facturas" role="tab" aria-selected="false" tabindex="-1">-->
                                    <!--        Facturas-->
                                    <!--    </a>-->
                                    <!--</li>-->
                                    <!--<li class="nav-item" role="presentation">-->
                                    <!--    <a class="nav-link fw-semibold" data-bs-toggle="tab" href="#condonacion-facturas-gestor" role="tab" aria-selected="false" tabindex="-1" data-condonacion="<?//= $oferta['IDOfertas'] ?>" onclick="recargarFacturasGestorCondonacion(this); mostrarBotonSolicitarPeticionCondonacion('<?//= $oferta['IDOfertas'] ?>');">-->
                                    <!--        Facturas-->
                                    <!--    </a>-->
                                    <!--</li>-->
                                    <!--<li class="nav-item" role="presentation">-->
                                    <!--    <a class="nav-link fw-semibold" data-bs-toggle="tab" href="#condonacion-aprobaciones" role="tab" aria-selected="false" tabindex="-1" data-condonacion="<?//= $oferta['IDOfertas'] ?>" onclick="recargarAprobacionesCondonacion(this); mostrarBotonSolicitarPeticionCondonacion('<?//= $oferta['IDOfertas'] ?>');">-->
                                    <!--        Aprobaciones-->
                                    <!--    </a>-->
                                    <!--</li>-->
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link fw-semibold" data-bs-toggle="tab" href="#oferta-bitacora" role="tab" aria-selected="false" tabindex="-1" data-oferta="<?= $oferta['IDOfertas'] ?>" onclick="recargarBitacoraOferta(this);">
                                            Bitacora
                                        </a>
                                    </li>
                                </ul>
                            </div>
                            <!-- end card body -->
                        </div>
                    </div>
                    <!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="tab-content text-muted">
                        <div class="tab-pane fade active show" id="oferta-general" role="tabpanel">
                            <div class="row">
                                <div class="col-xl-8 col-lg-6">
                                    
                                    <div class="card border card-border-<?= $claseEstilo ?> ">
                                        <div class="card-header align-items-center d-flex border-bottom-dashed">
                                            <h4 class="card-title mb-0 flex-grow-1"><?= $oferta['Matriz']=='Dentro'?'OBSERVACION':'APROBADOR' ?> <span class="badge bg-<?= $claseEstilo ?> align-middle fs-10"><?= $etiqueta ?> </span><span class="badge bg-secondary align-middle fs-10"><?= $oferta['Matriz']=='Dentro'?'DENTRO DE LA MATRIZ':'FUERA DE LA MATRIZ' ?></span></h4>
                                            <div class="flex-shrink-0">
                                                <button type="button" class="btn bg-<?= $claseEstilo ?> px-2 py-1" data-tooltip="tooltip" title="Actualizar Aprobadores" onclick="return mostrarAprobadoreGeneral('<?= $oferta['IDOfertas'] ?>')">
                                                    <i class="mdi mdi-refresh" style="font-size: 18px; color: #FFF"></i>
                                                </button>
                                            </div>
                                        </div>

                                        <div class="card-body p-4">
                                            <div class="vstack gap-3" id="ctnAprobadoresGeneral">
                                                
                                                
                                            </div>
                                        </div>
                                        <!-- end card body -->
                                    </div>

                                    <!-- end card -->
                                    <div class="card">
                                        <div class="card-header align-items-center d-flex">
                                            <h4 class="card-title mb-0 flex-grow-1">Comentarios de Oferta</h4>
                                            <div class="flex-shrink-0">
                                                <button type="button" class="btn bg-sistema px-2 py-1" data-tooltip="tooltip" title="Actualizar Comentarios de la Oferta" onclick="return mostrarComentariosGeneralOferta('<?= $oferta['IDOfertas'] ?>')">
                                                    <i class="mdi mdi-refresh" style="font-size: 18px; color: #FFF"></i>
                                                </button>
                                            </div>
                                        </div><!-- end card header -->

                                        <div class="card-body">
                                            <div class="col-12" data-simplebar id="ctnComentariosGeneralOferta" style="height: 250px;">
                                            </div>
                                            <hr>
                                            <div class="col-12 p-3 m-0">
                                                <form class="formularioRegistrarComentarioOferta comentario m-0" autocomplete="off" action="<?= $baseUrl ?>/registrar-comentario-oferta" method="POST" data-contenedor="ctnComentariosGeneralOferta" >
                                			        <div class="row col-12 m-0 p-0 d-flex">
                                			            <div class="panel m-0">
                                                            <div class="panel-heading">
                                                                <h4>Registrar Comentario</h4>
                                                            </div>
                                                            <div class="panel-content">
                                                                <div class="row">
                                                                    <div class="col-10">
                                                                        <input type="hidden" id="txtIDOferta_rcomcond" name="txtIDOferta_rcomcond" value="<?= $oferta['IDOfertas'] ?>">
                                            							<textarea class="form-control" id="txtComentariosOferta_rcomcond" name="txtComentariosOferta_rcomcond" rows="4" placeholder="Comentarios...."></textarea>
                                            						</div>
                                            						<div class="col-2 d-flex justify-content-center align-items-center">
                                            						    <button type="submit" class="btn bg-sistema color-white p-2 px-3 mx-1">
                                                                            <i class="mdi mdi-content-save" style="font-size: 22px;"></i>
                                                                        </button>
                                            						</div>
                                                                </div>
                                                            </div>
                                                        </div>
                                				    </div>
                                			    </form>
                                			</div>
                                        </div>
                                        <!-- end card body -->
                                    </div>

                                    <!-- end card -->
                                    
                                </div>
                                <!-- ene col -->
                                <div class="col-xl-4 col-lg-6">
                                    
                                    <div class="card">
                                        <div class="card-header align-items-center d-flex">
                                            <h5 class="card-title mb-0 flex-grow-1">Información de Solicitud</h5>
                                            <div class="flex-shrink-0">
                                            <?php if(in_array("EDIOFE",$permisos)){ ?>    
                                                <button type="button" class="btn bg-<?= $claseEstilo ?> px-2 py-1" data-tooltip="tooltip" title="Editar Oferta" onclick="editarDetalleOferta(<?= $oferta['IDOfertas'] ?>,<?= $oferta['Descuento'] ?>,<?= $oferta['MesesTiempoOferta'] ?>,'<?= $oferta['TipoDescuento'] ?>',<?= $oferta['CuotaMonitoreo'] ?>,'<?= $oferta['TiempoOferta'] ?>', <?= $oferta['IDOfertaNomenclatura'] ?>, '<?= $oferta['FechaInicio'] ?>', '<?= $oferta['TipoOferta'] ?>', <?= $oferta['IDGrupoCarteraCliente'] ?>, <?= $oferta['PermanenciaCliente'] ?> )">
                                                    <i class="mdi mdi-file-document-edit-outline" style="font-size: 22px; color: #FFF"></i>
                                                </button>
                                            <?php } ?>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <div class="table-responsive table-card">
                                                <table class="table table-borderless align-middle mb-0">
                                                    <tbody>
                                                        <tr>
                                                            <td class="fw-medium">Solicitud</td>
                                                            <td>#<?= $oferta['IDOfertas'] ?></td>
                                                        </tr>
                                                        
                                                        <tr class="bg-sistema-50 color-white">
                                                            <td class="fw-medium">Requerimiento</td>
                                                            <td><?= $oferta['Requerimiento'] ?></td>
                                                        </tr>
                                                        <tr class="bg-sistema-50 color-white">
                                                            <td class="fw-medium">Motivo</td>
                                                            <td><?= $oferta['MotivoRequerimiento'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Usuario Solicitante</td>
                                                            <td id="t-client"><?= $oferta['MatriculaCreador'].' | '.ucwords(mb_strtolower($oferta['NombresCreador'].' '.$oferta['ApellidosCreador'])) ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Dirección Solicitante</td>
                                                            <td id="t-client"><?= $oferta['DireccionSolicitanteCreador'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Área Solicitante</td>
                                                            <td id="t-client"><?= $oferta['AreaSolicitanteCreador'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Subárea Solicitante</td>
                                                            <td id="t-client"><?= $oferta['SubareaSolicitanteCreador'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Delegación Solicitante</td>
                                                            <td id="t-client"><?= $oferta['DelegacionSolicitanteCreador'] ?> | <?= $oferta['CCSolicitanteCreador'] ?> - <?= $oferta['LNSolicitanteCreador'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Cargp Solicitante</td>
                                                            <td id="t-client"><?= $oferta['CargoSolicitanteCreador'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Fecha de creación</td>
                                                            <td id="c-date"><?= date("d-m-Y H:i:s", strtotime($oferta['FechaCrea'])) ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Cartera </td>
                                                            <td id="c-date"><?= $nombreCartera ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Item </td>
                                                            <td id="c-date"><?= $nombreItem ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Número Contrato </td>
                                                            <td id="c-date"><?= $oferta['NumeroContrato'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Tiempo Oferta </td>
                                                            <td id="c-date"><?= $oferta['TiempoOferta'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Cuota Monitoreo </td>
                                                            <td id="c-date"><?= 'S/'.$oferta['CuotaMonitoreo'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Meses Descuento Oferta </td>
                                                            <td id="c-date"><?= $oferta['MesesTiempoOferta'] > 0 ? $oferta['MesesTiempoOferta'] :'Permanente'?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Descuento </td>
                                                            <td id="c-date"><?= $oferta['TipoDescuento']=='porcentaje'? $oferta['Descuento'].'%':'S/ '.$oferta['Descuento'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Valor Descuento </td>
                                                            <td id="c-date"><?= 'S/ ' . $oferta['ValorDescuento'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Tipo Oferta</td>
                                                            <td id="c-date"><?= $oferta['TipoOferta'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Motivo Estado</td>
                                                            <td id="c-date"><?= $oferta['MotivoEstadoAprobacion'] ?></td>
                                                        </tr>
                                                        <!--<tr class=" $estadosPeticion[$oferta['Estado']]['FONDO'] color-white">-->
                                                        <!--    <td class="fw-medium">Estado</td>-->
                                                        <!--    <td> $estadosPeticion[$oferta['Estado']]['PASADO'] </td>-->
                                                        <!--</tr>-->
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                        <!--end card-body-->
                                    </div>
                                    

                                    <!-- end card -->

                                </div>
                                <!-- end col -->
                            </div>
                            <!-- end row -->
                        </div>

                    </div>
                    <div class="tab-pane fade d-flex justify-content-center" id="oferta-bitacora" role="tabpanel">
                        
                    </div>
                        <!-- end tab pane -->
                </div>
            </div>
            <!-- end col -->
        </div>
        <!-- end row -->
    </div>
    <!-- container-fluid -->
	<span class="respuesta_global"></span>
</div>
<!-- End Page-content -->

    <footer class="footer">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-6">
                    <script>document.write(new Date().getFullYear())</script> © Verisure Peru.
                </div>
                <div class="col-sm-6">
                    <div class="text-sm-end d-none d-sm-block">Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
    $(function () {
        // $('#tblFacturasPendientesAprobarCondonacion').DataTable();
        mostrarAprobadoreGeneral('<?= $oferta['IDOfertas'] ?>');
        mostrarComentariosGeneralOferta('<?= $oferta['IDOfertas'] ?>');
    });
function recargarGeneralOferta(btnGeneral)
{
    let idOferta = $(btnGeneral).data("oferta");
    
    mostrarAprobadoreGeneral(idOferta);
    mostrarComentariosGeneralOferta(idOferta);
}

function mostrarAprobadoreGeneral(idOferta)
{
    var parametros = {
        "idOferta"  : idOferta
	};
    
    $.ajax({        
        url: baseUrl + '/mostrar-aprobador-general',
        type: 'POST',
        data: parametros,
        beforeSend: function() 
        {
            $('#ctnAprobadoresGeneral').html('<div class="d-flex justify-content-center align-items-center"><div class="spinner-border text-primary" role="status" style="width: 3rem; height: 3rem;"><span class="visually-hidden">Loading...</span></div></div>');
        },
        success: function(response) 
        {
            $('#ctnAprobadoresGeneral').empty();
            $('#ctnAprobadoresGeneral').html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
}

// $(document).on('click', '#btnCancelarOferta', function() 
// {
//     // var modal           = $(this).data('bs-target');
//     var idOferta   = $(this).data('oferta');
//     // var idUsuario       = $(this).data('usuario');
//     var tipo = $(this).data('tipo');
//     var estado = $(this).data('estado');
    
//     Swal.fire({
//         title: "Guardar Estatus Oferta",
//         html: "¿Desea cambiar el estado de la Oferta seleccionada a "+tipo.toUpperCase()+" ?<br>Indispensable tener motivo del estado de la Oferta ",
//         icon: 'warning',
//         showCancelButton: true,
//         confirmButtonColor: '#008F39',
//         cancelButtonColor: '#f35d5d',
//         confirmButtonText: 'Confirmar',
//         cancelButtonText: 'Cancelar',
//         input: 'textarea',
//         inputAttributes: {
//             autocapitalize: 'on'
//         },
//         inputValidator: obs => {
//             // // Si el valor es válido, debes regresar undefined. Si no, una cadena
//             if (!obs) {
//                 return "Por favor escribe el motivo";
//             } else {
//                 return undefined;
//             }
//         }
//     }).then((result) => {
//         if (result.isConfirmed) {

//             var motivo = result.value;
            
//             var parametros = {
//                 "motivo"    : motivo,
//                 "estado"      : estado,
//                 "idOferta"  : idOferta,
//     		};

//             $.ajax({        
//                 url: baseUrl + '/cambiar-estado-oferta',
//                 type: "POST",
//                 data: parametros,
//                 // processData: false, // Importante para enviar FormData
//                 // contentType: false, // Importante para enviar FormData
//                 dataType: 'json',
//                 beforeSend: function() 
//                 {
//                     Swal.fire({
//                         html: 'Un momento por favor...',
//                         heightAuto: true,
//                         showConfirmButton: false
//                     });
//                 },
//                 success: function(response) 
//                 {
//                     Swal.close();
                    
//                     $('.respuesta_global').html(response.mensaje);
                    
//                     if(response.result == 1)
//                     {
//                         recargarTablaAprobacionesCondonacion(idCondonacion);
//                     }
//                 }, 
//                 error: function(jqXHR, textStatus, errorThrown)
//                 {
//                     Swal.close();
            
//                     Swal.fire({
//                         title: 'Ha ocurrido un error interno',
//                         text: errorThrown,
//                         icon: 'error',
//                         showCancelButton: false,
//                         confirmButtonColor: '#E4002B',
//                         confirmButtonText: 'Confirmar'
//                     });
//                 }
//             });
//         }
//     });
    
    
// });

function cambiarEstadoOferta(idOferta, tipo, estado) {
    Swal.fire({
        title: "Guardar Estatus Oferta",
        html: "¿Desea cambiar el estado de la Oferta seleccionada a " + tipo.toUpperCase() + " ?<br>Indispensable tener motivo del estado de la Oferta ",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#008F39',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar',
        input: 'textarea',
        inputValidator: obs => obs ? undefined : "Por favor escribe el motivo"
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: baseUrl + '/cambiar-estado-oferta',
                type: "POST",
                data: {
                    motivo: result.value,
                    estado: estado,
                    idOferta: idOferta
                },
                dataType: 'json',
                beforeSend: () => {
                    Swal.fire({ html: 'Un momento por favor...', showConfirmButton: false });
                },
                success: function (response) {
                    Swal.close();
                    $('.respuesta_global').html(response.mensaje);
                    if (response.result == 1 && response.reload) {
                         location.reload(); // << recarga la página desde el backend
                    }
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    Swal.close();
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        confirmButtonColor: '#E4002B'
                    });
                }
            });
        }
    });
}


$(document).on('click', '.cambio-estado-oferta', function() {
    cambiarEstadoOferta($(this).data('oferta'), $(this).data('tipo'), $(this).data('estado'));
});

$(document).on('click', '#btnCancelarOferta', function() {
    cambiarEstadoOferta($(this).data('oferta'), $(this).data('tipo'), $(this).data('estado'));
});

function mostrarComentariosGeneralOferta(idOferta)
{
    var parametros = {
        "idOferta"  : idOferta
	};
    
    $.ajax({        
        url: baseUrl + '/comentarios-oferta',
        type: 'POST',
        data: parametros,
        beforeSend: function() 
        {
            $('#ctnComentariosGeneralOferta').html('<div class="d-flex justify-content-center align-items-center"><div class="spinner-border text-primary" role="status" style="width: 3rem; height: 3rem;"><span class="visually-hidden">Loading...</span></div></div>');
        },
        success: function(response) {
            Swal.close();
            
            let cont = $('#ctnComentariosGeneralOferta');
            
            cont.empty();
            cont.html(response);
            
            if (cont[0].SimpleBar) {
                cont[0].SimpleBar.recalculate();
            } else {
                new SimpleBar(cont[0]);
            }
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
}

/* ------------------------------- */

$(document).on('submit', '.formularioRegistrarComentarioOferta', function() 
{
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var contenedor = $(this).data("contenedor");
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData: false,
        dataType: 'json',
        beforeSend: function() 
        {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
                    
            $('.respuesta_global').html(response.mensaje);
            
            if(response.result == 1)
            {
                mostrarComentariosGeneralOferta(formulario.find('#txtIDOferta_rcomcond').val());
                // $("#txtComentariosFactura_rcomaprcond").val("");
                formulario.find('textarea').val('');
            }
        }, 
        error: function(jqXHR, textStatus, errorThrown)
        {
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */
    flatpickr("#fechaImpactoEditar", {
        locale: "es",
        plugins: [
            new monthSelectPlugin({
                shorthand: false,
                dateFormat: "Y-m-d",      // para guardar
                altFormat: "F Y",         // para mostrar
                theme: "light"
            })
        ],
        altInput: true
    });
/* ------------------------------- */

    function editarDetalleOferta(idOferta, Descuento, cantidadMeses, tipoDescuento, cuotaMonitoreo,tiempoOferta,itemOferta,fechaInicio,tipoOferta,grupoTipoCartera,permanenciaCliente) {
        $('#txtMatriz_detalleOferta').prop('checked', true); // lo activa
        console.log(grupoTipoCartera);
        console.log(cantidadMeses);
        $('#tiempoOfertaEditar').val(tiempoOferta);
        console.log(fechaInicio);
        // Asegúrate de que Flatpickr ya esté inicializado
        let fecha = fechaInicio.trim(); // ejemplo: '2025-07-01'
        if (fecha != "0000-00-00") {
            const picker = document.querySelector("#fechaImpactoEditar")._flatpickr;
            if (picker) {
                picker.setDate(fecha, true); // true = trigger change
            }
        }
        
        let descuentoNumero = parseFloat(Descuento);
        if (isNaN(descuentoNumero)) descuentoNumero = 0;
        console.log("Descuento limpio:", descuentoNumero);


        $('#permanenciaClienteEditarVisible').val(permanenciaCliente);
        $('#permanenciaClienteEditar').val(permanenciaCliente);
        
        $('#tipoDescuentoEditarVisible').val(cuotaMonitoreo);
        $('#tipoDescuentoEditar').val(cuotaMonitoreo);
        
        $('#tipoOfertaEditar').val(tipoOferta);
        selectItemOferta("itemOfertaEditar", grupoTipoCartera, tiempoOferta, itemOferta);
        
        $('#idOfertaEditar').val(idOferta);
        $('#valorDescuentoEditar').val(descuentoNumero);
         
        let selectMeses = $('#cantidadMesesEditar');
        selectMeses.empty().append('<option value="">Seleccione una opción</option>');
        
        if (tiempoOferta === 'Permanente') {
            var rangoMax = 100;
            // Solo mostrar la opción "Permanente"
            selectMeses.append('<option value="-1" selected>Permanente</option>');
        } else {
            if(grupoTipoCartera == 8){
                var i = 1;
                var rangoMax = 15;
            }else if(grupoTipoCartera == 9 || grupoTipoCartera == 10){
                var i = 1;
                var rangoMax = 100;
            }else{
                var i = 3; 
                var rangoMax = 100;
            }
            for (let mes = i; mes <= 12; mes = mes + i) {
                selectMeses.append('<option value="' + mes + '" '+(cantidadMeses==mes?'selected':'')+'>' + mes + ' meses</option>');
            }
        }

        let tipo = tipoDescuento;
        let simbolo = tipo === 'soles' ? 'S/ ' : '%';
    
        $('#lower-value-editar').text(simbolo + '0');
        $('#upper-value-editar').text(simbolo + rangoMax);
        $('#middle-value-editar').text(simbolo + descuentoNumero);
    
        let calculado = tipo === 'porcentaje'
            ? (cuotaMonitoreo * descuentoNumero / 100)
            : (cuotaMonitoreo - descuentoNumero);
    
        calculado = Math.max(0, calculado).toFixed(2); console.log(calculado);
        $('#valorDescuentoCalculadoEditar').val(calculado);
        $('#valorDescuentoCalculadoEditarVisible').val(calculado);
    
        let sliderEditar = document.getElementById('nonlinearEditar');
        if (sliderEditar && sliderEditar.noUiSlider) {
            sliderEditar.noUiSlider.destroy();
        }
        console.log('Valor inicial del slider (descuentoNumero):', descuentoNumero);
        noUiSlider.create(sliderEditar, {
            start: [descuentoNumero],
            connect: [true, false],
            range: {
                min: 0,
                max: rangoMax
            },
            step: tipo === 'soles' ? 1 : 5,
            tooltips: true,
            format: {
                to: function (value) {
                    return parseFloat(value).toFixed(0); // mostrar sin decimales  toFixed(tipo === 'soles' ? 0 : 2);
                },
                from: function (value) {
                    return Number(value);
                }
            }

            // format: {
            //     to: value => value,
            //     from: value => parseFloat(value)
            // }

        });
    
        sliderEditar.noUiSlider.on('update', function (values, handle) {
            const valor = parseFloat(values[handle]); console.log(values[handle]);
            $('#valorDescuentoEditar').val(valor);
            $('#middle-value-editar').text(simbolo + valor);
        
            let nuevoValor = tipo === 'porcentaje'
                ? (cuotaMonitoreo * valor / 100)
                : (cuotaMonitoreo - valor);

            nuevoValor = Math.max(0, nuevoValor).toFixed(2);
            $('#valorDescuentoCalculadoEditar').val(nuevoValor);
            $('#valorDescuentoCalculadoEditarVisible').val(nuevoValor);
        });// // // // 
    
        $('#modalEditarOferta').modal('show');
    }
/* ------------------------------- */    

    $(document).on('change', '#itemOfertaEditar', validarDetalleOfertaPorTiempo);

/* ------------------------------- */

    function validarDetalleOfertaPorTiempo() {
        $('#txtMatriz_detalleOferta').prop('checked', false); // lo desactiva
        let grupoTipoCartera = $("#grupoCartera").val(); // Asegúrate de tener este input hidden si no lo tienes aún
        let tiempoOferta = $("#tiempoOfertaEditar").val();
        let itemOferta = $("#itemOfertaEditar").val();
        let numeroContrato = $("#numeroContrato").val();
    
        if (grupoTipoCartera && tiempoOferta && itemOferta) {
            $.post(baseUrl + "/validar-contrato", {
                grupoTipoCartera: grupoTipoCartera,
                tiempoOferta: tiempoOferta,
                itemOferta: itemOferta,
                nroContrato: numeroContrato
            }, function (response) { console.log(response);
                if (response.status === 'ok') {
                    let tipo = response.tipoDescuento;
                    let valores = response.valorDescuento;
                    let cuotaMonitoreo = response.cuotaMonitoreo;
                    let permanenciaCliente = response.permanenciaCliente;
    
                    $('#tipoDescuentoEditarVisible').val(cuotaMonitoreo);
                    $('#tipoDescuentoEditar').val(cuotaMonitoreo);
    
                    $('#permanenciaClienteEditarVisible').val(permanenciaCliente);
                    $('#permanenciaClienteEditar').val(permanenciaCliente);
    
                    // Limpiar y cargar cantidadMeses
                    // let selectMeses = $('#cantidadMesesEditar');
                    // selectMeses.empty().append('<option value="">Seleccione una opción</option>');
                    // if (Array.isArray(response.cantidadMeses)) {
                    //     response.cantidadMeses.forEach(mes => {
                    //         let label = (mes === 'permanente') ? 'Permanente' : `${mes} meses`;
                    //         selectMeses.append(`<option value="${mes}" selected>${label}</option>`);
                    //     });
                    // }
                    
                    // Limpiar y cargar cantidadMeses
                    let selectMeses = $('#cantidadMesesEditar');
                    selectMeses.empty().append('<option value="">Seleccione una opción</option>');
                    
                    if (tiempoOferta === 'Permanente') {
                        var rangoMax = 100;
                        // Solo mostrar la opción "Permanente"
                        selectMeses.append('<option value="-1" selected>Permanente</option>');
                    } else {
                        
                        if(grupoTipoCartera == 8){
                            var i = 1;
                            // var rangoMax = 15;
                            // var tipo = 'soles';
                        }else if(grupoTipoCartera == 9 || grupoTipoCartera == 10){
                            var i = 1;
                            // var rangoMax = 100;
                            // var tipo = 'soles';
                        }else{
                            var i = 3;
                            // var rangoMax = 100;
                            // var tipo = 'soles';
                        }
                        
                        
                        for (let mes = i; mes <= 12; mes = mes + i) {
                            selectMeses.append('<option value="' + mes + '" '+(response.cantidadMeses==mes?'selected':'')+'>' + mes + ' meses</option>');
                        }
                        // if (Array.isArray(response.cantidadMeses)) {
                        //     response.cantidadMeses.forEach(mes => {
                        //         let isPermanente = mes === 'permanente' || mes === -1;
                        //         let label = isPermanente ? 'Permanente' : `${mes} meses`;
                        //         selectMeses.append(`<option value="${mes}">${label}</option>`);
                        //     });
                        // } else {
                        //     let isPermanente = cantidadMeses === -1 ;
                        //     let label = isPermanente ? 'Permanente' : `${cantidadMeses} meses`;
                        //     selectMeses.append(`<option value="${cantidadMeses}" selected>${label}</option>`);
                        // }
                    }
    
                    // Slider
                    let minValor = Math.min(...valores);
                    let maxValor = Math.max(...valores);
                    let startValor = valores[0];
                    let simbolo = tipo === 'soles' ? 'S/ ' : '%';
    
                    let slider = document.getElementById('nonlinearEditar');
                    if (slider.noUiSlider) slider.noUiSlider.destroy();
    
                    noUiSlider.create(slider, {
                        start: [startValor],
                        connect: [true, false],
                        range: {
                            min: minValor,
                            max: maxValor 
                        },
                        step: tipo === 'soles' ? 1 : 1,
                        tooltips: true,
                        format: {
                            to: value => simbolo + Math.round(value),
                            from: value => Number(value.replace(/[^0-9.-]+/g, ""))
                        }
                    });
    
                    $('#lower-value-editar').text(simbolo + minValor);
                    $('#upper-value-editar').text(simbolo + maxValor);
                    $('#middle-value-editar').text(simbolo + startValor);
    
                    slider.noUiSlider.on('update', function (values, handle) {
                        const valor = parseFloat(values[handle].replace(/[^0-9.]/g, ''));
                        $('#valorDescuentoEditar').val(valor);
                        $('#middle-value-editar').text(values[handle]);
    
                        let nuevoValor = tipo === 'porcentaje'
                            ? cuotaMonitoreo - (cuotaMonitoreo * valor / 100)
                            : (cuotaMonitoreo - valor);
    
                        nuevoValor = Math.max(0, nuevoValor).toFixed(2);
                        $('#valorDescuentoCalculadoEditar').val(nuevoValor);
                        $('#valorDescuentoCalculadoEditarVisible').val(nuevoValor);
                    });
                }
            }, 'json');
        }
    }
    
/* ------------------------------ */

    $('#txtMatriz_detalleOferta').change(function() {
      this.checked ? setValoresMatrizExterna() : validarDetalleOfertaPorTiempo();
    });

    
    function setValoresMatrizExterna() {
      const gc = parseInt($("#grupoCartera").val()); // grupo cartera
      let tipo = $("#tipoOfertaEditar").val(); // valor original
    
      // Reglas según grupo cartera
      if ([8, 9, 10].includes(gc)) {
        tipo = 'soles';
      } else if (gc === 2) {
        tipo = tipo; // Se mantiene el valor original
      }
    
      const symbol = tipo === 'soles' ? 'S/ ' : '%';
      const tiempoOferta = $("#tiempoOfertaEditar").val(); 
      const mesesRange = ([8, 9, 10].includes(gc)) ? 1 : 3;
      const step = ([8, 9, 10].includes(gc)) ? 1 : (tipo === 'soles' ? 10 : 5);
    
      // Arma el combo
      const sel = $('#cantidadMesesEditar').empty().append('<option value="">Seleccione una opción</option>');
      if (tiempoOferta === 'Permanente') {
        sel.append('<option value="-1">Permanente</option>');
      } else {
        for (let m = mesesRange; m <= 12; m += mesesRange) {
          sel.append(`<option value="${m}">${m} meses</option>`);
        }
      }
    
      // Slider
      const sliderEl = document.getElementById('nonlinearEditar');
      const slider = initSlider(sliderEl, {
        min: 0, max: 100, step, start: 0, simbolo: symbol
      });
    
      // Resetea visuales
      $('#lower-value-editar').text(symbol + '0');
      $('#upper-value-editar').text(symbol + '100');
      $('#middle-value-editar').text(symbol + '0');
      $('#valorDescuentoEditar').val(0);
      $('#valorDescuentoCalculadoEditar').val('');
      $('#valorDescuentoCalculadoEditarVisible').val('');
    
      slider.on('update', function (values, handle) {
        const raw = Number(values[handle].replace(/[^0-9.-]/g, ''));
        $('#middle-value-editar').text(values[handle]);
        $('#valorDescuentoEditar').val(raw);
    
        const cuota = parseFloat($('#tipoDescuentoEditar').val()) || 0;
        const calc = tipo === 'porcentaje'
          ? cuota - cuota * raw / 100
          : cuota - raw;
        const final = Math.max(0, calc).toFixed(2);
        $('#valorDescuentoCalculadoEditar, #valorDescuentoCalculadoEditarVisible').val(final);
      });
    }
    

    
/* ------------------------------- */
    function initSlider(element, { min, max, step, start, simbolo }) {
      if (element.noUiSlider) element.noUiSlider.destroy();
      noUiSlider.create(element, {
        start: [start],
        connect: [true, false],
        range: { min, max },
        step,
        tooltips: true,
        format: {
          to: v => simbolo + Math.round(v),
          from: v => Number(v.replace(/[^0-9.-]+/g, "")),
        }
      });
      return element.noUiSlider;
    }


/* ------------------------------- */


    $(document).on('click', '#btnGuardarEdicionOferta', function () {
        const idOferta = $(this).data('id');
        const matriz = $('#txtMatriz_detalleOferta').is(':checked') ? 1 : 0;
    
        const data = {
            idOferta: idOferta,
            valorDescuento: $('#valorDescuentoEditar').val(),
            valorDescuentoCalculado: $('#valorDescuentoCalculadoEditar').val(),
            cantidadMeses: $('#cantidadMesesEditar').val(),
            tiempoOferta: $('#tiempoOfertaEditar').val(),
            itemOferta: $('#itemOfertaEditar').val(),
            fechainicio: $('#fechaImpactoEditar').val(),
            tipoOferta: $('#tipoOfertaEditar').val(),
            matriz: matriz
        };
    
        // Validación básica
        if (!data.valorDescuento || !data.cantidadMeses) {
            Swal.fire('Faltan campos', 'Completa el descuento y los meses.', 'warning');
            return;
        }
    
        $.ajax({
            url: baseUrl + '/actualizar-detalle-oferta',
            type: 'POST',
            dataType: 'json',
            data: data,
            beforeSend: function () {
                Swal.fire({
                    title: 'Actualizando...',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });
            },
            success: function (response) {
                Swal.close();
    
                if (response.result === 1 && response.reload) {
                    Swal.fire('Actualizado', response.mensaje, 'success').then(() => {
                        $('#modalEditarOferta').modal('hide');
                        // mostrarAprobadoreGeneral(idOferta);
                        location.reload(); // Evítalo si puedes actualizar vía DOM
                    });
                } else {
                    Swal.fire('Error', response.mensaje || 'No se pudo actualizar.', 'error');
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                Swal.fire('Error interno', errorThrown || 'Error desconocido', 'error');
            }
        });
    });


/* ------------------------------- */

function recargarBitacoraOferta(btnBitacora)
{
    let idOferta   = $(btnBitacora).data("oferta");
    let contenedor      = $(btnBitacora).attr("href");
    
    var parametros = {
        "idOferta"  : idOferta
	};
	
    $.ajax({        
        url: baseUrl + '/recargar-bitacora-oferta',
        type: "POST",
        data: parametros,
        beforeSend: function() 
        {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
            
            $(contenedor).html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown)
        {
            Swal.close();
    
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
}



/* ------------------------------- */

</script>
<?php $this->endSection(); ?>

<!-- Modal Editar Detalle Oferta -->
<div class="modal fade" id="modalEditarOferta" tabindex="-1" aria-labelledby="modalEditarOfertaLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
    
      <div class="modal-header">
        <h5 class="modal-title" id="modalEditarOfertaLabel">Editar Detalle de Oferta</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        <input type="hidden" id="grupoCartera" value="<?= $oferta['IDGrupoCarteraCliente'] ?>">
        <input type="hidden" id="numeroContrato" value="<?= $oferta['NumeroContrato'] ?>">
      </div>

      <div class="modal-body">
        <form id="formEditarOferta">
            <div class="row">
                <input type="hidden" id="idOfertaEditar">
                
                <div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">
                  <label for="tiempoOfertaEditar" class="form-label">Tiempo de Oferta</label>
                  <select id="tiempoOfertaEditar" class="form-select">
                      <option value="">Seleccione una opción</option>
                      <option value="Temporal">Temporal</option>
                      <option value="Permanente">Permanente</option>
                  </select>
                </div>
                
                <div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">
                  <label for="itemOfertaEditar" class="form-label">Item Oferta</label>
                  <select id="itemOfertaEditar" class="form-select">
                      <!-- Cargarás dinámicamente -->
                  </select>
                </div>
                
                <div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">
                  <label for="fechaImpactoEditar" class="form-label">Mes de Impacto</label>
                  <input type="text" class="form-control" id="fechaImpactoEditar">
                </div>
                
                <div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">
                  <label for="tipoOfertaEditar" class="form-label">Tipo de Oferta</label>
                  <select id="tipoOfertaEditar" class="form-select">
                      <option value="">Seleccione una opción</option>
                      <option value="nuevaOferta">Nueva Oferta</option>
                      <option value="remplazoOferta">Reemplazo</option>
                  </select>
                </div>
                
                <div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">
    				<div>
    					<label class="form-label" >Cuota Monitoreo</label>
    					<input type="text" class="form-control" id="tipoDescuentoEditarVisible" disabled >
    					<input type="hidden" class="form-control" id="tipoDescuentoEditar" name="tipoDescuentoEditar">
    				</div>
    			</div>
    
                <div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">
    				<div>
    					<label for="valorDescuento" class="form-label" >Valor con descuento</label>
    					    <div class="input-group">
                              <span class="input-group-text">S/</span>
                              <input type="text" class="form-control" id="valorDescuentoCalculadoEditarVisible" disabled>
                              <input type="hidden" class="form-control" id="valorDescuentoCalculadoEditar" name="valorDescuentoCalculadoEditar">
                            </div>
    				</div>
    			</div>
    			
                <div class="mb-3">
                    <label for="valorDescuentoEditar" class="form-label">Descuento</label>
                    <div id="nonlinearEditar"></div>
                    <div class="d-flex justify-content-between">
                        <span id="lower-value-editar">0</span>
                        <span id="middle-value-editar">0</span>
                        <span id="upper-value-editar">100</span>
                    </div>
                    <input type="hidden" id="valorDescuentoEditar">
                </div>
                
                <div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">
                    <label for="cantidadMesesEditar" class="form-label">Cantidad de Meses</label>
                    <select id="cantidadMesesEditar" class="form-select">
                        
                    </select>
                </div>

                <div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">
    				<div>
    					<label class="form-label" >Permanencia Cliente (meses)</label>
    					<input type="text" class="form-control" id="permanenciaClienteEditarVisible" disabled >
    					<input type="hidden" class="form-control" id="permanenciaClienteEditar" name="permanenciaClienteEditar" >
    				</div>
    			</div>
    			
    			<div class="col-xxl-6 col-md-12 col-12 px-1 mb-0">
                    <div class="border-sistema-2px p-1 d-flex justify-content-center align-items-center" style="border-radius: 15px;">
                        <div class="text-center">
                            <div class="form-check form-switch form-switch-secondary m-0">
                                <input class="form-check-input" type="checkbox" role="switch" id="txtMatriz_detalleOferta" name="txtMatriz_detalleOferta" value="1">
                                <label class="form-check-label ms-2" for="txtMatriz_detalleOferta">Excepción</label>
                            </div>
                        </div>
                    </div>
                </div>
    			
            </div>
        </form>
      </div>

      <div class="modal-footer">
        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-success" id="btnGuardarEdicionOferta" data-id="<?= $oferta['IDOfertas'] ?>">Guardar Cambios</button>
      </div>
    </div>
  </div>
</div>


<?php $this->endSection(); ?>