<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card mt-n4 mx-n4">
                        <div class="bg-sistema-50">
                            <div class="card-body pb-0 px-4">
                                <div class="row mb-3">
                                    <div class="col-md">
                                        <div class="row align-items-center g-3">
                                            <div class="col-md-auto">
                                                <div class="avatar-md">
                                                    <div class="avatar-title bg-white rounded-circle">
                                                        <img src="<?= $baseUrl ?>/<?= $basePublic ?>/images/favicon.ico" alt="" class="avatar-xs">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md">
                                                <div>
                                                    <h4 class="fw-bold">#<?= $condonacion['IDCondonacion'] ?> - <?= ucwords(mb_strtolower($condonacion['TipoRequerimiento']))." | ".ucwords(mb_strtolower($condonacion['Requerimiento']))." | ".ucwords(mb_strtolower($condonacion['MotivoRequerimiento'])) ?></h4>
                                                    <div class="hstack gap-3 flex-wrap">
                                                        <div><i class="mdi mdi-account align-bottom me-1"></i><?= ucwords(mb_strtolower($condonacion['Nombres'].' '.$condonacion['Apellidos'])) ?></div>
                                                        <div class="vr"></div>
                                                        <div>Fecha de Creación: <span class="fw-medium"><?= date("d-m-Y H:i:s", strtotime($condonacion['FechaCrea'])) ?></span></div>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php
                                            
                                            $totalFacturas = $cantidadEstadoFactura['APRO']+$cantidadEstadoFactura['RECH']+$cantidadEstadoFactura['PEND'];
                                            $totalApro = $cantidadEstadoFactura['APRO'];
                                            
                                            $mostrarBoton = ($condonacion['IDPeticion']!= '' && $condonacion['IDPeticion']!= null) || $totalApro < $totalFacturas ? 'd-none' : '';
                                            ?>
                                            <div class="col-md-auto mt-md-0 mt-4 d-flex justify-content-end align-items-center">
                                                <div class="hstack gap-1 flex-wrap">
                                                    <button type="button" class="btn bg-sistema px-2 py-1 <?= $mostrarBoton ?>" data-condonacion="<?= $condonacion['IDCondonacion'] ?>" id="btnSolicitarPeticionCondonacion" data-tooltip="tooltip" title="Solicitar petición de condonación a Medios de pago">
                                                        <i class="mdi mdi-send" style="font-size: 24px; color: #FFF"></i>
                                                    </button>
                                                    <a href="<?= $baseUrl.'/'.$previo ?>" class="btn btn-danger px-2 py-1" data-tooltip="tooltip" title="Volver">
                                                        <i class="mdi mdi-arrow-left-circle" style="font-size: 24px; color: #FFF"></i>
                                                    </a>
                                                </div>
                                            </div>
 
                                        </div>
                                    </div>
                                </div>

                                <ul class="nav nav-tabs-custom border-bottom-0" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link fw-semibold active" data-bs-toggle="tab" href="#condonacion-general" role="tab" aria-selected="true" data-condonacion="<?= $condonacion['IDCondonacion'] ?>" onclick="recargarGeneralCondonacion(this); mostrarBotonSolicitarPeticionCondonacion('<?= $condonacion['IDCondonacion'] ?>');">
                                            General
                                        </a>
                                    </li>
                                    <!--<li class="nav-item" role="presentation">-->
                                    <!--    <a class="nav-link fw-semibold" data-bs-toggle="tab" href="#condonacion-facturas" role="tab" aria-selected="false" tabindex="-1">-->
                                    <!--        Facturas-->
                                    <!--    </a>-->
                                    <!--</li>-->
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link fw-semibold" data-bs-toggle="tab" href="#condonacion-facturas-gestor" role="tab" aria-selected="false" tabindex="-1" data-condonacion="<?= $condonacion['IDCondonacion'] ?>" onclick="recargarFacturasGestorCondonacion(this); mostrarBotonSolicitarPeticionCondonacion('<?= $condonacion['IDCondonacion'] ?>');">
                                            Facturas
                                        </a>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link fw-semibold" data-bs-toggle="tab" href="#condonacion-aprobaciones" role="tab" aria-selected="false" tabindex="-1" data-condonacion="<?= $condonacion['IDCondonacion'] ?>" onclick="recargarAprobacionesCondonacion(this); mostrarBotonSolicitarPeticionCondonacion('<?= $condonacion['IDCondonacion'] ?>');">
                                            Aprobaciones
                                        </a>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link fw-semibold" data-bs-toggle="tab" href="#condonacion-bitacora" role="tab" aria-selected="false" tabindex="-1" data-condonacion="<?= $condonacion['IDCondonacion'] ?>" onclick="recargarBitacoraCondonacion(this); mostrarBotonSolicitarPeticionCondonacion('<?= $condonacion['IDCondonacion'] ?>');">
                                            Bitacora
                                        </a>
                                    </li>
                                </ul>
                            </div>
                            <!-- end card body -->
                        </div>
                    </div>
                    <!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="tab-content text-muted">
                        <div class="tab-pane fade active show" id="condonacion-general" role="tabpanel">
                            <div class="row">
                                <div class="col-xl-8 col-lg-6">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="text-muted">
                                                <h6 class="mb-3 fw-semibold text-uppercase">Observación</h6>
                                                <p><?= $condonacion['Observacion'] ?></p>

                                                <div class="pt-3 border-top border-top-dashed my-1">
                                                    <div class="row">
                                                        <div class="col-xl-3 col-lg-6 col-12 my-2">
                                                            <div class="card m-0" style="box-shadow: 2px 2px #212529;">
                                                                <div class="card-body d-flex gap-3 align-items-center">
                                                                    <div class="avatar-sm">
                                                                        <div class="avatar-title border bg-dark border-dark border-opacity-25 rounded-2 fs-17">
                                                                            <i class="mdi mdi-cancel align-bottom" style="font-size: 24px; color: #FFF;"></i>
                                                                        </div>
                                                                    </div>
                                                                    <div class="flex-grow-1">
                                                                        <h5 class="fs-15"><?= $cantidadEstadoFactura['CANC'] ?></h5>
                                                                        <p class="mb-0 text-muted">Cancelados</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div><!--end col-->
                                                        <div class="col-xl-3 col-lg-6 col-12 my-2">
                                                            <div class="card m-0" style="box-shadow: 2px 2px #F06548;">
                                                                <div class="card-body d-flex gap-3 align-items-center">
                                                                    <div class="avatar-sm">
                                                                        <div class="avatar-title border bg-danger border-danger border-opacity-25 rounded-2 fs-17">
                                                                            <i class="mdi mdi-close-circle align-bottom" style="font-size: 24px; color: #FFF;"></i>
                                                                        </div>
                                                                    </div>
                                                                    <div class="flex-grow-1">
                                                                        <h5 class="fs-15"><?= $cantidadEstadoFactura['RECH'] ?></h5>
                                                                        <p class="mb-0 text-muted">Rechazados</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div><!--end col-->
                                                        <div class="col-xl-3 col-lg-6 col-12 my-2">
                                                            <div class="card m-0" style="box-shadow: 2px 2px #CDCDCD;">
                                                                <div class="card-body d-flex gap-3 align-items-center">
                                                                    <div class="avatar-sm">
                                                                        <div class="avatar-title border bg-gris-claro border-opacity-25 rounded-2 fs-17">
                                                                            <i class="mdi mdi-timer-sand align-bottom" style="font-size: 24px; color: #FFF;"></i>
                                                                        </div>
                                                                    </div>
                                                                    <div class="flex-grow-1">
                                                                        <h5 class="fs-15"><?= $cantidadEstadoFactura['PEND'] ?></h5>
                                                                        <p class="mb-0 text-muted">Pendientes</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div><!--end col-->
                                                        <div class="col-xl-3 col-lg-6 col-12 my-2">
                                                            <div class="card m-0" style="box-shadow: 2px 2px #45CB85;">
                                                                <div class="card-body d-flex gap-3 align-items-center">
                                                                    <div class="avatar-sm">
                                                                        <div class="avatar-title border bg-success border-success border-opacity-25 rounded-2 fs-17">
                                                                            <i class="mdi mdi-check-circle align-bottom" style="font-size: 24px; color: #FFF;"></i>
                                                                        </div>
                                                                    </div>
                                                                    <div class="flex-grow-1">
                                                                        <h5 class="fs-15"><?= $cantidadEstadoFactura['APRO'] ?></h5>
                                                                        <p class="mb-0 text-muted">Aprobados</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div><!--end col-->
                                                    </div>
                                                </div>
                                                <?php
                                                if(!empty($listadoAdjuntos))
                                                {
                                                ?>
                                                <div class="pt-3 border-top border-top-dashed mt-4">
                                                    <h6 class="mb-3 fw-semibold text-uppercase">Adjuntos</h6>
                                                    <div class="row g-3">
                                                        <?php
                                                        foreach($listadoAdjuntos as $adjuntos)
                                                        {
                                                        ?>
                                                        <div class="col-xxl-4 col-lg-6">
                                                            <div class="border rounded border-dashed p-2">
                                                                <div class="d-flex align-items-center">
                                                                    <div class="flex-shrink-0 me-3">
                                                                        <div class="avatar-sm">
                                                                            <div class="avatar-title bg-light text-secondary rounded fs-24">
                                                                                <i class="mdi mdi-paperclip"></i>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="flex-grow-1 overflow-hidden">
                                                                        <h5 class="fs-13 mb-1"><a href="#" class="text-body text-truncate d-block"><?= $adjuntos['Nombre'] ?></a></h5>
                                                                        <div><?= $adjuntos['Extension'] ?></div>
                                                                    </div>
                                                                    <div class="flex-shrink-0 ms-2">
                                                                        <div class="d-flex gap-1">
                                                                            <a class="btn btn-icon text-muted btn-sm fs-18" href="<?= $baseUrl ?>/<?= $baseDinamic ?>/files/Condonaciones/<?= date("Y", strtotime($condonacion['FechaCrea'])) ?>/<?= date("m", strtotime($condonacion['FechaCrea'])) ?>/<?= $condonacion['IDCondonacion'] ?>/Adjuntos/<?= $adjuntos['IDCondonacion'] ?>-<?= $adjuntos['IDAdjuntoCondonacion'] ?>.<?= $adjuntos['Extension'] ?>" download="<?= $adjuntos['Nombre'].".".$adjuntos['Extension'] ?>">
                                                                                <i class="ri-download-2-line"></i>
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- end col -->
                                                        <?php
                                                        }
                                                        ?>
                                                    </div>
                                                    <!-- end row -->
                                                </div>
                                                <?php
                                                }
                                                ?>
                                            </div>
                                        </div>
                                        <!-- end card body -->
                                    </div>
                                    <!-- end card -->

                                    <div class="card">
                                        <div class="card-header align-items-center d-flex">
                                            <h4 class="card-title mb-0 flex-grow-1">Comentarios de Condonación</h4>
                                            <div class="flex-shrink-0">
                                                <button type="button" class="btn bg-sistema px-2 py-1" data-tooltip="tooltip" title="Actualizar Comentarios de Condonación" onclick="return mostrarComentariosGeneralCondonacion('<?= $condonacion['IDCondonacion'] ?>')">
                                                    <i class="mdi mdi-refresh" style="font-size: 18px; color: #FFF"></i>
                                                </button>
                                            </div>
                                        </div><!-- end card header -->

                                        <div class="card-body">
                                            <div class="col-12" data-simplebar id="ctnComentariosGeneralCondonacion" style="height: 250px;">
                                            </div>
                                            <hr>
                                            <div class="col-12 p-3 m-0">
                                                <form class="formularioRegistrarComentarioCondonacion comentario m-0" autocomplete="off" action="<?= $baseUrl ?>/registrar-comentario-condonacion" method="POST" data-contenedor="ctnComentariosGeneralCondonacion" >
                                			        <div class="row col-12 m-0 p-0 d-flex">
                                			            <div class="panel m-0">
                                                            <div class="panel-heading">
                                                                <h4>Registrar Comentario</h4>
                                                            </div>
                                                            <div class="panel-content">
                                                                <div class="row">
                                                                    <div class="col-10">
                                                                        <input type="hidden" id="txtIDCondonacion_rcomcond" name="txtIDCondonacion_rcomcond" value="<?= $condonacion['IDCondonacion'] ?>">
                                            							<textarea class="form-control" id="txtComentariosCondonacion_rcomcond" name="txtComentariosCondonacion_rcomcond" rows="4" placeholder="Comentarios...."></textarea>
                                            						</div>
                                            						<div class="col-2 d-flex justify-content-center align-items-center">
                                            						    <button type="submit" class="btn bg-sistema color-white p-2 px-3 mx-1">
                                                                            <i class="mdi mdi-content-save" style="font-size: 22px;"></i>
                                                                        </button>
                                            						</div>
                                                                </div>
                                                            </div>
                                                        </div>
                                				    </div>
                                			    </form>
                                			</div>
                                        </div>
                                        <!-- end card body -->
                                    </div>
                                    <!-- end card -->
                                </div>
                                <!-- ene col -->
                                <div class="col-xl-4 col-lg-6">
                                    <div class="card">
                                        <div class="card-header">
                                            <h5 class="card-title mb-0">Información de Solicitud</h5>
                                        </div>
                                        <div class="card-body">
                                            <div class="table-responsive table-card">
                                                <table class="table table-borderless align-middle mb-0">
                                                    <tbody>
                                                        <tr>
                                                            <td class="fw-medium">Solicitud</td>
                                                            <td>#<?= $condonacion['IDCondonacion'] ?></td>
                                                        </tr>
                                                        
                                                        <tr class="bg-sistema-50 color-white">
                                                            <td class="fw-medium">Requerimiento</td>
                                                            <td><?= $condonacion['Requerimiento'] ?></td>
                                                        </tr>
                                                        <tr class="bg-sistema-50 color-white">
                                                            <td class="fw-medium">Motivo</td>
                                                            <td><?= $condonacion['MotivoRequerimiento'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Usuario Solicitante</td>
                                                            <td id="t-client"><?= $condonacion['Matricula'].' | '.ucwords(mb_strtolower($condonacion['Nombres'].' '.$condonacion['Apellidos'])) ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Dirección Solicitante</td>
                                                            <td id="t-client"><?= $condonacion['DireccionSolicitante'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Área Solicitante</td>
                                                            <td id="t-client"><?= $condonacion['AreaSolicitante'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Subárea Solicitante</td>
                                                            <td id="t-client"><?= $condonacion['SubareaSolicitante'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Delegación Solicitante</td>
                                                            <td id="t-client"><?= $condonacion['DelegacionSolicitante'] ?> | <?= $condonacion['CCSolicitante'] ?> - <?= $condonacion['LNSolicitante'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Cargp Solicitante</td>
                                                            <td id="t-client"><?= $condonacion['CargoSolicitante'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Fecha de creación</td>
                                                            <td id="c-date"><?= date("d-m-Y H:i:s", strtotime($condonacion['FechaCrea'])) ?></td>
                                                        </tr>
                                                        <!--<tr class=" $estadosPeticion[$condonacion['Estado']]['FONDO'] color-white">-->
                                                        <!--    <td class="fw-medium">Estado</td>-->
                                                        <!--    <td> $estadosPeticion[$condonacion['Estado']]['PASADO'] </td>-->
                                                        <!--</tr>-->
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                        <!--end card-body-->
                                    </div>
                                    <div class="card">
                                        <div class="card-header align-items-center d-flex border-bottom-dashed">
                                            <h4 class="card-title mb-0 flex-grow-1">Aprobadores</h4>
                                            <div class="flex-shrink-0">
                                                <button type="button" class="btn bg-sistema px-2 py-1" data-tooltip="tooltip" title="Actualizar Aprobadores" onclick="return mostrarAprobadoresGeneral('<?= $condonacion['IDCondonacion'] ?>')">
                                                    <i class="mdi mdi-refresh" style="font-size: 18px; color: #FFF"></i>
                                                </button>
                                            </div>
                                        </div>

                                        <div class="card-body">
                                            <div class="vstack gap-3" id="ctnAprobadoresGeneral">
                                                
                                            </div>
                                        </div>
                                        <!-- end card body -->
                                    </div>
                                    <!-- end card -->

                                </div>
                                <!-- end col -->
                            </div>
                            <!-- end row -->
                        </div>
                        <div class="tab-pane fade" id="condonacion-facturas" role="tabpanel">
                            <?php
                            // Inicializa un arreglo agrupado por estado
                            $facturasPorEstado = [
                                'APRO' => [],
                                'RECH' => [],
                                'CANC' => [],
                                'PEND' => [],
                            ];
                            
                            // Agrupa los registros según su estado
                            foreach ($listadoFacturas as $registro)
                            {
                                $estado = $registro['Estado'];
                                if (array_key_exists($estado, $facturasPorEstado))
                                {
                                    $facturasPorEstado[$estado][] = $registro;
                                }
                            }
                            
                            // var_dump($aprobadoresFactura);
                            
                            $aprobadoresPorFactura = [];
                            
                            //Agrupa los registros según su factura
                            foreach ($aprobadoresFactura as $registro) 
                            {
                                $idFactura = $registro['IDFactura'];
                                $aprobadoresPorFactura[$idFactura][] = $registro;
                            }
                            
                            ?>
                            <div class="card">
                                <div class="card-header d-flex align-items-center">
                                    <h5 class="card-title mb-0 flex-grow-1">Facturas</h5>
                                    <div class="d-flex">
                                        <button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white" data-bs-target="#aprobacionMasivaCondonacion" data-condonacion="<?= $condonacion['IDCondonacion'] ?>" id="btnAprobacionMasivaCondonacion">
        									<i class="mdi mdi-plus-circle"></i> Aprobaciones Masivas
        								</button>
                                    </div>
                                    <!--end row-->
                                </div>
                            </div>
                            <div class="row row-cols-xxl-4 row-cols-lg-2 row-cols-md-1 row-cols-1">
                                <div class="col">
                                    <div class="card">
                                        <a class="card-body bg-dark" data-bs-toggle="collapse" href="#facturasCanceladas" role="button" aria-expanded="true" aria-controls="facturasCanceladas">
                                            <h5 class="card-title text-uppercase fw-semibold mb-1 fs-15 text-white">Facturas Canceladas</h5>
                                            <p class="text-white mb-0">Total: <span class="fw-medium"><?= $cantidadEstadoFactura['CANC'] ?> Factura(s)</span></p>
                                        </a>
                                    </div>
                                    <!--end card-->
                                    <div class="collapse" id="facturasCanceladas" style="">
                                        <?php
                                        if(!empty($facturasPorEstado['CANC']))
                                        {
                                            foreach($facturasPorEstado['CANC'] as $canceladas)
                                            {
                                            ?>
                                            <div class="card mb-1">
                                                <div class="card-body">
                                                    <a class="d-flex align-items-center" data-bs-toggle="collapse" href="#IDFact<?= $canceladas['IDFacturaCondonacion'] ?>" role="button" aria-expanded="false" aria-controls="IDFact<?= $canceladas['IDFacturaCondonacion'] ?>">
                                                        <div class="flex-shrink-0">
                                                            <div class="avatar-md rounded">
                                                                <div class="avatar-title border bg-light text-primary rounded text-uppercase fs-24"><?= $canceladas['TipoFactura'] ?></div>
                                                            </div>
                                                        </div>
                                                        <div class="flex-grow-1 ms-3">
                                                            <!--<div class="my-1">-->
                                                            <!--    <h5 class="fs-16 m-0">Nro Contrato: </h5>-->
                                                            <!--</div>-->
                                                            <p class="text-muted my-1"><?= $canceladas['FacturaExterna'] ?></p>
                                                            <div class="d-flex flex-wrap gap-2 align-items-center my-1">
                                                                <?= $canceladas['FacturaInterna'] ?>
                                                            </div>
                                                            <div class="d-flex gap-4 my-1 text-muted justify-content-start align-content-center">
                                                                <div>
                                                                    <div class="badge text-bg-danger">S/ <?= number_format(round($canceladas['DeudaTotal'], 2), 2, '.', '') ?></div>
                                                                </div>
                                                                <div>
                                                                    <i class="mdi mdi-slash-forward text-primary me-1 align-bottom"></i>
                                                                    <div class="badge text-bg-success">S/ <?= number_format(round($canceladas['ImporteCondonar'], 2), 2, '.', '') ?></div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                                <div class="collapse border-top border-top-dashed" id="IDFact<?= $canceladas['IDFacturaCondonacion'] ?>">
                                                    <div class="card-body">
                                                        <h6 class="fs-14 mb-1">Nesta Technologies <small class="badge bg-danger-subtle text-danger">4 Days</small></h6>
                                                        <p class="text-muted">As a company grows however, you find it's not as easy to shout across</p>
                                                        <ul class="list-unstyled vstack gap-2 mb-0">
                                                            <li>
                                                                <div class="d-flex">
                                                                    <div class="flex-shrink-0 avatar-xxs text-muted">
                                                                        <i class="ri-question-answer-line"></i>
                                                                    </div>
                                                                    <div class="flex-grow-1">
                                                                        <h6 class="mb-0">Meeting with Thomas</h6>
                                                                        <small class="text-muted">Yesterday at 9:12AM</small>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="d-flex">
                                                                    <div class="flex-shrink-0 avatar-xxs text-muted">
                                                                        <i class="ri-mac-line"></i>
                                                                    </div>
                                                                    <div class="flex-grow-1">
                                                                        <h6 class="mb-0">Product Demo</h6>
                                                                        <small class="text-muted">Monday at 04:41PM</small>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="d-flex">
                                                                    <div class="flex-shrink-0 avatar-xxs text-muted">
                                                                        <i class="ri-earth-line"></i>
                                                                    </div>
                                                                    <div class="flex-grow-1">
                                                                        <h6 class="mb-0">Marketing Team Meeting</h6>
                                                                        <small class="text-muted">Monday at 04:41PM</small>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                    <div class="card-footer hstack gap-2">
                                                        <button class="btn btn-warning btn-sm w-100"><i class="ri-phone-line align-bottom me-1"></i> Call</button>
                                                        <button class="btn btn-info btn-sm w-100"><i class="ri-question-answer-line align-bottom me-1"></i> Message</button>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php
                                            }
                                        }
                                        else
                                        {
                                        ?>
                                        <div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                            	            <div class="col-xxl-10 col-md-12 col-12 ">
                                    	        <div class="alert alert-dark alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                                                    <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRÓ FACTURAS</strong> - No hay facturas canceladas.
                                                </div>
                                            </div>
                                    	</div>
                                        <?php
                                        }
                                        ?>
                                        <!--end card-->
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col">
                                    <div class="card">
                                        <a class="card-body bg-danger" data-bs-toggle="collapse" href="#leadDiscovered" role="button" aria-expanded="true" aria-controls="leadDiscovered">
                                            <h5 class="card-title text-uppercase fw-semibold mb-1 fs-15 text-white">Facturas Rechazadas</h5>
                                            <p class="text-white mb-0">Total: <span class="fw-medium"><?= $cantidadEstadoFactura['RECH'] ?> Factura(s)</span></p>
                                        </a>
                                    </div>
                                    <!--end card-->
                                    <div class="collapse" id="leadDiscovered" style="">
                                        <?php
                                        if(!empty($facturasPorEstado['RECH']))
                                        {
                                            foreach($facturasPorEstado['RECH'] as $rechazados)
                                            {
                                            ?>
                                            <div class="card mb-1">
                                                <div class="card-body">
                                                    <a class="d-flex align-items-center" data-bs-toggle="collapse" href="#IDFact<?= $rechazados['IDFacturaCondonacion'] ?>" role="button" aria-expanded="false" aria-controls="IDFact<?= $rechazados['IDFacturaCondonacion'] ?>">
                                                        <div class="flex-shrink-0">
                                                            <div class="avatar-md rounded">
                                                                <div class="avatar-title border bg-light text-primary rounded text-uppercase fs-24"><?= $canceladas['TipoFactura'] ?></div>
                                                            </div>
                                                        </div>
                                                        <div class="flex-grow-1 ms-3">
                                                            <!--<div class="my-1">-->
                                                            <!--    <h5 class="fs-16 m-0">Nro Contrato: </h5>-->
                                                            <!--</div>-->
                                                            <p class="text-muted my-1"><?= $rechazados['FacturaExterna'] ?></p>
                                                            <div class="d-flex flex-wrap gap-2 align-items-center my-1">
                                                                <?= $rechazados['FacturaInterna'] ?>
                                                            </div>
                                                            <div class="d-flex gap-4 my-1 text-muted justify-content-start align-content-center">
                                                                <div>
                                                                    <div class="badge text-bg-danger">S/ <?= number_format(round($rechazados['DeudaTotal'], 2), 2, '.', '') ?></div>
                                                                </div>
                                                                <div>
                                                                    <i class="mdi mdi-slash-forward text-primary me-1 align-bottom"></i>
                                                                    <div class="badge text-bg-success">S/ <?= number_format(round($rechazados['ImporteCondonar'], 2), 2, '.', '') ?></div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                                <div class="collapse border-top border-top-dashed" id="IDFact<?= $rechazados['IDFacturaCondonacion'] ?>">
                                                    <div class="card-body">
                                                        <h6 class="fs-14 mb-1">Nesta Technologies <small class="badge bg-danger-subtle text-danger">4 Days</small></h6>
                                                        <p class="text-muted">As a company grows however, you find it's not as easy to shout across</p>
                                                        <ul class="list-unstyled vstack gap-2 mb-0">
                                                            <li>
                                                                <div class="d-flex">
                                                                    <div class="flex-shrink-0 avatar-xxs text-muted">
                                                                        <i class="ri-question-answer-line"></i>
                                                                    </div>
                                                                    <div class="flex-grow-1">
                                                                        <h6 class="mb-0">Meeting with Thomas</h6>
                                                                        <small class="text-muted">Yesterday at 9:12AM</small>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="d-flex">
                                                                    <div class="flex-shrink-0 avatar-xxs text-muted">
                                                                        <i class="ri-mac-line"></i>
                                                                    </div>
                                                                    <div class="flex-grow-1">
                                                                        <h6 class="mb-0">Product Demo</h6>
                                                                        <small class="text-muted">Monday at 04:41PM</small>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="d-flex">
                                                                    <div class="flex-shrink-0 avatar-xxs text-muted">
                                                                        <i class="ri-earth-line"></i>
                                                                    </div>
                                                                    <div class="flex-grow-1">
                                                                        <h6 class="mb-0">Marketing Team Meeting</h6>
                                                                        <small class="text-muted">Monday at 04:41PM</small>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                    <div class="card-footer hstack gap-2">
                                                        <button class="btn btn-warning btn-sm w-100"><i class="ri-phone-line align-bottom me-1"></i> Call</button>
                                                        <button class="btn btn-info btn-sm w-100"><i class="ri-question-answer-line align-bottom me-1"></i> Message</button>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php
                                            }
                                        }
                                        else
                                        {
                                        ?>
                                        <div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                            	            <div class="col-xxl-10 col-md-12 col-12 ">
                                    	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                                                    <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRÓ FACTURAS</strong> - No hay facturas rechazadas.
                                                </div>
                                            </div>
                                    	</div>
                                        <?php
                                        }
                                        ?>
                                        <!--end card-->
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col">
                                    <div class="card">
                                        <a class="card-body bg-gris-claro" data-bs-toggle="collapse" href="#needsIdentified" role="button" aria-expanded="true" aria-controls="needsIdentified">
                                            <h5 class="card-title text-uppercase fw-semibold mb-1 fs-15 text-white">Facturas Pendientes</h5>
                                            <p class="text-white mb-0">Total: <span class="fw-medium"><?= $cantidadEstadoFactura['PEND'] ?> Factura(s)</span></p>
                                        </a>
                                    </div>
                                    <!--end card-->
                                    <div class="collapse show" id="needsIdentified" style="">
                                        <?php
                                        if(!empty($facturasPorEstado['PEND']))
                                        {
                                            foreach($facturasPorEstado['PEND'] as $pendientes)
                                            {
                                            ?>
                                            <div class="card mb-1">
                                                <div class="card-body">
                                                    <a class="d-flex align-items-center" data-bs-toggle="collapse" href="#IDFact<?= $pendientes['IDFacturaCondonacion'] ?>" role="button" aria-expanded="false" aria-controls="IDFact<?= $pendientes['IDFacturaCondonacion'] ?>">
                                                        <div class="flex-shrink-0">
                                                            <div class="avatar-md rounded">
                                                                <div class="avatar-title border bg-light text-primary rounded text-uppercase fs-24"><?= $pendientes['TipoFactura'] ?></div>
                                                            </div>
                                                        </div>
                                                        <div class="flex-grow-1 ms-3">
                                                            <!--<div class="my-1">-->
                                                            <!--    <h5 class="fs-16 m-0">Nro Contrato: </h5>-->
                                                            <!--</div>-->
                                                            <p class="text-muted my-1"><?= $pendientes['FacturaExterna'] ?></p>
                                                            <div class="d-flex flex-wrap gap-2 align-items-center my-1">
                                                                <?= $pendientes['FacturaInterna'] ?>
                                                            </div>
                                                            <div class="d-flex gap-4 my-1 text-muted justify-content-start align-content-center">
                                                                <div>
                                                                    <div class="badge text-bg-danger">S/ <?= number_format(round($pendientes['DeudaTotal'], 2), 2, '.', '') ?></div>
                                                                </div>
                                                                <div>
                                                                    <i class="mdi mdi-slash-forward text-primary me-1 align-bottom"></i>
                                                                    <div class="badge text-bg-success">S/ <?= number_format(round($pendientes['ImporteCondonar'], 2), 2, '.', '') ?></div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                                <div class="collapse border-top border-top-dashed show" id="IDFact<?= $pendientes['IDFacturaCondonacion'] ?>">
                                                    <div class="card-body d-flex justify-content-center align-items-center">
                                                        <?php
                                                        foreach($aprobadoresPorFactura[$pendientes['IDFacturaCondonacion']] as $aprobador)
                                                        {
                                                        ?>
                                                        <div class="col-xl-6 col-lg-6">
                                                            <div class="card ribbon-box right overflow-hidden mx-2">
                                                                <div class="card-body text-center p-2">
                                                                    <div class="flex-shrink-0 d-flex align-items-center justify-content-center">
                                                                        <div class="avatar-sm rounded">
                                                                            <div class="avatar-title border bg-light text-primary rounded text-uppercase fs-24"><span class="mdi mdi-account"></span></div>
                                                                        </div>
                                                                    </div>
                                                                    <h5 class="mb-1 mt-4"><?= ucwords(mb_strtolower($aprobador['Nombres'].' '.$aprobador['Apellidos'])) ?></h5>
                                                                    <p class="text-muted mb-4"><?= $aprobador['Cargo'] ?></p>
                                                                    <div class="row mt-4">
                                                                        <div class="col-lg-6 border-end-dashed border-end">
                                                                            <button class="badge bg-success border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Aprobar Condonación">
                                                                                <i class="mdi mdi-check-circle align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                                                            </button>
                                                                        </div>
                                                                        <div class="col-lg-6">
                                                                            <button class="badge bg-danger border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Rechazar Condonación">
                                                                                <i class="mdi mdi-close-circle align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                                                            </button>
                                                                        </div>
                                                                    </div>
                                                                    <!--<div class="mt-4">-->
                                                                    <!--    <a href="apps-ecommerce-seller-details.html" class="btn btn-light w-100">View Details</a>-->
                                                                    <!--</div>-->
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <?php
                                                        }
                                                        ?>
                                                    </div>
                                                    <div class="card-footer hstack gap-2">
                                                        <button class="btn bg-warning btn-sm w-100 text-white"><i class="mdi mdi-pencil-outline align-bottom me-1"></i> Editar</button>
                                                        <button class="btn bg-dark btn-sm w-100 text-white"><i class="mdi mdi-cancel align-bottom me-1"></i> Cancelar</button>
                                                        <button class="btn bg-rosa btn-sm w-100 text-white"><i class="mdi mdi-message-reply align-bottom me-1"></i> Comentarios</button>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php
                                            }
                                        }
                                        else
                                        {
                                        ?>
                                        <div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                            	            <div class="col-xxl-10 col-md-12 col-12 ">
                                    	        <div class="alert alert-light alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                                                    <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRÓ FACTURAS</strong> - No hay facturas pendientes.
                                                </div>
                                            </div>
                                    	</div>
                                        <?php
                                        }
                                        ?>
                                        <!--end card-->
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col">
                                    <div class="card">
                                        <a class="card-body bg-success" data-bs-toggle="collapse" href="#contactInitiated" role="button" aria-expanded="true" aria-controls="contactInitiated">
                                            <h5 class="card-title text-uppercase fw-semibold mb-1 fs-15 text-white">Facturas Aprobadas</h5>
                                            <p class="text-white mb-0">Total: <span class="fw-medium"><?= $cantidadEstadoFactura['APRO'] ?> Factura(s)</span></p>
                                        </a>
                                    </div>
                                    <!--end card-->
                                    <div class="collapse" id="contactInitiated" style="">
                                        <?php
                                        if(!empty($facturasPorEstado['APRO']))
                                        {
                                            foreach($facturasPorEstado['APRO'] as $aprobados)
                                            {
                                            ?>
                                            <div class="card mb-1">
                                                <div class="card-body">
                                                    <a class="d-flex align-items-center" data-bs-toggle="collapse" href="#IDFact<?= $aprobados['IDFacturaCondonacion'] ?>" role="button" aria-expanded="false" aria-controls="IDFact<?= $aprobados['IDFacturaCondonacion'] ?>">
                                                        <div class="flex-shrink-0">
                                                            <div class="avatar-md rounded">
                                                                <div class="avatar-title border bg-light text-primary rounded text-uppercase fs-24"><?= $aprobados['TipoFactura'] ?></div>
                                                            </div>
                                                        </div>
                                                        <div class="flex-grow-1 ms-3">
                                                            <!--<div class="my-1">-->
                                                            <!--    <h5 class="fs-16 m-0">Nro Contrato: </h5>-->
                                                            <!--</div>-->
                                                            <p class="text-muted my-1"><?= $aprobados['FacturaExterna'] ?></p>
                                                            <div class="d-flex flex-wrap gap-2 align-items-center my-1">
                                                                <?= $aprobados['FacturaInterna'] ?>
                                                            </div>
                                                            <div class="d-flex gap-4 my-1 text-muted justify-content-start align-content-center">
                                                                <div>
                                                                    <div class="badge text-bg-danger">S/ <?= number_format(round($aprobados['DeudaTotal'], 2), 2, '.', '') ?></div>
                                                                </div>
                                                                <div>
                                                                    <i class="mdi mdi-slash-forward text-primary me-1 align-bottom"></i>
                                                                    <div class="badge text-bg-success">S/ <?= number_format(round($aprobados['ImporteCondonar'], 2), 2, '.', '') ?></div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                                <div class="collapse border-top border-top-dashed" id="IDFact<?= $aprobados['IDFacturaCondonacion'] ?>">
                                                    <div class="card-body">
                                                        <h6 class="fs-14 mb-1">Nesta Technologies <small class="badge bg-danger-subtle text-danger">4 Days</small></h6>
                                                        <p class="text-muted">As a company grows however, you find it's not as easy to shout across</p>
                                                        <ul class="list-unstyled vstack gap-2 mb-0">
                                                            <li>
                                                                <div class="d-flex">
                                                                    <div class="flex-shrink-0 avatar-xxs text-muted">
                                                                        <i class="ri-question-answer-line"></i>
                                                                    </div>
                                                                    <div class="flex-grow-1">
                                                                        <h6 class="mb-0">Meeting with Thomas</h6>
                                                                        <small class="text-muted">Yesterday at 9:12AM</small>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="d-flex">
                                                                    <div class="flex-shrink-0 avatar-xxs text-muted">
                                                                        <i class="ri-mac-line"></i>
                                                                    </div>
                                                                    <div class="flex-grow-1">
                                                                        <h6 class="mb-0">Product Demo</h6>
                                                                        <small class="text-muted">Monday at 04:41PM</small>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="d-flex">
                                                                    <div class="flex-shrink-0 avatar-xxs text-muted">
                                                                        <i class="ri-earth-line"></i>
                                                                    </div>
                                                                    <div class="flex-grow-1">
                                                                        <h6 class="mb-0">Marketing Team Meeting</h6>
                                                                        <small class="text-muted">Monday at 04:41PM</small>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                    <div class="card-footer hstack gap-2">
                                                        <button class="btn btn-warning btn-sm w-100"><i class="ri-phone-line align-bottom me-1"></i> Call</button>
                                                        <button class="btn btn-info btn-sm w-100"><i class="ri-question-answer-line align-bottom me-1"></i> Message</button>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php
                                            }
                                        }
                                        else
                                        {
                                        ?>
                                        <div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                            	            <div class="col-xxl-10 col-md-12 col-12 ">
                                    	        <div class="alert alert-success alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                                                    <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRÓ FACTURAS</strong> - No hay facturas aprobadas.
                                                </div>
                                            </div>
                                    	</div>
                                        <?php
                                        }
                                        ?>
                                        <!--end card-->
                                    </div>
                                </div>
                                <!--end col-->
        
                            </div>
                        </div>
                        <div class="tab-pane fade" id="condonacion-facturas-gestor" role="tabpanel">
                            
                        </div>
                        <div class="tab-pane fade" id="condonacion-aprobaciones" role="tabpanel">
                            <div class="row">
                                <div class="col-xl-3 col-lg-4">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="d-flex">
                                                <h5 class="card-title flex-grow-1 mb-0"><i class="mdi mdi-cash align-middle me-1 text-muted"></i> Detalle de Condonación</h5>
                                                <div class="flex-shrink-0">
                                                    <a href="javascript:void(0);" class="badge bg-primary-subtle text-primary fs-11"># <?= $condonacion['IDCondonacion'] ?></a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <div class="my-2 text-center">
                                                <lord-icon src="https://cdn.lordicon.com/ysqeagpz.json" trigger="loop" colors="primary:#405189,secondary:#0ab39c" style="width:80px;height:80px"></lord-icon>
                                                <h5 class="fs-16 mt-2"><?= ucwords(mb_strtolower($condonacion['Nombres'].' '.$condonacion['Apellidos'])) ?></h5>
                                                <p class="text-muted mb-0"><?= ucwords(mb_strtolower($condonacion['Requerimiento']))." | ".ucwords(mb_strtolower($condonacion['MotivoRequerimiento'])) ?></p>
                                                <p class="text-muted mb-0"><?= date("d-m-Y H:i:s", strtotime($condonacion['FechaCrea'])) ?></p>
                                            </div>
                                            <div class="my-2">
                                                <h6 class="text-muted text-uppercase fw-semibold">Observación</h6>
                                                <p class="text-muted"><?= $condonacion['Observacion'] ?></p>
                                            </div>
                                        </div>
                                        
                                        <div class="card-header" style="border-top: 1px solid var(--vz-border-color);">
                                            <div class="d-flex">
                                                <h6 class="card-title flex-grow-1 d-flex align-items-center mb-0"><i class="mdi mdi-currency-usd me-1 text-muted"></i> Acumulados</h6>
                                                <div class="flex-shrink-0">
                                                    <button type="button" class="btn bg-sistema px-2 py-1" data-tooltip="tooltip" title="Actualizar Acumulados" onclick="return mostrarAcumuladosAprobaciones('<?= $condonacion['IDCondonacion'] ?>')">
                                                        <i class="mdi mdi-refresh" style="font-size: 18px; color: #FFF"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body" id="ctnAcumuladosAprobaciones">
                                            <div class="table-responsive table-card">
                                                <table class="table table-borderless mb-0">
                                                    <tbody>
                                                        <tr>
                                                            <td class="fw-medium" scope="row">Industry Type</td>
                                                            <td>Chemical Industries</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium" scope="row">Location</td>
                                                            <td>Damascus, Syria</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium" scope="row">Employee</td>
                                                            <td>10-50</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium" scope="row">Rating</td>
                                                            <td>4.0 <i class="ri-star-fill text-warning align-bottom"></i></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium" scope="row">Website</td>
                                                            <td>
                                                                <a href="javascript:void(0);" class="link-primary text-decoration-underline">www.syntycesolution.com</a>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium" scope="row">Contact Email</td>
                                                            <td>info@syntycesolution.com</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium" scope="row">Since</td>
                                                            <td>1995</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- end card -->
                                </div>
                                <!-- end col -->
                                <div class="col-xl-9 col-lg-8">
                                   <div class="col-lg-12">
                                        <div class="card" id="orderList">
                                            <div class="card-header border-0">
                                                <div class="row align-items-center gy-3">
                                                    <div class="col-sm">
                                                        <h5 class="card-title mb-0">Facturas Pendientes por Aprobar</h5>
                                                    </div>
                                                    <div class="col-sm-auto">
                                                        <div class="d-flex gap-1 flex-wrap">
                                                            <a class="btn bg-success color-white px-2 mx-1 d-flex justify-content-center align-items-center" style="font-size: 16px;">
                                                                <label for="chkAprobarFacturaCondonacionTotal" class="m-0 color-white mx-1 cursor-pointer">
                                                                    Aprobar Todo
                                                                </label>
                                                                <center class="content-center ms-2" style="position: relative; height: 40px">
                                                                    <input type="checkbox" id="chkAprobarFacturaCondonacionTotal" class="chk-basico chk-aprobar">
                                                                    <label for="chkAprobarFacturaCondonacionTotal"></label>
                                                    			</center>
                                                            </a>
                                                            <a class="btn bg-danger color-white px-2 mx-1 d-flex justify-content-center align-items-center" style="font-size: 16px;">
                                                                <label for="chkRechazarFacturaCondonacionTotal" class="m-0 color-white mx-1 cursor-pointer">
                                                                    Rechazar Todo
                                                                </label>
                                                                <center class="content-center ms-2" style="position: relative; height: 40px">
                                                                    <input type="checkbox" id="chkRechazarFacturaCondonacionTotal" class="chk-basico chk-rechazar">
                                                                    <label for="chkRechazarFacturaCondonacionTotal"></label>
                                                    			</center>
                                                            </a>
                                                            <button type="button" class="btn bg-sistema color-white p-2 px-3 mx-1" data-condonacion="<?= $condonacion['IDCondonacion'] ?>" id="btnGuardarStatusMasivoFactura">
                                                                <i class="mdi mdi-content-save" style="font-size: 22px;"></i>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body pt-0">
                                                <form id="formFacturasPendientesAprobar">
                                                    <table id="tblFacturasPendientesAprobarCondonacion" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
                                        			    <thead>
                                                            <tr>
                                                                <th class="">Nro Contrato</th>
                                                                <th class="">Factura Interna</th>
                                                                <th class="">Factura Externa</th>
                                                                <th class="">Segmento</th>
                                                                <th class="">Tipo de Factura</th>
                                                                <th class="">Deuda Total</th>
                                                                <th class="">Importe a Condonar</th>
                                                                <th class="">Aprobar | Rechazar</th>
                                                                <th class="">Observación</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                        </tbody>
                                                    </table>
                                                </form>
                                            </div>
                                        </div>
            
                                    </div>
                                </div>
                                <!-- end col -->
                            </div>
                        </div>
                        <!-- end tab pane -->
                        <div class="tab-pane fade d-flex justify-content-center" id="condonacion-bitacora" role="tabpanel">
                            
                        </div>
                        <!-- end tab pane -->
                    </div>
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->
        </div>
        <!-- container-fluid -->
		<span class="respuesta_global"></span>
    </div>
    <!-- End Page-content -->

    <footer class="footer">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-6">
                    <script>document.write(new Date().getFullYear())</script> © Verisure Peru.
                </div>
                <div class="col-sm-6">
                    <div class="text-sm-end d-none d-sm-block">Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
    $(function () {
        // $('#tblFacturasPendientesAprobarCondonacion').DataTable();
        mostrarAprobadoresGeneral('<?= $condonacion['IDCondonacion'] ?>');
        mostrarComentariosGeneralCondonacion('<?= $condonacion['IDCondonacion'] ?>');
    });
function recargarGeneralCondonacion(btnGeneral)
{
    let idCondonacion = $(btnGeneral).data("condonacion");
    
    mostrarAprobadoresGeneral(idCondonacion);
    mostrarComentariosGeneralCondonacion(idCondonacion);
}

        function mostrarAprobadoresGeneral(idCondonacion)
        {
            var parametros = {
                "idCondonacion"  : idCondonacion
        	};
            
            $.ajax({        
                url: baseUrl + '/mostrar-aprobadores-general',
                type: 'POST',
                data: parametros,
                beforeSend: function() 
                {
                    $('#ctnAprobadoresGeneral').html('<div class="d-flex justify-content-center align-items-center"><div class="spinner-border text-primary" role="status" style="width: 3rem; height: 3rem;"><span class="visually-hidden">Loading...</span></div></div>');
                },
                success: function(response) 
                {
                    $('#ctnAprobadoresGeneral').empty();
                    $('#ctnAprobadoresGeneral').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
            
        }

$(document).on('click', '.ver-facturas-aprobador', function() 
{
    var modal           = $(this).data('bs-target');
    var idCondonacion   = $(this).data('condonacion');
    var idUsuario       = $(this).data('usuario');
    
    var parametros = {
        "idCondonacion" : idCondonacion,
        "idUsuario"     : idUsuario
	};
    
    $.ajax({        
        url: baseUrl + '/mostrar-facturas-aprobador',
        type: 'POST',
        data: parametros,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            $('#ctnListadoFacturasAprobador').html(response);
            reinicializarSimpleBar();
            $(modal).modal("show");
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    
});


$(document).on('click', '#btnSolicitarPeticionCondonacion', function() 
{
    let idCondonacion   = $(this).data("condonacion");
    
    let formData = new FormData();
    
    Swal.fire({
        title: "Solicitar Petición de Condonación",
        html: "¿Estas seguro de solicitar la condonación de las facturas aprobadas a Medios de Pago?<br>El proceso continuará en el módulo 'Peticiones'.<br>Si ingresa alguna observación, se agregará a la observación inicial registrada a la solicitud.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#008F39',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // // Si el valor es válido, debes regresar undefined. Si no, una cadena
            // if (!obs) {
            //     return "Por favor escribe alguna observación";
            // } else {
            //     return undefined;
            // }
        }
    }).then((result) => {
        if (result.isConfirmed) {

            var motivo = result.value;
            
    		formData.append('txtIDCondonacion', idCondonacion);
    		formData.append('txtObservacionPeticion', motivo);
    		
            $.ajax({
                url: baseUrl + '/registrar-peticion-condonacion',
                type: "POST",
                data: formData,
                processData: false, // Importante para enviar FormData
                contentType: false, // Importante para enviar FormData
                dataType: 'json',
                beforeSend: function() 
                {
                    Swal.fire({
                        html: 'Un momento por favor...',
                        heightAuto: true,
                        showConfirmButton: false
                    });
                },
                success: function(response) 
                {
                    Swal.close();
                    console.log(response);
                    $('.respuesta_global').html(response.mensaje);
                    
                    // if(response.result == 1)
                    // {
                    //     recargarFacturasCondonacion(idCondonacion);
                    // }
                }, 
                error: function(jqXHR, textStatus, errorThrown)
                {
                    Swal.close();
            
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });
    
});

$(document).on('click', '.visualizar-informacion-factura-aprobador', function() 
{
    // Guardar clase original
    var originalClass = $(this).data('bg-original');
    var selectedClass = originalClass.replace('-25', '');

    // Des-seleccionar todas las tarjetas
    $('.visualizar-informacion-factura-aprobador').each(function () {
        var $card = $(this);
        var origClass = $card.data('bg-original');
        var selClass = origClass.replace('-25', '');
        $card.removeClass(selClass).addClass(origClass);
    });

    // Seleccionar solo la tarjeta clickeada
    $(this).removeClass(originalClass).addClass(selectedClass);
    
    var idAprobacion   = $(this).data('aprobacion');
    
    var parametros = {
        "idAprobacion" : idAprobacion
	};
    
    $.ajax({        
        url: baseUrl + '/visualizar-informacion-factura-aprobador',
        type: 'POST',
        data: parametros,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            $('#ctnAccionesFacturaAprobador').html(response);
            reinicializarSimpleBar();
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    
});

function enviarAvisoFacturasPendientesAprobar(btnCorreo)
{
    let idCondonacion = $(btnCorreo).data('condonacion');
    let idUsuarioAprobador = $(btnCorreo).data('aprobador');
    
    var parametros = {
        "idCondonacion"  : idCondonacion,
        "idUsuarioAprobador" : idUsuarioAprobador
    };
    $.ajax({        
        url: baseUrl + '/enviar-correo-facturas-pendientes-aprobador-condonacion',
        type: "POST",
        data: parametros,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false,
                didOpen: () => {
                    // Abrir la ventana emergente y no permitir cerrar mientras se procesa
                    Swal.showLoading();
                }
            });
        },
        success: function(response) 
        {
            Swal.close();
            $('.respuesta_global').html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown)
        {
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
}

function mostrarComentariosGeneralCondonacion(idCondonacion)
{
    var parametros = {
        "idCondonacion"  : idCondonacion
	};
    
    $.ajax({        
        url: baseUrl + '/comentarios-condonacion',
        type: 'POST',
        data: parametros,
        beforeSend: function() 
        {
            $('#ctnComentariosGeneralCondonacion').html('<div class="d-flex justify-content-center align-items-center"><div class="spinner-border text-primary" role="status" style="width: 3rem; height: 3rem;"><span class="visually-hidden">Loading...</span></div></div>');
        },
        success: function(response) {
            Swal.close();
            
            let cont = $('#ctnComentariosGeneralCondonacion');
            
            cont.empty();
            cont.html(response);
            
            if (cont[0].SimpleBar) {
                cont[0].SimpleBar.recalculate();
            } else {
                new SimpleBar(cont[0]);
            }
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
}

$(document).on('submit', '.formularioRegistrarComentarioCondonacion', function() 
{
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var contenedor = $(this).data("contenedor");
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData: false,
        dataType: 'json',
        beforeSend: function() 
        {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
                    
            $('.respuesta_global').html(response.mensaje);
            
            if(response.result == 1)
            {
                mostrarComentariosGeneralCondonacion(formulario.find('#txtIDCondonacion_rcomcond').val());
                // $("#txtComentariosFactura_rcomaprcond").val("");
                formulario.find('textarea').val('');
            }
        }, 
        error: function(jqXHR, textStatus, errorThrown)
        {
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

function mostrarAcumuladosAprobaciones(idCondonacion)
{
    var parametros = {
        "idCondonacion"  : idCondonacion
	};
    
    $.ajax({        
        url: baseUrl + '/acumulados-factura-condonacion',
        type: 'POST',
        data: parametros,
        beforeSend: function() 
        {
            $('#ctnAcumuladosAprobaciones').html('<div class="d-flex justify-content-center align-items-center"><div class="spinner-border text-primary" role="status" style="width: 3rem; height: 3rem;"><span class="visually-hidden">Loading...</span></div></div>');
        },
        success: function(response) {
            Swal.close();
            $('#ctnAcumuladosAprobaciones').empty();
            $('#ctnAcumuladosAprobaciones').html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
}

$(document).on('click', '.cambiar-aprobador-factura-condonacion', function() 
{
    var modal           = $(this).data('bs-target');
    var idCondonacion   = $(this).data('condonacion');
    var idAprobacion    = $(this).data('aprobacion');
    
    var parametros = {
        "idCondonacion" : idCondonacion,
        "idAprobacion"  : idAprobacion
	};
    
    $.ajax({        
        url: baseUrl + '/obtener-informacion-aprobador-factura-condonacion',
        type: 'POST',
        data: parametros,
        dataType: 'json',
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                Swal.close();
                console.log(response);
                $("#txtIDAprobacion_cafc").val(response.idaprobacion);
                $("#txtFacturaInterna_cafc").val(response.facturainterna);
                $("#txtFacturaExterna_cafc").val(response.facturaexterna);
                
                // selectUsuarios("cboAprobadorActual_cafc", response.idusuarioaprobacion, modal.substring(1));
                
                if(response.origen == "DIRECCION")
                {
                    selectResponsablesDireccion("cboAprobadorActual_cafc", response.idorigen, response.idusuarioaprobacion, response.matriculaaprobador+" | "+response.nombreaprobador+" "+response.apellidoaprobador, modal.substring(1));
                    selectResponsablesDireccion("cboNuevoAprobador_cafc", response.idorigen, response.idusuarioaprobacion, response.matriculaaprobador+" | "+response.nombreaprobador+" "+response.apellidoaprobador, modal.substring(1));
                }
                else
                {
                    selectResponsablesArea("cboAprobadorActual_cafc", response.idorigen, response.idusuarioaprobacion, response.matriculaaprobador+" | "+response.nombreaprobador+" "+response.apellidoaprobador, modal.substring(1));
                    selectResponsablesArea("cboNuevoAprobador_cafc", response.idorigen, response.idusuarioaprobacion, response.matriculaaprobador+" | "+response.nombreaprobador+" "+response.apellidoaprobador, modal.substring(1));
                    
                }
                
                // selectUsuarios("cboNuevoAprobador_cafc", "", modal.substring(1));
                
                // $('#ctnListadoFacturasAprobador').html(response);
                // reinicializarSimpleBar();
                $(modal).modal("show");
            }
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    
});

</script>
<?php $this->endSection(); ?>

<!-- Modal Aprobación Masiva Facturas Condonación -->
<div class="modal fade zoomIn" id="aprobacionMasivaCondonacion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleaprobacionMasivaCondonacion">
	<div class="modal-dialog modal-dialog-centered modal-fullscreen" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleaprobacionMasivaCondonacion">Aprobación Masiva</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formAprobacionMasivaFacturasCondonacion" class="formulario" autocomplete="off" action="<?= $baseUrl ?>/aprobacion-masiva-condonacion" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body" id="ctnAprobacionMasiva">
				    
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-import mx-1" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Información Factura Condonación -->
<div class="modal fade zoomIn" id="mdlFacturaCondonacion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlFacturaCondonacion">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlFacturaCondonacion">Información de Factura</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formFacturaCondonacion" class="formularioFacturaCondonacion" autocomplete="off" action="" data-condonacion="<?= $condonacion['IDCondonacion'] ?>" data-modal="#mdlFacturaCondonacion" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
				    <div class="row col-12 m-0 p-0 mb-3 d-flex">
						<div class="col-xxl-12 col-md-12 col-12 px-3 mb-3 ">
							<div>
								<label for="txtNroContrato_ifcond" class="form-label">Nro Contrato</label>
								<input type="text" class="form-control" id="txtNroContrato_ifcond" disabled>
							</div>
						</div>
						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
							<div>
								<label for="txtFacturaInterna_ifcond" class="form-label">Factura Interna</label>
								<input type="text" class="form-control" id="txtFacturaInterna_ifcond" disabled>
							</div>
						</div>
						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
							<div>
								<label for="txtFacturaExterna_ifcond" class="form-label">Factura Externa</label>
								<input type="text" class="form-control" id="txtFacturaExterna_ifcond" disabled>
							</div>
						</div>
						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
						    <div>
								<label for="txtTipoFactura_ifcond" class="form-label">Tipo de Factura</label>
								<select class="form-select" aria-label="Tipo de Factura" id="txtTipoFactura_ifcond" data-modal="#mdlFacturaCondonacion" disabled>
									<option value="" selected="">Seleccione una opción</option>
									<option value="ND">ND</option>
									<option value="O">O</option>
									<option value="C">C</option>
									<option value="OT">OT</option>
									<option value="OI">OI</option>
								</select>
							</div>
						</div>
						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
						    <div>
								<label for="txtSegmento_ifcond" class="form-label">Segmento</label>
								<select class="form-select" aria-label="Segmento" id="txtSegmento_ifcond" data-modal="#mdlFacturaCondonacion" disabled>
									<option value="" selected="">Seleccione una opción</option>
									<option value="HBFEPE">HBFEPE</option>
									<option value="HBFDPE">HBFDPE</option>
								</select>
							</div>
						</div>
						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
						    <div>
    							<label for="txtDeudaTotal_ifcond" class="form-label">Deuda Total Factura</label>
                                <div class="input-group">
                                    <span class="input-group-text">S/.</span>
                                    <input type="text" step="0.01" class="form-control evaluar-moneda-decimal" aria-label="Deuda Total" id="txtDeudaTotal_ifcond" placeholder="Deuda Total" pattern="^\d+(\.\d+)?$"  title="Solo números y un punto decimal" disabled>
                                </div>
                            </div>
                        </div>
						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
						    <div>
    							<label for="txtImporte_ifcond" class="form-label">Importe Condonar</label>
                                <div class="input-group">
                                    <span class="input-group-text">S/.</span>
                                    <input type="text" step="0.01" class="form-control evaluar-moneda-decimal" aria-label="Importe" id="txtImporte_ifcond" name="txtImporte_ifcond" placeholder="Importe" pattern="^\d+(\.\d+)?$"  title="Solo números y un punto decimal">
                                </div>
                            </div>
                        </div>
				    </div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" id="btnEjecutarFacturaCondonacion" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-import mx-1" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Comentarios Aprobación Factura Condonación -->
<div class="modal fade zoomIn" id="mdlComentariosAprobacionCondonacion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlComentariosAprobacionCondonacion">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlComentariosAprobacionCondonacion">Comentarios de Aprobador</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
			    <form id="formRegistrarComentarioAprobacionCondonacion" class="formularioRegistrarComentarioAprobacionCondonacion comentario" autocomplete="off" action="<?= $baseUrl ?>/registrar-comentario-aprobador-condonacion" method="POST" data-contenedor="ctnComentariosAprobacionFactura">
			        <div class="row col-12 m-0 p-0 d-flex">
			            <div class="panel">
                            <div class="panel-heading">
                                <h4>Registrar Comentario</h4>
                            </div>
                            <div class="panel-content">
                                <div class="row">
                                    <div class="col-10">
                                        <input type="hidden" id="txtIDCondonacion_rcomaprcond" name="txtIDCondonacion_rcomaprcond" value="<?= $condonacion['IDCondonacion'] ?>">
                                        <input type="hidden" id="txtIDFacturaCondonacion_rcomaprcond" name="txtIDFacturaCondonacion_rcomaprcond" value="">
                                        <input type="hidden" id="txtIDAprobacionCondonacion_rcomaprcond" name="txtIDAprobacionCondonacion_rcomaprcond" value="">
            							<textarea class="form-control" id="txtComentariosFactura_rcomaprcond" name="txtComentariosFactura_rcomaprcond" rows="4" placeholder="Comentarios...."></textarea>
            						</div>
            						<div class="col-2 d-flex justify-content-center align-items-center">
            						    <button type="submit" class="btn bg-sistema color-white p-2 px-3 mx-1">
                                            <i class="mdi mdi-content-save" style="font-size: 22px;"></i>
                                        </button>
            						</div>
                                </div>
                            </div>
                        </div>
				    </div>
			    </form>
			    <hr>
			    <div class="col-12 " id="ctnComentariosAprobacionFactura">
			        
			    </div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
			</div>
		</div>
	</div>
</div>

<!-- Modal Comentarios Factura Condonación -->
<div class="modal fade zoomIn" id="mdlComentariosFacturaCondonacion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlComentariosFacturaCondonacion">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlComentariosFacturaCondonacion">Comentarios en Factura</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
			    <form id="formRegistrarComentarioFacturaCondonacion" class="formularioRegistrarComentarioFacturaCondonacion comentario" autocomplete="off" action="<?= $baseUrl ?>/registrar-comentario-factura-condonacion" method="POST">
			        <div class="row col-12 m-0 p-0 d-flex">
			            <div class="panel">
                            <div class="panel-heading">
                                <h4>Registrar Comentario</h4>
                            </div>
                            <div class="panel-content">
                                <div class="row">
                                    <div class="col-10">
                                        <input type="hidden" id="txtIDCondonacion_rcomfaccond" name="txtIDCondonacion_rcomfaccond" value="<?= $condonacion['IDCondonacion'] ?>">
                                        <input type="hidden" id="txtIDFacturaCondonacion_rcomfaccond" name="txtIDFacturaCondonacion_rcomfaccond" value="">
            							<textarea class="form-control" id="txtComentariosFactura_rcomfaccond" name="txtComentariosFactura_rcomfaccond" rows="4" placeholder="Comentarios...."></textarea>
            						</div>
            						<div class="col-2 d-flex justify-content-center align-items-center">
            						    <button type="submit" class="btn bg-sistema color-white p-2 px-3 mx-1">
                                            <i class="mdi mdi-content-save" style="font-size: 22px;"></i>
                                        </button>
            						</div>
                                </div>
                            </div>
                        </div>
				    </div>
			    </form>
			    <hr>
			    <div class="col-12 " id="ctnComentariosFactura">
			        
			        
			    </div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
			</div>
		</div>
	</div>
</div>

<!-- Modal Facturas Usuario Aprobador Condonación -->
<div class="modal fade zoomIn" id="mdlFacturasAprobador" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlFacturasAprobador">
	<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlFacturasAprobador">Listado de Facturas por Aprobador</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body p-0" id="ctnListadoFacturasAprobador" style="overflow: hidden;">
			    
			</div>
		</div>
	</div>
</div>

<!-- Modal Cambiar Aprobador Factura Condonación -->
<div class="modal fade zoomIn" id="mdlCambiarAprobadorFacturaCondonacion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlCambiarAprobadorFacturaCondonacion">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlCambiarAprobadorFacturaCondonacion">Cambiar Aprobador</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formCambiarAprobadorFacturaCondonacion" class="formulario" autocomplete="off" action="<?= $baseUrl ?>/actualizar-aprobador-factura-condonacion" method="POST" accept-charset="utf-8">
			    <div class="modal-body">
			        <span class="respuesta"></span>
			        <input type="hidden" id="txtIDAprobacion_cafc" name="txtIDAprobacion_cafc">
    			    <h3 class="mb-3">Factura</h3>
    			    <div class="row m-0 mb-3">
    					<div class="col-12 col-lg-6">
    						<div class="form-group">
    							<label for="concepto_roc">Factura Interna</label>
    							<input type="text" class="form-control" id="txtFacturaInterna_cafc" placeholder="Concepto" disabled>
    						</div>
    					</div>
    					<div class="col-12 col-lg-6">
    						<div class="form-group">
    							<label for="proveedor_roc">Factura Externa</label>
    							<input type="text" class="form-control" id="txtFacturaExterna_cafc" placeholder="Proveedor" disabled>
    						</div>
    					</div>
    				</div>
    				<hr>
    				<h3 class="mb-3">Aprobador</h3>
    			    <div class="row m-0 mb-3">
    					<div class="col-12 col-lg-6">
    						<label>Aprobador actual</label>
							<select class="form-select" id="cboAprobadorActual_cafc" data-modal="mdlCambiarAprobadorFacturaCondonacion" disabled>
							</select>
    					</div>
    					<div class="col-12 col-lg-6">
    						<label for="cboNuevoAprobador_cafc">Nuevo Aprobador</label>
							<select class="form-select" id="cboNuevoAprobador_cafc" name="cboNuevoAprobador_cafc" data-modal="mdlCambiarAprobadorFacturaCondonacion">
							</select>
    					</div>
    				</div>
    			</div>
    			<div class="modal-footer justify-content-end">
    				<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
    				<button type="submit" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i> Guardar</button>
    			</div>
    		</form>
		</div>
	</div>
</div>

<?php $this->endSection(); ?>